/*
 * gpio.c
 *
 *  Created on: Feb 23, 2016
 *      Author: B55457
 */


#include "gpio.h"

/********************************************************************************************
*
* @brief    initGPIO - Init LEDs and Buttons
* @param    none
* @return   none
*
*********************************************************************************************/
void initGPIO(void)
{
	/* LEDS on Miriac(TM)-EK5744 */
	/* Enable DOUTn LEDs. PWENA/B effectively act as NAND gate to power DOUT0 */
	SIUL2.MSCR[PC10].B.OBE = 1;	//PWENA
	SIUL2.MSCR[PC13].B.OBE = 1; //PWENB
	SIUL2.MSCR[PD10].B.OBE = 1; /* Pad PD10 - DOUT0 LED. */
	SIUL2.MSCR[PH8].B.OBE = 1;  /* Pad PH8 - DOUT1 LED */
	SIUL2.MSCR[PA12].B.OBE = 1; /* Pad PA12 - DOUT2 LED */
	SIUL2.MSCR[PA14].B.OBE = 1; /* Pad PA14 - DOUT3 LED */

	SIUL2.GPDO[PC10].R = 0;
	SIUL2.GPDO[PC13].R = 0;
	SIUL2.GPDO[PD10].R = 0; 	//Turn off DOUT0 LED
	SIUL2.GPDO[PH8].R = 0;		//Turn off DOUT1 LED
	SIUL2.GPDO[PA12].R = 0;		//Turn off DOUT2 LED
	SIUL2.GPDO[PA14].R = 0;		//TUrn off DOUT3 LED

}

void GPIO_toggle(uint16_t GPIO, uint32_t TOGGLES, uint32_t DELAY)
{
  uint32_t i, j;

  SIUL2.MSCR[GPIO].B.OBE   = 1;
  for(i=0;i<TOGGLES*2;i++)
  {
   for(j=0;j<DELAY;j++);
   SIUL2.GPDO[GPIO].R ^= 1;
  }
}

void DebounceDelay(void)
{
    vuint32_t DelayCounter;
    for (DelayCounter=0; DelayCounter<DEBOUNCEDELAYTIME; DelayCounter++){};
}

void DebouncedWaitTilLow(uint16_t GPIO)
{
    /* enable GPIO as input */
    SIUL2.MSCR[GPIO].B.IBE  = 1;
    /* debounce */
    while(!SIUL2.GPDI[GPIO].R)  {};   /* wait here until level is high, if not already */
    do
    {
      while(SIUL2.GPDI[GPIO].R) {};   /* wait for falling edge */
      DebounceDelay();
    }while(SIUL2.GPDI[GPIO].R);       /* repeat loop, if after debounce delay high */
}

void DebouncedWaitTilHigh(uint16_t GPIO)
{
    /* enable GPIO as input */
    SIUL2.MSCR[GPIO].B.IBE  = 1;
    /* debounce */
    while(SIUL2.GPDI[GPIO].R)  {};   /* wait here until level is low, if not already */
    do
    {
      while(!SIUL2.GPDI[GPIO].R) {};   /* wait for rising edge */
      DebounceDelay();
    }while(!SIUL2.GPDI[GPIO].R);       /* repeat loop, if after debounce delay low */

}

 void clock_out_FMPLL()
 {
   /* Set Up clock selectors to allow clock out 0 to be viewed */
   MC_CGM.AC6_SC.B.SELCTL = 2;           /* Select PLL0 (PLL0-sysclk0) */
   MC_CGM.AC6_DC0.B.DE    = 1;           /* Enable AC6 divider 0 (SYSCLK0)*/
   MC_CGM.AC6_DC0.B.DIV   = 9;           /* Divide by 10 */

   /* Configure Pin for Clock out 0 on PG7 */
   //SIUL2.MSCR[PG7].R = 0x02000003;       /* SRC=2 (Full drive w/o slew) SSS=3 (CLKOUT_0)*/
   SIUL2.MSCR[PB6].R = 0x02000001; /* PB6 = 22 */
 }

  void clock_out_FIRC()
 {
   /* Set Up clock selectors to allow clock out 0 to be viewed */
   MC_CGM.AC6_SC.B.SELCTL = 1;            /* Select FIRC */
   MC_CGM.AC6_DC0.B.DE    = 1;            /* Enable AC6 divider 0 */
   MC_CGM.AC6_DC0.B.DIV   = 9;            /* Divide by 10 */

   /* Configure Pin for Clock out 0 on PG7 */
   //SIUL2.MSCR[PG7].R = 0x02000003;        /* PG7 = 103 */
   SIUL2.MSCR[PB6].R = 0x02000001; /* PB6 = 22 */
 }
