/* main.c - Hello World example for MPC5744P */
/* Description:  Measures eTimer pulse/period measurement */
/* Rev 1.0 Oct 24 2017 D Chung - production version */
/* Copyright NXP Semiconductor, Inc 2016 All rights reserved. */

/*******************************************************************************
* NXP Semiconductor Inc.
* (c) Copyright 2016 NXP Semiconductor, Inc.
* ALL RIGHTS RESERVED.
********************************************************************************
Services performed by NXP in this matter are performed AS IS and without
any warranty. CUSTOMER retains the final decision relative to the total design
and functionality of the end product. NXP neither guarantees nor will be
held liable by CUSTOMER for the success of this project.
NXP DISCLAIMS ALL WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING,
BUT NOT LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
A PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED TO THE PROJECT
BY NXP, AND OR NAY PRODUCT RESULTING FROM NXP SERVICES. IN NO EVENT
SHALL NXP BE LIABLE FOR INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THIS AGREEMENT.

CUSTOMER agrees to hold NXP harmless against any and all claims demands or
actions by anyone on account of any damage, or injury, whether commercial,
contractual, or tortuous, rising directly or indirectly as a result of the advise
or assistance supplied CUSTOMER in connection with product, services or goods
supplied under this Agreement.
********************************************************************************
* File              main.c
* Owner             David Chung
* Version           1.0
* Date              Oct-24-2017
* Classification    General Business Information
* Brief             Produces MPC5744P LFAST_REF_CLK
********************************************************************************
* Detailed Description:
* The Miriac(TM)-EK5744 has a 40 MHz external oscillator (XOSC).  This code example
* divides XOSC by 20 for output frequency of 2 MHz. LFAST_REF_CLK signal can be sourced from
* XOSC. Configures LFAST_REF_CLK, GPIO135 (Extension, Pin 18), signal to 20 MHz.
* Connect this to an LED so LED flashes at frequency of LFAST_REF_CLK.
* Onboard DOUT LED turns on to let user know program is running, but does not flash.
*
* ------------------------------------------------------------------------------
* Test HW:         Miriac(TM)-EK5744
* MCU:             MPC5744P
* Terminal:        None
* Fsys:            16 MHz IRC
* Debugger:        USB Multilink
* Target:          FLASH
* EVB connection:  Connect GPIO135 (Extension, Pin 18) to an oscilloscope or LED. Also,
* 					connect power to the I/O power terminal. Refer to EK5744 QSG for pin
* 					mapping.
*
********************************************************************************
Revision History:
Version  Date         Author  			Description of Changes
1.0      Oct-24-2017  David Chung	  	Initial version

*******************************************************************************/
#include "derivative.h" /* include peripheral declarations */
#include "project.h" /* Board Configuration */

extern void xcptn_xmpl(void);

void memory_config_16mhz(void);
void LFAST_REF_CLK_XOSC(void);

void SysClk_Init(void)
{
    MC_ME.RUN0_MC.R = 0x00130030;
    // Mode Transition to enter RUN0 mode:
    MC_ME.MCTL.R = 0x40005AF0;		    // Enter RUN0 Mode & Key
    MC_ME.MCTL.R = 0x4000A50F;		    // Enter RUN0 Mode & Inverted Key
    while (MC_ME.GS.B.S_MTRANS) {};		    // Wait for mode transition to complete
    while(MC_ME.GS.B.S_CURRENT_MODE != 4) {};	    // Verify RUN0 is the current mode
}

__attribute__ ((section(".text")))
int main(void)
{
	int counter = 0;
	
	xcptn_xmpl ();              /* Configure and Enable Interrupts */
    SysClk_Init();				/* Enable the XOSC */

	memory_config_16mhz(); /* Configure wait states, flash master access, etc. */

	/* Enable DOUT0 LED. PWENA/B effectively act as NAND gate to power DOUT0 */
	SIUL2.MSCR[PC10].B.OBE = 1;	//PWENA
	SIUL2.MSCR[PC13].B.OBE = 1; //PWENB
	SIUL2.MSCR[PD10].B.OBE = 1; /* Pad PD10 - DOUT0 LED. */

	SIUL2.GPDO[PC10].R = 0;
	SIUL2.GPDO[PC13].R = 0;
	SIUL2.GPDO[PD10].R = 1; 	//Turn on LED

	LFAST_REF_CLK_XOSC();		/* GPIO145 = XOSC/20 */

	for(;;) {	   
	   	counter++;
	}

	return 0;
}
