#ifndef _main_h
#define _main_h

/* address definition of the Quest analog die registers */

//-------------------------------------------------------
// example 1
typedef union 
{
  unsigned int word;
  struct
  {
   unsigned char high;
   unsigned char low;
  }tbyte;
}tword;


extern volatile tword _IVR_W @(0x0300);
extern volatile tword _IVR_R @(0x0200);

#define	IVR_Write(n)     _IVR_W.tbyte.high=n;
#define	IVR_Hi_Write(n)  _IVR_W.tbyte.high=n;
#define	IVR_Lo_Write(n)  _IVR_W.tbyte.low =n;

#define	IVR_Read         _IVR_R.tbyte.high;
#define	IVR_Hi_Read      _IVR_R.tbyte.high;
#define	IVR_Lo_Read      _IVR_R.tbyte.low ;

//-------------------------------------------------------
// example 2
extern volatile unsigned char IVR_W @(0x0302);
#define	IVR_Write(n)     IVR_W=n; while(D2DSTAT1_D2DBSY);
extern volatile unsigned char IVR_R @(0x0202);
#define	IVR_Read         IVR_R; while(D2DSTAT1_D2DBSY);

// comment to example 1 and 2:
/* it is necessary to create file "address.c", where 
there will be defined variables of the corresponded types
e.g. : volatile _IVR_W IVR_W, potom sa v main programe pristupuje k hodnote registra cez IVR_W  */

//-------------------------------------------------------
// example 3

#define IVR 0x02

unsigned char read_reg(unsigned int reg) 
  {
    return (* ((unsigned char*) (reg+0x0200)));
  }

void write_reg(unsigned int reg, unsigned char val) 
  {
    * ((unsigned char*) (reg+0x0200)) = val;
  }
  

x = read_reg(IVR);
write_reg(IVR, );
//--------------------------------------------------------

#define	IVR	  0x02
#define	VCR	  0x04
#define	VSR	  0x05
#define	LXR	  0x08
#define	LXCR	0x09
#define	WDR	  0x10
#define	WDSR	0x11
#define	WCR	  0x12
#define	TCR	  0x13
#define	WSR	  0x14
#define	RSR	  0x15
#define	MCR	  0x16
#define	LINR	0x18
#define	PTBC1	0x20
#define	PTBC2	0x21
#define	PTB	  0x22
#define	HSCR	0x28
#define	HSSR	0x29
#define	LSCR	0x30
#define	LSSR	0x31
#define	HSR	  0x38
#define	CSR	  0x3C
#define	SCIBDhi	0x40
#define	SCIBDlo	0x41
#define	SCIC1	0x42
#define	SCIC2	0x43
#define	SCIS1	0x44
#define	SCIS2	0x45
#define	SCIC3	0x46
#define	SCID	0x47
#define	PWMCTL	0x60
#define	PWMPRCLK	0x61
#define	PWMSCLA	0x62
#define	PWMSCLB	0x63
#define	PWMCNT0	0x64
#define	PWMCNT1	0x65
#define	PWMPER0	0x66
#define	PWMPER1	0x67
#define	PWMDTY0	0x68
#define	PWMDTY1	0x69
#define	ACR	0x80
#define	ASR	0x81
#define	ACCRhi	0x82
#define	ACCRlo	0x83
#define	ACCSRhi	0x84
#define	ACCSRlo	0x85
#define	ADR0hi	0x86
#define	ADR0lo	0x87
#define	ADR1hi	0x88
#define	ADR1lo	0x89
#define	ADR2hi	0x8A
#define	ADR2lo	0x8B
#define	ADR3hi	0x8C
#define	ADR3lo	0x8D
#define	ADR4hi	0x8E
#define	ADR4lo	0x8F
#define	ADR5hi	0x90
#define	ADR5lo	0x91
#define	ADR6hi	0x92
#define	ADR6lo	0x93
#define	ADR7hi	0x94
#define	ADR7lo	0x95
#define	ADR8hi	0x96
#define	ADR8lo	0x97
#define	ADR9hi	0x98
#define	ADR9lo	0x99
#define	ADR10hi	0x9A
#define	ADR10lo	0x9B
#define	ADR11hi	0x9C
#define	ADR11lo	0x9D
#define	ADR15hi	0xA4
#define	ADR15lo	0xA5
#define	TIOS	0xC0
#define	CFORC	0xC1
#define	OC3M	0xC2
#define	OC3D	0xC3
#define	TCNThi	0xC4
#define	TCNTlo	0xC5
#define	TSCR1	0xC6
#define	TTOV	0xC7
#define	TCTL1	0xC8
#define	TCTL2	0xC9
#define	TIE	0xCA
#define	TSCR2	0xCB
#define	TFLG1	0xCC
#define	TFLG2	0xCD
#define	TC0hi	0xCE
#define	TC0lo	0xCF
#define	TC1hi	0xD0
#define	TC1lo	0xD1
#define	TC2hi	0xD2
#define	TC2lo	0xD3
#define	TC3hi	0xD4
#define	TC3lo	0xD5



#endif