#ifndef LINSTD_H
#define LINSTD_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linstd.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Define LIN driver data types
*														                            
* Description:
*
* Notes:        
*
******************************************************************************/

typedef unsigned char LIN_BYTE;
typedef unsigned int  LIN_WORD;
typedef unsigned long LIN_DWORD;

//#define LIN_ZPAGE                                   /* zero page for HC12 don't used */

#if defined(CW12)

/* disable interrupt */
#define CLRI()      { asm sei; }
/* enable interrupt */
#define SETI()      { asm cli; }

//#define __lindecl       near                        /* non-banked function modifier       */
//#define LIN_INTERRUPT   interrupt __lindecl void    /* interrupt service routine modifier */

#endif /* defined(CW12) */



/* Extern declaration of lincfg.c user-defined constants */

/* NB: equivalence with LIN_CfgConst definition in lincfg.c/l_cfg.c */
extern const struct
{
    unsigned char   LIN_BaseRam;        /* RAM base address */
    unsigned char   LIN_BaseReg;        /* I/O registers base address */
    unsigned int    LIN_IdleTimeoutClocks;  /* number of LIN_IdleClock() calls per LIN idle timeout */
    unsigned int    LIN_BaudRate;       /* LIN baud rate setting */

} LIN_CfgConst;


#if defined(LINAPI_1_0)
extern const l_u8               LinFlagLookup[];
extern const l_u8               LinSigMaxIdx;
extern       l_u8               LinSigFlags[];
#endif /* defined(LINAPI_1_0) */

#if defined(SLAVE)
extern const LINMsgIdType       LinMsgId[];
extern const LIN_MSGLENGTHTYPE  LinMsgLen[];
#endif /* defined(SLAVE) */

extern const LINMsgRefType      LinMsgBuf[];
extern const LIN_BYTE           LinListSize;
extern       LINStatusType      LinMsgStatus[];

extern const LIN_BYTE           LinLookupTable[];


#endif /* !define (LINSTD_H) */
