#ifndef LINERR_H
#define LINERR_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linerr.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Error module header file
*														                            
* Description:  
*
* Notes:
*
******************************************************************************/

/****************************************************************************
 * All extern declarations of common-purpose RAM variables shall be here.
 ***************************************************************************/
#if defined(HC12) || defined (S12)
#if defined(CW12)
#pragma DATA_SEG SHORT ZeroSeg
#endif /* defined(CW12) */
#endif /* defined(HC12)	|| defined (S12)*/

extern LINErrCounterType LIN_ErrTxCounter;       /* Shift counter for Tx errors */
extern LINErrCounterType LIN_ErrRxCounter;       /* Shift counter for Rx errors */

#if defined(HC12) || defined (S12)
#if defined(CW12) 
#pragma DATA_SEG DEFAULT
#endif /* defined(CW12) */
#endif /* defined(HC12) || defined (S12)*/

/****************************************************************************/
/***                     Macros                                           ***/
/****************************************************************************/

#define LIN_ShiftRxErr()    LIN_ErrRxCounter >>= 1
#define LIN_ShiftTxErr()    LIN_ErrTxCounter >>= 1


/**************************************************************************
 * Function :   LIN_SetRxErr
 *
 * Description: Shift Rx error counter and set high bit
 *
 * Returns:     none
 *
 * Notes:       none
 *
 **************************************************************************/
#if defined(CW12)
#define LIN_SetRxErr()                                  \
        asm SEC;                                        \
        asm ROR LIN_ErrRxCounter
#endif /* defined(CW12) */



/**************************************************************************
 * Function :   LIN_SetTxErr
 *
 * Description: Shift Tx error counter and set high bit
 *
 * Returns:     none
 *
 * Notes:       none
 *
 **************************************************************************/
#if defined(CW12)
#define LIN_SetTxErr()                                  \
        asm SEC;                                        \
        asm ROR  LIN_ErrTxCounter
#endif /* defined(CW12) */



#endif /* !define (LINERR_H) */
