#ifndef _analog_h
#define _analog_h

/* address definition of the Quest analog die registers */
typedef unsigned char byte;
typedef unsigned int word;

	extern	volatile	byte	_ISRhi	@	0x0200;
	#define	ISRhi	_ISRhi
	extern	volatile	byte	_ISRlo	@	0x0201 ;
	#define	ISRlo	_ISRlo
	extern	volatile	byte	_IVR	@	0x0202  ;
	#define	IVR	_IVR
	extern	volatile	byte	_VCR	@	0x0204  ;
	#define	VCR	_VCR
	extern	volatile	byte	_VSR	@	0x0205  ;
	#define	VSR	_VSR
	extern	volatile	byte	_LXR	@	0x0208  ;
	#define	LXR	_LXR
	extern	volatile	byte	_LXCR	@	0x0209  ;
	#define	LXCR	_LXCR
	extern	volatile	byte	_WDR	@	0x0210  ;
	#define	WDR	_WDR
	extern	volatile	byte	_WDSR	@	0x0211  ;
	#define	WDSR	_WDSR
	extern	volatile	byte	_WCR	@	0x0212  ;
	#define	WCR	_WCR
	extern	volatile	byte	_TCR	@	0x0213  ;
	#define	TCR	_TCR
	extern	volatile	byte	_WSR	@	0x0214  ;
	#define	WSR	_WSR
	extern	volatile	byte	_RSR	@	0x0215  ;
	#define	RSR	_RSR
	extern	volatile	byte	_MCR	@	0x0216  ;
	#define	MCR	_MCR
	extern	volatile	byte	_LINR	@	0x0218  ;
	#define	LINR	_LINR
	extern	volatile	byte	_PTBC1	@	0x0220;
	#define	PTBC1	_PTBC1
	extern	volatile	byte	_PTBC2	@	0x0221;
	#define	PTBC2	_PTBC2
	extern	volatile	byte	_PTB	@	0x0222   ;
	#define	PTB	_PTB
	extern	volatile	byte	_HSCR	@	0x0228  ;
	#define	HSCR	_HSCR
	extern	volatile	byte	_HSSR	@	0x0229  ;
	#define	HSSR	_HSSR
	extern	volatile	byte	_LSCR	@	0x0230     ;
	#define	LSCR	_LSCR
	extern	volatile	byte	_LSSR	@	0x0231     ;
	#define	LSSR	_LSSR
	extern	volatile	byte	_LSCEN	@	0x0232     ;
	#define	LSCEN	_LSCEN
	extern	volatile	byte	_HSR	@	0x0238     ;
	#define	HSR	_HSR
	extern	volatile	byte	_CSR	@	0x023C     ;
	#define	CSR	_CSR
	extern	volatile	byte	_SCIBDhi	@	0x0240 ;
	#define	SCIBDhi	_SCIBDhi
	extern	volatile	byte	_SCIBDlo	@	0x0241 ;
	#define	SCIBDlo	_SCIBDlo
	extern	volatile	byte	_SCIC1	@	0x0242   ;
	#define	SCIC1	_SCIC1
	extern	volatile	byte	_SCIC2	@	0x0243   ;
	#define	SCIC2	_SCIC2
	extern	volatile	byte	_SCIS1	@	0x0244   ;
	#define	SCIS1	_SCIS1
	extern	volatile	byte	_SCIS2	@	0x0245   ;
	#define	SCIS2	_SCIS2
	extern	volatile	byte	_SCIC3	@	0x0246   ;
	#define	SCIC3	_SCIC3
	extern	volatile	byte	_SCID	@	0x0247     ;
	#define	SCID	_SCID
	extern	volatile	byte	_PWMCTL	@	0x0260   ;
	#define	PWMCTL	_PWMCTL
	extern	volatile	byte	_PWMPRCLK	@	0x0261 ;
	#define	PWMPRCLK	_PWMPRCLK
	extern	volatile	byte	_PWMSCLA	@	0x0262 ;
	#define	PWMSCLA	_PWMSCLA
	extern	volatile	byte	_PWMSCLB	@	0x0263 ;
	#define	PWMSCLB	_PWMSCLB
	extern	volatile	byte	_PWMCNT0	@	0x0264 ;
	#define	PWMCNT0	_PWMCNT0
	extern	volatile	byte	_PWMCNT1	@	0x0265 ;
	#define	PWMCNT1	_PWMCNT1
	extern	volatile	byte	_PWMPER0	@	0x0266 ;
	#define	PWMPER0	_PWMPER0
	extern	volatile	byte	_PWMPER1	@	0x0267 ;
	#define	PWMPER1	_PWMPER1
	extern	volatile	byte	_PWMDTY0	@	0x0268 ;
	#define	PWMDTY0	_PWMDTY0
	extern	volatile	byte	_PWMDTY1	@	0x0269 ;
	#define	PWMDTY1	_PWMDTY1
	extern	volatile	byte	_ACR	@	0x0280     ;
	#define	ACR	_ACR
	extern	volatile	byte	_ASR	@	0x0281     ;
	#define	ASR	_ASR
	extern	volatile	word	_ACCR	@	0x0282   ;
	#define	ACCR	_ACCR
	extern	volatile	word	_ACCSR	@	0x0284 ;
	#define	ACCSR	_ACCSR
	extern	volatile	word	_ADR0	@	0x0286   ;
	#define	ADR0	_ADR0
	extern	volatile	word	_ADR1	@	0x0288   ;
	#define	ADR1	_ADR1
	extern	volatile	word	_ADR2	@	0x028A   ;
	#define	ADR2	_ADR2
	extern	volatile	word	_ADR3	@	0x028C   ;
	#define	ADR3	_ADR3
	extern	volatile	word	_ADR4	@	0x028E   ;
	#define	ADR4	_ADR4
	extern	volatile	word	_ADR5	@	0x0290   ;
	#define	ADR5	_ADR5
	extern	volatile	word	_ADR6	@	0x0292   ;
	#define	ADR6	_ADR6
	extern	volatile	word	_ADR7	@	0x0294  ;
	#define	ADR7	_ADR7
	extern	volatile	word	_ADR8	@	0x0296  ;
	#define	ADR8	_ADR8
	extern	volatile	word	_ADR9	@	0x0298  ;
	#define	ADR9	_ADR9
	extern	volatile	word	_ADR10	@	0x029A;
	#define	ADR10	_ADR10
	extern	volatile	word	_ADR11	@	0x029C;
	#define	ADR11	_ADR11
	extern	volatile	word	_ADR15	@	0x02A4;
	#define	ADR15	_ADR15
	extern	volatile	byte	_TIOS	@	0x02C0;
	#define	TIOS	_TIOS
	extern	volatile	byte	_CFORC	@	0x02C1;
	#define	CFORC	_CFORC
	extern	volatile	byte	_OC3M	@	0x02C2;
	#define	OC3M	_OC3M
	extern	volatile	byte	_OC3D	@	0x02C3;
	#define	OC3D	_OC3D
	extern	volatile	word	_TCNT	@	0x02C4;
	#define	TCNT	_TCNT
	extern	volatile	byte	_TSCR1	@	0x02C6;
	#define	TSCR1	_TSCR1
	extern	volatile	byte	_TTOV	@	0x02C7;
	#define	TTOV	_TTOV
	extern	volatile	byte	_TCTL1	@	0x02C8;
	#define	TCTL1	_TCTL1
	extern	volatile	byte	_TCTL2	@	0x02C9;
	#define	TCTL2	_TCTL2
	extern	volatile	byte	_TIE	@	0x02CA;
	#define	TIE	_TIE
	extern	volatile	byte	_TSCR2	@	0x02CB;
	#define	TSCR2	_TSCR2
	extern	volatile	byte	_TFLG1	@	0x02CC;
	#define	TFLG1	_TFLG1
	extern	volatile	byte	_TFLG2	@	0x02CD;
	#define	TFLG2	_TFLG2
	extern	volatile	word	_TC0	@	0x02CE;
	#define	TC0hi	_TC0
	extern	volatile	word	_TC1	@	0x02D0;
	#define	TC1hi	_TC1
	extern	volatile	word	_TC2	@	0x02D2;
	#define	TC2hi	_TC2
	extern	volatile	word	_TC3	@	0x02D4;
	#define	TC3	_TC3

  /**************** IFR FLASH TRIMMING CONTENT *************************/

#define REG_BASE_B  0x0200                /* Base address for the I/O register block */


#define bCTR0	      IOBYTE(REG_BASE_B+0xF0) //	Calango Trimming Register 0
#define bCTR1	      IOBYTE(REG_BASE_B+0xF1) //	Calango Trimming Register 1
#define bCTR2	      IOBYTE(REG_BASE_B+0xF2) //	Calango Trimming Register 2
#define bCTR3	      IOBYTE(REG_BASE_B+0xF3) //	Calango Trimming Register 3

  /**************** HS & LS DEFINITIONS *************************/

#define bLSCEN	      IOBYTE(REG_BASE_B+0x32) //	Calango LS Enable Register
#define bLSCR	      IOBYTE(REG_BASE_B+0x30) //	Calango LS Control Register
#define bHSCR	      IOBYTE(REG_BASE_B+0x28) //	Calango HS Control Register


#define  IOBYTE(address)     (*((volatile unsigned char*) (address)))

#define TRIM0       IOBYTE(0x4C)
#define TRIM1       IOBYTE(0x4D)
#define TRIM2       IOBYTE(0x4E)
#define TRIM3       IOBYTE(0x4F)



#endif