#define LINERR_C
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linerr.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Error management module
*												                            
* Description:  
*
* Notes:        
*
******************************************************************************/

#include "linbase.h"

#pragma MESSAGE DISABLE C4200 /* WARNING C4200: other segment than in previous declaration */
 /****************************************************************************
 * All common-purpose RAM variables shall be declared here.
 ***************************************************************************/
#if defined(HC12) || defined (S12)
#if defined(CW12)
#pragma DATA_SEG SHORT ZeroSeg
#endif /* defined(CW12) */
#endif /* defined(HC12)	|| defined (S12)*/

LINErrCounterType LIN_ErrTxCounter;       /* Shift counter for Tx errors */
LINErrCounterType LIN_ErrRxCounter;       /* Shift counter for Rx errors */

#if defined(HC12) || defined (S12)
#if defined(CW12) 
#pragma DATA_SEG DEFAULT
#endif /* defined(CW12) */
#endif /* defined(HC12) || defined (S12)*/
/****************************************************************************
 * End of common-purpose RAM variables declaration
 ***************************************************************************/


#if !defined(LINAPI_1_0)

/***************************************************************************
 * Function :   LIN_GetTxErr
 *
 * Description: Return shift counter for Tx errors
 *
 * Returns:     LIN_ErrTxCounter
 *
 * Notes:       1. API call 
 **************************************************************************/
LINErrCounterType LIN_GetTxErr( void )
{
    return LIN_ErrTxCounter;       
}

/***************************************************************************
 * Function :   LIN_GetRxErr
 *
 * Description: Return shift counter for Rx errors
 *
 * Returns:     LIN_ErrRxCounter
 *
 * Notes:       1. API call 
 **************************************************************************/
LINErrCounterType LIN_GetRxErr( void )
{
    return LIN_ErrRxCounter;       
}

/***************************************************************************
 * Function :   LIN_ClearTxErr
 *
 * Description: Clear shift counter for Tx errors
 *
 * Returns:     none
 *
 * Notes:       1. API call
 **************************************************************************/
void LIN_ClearTxErr( void )
{
    LIN_ErrTxCounter = 0;
}

/***************************************************************************
 * Function :   LIN_ClearRxErr
 *
 * Description: Clear shift counter for Rx errors
 *
 * Returns:     none
 *
 * Notes:       1. API call
 **************************************************************************/
void LIN_ClearRxErr( void )
{
    LIN_ErrRxCounter = 0;
}

#endif /* !defined(LINAPI_1_0) */
