#define LININIT_C

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lininit.c                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver initialization 
*												                            
* Description:  
*
* Notes:        
*
******************************************************************************/

#include "linbase.h"

#if defined(CW12)
#pragma DATA_SEG LinReg
#endif /* defined(CW12) */

#if defined(COSMIC12)
#pragma section [lin_reg]
#endif /* defined(COSMIC12) */

volatile LIN_REGTYPE LIN_Reg;           /* Structure with S12 registers definition */

#if defined(COSMIC12)
#pragma section []
#endif /* defined(COSMIC12) */

#if defined(CW12)
#pragma DATA_SEG DEFAULT
#endif /* defined(CW12) */

#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)

LIN_BYTE    LIN_InternalError;           /* Internal error code */

#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */

#if defined(CW12)
extern void near _Startup( void );      /* HiCross compiler startup routine declaration */
#endif  /* defined(CW12)   */
/* Cosmic compiler startup routine is declared via _asm xref,
   because C symbols are undefined in Cosmic inline assembler expressions */

/***************************************************************************
 * Function :   LIN_Startup( )
 *
 * Description: Initialize mode registers and
 *              call compiler startup function
 *
 * Returns:     no returns value
 *
 * Notes:
 *
 **************************************************************************/
#if defined(CW12)

#pragma NO_FRAME
#pragma NO_ENTRY
#pragma NO_EXIT 
#pragma NO_RETURN
void near LIN_Startup( void ) 
{
                                
    LIN_INITRM = LIN_CfgConst.LIN_BaseRam;   /* fisrt step: Initialize INITRM register (RAM allocation) */
    LIN_INITRG = LIN_CfgConst.LIN_BaseReg;   /* last step: initialize INITRG registers (I/O registers allocation) */
                                                         
    asm                         /* Jump to normal startup */ 
    {    
        jmp _Startup 
    }                   
}

#endif  /* defined(CW12)   */



#if defined(LINAPI_1_0)

/***************************************************************************
 * Function :   l_sys_init
 *
 * Description: Initialise driver 
 * 
 * Returns:     Always returns 0
 *
 * Notes:       LIN API service call
 *
 **************************************************************************/
l_bool l_sys_init ( void )
{    
    LIN_BYTE    i;
    LIN_BYTE    intMask;

    LIN_DBG_SET_PORT_7;

    intMask = LIN_DisableInt();     /* disable interrupts */

    /* Set initial state -- this is abort any activity, interface is disconnected */
    LIN_StateFlags  = LIN_FLAG_NOINIT | LIN_FLAG_DISCONNECT | LIN_FLAG_IGNORE;

    /* Initialize Error Counters */
    LIN_ErrTxCounter = 0;
    LIN_ErrRxCounter = 0;

    /* Initialize all signal flags with 0 */
    for( i = 0; i <= LinSigMaxIdx; i++ )
    {
        LinSigFlags[i] = 0;
    }

    /* Initialize transmitted messages with NO_DATA */
    /* NB: now -- for all transmitted and received messages -- OPTIM */
    for( i = 0; i < LinListSize; i++ )
    {
        LinMsgStatus[i] = LIN_MSG_NODATA;   /* Set NODATA */
    }

    /* Set idle timeout if it has not set yet */
    LIN_SetIdleTimeout();               

    /* Debug initializing */
#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)
    LIN_InternalError = LIN_ERROR_0;
#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */
    LIN_DBG_INIT_PORT(0x00);

    LIN_EnableInt(intMask);     /* enable interrupts */

    LIN_DBG_CLR_PORT_7;

    return 0;
} 


#else /* !defined(LINAPI_1_0) */

/***************************************************************************
 * Function :   LIN_Init
 *
 * Description: Initialise driver - software & hardware
 * 
 * Returns:     none
 *
 * Notes:       Freescale API service call
 *
 **************************************************************************/
void  LIN_Init ( void )
{    
    LIN_BYTE    i;
    LIN_BYTE    intMask;

    LIN_DBG_SET_PORT_7;

    intMask = LIN_DisableInt();     /* disable interrupts */

    /* Set initial state -- this is abort any activity */
    LIN_StateFlags  = LIN_FLAG_IGNORE;

    /* Initialize Error Counters */
    LIN_ErrTxCounter = 0;
    LIN_ErrRxCounter = 0;

    /* Initialize messages with NO_DATA */
    for( i = 0; i < LinListSize; i++ )
    {
        LinMsgStatus[i] = LIN_MSG_NODATA;   /* Set NO_DATA */
    }

#if defined(MASTER)
    /* Initialize Timer for LIN (Slave don't use any timers) */
    LIN_TimerInit();
#endif /* defined(MASTER) */

    /* Initialize SCI for LIN */
    LIN_SCIInit();

    /* Set idle timeout if it has not set yet */
    LIN_SetIdleTimeout();               

    /* Debug initializing */
#if defined(LIN_DBG_CHECK_INTERNAL_ERROR)
    LIN_InternalError = LIN_ERROR_0;
#endif /* defined(LIN_DBG_CHECK_INTERNAL_ERROR) */
    LIN_DBG_INIT_PORT(0x00);

    LIN_EnableInt(intMask);     /* enable interrupts */

    LIN_DBG_CLR_PORT_7;
} 


/***************************************************************************
 * Function :   LIN_DisableInt
 *
 * Description: disable interrupts 
 * 
 * Returns:     Interrupt state 
 *
 * Notes:       only for Freescale API
 *              
 **************************************************************************/
#if defined(CW12)
#pragma OPTION ADD handle_register "-Or"
#endif /* defined(CW12) */

LIN_BYTE LIN_DisableInt( void )
{
#if defined(CW12)
    { 
        asm tfr ccr, b; 
        asm sei;
    }    
#endif /* defined(CW12)*/
#if defined(COSMIC12)
#asm
        tfr ccr, b
        sei     
#endasm 
#endif /* defined(COSMIC12)*/
}

#if defined(CW12)
#pragma OPTION DEL handle_register 
#endif /* defined(CW12) */

/***************************************************************************
 * Function :   LIN_EnableInt
 *
 * Description: enable interrupts
 * 
 * Returns:     
 *
 * Notes:       only for Freescale API
 *              
 **************************************************************************/
#if defined(CW12)
#pragma OPTION ADD handle_register "-Or"
#endif /* defined(CW12) */

void LIN_EnableInt( LIN_BYTE mask)
{

#if defined(CW12)
    { 
        asm tfr b, ccr;     /* ldaa mask; asm tap; */
    } 
#endif /* defined(CW12)*/
#if defined(COSMIC12)
    _asm("tfr b, ccr\n", mask );
#endif /* defined(COSMIC12) */

}

#if defined(CW12)
#pragma OPTION DEL handle_register
#endif /* defined(CW12) */


#endif /* !defined(LINAPI_1_0) */
