/**
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.nxp.vizncompanionapp.utility

import android.os.AsyncTask
import android.util.Log
import java.io.IOException
import java.net.DatagramPacket
import java.net.DatagramSocket
import java.net.InetAddress

/**
 * Send UPD Message to device
 *
 * @param msg Message send to device
 * @param address Address InetAddress of device or LAN
 */
class UdpSendProtocol(msg: String, address: String) : AsyncTask<Void, Void, Void>() {

    private var socket: DatagramSocket? = null
    private var mData: String = ""
    private var mAddress: String = ""

    /**
     * initialized objects
     */
    init {
        this.mData = msg
        this.mAddress = address
    }

    override fun doInBackground(vararg voids: Void): Void? {
        try {
            broadcast(mData,mAddress)
        } catch (e: Exception) {
            e.printStackTrace()
        } finally {
            if(socket != null){
                socket?.close()
                Log.e("TAG", "socket.close()")
            }
        }

        return null
    }

    /**
     * Broadcast Message
     *
     * @param mData Message send to device
     * @param mAddress Address InetAddress of device or LAN
     */
    @Throws(IOException::class)
    fun broadcast(mData: String, mAddress: String) {
            Log.e("TAG", "BroadCast Address: " + mAddress)
            socket = DatagramSocket()
            socket?.broadcast = true
            val buffer = mData.toByteArray()
            var address = InetAddress.getByName(mAddress)
            val packet = DatagramPacket(buffer, buffer.size, address, AppConstant.UDP_PORT)
            socket?.send(packet)
            socket?.close()
    }

}