/**
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.nxp.vizncompanionapp.utility

import android.util.Log
import com.nxp.vizncompanionapp.interfaces.DeviceList
import com.nxp.vizncompanionapp.model.Device
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException
import java.net.DatagramPacket
import java.net.DatagramSocket
import java.net.SocketException

/**
 * Start UDP Listener socket to receive data from devices
 *
 * @param udpServerPORT Port of Listener socket
 * @param device DeviceList interface to send device info ViewModel class
 */
class UdpRecieveProtocol(udpServerPORT: Int,device: DeviceList) : Thread() {
    private val TAG = "UdpRecieveProtocol"

    internal var serverPort: Int = 0
    internal var socket: DatagramSocket? = null
    internal var devicename: DeviceList? = null

    internal var running: Boolean = false

    /**
     * initialized objects
     */
    init {
        this.serverPort = udpServerPORT
        this.running = true
        this.devicename = device
    }

    /**
     * close the UDP socket
     */
    fun setRunning(running: Boolean) {
        this.running = running
        this.socket?.close()
    }

    override fun run() {
        try {
            socket = DatagramSocket(serverPort)
            Log.e(TAG, "UDP Server is running")

            while (running) {
                var buf = ByteArray(256)

                // receive request
                var packet = DatagramPacket(buf, buf.size)
                socket?.receive(packet)

                // send the response to the client at "address" and "port"
                val text = String(buf, 0, packet.length)
                Log.e("Response",text)

                val json = JSONObject(text)
                var keys:JSONArray = json.names()
                var newJson = JSONObject()
                for (i in 0..(keys.length()-1)){
                    newJson.put(keys[i].toString().toLowerCase(),json.getString(keys[i].toString()))
                }
                if(newJson.has(AppConstant.DEVICE_PRODUCT_ID) && newJson.has(AppConstant.DEVICE_DSN) && newJson.has(AppConstant.DEVICE_CODE_CHALLENGE)){
                    var deviceName = newJson.getString(AppConstant.DEVICE_PRODUCT_ID)
                    var serialNumber = newJson.getString(AppConstant.DEVICE_DSN)
                    var codeChallenge = newJson.getString(AppConstant.DEVICE_CODE_CHALLENGE)
                    devicename?.addDevice(Device(deviceName,serialNumber,codeChallenge,"",packet.address.hostAddress.toString(),"",""))
                } else if (newJson.has(AppConstant.DEVICE_PRODUCT_ID) && newJson.has(AppConstant.DEVICE_STATE)){
                    var deviceName = newJson.getString(AppConstant.DEVICE_PRODUCT_ID)
                    var state = newJson.getString(AppConstant.DEVICE_STATE)
                    devicename?.addDevice(Device(deviceName, "", "", state, packet.address.hostAddress.toString(),"",""))
                } else if(newJson.has(AppConstant.DEVICE_STATUS)){
                    var status = newJson.getString(AppConstant.DEVICE_STATUS)
                    devicename?.addDevice(Device("","","","",packet.address.hostAddress.toString(),status,""))
                } else if (newJson.has(AppConstant.DEVICE_DSN) && newJson.has(AppConstant.DEVICE_STATE)){
                    var dsn = newJson.getString(AppConstant.DEVICE_DSN)
                    var state = newJson.getString(AppConstant.DEVICE_STATE)
                    devicename?.addDevice(Device("", dsn, "", state, packet.address.hostAddress.toString(),"",""))
                } else if (newJson.has(AppConstant.DEVICE_DSN) && newJson.has(AppConstant.DEVICE_METADATE)){
                    var dsn = newJson.getString(AppConstant.DEVICE_DSN)
                    var metadata = newJson.getString(AppConstant.DEVICE_METADATE)
                    devicename?.addDevice(Device("", dsn, "", "", packet.address.hostAddress.toString(),"",metadata))
                } else{
                    Log.e("UnExpected Response",text)
                }
            }

            Log.e(TAG, "UDP Server ended")

        } catch (e: SocketException) {
            e.printStackTrace()
        } catch (e: IOException) {
            e.printStackTrace()
        } catch (e: JSONException){
            e.printStackTrace()
        }
    }
}