package com.nxp.vizncompanionapp.adapters

import android.content.Context
import android.net.wifi.ScanResult
import android.support.v7.widget.CardView
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.nxp.vizncompanionapp.R

class WifiListAdapter(context : Context) : RecyclerView.Adapter<WifiListAdapter.WordViewHolder>() {

    private var mInflater: LayoutInflater? = null
    private var myClickListener: MyClickListener? = null
    private var mWifiList: List<ScanResult>? = null
    var context = context

    init {
        mInflater = LayoutInflater.from(context)
        this.context = context
    }


    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): WordViewHolder {
        val itemView = mInflater?.inflate(R.layout.rv_wifilist_item,parent,false)
        return WordViewHolder(itemView!!)
    }

    override fun getItemCount(): Int {
        return if(mWifiList != null){
            mWifiList!!.size
        } else{
            0
        }
    }

    override fun onBindViewHolder(holder: WordViewHolder?, position: Int) {
       holder?.wordItemView!!.text = mWifiList?.get(position)?.SSID
    }


    internal fun setDevices(devices: List<ScanResult>?) {
        mWifiList = devices
        notifyDataSetChanged()
    }

    inner class WordViewHolder (itemView: View) : RecyclerView.ViewHolder(itemView), View.OnClickListener {
        override fun onClick(v: View) {
            myClickListener?.onItemClick(adapterPosition, v,mWifiList)
        }

        val wordItemView: TextView
        val wordItemRvView: CardView

        init {
            wordItemView = itemView.findViewById(R.id.rvWifiItem1)
            wordItemRvView = itemView.findViewById(R.id.llRvWifiItem)

            wordItemRvView.setOnClickListener(this)
        }

    }

    interface MyClickListener {
        fun onItemClick(position: Int, v: View,mDeviceList: List<ScanResult>?)
    }

    /**
     * RecyclerView item click listener
     *
     * @param myClickListener listener
     */
    fun setOnItemClickListener(myClickListener: MyClickListener) {
        this.myClickListener = myClickListener
    }
}