/**
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.nxp.vizncompanionapp.adapters

import android.content.Context
import android.support.v7.widget.CardView
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.nxp.vizncompanionapp.model.Device
import com.nxp.vizncompanionapp.R.*
import com.nxp.vizncompanionapp.R.color.*
import com.nxp.vizncompanionapp.utility.AppConstant
import com.rey.material.widget.ProgressView

class ListAdapter(context: Context) : RecyclerView.Adapter<ListAdapter.WordViewHolder>() {

    private var mInflater: LayoutInflater? = null
    private var myClickListener: MyClickListener? = null
    var mDeviceList: List<Device>? = null
    var context = context


    init {
        mInflater = LayoutInflater.from(context)
        this.context = context
    }

    override fun onBindViewHolder(holder: WordViewHolder?, position: Int) {
        holder?.wordItemView!!.text = "Serial Number: " + mDeviceList?.get(position)?.mDsn + "\n" + "IP Address: " + mDeviceList?.get(position)?.mDeviceAddress
        holder?.wordItemView.setTextColor(context.getColor(colorPrimary))

        when {
            mDeviceList?.get(position)?.mState == AppConstant.DEVICE_STATE_ALREADY_CONNECTED -> {
                //Change the color
                holder?.wordItemRvView.setCardBackgroundColor(context.getColor(nxpYellow))
                holder?.wordItemStatus.visibility = View.VISIBLE
                holder?.wordItemStatus.text = AppConstant.DEVICE_STATUS_COMPLETE
                holder?.wordItemRvView.isEnabled = false
            }

            mDeviceList?.get(position)?.mState == AppConstant.DEVICE_STATE_CONFIRM_RESPONSE-> {
                holder?.wordItemRvView.setCardBackgroundColor(context.getColor(nxpGreen))
                holder?.wordItemStatus.visibility = View.VISIBLE
                holder?.wordItemStatus.text = AppConstant.DEVICE_STATUS_CONFIRM
                holder?.wordItemProgressView.visibility = View.GONE
                holder?.wordItemRvView.isEnabled = true
            }
            else -> {
                holder?.wordItemRvView.setCardBackgroundColor(context.getColor(colorAccent))
                holder?.wordItemStatus.visibility = View.INVISIBLE
                holder?.wordItemProgressView.visibility = View.GONE
                holder?.wordItemRvView.isEnabled = true
            }
        }
    }

    override fun getItemCount(): Int {
       return if(mDeviceList != null){
           mDeviceList!!.size
       } else{
           0
       }
    }

    internal fun setDevices(devices: List<Device>?) {
        mDeviceList = devices
        notifyDataSetChanged()
    }

    override fun onCreateViewHolder(parent: ViewGroup?, viewType: Int): WordViewHolder {
        val itemView = mInflater?.inflate(layout.rvlist_item,parent,false)
        return WordViewHolder(itemView!!)
    }

    inner class WordViewHolder (itemView: View) : RecyclerView.ViewHolder(itemView), View.OnClickListener {
        override fun onClick(v: View) {
            myClickListener?.onItemClick(adapterPosition, v,mDeviceList)
        }

        val wordItemView: TextView
        val wordItemStatus: TextView
        val wordItemProgress: ProgressView
        val wordItemProgressStatus: TextView
        val wordItemProgressView: LinearLayout
        val wordItemRvView: CardView

        init {
            wordItemView = itemView.findViewById(id.rvItem1)
            wordItemStatus = itemView.findViewById(id.rvItemStatus)
            wordItemProgress = itemView.findViewById(id.rvProgress)
            wordItemProgressStatus = itemView.findViewById(id.rvProgressStatus)
            wordItemProgressView = itemView.findViewById(id.llProgress)
            wordItemRvView = itemView.findViewById(id.llRvItem)
            wordItemRvView.setOnClickListener(this)
        }
    }

    interface MyClickListener {
        fun onItemClick(position: Int, v: View,mDeviceList: List<Device>?)
    }

    /**
     * RecyclerView item click listener
     *
     * @param myClickListener listener
     */
    fun setOnItemClickListener(myClickListener: MyClickListener) {
        this.myClickListener = myClickListener
    }
}