/**
 * Copyright 2018 thedamfr
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.thedamfr.android.BleEventAdapter;


import android.bluetooth.BluetoothGattService;
import android.util.Log;
import com.thedamfr.android.BleEventAdapter.events.*;
import com.squareup.otto.Subscribe;

import java.util.List;

public class EventLogger {

    private static final String TAG = "BLE_EVENT_BUS";
    private final BleEventBus mBleEventBus;

    public EventLogger() {
        mBleEventBus = BleEventBus.getInstance();
        mBleEventBus.register(this);
    }

    @Subscribe
    public void logDeviceDiscovered(DiscoveredDevicesEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void logScanningEvent(ScanningEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(CharacteristicChangedEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(CharacteristicReadEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(CharacteristicWriteEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(DescriptorReadEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(DescriptorWriteEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(GattConnectionStateChangedEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(ReadRemoteRssiEvent event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(ReliableWriteCompleted event) {
        Log.i(TAG, event.toString());
    }

    @Subscribe
    public void log(ServiceDiscoveredEvent event) {
        Log.i(TAG, event.toString());
        List<BluetoothGattService> services = event.getmGatt().getServices();
        for(BluetoothGattService service : services)
        {
            Log.i(TAG, service.getClass().getSimpleName() + " : "
                    + service.getUuid().toString() + " "
                    + service.getCharacteristics().size() + " Characteristics" + " "
                    + service.getIncludedServices().size() + " Included Services");
        }
    }

    @Subscribe
    public void log(DiscoveryServiceEvent event) {
        Log.i(TAG, event.toString());
    }
}
