/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.map.device.utils;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MAPLog {
    private static final String LOG_TAG = MAPLog.class.getName();
    private static final String PII_STRING = ".PII";
    private static final String OBSCURED = "<obscured>";
    private static final String SEPARATOR = ":";
    private static final String LOG_TAG_PII = "com.amazon.identity.pii";
    private static final String NO_MESSAGE = "N/A";
    public static boolean IS_FIRST_PARTY_DEBUG_BUILD = MAPLog.isFirstPartyDebugBuild();
    private static final String ENG = "eng";
    private static final String USERDEBUG = "userdebug";
    private static final String MATCHER_PATTERN = "^(?:(.*?)_)??(?:([^_]*)_)?([0-9]+)$";
    private static final int NUM_GROUPS = 3;
    private static final int FLAVOR_INDEX = 2;

    public static int pii(String tag, String msg, String pii) {
        return MAPLog.pii(tag, msg, pii, null);
    }

    public static int pii(String tag, String msg, String pii, Throwable tr) {
        if (tag == null) {
            tag = "NULL_TAG";
        }
        tag = tag + PII_STRING;
        int priority = 3;
        String piiInfo = OBSCURED;
        if (IS_FIRST_PARTY_DEBUG_BUILD) {
            priority = 4;
            piiInfo = pii;
        } else {
            if (DefaultLibraryInfo.isProd() && Log.isLoggable((String)LOG_TAG_PII, (int)3)) {
                return MAPLog.logPii(tag, msg, pii, tr, 3);
            }
            if (!DefaultLibraryInfo.isProd()) {
                return MAPLog.logPii(tag, msg, pii, tr, 3);
            }
        }
        if (tr != null) {
            if (priority == 4) {
                return Log.i((String)tag, (String)MAPLog.getUpdatedMessage(msg, piiInfo), (Throwable)tr);
            }
            return Log.d((String)tag, (String)MAPLog.getUpdatedMessage(msg, piiInfo), (Throwable)tr);
        }
        if (priority == 4) {
            return Log.i((String)tag, (String)MAPLog.getUpdatedMessage(msg, piiInfo));
        }
        return Log.d((String)tag, (String)MAPLog.getUpdatedMessage(msg, piiInfo));
    }

    private static int logPii(String tag, String msg, String pii, Throwable tr, int priority) {
        if (tr != null) {
            if (priority == 4) {
                return Log.i((String)tag, (String)MAPLog.getUpdatedMessage(msg, pii), (Throwable)tr);
            }
            return Log.d((String)tag, (String)MAPLog.getUpdatedMessage(msg, pii), (Throwable)tr);
        }
        if (priority == 4) {
            return Log.i((String)tag, (String)MAPLog.getUpdatedMessage(msg, pii));
        }
        return Log.d((String)tag, (String)MAPLog.getUpdatedMessage(msg, pii));
    }

    private static String getUpdatedMessage(String msg, String pii) {
        StringBuffer newMsg = new StringBuffer(msg);
        if (!TextUtils.isEmpty((CharSequence)pii)) {
            newMsg.append(SEPARATOR);
            newMsg.append(pii);
        }
        return newMsg.toString();
    }

    public static int d(String tag, String msg) {
        return Log.d((String)tag, (String)msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return Log.d((String)tag, (String)msg, (Throwable)tr);
    }

    public static int e(String tag, String msg) {
        return Log.e((String)tag, (String)msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    public static int i(String tag, String msg) {
        return Log.i((String)tag, (String)msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    public static int v(String tag, String msg) {
        return Log.v((String)tag, (String)msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return Log.v((String)tag, (String)msg, (Throwable)tr);
    }

    public static int w(String tag, String msg) {
        return Log.w((String)tag, (String)msg);
    }

    public static int w(String tag, Throwable tr) {
        return Log.w((String)tag, (String)NO_MESSAGE, (Throwable)tr);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return Log.w((String)tag, (String)msg, (Throwable)tr);
    }

    public static String getStackTraceString(Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }

    public static boolean isLoggable(String tag, int level) {
        return Log.isLoggable((String)tag, (int)level);
    }

    public static int println(int priority, String tag, String msg) {
        return Log.println((int)priority, (String)tag, (String)msg);
    }

    public static int wtf(String tag, Throwable tr) {
        return Log.wtf((String)tag, (Throwable)tr);
    }

    public static int wtf(String tag, String msg) {
        return Log.wtf((String)tag, (String)msg);
    }

    public static int wtf(String tag, String msg, Throwable tr) {
        return Log.wtf((String)tag, (String)msg, (Throwable)tr);
    }

    private static boolean isFirstPartyDebugBuild() {
        try {
            String incrementalVersionString = Build.VERSION.INCREMENTAL;
            if (TextUtils.isEmpty((CharSequence)incrementalVersionString)) {
                MAPLog.w(LOG_TAG, "Incremental version was empty");
                return false;
            }
            Pattern p = Pattern.compile(MATCHER_PATTERN);
            MAPLog.pii(LOG_TAG, "Extracting verison incremental", "Build.VERSION.INCREMENTAL: " + incrementalVersionString);
            Matcher m = p.matcher(incrementalVersionString);
            if (!m.find()) {
                MAPLog.pii(LOG_TAG, "Incremental version '%s' was in invalid format.", "ver=" + incrementalVersionString);
                return false;
            }
            if (m.groupCount() < 3) {
                MAPLog.e(LOG_TAG, "Error parsing build version string.");
                return false;
            }
            String buildFlavor = m.group(2);
            MAPLog.pii(LOG_TAG, "Extracting flavor", "Build flavor: " + buildFlavor);
            if (!TextUtils.isEmpty((CharSequence)buildFlavor) && (buildFlavor.equals(USERDEBUG) || buildFlavor.equals(ENG))) {
                MAPLog.i(LOG_TAG, "MAP is running on 1st party debug");
                return true;
            }
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, e.getMessage(), e);
        }
        return false;
    }
}

