/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.workflow;

import android.content.Context;
import android.net.Uri;
import com.amazon.identity.auth.device.interactive.InteractiveListener;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.workflow.WorkflowCancellation;
import com.amazon.identity.auth.device.workflow.WorkflowResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWorkflowListener<T, U, V>
implements InteractiveListener<T, U, V> {
    private static final String LOG_TAG = BaseWorkflowListener.class.getName();

    protected abstract void onWorkflowSuccess(Context var1, InteractiveRequestRecord var2, JSONObject var3);

    protected abstract void onWorkflowError(Context var1, InteractiveRequestRecord var2, Exception var3);

    protected abstract void onWorkflowCancel(Context var1, InteractiveRequestRecord var2, WorkflowCancellation var3);

    @Override
    public final void onRequestCompletion(Context context, InteractiveRequestRecord request, Uri uri) {
        WorkflowResponse response = new WorkflowResponse(uri);
        if (response.isError()) {
            MAPLog.d(LOG_TAG, "onRequestCompletion failure: " + response.getError().getMessage());
            this.onWorkflowError(context, request, response.getError());
        } else {
            MAPLog.pii(LOG_TAG, "onRequestCompletion success", "result=" + response.getResultJson());
            this.onWorkflowSuccess(context, request, response.getResultJson());
        }
    }

    @Override
    public final void onRequestError(Context context, InteractiveRequestRecord request, Exception e) {
        MAPLog.d(LOG_TAG, "onRequestError: " + e.getMessage());
        this.onWorkflowError(context, request, e);
    }

    @Override
    public final void onRequestCancel(Context context, InteractiveRequestRecord request, WorkflowCancellation cancellation) {
        MAPLog.d(LOG_TAG, "onRequestCancel");
        this.onWorkflowCancel(context, request, cancellation);
    }
}

