/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.workflow;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.RequestManager;
import com.amazon.identity.auth.device.api.workflow.ListenerNotFoundException;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.interactive.InteractiveRequest;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.LWAServiceWrapper;
import com.amazon.identity.auth.device.workflow.WorkflowCancellation;
import com.amazon.identity.auth.device.workflow.WorkflowConstants;
import com.amazon.identity.auth.device.workflow.WorkflowRequest;
import com.amazon.identity.auth.device.workflow.WorkflowRequestFactory;
import com.amazon.identity.auth.device.workflow.WorkflowToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AmazonWorkflow {
    private static final String LOG_TAG = AmazonWorkflow.class.getName();
    private static final ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
    private static final int LOWEST_MINIMUM_TOKEN_LIFETIME_VALUE = 0;
    private static final int DEFAULT_MINIMUM_TOKEN_LIFETIME_VALUE = 300;
    private static WorkflowRequestFactory workflowRequestFactory = new WorkflowRequestFactory(new ServerCommunication());
    private static ThirdPartyServiceHelper thirdPartyServiceHelper = new ThirdPartyServiceHelper();

    private AmazonWorkflow() {
    }

    public static void openWorkflow(final InteractiveRequest<?, ?, ?, ?> request, final String workflowUrl, String workflowToken, Bundle options) throws ListenerNotFoundException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)workflowUrl)) {
            throw new IllegalArgumentException("workflowUrl cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)workflowToken)) {
            throw new IllegalArgumentException("workflowToken cannot be empty");
        }
        if (TextUtils.isEmpty((CharSequence)request.getRequestType())) {
            throw new IllegalArgumentException("getRequestType() of the passed in request object cannot be empty. Please refer to the documentation of getRequestType().");
        }
        request.assertListenerPresent();
        final Context context = request.getContext();
        final int minimumTokenLifetime = AmazonWorkflow.getMinimumTokenLifetime(options);
        final String workflowTokenString = workflowToken;
        MAPLog.pii(LOG_TAG, String.format("%s calling openWorkflow", context.getPackageName()), workflowUrl);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                try {
                    AmazonWorkflow.assertAPIKeyIsValid(context);
                    WorkflowToken workflowToken = new WorkflowToken(workflowTokenString);
                    WorkflowRequest workflowRequest = workflowRequestFactory.getWorkflowRequest(request, workflowUrl, workflowToken, minimumTokenLifetime);
                    if (!AmazonWorkflow.tryOpenWorkflowInFirstPartyApp(context, workflowRequest, workflowTokenString)) {
                        RequestManager.getInstance().executeRequest(workflowRequest, context);
                    }
                }
                catch (AuthError ae) {
                    InteractiveRequestRecord requestRecord = new InteractiveRequestRecord(null, request.getRequestExtras());
                    request.onRequestError(context, requestRecord, ae);
                }
            }
        });
    }

    static void setWorkflowRequestFactory(WorkflowRequestFactory workflowRequestFactory) {
        AmazonWorkflow.workflowRequestFactory = workflowRequestFactory;
    }

    static void setThirdPartyServiceHelper(ThirdPartyServiceHelper thirdPartyServiceHelper) {
        AmazonWorkflow.thirdPartyServiceHelper = thirdPartyServiceHelper;
    }

    private static boolean tryOpenWorkflowInFirstPartyApp(final Context context, final WorkflowRequest workflowRequest, final String workflowToken) throws AuthError {
        Boolean result = (Boolean)new LWAServiceWrapper<Boolean>(){

            @Override
            protected Boolean doWork(Context workContext, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
                return AmazonWorkflow.callOpenWorkflowInFirstPartyApp(service, context, workflowRequest, workflowToken);
            }
        }.execute(context, thirdPartyServiceHelper);
        return result != null ? result : false;
    }

    private static boolean callOpenWorkflowInFirstPartyApp(AmazonAuthorizationServiceInterface service, Context context, WorkflowRequest workflowRequest, String workflowToken) throws AuthError, RemoteException {
        if (!workflowRequest.canAttempt()) {
            throw new AuthError("Reached maximum attempts for the workflow request", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        Bundle result = service.openWorkflow(new Bundle(), context.getPackageName(), workflowRequest.getUrl(context), workflowToken);
        if (result == null) {
            return false;
        }
        result.setClassLoader(context.getClassLoader());
        if (result.containsKey("AUTH_ERROR_EXECEPTION")) {
            throw AuthError.extractError(result);
        }
        if (result.containsKey(WorkflowConstants.API.CANCELLATION_CODE.val)) {
            InteractiveRequest<?, ?, ?, ?> interactiveRequest = workflowRequest.getOriginalRequest();
            InteractiveRequestRecord requestRecord = workflowRequest.getInteractiveRequestRecord();
            WorkflowCancellation cancellation = new WorkflowCancellation(result);
            interactiveRequest.onRequestCancel(context, requestRecord, cancellation);
            return true;
        }
        if (!result.containsKey(WorkflowConstants.API.RESPONSE_URL.val)) {
            return false;
        }
        if (workflowRequest.handleResponse(Uri.parse((String)result.getString(WorkflowConstants.API.RESPONSE_URL.val)), context)) {
            return true;
        }
        workflowRequest.incrementAttemptCount();
        return AmazonWorkflow.callOpenWorkflowInFirstPartyApp(service, context, workflowRequest, workflowToken);
    }

    private static int getMinimumTokenLifetime(Bundle options) {
        if (options == null) {
            return 300;
        }
        int minimumTokenLifetime = options.getInt(WorkflowConstants.OPTION.MINIMUM_TOKEN_LIFETIME.val, 300);
        if (minimumTokenLifetime < 0) {
            throw new IllegalArgumentException("minimum token lifetime option has invalid value");
        }
        return minimumTokenLifetime;
    }

    private static void assertAPIKeyIsValid(Context context) throws AuthError {
        if (!appIdentifier.isAPIKeyValid(context)) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
    }
}

