/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.content.Context;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.interactive.InteractiveState;
import com.amazon.identity.auth.device.interactive.RequestSource;
import com.amazon.identity.auth.device.interactive.WorkflowSupportFragment;
import java.lang.ref.WeakReference;

public class RequestSourceContextWrapper
implements RequestSource {
    private static final String LOG_TAG = RequestSourceContextWrapper.class.getName();
    private final WeakReference<Context> contextWeakReference;
    private WorkflowSupportFragment workflowSupportFragment;

    public RequestSourceContextWrapper(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must be non-null");
        }
        this.contextWeakReference = new WeakReference<Context>(context);
        this.workflowSupportFragment = null;
    }

    public void onStartRequest(InteractiveRequestRecord request) {
        InteractiveState state = this.getInteractiveState();
        if (state != null) {
            state.onRequestStart(request);
        }
    }

    public InteractiveState getInteractiveState() {
        if (this.workflowSupportFragment == null) {
            this.workflowSupportFragment = new WorkflowSupportFragment();
            this.workflowSupportFragment.setApplicationContext((Context)this.contextWeakReference.get());
        }
        return this.workflowSupportFragment.getState();
    }

    public Object getBackingObject() {
        return this.contextWeakReference.get();
    }

    public Context getContext() {
        return (Context)this.contextWeakReference.get();
    }

    public boolean isHookNeededOnUIResume() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contextWeakReference == null || this.contextWeakReference.get() == null ? 0 : ((Context)this.contextWeakReference.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestSourceContextWrapper other = (RequestSourceContextWrapper)obj;
        if (this.contextWeakReference == null) {
            if (other.contextWeakReference != null) {
                return false;
            }
        } else {
            if (other.contextWeakReference == null) {
                return false;
            }
            if (this.contextWeakReference.get() == null ? other.contextWeakReference.get() != null : !((Context)this.contextWeakReference.get()).equals(other.contextWeakReference.get())) {
                return false;
            }
        }
        return true;
    }
}

