/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractOauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.endpoint.OauthTokenResponse;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OauthTokenRequest
extends AbstractOauthTokenRequest<OauthTokenResponse> {
    private static final String LOG_TAG = OauthTokenRequest.class.getName();
    protected static final String REFRESH_TOKEN_GRANT = "refresh_token";
    protected static final String REFRESH_TOKEN = "refresh_token";
    private final RefreshAtzToken mRefreshToken;

    OauthTokenRequest(Context context, RefreshAtzToken refreshToken, AppInfo appInfo) throws AuthError {
        super(context, appInfo);
        this.mRefreshToken = refreshToken;
    }

    @Override
    public String getGrantType() {
        return "refresh_token";
    }

    @Override
    protected OauthTokenResponse generateResponse(HttpResponse httpResponse) {
        return new OauthTokenResponse(httpResponse, this.getAppFamilyId(), null);
    }

    @Override
    protected List<Pair<String, String>> getExtraOauthTokenRequestParameters() {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(new Pair((Object)"refresh_token", (Object)this.mRefreshToken.toString()));
        return parameters;
    }

    @Override
    protected void logRequest() {
        MAPLog.pii(LOG_TAG, "Executing OAuth access token exchange. appId=" + this.getAppFamilyId(), "refreshAtzToken=" + this.mRefreshToken.toString());
    }
}

