/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractOauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.endpoint.OauthTokenResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OauthTokenForCodePairRequest
extends AbstractOauthTokenRequest<OauthTokenResponse> {
    private static final String LOG_TAG = OauthTokenForCodePairRequest.class.getName();
    private static final String USER_CODE_PARAM = "user_code";
    private static final String DEVICE_CODE_GRANT = "device_code";
    private final String mDeviceCode;
    private final String mUserCode;

    OauthTokenForCodePairRequest(String userCode, String deviceCode, AppInfo appInfo, Context context) throws AuthError {
        super(context, appInfo);
        this.mUserCode = userCode;
        this.mDeviceCode = deviceCode;
    }

    @Override
    public String getGrantType() {
        return DEVICE_CODE_GRANT;
    }

    @Override
    protected List<Pair<String, String>> getExtraOauthTokenRequestParameters() {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(new Pair((Object)DEVICE_CODE_GRANT, (Object)this.mDeviceCode));
        parameters.add(new Pair((Object)USER_CODE_PARAM, (Object)this.mUserCode));
        return parameters;
    }

    @Override
    protected void logRequest() {
        MAPLog.i(LOG_TAG, "Executing OAuth access token exchange. user code=" + this.mUserCode);
    }

    @Override
    protected OauthTokenResponse generateResponse(HttpResponse httpResponse) {
        return new OauthTokenResponse(httpResponse, this.getAppFamilyId(), null);
    }
}

