/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractOauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.endpoint.OauthCodeForTokenResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OauthCodeForTokenRequest
extends AbstractOauthTokenRequest<OauthCodeForTokenResponse> {
    private static final String LOG_TAG = OauthCodeForTokenRequest.class.getName();
    protected static final String AUTHORIZATION_CODE_GRANT = "authorization_code";
    protected static final String AUTHORIZATION_CODE_PARAM = "code";
    protected static final String REDIRECT_URI_PARAM = "redirect_uri";
    private final String mCode;
    private final String mRedirectUri;
    private final String mDirectedId;
    private final String mCodeVerifier;

    OauthCodeForTokenRequest(String code, String codeVerifier, String redirectUri, String directedId, AppInfo appInfo, Context context) throws AuthError {
        super(context, appInfo);
        this.mCode = code;
        this.mRedirectUri = redirectUri;
        this.mDirectedId = directedId;
        this.mCodeVerifier = codeVerifier;
    }

    @Override
    public String getGrantType() {
        return AUTHORIZATION_CODE_GRANT;
    }

    @Override
    protected OauthCodeForTokenResponse generateResponse(HttpResponse httpResponse) {
        return new OauthCodeForTokenResponse(httpResponse, this.getAppFamilyId(), this.mDirectedId);
    }

    @Override
    protected List<Pair<String, String>> getExtraOauthTokenRequestParameters() {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(new Pair((Object)AUTHORIZATION_CODE_PARAM, (Object)this.mCode));
        parameters.add(new Pair((Object)REDIRECT_URI_PARAM, (Object)this.mRedirectUri));
        parameters.add(new Pair((Object)"code_verifier", (Object)this.mCodeVerifier));
        return parameters;
    }

    @Override
    protected void logRequest() {
        MAPLog.pii(LOG_TAG, "Executing OAuth Code for Token Exchange. redirectUri=" + this.mRedirectUri + " appId=" + this.getAppFamilyId(), "code=" + this.mCode);
    }
}

