/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.text.TextUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse {
    private static final String LOG_TAG = HttpResponse.class.getSimpleName();
    private final int responseCode;
    private final String responseBody;
    private final Map<String, String> responseHeaders;

    public static HttpResponse readResponse(HttpsURLConnection httpsURLConnection) throws IOException {
        try {
            HttpResponse httpResponse = new HttpResponse(httpsURLConnection.getResponseCode(), HttpResponse.retrieveResponseBody(httpsURLConnection), HttpResponse.retrieveResponseHeaders(httpsURLConnection));
            return httpResponse;
        }
        finally {
            httpsURLConnection.disconnect();
        }
    }

    private HttpResponse(int responseCode, String responseBody, Map<String, String> responseHeaders) {
        this.responseCode = responseCode;
        this.responseBody = responseBody;
        this.responseHeaders = responseHeaders;
    }

    private static String retrieveResponseBody(HttpsURLConnection httpsURLConnection) {
        InputStream responseStream = null;
        try {
            responseStream = httpsURLConnection.getInputStream();
        }
        catch (IOException e) {
            responseStream = httpsURLConnection.getErrorStream();
        }
        if (responseStream == null) {
            return null;
        }
        String responseStr = HttpResponse.readInputStreamToString(responseStream);
        MAPLog.pii(LOG_TAG, "Response received", String.format("Request to %s received response %s", httpsURLConnection.getURL().toString(), responseStr));
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStreamToString(InputStream stream) {
        if (stream == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuilder response = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = "";
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, "Cannot parse response stream", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    MAPLog.e(LOG_TAG, "Cannot close BufferedReader", e);
                }
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                MAPLog.e(LOG_TAG, "Cannot close response stream", e);
            }
        }
        return response.toString();
    }

    private static Map<String, String> retrieveResponseHeaders(HttpURLConnection httpURLConnection) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            String headerValue = TextUtils.join((CharSequence)", ", (Iterable)entry.getValue());
            res.put(entry.getKey(), headerValue);
            MAPLog.pii(LOG_TAG, "Header from response: name=" + entry.getKey(), "val=" + headerValue);
        }
        return res;
    }

    public String getRedirectLocation() {
        return this.responseHeaders.get("Location");
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

