/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.CodePair;
import com.amazon.identity.auth.device.endpoint.AbstractJSONTokenResponse;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

class CreateCodePairResponse
extends AbstractJSONTokenResponse {
    private static final String LOG_TAG = CreateCodePairResponse.class.getName();
    private static final String USER_CODE = "user_code";
    private static final String DEVICE_CODE = "device_code";
    private static final String VERIFICATION_URI = "verification_uri";
    private static final String EXPIRES_IN = "expires_in";
    private static final String INTERVAL = "interval";
    private JSONObject mCreateCodePairResponse;
    private String mAppId;
    private String[] mScopeNames;

    public CreateCodePairResponse(HttpResponse httpResponse, String appId, String[] scopeNames) {
        super(httpResponse);
        this.mAppId = appId;
        this.mScopeNames = scopeNames;
    }

    protected JSONObject extractResponseJSONObject(JSONObject jsonObject) throws JSONException {
        try {
            return super.extractResponseJSONObject(jsonObject);
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "No Response type in the response");
            return jsonObject;
        }
    }

    protected void doParse(JSONObject jResponse) throws IOException, JSONException, AuthError {
        this.mCreateCodePairResponse = jResponse;
    }

    public CodePair getCodePair() throws AuthError {
        int interval;
        int expiresIn;
        String verificationUriString;
        String deviceCode;
        String userCode;
        try {
            userCode = this.mCreateCodePairResponse.getString(USER_CODE);
            deviceCode = this.mCreateCodePairResponse.getString(DEVICE_CODE);
            verificationUriString = this.mCreateCodePairResponse.getString(VERIFICATION_URI);
            expiresIn = this.mCreateCodePairResponse.getInt(EXPIRES_IN);
            interval = this.mCreateCodePairResponse.getInt(INTERVAL);
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Error reading JSON response, throwing AuthError", e);
            throw new AuthError("Error reading JSON response", AuthError.ERROR_TYPE.ERROR_JSON);
        }
        URI verificationUri = null;
        try {
            verificationUri = new URI(verificationUriString);
        }
        catch (URISyntaxException e) {
            MAPLog.e(LOG_TAG, "Error converting string to URI, throwing AuthError");
            throw new AuthError("Error converting string to URI", AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        Date creationTime = new Date();
        Date expirationTime = new Date(creationTime.getTime() + (long)(expiresIn * 1000));
        return new CodePair(this.mAppId, userCode, deviceCode, verificationUri, interval, creationTime, expirationTime, this.mScopeNames);
    }
}

