/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractPandaRequest;
import com.amazon.identity.auth.device.endpoint.Response;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOauthTokenRequest<T extends Response>
extends AbstractPandaRequest<T> {
    protected static final String OAUTH_END_POINT = "/auth/o2/token";
    protected static final String GRANT_TYPE_PARAM = "grant_type";
    private static final String APP_CLIENT_ID_PARAM = "client_id";
    private final String appFamilyId;
    private final String clientId;

    public AbstractOauthTokenRequest(Context context, AppInfo appInfo) throws AuthError {
        super(context, appInfo);
        if (appInfo == null) {
            throw new AuthError("Appinfo can not be null to make an OAuthTokenRequest", AuthError.ERROR_TYPE.ERROR_UNKNOWN);
        }
        this.appFamilyId = appInfo.getAppFamilyId();
        this.clientId = appInfo.getClientId();
    }

    @Override
    protected String getEndPoint() {
        return OAUTH_END_POINT;
    }

    protected abstract String getGrantType();

    protected abstract List<Pair<String, String>> getExtraOauthTokenRequestParameters();

    @Override
    protected List<Pair<String, String>> getExtraParameters() {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(new Pair((Object)GRANT_TYPE_PARAM, (Object)this.getGrantType()));
        parameters.add(new Pair((Object)APP_CLIENT_ID_PARAM, (Object)this.clientId));
        List<Pair<String, String>> extraParameters = this.getExtraOauthTokenRequestParameters();
        if (extraParameters != null) {
            parameters.addAll(extraParameters);
        }
        return parameters;
    }

    @Override
    protected List<Pair<String, String>> getExtraHeaders() {
        return new ArrayList<Pair<String, String>>();
    }

    protected String getAppFamilyId() {
        return this.appFamilyId;
    }
}

