/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidTokenAuthError;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.endpoint.Response;
import com.amazon.identity.auth.device.utils.NetworkUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractJSONTokenResponse
implements Response {
    private static final String LOG_TAG = AbstractJSONTokenResponse.class.getName();
    private static final String INVALID_TOKEN = "INVALID_TOKEN";
    private static final String JSON_MESSAGE_FIELD = "message";
    private static final String SERVER_ERROR = "ServerError";
    private static final String INVALID_SOURCE_TOKEN = "InvalidSourceToken";
    private static final String INVALID_TOKEN_CODE = "InvalidToken";
    private static final String JSON_CODE_FIELD = "code";
    protected static final String JSON_ERROR_FIELD = "error";
    private static final String FORCE_UPDATE_REQUESTED = "1";
    private static final String SERVER_ERROR_PAGE_IDENTIFIER = "!DOCTYPE html";
    private static final String DEFAULT_CHAR_SET = "UTF-8";
    protected static final String FORCE_UPDATE = "force_update";
    protected static final String TOKEN = "token";
    protected static final String COOKIE = "cookie";
    protected static final String RESPONSE = "response";
    public static final String REQUEST_ID = "request_id";
    private static final String REQUEST_ID_HEADER = "x-amzn-RequestId";
    public static final String VER_UNKOWN = "Unkown";
    public static final String EXPIRES_IN = "expires_in";
    public static final String TOKEN_EXPIRES_IN = "token_expires_in";
    public static final String TOKEN_TYPE = "token_type";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String REFRESH_TOKEN = "refresh_token";
    private final String responseBody;
    private final int responseCode;
    private final Map<String, String> responseHeaders;

    public AbstractJSONTokenResponse(HttpResponse httpResponse) {
        this.responseCode = httpResponse.getResponseCode();
        this.responseBody = httpResponse.getResponseBody();
        this.responseHeaders = httpResponse.getResponseHeaders();
    }

    protected JSONObject getJSONResponse() throws JSONException {
        MAPLog.pii(LOG_TAG, "Response Extracted", "response=" + this.responseBody);
        JSONObject jHttpResponse = new JSONObject(this.responseBody);
        JSONObject jResponse = this.extractResponseJSONObject(jHttpResponse);
        this.logRequestId(jHttpResponse);
        return jResponse;
    }

    protected JSONObject extractResponseJSONObject(JSONObject jsonObject) throws JSONException {
        return jsonObject.getJSONObject(RESPONSE);
    }

    protected void logRequestId(JSONObject jHttpResponse) {
        try {
            String requestId = jHttpResponse.getString(REQUEST_ID);
            MAPLog.i(LOG_TAG, "ExchangeResponse requestId from response body: " + requestId);
        }
        catch (JSONException e) {
            MAPLog.w(LOG_TAG, "No RequestId in JSON response");
        }
        MAPLog.i(LOG_TAG, "ExchangeResponse requestId from response header: " + this.responseHeaders.get(REQUEST_ID_HEADER));
    }

    public String getVersion() {
        return "3.5.6";
    }

    protected void handleForceUpdate(JSONObject jResponse) throws AuthError {
        block3: {
            String sForceUpdate = null;
            try {
                sForceUpdate = jResponse.getString(FORCE_UPDATE);
                if (sForceUpdate != null && sForceUpdate.equals(FORCE_UPDATE_REQUESTED)) {
                    String sVersion = this.getVersion();
                    MAPLog.e(LOG_TAG, "Force update requested ver:" + sVersion);
                    throw new AuthError("Server denied request, requested Force Update ver:" + sVersion, null, AuthError.ERROR_TYPE.ERROR_FORCE_UPDATE);
                }
            }
            catch (JSONException e) {
                if (TextUtils.isEmpty((CharSequence)sForceUpdate)) break block3;
                MAPLog.e(LOG_TAG, "JSON exception parsing force update response:" + e.toString());
                throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_JSON);
            }
        }
    }

    public void parse() throws AuthError {
        String additionalInfo = "";
        try {
            if (NetworkUtils.hasReceived500(this.responseCode)) {
                additionalInfo = "500 error (status=" + this.getStatusCode() + ")";
            }
            JSONObject jResponse = this.getJSONResponse();
            this.handleJSONError(jResponse);
            this.doParse(jResponse);
            this.handleForceUpdate(jResponse);
        }
        catch (JSONException e) {
            if (!TextUtils.isEmpty((CharSequence)this.responseBody) && this.responseBody.contains(SERVER_ERROR_PAGE_IDENTIFIER)) {
                MAPLog.e(LOG_TAG, "Server sending back default error page - BAD request");
                throw new AuthError("Server sending back default error page - BAD request", e, AuthError.ERROR_TYPE.ERROR_JSON);
            }
            MAPLog.w(LOG_TAG, "JSON exception parsing " + additionalInfo + " response:" + e.toString());
            MAPLog.w(LOG_TAG, "JSON exception html = " + this.responseBody);
            throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_JSON);
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, "Exception accessing " + additionalInfo + " response:" + e.toString());
            throw new AuthError(e.getMessage(), e, AuthError.ERROR_TYPE.ERROR_COM);
        }
    }

    protected abstract void doParse(JSONObject var1) throws IOException, JSONException, AuthError;

    protected void handleJSONError(JSONObject jResponse) throws AuthError, JSONException {
        block9: {
            JSONObject errorObject = null;
            try {
                errorObject = jResponse.getJSONObject(JSON_ERROR_FIELD);
                String sErrorCode = errorObject.getString(JSON_CODE_FIELD);
                if (SERVER_ERROR.equalsIgnoreCase(sErrorCode)) {
                    String sErrorMessage = errorObject.getString(JSON_MESSAGE_FIELD);
                    if (sErrorMessage.startsWith(INVALID_TOKEN)) {
                        throw new InvalidTokenAuthError("Invalid Exchange parameter - SERVER_ERROR.");
                    }
                    this.throwUnknownAuthError(sErrorCode);
                } else {
                    if (INVALID_SOURCE_TOKEN.equalsIgnoreCase(sErrorCode)) {
                        throw new InvalidTokenAuthError("Invalid Source Token in exchange parameter");
                    }
                    if (INVALID_TOKEN_CODE.equals(sErrorCode)) {
                        throw new InvalidTokenAuthError("Token used is invalid.");
                    }
                    if (NetworkUtils.hasReceived500(this.responseCode)) {
                        this.throwUnknownAuthError("500 error (status=" + this.getStatusCode() + ")" + sErrorCode);
                    } else {
                        this.throwUnknownAuthError(sErrorCode);
                    }
                }
            }
            catch (JSONException e) {
                if (errorObject == null) break block9;
                throw new AuthError("JSON exception parsing json error response:", e, AuthError.ERROR_TYPE.ERROR_JSON);
            }
        }
    }

    public void throwUnknownAuthError(String sErrorCode) throws AuthError {
        String error = String.format("Error code: %s Server response: %s", sErrorCode, this.responseBody);
        throw new AuthError("Server Error : " + error, AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
    }

    protected long getExpiresIn(JSONObject jResponse) {
        long expiresIn = 0L;
        try {
            if (jResponse.has(TOKEN_EXPIRES_IN)) {
                expiresIn = jResponse.getLong(TOKEN_EXPIRES_IN);
            } else if (jResponse.has(EXPIRES_IN)) {
                expiresIn = jResponse.getLong(EXPIRES_IN);
            } else {
                MAPLog.w(LOG_TAG, "Unable to find expiration time in JSON response, AccessToken will not expire locally");
            }
        }
        catch (JSONException e) {
            MAPLog.e(LOG_TAG, "Unable to parse expiration time in JSON response, AccessToken will not expire locally");
        }
        return expiresIn;
    }

    public int getStatusCode() {
        return this.responseCode;
    }
}

