/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.datastore.AbstractDataSource;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestedScopeDataSource
extends AbstractDataSource<RequestedScope> {
    private static final String LOG_TAG = RequestedScopeDataSource.class.getName();
    private static final String[] ALL_COLUMNS = RequestedScope.ALL_COLUMNS;
    private static RequestedScopeDataSource INSTANCE;

    private RequestedScopeDataSource(SQLiteDatabase database) {
        super(database);
    }

    public static synchronized RequestedScopeDataSource getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new RequestedScopeDataSource(MAPUtils.getMAPdatabase(context));
        }
        return INSTANCE;
    }

    public static void resetInstance() {
        INSTANCE = null;
        MAPUtils.resetDatabaseInstance();
    }

    public List<RequestedScope> findByScope(String scopeValue) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.SCOPE.colId], scopeValue);
    }

    public List<RequestedScope> findByAppFamilyId(String appFamilyId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.APP_FAMILY_ID.colId], appFamilyId);
    }

    public List<RequestedScope> findByDirectedId(String directedId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.DIRECTED_ID.colId], directedId);
    }

    public List<RequestedScope> findByAuthorizationAccessTokenId(long atzTokenId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.AUTHORIZATION_ACCESS_TOKEN_ID.colId], "" + atzTokenId);
    }

    public List<RequestedScope> findByAuthorizationRefreshTokenId(long atzTokenId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.AUTHORIZATION_REFRESH_TOKEN_ID.colId], "" + atzTokenId);
    }

    public RequestedScope findByPrimaryKey(String scopeValue, String appId, String directedId) {
        String[] selectionFields = new String[]{ALL_COLUMNS[RequestedScope.COL_INDEX.SCOPE.colId], ALL_COLUMNS[RequestedScope.COL_INDEX.APP_FAMILY_ID.colId], ALL_COLUMNS[RequestedScope.COL_INDEX.DIRECTED_ID.colId]};
        String[] selectionValues = new String[]{scopeValue, appId, directedId};
        return (RequestedScope)this.findOneRow(selectionFields, selectionValues);
    }

    public int deleteByScope(String scopeValue) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.SCOPE.colId], scopeValue);
    }

    public int deleteByAppFamilyId(String appFamilyId) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.APP_FAMILY_ID.colId], appFamilyId);
    }

    public int deleteByDirectedId(String directedId) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[RequestedScope.COL_INDEX.DIRECTED_ID.colId], directedId);
    }

    @Override
    public String getLogTag() {
        return LOG_TAG;
    }

    @Override
    public RequestedScope cursorToObject(Cursor cursor) {
        if (cursor == null || cursor.getCount() == 0) {
            return null;
        }
        try {
            RequestedScope to_return = new RequestedScope();
            to_return.setRowId(cursor.getLong(this.getColumnIndex(cursor, RequestedScope.COL_INDEX.ROW_ID.colId)));
            to_return.setScopeValue(cursor.getString(this.getColumnIndex(cursor, RequestedScope.COL_INDEX.SCOPE.colId)));
            to_return.setAppFamilyId(cursor.getString(this.getColumnIndex(cursor, RequestedScope.COL_INDEX.APP_FAMILY_ID.colId)));
            to_return.setDirectedId(cursor.getString(this.getColumnIndex(cursor, RequestedScope.COL_INDEX.DIRECTED_ID.colId)));
            to_return.setAuthorizationAccessTokenId(cursor.getLong(this.getColumnIndex(cursor, RequestedScope.COL_INDEX.AUTHORIZATION_ACCESS_TOKEN_ID.colId)));
            to_return.setAuthorizationRefreshTokenId(cursor.getLong(this.getColumnIndex(cursor, RequestedScope.COL_INDEX.AUTHORIZATION_REFRESH_TOKEN_ID.colId)));
            return to_return;
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getTableName() {
        return "RequestedScope";
    }

    @Override
    public String[] getAllColumns() {
        return ALL_COLUMNS;
    }
}

