/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.amazon.identity.auth.device.dataobject.CodePair;
import com.amazon.identity.auth.device.datastore.AbstractDataSource;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.device.utils.ScopeUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.net.URI;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodePairDataSource
extends AbstractDataSource<CodePair> {
    private static final String LOG_TAG = CodePairDataSource.class.getName();
    private static final String[] ALL_COLUMNS = CodePair.ALL_COLUMNS;
    private static CodePairDataSource INSTANCE;

    public CodePairDataSource(SQLiteDatabase database) {
        super(database);
    }

    public static synchronized CodePairDataSource getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new CodePairDataSource(MAPUtils.getMAPdatabase(context));
        }
        return INSTANCE;
    }

    public static void resetInstance() {
        INSTANCE = null;
        MAPUtils.resetDatabaseInstance();
    }

    @Override
    public String getLogTag() {
        return LOG_TAG;
    }

    @Override
    public CodePair cursorToObject(Cursor cursor) {
        if (cursor == null || cursor.getCount() == 0) {
            return null;
        }
        try {
            String appId = cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.APP_ID.colId));
            String userCode = cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.USER_CODE.colId));
            String deviceCode = cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.DEVICE_CODE.colId));
            String verificationUriString = cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.VERIFICATION_URI.colId));
            int interval = cursor.getInt(this.getColumnIndex(cursor, CodePair.COL_INDEX.INTERVAL.colId));
            Date creationTime = DatabaseHelper.parseDate(cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.CREATION_TIME.colId)));
            Date expirationTime = DatabaseHelper.parseDate(cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.EXPIRATION_TIME.colId)));
            URI verificationUri = new URI(verificationUriString);
            String scopesString = cursor.getString(this.getColumnIndex(cursor, CodePair.COL_INDEX.SCOPES.colId));
            String[] scopes = ScopeUtils.convertScopeStringToArray(scopesString);
            CodePair codePair = new CodePair(appId, userCode, deviceCode, verificationUri, interval, creationTime, expirationTime, scopes);
            codePair.setRowId(cursor.getLong(this.getColumnIndex(cursor, CodePair.COL_INDEX.ID.colId)));
            return codePair;
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getTableName() {
        return "CodePair";
    }

    @Override
    public String[] getAllColumns() {
        return ALL_COLUMNS;
    }
}

