/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import android.content.ContentValues;
import android.content.Context;
import android.text.TextUtils;
import com.amazon.identity.auth.device.dataobject.AbstractDataObject;
import com.amazon.identity.auth.device.datastore.CodePairDataSource;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.utils.ScopeUtils;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CodePair
extends AbstractDataObject {
    private static final String LOG_TAG = CodePair.class.getName();
    private final String mUserCode;
    private final String mDeviceCode;
    private final URI mVerificationUri;
    private final int mInterval;
    private final Date mCreationTime;
    private final Date mExpirationTime;
    private final String mAppId;
    private final String[] mScopes;
    public static final String[] ALL_COLUMNS = new String[]{"Id", "AppId", "UserCode", "DeviceCode", "VerificationUri", "Interval", "CreationTime", "ExpirationTime", "Scopes"};

    public CodePair(String appId, String userCode, String deviceCode, URI verficationUri, int interval, Date creationTime, Date expirationTime, String[] scopes) {
        this.mAppId = appId;
        this.mUserCode = userCode;
        this.mDeviceCode = deviceCode;
        this.mVerificationUri = verficationUri;
        this.mInterval = interval;
        this.mCreationTime = DatabaseHelper.truncateFractionalSeconds(creationTime);
        this.mExpirationTime = DatabaseHelper.truncateFractionalSeconds(expirationTime);
        this.mScopes = scopes;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public String getUserCode() {
        return this.mUserCode;
    }

    public String getDeviceCode() {
        return this.mDeviceCode;
    }

    public URI getVerificationUri() {
        return this.mVerificationUri;
    }

    public Date getCreationTime() {
        return this.mCreationTime;
    }

    public Date getExpirationTime() {
        return this.mExpirationTime;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public String[] getScopes() {
        return this.mScopes;
    }

    public ContentValues getValuesForInsert() {
        ContentValues to_return = new ContentValues();
        SimpleDateFormat dateFormat = DatabaseHelper.getDateFormat();
        to_return.put(ALL_COLUMNS[COL_INDEX.APP_ID.colId], this.mAppId);
        to_return.put(ALL_COLUMNS[COL_INDEX.USER_CODE.colId], this.mUserCode);
        to_return.put(ALL_COLUMNS[COL_INDEX.DEVICE_CODE.colId], this.mDeviceCode);
        to_return.put(ALL_COLUMNS[COL_INDEX.VERIFICATION_URI.colId], this.mVerificationUri.toString());
        to_return.put(ALL_COLUMNS[COL_INDEX.INTERVAL.colId], Integer.valueOf(this.mInterval));
        to_return.put(ALL_COLUMNS[COL_INDEX.CREATION_TIME.colId], dateFormat.format(this.mCreationTime));
        to_return.put(ALL_COLUMNS[COL_INDEX.EXPIRATION_TIME.colId], dateFormat.format(this.mExpirationTime));
        String mScopesString = ScopeUtils.convertScopeArrayToString(this.mScopes);
        to_return.put(ALL_COLUMNS[COL_INDEX.SCOPES.colId], mScopesString);
        return to_return;
    }

    public CodePairDataSource getDataSource(Context context) {
        return CodePairDataSource.getInstance(context);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CodePair) {
            CodePair codePair = (CodePair)obj;
            return TextUtils.equals((CharSequence)this.mAppId, (CharSequence)codePair.getAppId()) && TextUtils.equals((CharSequence)this.mUserCode, (CharSequence)codePair.getUserCode()) && TextUtils.equals((CharSequence)this.mDeviceCode, (CharSequence)codePair.getDeviceCode()) && this.areObjectsEqual(this.mVerificationUri, codePair.getVerificationUri()) && this.areObjectsEqual(this.mInterval, codePair.getInterval()) && this.areObjectsEqual(this.mCreationTime, codePair.getCreationTime()) && this.areObjectsEqual(this.mExpirationTime, codePair.getExpirationTime()) && this.areObjectsEqual(this.mScopes, codePair.getScopes());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum COL_INDEX {
        ID(0),
        APP_ID(1),
        USER_CODE(2),
        DEVICE_CODE(3),
        VERIFICATION_URI(4),
        INTERVAL(5),
        CREATION_TIME(6),
        EXPIRATION_TIME(7),
        SCOPES(8);

        public final int colId;

        private COL_INDEX(int colId) {
            this.colId = colId;
        }
    }
}

