/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization.api;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.authorization.AuthorizationManager;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.InternalAuthManager;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonAuthorizationManager {
    private static final String LOG_TAG = AmazonAuthorizationManager.class.getName();
    private String clientId;
    private final Context mContext;
    private static final ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();

    public AmazonAuthorizationManager(Context context, Bundle options) {
        AppInfo appInfo;
        MAPLog.pii(LOG_TAG, "AmazonAuthorizationManager:sdkVer=3.0.4 libVer=3.5.6", "options=" + options);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null!");
        }
        this.mContext = context;
        if (options == null) {
            MAPLog.i(LOG_TAG, "Options bundle is null");
        }
        if ((appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext)) == null || appInfo.getClientId() == null) {
            throw new IllegalArgumentException("Invalid API Key");
        }
        this.clientId = appInfo.getClientId();
        if (options != null) {
            AuthorizationManager.setSandboxMode(context, options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false));
        }
    }

    @Deprecated
    public Future<Bundle> authorize(String[] scopes, Bundle options, AuthorizationListener listener) {
        return InternalAuthManager.getInstance(this.mContext).authorize(null, this.mContext, scopes, options, listener);
    }

    @Deprecated
    public Future<Bundle> getToken(String[] scopes, APIListener listener) {
        return InternalAuthManager.getInstance(this.mContext).getToken(this.mContext, scopes, listener);
    }

    public String getAppId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getAppId");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getAppFamilyId();
    }

    public String getAppVariantId() throws AuthError {
        if (!this.isAPIKeyValid()) {
            throw new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED);
        }
        MAPLog.i(LOG_TAG, this.mContext.getPackageName() + " calling getAppId");
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.mContext.getPackageName(), this.mContext);
        if (appInfo == null) {
            return null;
        }
        return appInfo.getAppVariantId();
    }

    @Deprecated
    public String getClientId() {
        return InternalAuthManager.getInstance(this.mContext).getClientId();
    }

    @Deprecated
    public String getRedirectUri() throws AuthError {
        return InternalAuthManager.getInstance(this.mContext).getRedirectURI(this.mContext);
    }

    @Deprecated
    public Future<Bundle> clearAuthorizationState(APIListener listener) {
        return InternalAuthManager.getInstance(this.mContext).clearAuthorizationState(this.mContext, listener);
    }

    @Deprecated
    public Future<Bundle> getProfile(APIListener listener) {
        return InternalAuthManager.getInstance(this.mContext).getProfile(this.mContext, null, listener);
    }

    private boolean isAPIKeyValid() {
        return InternalAuthManager.getInstance(this.mContext).isAPIKeyValid(this.mContext);
    }
}

