/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.AbstractRequest;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.authorization.AuthorizeRequest;
import com.amazon.identity.auth.device.authorization.AuthorizationResponseProcessor;
import com.amazon.identity.auth.device.authorization.ThirdPartyAuthorizationHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import java.net.MalformedURLException;

public class AuthorizationRequest
extends AbstractRequest {
    private final String clientId;
    private final String[] scopes;
    private final Bundle options;
    private final AppInfo appInfo;
    private final AuthorizationListener listener;

    public AuthorizationRequest(AuthorizeRequest originalRequest, String clientId, String[] scopes, Bundle options, AppInfo appInfo, AuthorizationListener listener) {
        super(originalRequest);
        this.clientId = clientId;
        this.scopes = scopes;
        this.options = options;
        this.appInfo = appInfo;
        this.listener = listener;
        if (originalRequest != null) {
            this.options.putString("InteractiveRequestType", originalRequest.getRequestType());
        }
    }

    public String getUrl(Context context) throws AuthError {
        try {
            return ThirdPartyAuthorizationHelper.getOAuth2Url(context, context.getPackageName(), this.clientId, this.scopes, this.requestId, true, false, this.options, this.appInfo);
        }
        catch (MalformedURLException e) {
            throw new AuthError("MalformedURLException", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
    }

    public boolean handleResponse(Uri uri, Context context) {
        boolean returnAccessToken = this.originalRequest != null;
        AuthorizationResponseProcessor.handleResponse(context, uri, this.scopes, returnAccessToken, this.listener);
        return true;
    }
}

