/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.appid;

import android.content.Context;
import android.content.pm.PackageManager;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.utils.HashAlgorithm;
import com.amazon.identity.auth.device.utils.JSONUtils;
import com.amazon.identity.auth.device.utils.JWTDecoder;
import com.amazon.identity.auth.device.utils.PackageSignatureUtil;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class APIKeyDecoder {
    private static final String VER_1 = "1";
    private static final String VER_3 = "3";
    private static final String LOG_TAG = APIKeyDecoder.class.getName();
    private static final String FAILED_TO_DECODE = "Failed to decode: ";
    private static final char HASH_SEPARATOR = ':';
    private static final String EXPECTED_ISSUER = "Amazon";
    private static final String KEY_ISSUER = "iss";
    private static final String KEY_SIGNATURE_MD5 = "appsig";
    private static final String KEY_SIGNATURE_SHA256 = "appsigSha256";
    private static final String KEY_APP_ID = "appId";
    private static final String KEY_API_KEY_VER = "ver";
    private static final String KEY_CLIENT_ID = "clientId";
    private static final String KEY_PACKAGE_NAME = "pkg";
    private static final String KEY_SCOPES = "scopes";
    private static final String KEY_PERMISSIONS = "perm";
    private static final String KEY_APP_FAMILY_ID = "appFamilyId";
    private static final String KEY_APP_VARIANT_ID = "appVariantId";
    public static final String KEY_ENDPOINTS = "endpoints";
    public static final String KEY_AUTHORIZATION_HOST = "authz";
    public static final String KEY_EXCHANGE_HOST = "tokenExchange";
    private static final String HTTPS = "https";

    private APIKeyDecoder() throws Exception {
        throw new Exception("This class is not instantiable!");
    }

    public static AppInfo decode(String packageName, String apiKey, Context context) {
        return APIKeyDecoder.doDecode(packageName, apiKey, true, context);
    }

    static AppInfo doDecode(String packageName, String apiKey, boolean verifyPayload, Context context) {
        MAPLog.i(LOG_TAG, "Begin decoding API Key for packageName=" + packageName);
        JSONObject payload = new JWTDecoder().decode(apiKey);
        MAPLog.pii(LOG_TAG, "APIKey", "payload=" + payload);
        if (payload == null) {
            MAPLog.w(LOG_TAG, "Unable to decode APIKey for pkg=" + packageName);
            return null;
        }
        try {
            if (verifyPayload) {
                APIKeyDecoder.verifyPayload(packageName, payload, context);
            }
            return APIKeyDecoder.extractAppInfo(payload);
        }
        catch (SecurityException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (CertificateException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (JSONException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (IOException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (AuthError e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        MAPLog.w(LOG_TAG, "Unable to decode APIKey for pkg=" + packageName);
        return null;
    }

    public static AppInfo extractAppInfo(JSONObject payload) throws JSONException, AuthError {
        String clientId;
        String version = payload.getString(KEY_API_KEY_VER);
        String appFamilyId = null;
        String appVariantId = null;
        String authzHost = null;
        String exchangeHost = null;
        if (version.equals(VER_1)) {
            appVariantId = appFamilyId = payload.getString(KEY_APP_ID);
        } else {
            appFamilyId = payload.getString(KEY_APP_FAMILY_ID);
            appVariantId = payload.getString(KEY_APP_VARIANT_ID);
        }
        if (version.equals(VER_3)) {
            JSONObject endPointsObject = null;
            try {
                endPointsObject = payload.getJSONObject(KEY_ENDPOINTS);
            }
            catch (JSONException jsone) {
                MAPLog.w(LOG_TAG, "APIKey does not contain endpoints object");
            }
            if (endPointsObject != null) {
                authzHost = endPointsObject.getString(KEY_AUTHORIZATION_HOST);
                exchangeHost = endPointsObject.getString(KEY_EXCHANGE_HOST);
                if (authzHost != null && !authzHost.startsWith(HTTPS)) {
                    throw new AuthError("Authorization Host in APIKey is invalid", AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
                }
                if (exchangeHost != null && !exchangeHost.startsWith(HTTPS)) {
                    throw new AuthError("Exchange Host in APIKey is invalid", AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
                }
            }
        }
        String packageName = payload.getString(KEY_PACKAGE_NAME);
        String[] allowedScopes = JSONUtils.getStringArray(payload, KEY_SCOPES);
        try {
            clientId = payload.getString(KEY_CLIENT_ID);
        }
        catch (JSONException jsone) {
            MAPLog.w(LOG_TAG, "APIKey does not contain a client id");
            clientId = null;
        }
        String[] grantedPermissions = JSONUtils.getStringArray(payload, KEY_PERMISSIONS);
        return new AppInfo(appFamilyId, appVariantId, packageName, allowedScopes, grantedPermissions, clientId, authzHost, exchangeHost, payload);
    }

    private static void verifyPayload(String packageName, JSONObject payload, Context context) throws SecurityException, JSONException, PackageManager.NameNotFoundException, CertificateException, NoSuchAlgorithmException, IOException {
        MAPLog.i(LOG_TAG, "verifyPayload for packageName=" + packageName);
        if (!payload.getString(KEY_ISSUER).equals(EXPECTED_ISSUER)) {
            throw new SecurityException("Decoding fails: issuer (" + payload.getString(KEY_ISSUER) + ") is not = " + EXPECTED_ISSUER + " pkg=" + packageName);
        }
        if (packageName != null && !packageName.equals(payload.getString(KEY_PACKAGE_NAME))) {
            throw new SecurityException("Decoding fails: package names don't match! - " + packageName + " != " + payload.getString(KEY_PACKAGE_NAME));
        }
        if (payload.has(KEY_SIGNATURE_MD5)) {
            String signatureMd5FromAPIKey = payload.getString(KEY_SIGNATURE_MD5);
            MAPLog.pii(LOG_TAG, "Validating MD5 signature in API key", String.format("pkg = %s and signature %s", packageName, signatureMd5FromAPIKey));
            APIKeyDecoder.verifySignature(signatureMd5FromAPIKey, packageName, HashAlgorithm.MD5, context);
        }
        if (payload.has(KEY_SIGNATURE_SHA256)) {
            String signatureSha256FromAPIKey = payload.getString(KEY_SIGNATURE_SHA256);
            MAPLog.pii(LOG_TAG, "Validating SHA256 signature in API key", String.format("pkg = %s and signature %s", packageName, signatureSha256FromAPIKey));
            APIKeyDecoder.verifySignature(signatureSha256FromAPIKey, packageName, HashAlgorithm.SHA_256, context);
        }
    }

    private static void verifySignature(String signatureFromAPIKey, String packageName, HashAlgorithm hashAlgorithm, Context context) {
        if (signatureFromAPIKey == null) {
            MAPLog.d(LOG_TAG, "App Signature is null. pkg=" + packageName);
            throw new SecurityException("Decoding failed: certificate fingerprint can't be verified! pkg=" + packageName);
        }
        String signature = signatureFromAPIKey.replace(":", "");
        List<String> signaturesFromAndroid = PackageSignatureUtil.getAllSignaturesFor(packageName, hashAlgorithm, context);
        MAPLog.i(LOG_TAG, "Number of signatures = " + signaturesFromAndroid.size());
        MAPLog.pii(LOG_TAG, "Fingerprint checking", signaturesFromAndroid.toString());
        if (!signaturesFromAndroid.contains(signature.toLowerCase(Locale.US))) {
            throw new SecurityException("Decoding failed: certificate fingerprint can't be verified! pkg=" + packageName);
        }
    }
}

