/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageButton;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.HashMap;
import java.util.Map;

public class SignInButton
extends ImageButton {
    private static final String LOG_TAG = SignInButton.class.getName();
    private static final String BUTTON_IMAGE_PREFIX = "btnlwa";
    private static final String BUTTON_PRESSED_SUFFIX = "pressed";
    private static final Map<String, Integer> resourceIdCache = new HashMap<String, Integer>();
    private Style style = Style.LOGIN_WITH_AMAZON;
    private Color color = Color.GOLD;

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.updateImage();
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        this.updateImage();
    }

    private void updateImage() {
        this.setImageResource(this.getResourceIdForCurrentState());
    }

    private int getResourceIdForCurrentState() {
        String resourceName = this.getButtonNameForCurrentState();
        Integer resourceId = resourceIdCache.get(resourceName);
        if (resourceId == null) {
            String fullResourceName = String.format("%s:drawable/%s", this.getContext().getPackageName(), resourceName);
            resourceId = this.getResources().getIdentifier(fullResourceName, null, null);
            if (resourceId != 0) {
                resourceIdCache.put(resourceName, resourceId);
            } else {
                MAPLog.e(LOG_TAG, "Could not find the resource ID for the image named \"" + resourceName + "\". It must be added to the drawables resources  (" + this.getButtonDescription() + ")");
            }
        }
        return resourceId;
    }

    private String getButtonNameForCurrentState() {
        StringBuilder builder = new StringBuilder();
        builder.append(BUTTON_IMAGE_PREFIX);
        builder.append("_");
        builder.append(this.color.name);
        builder.append("_");
        builder.append(this.style.name);
        if (this.isPressed()) {
            builder.append("_");
            builder.append(BUTTON_PRESSED_SUFFIX);
        }
        return builder.toString();
    }

    private String getButtonDescription() {
        return String.format("Button configuration = { style:%s color:%s pressed:%b }", this.style.toString(), this.color.toString(), this.isPressed());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Color {
        GOLD("gold"),
        GRAY("gry"),
        DARK_GRAY("dark_gray");

        private final String name;

        private Color(String name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        A_WITH_SMILE("a"),
        LOGIN("login"),
        LOGIN_WITH_AMAZON("loginwithamazon");

        private final String name;

        private Style(String name) {
            this.name = name;
        }
    }
}

