/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.content.Context;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.authorization.CodePairManager;
import com.amazon.identity.auth.device.api.authorization.GetTokenListener;
import com.amazon.identity.auth.device.api.authorization.GetTokenResult;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.dataobject.CodePair;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;

public class PollingTask
implements Runnable {
    private static final String LOG_TAG = PollingTask.class.getName();
    private ServerCommunication mServerCommunication;
    private GetTokenListener mListener;
    private CodePair mCodePair;
    private ScheduledExecutorService mExecutorService;
    private Context mContext;
    private AppInfo mAppInfo;
    private String mScopeString;

    public PollingTask(ServerCommunication serverCommunication, GetTokenListener listener, CodePair codePair, ScheduledExecutorService executorService, Context context, AppInfo appinfo, String scopeString) {
        this.mServerCommunication = serverCommunication;
        this.mListener = listener;
        this.mCodePair = codePair;
        this.mExecutorService = executorService;
        this.mContext = context;
        this.mAppInfo = appinfo;
        this.mScopeString = scopeString;
    }

    public void run() {
        MAPLog.i(LOG_TAG, "Start polling for the token");
        if (CodePairManager.hasCodePairExpired(this.mCodePair.getExpirationTime())) {
            MAPLog.e(LOG_TAG, "Code Pair has already expired");
            this.mListener.onError(new AuthError("Code Pair has already expired", AuthError.ERROR_TYPE.ERROR_BAD_PARAM));
            this.mExecutorService.shutdownNow();
            return;
        }
        AuthorizationToken[] tokens = null;
        try {
            tokens = this.mServerCommunication.getTokensFromCodePair(this.mCodePair.getUserCode(), this.mCodePair.getDeviceCode(), this.mContext, this.mAppInfo);
        }
        catch (AuthError e) {
            MAPLog.i(LOG_TAG, "Code Pair has not been authorized, wait for " + this.mCodePair.getInterval() + " seconds to call the getToken API again");
            return;
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, "Failed to communicate with server", e);
            this.mListener.onError(new AuthError("Failed to communicate with server", AuthError.ERROR_TYPE.ERROR_IO));
            this.mExecutorService.shutdownNow();
        }
        AuthorizationToken accessToken = tokens[0];
        AuthorizationToken refreshToken = tokens[1];
        MAPLog.i(LOG_TAG, "Get the tokens from Code Pair successfully, update the database now");
        if (accessToken.insert(this.mContext) == -1L) {
            this.mListener.onError(new AuthError("Failed to insert Access Token", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE));
            this.mExecutorService.shutdownNow();
            return;
        }
        MAPLog.i(LOG_TAG, "Insert new access token successfully");
        if (refreshToken.insert(this.mContext) == -1L) {
            MAPLog.i(LOG_TAG, "Failed to insert Refresh token");
            if (accessToken.delete(this.mContext)) {
                MAPLog.i(LOG_TAG, "Deleted the access token!");
            } else {
                this.mListener.onError(new AuthError("Failed to delete access token in db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE));
            }
            this.mListener.onError(new AuthError("Failed to insert Refresh Token", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE));
            this.mExecutorService.shutdownNow();
            return;
        }
        MAPLog.i(LOG_TAG, "Insert new refresh token successfully");
        RequestedScope requestedScope = new RequestedScope(this.mScopeString, this.mAppInfo.getAppFamilyId(), null, accessToken.getRowId(), refreshToken.getRowId());
        if (requestedScope.insert(this.mContext) == -1L) {
            this.mListener.onError(new AuthError("Failed to insert Requested Scope", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE));
            this.mExecutorService.shutdownNow();
            return;
        }
        MAPLog.i(LOG_TAG, "Insert new requestedScope successfully");
        this.mListener.onSuccess(new GetTokenResult(accessToken.getTokenValue()));
        this.mExecutorService.shutdown();
    }
}

