/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.amazon.identity.auth.device.api.authorization.User;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;

public final class AuthorizeResult
implements Parcelable {
    private String accessToken;
    private String authorizationCode;
    private User user;
    private String clientId;
    private String redirectURI;
    public static final Parcelable.Creator<AuthorizeResult> CREATOR = new Parcelable.Creator<AuthorizeResult>(){

        public AuthorizeResult createFromParcel(Parcel in) {
            return new AuthorizeResult(in);
        }

        public AuthorizeResult[] newArray(int size) {
            return new AuthorizeResult[size];
        }
    };

    AuthorizeResult(Bundle bundle) {
        this(bundle, null);
    }

    AuthorizeResult(Bundle bundle, User user) {
        this.accessToken = bundle.getString(AuthzConstants.BUNDLE_KEY.TOKEN.val);
        this.authorizationCode = bundle.getString(AuthzConstants.BUNDLE_KEY.AUTHORIZATION_CODE.val);
        this.clientId = bundle.getString(AuthzConstants.BUNDLE_KEY.CLIENT_ID.val);
        this.redirectURI = bundle.getString(AuthzConstants.BUNDLE_KEY.REDIRECT_URI.val);
        this.user = user;
    }

    private AuthorizeResult(Parcel in) {
        this.accessToken = in.readString();
        this.authorizationCode = in.readString();
        this.user = (User)in.readParcelable(User.class.getClassLoader());
        this.clientId = in.readString();
        this.redirectURI = in.readString();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public User getUser() {
        return this.user;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessToken == null ? 0 : this.accessToken.hashCode());
        result = 31 * result + (this.authorizationCode == null ? 0 : this.authorizationCode.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.redirectURI == null ? 0 : this.redirectURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizeResult other = (AuthorizeResult)obj;
        if (this.accessToken == null ? other.accessToken != null : !this.accessToken.equals(other.accessToken)) {
            return false;
        }
        if (this.authorizationCode == null ? other.authorizationCode != null : !this.authorizationCode.equals(other.authorizationCode)) {
            return false;
        }
        if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        return !(this.redirectURI == null ? other.redirectURI != null : !this.redirectURI.equals(other.redirectURI));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.accessToken);
        dest.writeString(this.authorizationCode);
        dest.writeParcelable((Parcelable)this.user, flags);
        dest.writeString(this.clientId);
        dest.writeString(this.redirectURI);
    }
}

