/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device;

import android.content.Context;
import android.net.Uri;
import com.amazon.identity.auth.device.AbstractRequest;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.ExternalBrowserManager;
import com.amazon.identity.auth.device.ResponseManager;
import com.amazon.identity.auth.device.api.workflow.RequestContext;
import com.amazon.identity.auth.device.endpoint.ResponseUri;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RequestManager {
    public static final String STATE_PARAMETER_NAME = "state";
    public static final String REQUEST_ID_FIELD = "clientRequestId";
    private static final String LOG_TAG = RequestManager.class.getName();
    private static final int MAX_ACTIVE_REQUESTS = 10;
    private final Map<String, AbstractRequest> activeRequests = Collections.synchronizedMap(new LinkedHashMap(10));
    private final ExternalBrowserManager externalBrowserManager;
    private static RequestManager INSTANCE = null;

    public RequestManager(ExternalBrowserManager externalBrowserManager) {
        this.externalBrowserManager = externalBrowserManager;
    }

    private RequestManager() {
        this(new ExternalBrowserManager());
    }

    public static synchronized RequestManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RequestManager();
        }
        return INSTANCE;
    }

    public static void setInstance(RequestManager requestManager) {
        INSTANCE = requestManager;
    }

    public void executeRequest(AbstractRequest request, Context context) throws AuthError {
        MAPLog.d(LOG_TAG, "Executing request " + request.getRequestId());
        if (!request.canAttempt()) {
            throw new AuthError(String.format("Reached maximum attempts for the request: %s", request.getRequestId()), AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        request.incrementAttemptCount();
        this.cleanupOldActiveRequests();
        this.activeRequests.put(request.getRequestId(), request);
        this.externalBrowserManager.openUrl(request, request.getUrl(context), context);
    }

    public boolean handleResponse(Uri uri, Context context) throws AuthError {
        return this.handleResponse(uri, context, null);
    }

    public boolean handleResponse(Uri uri, Context context, RequestContext requestContext) throws AuthError {
        String requestId = RequestManager.getRequestIdFromResponseUri(uri);
        MAPLog.pii(LOG_TAG, "Handling response for request " + requestId, "uri=" + uri.toString());
        AbstractRequest request = this.activeRequests.remove(requestId);
        if (request != null) {
            if (requestContext != null) {
                request.getOriginalRequest().setRequestContext(requestContext);
            }
            if (!request.handleResponse(uri, context)) {
                MAPLog.d(LOG_TAG, "Retrying request " + requestId);
                this.executeRequest(request, context);
            }
            return true;
        }
        return false;
    }

    public RequestContext getRequestContextForRequest(String requestId) {
        AbstractRequest request = this.activeRequests.get(requestId);
        if (request == null) {
            return null;
        }
        if (request.getOriginalRequest() == null) {
            return null;
        }
        return request.getOriginalRequest().getRequestContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOldActiveRequests() {
        while (this.activeRequests.size() >= 10) {
            Map<String, AbstractRequest> map = this.activeRequests;
            synchronized (map) {
                String requestId = this.activeRequests.keySet().iterator().next();
                MAPLog.d(LOG_TAG, "Purging active request " + requestId);
                this.activeRequests.remove(requestId);
                ResponseManager.getInstance().removePendingResponse(requestId);
            }
        }
    }

    public static String getRequestIdFromResponseUri(Uri uri) throws AuthError {
        Map<String, String> stateValues = new ResponseUri(uri).getStateValues();
        String requestId = stateValues.get(REQUEST_ID_FIELD);
        if (requestId == null) {
            throw new AuthError(String.format("Response does not have a requestId: %s", uri.toString()), AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        return requestId;
    }

    public static boolean isInteractiveRequest(Uri uri) throws AuthError {
        Map<String, String> stateValues = new ResponseUri(uri).getStateValues();
        String requestType = stateValues.get("InteractiveRequestType");
        return requestType != null;
    }
}

