/*
 * Decompiled with CFR 0.152.
 */
package com.thedamfr.android.BleEventAdapter.service.gatt;

import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import com.thedamfr.android.BleEventAdapter.BleEventAdapter;
import com.thedamfr.android.BleEventAdapter.BleEventBus;
import com.thedamfr.android.BleEventAdapter.events.CharacteristicChangedEvent;
import com.thedamfr.android.BleEventAdapter.events.CharacteristicReadEvent;
import com.thedamfr.android.BleEventAdapter.events.CharacteristicWriteEvent;
import com.thedamfr.android.BleEventAdapter.events.DescriptorReadEvent;
import com.thedamfr.android.BleEventAdapter.events.DescriptorWriteEvent;
import com.thedamfr.android.BleEventAdapter.events.DiscoveryServiceEvent;
import com.thedamfr.android.BleEventAdapter.events.GattConnectionStateChangedEvent;
import com.thedamfr.android.BleEventAdapter.events.ReadRemoteRssiEvent;
import com.thedamfr.android.BleEventAdapter.events.ReliableWriteCompleted;
import com.thedamfr.android.BleEventAdapter.events.ServiceDiscoveredEvent;

public class GattService
extends Service {
    private BleEventBus mBleEventBus;
    private BluetoothGatt mBluetoothGatt;
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private BluetoothDevice mDevice;
    private BluetoothGattCallback mGattCallBack = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            super.onConnectionStateChange(gatt, status, newState);
            GattService.this.mBleEventBus.post(new GattConnectionStateChangedEvent(GattService.this.mBluetoothGatt, status, newState));
            if (newState == 2) {
                GattService.this.mBluetoothGatt.discoverServices();
                GattService.this.mBleEventBus.post(new DiscoveryServiceEvent(1));
            } else if (newState == 0) {
                // empty if block
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            super.onServicesDiscovered(gatt, status);
            GattService.this.mBleEventBus.post(new ServiceDiscoveredEvent(GattService.this.mBluetoothGatt, status));
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicRead(gatt, characteristic, status);
            GattService.this.mBleEventBus.post(new CharacteristicReadEvent(GattService.this.mBluetoothGatt, characteristic, status));
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            super.onCharacteristicWrite(gatt, characteristic, status);
            GattService.this.mBleEventBus.post(new CharacteristicWriteEvent(GattService.this.mBluetoothGatt, characteristic, status));
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            super.onCharacteristicChanged(gatt, characteristic);
            GattService.this.mBleEventBus.post(new CharacteristicChangedEvent(GattService.this.mBluetoothGatt, characteristic));
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorRead(gatt, descriptor, status);
            GattService.this.mBleEventBus.post(new DescriptorReadEvent(GattService.this.mBluetoothGatt, descriptor, status));
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            super.onDescriptorWrite(gatt, descriptor, status);
            GattService.this.mBleEventBus.post(new DescriptorWriteEvent(GattService.this.mBluetoothGatt, descriptor, status));
        }

        public void onReliableWriteCompleted(BluetoothGatt gatt, int status) {
            super.onReliableWriteCompleted(gatt, status);
            GattService.this.mBleEventBus.post(new ReliableWriteCompleted(GattService.this.mBluetoothGatt, status));
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
            super.onReadRemoteRssi(gatt, rssi, status);
            GattService.this.mBleEventBus.post(new ReadRemoteRssiEvent(GattService.this.mBluetoothGatt, rssi, status));
        }
    };

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mBleEventBus = BleEventBus.getInstance();
        this.mDevice = BleEventAdapter.getInstance().getBluetoothDevice();
        if (this.mBluetoothGatt == null || this.mBluetoothGatt.connect()) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    GattService.this.mBluetoothGatt = GattService.this.mDevice.connectGatt((Context)GattService.this, false, GattService.this.mGattCallBack);
                }
            }, 500L);
        }
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.close();
            this.mBluetoothGatt = null;
        }
    }
}

