/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/**
 * @file nmn1000_app.c
 * @brief The nmn1000_app.c file implements the component library  example application for nmh1000 sensor
 */

//-----------------------------------------------------------------------
// SDK Includes
//-----------------------------------------------------------------------
#include "board.h"
#include "pin_mux.h"
#include "clock_config.h"
#include "fsl_debug_console.h"

#include "nmh1000_driver.h"
#include "frdm_ke15z.h"


//-----------------------------------------------------------------------
// Global Variables
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
// Functions
//-----------------------------------------------------------------------

/*! -----------------------------------------------------------------------
 *  @brief       This is the The main function implementation.
 *  @details     This function invokes board initializes routines, then then brings up the sensor and
 *               finally enters an endless loop to continuously read available samples.
 *  @param[in]   void This is no input parameter.
 *  @return      void  There is no return value.
 *  @constraints None
 *  @reentrant  No
 *  -----------------------------------------------------------------------*/
int main(void)
{
    /*! Initialize the MCU hardware. */
    BOARD_InitPins();
    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();

    uint8_t magData = 0;

    nmh1000_driver_t driver;


    PRINTF("\r\n NMH1000 Sensor Example with I2C communication !\r\n");\
    if(SENSOR_SUCCESS != nmh1000_init(&driver))
    {
    	PRINTF("\r\n NMH1000 Initialization failed: Check the connection !\r\n");
    	return 1;
    }

    // set the odr
    nmh1000_write_reg(&driver, NMH1000_ODR, 0x2);
    // active the device in auto mode
    nmh1000_write_reg(&driver, NMH1000_CONTROL_REG1, 0x08);


	for(;;) /* Forever loop */
	{
		// get the mag output data
		nmh1000_get_magnetic_data(&driver, &magData);
		PRINTF("\r\n magnetic data output =  %d\r\n", magData);

	}

}
