/*******************************************************************************
 * This software is provided AS IS and without warranty of any kind. 
 * Your right to use this software is subject to separate terms and conditions entered between you and NXP.
 * If you have not entered into such terms, you have no license rights to use the code.
 * Copyright 2012-2016 Freescale Semiconductor, Inc.
 * Copyright 2017~2019 NXP.
 * All rights reserved.
*******************************************************************************/
/*******************************************************************************
*
* File Name: appconfig.h
*
* Description: file for static configuration of the application
*              (initial values, interrupt vectors)
*
*****************************************************************************/

#ifndef __APPCONFIG_H
#define __APPCONFIG_H

/*.*************************************************************************
*
*  File generated by Graphical Configuration Tool Thu, 27/Dec/2018, 15:45:23
*
****************************************************************************.*/

#define WCT1013A
#define EXTCLK 8000000L
#define EXTAL 8000000L
#define APPCFG_DFLTS_OMITTED 1
#define APPCFG_GCT_VERSION 0x02062200L

/*.
    OCCS Configuration
--------------------------------------------
    Use Factory Trim Value: No 
    Temperature trim value for 8 MHz oscillator: 0
    Enable internal 32 kHz oscillator: No 
    Power Down crystal oscillator: No 
    Core frequency: 100 MHz 
    VCO frequency: 400 MHz 
    Loss of lock interrupt 0: Disable 
    Loss of lock interrupt 1: Disable 
    Loss of reference clock Interrupt: Disable
.*/
#define OCCS_CTRL_INIT                    0x0081U
#define OCCS_DIVBY_INIT                   0x2031U
#define OCCS_OSCTL1_INIT                  0x2220U
#define OCCS_USE_FACTORY_TRIM             1
#define OCCS_OSCTL2_INIT                  0x8100U

/*.
    COP Configuration
--------------------------------------------
    COP clock source: Relaxation oscilator 
    COP operation: Disable
    COP timeout: 8.38848 sec 
    COP Runs in Stop Mode: No 
    COP Runs in Wait Mode: No 
    COP Write Protect: No 
    Enable Loss of Clock COP: No 
    Enable COP Warning Interrupt: No 
    COP Warning Interrupt Timeout: 32.64 ms
.*/
#define COP_COPCTL_INIT                   0x0300U

/*.
    SYS Configuration
--------------------------------------------
    SIM: Power Saving Modes: Stop enabled 
    Wait enabled 
         OnCE clock to processor core: Enabled when core TAP enabled 
    DMA Enable in RUN and WAIT modes: DMA enabled in all power modes 
    Enable External Reset Input Filter : No , SIM - Clock on GPIO: Enable CLKO_0: No 
    SIM - Clock on GPIO: Enable CLKO_1: No 
    SIM - Peripheral Clock Enable: GPIO G: No , GPIO F: Yes, GPIO E: Yes, GPIO D: No , GPIO C: Yes, GPIO B: No , GPIO A: No , TMR A0: Yes
                                   TMR A1: Yes, TMR A2: No , TMR A3: No , TMR B0: No , TMR B1: No , TMR B2: No , TMR B3: No , DAC: No 
                                   SCI0: Yes, SCI1: No , QSPI0: No , QSPI1: No , IIC0: No , IIC1: No , FLEXCAN: No 
                                   CMP A: No , CMP B: No , CMP C: No , CMP D: No , SAR ADC: No , CYC ADC: No , CRC: No , QDC (ENC): No , PIT0: No , PIT1: No , PDB0: No , PDB1: No 
                                   PWMCH0: No , PWMCH1: No , PWMCH2: No , PWMCH3: No 
                                   PWMBCH0: No , PWMBCH1: No , PWMBCH2: No , PWMBCH3: No , SIM - Modules Enabled in Stop: GPIO G: No 
    SIM - Modules Enabled in Stop: GPIO F: No , GPIO E: No , GPIO D: No , GPIO C: No , GPIO B: No , GPIO A: No 
                                   TMR A0: No , TMR A1: No , TMR A2: No , TMR A3: No , TMR B0: No , TMR B1: No , TMR B2: No , TMR B3: No , DAC: No 
                                   SCI0: No , SCI1: No , QSPI0: No , QSPI1: No , IIC0: No , IIC1: No , FLEXCAN: No 
                                   CMP A: No , CMP B: No , CMP C: No , CMP D: No , SAR ADC: No , CYC ADC: No , CRC: No , QDC (ENC): No , PIT0: No , PIT1: No , PDB0: No , PDB1: No 
                                   PWMCH0: No , PWMCH1: No , PWMCH2: No , PWMCH3: No 
                                   PWMBCH0: No , PWMBCH1: No , PWMBCH2: No , PWMBCH3: No 
    Protection of IPS and GPSxx  : Registers not protected 
    Protection of PCE, SD and PCR: Registers not protected 
    Protection of GPIO Port D: Registers not protected 
    Protection of PWRMODE: Registers not protected 
    GPIO Peripheral select registers (GPSn): ANA0/CMPA3 
                                             ANC13 
                                             ANC14 
                                             ANC15 
                                             EXTAL 
                                             TXD0 
                                             RXD0 
                                             TA1 
                                             DACO 
                                             TA2 
                                             SS0_B 
                                             MISO0 
                                             SCLK0 
                                             MOSI0 
                                             CANTX 
                                             CANRX 
                                             TA3 
                                             SDA0 
                                             SCL0 
                                             RXD2 
                                             TXD2 
                                             XB_OUT11 
                                             PWMA_2B 
                                             PWMA_2A 
                                             PWMA_3B 
                                             PWMA_3A 
                                             PWMB_2B 
                                             PWMB_2A 
                                             XB_IN6 
                                             CLKO_1 
                                             SCL1 
                                             SDA1 
                                             TXD1 
                                             RXD1 
                                             TB2 
                                             TB3 
                                             RXD0 
                                             RXD2 
                                             TXD2 
                                             TXD0 
                                             MISO1 
                                             MOSI1 
                                             SCLK1 
                                             RXD0 
                                             PWMB_1B 
                                             PWMB_1A 
                                             PWMB_0B 
                                             PWMB_0A 
                                             PWMB_3B 
                                             PWMB_3A 
                                             PWMA_FAULT4 
                                             PWMA_FAULT5 
                                             PWMB_0X 
                                             PWMB_1X 
                                             PWMB_2X 
                                             TB3 
    Internal Peripheral Select Register 0 (IPS0): GPIO C3 
                                                  GPIO C4 
                                                  GPIO C6/G8 
                                                  GPIO C13/G9 
                                                  GPIO C2 
                                                  GPIO F8 
                                                  GPIO F6/F0/G6 
                                                  GPIO F7/G11 
                                                  FAULT0 input pin (GPIO E8) 
                                                  FAULT1 input pin (GPIO E9) 
                                                  FAULT2 input pin (GPIO G4) 
                                                  FAULT3 input pin (GPIO G5) 
                                                  FAULT0 input pin (GPIO F14) 
                                                  FAULT1 input pin (GPIO F13) 
                                                  FAULT2 input pin (GPIO F12) 
    Miscellaneous Register 0 (SIM_MISC0): CLKIN0 (GPIOC0 alt1) 
                                          PIT0 master, PIT1 slave 
    SIM - Interrupts: Low voltage 2.2V: Disable
                      Low voltage 2.7V: Disable
                      High voltage 2.2V: Disable
                      High voltage 2.7V: Disable
    Enable Voltage Reference Buffer: No 
    Bandgap trim: 7, Use Factory Trim Value: No 
    Power Control: Large Regulator Standby mode: Normal 
                   Small Regulator 2.7 V Supply Standby mode: Normal 
                   Small Regulator 2.7 V Supply Powerdown mode: Normal 
                   Small Regulator 1.2 V Supply Standby mode: Normal
.*/
#define SIM_CLKOSR_INIT                   0x1020U
#define SIM_GPSCL_INIT                    0x0080U
#define SIM_PCE0_INIT                     0xC016U
#define SIM_PCE1_INIT                     0x1000U
#define SIM_PCE2_INIT                     0x0000U
#define SIM_PCE3_INIT                     0x0000U

/*.
    QT_A0 Configuration
--------------------------------------------
    Count mode: Stop mode, no operation 
    Timer Channel Enabled (counter starts counting immediatelly after initialized): Yes
    Input polarity: True , Output polarity: True 
    Input capture mode: Capture disabled, Input Edge Flag disabled 
    Output mode: Asserted while counter is active 
    Count stop mode: Count repeatedly , Count length: Count until compare and reinitialize , Count direction: Count up 
    Output enable (OFLAG to pin): No 
    Force OFLAG output at startup: No , Forced OFLAG value: 0
    Master mode (broadcast compare event): Disable
    Enable external OFLAG force (on broadcasted event): No 
    Co-channel initialization (on broadcasted event): No 
    Preload Control: 1: Never , Load Reg: 0
                     2: Never , Load Reg: 0
    Interrupts: Overflow: Disabled
                Input edge: Disabled
                Compare: Disabled
                Cmp 1: Disabled
                Cmp 2: Disabled
    Input Filter: Input Signal Sampling [timer clocks] : 0
                  Consecutive Samples Required to Agree: 3 
                  Input Signal Latency: OFF 
    Fault function: No 
    Alternative Load: No 
    Reload on Capture: No 
    Debug action: Continue 
    Enable DMA write for Comparator Preload Register CMPLD1: No 
    Enable DMA write for Comparator Preload Register CMPLD2: No 
    Enable DMA read for Input Edge Flag: No
.*/
#define QT_A0_CTRL_INIT                   0x1C20U
#define QT_A0_CMP1_INIT                   0x3D08U

/*.
    QT_A1 Configuration
--------------------------------------------
    Count mode: Cascaded Counter mode (up/down) 
    Timer Channel Enabled (counter starts counting immediatelly after initialized): Yes
    Primary source: Counter #0 output , 
    Input polarity: True , Output polarity: True 
    Input capture mode: Capture disabled, Input Edge Flag disabled 
    Output mode: Asserted while counter is active 
    Count stop mode: Count repeatedly , Count length: Count until compare and reinitialize , 
    Output enable (OFLAG to pin): No 
    Force OFLAG output at startup: No , Forced OFLAG value: 0
    Master mode (broadcast compare event): Disable
    Enable external OFLAG force (on broadcasted event): No 
    Co-channel initialization (on broadcasted event): No 
    Preload Control: 1: Never , Load Reg: 0
                     2: Never , Load Reg: 0
    Interrupts: Overflow: Disabled
                Input edge: Disabled
                Compare: Disabled
                Cmp 1: Disabled
                Cmp 2: Disabled
    Input Filter: Input Signal Sampling [timer clocks] : 0
                  Consecutive Samples Required to Agree: 3 
                  Input Signal Latency: OFF 
    Fault function: No 
    Alternative Load: No 
    Reload on Capture: No 
    Debug action: Continue 
    Enable DMA write for Comparator Preload Register CMPLD1: No 
    Enable DMA write for Comparator Preload Register CMPLD2: No 
    Enable DMA read for Input Edge Flag: No
.*/
#define QT_A1_CTRL_INIT                   0xE820U
#define QT_A1_CMP1_INIT                   0x0063U

/*.
    GPIO_C Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: TXD0 , PullUp: Disable , 
    Pin  3: Function: RXD0 , PullUp: Disable , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  8: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  9: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 10: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 11: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 12: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 13: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 14: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 15: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_C_PER_INIT                   0x000CU

/*.
    GPIO_E Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  1: Function: GPIO , Direction: Output , Init.Value: High - 1 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  2: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  3: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  4: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  5: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  6: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  7: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull ,
.*/
#define GPIO_E_DDR_INIT                   0x00FFU
#define GPIO_E_PER_INIT                   0x0000U
#define GPIO_E_DR_INIT                    0x0002U
#define GPIO_E_PPMODE_INIT                0x00FFU
#define GPIO_E_PUS_INIT                   0x00FFU

/*.
    GPIO_F Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  3: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  8: Function: GPIO , Direction: Input , PullUp: Disable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_F_PER_INIT                   0x0000U
#define GPIO_F_PPMODE_INIT                0x01FFU
#define GPIO_F_PUS_INIT                   0x01FFU

/*.
    SCI_0 Configuration
--------------------------------------------
    Baudrate: 115207 bps 
    Enable Receiver: Enable 
    Enable Transmitter: Enable 
    Data word length: 8 bits 
    Parity: None 
    Polarity: True polarity 
    Loop mode: Disable
    Function in Wait Mode: SCI module enabled in Wait Mode 
    Interrupts: RX Full: Enable 
                RX Error: Enable 
                TX Empty: Disable
                TX Empty: Disable
    Enable RX and TX FIFO Queues: Disable
    RX Active Edge: Disable
    Enable TX DMA: Disable
    Enable RX DMA: Disable
    Hold off entry to stop mode: No 
    Rx Idle: Disable
.*/
#define SCI_0_SCIBR_INIT                  0x01B2U
#define SCI_0_SCICR_INIT                  0x003CU
#define SCI_0_SCICR2_INIT                 0x0000U
#define SCI_0_RX_BUFFER_OKLIMIT           0x000FU
#define SCI_0_RX_BUFFER_LOWLIMIT          0x000AU
#define SCI_0_SCICR3_INIT                 0x0000U


/*.         End of autogenerated code
********************************************************************** ..*/

#endif
