;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; File: MWCT1013.inc
;; * This software is provided AS IS and without warranty of any kind. 
;; * Your right to use this software is subject to separate terms and conditions entered between you and NXP.
;; * If you have not entered into such terms, you have no license rights to use the code.
;; * Copyright 2012-2016 Freescale Semiconductor, Inc.
;; * Copyright 2017~2019 NXP.
;; * All rights reserved.
;; Purpose: Define the peripheral registers for pure assembly language.
;; This file has been automatically generated from the APIF knowledgebase
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Generic Bit Definitions Used Elsewhere in this File
;;
 define  BIT0                        '$1'
 define  BIT1                        '$2'
 define  BIT2                        '$4'
 define  BIT3                        '$8'
 define  BIT4                        '$10'
 define  BIT5                        '$20'
 define  BIT6                        '$40'
 define  BIT7                        '$80'
 define  BIT8                        '$100'
 define  BIT9                        '$200'
 define  BIT10                       '$400'
 define  BIT11                       '$800'
 define  BIT12                       '$1000'
 define  BIT13                       '$2000'
 define  BIT14                       '$4000'
 define  BIT15                       '$8000'
 define  BIT16                       '$10000'
 define  BIT17                       '$20000'
 define  BIT18                       '$40000'
 define  BIT19                       '$80000'
 define  BIT20                       '$100000'
 define  BIT21                       '$200000'
 define  BIT22                       '$400000'
 define  BIT23                       '$800000'
 define  BIT24                       '$1000000'
 define  BIT25                       '$2000000'
 define  BIT26                       '$4000000'
 define  BIT27                       '$8000000'
 define  BIT28                       '$10000000'
 define  BIT29                       '$20000000'
 define  BIT30                       '$40000000'
 define  BIT31                       '$80000000'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Peripheral Base Address Defines in Alphabetical Order
;;
 define  ADC12                       '$E500'
 define  ADC16                       '$E580'
 define  AOI                         '$E380'
 define  CAN                         '$E800'
 define  CMPA                        '$E020'
 define  CMPB                        '$E028'
 define  CMPC                        '$E030'
 define  CMPD                        '$E038'
 define  COP                         '$E320'
 define  CRC                         '$E1C0'
 define  DAC                         '$E000'
 define  DMA                         '$C800'
 define  EWM                         '$E330'
 define  FMC                         '$DE00'
 define  FTFL                        '$1C780'
 define  GPIOA                       '$E200'
 define  GPIOB                       '$E210'
 define  GPIOC                       '$E220'
 define  GPIOD                       '$E230'
 define  GPIOE                       '$E240'
 define  GPIOF                       '$E250'
 define  I2C0                        '$E0E0'
 define  I2C1                        '$E0F0'
 define  INTC                        '$E300'
 define  MCM                         '$18000'
 define  OCCS                        '$E2B0'
 define  PDB0                        '$E120'
 define  PDB1                        '$E130'
 define  PIT0                        '$E100'
 define  PIT1                        '$E110'
 define  PMC                         '$E2A0'
 define  PWMA                        '$E600'
 define  QSCI0                       '$E080'
 define  QSCI1                       '$E090'
 define  QSPI0                       '$E0B0'
 define  QSPI1                       '$E0C0'
 define  SIM                         '$E400'
 define  TMRA                        '$E140'
 define  TMRB                        '$E180'
 define  XBARA                       '$E340'
 define  XBARB                       '$E360'

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The following section defines the IO register locations.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 define  ADC12_CTRL1                 '$E500'
 define  ADC12_CTRL2                 '$E501'
 define  ADC12_ZXCTRL1               '$E502'
 define  ADC12_ZXCTRL2               '$E503'
 define  ADC12_CLIST1                '$E504'
 define  ADC12_CLIST2                '$E505'
 define  ADC12_CLIST3                '$E506'
 define  ADC12_CLIST4                '$E507'
 define  ADC12_SDIS                  '$E508'
 define  ADC12_STAT                  '$E509'
 define  ADC12_RDY                   '$E50A'
 define  ADC12_LOLIMSTAT             '$E50B'
 define  ADC12_HILIMSTAT             '$E50C'
 define  ADC12_ZXSTAT                '$E50D'
 define  ADC12_RSLT0                 '$E50E'
 define  ADC12_RSLT1                 '$E50F'
 define  ADC12_RSLT2                 '$E510'
 define  ADC12_RSLT3                 '$E511'
 define  ADC12_RSLT4                 '$E512'
 define  ADC12_RSLT5                 '$E513'
 define  ADC12_RSLT6                 '$E514'
 define  ADC12_RSLT7                 '$E515'
 define  ADC12_RSLT8                 '$E516'
 define  ADC12_RSLT9                 '$E517'
 define  ADC12_RSLT10                '$E518'
 define  ADC12_RSLT11                '$E519'
 define  ADC12_RSLT12                '$E51A'
 define  ADC12_RSLT13                '$E51B'
 define  ADC12_RSLT14                '$E51C'
 define  ADC12_RSLT15                '$E51D'
 define  ADC12_LOLIM0                '$E51E'
 define  ADC12_LOLIM1                '$E51F'
 define  ADC12_LOLIM2                '$E520'
 define  ADC12_LOLIM3                '$E521'
 define  ADC12_LOLIM4                '$E522'
 define  ADC12_LOLIM5                '$E523'
 define  ADC12_LOLIM6                '$E524'
 define  ADC12_LOLIM7                '$E525'
 define  ADC12_LOLIM8                '$E526'
 define  ADC12_LOLIM9                '$E527'
 define  ADC12_LOLIM10               '$E528'
 define  ADC12_LOLIM11               '$E529'
 define  ADC12_LOLIM12               '$E52A'
 define  ADC12_LOLIM13               '$E52B'
 define  ADC12_LOLIM14               '$E52C'
 define  ADC12_LOLIM15               '$E52D'
 define  ADC12_HILIM0                '$E52E'
 define  ADC12_HILIM1                '$E52F'
 define  ADC12_HILIM2                '$E530'
 define  ADC12_HILIM3                '$E531'
 define  ADC12_HILIM4                '$E532'
 define  ADC12_HILIM5                '$E533'
 define  ADC12_HILIM6                '$E534'
 define  ADC12_HILIM7                '$E535'
 define  ADC12_HILIM8                '$E536'
 define  ADC12_HILIM9                '$E537'
 define  ADC12_HILIM10               '$E538'
 define  ADC12_HILIM11               '$E539'
 define  ADC12_HILIM12               '$E53A'
 define  ADC12_HILIM13               '$E53B'
 define  ADC12_HILIM14               '$E53C'
 define  ADC12_HILIM15               '$E53D'
 define  ADC12_OFFST0                '$E53E'
 define  ADC12_OFFST1                '$E53F'
 define  ADC12_OFFST2                '$E540'
 define  ADC12_OFFST3                '$E541'
 define  ADC12_OFFST4                '$E542'
 define  ADC12_OFFST5                '$E543'
 define  ADC12_OFFST6                '$E544'
 define  ADC12_OFFST7                '$E545'
 define  ADC12_OFFST8                '$E546'
 define  ADC12_OFFST9                '$E547'
 define  ADC12_OFFST10               '$E548'
 define  ADC12_OFFST11               '$E549'
 define  ADC12_OFFST12               '$E54A'
 define  ADC12_OFFST13               '$E54B'
 define  ADC12_OFFST14               '$E54C'
 define  ADC12_OFFST15               '$E54D'
 define  ADC12_PWR                   '$E54E'
 define  ADC12_CAL                   '$E54F'
 define  ADC12_GC1                   '$E550'
 define  ADC12_GC2                   '$E551'
 define  ADC12_SCTRL                 '$E552'
 define  ADC12_PWR2                  '$E553'
 define  ADC12_CTRL3                 '$E554'
 define  ADC12_SCHLTEN               '$E555'
 define  ADC16_SC1A                  '$E580'
 define  ADC16_CFG1                  '$E584'
 define  ADC16_CFG2                  '$E586'
 define  ADC16_RA                    '$E588'
 define  ADC16_CV1                   '$E58C'
 define  ADC16_CV2                   '$E58E'
 define  ADC16_SC2                   '$E590'
 define  ADC16_SC3                   '$E592'
 define  ADC16_OFS                   '$E594'
 define  ADC16_PG                    '$E596'
 define  ADC16_CLPD                  '$E59A'
 define  ADC16_CLPS                  '$E59C'
 define  ADC16_CLP4                  '$E59E'
 define  ADC16_CLP3                  '$E5A0'
 define  ADC16_CLP2                  '$E5A2'
 define  ADC16_CLP1                  '$E5A4'
 define  ADC16_CLP0                  '$E5A6'
 define  AOI_BFCRT010                '$E380'
 define  AOI_BFCRT230                '$E381'
 define  AOI_BFCRT011                '$E382'
 define  AOI_BFCRT231                '$E383'
 define  AOI_BFCRT012                '$E384'
 define  AOI_BFCRT232                '$E385'
 define  AOI_BFCRT013                '$E386'
 define  AOI_BFCRT233                '$E387'
 define  CAN_MCR                     '$E800'
 define  CAN_CTRL1                   '$E802'
 define  CAN_TIMER                   '$E804'
 define  CAN_RXMGMASK                '$E808'
 define  CAN_RX14MASK                '$E80A'
 define  CAN_RX15MASK                '$E80C'
 define  CAN_ECR                     '$E80E'
 define  CAN_ESR1                    '$E810'
 define  CAN_IMASK1                  '$E814'
 define  CAN_IFLAG1                  '$E818'
 define  CAN_CTRL2                   '$E81A'
 define  CAN_ESR2                    '$E81C'
 define  CAN_CRCR                    '$E822'
 define  CAN_RXFGMASK                '$E824'
 define  CAN_RXFIR                   '$E826'
 define  CAN_CS0                     '$E840'
 define  CAN_ID0                     '$E842'
 define  CAN_WORD00                  '$E844'
 define  CAN_WORD10                  '$E846'
 define  CAN_CS1                     '$E848'
 define  CAN_ID1                     '$E84A'
 define  CAN_WORD01                  '$E84C'
 define  CAN_WORD11                  '$E84E'
 define  CAN_CS2                     '$E850'
 define  CAN_ID2                     '$E852'
 define  CAN_WORD02                  '$E854'
 define  CAN_WORD12                  '$E856'
 define  CAN_CS3                     '$E858'
 define  CAN_ID3                     '$E85A'
 define  CAN_WORD03                  '$E85C'
 define  CAN_WORD13                  '$E85E'
 define  CAN_CS4                     '$E860'
 define  CAN_ID4                     '$E862'
 define  CAN_WORD04                  '$E864'
 define  CAN_WORD14                  '$E866'
 define  CAN_CS5                     '$E868'
 define  CAN_ID5                     '$E86A'
 define  CAN_WORD05                  '$E86C'
 define  CAN_WORD15                  '$E86E'
 define  CAN_CS6                     '$E870'
 define  CAN_ID6                     '$E872'
 define  CAN_WORD06                  '$E874'
 define  CAN_WORD16                  '$E876'
 define  CAN_CS7                     '$E878'
 define  CAN_ID7                     '$E87A'
 define  CAN_WORD07                  '$E87C'
 define  CAN_WORD17                  '$E87E'
 define  CAN_CS8                     '$E880'
 define  CAN_ID8                     '$E882'
 define  CAN_WORD08                  '$E884'
 define  CAN_WORD18                  '$E886'
 define  CAN_CS9                     '$E888'
 define  CAN_ID9                     '$E88A'
 define  CAN_WORD09                  '$E88C'
 define  CAN_WORD19                  '$E88E'
 define  CAN_CS10                    '$E890'
 define  CAN_ID10                    '$E892'
 define  CAN_WORD010                 '$E894'
 define  CAN_WORD110                 '$E896'
 define  CAN_CS11                    '$E898'
 define  CAN_ID11                    '$E89A'
 define  CAN_WORD011                 '$E89C'
 define  CAN_WORD111                 '$E89E'
 define  CAN_CS12                    '$E8A0'
 define  CAN_ID12                    '$E8A2'
 define  CAN_WORD012                 '$E8A4'
 define  CAN_WORD112                 '$E8A6'
 define  CAN_CS13                    '$E8A8'
 define  CAN_ID13                    '$E8AA'
 define  CAN_WORD013                 '$E8AC'
 define  CAN_WORD113                 '$E8AE'
 define  CAN_CS14                    '$E8B0'
 define  CAN_ID14                    '$E8B2'
 define  CAN_WORD014                 '$E8B4'
 define  CAN_WORD114                 '$E8B6'
 define  CAN_CS15                    '$E8B8'
 define  CAN_ID15                    '$E8BA'
 define  CAN_WORD015                 '$E8BC'
 define  CAN_WORD115                 '$E8BE'
 define  CAN_RXIMR0                  '$EC40'
 define  CAN_RXIMR1                  '$EC42'
 define  CAN_RXIMR2                  '$EC44'
 define  CAN_RXIMR3                  '$EC46'
 define  CAN_RXIMR4                  '$EC48'
 define  CAN_RXIMR5                  '$EC4A'
 define  CAN_RXIMR6                  '$EC4C'
 define  CAN_RXIMR7                  '$EC4E'
 define  CAN_RXIMR8                  '$EC50'
 define  CAN_RXIMR9                  '$EC52'
 define  CAN_RXIMR10                 '$EC54'
 define  CAN_RXIMR11                 '$EC56'
 define  CAN_RXIMR12                 '$EC58'
 define  CAN_RXIMR13                 '$EC5A'
 define  CAN_RXIMR14                 '$EC5C'
 define  CAN_RXIMR15                 '$EC5E'
 define  CMPA_CR0                    '$E020'
 define  CMPA_CR1                    '$E021'
 define  CMPA_FPR                    '$E022'
 define  CMPA_SCR                    '$E023'
 define  CMPA_DACCR                  '$E024'
 define  CMPA_MUXCR                  '$E025'
 define  CMPB_CR0                    '$E028'
 define  CMPB_CR1                    '$E029'
 define  CMPB_FPR                    '$E02A'
 define  CMPB_SCR                    '$E02B'
 define  CMPB_DACCR                  '$E02C'
 define  CMPB_MUXCR                  '$E02D'
 define  CMPC_CR0                    '$E030'
 define  CMPC_CR1                    '$E031'
 define  CMPC_FPR                    '$E032'
 define  CMPC_SCR                    '$E033'
 define  CMPC_DACCR                  '$E034'
 define  CMPC_MUXCR                  '$E035'
 define  CMPD_CR0                    '$E038'
 define  CMPD_CR1                    '$E039'
 define  CMPD_FPR                    '$E03A'
 define  CMPD_SCR                    '$E03B'
 define  CMPD_DACCR                  '$E03C'
 define  CMPD_MUXCR                  '$E03D'
 define  COP_CTRL                    '$E320'
 define  COP_TOUT                    '$E321'
 define  COP_CNTR                    '$E322'
 define  COP_INTVAL                  '$E323'
 define  CRC_CRC                     '$E1C0'
 define  CRC_GPOLY                   '$E1C2'
 define  CRC_CTRL                    '$E1C4'
 define  DAC_CTRL0                   '$E000'
 define  DAC_DATAREG_FMT1            '$E001'
 define  DAC_DATAREG_FMT0            '$E001'
 define  DAC_STEPVAL_FMT0            '$E002'
 define  DAC_STEPVAL_FMT1            '$E002'
 define  DAC_MINVAL_FMT1             '$E003'
 define  DAC_MINVAL_FMT0             '$E003'
 define  DAC_MAXVAL_FMT0             '$E004'
 define  DAC_MAXVAL_FMT1             '$E004'
 define  DAC_STATUS                  '$E005'
 define  DAC_CTRL1                   '$E006'
 define  DMA_REQC                    '$C800'
 define  DMA_SAR0                    '$C880'
 define  DMA_DAR0                    '$C882'
 define  DMA_DSR_BCR0                '$C884'
 define  DMA_DCR0                    '$C886'
 define  DMA_SAR1                    '$C888'
 define  DMA_DAR1                    '$C88A'
 define  DMA_DSR_BCR1                '$C88C'
 define  DMA_DCR1                    '$C88E'
 define  DMA_SAR2                    '$C890'
 define  DMA_DAR2                    '$C892'
 define  DMA_DSR_BCR2                '$C894'
 define  DMA_DCR2                    '$C896'
 define  DMA_SAR3                    '$C898'
 define  DMA_DAR3                    '$C89A'
 define  DMA_DSR_BCR3                '$C89C'
 define  DMA_DCR3                    '$C89E'
 define  EWM_CTRL                    '$E330'
 define  EWM_SERV                    '$E331'
 define  EWM_CMPL                    '$E332'
 define  EWM_CMPH                    '$E333'
 define  EWM_CLKCTRL                 '$E334'
 define  EWM_CLKPRESCALER            '$E335'
 define  FMC_PFAPR                   '$DE00'
 define  FMC_PFB0CR                  '$DE02'
 define  FMC_PFB1CR                  '$DE04'
 define  FMC_TAGVDW0S0               '$DE80'
 define  FMC_TAGVDW0S1               '$DE82'
 define  FMC_TAGVDW0S2               '$DE84'
 define  FMC_TAGVDW0S3               '$DE86'
 define  FMC_TAGVDW0S4               '$DE88'
 define  FMC_TAGVDW0S5               '$DE8A'
 define  FMC_TAGVDW0S6               '$DE8C'
 define  FMC_TAGVDW0S7               '$DE8E'
 define  FMC_TAGVDW1S0               '$DE90'
 define  FMC_TAGVDW1S1               '$DE92'
 define  FMC_TAGVDW1S2               '$DE94'
 define  FMC_TAGVDW1S3               '$DE96'
 define  FMC_TAGVDW1S4               '$DE98'
 define  FMC_TAGVDW1S5               '$DE9A'
 define  FMC_TAGVDW1S6               '$DE9C'
 define  FMC_TAGVDW1S7               '$DE9E'
 define  FMC_TAGVDW2S0               '$DEA0'
 define  FMC_TAGVDW2S1               '$DEA2'
 define  FMC_TAGVDW2S2               '$DEA4'
 define  FMC_TAGVDW2S3               '$DEA6'
 define  FMC_TAGVDW2S4               '$DEA8'
 define  FMC_TAGVDW2S5               '$DEAA'
 define  FMC_TAGVDW2S6               '$DEAC'
 define  FMC_TAGVDW2S7               '$DEAE'
 define  FMC_TAGVDW3S0               '$DEB0'
 define  FMC_TAGVDW3S1               '$DEB2'
 define  FMC_TAGVDW3S2               '$DEB4'
 define  FMC_TAGVDW3S3               '$DEB6'
 define  FMC_TAGVDW3S4               '$DEB8'
 define  FMC_TAGVDW3S5               '$DEBA'
 define  FMC_TAGVDW3S6               '$DEBC'
 define  FMC_TAGVDW3S7               '$DEBE'
 define  FMC_DATAW0S0U               '$DF00'
 define  FMC_DATAW0S0L               '$DF02'
 define  FMC_DATAW0S1U               '$DF04'
 define  FMC_DATAW0S1L               '$DF06'
 define  FMC_DATAW0S2U               '$DF08'
 define  FMC_DATAW0S2L               '$DF0A'
 define  FMC_DATAW0S3U               '$DF0C'
 define  FMC_DATAW0S3L               '$DF0E'
 define  FMC_DATAW0S4U               '$DF10'
 define  FMC_DATAW0S4L               '$DF12'
 define  FMC_DATAW0S5U               '$DF14'
 define  FMC_DATAW0S5L               '$DF16'
 define  FMC_DATAW0S6U               '$DF18'
 define  FMC_DATAW0S6L               '$DF1A'
 define  FMC_DATAW0S7U               '$DF1C'
 define  FMC_DATAW0S7L               '$DF1E'
 define  FMC_DATAW1S0U               '$DF20'
 define  FMC_DATAW1S0L               '$DF22'
 define  FMC_DATAW1S1U               '$DF24'
 define  FMC_DATAW1S1L               '$DF26'
 define  FMC_DATAW1S2U               '$DF28'
 define  FMC_DATAW1S2L               '$DF2A'
 define  FMC_DATAW1S3U               '$DF2C'
 define  FMC_DATAW1S3L               '$DF2E'
 define  FMC_DATAW1S4U               '$DF30'
 define  FMC_DATAW1S4L               '$DF32'
 define  FMC_DATAW1S5U               '$DF34'
 define  FMC_DATAW1S5L               '$DF36'
 define  FMC_DATAW1S6U               '$DF38'
 define  FMC_DATAW1S6L               '$DF3A'
 define  FMC_DATAW1S7U               '$DF3C'
 define  FMC_DATAW1S7L               '$DF3E'
 define  FMC_DATAW2S0U               '$DF40'
 define  FMC_DATAW2S0L               '$DF42'
 define  FMC_DATAW2S1U               '$DF44'
 define  FMC_DATAW2S1L               '$DF46'
 define  FMC_DATAW2S2U               '$DF48'
 define  FMC_DATAW2S2L               '$DF4A'
 define  FMC_DATAW2S3U               '$DF4C'
 define  FMC_DATAW2S3L               '$DF4E'
 define  FMC_DATAW2S4U               '$DF50'
 define  FMC_DATAW2S4L               '$DF52'
 define  FMC_DATAW2S5U               '$DF54'
 define  FMC_DATAW2S5L               '$DF56'
 define  FMC_DATAW2S6U               '$DF58'
 define  FMC_DATAW2S6L               '$DF5A'
 define  FMC_DATAW2S7U               '$DF5C'
 define  FMC_DATAW2S7L               '$DF5E'
 define  FMC_DATAW3S0U               '$DF60'
 define  FMC_DATAW3S0L               '$DF62'
 define  FMC_DATAW3S1U               '$DF64'
 define  FMC_DATAW3S1L               '$DF66'
 define  FMC_DATAW3S2U               '$DF68'
 define  FMC_DATAW3S2L               '$DF6A'
 define  FMC_DATAW3S3U               '$DF6C'
 define  FMC_DATAW3S3L               '$DF6E'
 define  FMC_DATAW3S4U               '$DF70'
 define  FMC_DATAW3S4L               '$DF72'
 define  FMC_DATAW3S5U               '$DF74'
 define  FMC_DATAW3S5L               '$DF76'
 define  FMC_DATAW3S6U               '$DF78'
 define  FMC_DATAW3S6L               '$DF7A'
 define  FMC_DATAW3S7U               '$DF7C'
 define  FMC_DATAW3S7L               '$DF7E'
 define  FTFL_FSTAT                  '$1C780'
 define  FTFL_FCNFG                  '$1C781'
 define  FTFL_FSEC                   '$1C782'
 define  FTFL_FOPT                   '$1C783'
 define  FTFL_FCCOB3                 '$1C784'
 define  FTFL_FCCOB2                 '$1C785'
 define  FTFL_FCCOB1                 '$1C786'
 define  FTFL_FCCOB0                 '$1C787'
 define  FTFL_FCCOB7                 '$1C788'
 define  FTFL_FCCOB6                 '$1C789'
 define  FTFL_FCCOB5                 '$1C78A'
 define  FTFL_FCCOB4                 '$1C78B'
 define  FTFL_FCCOBB                 '$1C78C'
 define  FTFL_FCCOBA                 '$1C78D'
 define  FTFL_FCCOB9                 '$1C78E'
 define  FTFL_FCCOB8                 '$1C78F'
 define  FTFL_FPROT3                 '$1C790'
 define  FTFL_FPROT2                 '$1C791'
 define  FTFL_FPROT1                 '$1C792'
 define  FTFL_FPROT0                 '$1C793'
 define  FTFL_FEPROT                 '$1C796'
 define  FTFL_FDPROT                 '$1C797'
 define  GPIOA_PUR                   '$E200'
 define  GPIOA_DR                    '$E201'
 define  GPIOA_DDR                   '$E202'
 define  GPIOA_PER                   '$E203'
 define  GPIOA_IAR                   '$E204'
 define  GPIOA_IENR                  '$E205'
 define  GPIOA_IPOLR                 '$E206'
 define  GPIOA_IPR                   '$E207'
 define  GPIOA_IESR                  '$E208'
 define  GPIOA_PPMODE                '$E209'
 define  GPIOA_RAWDATA               '$E20A'
 define  GPIOA_DRIVE                 '$E20B'
 define  GPIOA_PUS                   '$E20C'
 define  GPIOA_SRE                   '$E20D'
 define  GPIOB_PUR                   '$E210'
 define  GPIOB_DR                    '$E211'
 define  GPIOB_DDR                   '$E212'
 define  GPIOB_PER                   '$E213'
 define  GPIOB_IAR                   '$E214'
 define  GPIOB_IENR                  '$E215'
 define  GPIOB_IPOLR                 '$E216'
 define  GPIOB_IPR                   '$E217'
 define  GPIOB_IESR                  '$E218'
 define  GPIOB_PPMODE                '$E219'
 define  GPIOB_RAWDATA               '$E21A'
 define  GPIOB_DRIVE                 '$E21B'
 define  GPIOB_PUS                   '$E21C'
 define  GPIOB_SRE                   '$E21D'
 define  GPIOC_PUR                   '$E220'
 define  GPIOC_DR                    '$E221'
 define  GPIOC_DDR                   '$E222'
 define  GPIOC_PER                   '$E223'
 define  GPIOC_IAR                   '$E224'
 define  GPIOC_IENR                  '$E225'
 define  GPIOC_IPOLR                 '$E226'
 define  GPIOC_IPR                   '$E227'
 define  GPIOC_IESR                  '$E228'
 define  GPIOC_PPMODE                '$E229'
 define  GPIOC_RAWDATA               '$E22A'
 define  GPIOC_DRIVE                 '$E22B'
 define  GPIOC_PUS                   '$E22C'
 define  GPIOC_SRE                   '$E22D'
 define  GPIOD_PUR                   '$E230'
 define  GPIOD_DR                    '$E231'
 define  GPIOD_DDR                   '$E232'
 define  GPIOD_PER                   '$E233'
 define  GPIOD_IAR                   '$E234'
 define  GPIOD_IENR                  '$E235'
 define  GPIOD_IPOLR                 '$E236'
 define  GPIOD_IPR                   '$E237'
 define  GPIOD_IESR                  '$E238'
 define  GPIOD_PPMODE                '$E239'
 define  GPIOD_RAWDATA               '$E23A'
 define  GPIOD_DRIVE                 '$E23B'
 define  GPIOD_PUS                   '$E23C'
 define  GPIOD_SRE                   '$E23D'
 define  GPIOE_PUR                   '$E240'
 define  GPIOE_DR                    '$E241'
 define  GPIOE_DDR                   '$E242'
 define  GPIOE_PER                   '$E243'
 define  GPIOE_IAR                   '$E244'
 define  GPIOE_IENR                  '$E245'
 define  GPIOE_IPOLR                 '$E246'
 define  GPIOE_IPR                   '$E247'
 define  GPIOE_IESR                  '$E248'
 define  GPIOE_PPMODE                '$E249'
 define  GPIOE_RAWDATA               '$E24A'
 define  GPIOE_DRIVE                 '$E24B'
 define  GPIOE_PUS                   '$E24C'
 define  GPIOE_SRE                   '$E24D'
 define  GPIOF_PUR                   '$E250'
 define  GPIOF_DR                    '$E251'
 define  GPIOF_DDR                   '$E252'
 define  GPIOF_PER                   '$E253'
 define  GPIOF_IAR                   '$E254'
 define  GPIOF_IENR                  '$E255'
 define  GPIOF_IPOLR                 '$E256'
 define  GPIOF_IPR                   '$E257'
 define  GPIOF_IESR                  '$E258'
 define  GPIOF_PPMODE                '$E259'
 define  GPIOF_RAWDATA               '$E25A'
 define  GPIOF_DRIVE                 '$E25B'
 define  GPIOF_PUS                   '$E25C'
 define  GPIOF_SRE                   '$E25D'
 define  I2C0_A1                     '$E0E0'
 define  I2C0_F                      '$E0E1'
 define  I2C0_C1                     '$E0E2'
 define  I2C0_S                      '$E0E3'
 define  I2C0_D                      '$E0E4'
 define  I2C0_C2                     '$E0E5'
 define  I2C0_FLT                    '$E0E6'
 define  I2C0_RA                     '$E0E7'
 define  I2C0_SMB                    '$E0E8'
 define  I2C0_A2                     '$E0E9'
 define  I2C0_SLTH                   '$E0EA'
 define  I2C0_SLTL                   '$E0EB'
 define  I2C1_A1                     '$E0F0'
 define  I2C1_F                      '$E0F1'
 define  I2C1_C1                     '$E0F2'
 define  I2C1_S                      '$E0F3'
 define  I2C1_D                      '$E0F4'
 define  I2C1_C2                     '$E0F5'
 define  I2C1_FLT                    '$E0F6'
 define  I2C1_RA                     '$E0F7'
 define  I2C1_SMB                    '$E0F8'
 define  I2C1_A2                     '$E0F9'
 define  I2C1_SLTH                   '$E0FA'
 define  I2C1_SLTL                   '$E0FB'
 define  INTC_IPR0                   '$E300'
 define  INTC_IPR1                   '$E301'
 define  INTC_IPR2                   '$E302'
 define  INTC_IPR3                   '$E303'
 define  INTC_IPR4                   '$E304'
 define  INTC_IPR5                   '$E305'
 define  INTC_IPR6                   '$E306'
 define  INTC_IPR8                   '$E308'
 define  INTC_IPR9                   '$E309'
 define  INTC_IPR10                  '$E30A'
 define  INTC_IPR11                  '$E30B'
 define  INTC_IPR12                  '$E30C'
 define  INTC_VBA                    '$E30D'
 define  INTC_FIM0                   '$E30E'
 define  INTC_FIVAL0                 '$E30F'
 define  INTC_FIVAH0                 '$E310'
 define  INTC_FIM1                   '$E311'
 define  INTC_FIVAL1                 '$E312'
 define  INTC_FIVAH1                 '$E313'
 define  INTC_IRQP0                  '$E314'
 define  INTC_IRQP1                  '$E315'
 define  INTC_IRQP2                  '$E316'
 define  INTC_IRQP3                  '$E317'
 define  INTC_IRQP4                  '$E318'
 define  INTC_IRQP5                  '$E319'
 define  INTC_IRQP6                  '$E31A'
 define  INTC_CTRL                   '$E31B'
 define  MCM_PLASC                   '$18008'
 define  MCM_PLAMC                   '$1800A'
 define  MCM_CPCR                    '$1800C'
 define  MCM_CFADR                   '$18010'
 define  MCM_CFATR                   '$18014'
 define  MCM_CFLOC                   '$18015'
 define  MCM_CFIER                   '$18016'
 define  MCM_CFISR                   '$18017'
 define  MCM_CFDTR                   '$18018'
 define  MCM_RPCR                    '$18020'
 define  MCM_UFLASHBAR               '$18024'
 define  MCM_UPRAMBAR                '$18028'
 define  MCM_SRPOSP                  '$18030'
 define  MCM_SRPIPC                  '$18034'
 define  MCM_SRPMPC                  '$18038'
 define  OCCS_CTRL                   '$E2B0'
 define  OCCS_DIVBY                  '$E2B1'
 define  OCCS_STAT                   '$E2B2'
 define  OCCS_OSCTL1                 '$E2B4'
 define  OCCS_OSCTL2                 '$E2B5'
 define  OCCS_CLKCHKR                '$E2B6'
 define  OCCS_CLKCHKT                '$E2B7'
 define  OCCS_PROT                   '$E2B8'
 define  PDB0_MCTRL                  '$E120'
 define  PDB0_CTRLA                  '$E121'
 define  PDB0_CTRLC                  '$E122'
 define  PDB0_DELAYA                 '$E123'
 define  PDB0_DELAYB                 '$E124'
 define  PDB0_DELAYC                 '$E125'
 define  PDB0_DELAYD                 '$E126'
 define  PDB0_MOD                    '$E127'
 define  PDB0_CNTR                   '$E128'
 define  PDB1_MCTRL                  '$E130'
 define  PDB1_CTRLA                  '$E131'
 define  PDB1_CTRLC                  '$E132'
 define  PDB1_DELAYA                 '$E133'
 define  PDB1_DELAYB                 '$E134'
 define  PDB1_DELAYC                 '$E135'
 define  PDB1_DELAYD                 '$E136'
 define  PDB1_MOD                    '$E137'
 define  PDB1_CNTR                   '$E138'
 define  PIT0_CTRL                   '$E100'
 define  PIT0_MOD                    '$E101'
 define  PIT0_CNTR                   '$E102'
 define  PIT1_CTRL                   '$E110'
 define  PIT1_MOD                    '$E111'
 define  PIT1_CNTR                   '$E112'
 define  PMC_CTRL                    '$E2A0'
 define  PMC_STS                     '$E2A1'
 define  PWMA_SM0CNT                 '$E600'
 define  PWMA_SM0INIT                '$E601'
 define  PWMA_SM0CTRL2               '$E602'
 define  PWMA_SM0CTRL                '$E603'
 define  PWMA_SM0VAL0                '$E605'
 define  PWMA_SM0FRACVAL1            '$E606'
 define  PWMA_SM0VAL1                '$E607'
 define  PWMA_SM0FRACVAL2            '$E608'
 define  PWMA_SM0VAL2                '$E609'
 define  PWMA_SM0FRACVAL3            '$E60A'
 define  PWMA_SM0VAL3                '$E60B'
 define  PWMA_SM0FRACVAL4            '$E60C'
 define  PWMA_SM0VAL4                '$E60D'
 define  PWMA_SM0FRACVAL5            '$E60E'
 define  PWMA_SM0VAL5                '$E60F'
 define  PWMA_SM0FRCTRL              '$E610'
 define  PWMA_SM0OCTRL               '$E611'
 define  PWMA_SM0STS                 '$E612'
 define  PWMA_SM0INTEN               '$E613'
 define  PWMA_SM0DMAEN               '$E614'
 define  PWMA_SM0TCTRL               '$E615'
 define  PWMA_SM0DISMAP0             '$E616'
 define  PWMA_SM0DISMAP1             '$E617'
 define  PWMA_SM0DTCNT0              '$E618'
 define  PWMA_SM0DTCNT1              '$E619'
 define  PWMA_SM0CAPTCTRLA           '$E61A'
 define  PWMA_SM0CAPTCOMPA           '$E61B'
 define  PWMA_SM0CAPTCTRLB           '$E61C'
 define  PWMA_SM0CAPTCOMPB           '$E61D'
 define  PWMA_SM0CAPTCTRLX           '$E61E'
 define  PWMA_SM0CAPTCOMPX           '$E61F'
 define  PWMA_SM0CVAL0               '$E620'
 define  PWMA_SM0CVAL0CYC            '$E621'
 define  PWMA_SM0CVAL1               '$E622'
 define  PWMA_SM0CVAL1CYC            '$E623'
 define  PWMA_SM0CVAL2               '$E624'
 define  PWMA_SM0CVAL2CYC            '$E625'
 define  PWMA_SM0CVAL3               '$E626'
 define  PWMA_SM0CVAL3CYC            '$E627'
 define  PWMA_SM0CVAL4               '$E628'
 define  PWMA_SM0CVAL4CYC            '$E629'
 define  PWMA_SM0CVAL5               '$E62A'
 define  PWMA_SM0CVAL5CYC            '$E62B'
 define  PWMA_SM1CNT                 '$E630'
 define  PWMA_SM1INIT                '$E631'
 define  PWMA_SM1CTRL2               '$E632'
 define  PWMA_SM1CTRL                '$E633'
 define  PWMA_SM1VAL0                '$E635'
 define  PWMA_SM1FRACVAL1            '$E636'
 define  PWMA_SM1VAL1                '$E637'
 define  PWMA_SM1FRACVAL2            '$E638'
 define  PWMA_SM1VAL2                '$E639'
 define  PWMA_SM1FRACVAL3            '$E63A'
 define  PWMA_SM1VAL3                '$E63B'
 define  PWMA_SM1FRACVAL4            '$E63C'
 define  PWMA_SM1VAL4                '$E63D'
 define  PWMA_SM1FRACVAL5            '$E63E'
 define  PWMA_SM1VAL5                '$E63F'
 define  PWMA_SM1FRCTRL              '$E640'
 define  PWMA_SM1OCTRL               '$E641'
 define  PWMA_SM1STS                 '$E642'
 define  PWMA_SM1INTEN               '$E643'
 define  PWMA_SM1DMAEN               '$E644'
 define  PWMA_SM1TCTRL               '$E645'
 define  PWMA_SM1DISMAP0             '$E646'
 define  PWMA_SM1DISMAP1             '$E647'
 define  PWMA_SM1DTCNT0              '$E648'
 define  PWMA_SM1DTCNT1              '$E649'
 define  PWMA_SM1CAPTCTRLA           '$E64A'
 define  PWMA_SM1CAPTCOMPA           '$E64B'
 define  PWMA_SM1CAPTCTRLB           '$E64C'
 define  PWMA_SM1CAPTCOMPB           '$E64D'
 define  PWMA_SM1CAPTCTRLX           '$E64E'
 define  PWMA_SM1CAPTCOMPX           '$E64F'
 define  PWMA_SM1CVAL0               '$E650'
 define  PWMA_SM1CVAL0CYC            '$E651'
 define  PWMA_SM1CVAL1               '$E652'
 define  PWMA_SM1CVAL1CYC            '$E653'
 define  PWMA_SM1CVAL2               '$E654'
 define  PWMA_SM1CVAL2CYC            '$E655'
 define  PWMA_SM1CVAL3               '$E656'
 define  PWMA_SM1CVAL3CYC            '$E657'
 define  PWMA_SM1CVAL4               '$E658'
 define  PWMA_SM1CVAL4CYC            '$E659'
 define  PWMA_SM1CVAL5               '$E65A'
 define  PWMA_SM1CVAL5CYC            '$E65B'
 define  PWMA_SM2CNT                 '$E660'
 define  PWMA_SM2INIT                '$E661'
 define  PWMA_SM2CTRL2               '$E662'
 define  PWMA_SM2CTRL                '$E663'
 define  PWMA_SM2VAL0                '$E665'
 define  PWMA_SM2FRACVAL1            '$E666'
 define  PWMA_SM2VAL1                '$E667'
 define  PWMA_SM2FRACVAL2            '$E668'
 define  PWMA_SM2VAL2                '$E669'
 define  PWMA_SM2FRACVAL3            '$E66A'
 define  PWMA_SM2VAL3                '$E66B'
 define  PWMA_SM2FRACVAL4            '$E66C'
 define  PWMA_SM2VAL4                '$E66D'
 define  PWMA_SM2FRACVAL5            '$E66E'
 define  PWMA_SM2VAL5                '$E66F'
 define  PWMA_SM2FRCTRL              '$E670'
 define  PWMA_SM2OCTRL               '$E671'
 define  PWMA_SM2STS                 '$E672'
 define  PWMA_SM2INTEN               '$E673'
 define  PWMA_SM2DMAEN               '$E674'
 define  PWMA_SM2TCTRL               '$E675'
 define  PWMA_SM2DISMAP0             '$E676'
 define  PWMA_SM2DISMAP1             '$E677'
 define  PWMA_SM2DTCNT0              '$E678'
 define  PWMA_SM2DTCNT1              '$E679'
 define  PWMA_SM2CAPTCTRLA           '$E67A'
 define  PWMA_SM2CAPTCOMPA           '$E67B'
 define  PWMA_SM2CAPTCTRLB           '$E67C'
 define  PWMA_SM2CAPTCOMPB           '$E67D'
 define  PWMA_SM2CAPTCTRLX           '$E67E'
 define  PWMA_SM2CAPTCOMPX           '$E67F'
 define  PWMA_SM2CVAL0               '$E680'
 define  PWMA_SM2CVAL0CYC            '$E681'
 define  PWMA_SM2CVAL1               '$E682'
 define  PWMA_SM2CVAL1CYC            '$E683'
 define  PWMA_SM2CVAL2               '$E684'
 define  PWMA_SM2CVAL2CYC            '$E685'
 define  PWMA_SM2CVAL3               '$E686'
 define  PWMA_SM2CVAL3CYC            '$E687'
 define  PWMA_SM2CVAL4               '$E688'
 define  PWMA_SM2CVAL4CYC            '$E689'
 define  PWMA_SM2CVAL5               '$E68A'
 define  PWMA_SM2CVAL5CYC            '$E68B'
 define  PWMA_SM3CNT                 '$E690'
 define  PWMA_SM3INIT                '$E691'
 define  PWMA_SM3CTRL2               '$E692'
 define  PWMA_SM3CTRL                '$E693'
 define  PWMA_SM3VAL0                '$E695'
 define  PWMA_SM3FRACVAL1            '$E696'
 define  PWMA_SM3VAL1                '$E697'
 define  PWMA_SM3FRACVAL2            '$E698'
 define  PWMA_SM3VAL2                '$E699'
 define  PWMA_SM3FRACVAL3            '$E69A'
 define  PWMA_SM3VAL3                '$E69B'
 define  PWMA_SM3FRACVAL4            '$E69C'
 define  PWMA_SM3VAL4                '$E69D'
 define  PWMA_SM3FRACVAL5            '$E69E'
 define  PWMA_SM3VAL5                '$E69F'
 define  PWMA_SM3FRCTRL              '$E6A0'
 define  PWMA_SM3OCTRL               '$E6A1'
 define  PWMA_SM3STS                 '$E6A2'
 define  PWMA_SM3INTEN               '$E6A3'
 define  PWMA_SM3DMAEN               '$E6A4'
 define  PWMA_SM3TCTRL               '$E6A5'
 define  PWMA_SM3DISMAP0             '$E6A6'
 define  PWMA_SM3DISMAP1             '$E6A7'
 define  PWMA_SM3DTCNT0              '$E6A8'
 define  PWMA_SM3DTCNT1              '$E6A9'
 define  PWMA_SM3CAPTCTRLA           '$E6AA'
 define  PWMA_SM3CAPTCOMPA           '$E6AB'
 define  PWMA_SM3CAPTCTRLB           '$E6AC'
 define  PWMA_SM3CAPTCOMPB           '$E6AD'
 define  PWMA_SM3CAPTCTRLX           '$E6AE'
 define  PWMA_SM3CAPTCOMPX           '$E6AF'
 define  PWMA_SM3CVAL0               '$E6B0'
 define  PWMA_SM3CVAL0CYC            '$E6B1'
 define  PWMA_SM3CVAL1               '$E6B2'
 define  PWMA_SM3CVAL1CYC            '$E6B3'
 define  PWMA_SM3CVAL2               '$E6B4'
 define  PWMA_SM3CVAL2CYC            '$E6B5'
 define  PWMA_SM3CVAL3               '$E6B6'
 define  PWMA_SM3CVAL3CYC            '$E6B7'
 define  PWMA_SM3CVAL4               '$E6B8'
 define  PWMA_SM3CVAL4CYC            '$E6B9'
 define  PWMA_SM3CVAL5               '$E6BA'
 define  PWMA_SM3CVAL5CYC            '$E6BB'
 define  PWMA_OUTEN                  '$E6C0'
 define  PWMA_MASK                   '$E6C1'
 define  PWMA_SWCOUT                 '$E6C2'
 define  PWMA_DTSRCSEL               '$E6C3'
 define  PWMA_MCTRL                  '$E6C4'
 define  PWMA_MCTRL2                 '$E6C5'
 define  PWMA_FCTRL0                 '$E6C6'
 define  PWMA_FSTS0                  '$E6C7'
 define  PWMA_FFILT0                 '$E6C8'
 define  PWMA_FTST0                  '$E6C9'
 define  PWMA_FCTRL1                 '$E6CA'
 define  PWMA_FCTRL20                '$E6CA'
 define  PWMA_FSTS1                  '$E6CB'
 define  PWMA_FFILT1                 '$E6CC'
 define  PWMA_FTST1                  '$E6CD'
 define  PWMA_FCTRL21                '$E6CE'
 define  QSCI0_RATE                  '$E080'
 define  QSCI0_CTRL1                 '$E081'
 define  QSCI0_CTRL2                 '$E082'
 define  QSCI0_STAT                  '$E083'
 define  QSCI0_DATA                  '$E084'
 define  QSCI0_CTRL3                 '$E085'
 define  QSCI1_RATE                  '$E090'
 define  QSCI1_CTRL1                 '$E091'
 define  QSCI1_CTRL2                 '$E092'
 define  QSCI1_STAT                  '$E093'
 define  QSCI1_DATA                  '$E094'
 define  QSCI1_CTRL3                 '$E095'
 define  QSPI0_SPSCR                 '$E0B0'
 define  QSPI0_SPDSR                 '$E0B1'
 define  QSPI0_SPDRR                 '$E0B2'
 define  QSPI0_SPDTR                 '$E0B3'
 define  QSPI0_SPFIFO                '$E0B4'
 define  QSPI0_SPWAIT                '$E0B5'
 define  QSPI0_SPCTL2                '$E0B6'
 define  QSPI1_SPSCR                 '$E0C0'
 define  QSPI1_SPDSR                 '$E0C1'
 define  QSPI1_SPDRR                 '$E0C2'
 define  QSPI1_SPDTR                 '$E0C3'
 define  QSPI1_SPFIFO                '$E0C4'
 define  QSPI1_SPWAIT                '$E0C5'
 define  QSPI1_SPCTL2                '$E0C6'
 define  SIM_CTRL                    '$E400'
 define  SIM_RSTAT                   '$E401'
 define  SIM_SCR0                    '$E402'
 define  SIM_SCR1                    '$E403'
 define  SIM_SCR2                    '$E404'
 define  SIM_SCR3                    '$E405'
 define  SIM_MSHID                   '$E406'
 define  SIM_LSHID                   '$E407'
 define  SIM_PWR                     '$E408'
 define  SIM_CLKOUT                  '$E40A'
 define  SIM_PCR                     '$E40B'
 define  SIM_PCE0                    '$E40C'
 define  SIM_PCE1                    '$E40D'
 define  SIM_PCE2                    '$E40E'
 define  SIM_PCE3                    '$E40F'
 define  SIM_SD0                     '$E410'
 define  SIM_SD1                     '$E411'
 define  SIM_SD2                     '$E412'
 define  SIM_SD3                     '$E413'
 define  SIM_IOSAHI                  '$E414'
 define  SIM_IOSALO                  '$E415'
 define  SIM_PROT                    '$E416'
 define  SIM_GPSAL                   '$E417'
 define  SIM_GPSBH                   '$E418'
 define  SIM_GPSCL                   '$E419'
 define  SIM_GPSCH                   '$E41A'
 define  SIM_GPSDL                   '$E41B'
 define  SIM_GPSEL                   '$E41C'
 define  SIM_GPSEH                   '$E41D'
 define  SIM_GPSFL                   '$E41E'
 define  SIM_GPSFH                   '$E41F'
 define  SIM_GPSGL                   '$E420'
 define  SIM_GPSGH                   '$E421'
 define  SIM_IPS0                    '$E422'
 define  SIM_MISC0                   '$E423'
 define  SIM_PSWR0                   '$E424'
 define  SIM_PSWR1                   '$E425'
 define  SIM_PSWR2                   '$E426'
 define  SIM_PSWR3                   '$E427'
 define  SIM_PWRMODE                 '$E428'
 define  SIM_NVMOPT2H                '$E42C'
 define  SIM_NVMOPT2L                '$E42D'
 define  SIM_NVMOPT3H                '$E42E'
 define  TMRA_0_COMP1                '$E140'
 define  TMRA_0_COMP2                '$E141'
 define  TMRA_0_CAPT                 '$E142'
 define  TMRA_0_LOAD                 '$E143'
 define  TMRA_0_HOLD                 '$E144'
 define  TMRA_0_CNTR                 '$E145'
 define  TMRA_0_CTRL                 '$E146'
 define  TMRA_0_SCTRL                '$E147'
 define  TMRA_0_CMPLD1               '$E148'
 define  TMRA_0_CMPLD2               '$E149'
 define  TMRA_0_CSCTRL               '$E14A'
 define  TMRA_0_FILT                 '$E14B'
 define  TMRA_0_DMA                  '$E14C'
 define  TMRA_0_ENBL                 '$E14F'
 define  TMRA_1_COMP1                '$E150'
 define  TMRA_1_COMP2                '$E151'
 define  TMRA_1_CAPT                 '$E152'
 define  TMRA_1_LOAD                 '$E153'
 define  TMRA_1_HOLD                 '$E154'
 define  TMRA_1_CNTR                 '$E155'
 define  TMRA_1_CTRL                 '$E156'
 define  TMRA_1_SCTRL                '$E157'
 define  TMRA_1_CMPLD1               '$E158'
 define  TMRA_1_CMPLD2               '$E159'
 define  TMRA_1_CSCTRL               '$E15A'
 define  TMRA_1_FILT                 '$E15B'
 define  TMRA_1_DMA                  '$E15C'
 define  TMRA_2_COMP1                '$E160'
 define  TMRA_2_COMP2                '$E161'
 define  TMRA_2_CAPT                 '$E162'
 define  TMRA_2_LOAD                 '$E163'
 define  TMRA_2_HOLD                 '$E164'
 define  TMRA_2_CNTR                 '$E165'
 define  TMRA_2_CTRL                 '$E166'
 define  TMRA_2_SCTRL                '$E167'
 define  TMRA_2_CMPLD1               '$E168'
 define  TMRA_2_CMPLD2               '$E169'
 define  TMRA_2_CSCTRL               '$E16A'
 define  TMRA_2_FILT                 '$E16B'
 define  TMRA_2_DMA                  '$E16C'
 define  TMRA_3_COMP1                '$E170'
 define  TMRA_3_COMP2                '$E171'
 define  TMRA_3_CAPT                 '$E172'
 define  TMRA_3_LOAD                 '$E173'
 define  TMRA_3_HOLD                 '$E174'
 define  TMRA_3_CNTR                 '$E175'
 define  TMRA_3_CTRL                 '$E176'
 define  TMRA_3_SCTRL                '$E177'
 define  TMRA_3_CMPLD1               '$E178'
 define  TMRA_3_CMPLD2               '$E179'
 define  TMRA_3_CSCTRL               '$E17A'
 define  TMRA_3_FILT                 '$E17B'
 define  TMRA_3_DMA                  '$E17C'
 define  TMRB_0_COMP1                '$E180'
 define  TMRB_0_COMP2                '$E181'
 define  TMRB_0_CAPT                 '$E182'
 define  TMRB_0_LOAD                 '$E183'
 define  TMRB_0_HOLD                 '$E184'
 define  TMRB_0_CNTR                 '$E185'
 define  TMRB_0_CTRL                 '$E186'
 define  TMRB_0_SCTRL                '$E187'
 define  TMRB_0_CMPLD1               '$E188'
 define  TMRB_0_CMPLD2               '$E189'
 define  TMRB_0_CSCTRL               '$E18A'
 define  TMRB_0_FILT                 '$E18B'
 define  TMRB_0_DMA                  '$E18C'
 define  TMRB_0_ENBL                 '$E18F'
 define  TMRB_1_COMP1                '$E190'
 define  TMRB_1_COMP2                '$E191'
 define  TMRB_1_CAPT                 '$E192'
 define  TMRB_1_LOAD                 '$E193'
 define  TMRB_1_HOLD                 '$E194'
 define  TMRB_1_CNTR                 '$E195'
 define  TMRB_1_CTRL                 '$E196'
 define  TMRB_1_SCTRL                '$E197'
 define  TMRB_1_CMPLD1               '$E198'
 define  TMRB_1_CMPLD2               '$E199'
 define  TMRB_1_CSCTRL               '$E19A'
 define  TMRB_1_FILT                 '$E19B'
 define  TMRB_1_DMA                  '$E19C'
 define  TMRB_2_COMP1                '$E1A0'
 define  TMRB_2_COMP2                '$E1A1'
 define  TMRB_2_CAPT                 '$E1A2'
 define  TMRB_2_LOAD                 '$E1A3'
 define  TMRB_2_HOLD                 '$E1A4'
 define  TMRB_2_CNTR                 '$E1A5'
 define  TMRB_2_CTRL                 '$E1A6'
 define  TMRB_2_SCTRL                '$E1A7'
 define  TMRB_2_CMPLD1               '$E1A8'
 define  TMRB_2_CMPLD2               '$E1A9'
 define  TMRB_2_CSCTRL               '$E1AA'
 define  TMRB_2_FILT                 '$E1AB'
 define  TMRB_2_DMA                  '$E1AC'
 define  TMRB_3_COMP1                '$E1B0'
 define  TMRB_3_COMP2                '$E1B1'
 define  TMRB_3_CAPT                 '$E1B2'
 define  TMRB_3_LOAD                 '$E1B3'
 define  TMRB_3_HOLD                 '$E1B4'
 define  TMRB_3_CNTR                 '$E1B5'
 define  TMRB_3_CTRL                 '$E1B6'
 define  TMRB_3_SCTRL                '$E1B7'
 define  TMRB_3_CMPLD1               '$E1B8'
 define  TMRB_3_CMPLD2               '$E1B9'
 define  TMRB_3_CSCTRL               '$E1BA'
 define  TMRB_3_FILT                 '$E1BB'
 define  TMRB_3_DMA                  '$E1BC'
 define  XBARA_SEL0                  '$E340'
 define  XBARA_SEL1                  '$E341'
 define  XBARA_SEL2                  '$E342'
 define  XBARA_SEL3                  '$E343'
 define  XBARA_SEL4                  '$E344'
 define  XBARA_SEL5                  '$E345'
 define  XBARA_SEL6                  '$E346'
 define  XBARA_SEL7                  '$E347'
 define  XBARA_SEL8                  '$E348'
 define  XBARA_SEL9                  '$E349'
 define  XBARA_SEL10                 '$E34A'
 define  XBARA_SEL11                 '$E34B'
 define  XBARA_SEL12                 '$E34C'
 define  XBARA_SEL13                 '$E34D'
 define  XBARA_SEL14                 '$E34E'
 define  XBARA_SEL15                 '$E34F'
 define  XBARA_SEL16                 '$E350'
 define  XBARA_SEL17                 '$E351'
 define  XBARA_SEL18                 '$E352'
 define  XBARA_SEL19                 '$E353'
 define  XBARA_SEL20                 '$E354'
 define  XBARA_SEL21                 '$E355'
 define  XBARA_SEL22                 '$E356'
 define  XBARA_SEL23                 '$E357'
 define  XBARA_SEL24                 '$E358'
 define  XBARA_SEL25                 '$E359'
 define  XBARA_SEL26                 '$E35A'
 define  XBARA_SEL27                 '$E35B'
 define  XBARA_SEL28                 '$E35C'
 define  XBARA_SEL29                 '$E35D'
 define  XBARA_CTRL0                 '$E35E'
 define  XBARA_CTRL1                 '$E35F'
 define  XBARB_SEL0                  '$E360'
 define  XBARB_SEL1                  '$E361'
 define  XBARB_SEL2                  '$E362'
 define  XBARB_SEL3                  '$E363'
 define  XBARB_SEL4                  '$E364'
 define  XBARB_SEL5                  '$E365'
 define  XBARB_SEL6                  '$E366'
 define  XBARB_SEL7                  '$E367'
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The following section defines the IO register bitfield locations and includes some commentary on the meaning of some settings.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 set     ADC12_CTRL1_SMODE           (BIT0|BIT1|BIT2)
;;   ADC Scan Mode Control
;;     0b000 ==> Once (single) sequential
;;     0b001 ==> Once parallel
;;     0b010 ==> Loop sequential
;;     0b011 ==> Loop parallel
;;     0b100 ==> Triggered sequential
;;     0b101 ==> Triggered parallel (default)
;;     0b11x ==> Reserved
 set     ADC12_CTRL1_SMODE_0         BIT0
 set     ADC12_CTRL1_SMODE_1         BIT1
 set     ADC12_CTRL1_SMODE_2         BIT2

 set     ADC12_CTRL1_CHNCFG_L        (BIT4|BIT5|BIT6|BIT7)
;;   CHCNF (Channel Configure Low) bits
;;     0bxxx1 ==> Inputs = ANA0-ANA1
;;     0bxxx0 ==> Inputs = ANA0-ANA1
;;     0bxx1x ==> Inputs = ANA2-ANA3
;;     0bxx0x ==> Inputs = ANA2-ANA3
;;     0bx1xx ==> Inputs = ANB0-ANB1
;;     0bx0xx ==> Inputs = ANB0-ANB1
;;     0b1xxx ==> Inputs = ANB2-ANB3
 set     ADC12_CTRL1_CHNCFG_L_0      BIT4
 set     ADC12_CTRL1_CHNCFG_L_1      BIT5
 set     ADC12_CTRL1_CHNCFG_L_2      BIT6
 set     ADC12_CTRL1_CHNCFG_L_3      BIT7

 set     ADC12_CTRL1_HLMTIE          BIT8
;;   High Limit Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC12_CTRL1_LLMTIE          BIT9
;;   Low Limit Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC12_CTRL1_ZCIE            BIT10
;;   Zero Crossing Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC12_CTRL1_EOSIE0          BIT11
;;   End Of Scan Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC12_CTRL1_SYNC0           BIT12
;;   SYNC0 Enable
;;     0b0 ==> Scan is initiated by a write to CTRL1[START0] only
;;     0b1 ==> Use a SYNC0 input pulse or CTRL1[START0] to initiate a scan

 set     ADC12_CTRL1_START0          BIT13
;;   START0 Conversion
;;     0b0 ==> No action
;;     0b1 ==> Start command is issued

 set     ADC12_CTRL1_STOP0           BIT14
;;   Stop
;;     0b0 ==> Normal operation
;;     0b1 ==> Stop mode

 set     ADC12_CTRL1_DMAEN0          BIT15
;;   DMA enable
;;     0b0 ==> DMA is not enabled.
;;     0b1 ==> DMA is enabled.

 set     ADC12_CTRL2_DIV0            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Clock Divisor Select
 set     ADC12_CTRL2_DIV0_0          BIT0
 set     ADC12_CTRL2_DIV0_1          BIT1
 set     ADC12_CTRL2_DIV0_2          BIT2
 set     ADC12_CTRL2_DIV0_3          BIT3
 set     ADC12_CTRL2_DIV0_4          BIT4
 set     ADC12_CTRL2_DIV0_5          BIT5

 set     ADC12_CTRL2_SIMULT          BIT6
;;   Simultaneous mode
;;     0b0 ==> Parallel scans done independently
;;     0b1 ==> Parallel scans done simultaneously (default)

 set     ADC12_CTRL2_CHNCFG_H        (BIT7|BIT8|BIT9|BIT10)
;;   CHCNF (Channel Configure High) bits
;;     0bxxx1 ==> Inputs = ANA4-ANA5
;;     0bxxx0 ==> Inputs = ANA4-ANA5
;;     0bxx1x ==> Inputs = ANA6-ANA7
;;     0bxx0x ==> Inputs = ANA6-ANA7
;;     0bx1xx ==> Inputs = ANB4-ANB5
;;     0bx0xx ==> Inputs = ANB4-ANB5
;;     0b1xxx ==> Inputs = ANB6-ANB7
 set     ADC12_CTRL2_CHNCFG_H_0      BIT7
 set     ADC12_CTRL2_CHNCFG_H_1      BIT8
 set     ADC12_CTRL2_CHNCFG_H_2      BIT9
 set     ADC12_CTRL2_CHNCFG_H_3      BIT10

 set     ADC12_CTRL2_EOSIE1          BIT11
;;   End Of Scan Interrupt Enable
;;     0b0 ==> Interrupt disabled
;;     0b1 ==> Interrupt enabled

 set     ADC12_CTRL2_SYNC1           BIT12
;;   SYNC1 Enable
;;     0b0 ==> B converter parallel scan is initiated by a write to CTRL2[START1] bit only
;;     0b1 ==> Use a SYNC1 input pulse or CTRL2[START1] bit to initiate a B converter parallel scan

 set     ADC12_CTRL2_START1          BIT13
;;   START1 Conversion
;;     0b0 ==> No action
;;     0b1 ==> Start command is issued

 set     ADC12_CTRL2_STOP1           BIT14
;;   Stop
;;     0b0 ==> Normal operation
;;     0b1 ==> Stop mode

 set     ADC12_CTRL2_DMAEN1          BIT15
;;   DMA enable
;;     0b0 ==> DMA is not enabled.
;;     0b1 ==> DMA is enabled.

 set     ADC12_ZXCTRL1_ZCE0          (BIT0|BIT1)
;;   Zero crossing enable 0
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE0_0        BIT0
 set     ADC12_ZXCTRL1_ZCE0_1        BIT1

 set     ADC12_ZXCTRL1_ZCE1          (BIT2|BIT3)
;;   Zero crossing enable 1
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE1_0        BIT2
 set     ADC12_ZXCTRL1_ZCE1_1        BIT3

 set     ADC12_ZXCTRL1_ZCE2          (BIT4|BIT5)
;;   Zero crossing enable 2
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE2_0        BIT4
 set     ADC12_ZXCTRL1_ZCE2_1        BIT5

 set     ADC12_ZXCTRL1_ZCE3          (BIT6|BIT7)
;;   Zero crossing enable 3
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE3_0        BIT6
 set     ADC12_ZXCTRL1_ZCE3_1        BIT7

 set     ADC12_ZXCTRL1_ZCE4          (BIT8|BIT9)
;;   Zero crossing enable 4
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE4_0        BIT8
 set     ADC12_ZXCTRL1_ZCE4_1        BIT9

 set     ADC12_ZXCTRL1_ZCE5          (BIT10|BIT11)
;;   Zero crossing enable 5
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE5_0        BIT10
 set     ADC12_ZXCTRL1_ZCE5_1        BIT11

 set     ADC12_ZXCTRL1_ZCE6          (BIT12|BIT13)
;;   Zero crossing enable 6
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE6_0        BIT12
 set     ADC12_ZXCTRL1_ZCE6_1        BIT13

 set     ADC12_ZXCTRL1_ZCE7          (BIT14|BIT15)
;;   Zero crossing enable 7
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL1_ZCE7_0        BIT14
 set     ADC12_ZXCTRL1_ZCE7_1        BIT15

 set     ADC12_ZXCTRL2_ZCE8          (BIT0|BIT1)
;;   Zero crossing enable 8
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE8_0        BIT0
 set     ADC12_ZXCTRL2_ZCE8_1        BIT1

 set     ADC12_ZXCTRL2_ZCE9          (BIT2|BIT3)
;;   Zero crossing enable 9
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE9_0        BIT2
 set     ADC12_ZXCTRL2_ZCE9_1        BIT3

 set     ADC12_ZXCTRL2_ZCE10         (BIT4|BIT5)
;;   Zero crossing enable 10
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE10_0       BIT4
 set     ADC12_ZXCTRL2_ZCE10_1       BIT5

 set     ADC12_ZXCTRL2_ZCE11         (BIT6|BIT7)
;;   Zero crossing enable 11
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE11_0       BIT6
 set     ADC12_ZXCTRL2_ZCE11_1       BIT7

 set     ADC12_ZXCTRL2_ZCE12         (BIT8|BIT9)
;;   Zero crossing enable 12
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE12_0       BIT8
 set     ADC12_ZXCTRL2_ZCE12_1       BIT9

 set     ADC12_ZXCTRL2_ZCE13         (BIT10|BIT11)
;;   Zero crossing enable 13
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE13_0       BIT10
 set     ADC12_ZXCTRL2_ZCE13_1       BIT11

 set     ADC12_ZXCTRL2_ZCE14         (BIT12|BIT13)
;;   Zero crossing enable 14
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE14_0       BIT12
 set     ADC12_ZXCTRL2_ZCE14_1       BIT13

 set     ADC12_ZXCTRL2_ZCE15         (BIT14|BIT15)
;;   Zero crossing enable 15
;;     0b00 ==> Zero Crossing disabled
;;     0b01 ==> Zero Crossing enabled for positive to negative sign change
;;     0b10 ==> Zero Crossing enabled for negative to positive sign change
;;     0b11 ==> Zero Crossing enabled for any sign change
 set     ADC12_ZXCTRL2_ZCE15_0       BIT14
 set     ADC12_ZXCTRL2_ZCE15_1       BIT15

 set     ADC12_CLIST1_SAMPLE0        (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 0
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST1_SAMPLE0_0      BIT0
 set     ADC12_CLIST1_SAMPLE0_1      BIT1
 set     ADC12_CLIST1_SAMPLE0_2      BIT2
 set     ADC12_CLIST1_SAMPLE0_3      BIT3

 set     ADC12_CLIST1_SAMPLE1        (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 1
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST1_SAMPLE1_0      BIT4
 set     ADC12_CLIST1_SAMPLE1_1      BIT5
 set     ADC12_CLIST1_SAMPLE1_2      BIT6
 set     ADC12_CLIST1_SAMPLE1_3      BIT7

 set     ADC12_CLIST1_SAMPLE2        (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 2
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST1_SAMPLE2_0      BIT8
 set     ADC12_CLIST1_SAMPLE2_1      BIT9
 set     ADC12_CLIST1_SAMPLE2_2      BIT10
 set     ADC12_CLIST1_SAMPLE2_3      BIT11

 set     ADC12_CLIST1_SAMPLE3        (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 3
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST1_SAMPLE3_0      BIT12
 set     ADC12_CLIST1_SAMPLE3_1      BIT13
 set     ADC12_CLIST1_SAMPLE3_2      BIT14
 set     ADC12_CLIST1_SAMPLE3_3      BIT15

 set     ADC12_CLIST2_SAMPLE4        (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 4
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST2_SAMPLE4_0      BIT0
 set     ADC12_CLIST2_SAMPLE4_1      BIT1
 set     ADC12_CLIST2_SAMPLE4_2      BIT2
 set     ADC12_CLIST2_SAMPLE4_3      BIT3

 set     ADC12_CLIST2_SAMPLE5        (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 5
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST2_SAMPLE5_0      BIT4
 set     ADC12_CLIST2_SAMPLE5_1      BIT5
 set     ADC12_CLIST2_SAMPLE5_2      BIT6
 set     ADC12_CLIST2_SAMPLE5_3      BIT7

 set     ADC12_CLIST2_SAMPLE6        (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 6
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST2_SAMPLE6_0      BIT8
 set     ADC12_CLIST2_SAMPLE6_1      BIT9
 set     ADC12_CLIST2_SAMPLE6_2      BIT10
 set     ADC12_CLIST2_SAMPLE6_3      BIT11

 set     ADC12_CLIST2_SAMPLE7        (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 7
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST2_SAMPLE7_0      BIT12
 set     ADC12_CLIST2_SAMPLE7_1      BIT13
 set     ADC12_CLIST2_SAMPLE7_2      BIT14
 set     ADC12_CLIST2_SAMPLE7_3      BIT15

 set     ADC12_CLIST3_SAMPLE8        (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 8
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST3_SAMPLE8_0      BIT0
 set     ADC12_CLIST3_SAMPLE8_1      BIT1
 set     ADC12_CLIST3_SAMPLE8_2      BIT2
 set     ADC12_CLIST3_SAMPLE8_3      BIT3

 set     ADC12_CLIST3_SAMPLE9        (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 9
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST3_SAMPLE9_0      BIT4
 set     ADC12_CLIST3_SAMPLE9_1      BIT5
 set     ADC12_CLIST3_SAMPLE9_2      BIT6
 set     ADC12_CLIST3_SAMPLE9_3      BIT7

 set     ADC12_CLIST3_SAMPLE10       (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 10
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST3_SAMPLE10_0     BIT8
 set     ADC12_CLIST3_SAMPLE10_1     BIT9
 set     ADC12_CLIST3_SAMPLE10_2     BIT10
 set     ADC12_CLIST3_SAMPLE10_3     BIT11

 set     ADC12_CLIST3_SAMPLE11       (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 11
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST3_SAMPLE11_0     BIT12
 set     ADC12_CLIST3_SAMPLE11_1     BIT13
 set     ADC12_CLIST3_SAMPLE11_2     BIT14
 set     ADC12_CLIST3_SAMPLE11_3     BIT15

 set     ADC12_CLIST4_SAMPLE12       (BIT0|BIT1|BIT2|BIT3)
;;   Sample Field 12
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST4_SAMPLE12_0     BIT0
 set     ADC12_CLIST4_SAMPLE12_1     BIT1
 set     ADC12_CLIST4_SAMPLE12_2     BIT2
 set     ADC12_CLIST4_SAMPLE12_3     BIT3

 set     ADC12_CLIST4_SAMPLE13       (BIT4|BIT5|BIT6|BIT7)
;;   Sample Field 13
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST4_SAMPLE13_0     BIT4
 set     ADC12_CLIST4_SAMPLE13_1     BIT5
 set     ADC12_CLIST4_SAMPLE13_2     BIT6
 set     ADC12_CLIST4_SAMPLE13_3     BIT7

 set     ADC12_CLIST4_SAMPLE14       (BIT8|BIT9|BIT10|BIT11)
;;   Sample Field 14
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST4_SAMPLE14_0     BIT8
 set     ADC12_CLIST4_SAMPLE14_1     BIT9
 set     ADC12_CLIST4_SAMPLE14_2     BIT10
 set     ADC12_CLIST4_SAMPLE14_3     BIT11

 set     ADC12_CLIST4_SAMPLE15       (BIT12|BIT13|BIT14|BIT15)
;;   Sample Field 15
;;     0b0000 ==> Single Ended: ANA0, Differential: ANA0+, ANA1-
;;     0b0001 ==> Single Ended: ANA1, Differential: ANA0+, ANA1-
;;     0b0010 ==> Single Ended: ANA2, Differential: ANA2+, ANA3-
;;     0b0011 ==> Single Ended: ANA3, Differential: ANA2+, ANA3-
;;     0b0100 ==> Single Ended: ANA4, Differential: ANA4+, ANA5-
;;     0b0101 ==> Single Ended: ANA5, Differential: ANA4+, ANA5-
;;     0b0110 ==> Single Ended: ANA6, Differential: ANA6+, ANA7-
;;     0b0111 ==> Single Ended: ANA7, Differential: ANA6+, ANA7-
;;     0b1000 ==> Single Ended: ANB0, Differential: ANB0+, ANB1-
;;     0b1001 ==> Single Ended: ANB1, Differential: ANB0+, ANB1-
;;     0b1010 ==> Single Ended: ANB2, Differential: ANB2+, ANB3-
;;     0b1011 ==> Single Ended: ANB3, Differential: ANB2+, ANB3-
;;     0b1100 ==> Single Ended: ANB4, Differential: ANB4+, ANB5-
;;     0b1101 ==> Single Ended: ANB5, Differential: ANB4+, ANB5-
;;     0b1110 ==> Single Ended: ANB6, Differential: ANB6+, ANB7-
;;     0b1111 ==> Single Ended: ANB7, Differential: ANB6+, ANB7-
 set     ADC12_CLIST4_SAMPLE15_0     BIT12
 set     ADC12_CLIST4_SAMPLE15_1     BIT13
 set     ADC12_CLIST4_SAMPLE15_2     BIT14
 set     ADC12_CLIST4_SAMPLE15_3     BIT15

 set     ADC12_SDIS_DS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Disable Sample Bits
;;     0b0 ==> Enable CLIST*[SAMPLEx].
;;     0b1 ==> Disable CLIST*[SAMPLEx] and all subsequent samples. Which samples are actually disabled will depend on the conversion mode, sequential/parallel, and the value of CTRL2[SIMULT].
 set     ADC12_SDIS_DS_0             BIT0
 set     ADC12_SDIS_DS_1             BIT1
 set     ADC12_SDIS_DS_2             BIT2
 set     ADC12_SDIS_DS_3             BIT3
 set     ADC12_SDIS_DS_4             BIT4
 set     ADC12_SDIS_DS_5             BIT5
 set     ADC12_SDIS_DS_6             BIT6
 set     ADC12_SDIS_DS_7             BIT7
 set     ADC12_SDIS_DS_8             BIT8
 set     ADC12_SDIS_DS_9             BIT9
 set     ADC12_SDIS_DS_10            BIT10
 set     ADC12_SDIS_DS_11            BIT11
 set     ADC12_SDIS_DS_12            BIT12
 set     ADC12_SDIS_DS_13            BIT13
 set     ADC12_SDIS_DS_14            BIT14
 set     ADC12_SDIS_DS_15            BIT15

 set     ADC12_STAT_UNDEFINED        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     ADC12_STAT_UNDEFINED_0      BIT0
 set     ADC12_STAT_UNDEFINED_1      BIT1
 set     ADC12_STAT_UNDEFINED_2      BIT2
 set     ADC12_STAT_UNDEFINED_3      BIT3
 set     ADC12_STAT_UNDEFINED_4      BIT4
 set     ADC12_STAT_UNDEFINED_5      BIT5
 set     ADC12_STAT_UNDEFINED_6      BIT6
 set     ADC12_STAT_UNDEFINED_7      BIT7

 set     ADC12_STAT_HLMTI            BIT8
;;   High Limit Interrupt
;;     0b0 ==> No high limit interrupt request
;;     0b1 ==> High limit exceeded, IRQ pending if CTRL1[HLMTIE] is set

 set     ADC12_STAT_LLMTI            BIT9
;;   Low Limit Interrupt
;;     0b0 ==> No low limit interrupt request
;;     0b1 ==> Low limit exceeded, IRQ pending if CTRL1[LLMTIE] is set

 set     ADC12_STAT_ZCI              BIT10
;;   Zero Crossing Interrupt
;;     0b0 ==> No zero crossing interrupt request
;;     0b1 ==> Zero crossing encountered, IRQ pending if CTRL1[ZCIE] is set

 set     ADC12_STAT_EOSI0            BIT11
;;   End of Scan Interrupt
;;     0b0 ==> A scan cycle has not been completed, no end of scan IRQ pending
;;     0b1 ==> A scan cycle has been completed, end of scan IRQ pending

 set     ADC12_STAT_EOSI1            BIT12
;;   End of Scan Interrupt
;;     0b0 ==> A scan cycle has not been completed, no end of scan IRQ pending
;;     0b1 ==> A scan cycle has been completed, end of scan IRQ pending

 set     ADC12_STAT_CIP1             BIT14
;;   Conversion in Progress
;;     0b0 ==> Idle state
;;     0b1 ==> A scan cycle is in progress. The ADC will ignore all sync pulses or start commands

 set     ADC12_STAT_CIP0             BIT15
;;   Conversion in Progress
;;     0b0 ==> Idle state
;;     0b1 ==> A scan cycle is in progress. The ADC will ignore all sync pulses or start commands

 set     ADC12_RDY_RDY               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Ready Sample
;;     0b0 ==> Sample not ready or has been read
;;     0b1 ==> Sample ready to be read
 set     ADC12_RDY_RDY_0             BIT0
 set     ADC12_RDY_RDY_1             BIT1
 set     ADC12_RDY_RDY_2             BIT2
 set     ADC12_RDY_RDY_3             BIT3
 set     ADC12_RDY_RDY_4             BIT4
 set     ADC12_RDY_RDY_5             BIT5
 set     ADC12_RDY_RDY_6             BIT6
 set     ADC12_RDY_RDY_7             BIT7
 set     ADC12_RDY_RDY_8             BIT8
 set     ADC12_RDY_RDY_9             BIT9
 set     ADC12_RDY_RDY_10            BIT10
 set     ADC12_RDY_RDY_11            BIT11
 set     ADC12_RDY_RDY_12            BIT12
 set     ADC12_RDY_RDY_13            BIT13
 set     ADC12_RDY_RDY_14            BIT14
 set     ADC12_RDY_RDY_15            BIT15

 set     ADC12_LOLIMSTAT_LLS         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Low Limit Status Bits
 set     ADC12_LOLIMSTAT_LLS_0       BIT0
 set     ADC12_LOLIMSTAT_LLS_1       BIT1
 set     ADC12_LOLIMSTAT_LLS_2       BIT2
 set     ADC12_LOLIMSTAT_LLS_3       BIT3
 set     ADC12_LOLIMSTAT_LLS_4       BIT4
 set     ADC12_LOLIMSTAT_LLS_5       BIT5
 set     ADC12_LOLIMSTAT_LLS_6       BIT6
 set     ADC12_LOLIMSTAT_LLS_7       BIT7
 set     ADC12_LOLIMSTAT_LLS_8       BIT8
 set     ADC12_LOLIMSTAT_LLS_9       BIT9
 set     ADC12_LOLIMSTAT_LLS_10      BIT10
 set     ADC12_LOLIMSTAT_LLS_11      BIT11
 set     ADC12_LOLIMSTAT_LLS_12      BIT12
 set     ADC12_LOLIMSTAT_LLS_13      BIT13
 set     ADC12_LOLIMSTAT_LLS_14      BIT14
 set     ADC12_LOLIMSTAT_LLS_15      BIT15

 set     ADC12_HILIMSTAT_HLS         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   High Limit Status Bits
 set     ADC12_HILIMSTAT_HLS_0       BIT0
 set     ADC12_HILIMSTAT_HLS_1       BIT1
 set     ADC12_HILIMSTAT_HLS_2       BIT2
 set     ADC12_HILIMSTAT_HLS_3       BIT3
 set     ADC12_HILIMSTAT_HLS_4       BIT4
 set     ADC12_HILIMSTAT_HLS_5       BIT5
 set     ADC12_HILIMSTAT_HLS_6       BIT6
 set     ADC12_HILIMSTAT_HLS_7       BIT7
 set     ADC12_HILIMSTAT_HLS_8       BIT8
 set     ADC12_HILIMSTAT_HLS_9       BIT9
 set     ADC12_HILIMSTAT_HLS_10      BIT10
 set     ADC12_HILIMSTAT_HLS_11      BIT11
 set     ADC12_HILIMSTAT_HLS_12      BIT12
 set     ADC12_HILIMSTAT_HLS_13      BIT13
 set     ADC12_HILIMSTAT_HLS_14      BIT14
 set     ADC12_HILIMSTAT_HLS_15      BIT15

 set     ADC12_ZXSTAT_ZCS            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Zero Crossing Status
;;     0b0 ==> Either: A sign change did not occur in a comparison between the current channelx result and the previous channelx result, or Zero crossing control is disabled for channelx in the zero crossing control register, ZXCTRL
;;     0b1 ==> In a comparison between the current channelx result and the previous channelx result, a sign change condition occurred as defined in the zero crossing control register (ZXCTRL)
 set     ADC12_ZXSTAT_ZCS_0          BIT0
 set     ADC12_ZXSTAT_ZCS_1          BIT1
 set     ADC12_ZXSTAT_ZCS_2          BIT2
 set     ADC12_ZXSTAT_ZCS_3          BIT3
 set     ADC12_ZXSTAT_ZCS_4          BIT4
 set     ADC12_ZXSTAT_ZCS_5          BIT5
 set     ADC12_ZXSTAT_ZCS_6          BIT6
 set     ADC12_ZXSTAT_ZCS_7          BIT7
 set     ADC12_ZXSTAT_ZCS_8          BIT8
 set     ADC12_ZXSTAT_ZCS_9          BIT9
 set     ADC12_ZXSTAT_ZCS_10         BIT10
 set     ADC12_ZXSTAT_ZCS_11         BIT11
 set     ADC12_ZXSTAT_ZCS_12         BIT12
 set     ADC12_ZXSTAT_ZCS_13         BIT13
 set     ADC12_ZXSTAT_ZCS_14         BIT14
 set     ADC12_ZXSTAT_ZCS_15         BIT15

 set     ADC12_RSLT0_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT0_RSLT_0          BIT3
 set     ADC12_RSLT0_RSLT_1          BIT4
 set     ADC12_RSLT0_RSLT_2          BIT5
 set     ADC12_RSLT0_RSLT_3          BIT6
 set     ADC12_RSLT0_RSLT_4          BIT7
 set     ADC12_RSLT0_RSLT_5          BIT8
 set     ADC12_RSLT0_RSLT_6          BIT9
 set     ADC12_RSLT0_RSLT_7          BIT10
 set     ADC12_RSLT0_RSLT_8          BIT11
 set     ADC12_RSLT0_RSLT_9          BIT12
 set     ADC12_RSLT0_RSLT_10         BIT13
 set     ADC12_RSLT0_RSLT_11         BIT14

 set     ADC12_RSLT0_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT1_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT1_RSLT_0          BIT3
 set     ADC12_RSLT1_RSLT_1          BIT4
 set     ADC12_RSLT1_RSLT_2          BIT5
 set     ADC12_RSLT1_RSLT_3          BIT6
 set     ADC12_RSLT1_RSLT_4          BIT7
 set     ADC12_RSLT1_RSLT_5          BIT8
 set     ADC12_RSLT1_RSLT_6          BIT9
 set     ADC12_RSLT1_RSLT_7          BIT10
 set     ADC12_RSLT1_RSLT_8          BIT11
 set     ADC12_RSLT1_RSLT_9          BIT12
 set     ADC12_RSLT1_RSLT_10         BIT13
 set     ADC12_RSLT1_RSLT_11         BIT14

 set     ADC12_RSLT1_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT2_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT2_RSLT_0          BIT3
 set     ADC12_RSLT2_RSLT_1          BIT4
 set     ADC12_RSLT2_RSLT_2          BIT5
 set     ADC12_RSLT2_RSLT_3          BIT6
 set     ADC12_RSLT2_RSLT_4          BIT7
 set     ADC12_RSLT2_RSLT_5          BIT8
 set     ADC12_RSLT2_RSLT_6          BIT9
 set     ADC12_RSLT2_RSLT_7          BIT10
 set     ADC12_RSLT2_RSLT_8          BIT11
 set     ADC12_RSLT2_RSLT_9          BIT12
 set     ADC12_RSLT2_RSLT_10         BIT13
 set     ADC12_RSLT2_RSLT_11         BIT14

 set     ADC12_RSLT2_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT3_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT3_RSLT_0          BIT3
 set     ADC12_RSLT3_RSLT_1          BIT4
 set     ADC12_RSLT3_RSLT_2          BIT5
 set     ADC12_RSLT3_RSLT_3          BIT6
 set     ADC12_RSLT3_RSLT_4          BIT7
 set     ADC12_RSLT3_RSLT_5          BIT8
 set     ADC12_RSLT3_RSLT_6          BIT9
 set     ADC12_RSLT3_RSLT_7          BIT10
 set     ADC12_RSLT3_RSLT_8          BIT11
 set     ADC12_RSLT3_RSLT_9          BIT12
 set     ADC12_RSLT3_RSLT_10         BIT13
 set     ADC12_RSLT3_RSLT_11         BIT14

 set     ADC12_RSLT3_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT4_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT4_RSLT_0          BIT3
 set     ADC12_RSLT4_RSLT_1          BIT4
 set     ADC12_RSLT4_RSLT_2          BIT5
 set     ADC12_RSLT4_RSLT_3          BIT6
 set     ADC12_RSLT4_RSLT_4          BIT7
 set     ADC12_RSLT4_RSLT_5          BIT8
 set     ADC12_RSLT4_RSLT_6          BIT9
 set     ADC12_RSLT4_RSLT_7          BIT10
 set     ADC12_RSLT4_RSLT_8          BIT11
 set     ADC12_RSLT4_RSLT_9          BIT12
 set     ADC12_RSLT4_RSLT_10         BIT13
 set     ADC12_RSLT4_RSLT_11         BIT14

 set     ADC12_RSLT4_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT5_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT5_RSLT_0          BIT3
 set     ADC12_RSLT5_RSLT_1          BIT4
 set     ADC12_RSLT5_RSLT_2          BIT5
 set     ADC12_RSLT5_RSLT_3          BIT6
 set     ADC12_RSLT5_RSLT_4          BIT7
 set     ADC12_RSLT5_RSLT_5          BIT8
 set     ADC12_RSLT5_RSLT_6          BIT9
 set     ADC12_RSLT5_RSLT_7          BIT10
 set     ADC12_RSLT5_RSLT_8          BIT11
 set     ADC12_RSLT5_RSLT_9          BIT12
 set     ADC12_RSLT5_RSLT_10         BIT13
 set     ADC12_RSLT5_RSLT_11         BIT14

 set     ADC12_RSLT5_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT6_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT6_RSLT_0          BIT3
 set     ADC12_RSLT6_RSLT_1          BIT4
 set     ADC12_RSLT6_RSLT_2          BIT5
 set     ADC12_RSLT6_RSLT_3          BIT6
 set     ADC12_RSLT6_RSLT_4          BIT7
 set     ADC12_RSLT6_RSLT_5          BIT8
 set     ADC12_RSLT6_RSLT_6          BIT9
 set     ADC12_RSLT6_RSLT_7          BIT10
 set     ADC12_RSLT6_RSLT_8          BIT11
 set     ADC12_RSLT6_RSLT_9          BIT12
 set     ADC12_RSLT6_RSLT_10         BIT13
 set     ADC12_RSLT6_RSLT_11         BIT14

 set     ADC12_RSLT6_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT7_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT7_RSLT_0          BIT3
 set     ADC12_RSLT7_RSLT_1          BIT4
 set     ADC12_RSLT7_RSLT_2          BIT5
 set     ADC12_RSLT7_RSLT_3          BIT6
 set     ADC12_RSLT7_RSLT_4          BIT7
 set     ADC12_RSLT7_RSLT_5          BIT8
 set     ADC12_RSLT7_RSLT_6          BIT9
 set     ADC12_RSLT7_RSLT_7          BIT10
 set     ADC12_RSLT7_RSLT_8          BIT11
 set     ADC12_RSLT7_RSLT_9          BIT12
 set     ADC12_RSLT7_RSLT_10         BIT13
 set     ADC12_RSLT7_RSLT_11         BIT14

 set     ADC12_RSLT7_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT8_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT8_RSLT_0          BIT3
 set     ADC12_RSLT8_RSLT_1          BIT4
 set     ADC12_RSLT8_RSLT_2          BIT5
 set     ADC12_RSLT8_RSLT_3          BIT6
 set     ADC12_RSLT8_RSLT_4          BIT7
 set     ADC12_RSLT8_RSLT_5          BIT8
 set     ADC12_RSLT8_RSLT_6          BIT9
 set     ADC12_RSLT8_RSLT_7          BIT10
 set     ADC12_RSLT8_RSLT_8          BIT11
 set     ADC12_RSLT8_RSLT_9          BIT12
 set     ADC12_RSLT8_RSLT_10         BIT13
 set     ADC12_RSLT8_RSLT_11         BIT14

 set     ADC12_RSLT8_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT9_RSLT            (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT9_RSLT_0          BIT3
 set     ADC12_RSLT9_RSLT_1          BIT4
 set     ADC12_RSLT9_RSLT_2          BIT5
 set     ADC12_RSLT9_RSLT_3          BIT6
 set     ADC12_RSLT9_RSLT_4          BIT7
 set     ADC12_RSLT9_RSLT_5          BIT8
 set     ADC12_RSLT9_RSLT_6          BIT9
 set     ADC12_RSLT9_RSLT_7          BIT10
 set     ADC12_RSLT9_RSLT_8          BIT11
 set     ADC12_RSLT9_RSLT_9          BIT12
 set     ADC12_RSLT9_RSLT_10         BIT13
 set     ADC12_RSLT9_RSLT_11         BIT14

 set     ADC12_RSLT9_SEXT            BIT15
;;   Sign Extend

 set     ADC12_RSLT10_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT10_RSLT_0         BIT3
 set     ADC12_RSLT10_RSLT_1         BIT4
 set     ADC12_RSLT10_RSLT_2         BIT5
 set     ADC12_RSLT10_RSLT_3         BIT6
 set     ADC12_RSLT10_RSLT_4         BIT7
 set     ADC12_RSLT10_RSLT_5         BIT8
 set     ADC12_RSLT10_RSLT_6         BIT9
 set     ADC12_RSLT10_RSLT_7         BIT10
 set     ADC12_RSLT10_RSLT_8         BIT11
 set     ADC12_RSLT10_RSLT_9         BIT12
 set     ADC12_RSLT10_RSLT_10        BIT13
 set     ADC12_RSLT10_RSLT_11        BIT14

 set     ADC12_RSLT10_SEXT           BIT15
;;   Sign Extend

 set     ADC12_RSLT11_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT11_RSLT_0         BIT3
 set     ADC12_RSLT11_RSLT_1         BIT4
 set     ADC12_RSLT11_RSLT_2         BIT5
 set     ADC12_RSLT11_RSLT_3         BIT6
 set     ADC12_RSLT11_RSLT_4         BIT7
 set     ADC12_RSLT11_RSLT_5         BIT8
 set     ADC12_RSLT11_RSLT_6         BIT9
 set     ADC12_RSLT11_RSLT_7         BIT10
 set     ADC12_RSLT11_RSLT_8         BIT11
 set     ADC12_RSLT11_RSLT_9         BIT12
 set     ADC12_RSLT11_RSLT_10        BIT13
 set     ADC12_RSLT11_RSLT_11        BIT14

 set     ADC12_RSLT11_SEXT           BIT15
;;   Sign Extend

 set     ADC12_RSLT12_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT12_RSLT_0         BIT3
 set     ADC12_RSLT12_RSLT_1         BIT4
 set     ADC12_RSLT12_RSLT_2         BIT5
 set     ADC12_RSLT12_RSLT_3         BIT6
 set     ADC12_RSLT12_RSLT_4         BIT7
 set     ADC12_RSLT12_RSLT_5         BIT8
 set     ADC12_RSLT12_RSLT_6         BIT9
 set     ADC12_RSLT12_RSLT_7         BIT10
 set     ADC12_RSLT12_RSLT_8         BIT11
 set     ADC12_RSLT12_RSLT_9         BIT12
 set     ADC12_RSLT12_RSLT_10        BIT13
 set     ADC12_RSLT12_RSLT_11        BIT14

 set     ADC12_RSLT12_SEXT           BIT15
;;   Sign Extend

 set     ADC12_RSLT13_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT13_RSLT_0         BIT3
 set     ADC12_RSLT13_RSLT_1         BIT4
 set     ADC12_RSLT13_RSLT_2         BIT5
 set     ADC12_RSLT13_RSLT_3         BIT6
 set     ADC12_RSLT13_RSLT_4         BIT7
 set     ADC12_RSLT13_RSLT_5         BIT8
 set     ADC12_RSLT13_RSLT_6         BIT9
 set     ADC12_RSLT13_RSLT_7         BIT10
 set     ADC12_RSLT13_RSLT_8         BIT11
 set     ADC12_RSLT13_RSLT_9         BIT12
 set     ADC12_RSLT13_RSLT_10        BIT13
 set     ADC12_RSLT13_RSLT_11        BIT14

 set     ADC12_RSLT13_SEXT           BIT15
;;   Sign Extend

 set     ADC12_RSLT14_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT14_RSLT_0         BIT3
 set     ADC12_RSLT14_RSLT_1         BIT4
 set     ADC12_RSLT14_RSLT_2         BIT5
 set     ADC12_RSLT14_RSLT_3         BIT6
 set     ADC12_RSLT14_RSLT_4         BIT7
 set     ADC12_RSLT14_RSLT_5         BIT8
 set     ADC12_RSLT14_RSLT_6         BIT9
 set     ADC12_RSLT14_RSLT_7         BIT10
 set     ADC12_RSLT14_RSLT_8         BIT11
 set     ADC12_RSLT14_RSLT_9         BIT12
 set     ADC12_RSLT14_RSLT_10        BIT13
 set     ADC12_RSLT14_RSLT_11        BIT14

 set     ADC12_RSLT14_SEXT           BIT15
;;   Sign Extend

 set     ADC12_RSLT15_RSLT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Digital Result of the Conversion
 set     ADC12_RSLT15_RSLT_0         BIT3
 set     ADC12_RSLT15_RSLT_1         BIT4
 set     ADC12_RSLT15_RSLT_2         BIT5
 set     ADC12_RSLT15_RSLT_3         BIT6
 set     ADC12_RSLT15_RSLT_4         BIT7
 set     ADC12_RSLT15_RSLT_5         BIT8
 set     ADC12_RSLT15_RSLT_6         BIT9
 set     ADC12_RSLT15_RSLT_7         BIT10
 set     ADC12_RSLT15_RSLT_8         BIT11
 set     ADC12_RSLT15_RSLT_9         BIT12
 set     ADC12_RSLT15_RSLT_10        BIT13
 set     ADC12_RSLT15_RSLT_11        BIT14

 set     ADC12_RSLT15_SEXT           BIT15
;;   Sign Extend

 set     ADC12_LOLIM0_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM0_LLMT_0         BIT3
 set     ADC12_LOLIM0_LLMT_1         BIT4
 set     ADC12_LOLIM0_LLMT_2         BIT5
 set     ADC12_LOLIM0_LLMT_3         BIT6
 set     ADC12_LOLIM0_LLMT_4         BIT7
 set     ADC12_LOLIM0_LLMT_5         BIT8
 set     ADC12_LOLIM0_LLMT_6         BIT9
 set     ADC12_LOLIM0_LLMT_7         BIT10
 set     ADC12_LOLIM0_LLMT_8         BIT11
 set     ADC12_LOLIM0_LLMT_9         BIT12
 set     ADC12_LOLIM0_LLMT_10        BIT13
 set     ADC12_LOLIM0_LLMT_11        BIT14

 set     ADC12_LOLIM1_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM1_LLMT_0         BIT3
 set     ADC12_LOLIM1_LLMT_1         BIT4
 set     ADC12_LOLIM1_LLMT_2         BIT5
 set     ADC12_LOLIM1_LLMT_3         BIT6
 set     ADC12_LOLIM1_LLMT_4         BIT7
 set     ADC12_LOLIM1_LLMT_5         BIT8
 set     ADC12_LOLIM1_LLMT_6         BIT9
 set     ADC12_LOLIM1_LLMT_7         BIT10
 set     ADC12_LOLIM1_LLMT_8         BIT11
 set     ADC12_LOLIM1_LLMT_9         BIT12
 set     ADC12_LOLIM1_LLMT_10        BIT13
 set     ADC12_LOLIM1_LLMT_11        BIT14

 set     ADC12_LOLIM2_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM2_LLMT_0         BIT3
 set     ADC12_LOLIM2_LLMT_1         BIT4
 set     ADC12_LOLIM2_LLMT_2         BIT5
 set     ADC12_LOLIM2_LLMT_3         BIT6
 set     ADC12_LOLIM2_LLMT_4         BIT7
 set     ADC12_LOLIM2_LLMT_5         BIT8
 set     ADC12_LOLIM2_LLMT_6         BIT9
 set     ADC12_LOLIM2_LLMT_7         BIT10
 set     ADC12_LOLIM2_LLMT_8         BIT11
 set     ADC12_LOLIM2_LLMT_9         BIT12
 set     ADC12_LOLIM2_LLMT_10        BIT13
 set     ADC12_LOLIM2_LLMT_11        BIT14

 set     ADC12_LOLIM3_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM3_LLMT_0         BIT3
 set     ADC12_LOLIM3_LLMT_1         BIT4
 set     ADC12_LOLIM3_LLMT_2         BIT5
 set     ADC12_LOLIM3_LLMT_3         BIT6
 set     ADC12_LOLIM3_LLMT_4         BIT7
 set     ADC12_LOLIM3_LLMT_5         BIT8
 set     ADC12_LOLIM3_LLMT_6         BIT9
 set     ADC12_LOLIM3_LLMT_7         BIT10
 set     ADC12_LOLIM3_LLMT_8         BIT11
 set     ADC12_LOLIM3_LLMT_9         BIT12
 set     ADC12_LOLIM3_LLMT_10        BIT13
 set     ADC12_LOLIM3_LLMT_11        BIT14

 set     ADC12_LOLIM4_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM4_LLMT_0         BIT3
 set     ADC12_LOLIM4_LLMT_1         BIT4
 set     ADC12_LOLIM4_LLMT_2         BIT5
 set     ADC12_LOLIM4_LLMT_3         BIT6
 set     ADC12_LOLIM4_LLMT_4         BIT7
 set     ADC12_LOLIM4_LLMT_5         BIT8
 set     ADC12_LOLIM4_LLMT_6         BIT9
 set     ADC12_LOLIM4_LLMT_7         BIT10
 set     ADC12_LOLIM4_LLMT_8         BIT11
 set     ADC12_LOLIM4_LLMT_9         BIT12
 set     ADC12_LOLIM4_LLMT_10        BIT13
 set     ADC12_LOLIM4_LLMT_11        BIT14

 set     ADC12_LOLIM5_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM5_LLMT_0         BIT3
 set     ADC12_LOLIM5_LLMT_1         BIT4
 set     ADC12_LOLIM5_LLMT_2         BIT5
 set     ADC12_LOLIM5_LLMT_3         BIT6
 set     ADC12_LOLIM5_LLMT_4         BIT7
 set     ADC12_LOLIM5_LLMT_5         BIT8
 set     ADC12_LOLIM5_LLMT_6         BIT9
 set     ADC12_LOLIM5_LLMT_7         BIT10
 set     ADC12_LOLIM5_LLMT_8         BIT11
 set     ADC12_LOLIM5_LLMT_9         BIT12
 set     ADC12_LOLIM5_LLMT_10        BIT13
 set     ADC12_LOLIM5_LLMT_11        BIT14

 set     ADC12_LOLIM6_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM6_LLMT_0         BIT3
 set     ADC12_LOLIM6_LLMT_1         BIT4
 set     ADC12_LOLIM6_LLMT_2         BIT5
 set     ADC12_LOLIM6_LLMT_3         BIT6
 set     ADC12_LOLIM6_LLMT_4         BIT7
 set     ADC12_LOLIM6_LLMT_5         BIT8
 set     ADC12_LOLIM6_LLMT_6         BIT9
 set     ADC12_LOLIM6_LLMT_7         BIT10
 set     ADC12_LOLIM6_LLMT_8         BIT11
 set     ADC12_LOLIM6_LLMT_9         BIT12
 set     ADC12_LOLIM6_LLMT_10        BIT13
 set     ADC12_LOLIM6_LLMT_11        BIT14

 set     ADC12_LOLIM7_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM7_LLMT_0         BIT3
 set     ADC12_LOLIM7_LLMT_1         BIT4
 set     ADC12_LOLIM7_LLMT_2         BIT5
 set     ADC12_LOLIM7_LLMT_3         BIT6
 set     ADC12_LOLIM7_LLMT_4         BIT7
 set     ADC12_LOLIM7_LLMT_5         BIT8
 set     ADC12_LOLIM7_LLMT_6         BIT9
 set     ADC12_LOLIM7_LLMT_7         BIT10
 set     ADC12_LOLIM7_LLMT_8         BIT11
 set     ADC12_LOLIM7_LLMT_9         BIT12
 set     ADC12_LOLIM7_LLMT_10        BIT13
 set     ADC12_LOLIM7_LLMT_11        BIT14

 set     ADC12_LOLIM8_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM8_LLMT_0         BIT3
 set     ADC12_LOLIM8_LLMT_1         BIT4
 set     ADC12_LOLIM8_LLMT_2         BIT5
 set     ADC12_LOLIM8_LLMT_3         BIT6
 set     ADC12_LOLIM8_LLMT_4         BIT7
 set     ADC12_LOLIM8_LLMT_5         BIT8
 set     ADC12_LOLIM8_LLMT_6         BIT9
 set     ADC12_LOLIM8_LLMT_7         BIT10
 set     ADC12_LOLIM8_LLMT_8         BIT11
 set     ADC12_LOLIM8_LLMT_9         BIT12
 set     ADC12_LOLIM8_LLMT_10        BIT13
 set     ADC12_LOLIM8_LLMT_11        BIT14

 set     ADC12_LOLIM9_LLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM9_LLMT_0         BIT3
 set     ADC12_LOLIM9_LLMT_1         BIT4
 set     ADC12_LOLIM9_LLMT_2         BIT5
 set     ADC12_LOLIM9_LLMT_3         BIT6
 set     ADC12_LOLIM9_LLMT_4         BIT7
 set     ADC12_LOLIM9_LLMT_5         BIT8
 set     ADC12_LOLIM9_LLMT_6         BIT9
 set     ADC12_LOLIM9_LLMT_7         BIT10
 set     ADC12_LOLIM9_LLMT_8         BIT11
 set     ADC12_LOLIM9_LLMT_9         BIT12
 set     ADC12_LOLIM9_LLMT_10        BIT13
 set     ADC12_LOLIM9_LLMT_11        BIT14

 set     ADC12_LOLIM10_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM10_LLMT_0        BIT3
 set     ADC12_LOLIM10_LLMT_1        BIT4
 set     ADC12_LOLIM10_LLMT_2        BIT5
 set     ADC12_LOLIM10_LLMT_3        BIT6
 set     ADC12_LOLIM10_LLMT_4        BIT7
 set     ADC12_LOLIM10_LLMT_5        BIT8
 set     ADC12_LOLIM10_LLMT_6        BIT9
 set     ADC12_LOLIM10_LLMT_7        BIT10
 set     ADC12_LOLIM10_LLMT_8        BIT11
 set     ADC12_LOLIM10_LLMT_9        BIT12
 set     ADC12_LOLIM10_LLMT_10       BIT13
 set     ADC12_LOLIM10_LLMT_11       BIT14

 set     ADC12_LOLIM11_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM11_LLMT_0        BIT3
 set     ADC12_LOLIM11_LLMT_1        BIT4
 set     ADC12_LOLIM11_LLMT_2        BIT5
 set     ADC12_LOLIM11_LLMT_3        BIT6
 set     ADC12_LOLIM11_LLMT_4        BIT7
 set     ADC12_LOLIM11_LLMT_5        BIT8
 set     ADC12_LOLIM11_LLMT_6        BIT9
 set     ADC12_LOLIM11_LLMT_7        BIT10
 set     ADC12_LOLIM11_LLMT_8        BIT11
 set     ADC12_LOLIM11_LLMT_9        BIT12
 set     ADC12_LOLIM11_LLMT_10       BIT13
 set     ADC12_LOLIM11_LLMT_11       BIT14

 set     ADC12_LOLIM12_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM12_LLMT_0        BIT3
 set     ADC12_LOLIM12_LLMT_1        BIT4
 set     ADC12_LOLIM12_LLMT_2        BIT5
 set     ADC12_LOLIM12_LLMT_3        BIT6
 set     ADC12_LOLIM12_LLMT_4        BIT7
 set     ADC12_LOLIM12_LLMT_5        BIT8
 set     ADC12_LOLIM12_LLMT_6        BIT9
 set     ADC12_LOLIM12_LLMT_7        BIT10
 set     ADC12_LOLIM12_LLMT_8        BIT11
 set     ADC12_LOLIM12_LLMT_9        BIT12
 set     ADC12_LOLIM12_LLMT_10       BIT13
 set     ADC12_LOLIM12_LLMT_11       BIT14

 set     ADC12_LOLIM13_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM13_LLMT_0        BIT3
 set     ADC12_LOLIM13_LLMT_1        BIT4
 set     ADC12_LOLIM13_LLMT_2        BIT5
 set     ADC12_LOLIM13_LLMT_3        BIT6
 set     ADC12_LOLIM13_LLMT_4        BIT7
 set     ADC12_LOLIM13_LLMT_5        BIT8
 set     ADC12_LOLIM13_LLMT_6        BIT9
 set     ADC12_LOLIM13_LLMT_7        BIT10
 set     ADC12_LOLIM13_LLMT_8        BIT11
 set     ADC12_LOLIM13_LLMT_9        BIT12
 set     ADC12_LOLIM13_LLMT_10       BIT13
 set     ADC12_LOLIM13_LLMT_11       BIT14

 set     ADC12_LOLIM14_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM14_LLMT_0        BIT3
 set     ADC12_LOLIM14_LLMT_1        BIT4
 set     ADC12_LOLIM14_LLMT_2        BIT5
 set     ADC12_LOLIM14_LLMT_3        BIT6
 set     ADC12_LOLIM14_LLMT_4        BIT7
 set     ADC12_LOLIM14_LLMT_5        BIT8
 set     ADC12_LOLIM14_LLMT_6        BIT9
 set     ADC12_LOLIM14_LLMT_7        BIT10
 set     ADC12_LOLIM14_LLMT_8        BIT11
 set     ADC12_LOLIM14_LLMT_9        BIT12
 set     ADC12_LOLIM14_LLMT_10       BIT13
 set     ADC12_LOLIM14_LLMT_11       BIT14

 set     ADC12_LOLIM15_LLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Low Limit Bits
 set     ADC12_LOLIM15_LLMT_0        BIT3
 set     ADC12_LOLIM15_LLMT_1        BIT4
 set     ADC12_LOLIM15_LLMT_2        BIT5
 set     ADC12_LOLIM15_LLMT_3        BIT6
 set     ADC12_LOLIM15_LLMT_4        BIT7
 set     ADC12_LOLIM15_LLMT_5        BIT8
 set     ADC12_LOLIM15_LLMT_6        BIT9
 set     ADC12_LOLIM15_LLMT_7        BIT10
 set     ADC12_LOLIM15_LLMT_8        BIT11
 set     ADC12_LOLIM15_LLMT_9        BIT12
 set     ADC12_LOLIM15_LLMT_10       BIT13
 set     ADC12_LOLIM15_LLMT_11       BIT14

 set     ADC12_HILIM0_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM0_HLMT_0         BIT3
 set     ADC12_HILIM0_HLMT_1         BIT4
 set     ADC12_HILIM0_HLMT_2         BIT5
 set     ADC12_HILIM0_HLMT_3         BIT6
 set     ADC12_HILIM0_HLMT_4         BIT7
 set     ADC12_HILIM0_HLMT_5         BIT8
 set     ADC12_HILIM0_HLMT_6         BIT9
 set     ADC12_HILIM0_HLMT_7         BIT10
 set     ADC12_HILIM0_HLMT_8         BIT11
 set     ADC12_HILIM0_HLMT_9         BIT12
 set     ADC12_HILIM0_HLMT_10        BIT13
 set     ADC12_HILIM0_HLMT_11        BIT14

 set     ADC12_HILIM1_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM1_HLMT_0         BIT3
 set     ADC12_HILIM1_HLMT_1         BIT4
 set     ADC12_HILIM1_HLMT_2         BIT5
 set     ADC12_HILIM1_HLMT_3         BIT6
 set     ADC12_HILIM1_HLMT_4         BIT7
 set     ADC12_HILIM1_HLMT_5         BIT8
 set     ADC12_HILIM1_HLMT_6         BIT9
 set     ADC12_HILIM1_HLMT_7         BIT10
 set     ADC12_HILIM1_HLMT_8         BIT11
 set     ADC12_HILIM1_HLMT_9         BIT12
 set     ADC12_HILIM1_HLMT_10        BIT13
 set     ADC12_HILIM1_HLMT_11        BIT14

 set     ADC12_HILIM2_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM2_HLMT_0         BIT3
 set     ADC12_HILIM2_HLMT_1         BIT4
 set     ADC12_HILIM2_HLMT_2         BIT5
 set     ADC12_HILIM2_HLMT_3         BIT6
 set     ADC12_HILIM2_HLMT_4         BIT7
 set     ADC12_HILIM2_HLMT_5         BIT8
 set     ADC12_HILIM2_HLMT_6         BIT9
 set     ADC12_HILIM2_HLMT_7         BIT10
 set     ADC12_HILIM2_HLMT_8         BIT11
 set     ADC12_HILIM2_HLMT_9         BIT12
 set     ADC12_HILIM2_HLMT_10        BIT13
 set     ADC12_HILIM2_HLMT_11        BIT14

 set     ADC12_HILIM3_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM3_HLMT_0         BIT3
 set     ADC12_HILIM3_HLMT_1         BIT4
 set     ADC12_HILIM3_HLMT_2         BIT5
 set     ADC12_HILIM3_HLMT_3         BIT6
 set     ADC12_HILIM3_HLMT_4         BIT7
 set     ADC12_HILIM3_HLMT_5         BIT8
 set     ADC12_HILIM3_HLMT_6         BIT9
 set     ADC12_HILIM3_HLMT_7         BIT10
 set     ADC12_HILIM3_HLMT_8         BIT11
 set     ADC12_HILIM3_HLMT_9         BIT12
 set     ADC12_HILIM3_HLMT_10        BIT13
 set     ADC12_HILIM3_HLMT_11        BIT14

 set     ADC12_HILIM4_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM4_HLMT_0         BIT3
 set     ADC12_HILIM4_HLMT_1         BIT4
 set     ADC12_HILIM4_HLMT_2         BIT5
 set     ADC12_HILIM4_HLMT_3         BIT6
 set     ADC12_HILIM4_HLMT_4         BIT7
 set     ADC12_HILIM4_HLMT_5         BIT8
 set     ADC12_HILIM4_HLMT_6         BIT9
 set     ADC12_HILIM4_HLMT_7         BIT10
 set     ADC12_HILIM4_HLMT_8         BIT11
 set     ADC12_HILIM4_HLMT_9         BIT12
 set     ADC12_HILIM4_HLMT_10        BIT13
 set     ADC12_HILIM4_HLMT_11        BIT14

 set     ADC12_HILIM5_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM5_HLMT_0         BIT3
 set     ADC12_HILIM5_HLMT_1         BIT4
 set     ADC12_HILIM5_HLMT_2         BIT5
 set     ADC12_HILIM5_HLMT_3         BIT6
 set     ADC12_HILIM5_HLMT_4         BIT7
 set     ADC12_HILIM5_HLMT_5         BIT8
 set     ADC12_HILIM5_HLMT_6         BIT9
 set     ADC12_HILIM5_HLMT_7         BIT10
 set     ADC12_HILIM5_HLMT_8         BIT11
 set     ADC12_HILIM5_HLMT_9         BIT12
 set     ADC12_HILIM5_HLMT_10        BIT13
 set     ADC12_HILIM5_HLMT_11        BIT14

 set     ADC12_HILIM6_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM6_HLMT_0         BIT3
 set     ADC12_HILIM6_HLMT_1         BIT4
 set     ADC12_HILIM6_HLMT_2         BIT5
 set     ADC12_HILIM6_HLMT_3         BIT6
 set     ADC12_HILIM6_HLMT_4         BIT7
 set     ADC12_HILIM6_HLMT_5         BIT8
 set     ADC12_HILIM6_HLMT_6         BIT9
 set     ADC12_HILIM6_HLMT_7         BIT10
 set     ADC12_HILIM6_HLMT_8         BIT11
 set     ADC12_HILIM6_HLMT_9         BIT12
 set     ADC12_HILIM6_HLMT_10        BIT13
 set     ADC12_HILIM6_HLMT_11        BIT14

 set     ADC12_HILIM7_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM7_HLMT_0         BIT3
 set     ADC12_HILIM7_HLMT_1         BIT4
 set     ADC12_HILIM7_HLMT_2         BIT5
 set     ADC12_HILIM7_HLMT_3         BIT6
 set     ADC12_HILIM7_HLMT_4         BIT7
 set     ADC12_HILIM7_HLMT_5         BIT8
 set     ADC12_HILIM7_HLMT_6         BIT9
 set     ADC12_HILIM7_HLMT_7         BIT10
 set     ADC12_HILIM7_HLMT_8         BIT11
 set     ADC12_HILIM7_HLMT_9         BIT12
 set     ADC12_HILIM7_HLMT_10        BIT13
 set     ADC12_HILIM7_HLMT_11        BIT14

 set     ADC12_HILIM8_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM8_HLMT_0         BIT3
 set     ADC12_HILIM8_HLMT_1         BIT4
 set     ADC12_HILIM8_HLMT_2         BIT5
 set     ADC12_HILIM8_HLMT_3         BIT6
 set     ADC12_HILIM8_HLMT_4         BIT7
 set     ADC12_HILIM8_HLMT_5         BIT8
 set     ADC12_HILIM8_HLMT_6         BIT9
 set     ADC12_HILIM8_HLMT_7         BIT10
 set     ADC12_HILIM8_HLMT_8         BIT11
 set     ADC12_HILIM8_HLMT_9         BIT12
 set     ADC12_HILIM8_HLMT_10        BIT13
 set     ADC12_HILIM8_HLMT_11        BIT14

 set     ADC12_HILIM9_HLMT           (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM9_HLMT_0         BIT3
 set     ADC12_HILIM9_HLMT_1         BIT4
 set     ADC12_HILIM9_HLMT_2         BIT5
 set     ADC12_HILIM9_HLMT_3         BIT6
 set     ADC12_HILIM9_HLMT_4         BIT7
 set     ADC12_HILIM9_HLMT_5         BIT8
 set     ADC12_HILIM9_HLMT_6         BIT9
 set     ADC12_HILIM9_HLMT_7         BIT10
 set     ADC12_HILIM9_HLMT_8         BIT11
 set     ADC12_HILIM9_HLMT_9         BIT12
 set     ADC12_HILIM9_HLMT_10        BIT13
 set     ADC12_HILIM9_HLMT_11        BIT14

 set     ADC12_HILIM10_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM10_HLMT_0        BIT3
 set     ADC12_HILIM10_HLMT_1        BIT4
 set     ADC12_HILIM10_HLMT_2        BIT5
 set     ADC12_HILIM10_HLMT_3        BIT6
 set     ADC12_HILIM10_HLMT_4        BIT7
 set     ADC12_HILIM10_HLMT_5        BIT8
 set     ADC12_HILIM10_HLMT_6        BIT9
 set     ADC12_HILIM10_HLMT_7        BIT10
 set     ADC12_HILIM10_HLMT_8        BIT11
 set     ADC12_HILIM10_HLMT_9        BIT12
 set     ADC12_HILIM10_HLMT_10       BIT13
 set     ADC12_HILIM10_HLMT_11       BIT14

 set     ADC12_HILIM11_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM11_HLMT_0        BIT3
 set     ADC12_HILIM11_HLMT_1        BIT4
 set     ADC12_HILIM11_HLMT_2        BIT5
 set     ADC12_HILIM11_HLMT_3        BIT6
 set     ADC12_HILIM11_HLMT_4        BIT7
 set     ADC12_HILIM11_HLMT_5        BIT8
 set     ADC12_HILIM11_HLMT_6        BIT9
 set     ADC12_HILIM11_HLMT_7        BIT10
 set     ADC12_HILIM11_HLMT_8        BIT11
 set     ADC12_HILIM11_HLMT_9        BIT12
 set     ADC12_HILIM11_HLMT_10       BIT13
 set     ADC12_HILIM11_HLMT_11       BIT14

 set     ADC12_HILIM12_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM12_HLMT_0        BIT3
 set     ADC12_HILIM12_HLMT_1        BIT4
 set     ADC12_HILIM12_HLMT_2        BIT5
 set     ADC12_HILIM12_HLMT_3        BIT6
 set     ADC12_HILIM12_HLMT_4        BIT7
 set     ADC12_HILIM12_HLMT_5        BIT8
 set     ADC12_HILIM12_HLMT_6        BIT9
 set     ADC12_HILIM12_HLMT_7        BIT10
 set     ADC12_HILIM12_HLMT_8        BIT11
 set     ADC12_HILIM12_HLMT_9        BIT12
 set     ADC12_HILIM12_HLMT_10       BIT13
 set     ADC12_HILIM12_HLMT_11       BIT14

 set     ADC12_HILIM13_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM13_HLMT_0        BIT3
 set     ADC12_HILIM13_HLMT_1        BIT4
 set     ADC12_HILIM13_HLMT_2        BIT5
 set     ADC12_HILIM13_HLMT_3        BIT6
 set     ADC12_HILIM13_HLMT_4        BIT7
 set     ADC12_HILIM13_HLMT_5        BIT8
 set     ADC12_HILIM13_HLMT_6        BIT9
 set     ADC12_HILIM13_HLMT_7        BIT10
 set     ADC12_HILIM13_HLMT_8        BIT11
 set     ADC12_HILIM13_HLMT_9        BIT12
 set     ADC12_HILIM13_HLMT_10       BIT13
 set     ADC12_HILIM13_HLMT_11       BIT14

 set     ADC12_HILIM14_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM14_HLMT_0        BIT3
 set     ADC12_HILIM14_HLMT_1        BIT4
 set     ADC12_HILIM14_HLMT_2        BIT5
 set     ADC12_HILIM14_HLMT_3        BIT6
 set     ADC12_HILIM14_HLMT_4        BIT7
 set     ADC12_HILIM14_HLMT_5        BIT8
 set     ADC12_HILIM14_HLMT_6        BIT9
 set     ADC12_HILIM14_HLMT_7        BIT10
 set     ADC12_HILIM14_HLMT_8        BIT11
 set     ADC12_HILIM14_HLMT_9        BIT12
 set     ADC12_HILIM14_HLMT_10       BIT13
 set     ADC12_HILIM14_HLMT_11       BIT14

 set     ADC12_HILIM15_HLMT          (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   High Limit Bits
 set     ADC12_HILIM15_HLMT_0        BIT3
 set     ADC12_HILIM15_HLMT_1        BIT4
 set     ADC12_HILIM15_HLMT_2        BIT5
 set     ADC12_HILIM15_HLMT_3        BIT6
 set     ADC12_HILIM15_HLMT_4        BIT7
 set     ADC12_HILIM15_HLMT_5        BIT8
 set     ADC12_HILIM15_HLMT_6        BIT9
 set     ADC12_HILIM15_HLMT_7        BIT10
 set     ADC12_HILIM15_HLMT_8        BIT11
 set     ADC12_HILIM15_HLMT_9        BIT12
 set     ADC12_HILIM15_HLMT_10       BIT13
 set     ADC12_HILIM15_HLMT_11       BIT14

 set     ADC12_OFFST0_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST0_OFFSET_0       BIT3
 set     ADC12_OFFST0_OFFSET_1       BIT4
 set     ADC12_OFFST0_OFFSET_2       BIT5
 set     ADC12_OFFST0_OFFSET_3       BIT6
 set     ADC12_OFFST0_OFFSET_4       BIT7
 set     ADC12_OFFST0_OFFSET_5       BIT8
 set     ADC12_OFFST0_OFFSET_6       BIT9
 set     ADC12_OFFST0_OFFSET_7       BIT10
 set     ADC12_OFFST0_OFFSET_8       BIT11
 set     ADC12_OFFST0_OFFSET_9       BIT12
 set     ADC12_OFFST0_OFFSET_10      BIT13
 set     ADC12_OFFST0_OFFSET_11      BIT14

 set     ADC12_OFFST1_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST1_OFFSET_0       BIT3
 set     ADC12_OFFST1_OFFSET_1       BIT4
 set     ADC12_OFFST1_OFFSET_2       BIT5
 set     ADC12_OFFST1_OFFSET_3       BIT6
 set     ADC12_OFFST1_OFFSET_4       BIT7
 set     ADC12_OFFST1_OFFSET_5       BIT8
 set     ADC12_OFFST1_OFFSET_6       BIT9
 set     ADC12_OFFST1_OFFSET_7       BIT10
 set     ADC12_OFFST1_OFFSET_8       BIT11
 set     ADC12_OFFST1_OFFSET_9       BIT12
 set     ADC12_OFFST1_OFFSET_10      BIT13
 set     ADC12_OFFST1_OFFSET_11      BIT14

 set     ADC12_OFFST2_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST2_OFFSET_0       BIT3
 set     ADC12_OFFST2_OFFSET_1       BIT4
 set     ADC12_OFFST2_OFFSET_2       BIT5
 set     ADC12_OFFST2_OFFSET_3       BIT6
 set     ADC12_OFFST2_OFFSET_4       BIT7
 set     ADC12_OFFST2_OFFSET_5       BIT8
 set     ADC12_OFFST2_OFFSET_6       BIT9
 set     ADC12_OFFST2_OFFSET_7       BIT10
 set     ADC12_OFFST2_OFFSET_8       BIT11
 set     ADC12_OFFST2_OFFSET_9       BIT12
 set     ADC12_OFFST2_OFFSET_10      BIT13
 set     ADC12_OFFST2_OFFSET_11      BIT14

 set     ADC12_OFFST3_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST3_OFFSET_0       BIT3
 set     ADC12_OFFST3_OFFSET_1       BIT4
 set     ADC12_OFFST3_OFFSET_2       BIT5
 set     ADC12_OFFST3_OFFSET_3       BIT6
 set     ADC12_OFFST3_OFFSET_4       BIT7
 set     ADC12_OFFST3_OFFSET_5       BIT8
 set     ADC12_OFFST3_OFFSET_6       BIT9
 set     ADC12_OFFST3_OFFSET_7       BIT10
 set     ADC12_OFFST3_OFFSET_8       BIT11
 set     ADC12_OFFST3_OFFSET_9       BIT12
 set     ADC12_OFFST3_OFFSET_10      BIT13
 set     ADC12_OFFST3_OFFSET_11      BIT14

 set     ADC12_OFFST4_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST4_OFFSET_0       BIT3
 set     ADC12_OFFST4_OFFSET_1       BIT4
 set     ADC12_OFFST4_OFFSET_2       BIT5
 set     ADC12_OFFST4_OFFSET_3       BIT6
 set     ADC12_OFFST4_OFFSET_4       BIT7
 set     ADC12_OFFST4_OFFSET_5       BIT8
 set     ADC12_OFFST4_OFFSET_6       BIT9
 set     ADC12_OFFST4_OFFSET_7       BIT10
 set     ADC12_OFFST4_OFFSET_8       BIT11
 set     ADC12_OFFST4_OFFSET_9       BIT12
 set     ADC12_OFFST4_OFFSET_10      BIT13
 set     ADC12_OFFST4_OFFSET_11      BIT14

 set     ADC12_OFFST5_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST5_OFFSET_0       BIT3
 set     ADC12_OFFST5_OFFSET_1       BIT4
 set     ADC12_OFFST5_OFFSET_2       BIT5
 set     ADC12_OFFST5_OFFSET_3       BIT6
 set     ADC12_OFFST5_OFFSET_4       BIT7
 set     ADC12_OFFST5_OFFSET_5       BIT8
 set     ADC12_OFFST5_OFFSET_6       BIT9
 set     ADC12_OFFST5_OFFSET_7       BIT10
 set     ADC12_OFFST5_OFFSET_8       BIT11
 set     ADC12_OFFST5_OFFSET_9       BIT12
 set     ADC12_OFFST5_OFFSET_10      BIT13
 set     ADC12_OFFST5_OFFSET_11      BIT14

 set     ADC12_OFFST6_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST6_OFFSET_0       BIT3
 set     ADC12_OFFST6_OFFSET_1       BIT4
 set     ADC12_OFFST6_OFFSET_2       BIT5
 set     ADC12_OFFST6_OFFSET_3       BIT6
 set     ADC12_OFFST6_OFFSET_4       BIT7
 set     ADC12_OFFST6_OFFSET_5       BIT8
 set     ADC12_OFFST6_OFFSET_6       BIT9
 set     ADC12_OFFST6_OFFSET_7       BIT10
 set     ADC12_OFFST6_OFFSET_8       BIT11
 set     ADC12_OFFST6_OFFSET_9       BIT12
 set     ADC12_OFFST6_OFFSET_10      BIT13
 set     ADC12_OFFST6_OFFSET_11      BIT14

 set     ADC12_OFFST7_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST7_OFFSET_0       BIT3
 set     ADC12_OFFST7_OFFSET_1       BIT4
 set     ADC12_OFFST7_OFFSET_2       BIT5
 set     ADC12_OFFST7_OFFSET_3       BIT6
 set     ADC12_OFFST7_OFFSET_4       BIT7
 set     ADC12_OFFST7_OFFSET_5       BIT8
 set     ADC12_OFFST7_OFFSET_6       BIT9
 set     ADC12_OFFST7_OFFSET_7       BIT10
 set     ADC12_OFFST7_OFFSET_8       BIT11
 set     ADC12_OFFST7_OFFSET_9       BIT12
 set     ADC12_OFFST7_OFFSET_10      BIT13
 set     ADC12_OFFST7_OFFSET_11      BIT14

 set     ADC12_OFFST8_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST8_OFFSET_0       BIT3
 set     ADC12_OFFST8_OFFSET_1       BIT4
 set     ADC12_OFFST8_OFFSET_2       BIT5
 set     ADC12_OFFST8_OFFSET_3       BIT6
 set     ADC12_OFFST8_OFFSET_4       BIT7
 set     ADC12_OFFST8_OFFSET_5       BIT8
 set     ADC12_OFFST8_OFFSET_6       BIT9
 set     ADC12_OFFST8_OFFSET_7       BIT10
 set     ADC12_OFFST8_OFFSET_8       BIT11
 set     ADC12_OFFST8_OFFSET_9       BIT12
 set     ADC12_OFFST8_OFFSET_10      BIT13
 set     ADC12_OFFST8_OFFSET_11      BIT14

 set     ADC12_OFFST9_OFFSET         (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST9_OFFSET_0       BIT3
 set     ADC12_OFFST9_OFFSET_1       BIT4
 set     ADC12_OFFST9_OFFSET_2       BIT5
 set     ADC12_OFFST9_OFFSET_3       BIT6
 set     ADC12_OFFST9_OFFSET_4       BIT7
 set     ADC12_OFFST9_OFFSET_5       BIT8
 set     ADC12_OFFST9_OFFSET_6       BIT9
 set     ADC12_OFFST9_OFFSET_7       BIT10
 set     ADC12_OFFST9_OFFSET_8       BIT11
 set     ADC12_OFFST9_OFFSET_9       BIT12
 set     ADC12_OFFST9_OFFSET_10      BIT13
 set     ADC12_OFFST9_OFFSET_11      BIT14

 set     ADC12_OFFST10_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST10_OFFSET_0      BIT3
 set     ADC12_OFFST10_OFFSET_1      BIT4
 set     ADC12_OFFST10_OFFSET_2      BIT5
 set     ADC12_OFFST10_OFFSET_3      BIT6
 set     ADC12_OFFST10_OFFSET_4      BIT7
 set     ADC12_OFFST10_OFFSET_5      BIT8
 set     ADC12_OFFST10_OFFSET_6      BIT9
 set     ADC12_OFFST10_OFFSET_7      BIT10
 set     ADC12_OFFST10_OFFSET_8      BIT11
 set     ADC12_OFFST10_OFFSET_9      BIT12
 set     ADC12_OFFST10_OFFSET_10     BIT13
 set     ADC12_OFFST10_OFFSET_11     BIT14

 set     ADC12_OFFST11_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST11_OFFSET_0      BIT3
 set     ADC12_OFFST11_OFFSET_1      BIT4
 set     ADC12_OFFST11_OFFSET_2      BIT5
 set     ADC12_OFFST11_OFFSET_3      BIT6
 set     ADC12_OFFST11_OFFSET_4      BIT7
 set     ADC12_OFFST11_OFFSET_5      BIT8
 set     ADC12_OFFST11_OFFSET_6      BIT9
 set     ADC12_OFFST11_OFFSET_7      BIT10
 set     ADC12_OFFST11_OFFSET_8      BIT11
 set     ADC12_OFFST11_OFFSET_9      BIT12
 set     ADC12_OFFST11_OFFSET_10     BIT13
 set     ADC12_OFFST11_OFFSET_11     BIT14

 set     ADC12_OFFST12_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST12_OFFSET_0      BIT3
 set     ADC12_OFFST12_OFFSET_1      BIT4
 set     ADC12_OFFST12_OFFSET_2      BIT5
 set     ADC12_OFFST12_OFFSET_3      BIT6
 set     ADC12_OFFST12_OFFSET_4      BIT7
 set     ADC12_OFFST12_OFFSET_5      BIT8
 set     ADC12_OFFST12_OFFSET_6      BIT9
 set     ADC12_OFFST12_OFFSET_7      BIT10
 set     ADC12_OFFST12_OFFSET_8      BIT11
 set     ADC12_OFFST12_OFFSET_9      BIT12
 set     ADC12_OFFST12_OFFSET_10     BIT13
 set     ADC12_OFFST12_OFFSET_11     BIT14

 set     ADC12_OFFST13_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST13_OFFSET_0      BIT3
 set     ADC12_OFFST13_OFFSET_1      BIT4
 set     ADC12_OFFST13_OFFSET_2      BIT5
 set     ADC12_OFFST13_OFFSET_3      BIT6
 set     ADC12_OFFST13_OFFSET_4      BIT7
 set     ADC12_OFFST13_OFFSET_5      BIT8
 set     ADC12_OFFST13_OFFSET_6      BIT9
 set     ADC12_OFFST13_OFFSET_7      BIT10
 set     ADC12_OFFST13_OFFSET_8      BIT11
 set     ADC12_OFFST13_OFFSET_9      BIT12
 set     ADC12_OFFST13_OFFSET_10     BIT13
 set     ADC12_OFFST13_OFFSET_11     BIT14

 set     ADC12_OFFST14_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST14_OFFSET_0      BIT3
 set     ADC12_OFFST14_OFFSET_1      BIT4
 set     ADC12_OFFST14_OFFSET_2      BIT5
 set     ADC12_OFFST14_OFFSET_3      BIT6
 set     ADC12_OFFST14_OFFSET_4      BIT7
 set     ADC12_OFFST14_OFFSET_5      BIT8
 set     ADC12_OFFST14_OFFSET_6      BIT9
 set     ADC12_OFFST14_OFFSET_7      BIT10
 set     ADC12_OFFST14_OFFSET_8      BIT11
 set     ADC12_OFFST14_OFFSET_9      BIT12
 set     ADC12_OFFST14_OFFSET_10     BIT13
 set     ADC12_OFFST14_OFFSET_11     BIT14

 set     ADC12_OFFST15_OFFSET        (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   ADC Offset Bits
 set     ADC12_OFFST15_OFFSET_0      BIT3
 set     ADC12_OFFST15_OFFSET_1      BIT4
 set     ADC12_OFFST15_OFFSET_2      BIT5
 set     ADC12_OFFST15_OFFSET_3      BIT6
 set     ADC12_OFFST15_OFFSET_4      BIT7
 set     ADC12_OFFST15_OFFSET_5      BIT8
 set     ADC12_OFFST15_OFFSET_6      BIT9
 set     ADC12_OFFST15_OFFSET_7      BIT10
 set     ADC12_OFFST15_OFFSET_8      BIT11
 set     ADC12_OFFST15_OFFSET_9      BIT12
 set     ADC12_OFFST15_OFFSET_10     BIT13
 set     ADC12_OFFST15_OFFSET_11     BIT14

 set     ADC12_PWR_PD0               BIT0
;;   Manual Power Down for Converter A
;;     0b0 ==> Power Up ADC converter A
;;     0b1 ==> Power Down ADC converter A

 set     ADC12_PWR_PD1               BIT1
;;   Manual Power Down for Converter B
;;     0b0 ==> Power Up ADC converter B
;;     0b1 ==> Power Down ADC converter B

 set     ADC12_PWR_APD               BIT3
;;   Auto Powerdown
;;     0b0 ==> Auto Powerdown Mode is not active
;;     0b1 ==> Auto Powerdown Mode is active

 set     ADC12_PWR_PUDELAY           (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   Power Up Delay
 set     ADC12_PWR_PUDELAY_0         BIT4
 set     ADC12_PWR_PUDELAY_1         BIT5
 set     ADC12_PWR_PUDELAY_2         BIT6
 set     ADC12_PWR_PUDELAY_3         BIT7
 set     ADC12_PWR_PUDELAY_4         BIT8
 set     ADC12_PWR_PUDELAY_5         BIT9

 set     ADC12_PWR_PSTS0             BIT10
;;   ADC Converter A Power Status
;;     0b0 ==> ADC Converter A is currently powered up
;;     0b1 ==> ADC Converter A is currently powered down

 set     ADC12_PWR_PSTS1             BIT11
;;   ADC Converter B Power Status
;;     0b0 ==> ADC Converter B is currently powered up
;;     0b1 ==> ADC Converter B is currently powered down

 set     ADC12_PWR_ASB               BIT15
;;   Auto Standby
;;     0b0 ==> Auto standby mode disabled
;;     0b1 ==> Auto standby mode enabled

 set     ADC12_CAL_SEL_VREFLO_A      BIT12
;;   Select V REFLO Source
;;     0b0 ==> Internal VSSA
;;     0b1 ==> ANA3

 set     ADC12_CAL_SEL_VREFH_A       BIT13
;;   Select V REFH Source
;;     0b0 ==> Internal VDDA
;;     0b1 ==> ANA2

 set     ADC12_CAL_SEL_VREFLO_B      BIT14
;;   Select V REFLO Source
;;     0b0 ==> Internal VSSA
;;     0b1 ==> ANB3

 set     ADC12_CAL_SEL_VREFH_B       BIT15
;;   Select V REFH Source
;;     0b0 ==> Internal VDDA
;;     0b1 ==> ANB2

 set     ADC12_GC1_GAIN0             (BIT0|BIT1)
;;   Gain Control Bit 0
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN0_0           BIT0
 set     ADC12_GC1_GAIN0_1           BIT1

 set     ADC12_GC1_GAIN1             (BIT2|BIT3)
;;   Gain Control Bit 1
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN1_0           BIT2
 set     ADC12_GC1_GAIN1_1           BIT3

 set     ADC12_GC1_GAIN2             (BIT4|BIT5)
;;   Gain Control Bit 2
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN2_0           BIT4
 set     ADC12_GC1_GAIN2_1           BIT5

 set     ADC12_GC1_GAIN3             (BIT6|BIT7)
;;   Gain Control Bit 3
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN3_0           BIT6
 set     ADC12_GC1_GAIN3_1           BIT7

 set     ADC12_GC1_GAIN4             (BIT8|BIT9)
;;   Gain Control Bit 4
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN4_0           BIT8
 set     ADC12_GC1_GAIN4_1           BIT9

 set     ADC12_GC1_GAIN5             (BIT10|BIT11)
;;   Gain Control Bit 5
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN5_0           BIT10
 set     ADC12_GC1_GAIN5_1           BIT11

 set     ADC12_GC1_GAIN6             (BIT12|BIT13)
;;   Gain Control Bit 6
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN6_0           BIT12
 set     ADC12_GC1_GAIN6_1           BIT13

 set     ADC12_GC1_GAIN7             (BIT14|BIT15)
;;   Gain Control Bit 7
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC1_GAIN7_0           BIT14
 set     ADC12_GC1_GAIN7_1           BIT15

 set     ADC12_GC2_GAIN8             (BIT0|BIT1)
;;   Gain Control Bit 8
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN8_0           BIT0
 set     ADC12_GC2_GAIN8_1           BIT1

 set     ADC12_GC2_GAIN9             (BIT2|BIT3)
;;   Gain Control Bit 9
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN9_0           BIT2
 set     ADC12_GC2_GAIN9_1           BIT3

 set     ADC12_GC2_GAIN10            (BIT4|BIT5)
;;   Gain Control Bit 10
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN10_0          BIT4
 set     ADC12_GC2_GAIN10_1          BIT5

 set     ADC12_GC2_GAIN11            (BIT6|BIT7)
;;   Gain Control Bit 11
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN11_0          BIT6
 set     ADC12_GC2_GAIN11_1          BIT7

 set     ADC12_GC2_GAIN12            (BIT8|BIT9)
;;   Gain Control Bit 12
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN12_0          BIT8
 set     ADC12_GC2_GAIN12_1          BIT9

 set     ADC12_GC2_GAIN13            (BIT10|BIT11)
;;   Gain Control Bit 13
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN13_0          BIT10
 set     ADC12_GC2_GAIN13_1          BIT11

 set     ADC12_GC2_GAIN14            (BIT12|BIT13)
;;   Gain Control Bit 14
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN14_0          BIT12
 set     ADC12_GC2_GAIN14_1          BIT13

 set     ADC12_GC2_GAIN15            (BIT14|BIT15)
;;   Gain Control Bit 15
;;     0b00 ==> x1 amplification
;;     0b01 ==> x2 amplification
;;     0b10 ==> x4 amplification
;;     0b11 ==> reserved
 set     ADC12_GC2_GAIN15_0          BIT14
 set     ADC12_GC2_GAIN15_1          BIT15

 set     ADC12_SCTRL_SC              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Scan Control Bits
;;     0b0 ==> Perform sample immediately after the completion of the current sample.
;;     0b1 ==> Delay sample until a new sync input occurs.
 set     ADC12_SCTRL_SC_0            BIT0
 set     ADC12_SCTRL_SC_1            BIT1
 set     ADC12_SCTRL_SC_2            BIT2
 set     ADC12_SCTRL_SC_3            BIT3
 set     ADC12_SCTRL_SC_4            BIT4
 set     ADC12_SCTRL_SC_5            BIT5
 set     ADC12_SCTRL_SC_6            BIT6
 set     ADC12_SCTRL_SC_7            BIT7
 set     ADC12_SCTRL_SC_8            BIT8
 set     ADC12_SCTRL_SC_9            BIT9
 set     ADC12_SCTRL_SC_10           BIT10
 set     ADC12_SCTRL_SC_11           BIT11
 set     ADC12_SCTRL_SC_12           BIT12
 set     ADC12_SCTRL_SC_13           BIT13
 set     ADC12_SCTRL_SC_14           BIT14
 set     ADC12_SCTRL_SC_15           BIT15

 set     ADC12_PWR2_SPEEDA           (BIT0|BIT1)
;;   ADCA Speed Control Bits
;;     0b00 ==> Conversion clock frequency <= 5 MHz; current consumption per converter = 5 mA
;;     0b01 ==> Conversion clock frequency <= 10 MHz; current consumption per converter = 9 mA
;;     0b10 ==> Conversion clock frequency <= 15 MHz; current consumption per converter = 15 mA
;;     0b11 ==> Conversion clock frequency <= 20 MHz; current consumption per converter = 21 mA
 set     ADC12_PWR2_SPEEDA_0         BIT0
 set     ADC12_PWR2_SPEEDA_1         BIT1

 set     ADC12_PWR2_SPEEDB           (BIT2|BIT3)
;;   ADCB Speed Control Bits
;;     0b00 ==> Conversion clock frequency <= 5 MHz; current consumption per converter = 5 mA
;;     0b01 ==> Conversion clock frequency <= 10 MHz; current consumption per converter = 9 mA
;;     0b10 ==> Conversion clock frequency <= 15 MHz; current consumption per converter = 15 mA
;;     0b11 ==> Conversion clock frequency <= 20 MHz; current consumption per converter = 21 mA
 set     ADC12_PWR2_SPEEDB_0         BIT2
 set     ADC12_PWR2_SPEEDB_1         BIT3

 set     ADC12_PWR2_DIV1             (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Clock Divisor Select
 set     ADC12_PWR2_DIV1_0           BIT8
 set     ADC12_PWR2_DIV1_1           BIT9
 set     ADC12_PWR2_DIV1_2           BIT10
 set     ADC12_PWR2_DIV1_3           BIT11
 set     ADC12_PWR2_DIV1_4           BIT12
 set     ADC12_PWR2_DIV1_5           BIT13

 set     ADC12_CTRL3_SCNT0           (BIT0|BIT1|BIT2)
;;   Sample Window Count 0
 set     ADC12_CTRL3_SCNT0_0         BIT0
 set     ADC12_CTRL3_SCNT0_1         BIT1
 set     ADC12_CTRL3_SCNT0_2         BIT2

 set     ADC12_CTRL3_SCNT1           (BIT3|BIT4|BIT5)
;;   Sample Window Count 1
 set     ADC12_CTRL3_SCNT1_0         BIT3
 set     ADC12_CTRL3_SCNT1_1         BIT4
 set     ADC12_CTRL3_SCNT1_2         BIT5

 set     ADC12_CTRL3_DMASRC          BIT6
;;   DMA Trigger Source
;;     0b0 ==> DMA trigger source is end of scan interrupt
;;     0b1 ==> DMA trigger source is RDY bits

 set     ADC12_SCHLTEN_SCHLTEN       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Scan Halted Interrupt Enable
;;     0b0 ==> Scan halted interrupt is not enabled for this sample.
;;     0b1 ==> Scan halted interrupt is enabled for this sample.
 set     ADC12_SCHLTEN_SCHLTEN_0     BIT0
 set     ADC12_SCHLTEN_SCHLTEN_1     BIT1
 set     ADC12_SCHLTEN_SCHLTEN_2     BIT2
 set     ADC12_SCHLTEN_SCHLTEN_3     BIT3
 set     ADC12_SCHLTEN_SCHLTEN_4     BIT4
 set     ADC12_SCHLTEN_SCHLTEN_5     BIT5
 set     ADC12_SCHLTEN_SCHLTEN_6     BIT6
 set     ADC12_SCHLTEN_SCHLTEN_7     BIT7
 set     ADC12_SCHLTEN_SCHLTEN_8     BIT8
 set     ADC12_SCHLTEN_SCHLTEN_9     BIT9
 set     ADC12_SCHLTEN_SCHLTEN_10    BIT10
 set     ADC12_SCHLTEN_SCHLTEN_11    BIT11
 set     ADC12_SCHLTEN_SCHLTEN_12    BIT12
 set     ADC12_SCHLTEN_SCHLTEN_13    BIT13
 set     ADC12_SCHLTEN_SCHLTEN_14    BIT14
 set     ADC12_SCHLTEN_SCHLTEN_15    BIT15

 set     ADC16_SC1A_ADCH             (BIT0|BIT1|BIT2|BIT3|BIT4)
;;   Input channel select
;;     0b00000 ==> AD0 is selected as input.
;;     0b00001 ==> AD1 is selected as input.
;;     0b00010 ==> AD2 is selected as input.
;;     0b00011 ==> AD3 is selected as input.
;;     0b00100 ==> AD4 is selected as input.
;;     0b00101 ==> AD5 is selected as input.
;;     0b00110 ==> AD6 is selected as input.
;;     0b00111 ==> AD7 is selected as input.
;;     0b01000 ==> AD8 is selected as input.
;;     0b01001 ==> AD9 is selected as input.
;;     0b01010 ==> AD10 is selected as input.
;;     0b01011 ==> AD11 is selected as input.
;;     0b01100 ==> AD12 is selected as input.
;;     0b01101 ==> AD13 is selected as input.
;;     0b01110 ==> AD14 is selected as input.
;;     0b01111 ==> AD15 is selected as input.
;;     0b10000 ==> AD16 is selected as input.
;;     0b10001 ==> AD17 is selected as input.
;;     0b10010 ==> AD18 is selected as input.
;;     0b10011 ==> AD19 is selected as input.
;;     0b10100 ==> AD20 is selected as input.
;;     0b10101 ==> AD21 is selected as input.
;;     0b10110 ==> AD22 is selected as input.
;;     0b10111 ==> AD23 is selected as input.
;;     0b11000 ==> Reserved.
;;     0b11001 ==> Reserved.
;;     0b11010 ==> Temp Sensor (single-ended) is selected as input.
;;     0b11011 ==> Bandgap (single-ended) is selected as input.
;;     0b11100 ==> Reserved.
;;     0b11101 ==> VREFSH is selected as input. Voltage reference selected is determined by SC2[REFSEL].
;;     0b11110 ==> VREFSL is selected as input. Voltage reference selected is determined by SC2[REFSEL].
;;     0b11111 ==> Module is disabled.
 set     ADC16_SC1A_ADCH_0           BIT0
 set     ADC16_SC1A_ADCH_1           BIT1
 set     ADC16_SC1A_ADCH_2           BIT2
 set     ADC16_SC1A_ADCH_3           BIT3
 set     ADC16_SC1A_ADCH_4           BIT4

 set     ADC16_SC1A_AIEN             BIT6
;;   Interrupt Enable
;;     0b0 ==> Conversion complete interrupt is disabled.
;;     0b1 ==> Conversion complete interrupt is enabled.

 set     ADC16_SC1A_COCO             BIT7
;;   Conversion Complete Flag
;;     0b0 ==> Conversion is not completed.
;;     0b1 ==> Conversion is completed.

 set     ADC16_CFG1_ADICLK           (BIT0|BIT1)
;;   Input Clock Select
;;     0b00 ==> Bus clock
;;     0b01 ==> (Bus clock)/2
;;     0b10 ==> Alternate clock (ALTCLK)
;;     0b11 ==> Asynchronous clock (ADACK)
 set     ADC16_CFG1_ADICLK_0         BIT0
 set     ADC16_CFG1_ADICLK_1         BIT1

 set     ADC16_CFG1_MODE             (BIT2|BIT3)
;;   Conversion mode selection
;;     0b00 ==> It is single-ended 8-bit conversion.
;;     0b01 ==> It is single-ended 12-bit conversion .
;;     0b10 ==> It is single-ended 10-bit conversion .
;;     0b11 ==> It is single-ended 16-bit conversion.
 set     ADC16_CFG1_MODE_0           BIT2
 set     ADC16_CFG1_MODE_1           BIT3

 set     ADC16_CFG1_ADLSMP           BIT4
;;   Sample time configuration
;;     0b0 ==> Short sample time.
;;     0b1 ==> Long sample time.

 set     ADC16_CFG1_ADIV             (BIT5|BIT6)
;;   Clock Divide Select
;;     0b00 ==> The divide ratio is 1 and the clock rate is input clock.
;;     0b01 ==> The divide ratio is 2 and the clock rate is (input clock)/2.
;;     0b10 ==> The divide ratio is 4 and the clock rate is (input clock)/4.
;;     0b11 ==> The divide ratio is 8 and the clock rate is (input clock)/8.
 set     ADC16_CFG1_ADIV_0           BIT5
 set     ADC16_CFG1_ADIV_1           BIT6

 set     ADC16_CFG1_ADLPC            BIT7
;;   Low-Power Configuration
;;     0b0 ==> Normal power configuration.
;;     0b1 ==> Low-power configuration. The power is reduced at the expense of maximum clock speed.

 set     ADC16_CFG2_ADLSTS           (BIT0|BIT1)
;;   Long Sample Time Select
;;     0b00 ==> Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles total.
;;     0b01 ==> 12 extra ADCK cycles; 16 ADCK cycles total sample time.
;;     0b10 ==> 6 extra ADCK cycles; 10 ADCK cycles total sample time.
;;     0b11 ==> 2 extra ADCK cycles; 6 ADCK cycles total sample time.
 set     ADC16_CFG2_ADLSTS_0         BIT0
 set     ADC16_CFG2_ADLSTS_1         BIT1

 set     ADC16_CFG2_ADHSC            BIT2
;;   High-Speed Configuration
;;     0b0 ==> Normal conversion sequence selected.
;;     0b1 ==> High-speed conversion sequence selected with 2 additional ADCK cycles to total conversion time.

 set     ADC16_CFG2_ADACKEN          BIT3
;;   Asynchronous Clock Output Enable
;;     0b0 ==> Asynchronous clock output disabled; Asynchronous clock is enabled only if selected by ADICLK and a conversion is active.
;;     0b1 ==> Asynchronous clock and clock output is enabled regardless of the state of the ADC.

 set     ADC16_RA_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data result
 set     ADC16_RA_D_0                BIT0
 set     ADC16_RA_D_1                BIT1
 set     ADC16_RA_D_2                BIT2
 set     ADC16_RA_D_3                BIT3
 set     ADC16_RA_D_4                BIT4
 set     ADC16_RA_D_5                BIT5
 set     ADC16_RA_D_6                BIT6
 set     ADC16_RA_D_7                BIT7
 set     ADC16_RA_D_8                BIT8
 set     ADC16_RA_D_9                BIT9
 set     ADC16_RA_D_10               BIT10
 set     ADC16_RA_D_11               BIT11
 set     ADC16_RA_D_12               BIT12
 set     ADC16_RA_D_13               BIT13
 set     ADC16_RA_D_14               BIT14
 set     ADC16_RA_D_15               BIT15

 set     ADC16_CV1_CV                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Compare Value.
 set     ADC16_CV1_CV_0              BIT0
 set     ADC16_CV1_CV_1              BIT1
 set     ADC16_CV1_CV_2              BIT2
 set     ADC16_CV1_CV_3              BIT3
 set     ADC16_CV1_CV_4              BIT4
 set     ADC16_CV1_CV_5              BIT5
 set     ADC16_CV1_CV_6              BIT6
 set     ADC16_CV1_CV_7              BIT7
 set     ADC16_CV1_CV_8              BIT8
 set     ADC16_CV1_CV_9              BIT9
 set     ADC16_CV1_CV_10             BIT10
 set     ADC16_CV1_CV_11             BIT11
 set     ADC16_CV1_CV_12             BIT12
 set     ADC16_CV1_CV_13             BIT13
 set     ADC16_CV1_CV_14             BIT14
 set     ADC16_CV1_CV_15             BIT15

 set     ADC16_CV2_CV                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Compare Value.
 set     ADC16_CV2_CV_0              BIT0
 set     ADC16_CV2_CV_1              BIT1
 set     ADC16_CV2_CV_2              BIT2
 set     ADC16_CV2_CV_3              BIT3
 set     ADC16_CV2_CV_4              BIT4
 set     ADC16_CV2_CV_5              BIT5
 set     ADC16_CV2_CV_6              BIT6
 set     ADC16_CV2_CV_7              BIT7
 set     ADC16_CV2_CV_8              BIT8
 set     ADC16_CV2_CV_9              BIT9
 set     ADC16_CV2_CV_10             BIT10
 set     ADC16_CV2_CV_11             BIT11
 set     ADC16_CV2_CV_12             BIT12
 set     ADC16_CV2_CV_13             BIT13
 set     ADC16_CV2_CV_14             BIT14
 set     ADC16_CV2_CV_15             BIT15

 set     ADC16_SC2_REFSEL            (BIT0|BIT1)
;;   Voltage Reference Selection
;;     0b00 ==> Default voltage reference pin pair, that is, external pins VREFH and VREFL
;;     0b01 ==> Alternate reference pair, that is, VALTH and VALTL . This pair may be additional external pins or internal sources depending on the MCU configuration. See the chip configuration information for details specific to this MCU
;;     0b10 ==> Internal bandgap reference and associated ground reference (V BGH and V BGL ). Consult the Chip Configuration information for details specific to this MCU.
;;     0b11 ==> Reserved
 set     ADC16_SC2_REFSEL_0          BIT0
 set     ADC16_SC2_REFSEL_1          BIT1

 set     ADC16_SC2_DMAEN             BIT2
;;   DMA Enable
;;     0b0 ==> DMA is disabled.
;;     0b1 ==> DMA is enabled and will assert the ADC DMA request during an ADC conversion complete event noted when any of the SC1n[COCO] flags is asserted.

 set     ADC16_SC2_ACREN             BIT3
;;   Compare Function Range Enable
;;     0b0 ==> Range function disabled. Only CV1 is compared.
;;     0b1 ==> Range function enabled. Both CV1 and CV2 are compared.

 set     ADC16_SC2_ACFGT             BIT4
;;   Compare Function Greater Than Enable
;;     0b0 ==> Configures less than threshold, outside range not inclusive and inside range not inclusive; functionality based on the values placed in CV1 and CV2.
;;     0b1 ==> Configures greater than or equal to threshold, outside and inside ranges inclusive; functionality based on the values placed in CV1 and CV2.

 set     ADC16_SC2_ACFE              BIT5
;;   Compare Function Enable
;;     0b0 ==> Compare function disabled.
;;     0b1 ==> Compare function enabled.

 set     ADC16_SC2_ADTRG             BIT6
;;   Conversion Trigger Select
;;     0b0 ==> Software trigger selected.
;;     0b1 ==> Hardware trigger selected.

 set     ADC16_SC2_ADACT             BIT7
;;   Conversion Active
;;     0b0 ==> Conversion not in progress.
;;     0b1 ==> Conversion in progress.

 set     ADC16_SC3_AVGS              (BIT0|BIT1)
;;   Hardware Average Select
;;     0b00 ==> 4 samples averaged.
;;     0b01 ==> 8 samples averaged.
;;     0b10 ==> 16 samples averaged.
;;     0b11 ==> 32 samples averaged.
 set     ADC16_SC3_AVGS_0            BIT0
 set     ADC16_SC3_AVGS_1            BIT1

 set     ADC16_SC3_AVGE              BIT2
;;   Hardware Average Enable
;;     0b0 ==> Hardware average function disabled.
;;     0b1 ==> Hardware average function enabled.

 set     ADC16_SC3_ADCO              BIT3
;;   Continuous Conversion Enable
;;     0b0 ==> One conversion or one set of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.
;;     0b1 ==> Continuous conversions or sets of conversions if the hardware average function is enabled, that is, AVGE=1, after initiating a conversion.

 set     ADC16_SC3_ASSITRGEN         BIT4
;;   Assist Trigger Enable
;;     0b0 ==> Writes to ADCSC1 COCO bit don't have an affect on ADTRG.
;;     0b1 ==> Writes to ADCSC1 COCO bit will be reflected into ADTRG register. Note: When ASSITRGEN is set, writes to ADCSC1 are delayed by 1/2 bus cycle to allow ADCSC1 COCO write to be updated in ADTRG register so conversion type can be correctly generated (software if coco write is 0 causing ADTRG to clear or hardware type if coco write is 1.). Note: User must ensure no hardware trigger is generated between the time ADCSC1 COCO bit is written if value of ADTRG will change to guarantee
;;             correct conversion type is generated.

 set     ADC16_SC3_CALF              BIT6
;;   Calibration Failed Flag
;;     0b0 ==> Calibration completed normally.
;;     0b1 ==> Calibration failed. ADC accuracy specifications are not guaranteed.

 set     ADC16_SC3_CAL               BIT7
;;   Calibration

 set     ADC16_OFS_OFS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Offset Error Correction Value
 set     ADC16_OFS_OFS_0             BIT0
 set     ADC16_OFS_OFS_1             BIT1
 set     ADC16_OFS_OFS_2             BIT2
 set     ADC16_OFS_OFS_3             BIT3
 set     ADC16_OFS_OFS_4             BIT4
 set     ADC16_OFS_OFS_5             BIT5
 set     ADC16_OFS_OFS_6             BIT6
 set     ADC16_OFS_OFS_7             BIT7
 set     ADC16_OFS_OFS_8             BIT8
 set     ADC16_OFS_OFS_9             BIT9
 set     ADC16_OFS_OFS_10            BIT10
 set     ADC16_OFS_OFS_11            BIT11
 set     ADC16_OFS_OFS_12            BIT12
 set     ADC16_OFS_OFS_13            BIT13
 set     ADC16_OFS_OFS_14            BIT14
 set     ADC16_OFS_OFS_15            BIT15

 set     ADC16_PG_PG                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Plus-Side Gain
 set     ADC16_PG_PG_0               BIT0
 set     ADC16_PG_PG_1               BIT1
 set     ADC16_PG_PG_2               BIT2
 set     ADC16_PG_PG_3               BIT3
 set     ADC16_PG_PG_4               BIT4
 set     ADC16_PG_PG_5               BIT5
 set     ADC16_PG_PG_6               BIT6
 set     ADC16_PG_PG_7               BIT7
 set     ADC16_PG_PG_8               BIT8
 set     ADC16_PG_PG_9               BIT9
 set     ADC16_PG_PG_10              BIT10
 set     ADC16_PG_PG_11              BIT11
 set     ADC16_PG_PG_12              BIT12
 set     ADC16_PG_PG_13              BIT13
 set     ADC16_PG_PG_14              BIT14
 set     ADC16_PG_PG_15              BIT15

 set     ADC16_CLPD_CLPD             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     ADC16_CLPD_CLPD_0           BIT0
 set     ADC16_CLPD_CLPD_1           BIT1
 set     ADC16_CLPD_CLPD_2           BIT2
 set     ADC16_CLPD_CLPD_3           BIT3
 set     ADC16_CLPD_CLPD_4           BIT4
 set     ADC16_CLPD_CLPD_5           BIT5

 set     ADC16_CLPS_CLPS             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     ADC16_CLPS_CLPS_0           BIT0
 set     ADC16_CLPS_CLPS_1           BIT1
 set     ADC16_CLPS_CLPS_2           BIT2
 set     ADC16_CLPS_CLPS_3           BIT3
 set     ADC16_CLPS_CLPS_4           BIT4
 set     ADC16_CLPS_CLPS_5           BIT5

 set     ADC16_CLP4_CLP4             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
 set     ADC16_CLP4_CLP4_0           BIT0
 set     ADC16_CLP4_CLP4_1           BIT1
 set     ADC16_CLP4_CLP4_2           BIT2
 set     ADC16_CLP4_CLP4_3           BIT3
 set     ADC16_CLP4_CLP4_4           BIT4
 set     ADC16_CLP4_CLP4_5           BIT5
 set     ADC16_CLP4_CLP4_6           BIT6
 set     ADC16_CLP4_CLP4_7           BIT7
 set     ADC16_CLP4_CLP4_8           BIT8
 set     ADC16_CLP4_CLP4_9           BIT9

 set     ADC16_CLP3_CLP3             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
 set     ADC16_CLP3_CLP3_0           BIT0
 set     ADC16_CLP3_CLP3_1           BIT1
 set     ADC16_CLP3_CLP3_2           BIT2
 set     ADC16_CLP3_CLP3_3           BIT3
 set     ADC16_CLP3_CLP3_4           BIT4
 set     ADC16_CLP3_CLP3_5           BIT5
 set     ADC16_CLP3_CLP3_6           BIT6
 set     ADC16_CLP3_CLP3_7           BIT7
 set     ADC16_CLP3_CLP3_8           BIT8

 set     ADC16_CLP2_CLP2             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     ADC16_CLP2_CLP2_0           BIT0
 set     ADC16_CLP2_CLP2_1           BIT1
 set     ADC16_CLP2_CLP2_2           BIT2
 set     ADC16_CLP2_CLP2_3           BIT3
 set     ADC16_CLP2_CLP2_4           BIT4
 set     ADC16_CLP2_CLP2_5           BIT5
 set     ADC16_CLP2_CLP2_6           BIT6
 set     ADC16_CLP2_CLP2_7           BIT7

 set     ADC16_CLP1_CLP1             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
 set     ADC16_CLP1_CLP1_0           BIT0
 set     ADC16_CLP1_CLP1_1           BIT1
 set     ADC16_CLP1_CLP1_2           BIT2
 set     ADC16_CLP1_CLP1_3           BIT3
 set     ADC16_CLP1_CLP1_4           BIT4
 set     ADC16_CLP1_CLP1_5           BIT5
 set     ADC16_CLP1_CLP1_6           BIT6

 set     ADC16_CLP0_CLP0             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
 set     ADC16_CLP0_CLP0_0           BIT0
 set     ADC16_CLP0_CLP0_1           BIT1
 set     ADC16_CLP0_CLP0_2           BIT2
 set     ADC16_CLP0_CLP0_3           BIT3
 set     ADC16_CLP0_CLP0_4           BIT4
 set     ADC16_CLP0_CLP0_5           BIT5

 set     AOI_BFCRT010_PT1_DC         (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT010_PT1_DC_0       BIT0
 set     AOI_BFCRT010_PT1_DC_1       BIT1

 set     AOI_BFCRT010_PT1_CC         (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT010_PT1_CC_0       BIT2
 set     AOI_BFCRT010_PT1_CC_1       BIT3

 set     AOI_BFCRT010_PT1_BC         (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT010_PT1_BC_0       BIT4
 set     AOI_BFCRT010_PT1_BC_1       BIT5

 set     AOI_BFCRT010_PT1_AC         (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT010_PT1_AC_0       BIT6
 set     AOI_BFCRT010_PT1_AC_1       BIT7

 set     AOI_BFCRT010_PT0_DC         (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT010_PT0_DC_0       BIT8
 set     AOI_BFCRT010_PT0_DC_1       BIT9

 set     AOI_BFCRT010_PT0_CC         (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT010_PT0_CC_0       BIT10
 set     AOI_BFCRT010_PT0_CC_1       BIT11

 set     AOI_BFCRT010_PT0_BC         (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT010_PT0_BC_0       BIT12
 set     AOI_BFCRT010_PT0_BC_1       BIT13

 set     AOI_BFCRT010_PT0_AC         (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT010_PT0_AC_0       BIT14
 set     AOI_BFCRT010_PT0_AC_1       BIT15

 set     AOI_BFCRT230_PT3_DC         (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT230_PT3_DC_0       BIT0
 set     AOI_BFCRT230_PT3_DC_1       BIT1

 set     AOI_BFCRT230_PT3_CC         (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT230_PT3_CC_0       BIT2
 set     AOI_BFCRT230_PT3_CC_1       BIT3

 set     AOI_BFCRT230_PT3_BC         (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT230_PT3_BC_0       BIT4
 set     AOI_BFCRT230_PT3_BC_1       BIT5

 set     AOI_BFCRT230_PT3_AC         (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT230_PT3_AC_0       BIT6
 set     AOI_BFCRT230_PT3_AC_1       BIT7

 set     AOI_BFCRT230_PT2_DC         (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT230_PT2_DC_0       BIT8
 set     AOI_BFCRT230_PT2_DC_1       BIT9

 set     AOI_BFCRT230_PT2_CC         (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT230_PT2_CC_0       BIT10
 set     AOI_BFCRT230_PT2_CC_1       BIT11

 set     AOI_BFCRT230_PT2_BC         (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT230_PT2_BC_0       BIT12
 set     AOI_BFCRT230_PT2_BC_1       BIT13

 set     AOI_BFCRT230_PT2_AC         (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT230_PT2_AC_0       BIT14
 set     AOI_BFCRT230_PT2_AC_1       BIT15

 set     AOI_BFCRT011_PT1_DC         (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT011_PT1_DC_0       BIT0
 set     AOI_BFCRT011_PT1_DC_1       BIT1

 set     AOI_BFCRT011_PT1_CC         (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT011_PT1_CC_0       BIT2
 set     AOI_BFCRT011_PT1_CC_1       BIT3

 set     AOI_BFCRT011_PT1_BC         (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT011_PT1_BC_0       BIT4
 set     AOI_BFCRT011_PT1_BC_1       BIT5

 set     AOI_BFCRT011_PT1_AC         (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT011_PT1_AC_0       BIT6
 set     AOI_BFCRT011_PT1_AC_1       BIT7

 set     AOI_BFCRT011_PT0_DC         (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT011_PT0_DC_0       BIT8
 set     AOI_BFCRT011_PT0_DC_1       BIT9

 set     AOI_BFCRT011_PT0_CC         (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT011_PT0_CC_0       BIT10
 set     AOI_BFCRT011_PT0_CC_1       BIT11

 set     AOI_BFCRT011_PT0_BC         (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT011_PT0_BC_0       BIT12
 set     AOI_BFCRT011_PT0_BC_1       BIT13

 set     AOI_BFCRT011_PT0_AC         (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT011_PT0_AC_0       BIT14
 set     AOI_BFCRT011_PT0_AC_1       BIT15

 set     AOI_BFCRT231_PT3_DC         (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT231_PT3_DC_0       BIT0
 set     AOI_BFCRT231_PT3_DC_1       BIT1

 set     AOI_BFCRT231_PT3_CC         (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT231_PT3_CC_0       BIT2
 set     AOI_BFCRT231_PT3_CC_1       BIT3

 set     AOI_BFCRT231_PT3_BC         (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT231_PT3_BC_0       BIT4
 set     AOI_BFCRT231_PT3_BC_1       BIT5

 set     AOI_BFCRT231_PT3_AC         (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT231_PT3_AC_0       BIT6
 set     AOI_BFCRT231_PT3_AC_1       BIT7

 set     AOI_BFCRT231_PT2_DC         (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT231_PT2_DC_0       BIT8
 set     AOI_BFCRT231_PT2_DC_1       BIT9

 set     AOI_BFCRT231_PT2_CC         (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT231_PT2_CC_0       BIT10
 set     AOI_BFCRT231_PT2_CC_1       BIT11

 set     AOI_BFCRT231_PT2_BC         (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT231_PT2_BC_0       BIT12
 set     AOI_BFCRT231_PT2_BC_1       BIT13

 set     AOI_BFCRT231_PT2_AC         (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT231_PT2_AC_0       BIT14
 set     AOI_BFCRT231_PT2_AC_1       BIT15

 set     AOI_BFCRT012_PT1_DC         (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT012_PT1_DC_0       BIT0
 set     AOI_BFCRT012_PT1_DC_1       BIT1

 set     AOI_BFCRT012_PT1_CC         (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT012_PT1_CC_0       BIT2
 set     AOI_BFCRT012_PT1_CC_1       BIT3

 set     AOI_BFCRT012_PT1_BC         (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT012_PT1_BC_0       BIT4
 set     AOI_BFCRT012_PT1_BC_1       BIT5

 set     AOI_BFCRT012_PT1_AC         (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT012_PT1_AC_0       BIT6
 set     AOI_BFCRT012_PT1_AC_1       BIT7

 set     AOI_BFCRT012_PT0_DC         (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT012_PT0_DC_0       BIT8
 set     AOI_BFCRT012_PT0_DC_1       BIT9

 set     AOI_BFCRT012_PT0_CC         (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT012_PT0_CC_0       BIT10
 set     AOI_BFCRT012_PT0_CC_1       BIT11

 set     AOI_BFCRT012_PT0_BC         (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT012_PT0_BC_0       BIT12
 set     AOI_BFCRT012_PT0_BC_1       BIT13

 set     AOI_BFCRT012_PT0_AC         (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT012_PT0_AC_0       BIT14
 set     AOI_BFCRT012_PT0_AC_1       BIT15

 set     AOI_BFCRT232_PT3_DC         (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT232_PT3_DC_0       BIT0
 set     AOI_BFCRT232_PT3_DC_1       BIT1

 set     AOI_BFCRT232_PT3_CC         (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT232_PT3_CC_0       BIT2
 set     AOI_BFCRT232_PT3_CC_1       BIT3

 set     AOI_BFCRT232_PT3_BC         (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT232_PT3_BC_0       BIT4
 set     AOI_BFCRT232_PT3_BC_1       BIT5

 set     AOI_BFCRT232_PT3_AC         (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT232_PT3_AC_0       BIT6
 set     AOI_BFCRT232_PT3_AC_1       BIT7

 set     AOI_BFCRT232_PT2_DC         (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT232_PT2_DC_0       BIT8
 set     AOI_BFCRT232_PT2_DC_1       BIT9

 set     AOI_BFCRT232_PT2_CC         (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT232_PT2_CC_0       BIT10
 set     AOI_BFCRT232_PT2_CC_1       BIT11

 set     AOI_BFCRT232_PT2_BC         (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT232_PT2_BC_0       BIT12
 set     AOI_BFCRT232_PT2_BC_1       BIT13

 set     AOI_BFCRT232_PT2_AC         (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT232_PT2_AC_0       BIT14
 set     AOI_BFCRT232_PT2_AC_1       BIT15

 set     AOI_BFCRT013_PT1_DC         (BIT0|BIT1)
;;   Product term 1, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT013_PT1_DC_0       BIT0
 set     AOI_BFCRT013_PT1_DC_1       BIT1

 set     AOI_BFCRT013_PT1_CC         (BIT2|BIT3)
;;   Product term 1, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT013_PT1_CC_0       BIT2
 set     AOI_BFCRT013_PT1_CC_1       BIT3

 set     AOI_BFCRT013_PT1_BC         (BIT4|BIT5)
;;   Product term 1, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT013_PT1_BC_0       BIT4
 set     AOI_BFCRT013_PT1_BC_1       BIT5

 set     AOI_BFCRT013_PT1_AC         (BIT6|BIT7)
;;   Product term 1, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT013_PT1_AC_0       BIT6
 set     AOI_BFCRT013_PT1_AC_1       BIT7

 set     AOI_BFCRT013_PT0_DC         (BIT8|BIT9)
;;   Product term 0, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT013_PT0_DC_0       BIT8
 set     AOI_BFCRT013_PT0_DC_1       BIT9

 set     AOI_BFCRT013_PT0_CC         (BIT10|BIT11)
;;   Product term 0, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT013_PT0_CC_0       BIT10
 set     AOI_BFCRT013_PT0_CC_1       BIT11

 set     AOI_BFCRT013_PT0_BC         (BIT12|BIT13)
;;   Product term 0, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT013_PT0_BC_0       BIT12
 set     AOI_BFCRT013_PT0_BC_1       BIT13

 set     AOI_BFCRT013_PT0_AC         (BIT14|BIT15)
;;   Product term 0, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT013_PT0_AC_0       BIT14
 set     AOI_BFCRT013_PT0_AC_1       BIT15

 set     AOI_BFCRT233_PT3_DC         (BIT0|BIT1)
;;   Product term 3, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT233_PT3_DC_0       BIT0
 set     AOI_BFCRT233_PT3_DC_1       BIT1

 set     AOI_BFCRT233_PT3_CC         (BIT2|BIT3)
;;   Product term 3, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT233_PT3_CC_0       BIT2
 set     AOI_BFCRT233_PT3_CC_1       BIT3

 set     AOI_BFCRT233_PT3_BC         (BIT4|BIT5)
;;   Product term 3, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT233_PT3_BC_0       BIT4
 set     AOI_BFCRT233_PT3_BC_1       BIT5

 set     AOI_BFCRT233_PT3_AC         (BIT6|BIT7)
;;   Product term 3, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT233_PT3_AC_0       BIT6
 set     AOI_BFCRT233_PT3_AC_1       BIT7

 set     AOI_BFCRT233_PT2_DC         (BIT8|BIT9)
;;   Product term 2, D input configuration
;;     0b00 ==> Force the D input in this product term to a logical zero
;;     0b01 ==> Pass the D input in this product term
;;     0b10 ==> Complement the D input in this product term
;;     0b11 ==> Force the D input in this product term to a logical one
 set     AOI_BFCRT233_PT2_DC_0       BIT8
 set     AOI_BFCRT233_PT2_DC_1       BIT9

 set     AOI_BFCRT233_PT2_CC         (BIT10|BIT11)
;;   Product term 2, C input configuration
;;     0b00 ==> Force the C input in this product term to a logical zero
;;     0b01 ==> Pass the C input in this product term
;;     0b10 ==> Complement the C input in this product term
;;     0b11 ==> Force the C input in this product term to a logical one
 set     AOI_BFCRT233_PT2_CC_0       BIT10
 set     AOI_BFCRT233_PT2_CC_1       BIT11

 set     AOI_BFCRT233_PT2_BC         (BIT12|BIT13)
;;   Product term 2, B input configuration
;;     0b00 ==> Force the B input in this product term to a logical zero
;;     0b01 ==> Pass the B input in this product term
;;     0b10 ==> Complement the B input in this product term
;;     0b11 ==> Force the B input in this product term to a logical one
 set     AOI_BFCRT233_PT2_BC_0       BIT12
 set     AOI_BFCRT233_PT2_BC_1       BIT13

 set     AOI_BFCRT233_PT2_AC         (BIT14|BIT15)
;;   Product term 2, A input configuration
;;     0b00 ==> Force the A input in this product term to a logical zero
;;     0b01 ==> Pass the A input in this product term
;;     0b10 ==> Complement the A input in this product term
;;     0b11 ==> Force the A input in this product term to a logical one
 set     AOI_BFCRT233_PT2_AC_0       BIT14
 set     AOI_BFCRT233_PT2_AC_1       BIT15

 set     CAN_MCR_MAXMB               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Number Of The Last Message Buffer
 set     CAN_MCR_MAXMB_0             BIT0
 set     CAN_MCR_MAXMB_1             BIT1
 set     CAN_MCR_MAXMB_2             BIT2
 set     CAN_MCR_MAXMB_3             BIT3
 set     CAN_MCR_MAXMB_4             BIT4
 set     CAN_MCR_MAXMB_5             BIT5
 set     CAN_MCR_MAXMB_6             BIT6

 set     CAN_MCR_IDAM                (BIT8|BIT9)
;;   ID Acceptance Mode
;;     0b00 ==> Format A: One full ID (standard and extended) per ID Filter Table element.
;;     0b01 ==> Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID Filter Table element.
;;     0b10 ==> Format C: Four partial 8-bit Standard IDs per ID Filter Table element.
;;     0b11 ==> Format D: All frames rejected.
 set     CAN_MCR_IDAM_0              BIT8
 set     CAN_MCR_IDAM_1              BIT9

 set     CAN_MCR_AEN                 BIT12
;;   Abort Enable
;;     0b0 ==> Abort disabled.
;;     0b1 ==> Abort enabled.

 set     CAN_MCR_LPRIOEN             BIT13
;;   Local Priority Enable
;;     0b0 ==> Local Priority disabled.
;;     0b1 ==> Local Priority enabled.

 set     CAN_MCR_IRMQ                BIT16
;;   Individual Rx Masking And Queue Enable
;;     0b0 ==> Individual Rx masking and queue feature are disabled. For backward compatibility with legacy applications, the reading of C/S word locks the MB even if it is EMPTY.
;;     0b1 ==> Individual Rx masking and queue feature are enabled.

 set     CAN_MCR_SRXDIS              BIT17
;;   Self Reception Disable
;;     0b0 ==> Self reception enabled.
;;     0b1 ==> Self reception disabled.

 set     CAN_MCR_DOZE                BIT18
;;   Doze Mode Enable
;;     0b0 ==> FlexCAN is not enabled to enter low-power mode when Doze mode is requested.
;;     0b1 ==> FlexCAN is enabled to enter low-power mode when Doze mode is requested.

 set     CAN_MCR_WAKSRC              BIT19
;;   Wake Up Source
;;     0b0 ==> FlexCAN uses the unfiltered Rx input to detect recessive to dominant edges on the CAN bus.
;;     0b1 ==> FlexCAN uses the filtered Rx input to detect recessive to dominant edges on the CAN bus.

 set     CAN_MCR_LPMACK              BIT20
;;   Low-Power Mode Acknowledge
;;     0b0 ==> FlexCAN is not in a low-power mode.
;;     0b1 ==> FlexCAN is in a low-power mode.

 set     CAN_MCR_WRNEN               BIT21
;;   Warning Interrupt Enable
;;     0b0 ==> TWRNINT and RWRNINT bits are zero, independent of the values in the error counters.
;;     0b1 ==> TWRNINT and RWRNINT bits are set when the respective error counter transitions from less than 96 to greater than or equal to 96.

 set     CAN_MCR_SLFWAK              BIT22
;;   Self Wake Up
;;     0b0 ==> FlexCAN Self Wake Up feature is disabled.
;;     0b1 ==> FlexCAN Self Wake Up feature is enabled.

 set     CAN_MCR_SUPV                BIT23
;;   Supervisor Mode
;;     0b0 ==> FlexCAN is in User mode. Affected registers allow both Supervisor and Unrestricted accesses .
;;     0b1 ==> FlexCAN is in Supervisor mode. Affected registers allow only Supervisor access. Unrestricted access behaves as though the access was done to an unimplemented register location .

 set     CAN_MCR_FRZACK              BIT24
;;   Freeze Mode Acknowledge
;;     0b0 ==> FlexCAN not in Freeze mode, prescaler running.
;;     0b1 ==> FlexCAN in Freeze mode, prescaler stopped.

 set     CAN_MCR_SOFTRST             BIT25
;;   Soft Reset
;;     0b0 ==> No reset request.
;;     0b1 ==> Resets the registers affected by soft reset.

 set     CAN_MCR_WAKMSK              BIT26
;;   Wake Up Interrupt Mask
;;     0b0 ==> Wake Up Interrupt is disabled.
;;     0b1 ==> Wake Up Interrupt is enabled.

 set     CAN_MCR_NOTRDY              BIT27
;;   FlexCAN Not Ready
;;     0b0 ==> FlexCAN module is either in Normal mode, Listen-Only mode or Loop-Back mode.
;;     0b1 ==> FlexCAN module is either in Disable mode , Doze mode , Stop mode or Freeze mode.

 set     CAN_MCR_HALT                BIT28
;;   Halt FlexCAN
;;     0b0 ==> No Freeze mode request.
;;     0b1 ==> Enters Freeze mode if the FRZ bit is asserted.

 set     CAN_MCR_RFEN                BIT29
;;   Rx FIFO Enable
;;     0b0 ==> Rx FIFO not enabled.
;;     0b1 ==> Rx FIFO enabled.

 set     CAN_MCR_FRZ                 BIT30
;;   Freeze Enable
;;     0b0 ==> Not enabled to enter Freeze mode.
;;     0b1 ==> Enabled to enter Freeze mode.

 set     CAN_MCR_MDIS                BIT31
;;   Module Disable
;;     0b0 ==> Enable the FlexCAN module.
;;     0b1 ==> Disable the FlexCAN module.

 set     CAN_CTRL1_PROPSEG           (BIT0|BIT1|BIT2)
;;   Propagation Segment
 set     CAN_CTRL1_PROPSEG_0         BIT0
 set     CAN_CTRL1_PROPSEG_1         BIT1
 set     CAN_CTRL1_PROPSEG_2         BIT2

 set     CAN_CTRL1_LOM               BIT3
;;   Listen-Only Mode
;;     0b0 ==> Listen-Only mode is deactivated.
;;     0b1 ==> FlexCAN module operates in Listen-Only mode.

 set     CAN_CTRL1_LBUF              BIT4
;;   Lowest Buffer Transmitted First
;;     0b0 ==> Buffer with highest priority is transmitted first.
;;     0b1 ==> Lowest number buffer is transmitted first.

 set     CAN_CTRL1_TSYN              BIT5
;;   Timer Sync
;;     0b0 ==> Timer Sync feature disabled
;;     0b1 ==> Timer Sync feature enabled

 set     CAN_CTRL1_BOFFREC           BIT6
;;   Bus Off Recovery
;;     0b0 ==> Automatic recovering from Bus Off state enabled, according to CAN Spec 2.0 part B.
;;     0b1 ==> Automatic recovering from Bus Off state disabled.

 set     CAN_CTRL1_SMP               BIT7
;;   CAN Bit Sampling
;;     0b0 ==> Just one sample is used to determine the bit value.
;;     0b1 ==> Three samples are used to determine the value of the received bit: the regular one (sample point) and 2 preceding samples; a majority rule is used.

 set     CAN_CTRL1_RWRNMSK           BIT10
;;   Rx Warning Interrupt Mask
;;     0b0 ==> Rx Warning Interrupt disabled.
;;     0b1 ==> Rx Warning Interrupt enabled.

 set     CAN_CTRL1_TWRNMSK           BIT11
;;   Tx Warning Interrupt Mask
;;     0b0 ==> Tx Warning Interrupt disabled.
;;     0b1 ==> Tx Warning Interrupt enabled.

 set     CAN_CTRL1_LPB               BIT12
;;   Loop Back Mode
;;     0b0 ==> Loop Back disabled.
;;     0b1 ==> Loop Back enabled.

 set     CAN_CTRL1_CLKSRC            BIT13
;;   CAN Engine Clock Source
;;     0b0 ==> The CAN engine clock source is the oscillator clock. Under this condition, the oscillator clock frequency must be lower than the bus clock.
;;     0b1 ==> The CAN engine clock source is the peripheral clock.

 set     CAN_CTRL1_ERRMSK            BIT14
;;   Error Mask
;;     0b0 ==> Error interrupt disabled.
;;     0b1 ==> Error interrupt enabled.

 set     CAN_CTRL1_BOFFMSK           BIT15
;;   Bus Off Mask
;;     0b0 ==> Bus Off interrupt disabled.
;;     0b1 ==> Bus Off interrupt enabled.

 set     CAN_CTRL1_PSEG2             (BIT16|BIT17|BIT18)
;;   Phase Segment 2
 set     CAN_CTRL1_PSEG2_0           BIT16
 set     CAN_CTRL1_PSEG2_1           BIT17
 set     CAN_CTRL1_PSEG2_2           BIT18

 set     CAN_CTRL1_PSEG1             (BIT19|BIT20|BIT21)
;;   Phase Segment 1
 set     CAN_CTRL1_PSEG1_0           BIT19
 set     CAN_CTRL1_PSEG1_1           BIT20
 set     CAN_CTRL1_PSEG1_2           BIT21

 set     CAN_CTRL1_RJW               (BIT22|BIT23)
;;   Resync Jump Width
 set     CAN_CTRL1_RJW_0             BIT22
 set     CAN_CTRL1_RJW_1             BIT23

 set     CAN_CTRL1_PRESDIV           (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Prescaler Division Factor
 set     CAN_CTRL1_PRESDIV_0         BIT24
 set     CAN_CTRL1_PRESDIV_1         BIT25
 set     CAN_CTRL1_PRESDIV_2         BIT26
 set     CAN_CTRL1_PRESDIV_3         BIT27
 set     CAN_CTRL1_PRESDIV_4         BIT28
 set     CAN_CTRL1_PRESDIV_5         BIT29
 set     CAN_CTRL1_PRESDIV_6         BIT30
 set     CAN_CTRL1_PRESDIV_7         BIT31

 set     CAN_TIMER_TIMER             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Timer Value
 set     CAN_TIMER_TIMER_0           BIT0
 set     CAN_TIMER_TIMER_1           BIT1
 set     CAN_TIMER_TIMER_2           BIT2
 set     CAN_TIMER_TIMER_3           BIT3
 set     CAN_TIMER_TIMER_4           BIT4
 set     CAN_TIMER_TIMER_5           BIT5
 set     CAN_TIMER_TIMER_6           BIT6
 set     CAN_TIMER_TIMER_7           BIT7
 set     CAN_TIMER_TIMER_8           BIT8
 set     CAN_TIMER_TIMER_9           BIT9
 set     CAN_TIMER_TIMER_10          BIT10
 set     CAN_TIMER_TIMER_11          BIT11
 set     CAN_TIMER_TIMER_12          BIT12
 set     CAN_TIMER_TIMER_13          BIT13
 set     CAN_TIMER_TIMER_14          BIT14
 set     CAN_TIMER_TIMER_15          BIT15

 set     CAN_RXMGMASK_MG             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Rx Mailboxes Global Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXMGMASK_MG_0           BIT0
 set     CAN_RXMGMASK_MG_1           BIT1
 set     CAN_RXMGMASK_MG_2           BIT2
 set     CAN_RXMGMASK_MG_3           BIT3
 set     CAN_RXMGMASK_MG_4           BIT4
 set     CAN_RXMGMASK_MG_5           BIT5
 set     CAN_RXMGMASK_MG_6           BIT6
 set     CAN_RXMGMASK_MG_7           BIT7
 set     CAN_RXMGMASK_MG_8           BIT8
 set     CAN_RXMGMASK_MG_9           BIT9
 set     CAN_RXMGMASK_MG_10          BIT10
 set     CAN_RXMGMASK_MG_11          BIT11
 set     CAN_RXMGMASK_MG_12          BIT12
 set     CAN_RXMGMASK_MG_13          BIT13
 set     CAN_RXMGMASK_MG_14          BIT14
 set     CAN_RXMGMASK_MG_15          BIT15
 set     CAN_RXMGMASK_MG_16          BIT16
 set     CAN_RXMGMASK_MG_17          BIT17
 set     CAN_RXMGMASK_MG_18          BIT18
 set     CAN_RXMGMASK_MG_19          BIT19
 set     CAN_RXMGMASK_MG_20          BIT20
 set     CAN_RXMGMASK_MG_21          BIT21
 set     CAN_RXMGMASK_MG_22          BIT22
 set     CAN_RXMGMASK_MG_23          BIT23
 set     CAN_RXMGMASK_MG_24          BIT24
 set     CAN_RXMGMASK_MG_25          BIT25
 set     CAN_RXMGMASK_MG_26          BIT26
 set     CAN_RXMGMASK_MG_27          BIT27
 set     CAN_RXMGMASK_MG_28          BIT28
 set     CAN_RXMGMASK_MG_29          BIT29
 set     CAN_RXMGMASK_MG_30          BIT30
 set     CAN_RXMGMASK_MG_31          BIT31

 set     CAN_RX14MASK_RX14M          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Rx Buffer 14 Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RX14MASK_RX14M_0        BIT0
 set     CAN_RX14MASK_RX14M_1        BIT1
 set     CAN_RX14MASK_RX14M_2        BIT2
 set     CAN_RX14MASK_RX14M_3        BIT3
 set     CAN_RX14MASK_RX14M_4        BIT4
 set     CAN_RX14MASK_RX14M_5        BIT5
 set     CAN_RX14MASK_RX14M_6        BIT6
 set     CAN_RX14MASK_RX14M_7        BIT7
 set     CAN_RX14MASK_RX14M_8        BIT8
 set     CAN_RX14MASK_RX14M_9        BIT9
 set     CAN_RX14MASK_RX14M_10       BIT10
 set     CAN_RX14MASK_RX14M_11       BIT11
 set     CAN_RX14MASK_RX14M_12       BIT12
 set     CAN_RX14MASK_RX14M_13       BIT13
 set     CAN_RX14MASK_RX14M_14       BIT14
 set     CAN_RX14MASK_RX14M_15       BIT15
 set     CAN_RX14MASK_RX14M_16       BIT16
 set     CAN_RX14MASK_RX14M_17       BIT17
 set     CAN_RX14MASK_RX14M_18       BIT18
 set     CAN_RX14MASK_RX14M_19       BIT19
 set     CAN_RX14MASK_RX14M_20       BIT20
 set     CAN_RX14MASK_RX14M_21       BIT21
 set     CAN_RX14MASK_RX14M_22       BIT22
 set     CAN_RX14MASK_RX14M_23       BIT23
 set     CAN_RX14MASK_RX14M_24       BIT24
 set     CAN_RX14MASK_RX14M_25       BIT25
 set     CAN_RX14MASK_RX14M_26       BIT26
 set     CAN_RX14MASK_RX14M_27       BIT27
 set     CAN_RX14MASK_RX14M_28       BIT28
 set     CAN_RX14MASK_RX14M_29       BIT29
 set     CAN_RX14MASK_RX14M_30       BIT30
 set     CAN_RX14MASK_RX14M_31       BIT31

 set     CAN_RX15MASK_RX15M          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Rx Buffer 15 Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RX15MASK_RX15M_0        BIT0
 set     CAN_RX15MASK_RX15M_1        BIT1
 set     CAN_RX15MASK_RX15M_2        BIT2
 set     CAN_RX15MASK_RX15M_3        BIT3
 set     CAN_RX15MASK_RX15M_4        BIT4
 set     CAN_RX15MASK_RX15M_5        BIT5
 set     CAN_RX15MASK_RX15M_6        BIT6
 set     CAN_RX15MASK_RX15M_7        BIT7
 set     CAN_RX15MASK_RX15M_8        BIT8
 set     CAN_RX15MASK_RX15M_9        BIT9
 set     CAN_RX15MASK_RX15M_10       BIT10
 set     CAN_RX15MASK_RX15M_11       BIT11
 set     CAN_RX15MASK_RX15M_12       BIT12
 set     CAN_RX15MASK_RX15M_13       BIT13
 set     CAN_RX15MASK_RX15M_14       BIT14
 set     CAN_RX15MASK_RX15M_15       BIT15
 set     CAN_RX15MASK_RX15M_16       BIT16
 set     CAN_RX15MASK_RX15M_17       BIT17
 set     CAN_RX15MASK_RX15M_18       BIT18
 set     CAN_RX15MASK_RX15M_19       BIT19
 set     CAN_RX15MASK_RX15M_20       BIT20
 set     CAN_RX15MASK_RX15M_21       BIT21
 set     CAN_RX15MASK_RX15M_22       BIT22
 set     CAN_RX15MASK_RX15M_23       BIT23
 set     CAN_RX15MASK_RX15M_24       BIT24
 set     CAN_RX15MASK_RX15M_25       BIT25
 set     CAN_RX15MASK_RX15M_26       BIT26
 set     CAN_RX15MASK_RX15M_27       BIT27
 set     CAN_RX15MASK_RX15M_28       BIT28
 set     CAN_RX15MASK_RX15M_29       BIT29
 set     CAN_RX15MASK_RX15M_30       BIT30
 set     CAN_RX15MASK_RX15M_31       BIT31

 set     CAN_ECR_TXERRCNT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Transmit Error Counter
 set     CAN_ECR_TXERRCNT_0          BIT0
 set     CAN_ECR_TXERRCNT_1          BIT1
 set     CAN_ECR_TXERRCNT_2          BIT2
 set     CAN_ECR_TXERRCNT_3          BIT3
 set     CAN_ECR_TXERRCNT_4          BIT4
 set     CAN_ECR_TXERRCNT_5          BIT5
 set     CAN_ECR_TXERRCNT_6          BIT6
 set     CAN_ECR_TXERRCNT_7          BIT7

 set     CAN_ECR_RXERRCNT            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Receive Error Counter
 set     CAN_ECR_RXERRCNT_0          BIT8
 set     CAN_ECR_RXERRCNT_1          BIT9
 set     CAN_ECR_RXERRCNT_2          BIT10
 set     CAN_ECR_RXERRCNT_3          BIT11
 set     CAN_ECR_RXERRCNT_4          BIT12
 set     CAN_ECR_RXERRCNT_5          BIT13
 set     CAN_ECR_RXERRCNT_6          BIT14
 set     CAN_ECR_RXERRCNT_7          BIT15

 set     CAN_ESR1_WAKINT             BIT0
;;   Wake-Up Interrupt
;;     0b0 ==> No such occurrence.
;;     0b1 ==> Indicates a recessive to dominant transition was received on the CAN bus.

 set     CAN_ESR1_ERRINT             BIT1
;;   Error Interrupt
;;     0b0 ==> No such occurrence.
;;     0b1 ==> Indicates setting of any Error Bit in the Error and Status Register.

 set     CAN_ESR1_BOFFINT            BIT2
;;   Bus Off Interrupt
;;     0b0 ==> No such occurrence.
;;     0b1 ==> FlexCAN module entered Bus Off state.

 set     CAN_ESR1_RX                 BIT3
;;   FlexCAN In Reception
;;     0b0 ==> FlexCAN is not receiving a message.
;;     0b1 ==> FlexCAN is receiving a message.

 set     CAN_ESR1_FLTCONF            (BIT4|BIT5)
;;   Fault Confinement State
;;     0b00 ==> Error Active
;;     0b01 ==> Error Passive
;;     0b1x ==> Bus Off
 set     CAN_ESR1_FLTCONF_0          BIT4
 set     CAN_ESR1_FLTCONF_1          BIT5

 set     CAN_ESR1_TX                 BIT6
;;   FlexCAN In Transmission
;;     0b0 ==> FlexCAN is not transmitting a message.
;;     0b1 ==> FlexCAN is transmitting a message.

 set     CAN_ESR1_IDLE               BIT7
;;     0b0 ==> No such occurrence.
;;     0b1 ==> CAN bus is now IDLE.

 set     CAN_ESR1_RXWRN              BIT8
;;   Rx Error Warning
;;     0b0 ==> No such occurrence.
;;     0b1 ==> RXERRCNT is greater than or equal to 96.

 set     CAN_ESR1_TXWRN              BIT9
;;   TX Error Warning
;;     0b0 ==> No such occurrence.
;;     0b1 ==> TXERRCNT is greater than or equal to 96.

 set     CAN_ESR1_STFERR             BIT10
;;   Stuffing Error
;;     0b0 ==> No such occurrence.
;;     0b1 ==> A Stuffing Error occurred since last read of this register.

 set     CAN_ESR1_FRMERR             BIT11
;;   Form Error
;;     0b0 ==> No such occurrence.
;;     0b1 ==> A Form Error occurred since last read of this register.

 set     CAN_ESR1_CRCERR             BIT12
;;   Cyclic Redundancy Check Error
;;     0b0 ==> No such occurrence.
;;     0b1 ==> A CRC error occurred since last read of this register.

 set     CAN_ESR1_ACKERR             BIT13
;;   Acknowledge Error
;;     0b0 ==> No such occurrence.
;;     0b1 ==> An ACK error occurred since last read of this register.

 set     CAN_ESR1_BIT0ERR            BIT14
;;   Bit0 Error
;;     0b0 ==> No such occurrence.
;;     0b1 ==> At least one bit sent as dominant is received as recessive.

 set     CAN_ESR1_BIT1ERR            BIT15
;;   Bit1 Error
;;     0b0 ==> No such occurrence.
;;     0b1 ==> At least one bit sent as recessive is received as dominant.

 set     CAN_ESR1_RWRNINT            BIT16
;;   Rx Warning Interrupt Flag
;;     0b0 ==> No such occurrence.
;;     0b1 ==> The Rx error counter transitioned from less than 96 to greater than or equal to 96.

 set     CAN_ESR1_TWRNINT            BIT17
;;   Tx Warning Interrupt Flag
;;     0b0 ==> No such occurrence.
;;     0b1 ==> The Tx error counter transitioned from less than 96 to greater than or equal to 96.

 set     CAN_ESR1_SYNCH              BIT18
;;   CAN Synchronization Status
;;     0b0 ==> FlexCAN is not synchronized to the CAN bus.
;;     0b1 ==> FlexCAN is synchronized to the CAN bus.

 set     CAN_IMASK1_BUFLM            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Buffer MB i Mask
;;     0b0 ==> The corresponding buffer Interrupt is disabled.
;;     0b1 ==> The corresponding buffer Interrupt is enabled.
 set     CAN_IMASK1_BUFLM_0          BIT0
 set     CAN_IMASK1_BUFLM_1          BIT1
 set     CAN_IMASK1_BUFLM_2          BIT2
 set     CAN_IMASK1_BUFLM_3          BIT3
 set     CAN_IMASK1_BUFLM_4          BIT4
 set     CAN_IMASK1_BUFLM_5          BIT5
 set     CAN_IMASK1_BUFLM_6          BIT6
 set     CAN_IMASK1_BUFLM_7          BIT7
 set     CAN_IMASK1_BUFLM_8          BIT8
 set     CAN_IMASK1_BUFLM_9          BIT9
 set     CAN_IMASK1_BUFLM_10         BIT10
 set     CAN_IMASK1_BUFLM_11         BIT11
 set     CAN_IMASK1_BUFLM_12         BIT12
 set     CAN_IMASK1_BUFLM_13         BIT13
 set     CAN_IMASK1_BUFLM_14         BIT14
 set     CAN_IMASK1_BUFLM_15         BIT15
 set     CAN_IMASK1_BUFLM_16         BIT16
 set     CAN_IMASK1_BUFLM_17         BIT17
 set     CAN_IMASK1_BUFLM_18         BIT18
 set     CAN_IMASK1_BUFLM_19         BIT19
 set     CAN_IMASK1_BUFLM_20         BIT20
 set     CAN_IMASK1_BUFLM_21         BIT21
 set     CAN_IMASK1_BUFLM_22         BIT22
 set     CAN_IMASK1_BUFLM_23         BIT23
 set     CAN_IMASK1_BUFLM_24         BIT24
 set     CAN_IMASK1_BUFLM_25         BIT25
 set     CAN_IMASK1_BUFLM_26         BIT26
 set     CAN_IMASK1_BUFLM_27         BIT27
 set     CAN_IMASK1_BUFLM_28         BIT28
 set     CAN_IMASK1_BUFLM_29         BIT29
 set     CAN_IMASK1_BUFLM_30         BIT30
 set     CAN_IMASK1_BUFLM_31         BIT31

 set     CAN_IFLAG1_BUF4TO0I         (BIT0|BIT1|BIT2|BIT3|BIT4)
;;   Buffer MB i Interrupt Or "reserved"
;;     0b0 ==> The corresponding buffer has no occurrence of successfully completed transmission or reception when MCR[RFEN]=0.
;;     0b1 ==> The corresponding buffer has successfully completed transmission or reception when MCR[RFEN]=0.
 set     CAN_IFLAG1_BUF4TO0I_0       BIT0
 set     CAN_IFLAG1_BUF4TO0I_1       BIT1
 set     CAN_IFLAG1_BUF4TO0I_2       BIT2
 set     CAN_IFLAG1_BUF4TO0I_3       BIT3
 set     CAN_IFLAG1_BUF4TO0I_4       BIT4

 set     CAN_IFLAG1_BUF5I            BIT5
;;   Buffer MB5 Interrupt Or "Frames available in Rx FIFO"
;;     0b0 ==> No occurrence of MB5 completing transmission/reception when MCR[RFEN]=0, or of frame(s) available in the Rx FIFO, when MCR[RFEN]=1
;;     0b1 ==> MB5 completed transmission/reception when MCR[RFEN]=0, or frame(s) available in the Rx FIFO when MCR[RFEN]=1

 set     CAN_IFLAG1_BUF6I            BIT6
;;   Buffer MB6 Interrupt Or "Rx FIFO Warning"
;;     0b0 ==> No occurrence of MB6 completing transmission/reception when MCR[RFEN]=0, or of Rx FIFO almost full when MCR[RFEN]=1
;;     0b1 ==> MB6 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO almost full when MCR[RFEN]=1

 set     CAN_IFLAG1_BUF7I            BIT7
;;   Buffer MB7 Interrupt Or "Rx FIFO Overflow"
;;     0b0 ==> No occurrence of MB7 completing transmission/reception when MCR[RFEN]=0, or of Rx FIFO overflow when MCR[RFEN]=1
;;     0b1 ==> MB7 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO overflow when MCR[RFEN]=1

 set     CAN_IFLAG1_BUF31TO8I        (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Buffer MBi Interrupt
;;     0b0 ==> The corresponding buffer has no occurrence of successfully completed transmission or reception.
;;     0b1 ==> The corresponding buffer has successfully completed transmission or reception.
 set     CAN_IFLAG1_BUF31TO8I_0      BIT8
 set     CAN_IFLAG1_BUF31TO8I_1      BIT9
 set     CAN_IFLAG1_BUF31TO8I_2      BIT10
 set     CAN_IFLAG1_BUF31TO8I_3      BIT11
 set     CAN_IFLAG1_BUF31TO8I_4      BIT12
 set     CAN_IFLAG1_BUF31TO8I_5      BIT13
 set     CAN_IFLAG1_BUF31TO8I_6      BIT14
 set     CAN_IFLAG1_BUF31TO8I_7      BIT15
 set     CAN_IFLAG1_BUF31TO8I_8      BIT16
 set     CAN_IFLAG1_BUF31TO8I_9      BIT17
 set     CAN_IFLAG1_BUF31TO8I_10     BIT18
 set     CAN_IFLAG1_BUF31TO8I_11     BIT19
 set     CAN_IFLAG1_BUF31TO8I_12     BIT20
 set     CAN_IFLAG1_BUF31TO8I_13     BIT21
 set     CAN_IFLAG1_BUF31TO8I_14     BIT22
 set     CAN_IFLAG1_BUF31TO8I_15     BIT23
 set     CAN_IFLAG1_BUF31TO8I_16     BIT24
 set     CAN_IFLAG1_BUF31TO8I_17     BIT25
 set     CAN_IFLAG1_BUF31TO8I_18     BIT26
 set     CAN_IFLAG1_BUF31TO8I_19     BIT27
 set     CAN_IFLAG1_BUF31TO8I_20     BIT28
 set     CAN_IFLAG1_BUF31TO8I_21     BIT29
 set     CAN_IFLAG1_BUF31TO8I_22     BIT30
 set     CAN_IFLAG1_BUF31TO8I_23     BIT31

 set     CAN_CTRL2_EACEN             BIT16
;;   Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes
;;     0b0 ==> Rx Mailbox filter's IDE bit is always compared and RTR is never compared despite mask bits.
;;     0b1 ==> Enables the comparison of both Rx Mailbox filter's IDE and RTR bit with their corresponding bits within the incoming frame. Mask bits do apply.

 set     CAN_CTRL2_RRS               BIT17
;;   Remote Request Storing
;;     0b0 ==> Remote Response Frame is generated.
;;     0b1 ==> Remote Request Frame is stored.

 set     CAN_CTRL2_MRP               BIT18
;;   Mailboxes Reception Priority
;;     0b0 ==> Matching starts from Rx FIFO and continues on Mailboxes.
;;     0b1 ==> Matching starts from Mailboxes and continues on Rx FIFO.

 set     CAN_CTRL2_TASD              (BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Tx Arbitration Start Delay
 set     CAN_CTRL2_TASD_0            BIT19
 set     CAN_CTRL2_TASD_1            BIT20
 set     CAN_CTRL2_TASD_2            BIT21
 set     CAN_CTRL2_TASD_3            BIT22
 set     CAN_CTRL2_TASD_4            BIT23

 set     CAN_CTRL2_RFFN              (BIT24|BIT25|BIT26|BIT27)
;;   Number Of Rx FIFO Filters
 set     CAN_CTRL2_RFFN_0            BIT24
 set     CAN_CTRL2_RFFN_1            BIT25
 set     CAN_CTRL2_RFFN_2            BIT26
 set     CAN_CTRL2_RFFN_3            BIT27

 set     CAN_CTRL2_WRMFRZ            BIT28
;;   Write-Access To Memory In Freeze Mode
;;     0b0 ==> Maintain the write access restrictions.
;;     0b1 ==> Enable unrestricted write access to FlexCAN memory.

 set     CAN_ESR2_IMB                BIT13
;;   Inactive Mailbox
;;     0b0 ==> If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive Mailbox.
;;     0b1 ==> If ESR2[VPS] is asserted, there is at least one inactive Mailbox. LPTM content is the number of the first one.

 set     CAN_ESR2_VPS                BIT14
;;   Valid Priority Status
;;     0b0 ==> Contents of IMB and LPTM are invalid.
;;     0b1 ==> Contents of IMB and LPTM are valid.

 set     CAN_ESR2_LPTM               (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22)
;;   Lowest Priority Tx Mailbox
 set     CAN_ESR2_LPTM_0             BIT16
 set     CAN_ESR2_LPTM_1             BIT17
 set     CAN_ESR2_LPTM_2             BIT18
 set     CAN_ESR2_LPTM_3             BIT19
 set     CAN_ESR2_LPTM_4             BIT20
 set     CAN_ESR2_LPTM_5             BIT21
 set     CAN_ESR2_LPTM_6             BIT22

 set     CAN_CRCR_TXCRC              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   CRC Transmitted
 set     CAN_CRCR_TXCRC_0            BIT0
 set     CAN_CRCR_TXCRC_1            BIT1
 set     CAN_CRCR_TXCRC_2            BIT2
 set     CAN_CRCR_TXCRC_3            BIT3
 set     CAN_CRCR_TXCRC_4            BIT4
 set     CAN_CRCR_TXCRC_5            BIT5
 set     CAN_CRCR_TXCRC_6            BIT6
 set     CAN_CRCR_TXCRC_7            BIT7
 set     CAN_CRCR_TXCRC_8            BIT8
 set     CAN_CRCR_TXCRC_9            BIT9
 set     CAN_CRCR_TXCRC_10           BIT10
 set     CAN_CRCR_TXCRC_11           BIT11
 set     CAN_CRCR_TXCRC_12           BIT12
 set     CAN_CRCR_TXCRC_13           BIT13
 set     CAN_CRCR_TXCRC_14           BIT14

 set     CAN_CRCR_MBCRC              (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22)
;;   CRC Mailbox
 set     CAN_CRCR_MBCRC_0            BIT16
 set     CAN_CRCR_MBCRC_1            BIT17
 set     CAN_CRCR_MBCRC_2            BIT18
 set     CAN_CRCR_MBCRC_3            BIT19
 set     CAN_CRCR_MBCRC_4            BIT20
 set     CAN_CRCR_MBCRC_5            BIT21
 set     CAN_CRCR_MBCRC_6            BIT22

 set     CAN_RXFGMASK_FGM            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Rx FIFO Global Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXFGMASK_FGM_0          BIT0
 set     CAN_RXFGMASK_FGM_1          BIT1
 set     CAN_RXFGMASK_FGM_2          BIT2
 set     CAN_RXFGMASK_FGM_3          BIT3
 set     CAN_RXFGMASK_FGM_4          BIT4
 set     CAN_RXFGMASK_FGM_5          BIT5
 set     CAN_RXFGMASK_FGM_6          BIT6
 set     CAN_RXFGMASK_FGM_7          BIT7
 set     CAN_RXFGMASK_FGM_8          BIT8
 set     CAN_RXFGMASK_FGM_9          BIT9
 set     CAN_RXFGMASK_FGM_10         BIT10
 set     CAN_RXFGMASK_FGM_11         BIT11
 set     CAN_RXFGMASK_FGM_12         BIT12
 set     CAN_RXFGMASK_FGM_13         BIT13
 set     CAN_RXFGMASK_FGM_14         BIT14
 set     CAN_RXFGMASK_FGM_15         BIT15
 set     CAN_RXFGMASK_FGM_16         BIT16
 set     CAN_RXFGMASK_FGM_17         BIT17
 set     CAN_RXFGMASK_FGM_18         BIT18
 set     CAN_RXFGMASK_FGM_19         BIT19
 set     CAN_RXFGMASK_FGM_20         BIT20
 set     CAN_RXFGMASK_FGM_21         BIT21
 set     CAN_RXFGMASK_FGM_22         BIT22
 set     CAN_RXFGMASK_FGM_23         BIT23
 set     CAN_RXFGMASK_FGM_24         BIT24
 set     CAN_RXFGMASK_FGM_25         BIT25
 set     CAN_RXFGMASK_FGM_26         BIT26
 set     CAN_RXFGMASK_FGM_27         BIT27
 set     CAN_RXFGMASK_FGM_28         BIT28
 set     CAN_RXFGMASK_FGM_29         BIT29
 set     CAN_RXFGMASK_FGM_30         BIT30
 set     CAN_RXFGMASK_FGM_31         BIT31

 set     CAN_RXFIR_IDHIT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   Identifier Acceptance Filter Hit Indicator
 set     CAN_RXFIR_IDHIT_0           BIT0
 set     CAN_RXFIR_IDHIT_1           BIT1
 set     CAN_RXFIR_IDHIT_2           BIT2
 set     CAN_RXFIR_IDHIT_3           BIT3
 set     CAN_RXFIR_IDHIT_4           BIT4
 set     CAN_RXFIR_IDHIT_5           BIT5
 set     CAN_RXFIR_IDHIT_6           BIT6
 set     CAN_RXFIR_IDHIT_7           BIT7
 set     CAN_RXFIR_IDHIT_8           BIT8

 set     CAN_CS0_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS0_TIME_STAMP_0        BIT0
 set     CAN_CS0_TIME_STAMP_1        BIT1
 set     CAN_CS0_TIME_STAMP_2        BIT2
 set     CAN_CS0_TIME_STAMP_3        BIT3
 set     CAN_CS0_TIME_STAMP_4        BIT4
 set     CAN_CS0_TIME_STAMP_5        BIT5
 set     CAN_CS0_TIME_STAMP_6        BIT6
 set     CAN_CS0_TIME_STAMP_7        BIT7
 set     CAN_CS0_TIME_STAMP_8        BIT8
 set     CAN_CS0_TIME_STAMP_9        BIT9
 set     CAN_CS0_TIME_STAMP_10       BIT10
 set     CAN_CS0_TIME_STAMP_11       BIT11
 set     CAN_CS0_TIME_STAMP_12       BIT12
 set     CAN_CS0_TIME_STAMP_13       BIT13
 set     CAN_CS0_TIME_STAMP_14       BIT14
 set     CAN_CS0_TIME_STAMP_15       BIT15

 set     CAN_CS0_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS0_DLC_0               BIT16
 set     CAN_CS0_DLC_1               BIT17
 set     CAN_CS0_DLC_2               BIT18
 set     CAN_CS0_DLC_3               BIT19

 set     CAN_CS0_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS0_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS0_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS0_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS0_CODE_0              BIT24
 set     CAN_CS0_CODE_1              BIT25
 set     CAN_CS0_CODE_2              BIT26
 set     CAN_CS0_CODE_3              BIT27

 set     CAN_ID0_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID0_EXT_0               BIT0
 set     CAN_ID0_EXT_1               BIT1
 set     CAN_ID0_EXT_2               BIT2
 set     CAN_ID0_EXT_3               BIT3
 set     CAN_ID0_EXT_4               BIT4
 set     CAN_ID0_EXT_5               BIT5
 set     CAN_ID0_EXT_6               BIT6
 set     CAN_ID0_EXT_7               BIT7
 set     CAN_ID0_EXT_8               BIT8
 set     CAN_ID0_EXT_9               BIT9
 set     CAN_ID0_EXT_10              BIT10
 set     CAN_ID0_EXT_11              BIT11
 set     CAN_ID0_EXT_12              BIT12
 set     CAN_ID0_EXT_13              BIT13
 set     CAN_ID0_EXT_14              BIT14
 set     CAN_ID0_EXT_15              BIT15
 set     CAN_ID0_EXT_16              BIT16
 set     CAN_ID0_EXT_17              BIT17

 set     CAN_ID0_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID0_STD_0               BIT18
 set     CAN_ID0_STD_1               BIT19
 set     CAN_ID0_STD_2               BIT20
 set     CAN_ID0_STD_3               BIT21
 set     CAN_ID0_STD_4               BIT22
 set     CAN_ID0_STD_5               BIT23
 set     CAN_ID0_STD_6               BIT24
 set     CAN_ID0_STD_7               BIT25
 set     CAN_ID0_STD_8               BIT26
 set     CAN_ID0_STD_9               BIT27
 set     CAN_ID0_STD_10              BIT28

 set     CAN_ID0_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID0_PRIO_0              BIT29
 set     CAN_ID0_PRIO_1              BIT30
 set     CAN_ID0_PRIO_2              BIT31

 set     CAN_WORD00_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD00_DATA_BYTE_3_0    BIT0
 set     CAN_WORD00_DATA_BYTE_3_1    BIT1
 set     CAN_WORD00_DATA_BYTE_3_2    BIT2
 set     CAN_WORD00_DATA_BYTE_3_3    BIT3
 set     CAN_WORD00_DATA_BYTE_3_4    BIT4
 set     CAN_WORD00_DATA_BYTE_3_5    BIT5
 set     CAN_WORD00_DATA_BYTE_3_6    BIT6
 set     CAN_WORD00_DATA_BYTE_3_7    BIT7

 set     CAN_WORD00_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD00_DATA_BYTE_2_0    BIT8
 set     CAN_WORD00_DATA_BYTE_2_1    BIT9
 set     CAN_WORD00_DATA_BYTE_2_2    BIT10
 set     CAN_WORD00_DATA_BYTE_2_3    BIT11
 set     CAN_WORD00_DATA_BYTE_2_4    BIT12
 set     CAN_WORD00_DATA_BYTE_2_5    BIT13
 set     CAN_WORD00_DATA_BYTE_2_6    BIT14
 set     CAN_WORD00_DATA_BYTE_2_7    BIT15

 set     CAN_WORD00_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD00_DATA_BYTE_1_0    BIT16
 set     CAN_WORD00_DATA_BYTE_1_1    BIT17
 set     CAN_WORD00_DATA_BYTE_1_2    BIT18
 set     CAN_WORD00_DATA_BYTE_1_3    BIT19
 set     CAN_WORD00_DATA_BYTE_1_4    BIT20
 set     CAN_WORD00_DATA_BYTE_1_5    BIT21
 set     CAN_WORD00_DATA_BYTE_1_6    BIT22
 set     CAN_WORD00_DATA_BYTE_1_7    BIT23

 set     CAN_WORD00_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD00_DATA_BYTE_0_0    BIT24
 set     CAN_WORD00_DATA_BYTE_0_1    BIT25
 set     CAN_WORD00_DATA_BYTE_0_2    BIT26
 set     CAN_WORD00_DATA_BYTE_0_3    BIT27
 set     CAN_WORD00_DATA_BYTE_0_4    BIT28
 set     CAN_WORD00_DATA_BYTE_0_5    BIT29
 set     CAN_WORD00_DATA_BYTE_0_6    BIT30
 set     CAN_WORD00_DATA_BYTE_0_7    BIT31

 set     CAN_WORD10_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD10_DATA_BYTE_7_0    BIT0
 set     CAN_WORD10_DATA_BYTE_7_1    BIT1
 set     CAN_WORD10_DATA_BYTE_7_2    BIT2
 set     CAN_WORD10_DATA_BYTE_7_3    BIT3
 set     CAN_WORD10_DATA_BYTE_7_4    BIT4
 set     CAN_WORD10_DATA_BYTE_7_5    BIT5
 set     CAN_WORD10_DATA_BYTE_7_6    BIT6
 set     CAN_WORD10_DATA_BYTE_7_7    BIT7

 set     CAN_WORD10_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD10_DATA_BYTE_6_0    BIT8
 set     CAN_WORD10_DATA_BYTE_6_1    BIT9
 set     CAN_WORD10_DATA_BYTE_6_2    BIT10
 set     CAN_WORD10_DATA_BYTE_6_3    BIT11
 set     CAN_WORD10_DATA_BYTE_6_4    BIT12
 set     CAN_WORD10_DATA_BYTE_6_5    BIT13
 set     CAN_WORD10_DATA_BYTE_6_6    BIT14
 set     CAN_WORD10_DATA_BYTE_6_7    BIT15

 set     CAN_WORD10_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD10_DATA_BYTE_5_0    BIT16
 set     CAN_WORD10_DATA_BYTE_5_1    BIT17
 set     CAN_WORD10_DATA_BYTE_5_2    BIT18
 set     CAN_WORD10_DATA_BYTE_5_3    BIT19
 set     CAN_WORD10_DATA_BYTE_5_4    BIT20
 set     CAN_WORD10_DATA_BYTE_5_5    BIT21
 set     CAN_WORD10_DATA_BYTE_5_6    BIT22
 set     CAN_WORD10_DATA_BYTE_5_7    BIT23

 set     CAN_WORD10_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD10_DATA_BYTE_4_0    BIT24
 set     CAN_WORD10_DATA_BYTE_4_1    BIT25
 set     CAN_WORD10_DATA_BYTE_4_2    BIT26
 set     CAN_WORD10_DATA_BYTE_4_3    BIT27
 set     CAN_WORD10_DATA_BYTE_4_4    BIT28
 set     CAN_WORD10_DATA_BYTE_4_5    BIT29
 set     CAN_WORD10_DATA_BYTE_4_6    BIT30
 set     CAN_WORD10_DATA_BYTE_4_7    BIT31

 set     CAN_CS1_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS1_TIME_STAMP_0        BIT0
 set     CAN_CS1_TIME_STAMP_1        BIT1
 set     CAN_CS1_TIME_STAMP_2        BIT2
 set     CAN_CS1_TIME_STAMP_3        BIT3
 set     CAN_CS1_TIME_STAMP_4        BIT4
 set     CAN_CS1_TIME_STAMP_5        BIT5
 set     CAN_CS1_TIME_STAMP_6        BIT6
 set     CAN_CS1_TIME_STAMP_7        BIT7
 set     CAN_CS1_TIME_STAMP_8        BIT8
 set     CAN_CS1_TIME_STAMP_9        BIT9
 set     CAN_CS1_TIME_STAMP_10       BIT10
 set     CAN_CS1_TIME_STAMP_11       BIT11
 set     CAN_CS1_TIME_STAMP_12       BIT12
 set     CAN_CS1_TIME_STAMP_13       BIT13
 set     CAN_CS1_TIME_STAMP_14       BIT14
 set     CAN_CS1_TIME_STAMP_15       BIT15

 set     CAN_CS1_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS1_DLC_0               BIT16
 set     CAN_CS1_DLC_1               BIT17
 set     CAN_CS1_DLC_2               BIT18
 set     CAN_CS1_DLC_3               BIT19

 set     CAN_CS1_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS1_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS1_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS1_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS1_CODE_0              BIT24
 set     CAN_CS1_CODE_1              BIT25
 set     CAN_CS1_CODE_2              BIT26
 set     CAN_CS1_CODE_3              BIT27

 set     CAN_ID1_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID1_EXT_0               BIT0
 set     CAN_ID1_EXT_1               BIT1
 set     CAN_ID1_EXT_2               BIT2
 set     CAN_ID1_EXT_3               BIT3
 set     CAN_ID1_EXT_4               BIT4
 set     CAN_ID1_EXT_5               BIT5
 set     CAN_ID1_EXT_6               BIT6
 set     CAN_ID1_EXT_7               BIT7
 set     CAN_ID1_EXT_8               BIT8
 set     CAN_ID1_EXT_9               BIT9
 set     CAN_ID1_EXT_10              BIT10
 set     CAN_ID1_EXT_11              BIT11
 set     CAN_ID1_EXT_12              BIT12
 set     CAN_ID1_EXT_13              BIT13
 set     CAN_ID1_EXT_14              BIT14
 set     CAN_ID1_EXT_15              BIT15
 set     CAN_ID1_EXT_16              BIT16
 set     CAN_ID1_EXT_17              BIT17

 set     CAN_ID1_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID1_STD_0               BIT18
 set     CAN_ID1_STD_1               BIT19
 set     CAN_ID1_STD_2               BIT20
 set     CAN_ID1_STD_3               BIT21
 set     CAN_ID1_STD_4               BIT22
 set     CAN_ID1_STD_5               BIT23
 set     CAN_ID1_STD_6               BIT24
 set     CAN_ID1_STD_7               BIT25
 set     CAN_ID1_STD_8               BIT26
 set     CAN_ID1_STD_9               BIT27
 set     CAN_ID1_STD_10              BIT28

 set     CAN_ID1_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID1_PRIO_0              BIT29
 set     CAN_ID1_PRIO_1              BIT30
 set     CAN_ID1_PRIO_2              BIT31

 set     CAN_WORD01_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD01_DATA_BYTE_3_0    BIT0
 set     CAN_WORD01_DATA_BYTE_3_1    BIT1
 set     CAN_WORD01_DATA_BYTE_3_2    BIT2
 set     CAN_WORD01_DATA_BYTE_3_3    BIT3
 set     CAN_WORD01_DATA_BYTE_3_4    BIT4
 set     CAN_WORD01_DATA_BYTE_3_5    BIT5
 set     CAN_WORD01_DATA_BYTE_3_6    BIT6
 set     CAN_WORD01_DATA_BYTE_3_7    BIT7

 set     CAN_WORD01_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD01_DATA_BYTE_2_0    BIT8
 set     CAN_WORD01_DATA_BYTE_2_1    BIT9
 set     CAN_WORD01_DATA_BYTE_2_2    BIT10
 set     CAN_WORD01_DATA_BYTE_2_3    BIT11
 set     CAN_WORD01_DATA_BYTE_2_4    BIT12
 set     CAN_WORD01_DATA_BYTE_2_5    BIT13
 set     CAN_WORD01_DATA_BYTE_2_6    BIT14
 set     CAN_WORD01_DATA_BYTE_2_7    BIT15

 set     CAN_WORD01_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD01_DATA_BYTE_1_0    BIT16
 set     CAN_WORD01_DATA_BYTE_1_1    BIT17
 set     CAN_WORD01_DATA_BYTE_1_2    BIT18
 set     CAN_WORD01_DATA_BYTE_1_3    BIT19
 set     CAN_WORD01_DATA_BYTE_1_4    BIT20
 set     CAN_WORD01_DATA_BYTE_1_5    BIT21
 set     CAN_WORD01_DATA_BYTE_1_6    BIT22
 set     CAN_WORD01_DATA_BYTE_1_7    BIT23

 set     CAN_WORD01_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD01_DATA_BYTE_0_0    BIT24
 set     CAN_WORD01_DATA_BYTE_0_1    BIT25
 set     CAN_WORD01_DATA_BYTE_0_2    BIT26
 set     CAN_WORD01_DATA_BYTE_0_3    BIT27
 set     CAN_WORD01_DATA_BYTE_0_4    BIT28
 set     CAN_WORD01_DATA_BYTE_0_5    BIT29
 set     CAN_WORD01_DATA_BYTE_0_6    BIT30
 set     CAN_WORD01_DATA_BYTE_0_7    BIT31

 set     CAN_WORD11_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD11_DATA_BYTE_7_0    BIT0
 set     CAN_WORD11_DATA_BYTE_7_1    BIT1
 set     CAN_WORD11_DATA_BYTE_7_2    BIT2
 set     CAN_WORD11_DATA_BYTE_7_3    BIT3
 set     CAN_WORD11_DATA_BYTE_7_4    BIT4
 set     CAN_WORD11_DATA_BYTE_7_5    BIT5
 set     CAN_WORD11_DATA_BYTE_7_6    BIT6
 set     CAN_WORD11_DATA_BYTE_7_7    BIT7

 set     CAN_WORD11_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD11_DATA_BYTE_6_0    BIT8
 set     CAN_WORD11_DATA_BYTE_6_1    BIT9
 set     CAN_WORD11_DATA_BYTE_6_2    BIT10
 set     CAN_WORD11_DATA_BYTE_6_3    BIT11
 set     CAN_WORD11_DATA_BYTE_6_4    BIT12
 set     CAN_WORD11_DATA_BYTE_6_5    BIT13
 set     CAN_WORD11_DATA_BYTE_6_6    BIT14
 set     CAN_WORD11_DATA_BYTE_6_7    BIT15

 set     CAN_WORD11_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD11_DATA_BYTE_5_0    BIT16
 set     CAN_WORD11_DATA_BYTE_5_1    BIT17
 set     CAN_WORD11_DATA_BYTE_5_2    BIT18
 set     CAN_WORD11_DATA_BYTE_5_3    BIT19
 set     CAN_WORD11_DATA_BYTE_5_4    BIT20
 set     CAN_WORD11_DATA_BYTE_5_5    BIT21
 set     CAN_WORD11_DATA_BYTE_5_6    BIT22
 set     CAN_WORD11_DATA_BYTE_5_7    BIT23

 set     CAN_WORD11_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD11_DATA_BYTE_4_0    BIT24
 set     CAN_WORD11_DATA_BYTE_4_1    BIT25
 set     CAN_WORD11_DATA_BYTE_4_2    BIT26
 set     CAN_WORD11_DATA_BYTE_4_3    BIT27
 set     CAN_WORD11_DATA_BYTE_4_4    BIT28
 set     CAN_WORD11_DATA_BYTE_4_5    BIT29
 set     CAN_WORD11_DATA_BYTE_4_6    BIT30
 set     CAN_WORD11_DATA_BYTE_4_7    BIT31

 set     CAN_CS2_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS2_TIME_STAMP_0        BIT0
 set     CAN_CS2_TIME_STAMP_1        BIT1
 set     CAN_CS2_TIME_STAMP_2        BIT2
 set     CAN_CS2_TIME_STAMP_3        BIT3
 set     CAN_CS2_TIME_STAMP_4        BIT4
 set     CAN_CS2_TIME_STAMP_5        BIT5
 set     CAN_CS2_TIME_STAMP_6        BIT6
 set     CAN_CS2_TIME_STAMP_7        BIT7
 set     CAN_CS2_TIME_STAMP_8        BIT8
 set     CAN_CS2_TIME_STAMP_9        BIT9
 set     CAN_CS2_TIME_STAMP_10       BIT10
 set     CAN_CS2_TIME_STAMP_11       BIT11
 set     CAN_CS2_TIME_STAMP_12       BIT12
 set     CAN_CS2_TIME_STAMP_13       BIT13
 set     CAN_CS2_TIME_STAMP_14       BIT14
 set     CAN_CS2_TIME_STAMP_15       BIT15

 set     CAN_CS2_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS2_DLC_0               BIT16
 set     CAN_CS2_DLC_1               BIT17
 set     CAN_CS2_DLC_2               BIT18
 set     CAN_CS2_DLC_3               BIT19

 set     CAN_CS2_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS2_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS2_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS2_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS2_CODE_0              BIT24
 set     CAN_CS2_CODE_1              BIT25
 set     CAN_CS2_CODE_2              BIT26
 set     CAN_CS2_CODE_3              BIT27

 set     CAN_ID2_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID2_EXT_0               BIT0
 set     CAN_ID2_EXT_1               BIT1
 set     CAN_ID2_EXT_2               BIT2
 set     CAN_ID2_EXT_3               BIT3
 set     CAN_ID2_EXT_4               BIT4
 set     CAN_ID2_EXT_5               BIT5
 set     CAN_ID2_EXT_6               BIT6
 set     CAN_ID2_EXT_7               BIT7
 set     CAN_ID2_EXT_8               BIT8
 set     CAN_ID2_EXT_9               BIT9
 set     CAN_ID2_EXT_10              BIT10
 set     CAN_ID2_EXT_11              BIT11
 set     CAN_ID2_EXT_12              BIT12
 set     CAN_ID2_EXT_13              BIT13
 set     CAN_ID2_EXT_14              BIT14
 set     CAN_ID2_EXT_15              BIT15
 set     CAN_ID2_EXT_16              BIT16
 set     CAN_ID2_EXT_17              BIT17

 set     CAN_ID2_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID2_STD_0               BIT18
 set     CAN_ID2_STD_1               BIT19
 set     CAN_ID2_STD_2               BIT20
 set     CAN_ID2_STD_3               BIT21
 set     CAN_ID2_STD_4               BIT22
 set     CAN_ID2_STD_5               BIT23
 set     CAN_ID2_STD_6               BIT24
 set     CAN_ID2_STD_7               BIT25
 set     CAN_ID2_STD_8               BIT26
 set     CAN_ID2_STD_9               BIT27
 set     CAN_ID2_STD_10              BIT28

 set     CAN_ID2_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID2_PRIO_0              BIT29
 set     CAN_ID2_PRIO_1              BIT30
 set     CAN_ID2_PRIO_2              BIT31

 set     CAN_WORD02_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD02_DATA_BYTE_3_0    BIT0
 set     CAN_WORD02_DATA_BYTE_3_1    BIT1
 set     CAN_WORD02_DATA_BYTE_3_2    BIT2
 set     CAN_WORD02_DATA_BYTE_3_3    BIT3
 set     CAN_WORD02_DATA_BYTE_3_4    BIT4
 set     CAN_WORD02_DATA_BYTE_3_5    BIT5
 set     CAN_WORD02_DATA_BYTE_3_6    BIT6
 set     CAN_WORD02_DATA_BYTE_3_7    BIT7

 set     CAN_WORD02_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD02_DATA_BYTE_2_0    BIT8
 set     CAN_WORD02_DATA_BYTE_2_1    BIT9
 set     CAN_WORD02_DATA_BYTE_2_2    BIT10
 set     CAN_WORD02_DATA_BYTE_2_3    BIT11
 set     CAN_WORD02_DATA_BYTE_2_4    BIT12
 set     CAN_WORD02_DATA_BYTE_2_5    BIT13
 set     CAN_WORD02_DATA_BYTE_2_6    BIT14
 set     CAN_WORD02_DATA_BYTE_2_7    BIT15

 set     CAN_WORD02_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD02_DATA_BYTE_1_0    BIT16
 set     CAN_WORD02_DATA_BYTE_1_1    BIT17
 set     CAN_WORD02_DATA_BYTE_1_2    BIT18
 set     CAN_WORD02_DATA_BYTE_1_3    BIT19
 set     CAN_WORD02_DATA_BYTE_1_4    BIT20
 set     CAN_WORD02_DATA_BYTE_1_5    BIT21
 set     CAN_WORD02_DATA_BYTE_1_6    BIT22
 set     CAN_WORD02_DATA_BYTE_1_7    BIT23

 set     CAN_WORD02_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD02_DATA_BYTE_0_0    BIT24
 set     CAN_WORD02_DATA_BYTE_0_1    BIT25
 set     CAN_WORD02_DATA_BYTE_0_2    BIT26
 set     CAN_WORD02_DATA_BYTE_0_3    BIT27
 set     CAN_WORD02_DATA_BYTE_0_4    BIT28
 set     CAN_WORD02_DATA_BYTE_0_5    BIT29
 set     CAN_WORD02_DATA_BYTE_0_6    BIT30
 set     CAN_WORD02_DATA_BYTE_0_7    BIT31

 set     CAN_WORD12_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD12_DATA_BYTE_7_0    BIT0
 set     CAN_WORD12_DATA_BYTE_7_1    BIT1
 set     CAN_WORD12_DATA_BYTE_7_2    BIT2
 set     CAN_WORD12_DATA_BYTE_7_3    BIT3
 set     CAN_WORD12_DATA_BYTE_7_4    BIT4
 set     CAN_WORD12_DATA_BYTE_7_5    BIT5
 set     CAN_WORD12_DATA_BYTE_7_6    BIT6
 set     CAN_WORD12_DATA_BYTE_7_7    BIT7

 set     CAN_WORD12_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD12_DATA_BYTE_6_0    BIT8
 set     CAN_WORD12_DATA_BYTE_6_1    BIT9
 set     CAN_WORD12_DATA_BYTE_6_2    BIT10
 set     CAN_WORD12_DATA_BYTE_6_3    BIT11
 set     CAN_WORD12_DATA_BYTE_6_4    BIT12
 set     CAN_WORD12_DATA_BYTE_6_5    BIT13
 set     CAN_WORD12_DATA_BYTE_6_6    BIT14
 set     CAN_WORD12_DATA_BYTE_6_7    BIT15

 set     CAN_WORD12_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD12_DATA_BYTE_5_0    BIT16
 set     CAN_WORD12_DATA_BYTE_5_1    BIT17
 set     CAN_WORD12_DATA_BYTE_5_2    BIT18
 set     CAN_WORD12_DATA_BYTE_5_3    BIT19
 set     CAN_WORD12_DATA_BYTE_5_4    BIT20
 set     CAN_WORD12_DATA_BYTE_5_5    BIT21
 set     CAN_WORD12_DATA_BYTE_5_6    BIT22
 set     CAN_WORD12_DATA_BYTE_5_7    BIT23

 set     CAN_WORD12_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD12_DATA_BYTE_4_0    BIT24
 set     CAN_WORD12_DATA_BYTE_4_1    BIT25
 set     CAN_WORD12_DATA_BYTE_4_2    BIT26
 set     CAN_WORD12_DATA_BYTE_4_3    BIT27
 set     CAN_WORD12_DATA_BYTE_4_4    BIT28
 set     CAN_WORD12_DATA_BYTE_4_5    BIT29
 set     CAN_WORD12_DATA_BYTE_4_6    BIT30
 set     CAN_WORD12_DATA_BYTE_4_7    BIT31

 set     CAN_CS3_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS3_TIME_STAMP_0        BIT0
 set     CAN_CS3_TIME_STAMP_1        BIT1
 set     CAN_CS3_TIME_STAMP_2        BIT2
 set     CAN_CS3_TIME_STAMP_3        BIT3
 set     CAN_CS3_TIME_STAMP_4        BIT4
 set     CAN_CS3_TIME_STAMP_5        BIT5
 set     CAN_CS3_TIME_STAMP_6        BIT6
 set     CAN_CS3_TIME_STAMP_7        BIT7
 set     CAN_CS3_TIME_STAMP_8        BIT8
 set     CAN_CS3_TIME_STAMP_9        BIT9
 set     CAN_CS3_TIME_STAMP_10       BIT10
 set     CAN_CS3_TIME_STAMP_11       BIT11
 set     CAN_CS3_TIME_STAMP_12       BIT12
 set     CAN_CS3_TIME_STAMP_13       BIT13
 set     CAN_CS3_TIME_STAMP_14       BIT14
 set     CAN_CS3_TIME_STAMP_15       BIT15

 set     CAN_CS3_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS3_DLC_0               BIT16
 set     CAN_CS3_DLC_1               BIT17
 set     CAN_CS3_DLC_2               BIT18
 set     CAN_CS3_DLC_3               BIT19

 set     CAN_CS3_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS3_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS3_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS3_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS3_CODE_0              BIT24
 set     CAN_CS3_CODE_1              BIT25
 set     CAN_CS3_CODE_2              BIT26
 set     CAN_CS3_CODE_3              BIT27

 set     CAN_ID3_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID3_EXT_0               BIT0
 set     CAN_ID3_EXT_1               BIT1
 set     CAN_ID3_EXT_2               BIT2
 set     CAN_ID3_EXT_3               BIT3
 set     CAN_ID3_EXT_4               BIT4
 set     CAN_ID3_EXT_5               BIT5
 set     CAN_ID3_EXT_6               BIT6
 set     CAN_ID3_EXT_7               BIT7
 set     CAN_ID3_EXT_8               BIT8
 set     CAN_ID3_EXT_9               BIT9
 set     CAN_ID3_EXT_10              BIT10
 set     CAN_ID3_EXT_11              BIT11
 set     CAN_ID3_EXT_12              BIT12
 set     CAN_ID3_EXT_13              BIT13
 set     CAN_ID3_EXT_14              BIT14
 set     CAN_ID3_EXT_15              BIT15
 set     CAN_ID3_EXT_16              BIT16
 set     CAN_ID3_EXT_17              BIT17

 set     CAN_ID3_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID3_STD_0               BIT18
 set     CAN_ID3_STD_1               BIT19
 set     CAN_ID3_STD_2               BIT20
 set     CAN_ID3_STD_3               BIT21
 set     CAN_ID3_STD_4               BIT22
 set     CAN_ID3_STD_5               BIT23
 set     CAN_ID3_STD_6               BIT24
 set     CAN_ID3_STD_7               BIT25
 set     CAN_ID3_STD_8               BIT26
 set     CAN_ID3_STD_9               BIT27
 set     CAN_ID3_STD_10              BIT28

 set     CAN_ID3_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID3_PRIO_0              BIT29
 set     CAN_ID3_PRIO_1              BIT30
 set     CAN_ID3_PRIO_2              BIT31

 set     CAN_WORD03_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD03_DATA_BYTE_3_0    BIT0
 set     CAN_WORD03_DATA_BYTE_3_1    BIT1
 set     CAN_WORD03_DATA_BYTE_3_2    BIT2
 set     CAN_WORD03_DATA_BYTE_3_3    BIT3
 set     CAN_WORD03_DATA_BYTE_3_4    BIT4
 set     CAN_WORD03_DATA_BYTE_3_5    BIT5
 set     CAN_WORD03_DATA_BYTE_3_6    BIT6
 set     CAN_WORD03_DATA_BYTE_3_7    BIT7

 set     CAN_WORD03_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD03_DATA_BYTE_2_0    BIT8
 set     CAN_WORD03_DATA_BYTE_2_1    BIT9
 set     CAN_WORD03_DATA_BYTE_2_2    BIT10
 set     CAN_WORD03_DATA_BYTE_2_3    BIT11
 set     CAN_WORD03_DATA_BYTE_2_4    BIT12
 set     CAN_WORD03_DATA_BYTE_2_5    BIT13
 set     CAN_WORD03_DATA_BYTE_2_6    BIT14
 set     CAN_WORD03_DATA_BYTE_2_7    BIT15

 set     CAN_WORD03_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD03_DATA_BYTE_1_0    BIT16
 set     CAN_WORD03_DATA_BYTE_1_1    BIT17
 set     CAN_WORD03_DATA_BYTE_1_2    BIT18
 set     CAN_WORD03_DATA_BYTE_1_3    BIT19
 set     CAN_WORD03_DATA_BYTE_1_4    BIT20
 set     CAN_WORD03_DATA_BYTE_1_5    BIT21
 set     CAN_WORD03_DATA_BYTE_1_6    BIT22
 set     CAN_WORD03_DATA_BYTE_1_7    BIT23

 set     CAN_WORD03_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD03_DATA_BYTE_0_0    BIT24
 set     CAN_WORD03_DATA_BYTE_0_1    BIT25
 set     CAN_WORD03_DATA_BYTE_0_2    BIT26
 set     CAN_WORD03_DATA_BYTE_0_3    BIT27
 set     CAN_WORD03_DATA_BYTE_0_4    BIT28
 set     CAN_WORD03_DATA_BYTE_0_5    BIT29
 set     CAN_WORD03_DATA_BYTE_0_6    BIT30
 set     CAN_WORD03_DATA_BYTE_0_7    BIT31

 set     CAN_WORD13_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD13_DATA_BYTE_7_0    BIT0
 set     CAN_WORD13_DATA_BYTE_7_1    BIT1
 set     CAN_WORD13_DATA_BYTE_7_2    BIT2
 set     CAN_WORD13_DATA_BYTE_7_3    BIT3
 set     CAN_WORD13_DATA_BYTE_7_4    BIT4
 set     CAN_WORD13_DATA_BYTE_7_5    BIT5
 set     CAN_WORD13_DATA_BYTE_7_6    BIT6
 set     CAN_WORD13_DATA_BYTE_7_7    BIT7

 set     CAN_WORD13_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD13_DATA_BYTE_6_0    BIT8
 set     CAN_WORD13_DATA_BYTE_6_1    BIT9
 set     CAN_WORD13_DATA_BYTE_6_2    BIT10
 set     CAN_WORD13_DATA_BYTE_6_3    BIT11
 set     CAN_WORD13_DATA_BYTE_6_4    BIT12
 set     CAN_WORD13_DATA_BYTE_6_5    BIT13
 set     CAN_WORD13_DATA_BYTE_6_6    BIT14
 set     CAN_WORD13_DATA_BYTE_6_7    BIT15

 set     CAN_WORD13_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD13_DATA_BYTE_5_0    BIT16
 set     CAN_WORD13_DATA_BYTE_5_1    BIT17
 set     CAN_WORD13_DATA_BYTE_5_2    BIT18
 set     CAN_WORD13_DATA_BYTE_5_3    BIT19
 set     CAN_WORD13_DATA_BYTE_5_4    BIT20
 set     CAN_WORD13_DATA_BYTE_5_5    BIT21
 set     CAN_WORD13_DATA_BYTE_5_6    BIT22
 set     CAN_WORD13_DATA_BYTE_5_7    BIT23

 set     CAN_WORD13_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD13_DATA_BYTE_4_0    BIT24
 set     CAN_WORD13_DATA_BYTE_4_1    BIT25
 set     CAN_WORD13_DATA_BYTE_4_2    BIT26
 set     CAN_WORD13_DATA_BYTE_4_3    BIT27
 set     CAN_WORD13_DATA_BYTE_4_4    BIT28
 set     CAN_WORD13_DATA_BYTE_4_5    BIT29
 set     CAN_WORD13_DATA_BYTE_4_6    BIT30
 set     CAN_WORD13_DATA_BYTE_4_7    BIT31

 set     CAN_CS4_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS4_TIME_STAMP_0        BIT0
 set     CAN_CS4_TIME_STAMP_1        BIT1
 set     CAN_CS4_TIME_STAMP_2        BIT2
 set     CAN_CS4_TIME_STAMP_3        BIT3
 set     CAN_CS4_TIME_STAMP_4        BIT4
 set     CAN_CS4_TIME_STAMP_5        BIT5
 set     CAN_CS4_TIME_STAMP_6        BIT6
 set     CAN_CS4_TIME_STAMP_7        BIT7
 set     CAN_CS4_TIME_STAMP_8        BIT8
 set     CAN_CS4_TIME_STAMP_9        BIT9
 set     CAN_CS4_TIME_STAMP_10       BIT10
 set     CAN_CS4_TIME_STAMP_11       BIT11
 set     CAN_CS4_TIME_STAMP_12       BIT12
 set     CAN_CS4_TIME_STAMP_13       BIT13
 set     CAN_CS4_TIME_STAMP_14       BIT14
 set     CAN_CS4_TIME_STAMP_15       BIT15

 set     CAN_CS4_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS4_DLC_0               BIT16
 set     CAN_CS4_DLC_1               BIT17
 set     CAN_CS4_DLC_2               BIT18
 set     CAN_CS4_DLC_3               BIT19

 set     CAN_CS4_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS4_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS4_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS4_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS4_CODE_0              BIT24
 set     CAN_CS4_CODE_1              BIT25
 set     CAN_CS4_CODE_2              BIT26
 set     CAN_CS4_CODE_3              BIT27

 set     CAN_ID4_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID4_EXT_0               BIT0
 set     CAN_ID4_EXT_1               BIT1
 set     CAN_ID4_EXT_2               BIT2
 set     CAN_ID4_EXT_3               BIT3
 set     CAN_ID4_EXT_4               BIT4
 set     CAN_ID4_EXT_5               BIT5
 set     CAN_ID4_EXT_6               BIT6
 set     CAN_ID4_EXT_7               BIT7
 set     CAN_ID4_EXT_8               BIT8
 set     CAN_ID4_EXT_9               BIT9
 set     CAN_ID4_EXT_10              BIT10
 set     CAN_ID4_EXT_11              BIT11
 set     CAN_ID4_EXT_12              BIT12
 set     CAN_ID4_EXT_13              BIT13
 set     CAN_ID4_EXT_14              BIT14
 set     CAN_ID4_EXT_15              BIT15
 set     CAN_ID4_EXT_16              BIT16
 set     CAN_ID4_EXT_17              BIT17

 set     CAN_ID4_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID4_STD_0               BIT18
 set     CAN_ID4_STD_1               BIT19
 set     CAN_ID4_STD_2               BIT20
 set     CAN_ID4_STD_3               BIT21
 set     CAN_ID4_STD_4               BIT22
 set     CAN_ID4_STD_5               BIT23
 set     CAN_ID4_STD_6               BIT24
 set     CAN_ID4_STD_7               BIT25
 set     CAN_ID4_STD_8               BIT26
 set     CAN_ID4_STD_9               BIT27
 set     CAN_ID4_STD_10              BIT28

 set     CAN_ID4_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID4_PRIO_0              BIT29
 set     CAN_ID4_PRIO_1              BIT30
 set     CAN_ID4_PRIO_2              BIT31

 set     CAN_WORD04_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD04_DATA_BYTE_3_0    BIT0
 set     CAN_WORD04_DATA_BYTE_3_1    BIT1
 set     CAN_WORD04_DATA_BYTE_3_2    BIT2
 set     CAN_WORD04_DATA_BYTE_3_3    BIT3
 set     CAN_WORD04_DATA_BYTE_3_4    BIT4
 set     CAN_WORD04_DATA_BYTE_3_5    BIT5
 set     CAN_WORD04_DATA_BYTE_3_6    BIT6
 set     CAN_WORD04_DATA_BYTE_3_7    BIT7

 set     CAN_WORD04_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD04_DATA_BYTE_2_0    BIT8
 set     CAN_WORD04_DATA_BYTE_2_1    BIT9
 set     CAN_WORD04_DATA_BYTE_2_2    BIT10
 set     CAN_WORD04_DATA_BYTE_2_3    BIT11
 set     CAN_WORD04_DATA_BYTE_2_4    BIT12
 set     CAN_WORD04_DATA_BYTE_2_5    BIT13
 set     CAN_WORD04_DATA_BYTE_2_6    BIT14
 set     CAN_WORD04_DATA_BYTE_2_7    BIT15

 set     CAN_WORD04_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD04_DATA_BYTE_1_0    BIT16
 set     CAN_WORD04_DATA_BYTE_1_1    BIT17
 set     CAN_WORD04_DATA_BYTE_1_2    BIT18
 set     CAN_WORD04_DATA_BYTE_1_3    BIT19
 set     CAN_WORD04_DATA_BYTE_1_4    BIT20
 set     CAN_WORD04_DATA_BYTE_1_5    BIT21
 set     CAN_WORD04_DATA_BYTE_1_6    BIT22
 set     CAN_WORD04_DATA_BYTE_1_7    BIT23

 set     CAN_WORD04_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD04_DATA_BYTE_0_0    BIT24
 set     CAN_WORD04_DATA_BYTE_0_1    BIT25
 set     CAN_WORD04_DATA_BYTE_0_2    BIT26
 set     CAN_WORD04_DATA_BYTE_0_3    BIT27
 set     CAN_WORD04_DATA_BYTE_0_4    BIT28
 set     CAN_WORD04_DATA_BYTE_0_5    BIT29
 set     CAN_WORD04_DATA_BYTE_0_6    BIT30
 set     CAN_WORD04_DATA_BYTE_0_7    BIT31

 set     CAN_WORD14_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD14_DATA_BYTE_7_0    BIT0
 set     CAN_WORD14_DATA_BYTE_7_1    BIT1
 set     CAN_WORD14_DATA_BYTE_7_2    BIT2
 set     CAN_WORD14_DATA_BYTE_7_3    BIT3
 set     CAN_WORD14_DATA_BYTE_7_4    BIT4
 set     CAN_WORD14_DATA_BYTE_7_5    BIT5
 set     CAN_WORD14_DATA_BYTE_7_6    BIT6
 set     CAN_WORD14_DATA_BYTE_7_7    BIT7

 set     CAN_WORD14_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD14_DATA_BYTE_6_0    BIT8
 set     CAN_WORD14_DATA_BYTE_6_1    BIT9
 set     CAN_WORD14_DATA_BYTE_6_2    BIT10
 set     CAN_WORD14_DATA_BYTE_6_3    BIT11
 set     CAN_WORD14_DATA_BYTE_6_4    BIT12
 set     CAN_WORD14_DATA_BYTE_6_5    BIT13
 set     CAN_WORD14_DATA_BYTE_6_6    BIT14
 set     CAN_WORD14_DATA_BYTE_6_7    BIT15

 set     CAN_WORD14_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD14_DATA_BYTE_5_0    BIT16
 set     CAN_WORD14_DATA_BYTE_5_1    BIT17
 set     CAN_WORD14_DATA_BYTE_5_2    BIT18
 set     CAN_WORD14_DATA_BYTE_5_3    BIT19
 set     CAN_WORD14_DATA_BYTE_5_4    BIT20
 set     CAN_WORD14_DATA_BYTE_5_5    BIT21
 set     CAN_WORD14_DATA_BYTE_5_6    BIT22
 set     CAN_WORD14_DATA_BYTE_5_7    BIT23

 set     CAN_WORD14_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD14_DATA_BYTE_4_0    BIT24
 set     CAN_WORD14_DATA_BYTE_4_1    BIT25
 set     CAN_WORD14_DATA_BYTE_4_2    BIT26
 set     CAN_WORD14_DATA_BYTE_4_3    BIT27
 set     CAN_WORD14_DATA_BYTE_4_4    BIT28
 set     CAN_WORD14_DATA_BYTE_4_5    BIT29
 set     CAN_WORD14_DATA_BYTE_4_6    BIT30
 set     CAN_WORD14_DATA_BYTE_4_7    BIT31

 set     CAN_CS5_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS5_TIME_STAMP_0        BIT0
 set     CAN_CS5_TIME_STAMP_1        BIT1
 set     CAN_CS5_TIME_STAMP_2        BIT2
 set     CAN_CS5_TIME_STAMP_3        BIT3
 set     CAN_CS5_TIME_STAMP_4        BIT4
 set     CAN_CS5_TIME_STAMP_5        BIT5
 set     CAN_CS5_TIME_STAMP_6        BIT6
 set     CAN_CS5_TIME_STAMP_7        BIT7
 set     CAN_CS5_TIME_STAMP_8        BIT8
 set     CAN_CS5_TIME_STAMP_9        BIT9
 set     CAN_CS5_TIME_STAMP_10       BIT10
 set     CAN_CS5_TIME_STAMP_11       BIT11
 set     CAN_CS5_TIME_STAMP_12       BIT12
 set     CAN_CS5_TIME_STAMP_13       BIT13
 set     CAN_CS5_TIME_STAMP_14       BIT14
 set     CAN_CS5_TIME_STAMP_15       BIT15

 set     CAN_CS5_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS5_DLC_0               BIT16
 set     CAN_CS5_DLC_1               BIT17
 set     CAN_CS5_DLC_2               BIT18
 set     CAN_CS5_DLC_3               BIT19

 set     CAN_CS5_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS5_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS5_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS5_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS5_CODE_0              BIT24
 set     CAN_CS5_CODE_1              BIT25
 set     CAN_CS5_CODE_2              BIT26
 set     CAN_CS5_CODE_3              BIT27

 set     CAN_ID5_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID5_EXT_0               BIT0
 set     CAN_ID5_EXT_1               BIT1
 set     CAN_ID5_EXT_2               BIT2
 set     CAN_ID5_EXT_3               BIT3
 set     CAN_ID5_EXT_4               BIT4
 set     CAN_ID5_EXT_5               BIT5
 set     CAN_ID5_EXT_6               BIT6
 set     CAN_ID5_EXT_7               BIT7
 set     CAN_ID5_EXT_8               BIT8
 set     CAN_ID5_EXT_9               BIT9
 set     CAN_ID5_EXT_10              BIT10
 set     CAN_ID5_EXT_11              BIT11
 set     CAN_ID5_EXT_12              BIT12
 set     CAN_ID5_EXT_13              BIT13
 set     CAN_ID5_EXT_14              BIT14
 set     CAN_ID5_EXT_15              BIT15
 set     CAN_ID5_EXT_16              BIT16
 set     CAN_ID5_EXT_17              BIT17

 set     CAN_ID5_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID5_STD_0               BIT18
 set     CAN_ID5_STD_1               BIT19
 set     CAN_ID5_STD_2               BIT20
 set     CAN_ID5_STD_3               BIT21
 set     CAN_ID5_STD_4               BIT22
 set     CAN_ID5_STD_5               BIT23
 set     CAN_ID5_STD_6               BIT24
 set     CAN_ID5_STD_7               BIT25
 set     CAN_ID5_STD_8               BIT26
 set     CAN_ID5_STD_9               BIT27
 set     CAN_ID5_STD_10              BIT28

 set     CAN_ID5_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID5_PRIO_0              BIT29
 set     CAN_ID5_PRIO_1              BIT30
 set     CAN_ID5_PRIO_2              BIT31

 set     CAN_WORD05_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD05_DATA_BYTE_3_0    BIT0
 set     CAN_WORD05_DATA_BYTE_3_1    BIT1
 set     CAN_WORD05_DATA_BYTE_3_2    BIT2
 set     CAN_WORD05_DATA_BYTE_3_3    BIT3
 set     CAN_WORD05_DATA_BYTE_3_4    BIT4
 set     CAN_WORD05_DATA_BYTE_3_5    BIT5
 set     CAN_WORD05_DATA_BYTE_3_6    BIT6
 set     CAN_WORD05_DATA_BYTE_3_7    BIT7

 set     CAN_WORD05_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD05_DATA_BYTE_2_0    BIT8
 set     CAN_WORD05_DATA_BYTE_2_1    BIT9
 set     CAN_WORD05_DATA_BYTE_2_2    BIT10
 set     CAN_WORD05_DATA_BYTE_2_3    BIT11
 set     CAN_WORD05_DATA_BYTE_2_4    BIT12
 set     CAN_WORD05_DATA_BYTE_2_5    BIT13
 set     CAN_WORD05_DATA_BYTE_2_6    BIT14
 set     CAN_WORD05_DATA_BYTE_2_7    BIT15

 set     CAN_WORD05_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD05_DATA_BYTE_1_0    BIT16
 set     CAN_WORD05_DATA_BYTE_1_1    BIT17
 set     CAN_WORD05_DATA_BYTE_1_2    BIT18
 set     CAN_WORD05_DATA_BYTE_1_3    BIT19
 set     CAN_WORD05_DATA_BYTE_1_4    BIT20
 set     CAN_WORD05_DATA_BYTE_1_5    BIT21
 set     CAN_WORD05_DATA_BYTE_1_6    BIT22
 set     CAN_WORD05_DATA_BYTE_1_7    BIT23

 set     CAN_WORD05_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD05_DATA_BYTE_0_0    BIT24
 set     CAN_WORD05_DATA_BYTE_0_1    BIT25
 set     CAN_WORD05_DATA_BYTE_0_2    BIT26
 set     CAN_WORD05_DATA_BYTE_0_3    BIT27
 set     CAN_WORD05_DATA_BYTE_0_4    BIT28
 set     CAN_WORD05_DATA_BYTE_0_5    BIT29
 set     CAN_WORD05_DATA_BYTE_0_6    BIT30
 set     CAN_WORD05_DATA_BYTE_0_7    BIT31

 set     CAN_WORD15_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD15_DATA_BYTE_7_0    BIT0
 set     CAN_WORD15_DATA_BYTE_7_1    BIT1
 set     CAN_WORD15_DATA_BYTE_7_2    BIT2
 set     CAN_WORD15_DATA_BYTE_7_3    BIT3
 set     CAN_WORD15_DATA_BYTE_7_4    BIT4
 set     CAN_WORD15_DATA_BYTE_7_5    BIT5
 set     CAN_WORD15_DATA_BYTE_7_6    BIT6
 set     CAN_WORD15_DATA_BYTE_7_7    BIT7

 set     CAN_WORD15_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD15_DATA_BYTE_6_0    BIT8
 set     CAN_WORD15_DATA_BYTE_6_1    BIT9
 set     CAN_WORD15_DATA_BYTE_6_2    BIT10
 set     CAN_WORD15_DATA_BYTE_6_3    BIT11
 set     CAN_WORD15_DATA_BYTE_6_4    BIT12
 set     CAN_WORD15_DATA_BYTE_6_5    BIT13
 set     CAN_WORD15_DATA_BYTE_6_6    BIT14
 set     CAN_WORD15_DATA_BYTE_6_7    BIT15

 set     CAN_WORD15_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD15_DATA_BYTE_5_0    BIT16
 set     CAN_WORD15_DATA_BYTE_5_1    BIT17
 set     CAN_WORD15_DATA_BYTE_5_2    BIT18
 set     CAN_WORD15_DATA_BYTE_5_3    BIT19
 set     CAN_WORD15_DATA_BYTE_5_4    BIT20
 set     CAN_WORD15_DATA_BYTE_5_5    BIT21
 set     CAN_WORD15_DATA_BYTE_5_6    BIT22
 set     CAN_WORD15_DATA_BYTE_5_7    BIT23

 set     CAN_WORD15_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD15_DATA_BYTE_4_0    BIT24
 set     CAN_WORD15_DATA_BYTE_4_1    BIT25
 set     CAN_WORD15_DATA_BYTE_4_2    BIT26
 set     CAN_WORD15_DATA_BYTE_4_3    BIT27
 set     CAN_WORD15_DATA_BYTE_4_4    BIT28
 set     CAN_WORD15_DATA_BYTE_4_5    BIT29
 set     CAN_WORD15_DATA_BYTE_4_6    BIT30
 set     CAN_WORD15_DATA_BYTE_4_7    BIT31

 set     CAN_CS6_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS6_TIME_STAMP_0        BIT0
 set     CAN_CS6_TIME_STAMP_1        BIT1
 set     CAN_CS6_TIME_STAMP_2        BIT2
 set     CAN_CS6_TIME_STAMP_3        BIT3
 set     CAN_CS6_TIME_STAMP_4        BIT4
 set     CAN_CS6_TIME_STAMP_5        BIT5
 set     CAN_CS6_TIME_STAMP_6        BIT6
 set     CAN_CS6_TIME_STAMP_7        BIT7
 set     CAN_CS6_TIME_STAMP_8        BIT8
 set     CAN_CS6_TIME_STAMP_9        BIT9
 set     CAN_CS6_TIME_STAMP_10       BIT10
 set     CAN_CS6_TIME_STAMP_11       BIT11
 set     CAN_CS6_TIME_STAMP_12       BIT12
 set     CAN_CS6_TIME_STAMP_13       BIT13
 set     CAN_CS6_TIME_STAMP_14       BIT14
 set     CAN_CS6_TIME_STAMP_15       BIT15

 set     CAN_CS6_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS6_DLC_0               BIT16
 set     CAN_CS6_DLC_1               BIT17
 set     CAN_CS6_DLC_2               BIT18
 set     CAN_CS6_DLC_3               BIT19

 set     CAN_CS6_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS6_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS6_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS6_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS6_CODE_0              BIT24
 set     CAN_CS6_CODE_1              BIT25
 set     CAN_CS6_CODE_2              BIT26
 set     CAN_CS6_CODE_3              BIT27

 set     CAN_ID6_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID6_EXT_0               BIT0
 set     CAN_ID6_EXT_1               BIT1
 set     CAN_ID6_EXT_2               BIT2
 set     CAN_ID6_EXT_3               BIT3
 set     CAN_ID6_EXT_4               BIT4
 set     CAN_ID6_EXT_5               BIT5
 set     CAN_ID6_EXT_6               BIT6
 set     CAN_ID6_EXT_7               BIT7
 set     CAN_ID6_EXT_8               BIT8
 set     CAN_ID6_EXT_9               BIT9
 set     CAN_ID6_EXT_10              BIT10
 set     CAN_ID6_EXT_11              BIT11
 set     CAN_ID6_EXT_12              BIT12
 set     CAN_ID6_EXT_13              BIT13
 set     CAN_ID6_EXT_14              BIT14
 set     CAN_ID6_EXT_15              BIT15
 set     CAN_ID6_EXT_16              BIT16
 set     CAN_ID6_EXT_17              BIT17

 set     CAN_ID6_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID6_STD_0               BIT18
 set     CAN_ID6_STD_1               BIT19
 set     CAN_ID6_STD_2               BIT20
 set     CAN_ID6_STD_3               BIT21
 set     CAN_ID6_STD_4               BIT22
 set     CAN_ID6_STD_5               BIT23
 set     CAN_ID6_STD_6               BIT24
 set     CAN_ID6_STD_7               BIT25
 set     CAN_ID6_STD_8               BIT26
 set     CAN_ID6_STD_9               BIT27
 set     CAN_ID6_STD_10              BIT28

 set     CAN_ID6_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID6_PRIO_0              BIT29
 set     CAN_ID6_PRIO_1              BIT30
 set     CAN_ID6_PRIO_2              BIT31

 set     CAN_WORD06_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD06_DATA_BYTE_3_0    BIT0
 set     CAN_WORD06_DATA_BYTE_3_1    BIT1
 set     CAN_WORD06_DATA_BYTE_3_2    BIT2
 set     CAN_WORD06_DATA_BYTE_3_3    BIT3
 set     CAN_WORD06_DATA_BYTE_3_4    BIT4
 set     CAN_WORD06_DATA_BYTE_3_5    BIT5
 set     CAN_WORD06_DATA_BYTE_3_6    BIT6
 set     CAN_WORD06_DATA_BYTE_3_7    BIT7

 set     CAN_WORD06_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD06_DATA_BYTE_2_0    BIT8
 set     CAN_WORD06_DATA_BYTE_2_1    BIT9
 set     CAN_WORD06_DATA_BYTE_2_2    BIT10
 set     CAN_WORD06_DATA_BYTE_2_3    BIT11
 set     CAN_WORD06_DATA_BYTE_2_4    BIT12
 set     CAN_WORD06_DATA_BYTE_2_5    BIT13
 set     CAN_WORD06_DATA_BYTE_2_6    BIT14
 set     CAN_WORD06_DATA_BYTE_2_7    BIT15

 set     CAN_WORD06_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD06_DATA_BYTE_1_0    BIT16
 set     CAN_WORD06_DATA_BYTE_1_1    BIT17
 set     CAN_WORD06_DATA_BYTE_1_2    BIT18
 set     CAN_WORD06_DATA_BYTE_1_3    BIT19
 set     CAN_WORD06_DATA_BYTE_1_4    BIT20
 set     CAN_WORD06_DATA_BYTE_1_5    BIT21
 set     CAN_WORD06_DATA_BYTE_1_6    BIT22
 set     CAN_WORD06_DATA_BYTE_1_7    BIT23

 set     CAN_WORD06_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD06_DATA_BYTE_0_0    BIT24
 set     CAN_WORD06_DATA_BYTE_0_1    BIT25
 set     CAN_WORD06_DATA_BYTE_0_2    BIT26
 set     CAN_WORD06_DATA_BYTE_0_3    BIT27
 set     CAN_WORD06_DATA_BYTE_0_4    BIT28
 set     CAN_WORD06_DATA_BYTE_0_5    BIT29
 set     CAN_WORD06_DATA_BYTE_0_6    BIT30
 set     CAN_WORD06_DATA_BYTE_0_7    BIT31

 set     CAN_WORD16_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD16_DATA_BYTE_7_0    BIT0
 set     CAN_WORD16_DATA_BYTE_7_1    BIT1
 set     CAN_WORD16_DATA_BYTE_7_2    BIT2
 set     CAN_WORD16_DATA_BYTE_7_3    BIT3
 set     CAN_WORD16_DATA_BYTE_7_4    BIT4
 set     CAN_WORD16_DATA_BYTE_7_5    BIT5
 set     CAN_WORD16_DATA_BYTE_7_6    BIT6
 set     CAN_WORD16_DATA_BYTE_7_7    BIT7

 set     CAN_WORD16_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD16_DATA_BYTE_6_0    BIT8
 set     CAN_WORD16_DATA_BYTE_6_1    BIT9
 set     CAN_WORD16_DATA_BYTE_6_2    BIT10
 set     CAN_WORD16_DATA_BYTE_6_3    BIT11
 set     CAN_WORD16_DATA_BYTE_6_4    BIT12
 set     CAN_WORD16_DATA_BYTE_6_5    BIT13
 set     CAN_WORD16_DATA_BYTE_6_6    BIT14
 set     CAN_WORD16_DATA_BYTE_6_7    BIT15

 set     CAN_WORD16_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD16_DATA_BYTE_5_0    BIT16
 set     CAN_WORD16_DATA_BYTE_5_1    BIT17
 set     CAN_WORD16_DATA_BYTE_5_2    BIT18
 set     CAN_WORD16_DATA_BYTE_5_3    BIT19
 set     CAN_WORD16_DATA_BYTE_5_4    BIT20
 set     CAN_WORD16_DATA_BYTE_5_5    BIT21
 set     CAN_WORD16_DATA_BYTE_5_6    BIT22
 set     CAN_WORD16_DATA_BYTE_5_7    BIT23

 set     CAN_WORD16_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD16_DATA_BYTE_4_0    BIT24
 set     CAN_WORD16_DATA_BYTE_4_1    BIT25
 set     CAN_WORD16_DATA_BYTE_4_2    BIT26
 set     CAN_WORD16_DATA_BYTE_4_3    BIT27
 set     CAN_WORD16_DATA_BYTE_4_4    BIT28
 set     CAN_WORD16_DATA_BYTE_4_5    BIT29
 set     CAN_WORD16_DATA_BYTE_4_6    BIT30
 set     CAN_WORD16_DATA_BYTE_4_7    BIT31

 set     CAN_CS7_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS7_TIME_STAMP_0        BIT0
 set     CAN_CS7_TIME_STAMP_1        BIT1
 set     CAN_CS7_TIME_STAMP_2        BIT2
 set     CAN_CS7_TIME_STAMP_3        BIT3
 set     CAN_CS7_TIME_STAMP_4        BIT4
 set     CAN_CS7_TIME_STAMP_5        BIT5
 set     CAN_CS7_TIME_STAMP_6        BIT6
 set     CAN_CS7_TIME_STAMP_7        BIT7
 set     CAN_CS7_TIME_STAMP_8        BIT8
 set     CAN_CS7_TIME_STAMP_9        BIT9
 set     CAN_CS7_TIME_STAMP_10       BIT10
 set     CAN_CS7_TIME_STAMP_11       BIT11
 set     CAN_CS7_TIME_STAMP_12       BIT12
 set     CAN_CS7_TIME_STAMP_13       BIT13
 set     CAN_CS7_TIME_STAMP_14       BIT14
 set     CAN_CS7_TIME_STAMP_15       BIT15

 set     CAN_CS7_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS7_DLC_0               BIT16
 set     CAN_CS7_DLC_1               BIT17
 set     CAN_CS7_DLC_2               BIT18
 set     CAN_CS7_DLC_3               BIT19

 set     CAN_CS7_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS7_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS7_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS7_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS7_CODE_0              BIT24
 set     CAN_CS7_CODE_1              BIT25
 set     CAN_CS7_CODE_2              BIT26
 set     CAN_CS7_CODE_3              BIT27

 set     CAN_ID7_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID7_EXT_0               BIT0
 set     CAN_ID7_EXT_1               BIT1
 set     CAN_ID7_EXT_2               BIT2
 set     CAN_ID7_EXT_3               BIT3
 set     CAN_ID7_EXT_4               BIT4
 set     CAN_ID7_EXT_5               BIT5
 set     CAN_ID7_EXT_6               BIT6
 set     CAN_ID7_EXT_7               BIT7
 set     CAN_ID7_EXT_8               BIT8
 set     CAN_ID7_EXT_9               BIT9
 set     CAN_ID7_EXT_10              BIT10
 set     CAN_ID7_EXT_11              BIT11
 set     CAN_ID7_EXT_12              BIT12
 set     CAN_ID7_EXT_13              BIT13
 set     CAN_ID7_EXT_14              BIT14
 set     CAN_ID7_EXT_15              BIT15
 set     CAN_ID7_EXT_16              BIT16
 set     CAN_ID7_EXT_17              BIT17

 set     CAN_ID7_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID7_STD_0               BIT18
 set     CAN_ID7_STD_1               BIT19
 set     CAN_ID7_STD_2               BIT20
 set     CAN_ID7_STD_3               BIT21
 set     CAN_ID7_STD_4               BIT22
 set     CAN_ID7_STD_5               BIT23
 set     CAN_ID7_STD_6               BIT24
 set     CAN_ID7_STD_7               BIT25
 set     CAN_ID7_STD_8               BIT26
 set     CAN_ID7_STD_9               BIT27
 set     CAN_ID7_STD_10              BIT28

 set     CAN_ID7_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID7_PRIO_0              BIT29
 set     CAN_ID7_PRIO_1              BIT30
 set     CAN_ID7_PRIO_2              BIT31

 set     CAN_WORD07_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD07_DATA_BYTE_3_0    BIT0
 set     CAN_WORD07_DATA_BYTE_3_1    BIT1
 set     CAN_WORD07_DATA_BYTE_3_2    BIT2
 set     CAN_WORD07_DATA_BYTE_3_3    BIT3
 set     CAN_WORD07_DATA_BYTE_3_4    BIT4
 set     CAN_WORD07_DATA_BYTE_3_5    BIT5
 set     CAN_WORD07_DATA_BYTE_3_6    BIT6
 set     CAN_WORD07_DATA_BYTE_3_7    BIT7

 set     CAN_WORD07_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD07_DATA_BYTE_2_0    BIT8
 set     CAN_WORD07_DATA_BYTE_2_1    BIT9
 set     CAN_WORD07_DATA_BYTE_2_2    BIT10
 set     CAN_WORD07_DATA_BYTE_2_3    BIT11
 set     CAN_WORD07_DATA_BYTE_2_4    BIT12
 set     CAN_WORD07_DATA_BYTE_2_5    BIT13
 set     CAN_WORD07_DATA_BYTE_2_6    BIT14
 set     CAN_WORD07_DATA_BYTE_2_7    BIT15

 set     CAN_WORD07_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD07_DATA_BYTE_1_0    BIT16
 set     CAN_WORD07_DATA_BYTE_1_1    BIT17
 set     CAN_WORD07_DATA_BYTE_1_2    BIT18
 set     CAN_WORD07_DATA_BYTE_1_3    BIT19
 set     CAN_WORD07_DATA_BYTE_1_4    BIT20
 set     CAN_WORD07_DATA_BYTE_1_5    BIT21
 set     CAN_WORD07_DATA_BYTE_1_6    BIT22
 set     CAN_WORD07_DATA_BYTE_1_7    BIT23

 set     CAN_WORD07_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD07_DATA_BYTE_0_0    BIT24
 set     CAN_WORD07_DATA_BYTE_0_1    BIT25
 set     CAN_WORD07_DATA_BYTE_0_2    BIT26
 set     CAN_WORD07_DATA_BYTE_0_3    BIT27
 set     CAN_WORD07_DATA_BYTE_0_4    BIT28
 set     CAN_WORD07_DATA_BYTE_0_5    BIT29
 set     CAN_WORD07_DATA_BYTE_0_6    BIT30
 set     CAN_WORD07_DATA_BYTE_0_7    BIT31

 set     CAN_WORD17_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD17_DATA_BYTE_7_0    BIT0
 set     CAN_WORD17_DATA_BYTE_7_1    BIT1
 set     CAN_WORD17_DATA_BYTE_7_2    BIT2
 set     CAN_WORD17_DATA_BYTE_7_3    BIT3
 set     CAN_WORD17_DATA_BYTE_7_4    BIT4
 set     CAN_WORD17_DATA_BYTE_7_5    BIT5
 set     CAN_WORD17_DATA_BYTE_7_6    BIT6
 set     CAN_WORD17_DATA_BYTE_7_7    BIT7

 set     CAN_WORD17_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD17_DATA_BYTE_6_0    BIT8
 set     CAN_WORD17_DATA_BYTE_6_1    BIT9
 set     CAN_WORD17_DATA_BYTE_6_2    BIT10
 set     CAN_WORD17_DATA_BYTE_6_3    BIT11
 set     CAN_WORD17_DATA_BYTE_6_4    BIT12
 set     CAN_WORD17_DATA_BYTE_6_5    BIT13
 set     CAN_WORD17_DATA_BYTE_6_6    BIT14
 set     CAN_WORD17_DATA_BYTE_6_7    BIT15

 set     CAN_WORD17_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD17_DATA_BYTE_5_0    BIT16
 set     CAN_WORD17_DATA_BYTE_5_1    BIT17
 set     CAN_WORD17_DATA_BYTE_5_2    BIT18
 set     CAN_WORD17_DATA_BYTE_5_3    BIT19
 set     CAN_WORD17_DATA_BYTE_5_4    BIT20
 set     CAN_WORD17_DATA_BYTE_5_5    BIT21
 set     CAN_WORD17_DATA_BYTE_5_6    BIT22
 set     CAN_WORD17_DATA_BYTE_5_7    BIT23

 set     CAN_WORD17_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD17_DATA_BYTE_4_0    BIT24
 set     CAN_WORD17_DATA_BYTE_4_1    BIT25
 set     CAN_WORD17_DATA_BYTE_4_2    BIT26
 set     CAN_WORD17_DATA_BYTE_4_3    BIT27
 set     CAN_WORD17_DATA_BYTE_4_4    BIT28
 set     CAN_WORD17_DATA_BYTE_4_5    BIT29
 set     CAN_WORD17_DATA_BYTE_4_6    BIT30
 set     CAN_WORD17_DATA_BYTE_4_7    BIT31

 set     CAN_CS8_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS8_TIME_STAMP_0        BIT0
 set     CAN_CS8_TIME_STAMP_1        BIT1
 set     CAN_CS8_TIME_STAMP_2        BIT2
 set     CAN_CS8_TIME_STAMP_3        BIT3
 set     CAN_CS8_TIME_STAMP_4        BIT4
 set     CAN_CS8_TIME_STAMP_5        BIT5
 set     CAN_CS8_TIME_STAMP_6        BIT6
 set     CAN_CS8_TIME_STAMP_7        BIT7
 set     CAN_CS8_TIME_STAMP_8        BIT8
 set     CAN_CS8_TIME_STAMP_9        BIT9
 set     CAN_CS8_TIME_STAMP_10       BIT10
 set     CAN_CS8_TIME_STAMP_11       BIT11
 set     CAN_CS8_TIME_STAMP_12       BIT12
 set     CAN_CS8_TIME_STAMP_13       BIT13
 set     CAN_CS8_TIME_STAMP_14       BIT14
 set     CAN_CS8_TIME_STAMP_15       BIT15

 set     CAN_CS8_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS8_DLC_0               BIT16
 set     CAN_CS8_DLC_1               BIT17
 set     CAN_CS8_DLC_2               BIT18
 set     CAN_CS8_DLC_3               BIT19

 set     CAN_CS8_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS8_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS8_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS8_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS8_CODE_0              BIT24
 set     CAN_CS8_CODE_1              BIT25
 set     CAN_CS8_CODE_2              BIT26
 set     CAN_CS8_CODE_3              BIT27

 set     CAN_ID8_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID8_EXT_0               BIT0
 set     CAN_ID8_EXT_1               BIT1
 set     CAN_ID8_EXT_2               BIT2
 set     CAN_ID8_EXT_3               BIT3
 set     CAN_ID8_EXT_4               BIT4
 set     CAN_ID8_EXT_5               BIT5
 set     CAN_ID8_EXT_6               BIT6
 set     CAN_ID8_EXT_7               BIT7
 set     CAN_ID8_EXT_8               BIT8
 set     CAN_ID8_EXT_9               BIT9
 set     CAN_ID8_EXT_10              BIT10
 set     CAN_ID8_EXT_11              BIT11
 set     CAN_ID8_EXT_12              BIT12
 set     CAN_ID8_EXT_13              BIT13
 set     CAN_ID8_EXT_14              BIT14
 set     CAN_ID8_EXT_15              BIT15
 set     CAN_ID8_EXT_16              BIT16
 set     CAN_ID8_EXT_17              BIT17

 set     CAN_ID8_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID8_STD_0               BIT18
 set     CAN_ID8_STD_1               BIT19
 set     CAN_ID8_STD_2               BIT20
 set     CAN_ID8_STD_3               BIT21
 set     CAN_ID8_STD_4               BIT22
 set     CAN_ID8_STD_5               BIT23
 set     CAN_ID8_STD_6               BIT24
 set     CAN_ID8_STD_7               BIT25
 set     CAN_ID8_STD_8               BIT26
 set     CAN_ID8_STD_9               BIT27
 set     CAN_ID8_STD_10              BIT28

 set     CAN_ID8_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID8_PRIO_0              BIT29
 set     CAN_ID8_PRIO_1              BIT30
 set     CAN_ID8_PRIO_2              BIT31

 set     CAN_WORD08_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD08_DATA_BYTE_3_0    BIT0
 set     CAN_WORD08_DATA_BYTE_3_1    BIT1
 set     CAN_WORD08_DATA_BYTE_3_2    BIT2
 set     CAN_WORD08_DATA_BYTE_3_3    BIT3
 set     CAN_WORD08_DATA_BYTE_3_4    BIT4
 set     CAN_WORD08_DATA_BYTE_3_5    BIT5
 set     CAN_WORD08_DATA_BYTE_3_6    BIT6
 set     CAN_WORD08_DATA_BYTE_3_7    BIT7

 set     CAN_WORD08_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD08_DATA_BYTE_2_0    BIT8
 set     CAN_WORD08_DATA_BYTE_2_1    BIT9
 set     CAN_WORD08_DATA_BYTE_2_2    BIT10
 set     CAN_WORD08_DATA_BYTE_2_3    BIT11
 set     CAN_WORD08_DATA_BYTE_2_4    BIT12
 set     CAN_WORD08_DATA_BYTE_2_5    BIT13
 set     CAN_WORD08_DATA_BYTE_2_6    BIT14
 set     CAN_WORD08_DATA_BYTE_2_7    BIT15

 set     CAN_WORD08_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD08_DATA_BYTE_1_0    BIT16
 set     CAN_WORD08_DATA_BYTE_1_1    BIT17
 set     CAN_WORD08_DATA_BYTE_1_2    BIT18
 set     CAN_WORD08_DATA_BYTE_1_3    BIT19
 set     CAN_WORD08_DATA_BYTE_1_4    BIT20
 set     CAN_WORD08_DATA_BYTE_1_5    BIT21
 set     CAN_WORD08_DATA_BYTE_1_6    BIT22
 set     CAN_WORD08_DATA_BYTE_1_7    BIT23

 set     CAN_WORD08_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD08_DATA_BYTE_0_0    BIT24
 set     CAN_WORD08_DATA_BYTE_0_1    BIT25
 set     CAN_WORD08_DATA_BYTE_0_2    BIT26
 set     CAN_WORD08_DATA_BYTE_0_3    BIT27
 set     CAN_WORD08_DATA_BYTE_0_4    BIT28
 set     CAN_WORD08_DATA_BYTE_0_5    BIT29
 set     CAN_WORD08_DATA_BYTE_0_6    BIT30
 set     CAN_WORD08_DATA_BYTE_0_7    BIT31

 set     CAN_WORD18_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD18_DATA_BYTE_7_0    BIT0
 set     CAN_WORD18_DATA_BYTE_7_1    BIT1
 set     CAN_WORD18_DATA_BYTE_7_2    BIT2
 set     CAN_WORD18_DATA_BYTE_7_3    BIT3
 set     CAN_WORD18_DATA_BYTE_7_4    BIT4
 set     CAN_WORD18_DATA_BYTE_7_5    BIT5
 set     CAN_WORD18_DATA_BYTE_7_6    BIT6
 set     CAN_WORD18_DATA_BYTE_7_7    BIT7

 set     CAN_WORD18_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD18_DATA_BYTE_6_0    BIT8
 set     CAN_WORD18_DATA_BYTE_6_1    BIT9
 set     CAN_WORD18_DATA_BYTE_6_2    BIT10
 set     CAN_WORD18_DATA_BYTE_6_3    BIT11
 set     CAN_WORD18_DATA_BYTE_6_4    BIT12
 set     CAN_WORD18_DATA_BYTE_6_5    BIT13
 set     CAN_WORD18_DATA_BYTE_6_6    BIT14
 set     CAN_WORD18_DATA_BYTE_6_7    BIT15

 set     CAN_WORD18_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD18_DATA_BYTE_5_0    BIT16
 set     CAN_WORD18_DATA_BYTE_5_1    BIT17
 set     CAN_WORD18_DATA_BYTE_5_2    BIT18
 set     CAN_WORD18_DATA_BYTE_5_3    BIT19
 set     CAN_WORD18_DATA_BYTE_5_4    BIT20
 set     CAN_WORD18_DATA_BYTE_5_5    BIT21
 set     CAN_WORD18_DATA_BYTE_5_6    BIT22
 set     CAN_WORD18_DATA_BYTE_5_7    BIT23

 set     CAN_WORD18_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD18_DATA_BYTE_4_0    BIT24
 set     CAN_WORD18_DATA_BYTE_4_1    BIT25
 set     CAN_WORD18_DATA_BYTE_4_2    BIT26
 set     CAN_WORD18_DATA_BYTE_4_3    BIT27
 set     CAN_WORD18_DATA_BYTE_4_4    BIT28
 set     CAN_WORD18_DATA_BYTE_4_5    BIT29
 set     CAN_WORD18_DATA_BYTE_4_6    BIT30
 set     CAN_WORD18_DATA_BYTE_4_7    BIT31

 set     CAN_CS9_TIME_STAMP          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS9_TIME_STAMP_0        BIT0
 set     CAN_CS9_TIME_STAMP_1        BIT1
 set     CAN_CS9_TIME_STAMP_2        BIT2
 set     CAN_CS9_TIME_STAMP_3        BIT3
 set     CAN_CS9_TIME_STAMP_4        BIT4
 set     CAN_CS9_TIME_STAMP_5        BIT5
 set     CAN_CS9_TIME_STAMP_6        BIT6
 set     CAN_CS9_TIME_STAMP_7        BIT7
 set     CAN_CS9_TIME_STAMP_8        BIT8
 set     CAN_CS9_TIME_STAMP_9        BIT9
 set     CAN_CS9_TIME_STAMP_10       BIT10
 set     CAN_CS9_TIME_STAMP_11       BIT11
 set     CAN_CS9_TIME_STAMP_12       BIT12
 set     CAN_CS9_TIME_STAMP_13       BIT13
 set     CAN_CS9_TIME_STAMP_14       BIT14
 set     CAN_CS9_TIME_STAMP_15       BIT15

 set     CAN_CS9_DLC                 (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS9_DLC_0               BIT16
 set     CAN_CS9_DLC_1               BIT17
 set     CAN_CS9_DLC_2               BIT18
 set     CAN_CS9_DLC_3               BIT19

 set     CAN_CS9_RTR                 BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS9_IDE                 BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS9_SRR                 BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS9_CODE                (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS9_CODE_0              BIT24
 set     CAN_CS9_CODE_1              BIT25
 set     CAN_CS9_CODE_2              BIT26
 set     CAN_CS9_CODE_3              BIT27

 set     CAN_ID9_EXT                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID9_EXT_0               BIT0
 set     CAN_ID9_EXT_1               BIT1
 set     CAN_ID9_EXT_2               BIT2
 set     CAN_ID9_EXT_3               BIT3
 set     CAN_ID9_EXT_4               BIT4
 set     CAN_ID9_EXT_5               BIT5
 set     CAN_ID9_EXT_6               BIT6
 set     CAN_ID9_EXT_7               BIT7
 set     CAN_ID9_EXT_8               BIT8
 set     CAN_ID9_EXT_9               BIT9
 set     CAN_ID9_EXT_10              BIT10
 set     CAN_ID9_EXT_11              BIT11
 set     CAN_ID9_EXT_12              BIT12
 set     CAN_ID9_EXT_13              BIT13
 set     CAN_ID9_EXT_14              BIT14
 set     CAN_ID9_EXT_15              BIT15
 set     CAN_ID9_EXT_16              BIT16
 set     CAN_ID9_EXT_17              BIT17

 set     CAN_ID9_STD                 (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID9_STD_0               BIT18
 set     CAN_ID9_STD_1               BIT19
 set     CAN_ID9_STD_2               BIT20
 set     CAN_ID9_STD_3               BIT21
 set     CAN_ID9_STD_4               BIT22
 set     CAN_ID9_STD_5               BIT23
 set     CAN_ID9_STD_6               BIT24
 set     CAN_ID9_STD_7               BIT25
 set     CAN_ID9_STD_8               BIT26
 set     CAN_ID9_STD_9               BIT27
 set     CAN_ID9_STD_10              BIT28

 set     CAN_ID9_PRIO                (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID9_PRIO_0              BIT29
 set     CAN_ID9_PRIO_1              BIT30
 set     CAN_ID9_PRIO_2              BIT31

 set     CAN_WORD09_DATA_BYTE_3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD09_DATA_BYTE_3_0    BIT0
 set     CAN_WORD09_DATA_BYTE_3_1    BIT1
 set     CAN_WORD09_DATA_BYTE_3_2    BIT2
 set     CAN_WORD09_DATA_BYTE_3_3    BIT3
 set     CAN_WORD09_DATA_BYTE_3_4    BIT4
 set     CAN_WORD09_DATA_BYTE_3_5    BIT5
 set     CAN_WORD09_DATA_BYTE_3_6    BIT6
 set     CAN_WORD09_DATA_BYTE_3_7    BIT7

 set     CAN_WORD09_DATA_BYTE_2      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD09_DATA_BYTE_2_0    BIT8
 set     CAN_WORD09_DATA_BYTE_2_1    BIT9
 set     CAN_WORD09_DATA_BYTE_2_2    BIT10
 set     CAN_WORD09_DATA_BYTE_2_3    BIT11
 set     CAN_WORD09_DATA_BYTE_2_4    BIT12
 set     CAN_WORD09_DATA_BYTE_2_5    BIT13
 set     CAN_WORD09_DATA_BYTE_2_6    BIT14
 set     CAN_WORD09_DATA_BYTE_2_7    BIT15

 set     CAN_WORD09_DATA_BYTE_1      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD09_DATA_BYTE_1_0    BIT16
 set     CAN_WORD09_DATA_BYTE_1_1    BIT17
 set     CAN_WORD09_DATA_BYTE_1_2    BIT18
 set     CAN_WORD09_DATA_BYTE_1_3    BIT19
 set     CAN_WORD09_DATA_BYTE_1_4    BIT20
 set     CAN_WORD09_DATA_BYTE_1_5    BIT21
 set     CAN_WORD09_DATA_BYTE_1_6    BIT22
 set     CAN_WORD09_DATA_BYTE_1_7    BIT23

 set     CAN_WORD09_DATA_BYTE_0      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD09_DATA_BYTE_0_0    BIT24
 set     CAN_WORD09_DATA_BYTE_0_1    BIT25
 set     CAN_WORD09_DATA_BYTE_0_2    BIT26
 set     CAN_WORD09_DATA_BYTE_0_3    BIT27
 set     CAN_WORD09_DATA_BYTE_0_4    BIT28
 set     CAN_WORD09_DATA_BYTE_0_5    BIT29
 set     CAN_WORD09_DATA_BYTE_0_6    BIT30
 set     CAN_WORD09_DATA_BYTE_0_7    BIT31

 set     CAN_WORD19_DATA_BYTE_7      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD19_DATA_BYTE_7_0    BIT0
 set     CAN_WORD19_DATA_BYTE_7_1    BIT1
 set     CAN_WORD19_DATA_BYTE_7_2    BIT2
 set     CAN_WORD19_DATA_BYTE_7_3    BIT3
 set     CAN_WORD19_DATA_BYTE_7_4    BIT4
 set     CAN_WORD19_DATA_BYTE_7_5    BIT5
 set     CAN_WORD19_DATA_BYTE_7_6    BIT6
 set     CAN_WORD19_DATA_BYTE_7_7    BIT7

 set     CAN_WORD19_DATA_BYTE_6      (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD19_DATA_BYTE_6_0    BIT8
 set     CAN_WORD19_DATA_BYTE_6_1    BIT9
 set     CAN_WORD19_DATA_BYTE_6_2    BIT10
 set     CAN_WORD19_DATA_BYTE_6_3    BIT11
 set     CAN_WORD19_DATA_BYTE_6_4    BIT12
 set     CAN_WORD19_DATA_BYTE_6_5    BIT13
 set     CAN_WORD19_DATA_BYTE_6_6    BIT14
 set     CAN_WORD19_DATA_BYTE_6_7    BIT15

 set     CAN_WORD19_DATA_BYTE_5      (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD19_DATA_BYTE_5_0    BIT16
 set     CAN_WORD19_DATA_BYTE_5_1    BIT17
 set     CAN_WORD19_DATA_BYTE_5_2    BIT18
 set     CAN_WORD19_DATA_BYTE_5_3    BIT19
 set     CAN_WORD19_DATA_BYTE_5_4    BIT20
 set     CAN_WORD19_DATA_BYTE_5_5    BIT21
 set     CAN_WORD19_DATA_BYTE_5_6    BIT22
 set     CAN_WORD19_DATA_BYTE_5_7    BIT23

 set     CAN_WORD19_DATA_BYTE_4      (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD19_DATA_BYTE_4_0    BIT24
 set     CAN_WORD19_DATA_BYTE_4_1    BIT25
 set     CAN_WORD19_DATA_BYTE_4_2    BIT26
 set     CAN_WORD19_DATA_BYTE_4_3    BIT27
 set     CAN_WORD19_DATA_BYTE_4_4    BIT28
 set     CAN_WORD19_DATA_BYTE_4_5    BIT29
 set     CAN_WORD19_DATA_BYTE_4_6    BIT30
 set     CAN_WORD19_DATA_BYTE_4_7    BIT31

 set     CAN_CS10_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS10_TIME_STAMP_0       BIT0
 set     CAN_CS10_TIME_STAMP_1       BIT1
 set     CAN_CS10_TIME_STAMP_2       BIT2
 set     CAN_CS10_TIME_STAMP_3       BIT3
 set     CAN_CS10_TIME_STAMP_4       BIT4
 set     CAN_CS10_TIME_STAMP_5       BIT5
 set     CAN_CS10_TIME_STAMP_6       BIT6
 set     CAN_CS10_TIME_STAMP_7       BIT7
 set     CAN_CS10_TIME_STAMP_8       BIT8
 set     CAN_CS10_TIME_STAMP_9       BIT9
 set     CAN_CS10_TIME_STAMP_10      BIT10
 set     CAN_CS10_TIME_STAMP_11      BIT11
 set     CAN_CS10_TIME_STAMP_12      BIT12
 set     CAN_CS10_TIME_STAMP_13      BIT13
 set     CAN_CS10_TIME_STAMP_14      BIT14
 set     CAN_CS10_TIME_STAMP_15      BIT15

 set     CAN_CS10_DLC                (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS10_DLC_0              BIT16
 set     CAN_CS10_DLC_1              BIT17
 set     CAN_CS10_DLC_2              BIT18
 set     CAN_CS10_DLC_3              BIT19

 set     CAN_CS10_RTR                BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS10_IDE                BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS10_SRR                BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS10_CODE               (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS10_CODE_0             BIT24
 set     CAN_CS10_CODE_1             BIT25
 set     CAN_CS10_CODE_2             BIT26
 set     CAN_CS10_CODE_3             BIT27

 set     CAN_ID10_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID10_EXT_0              BIT0
 set     CAN_ID10_EXT_1              BIT1
 set     CAN_ID10_EXT_2              BIT2
 set     CAN_ID10_EXT_3              BIT3
 set     CAN_ID10_EXT_4              BIT4
 set     CAN_ID10_EXT_5              BIT5
 set     CAN_ID10_EXT_6              BIT6
 set     CAN_ID10_EXT_7              BIT7
 set     CAN_ID10_EXT_8              BIT8
 set     CAN_ID10_EXT_9              BIT9
 set     CAN_ID10_EXT_10             BIT10
 set     CAN_ID10_EXT_11             BIT11
 set     CAN_ID10_EXT_12             BIT12
 set     CAN_ID10_EXT_13             BIT13
 set     CAN_ID10_EXT_14             BIT14
 set     CAN_ID10_EXT_15             BIT15
 set     CAN_ID10_EXT_16             BIT16
 set     CAN_ID10_EXT_17             BIT17

 set     CAN_ID10_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID10_STD_0              BIT18
 set     CAN_ID10_STD_1              BIT19
 set     CAN_ID10_STD_2              BIT20
 set     CAN_ID10_STD_3              BIT21
 set     CAN_ID10_STD_4              BIT22
 set     CAN_ID10_STD_5              BIT23
 set     CAN_ID10_STD_6              BIT24
 set     CAN_ID10_STD_7              BIT25
 set     CAN_ID10_STD_8              BIT26
 set     CAN_ID10_STD_9              BIT27
 set     CAN_ID10_STD_10             BIT28

 set     CAN_ID10_PRIO               (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID10_PRIO_0             BIT29
 set     CAN_ID10_PRIO_1             BIT30
 set     CAN_ID10_PRIO_2             BIT31

 set     CAN_WORD010_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD010_DATA_BYTE_3_0   BIT0
 set     CAN_WORD010_DATA_BYTE_3_1   BIT1
 set     CAN_WORD010_DATA_BYTE_3_2   BIT2
 set     CAN_WORD010_DATA_BYTE_3_3   BIT3
 set     CAN_WORD010_DATA_BYTE_3_4   BIT4
 set     CAN_WORD010_DATA_BYTE_3_5   BIT5
 set     CAN_WORD010_DATA_BYTE_3_6   BIT6
 set     CAN_WORD010_DATA_BYTE_3_7   BIT7

 set     CAN_WORD010_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD010_DATA_BYTE_2_0   BIT8
 set     CAN_WORD010_DATA_BYTE_2_1   BIT9
 set     CAN_WORD010_DATA_BYTE_2_2   BIT10
 set     CAN_WORD010_DATA_BYTE_2_3   BIT11
 set     CAN_WORD010_DATA_BYTE_2_4   BIT12
 set     CAN_WORD010_DATA_BYTE_2_5   BIT13
 set     CAN_WORD010_DATA_BYTE_2_6   BIT14
 set     CAN_WORD010_DATA_BYTE_2_7   BIT15

 set     CAN_WORD010_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD010_DATA_BYTE_1_0   BIT16
 set     CAN_WORD010_DATA_BYTE_1_1   BIT17
 set     CAN_WORD010_DATA_BYTE_1_2   BIT18
 set     CAN_WORD010_DATA_BYTE_1_3   BIT19
 set     CAN_WORD010_DATA_BYTE_1_4   BIT20
 set     CAN_WORD010_DATA_BYTE_1_5   BIT21
 set     CAN_WORD010_DATA_BYTE_1_6   BIT22
 set     CAN_WORD010_DATA_BYTE_1_7   BIT23

 set     CAN_WORD010_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD010_DATA_BYTE_0_0   BIT24
 set     CAN_WORD010_DATA_BYTE_0_1   BIT25
 set     CAN_WORD010_DATA_BYTE_0_2   BIT26
 set     CAN_WORD010_DATA_BYTE_0_3   BIT27
 set     CAN_WORD010_DATA_BYTE_0_4   BIT28
 set     CAN_WORD010_DATA_BYTE_0_5   BIT29
 set     CAN_WORD010_DATA_BYTE_0_6   BIT30
 set     CAN_WORD010_DATA_BYTE_0_7   BIT31

 set     CAN_WORD110_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD110_DATA_BYTE_7_0   BIT0
 set     CAN_WORD110_DATA_BYTE_7_1   BIT1
 set     CAN_WORD110_DATA_BYTE_7_2   BIT2
 set     CAN_WORD110_DATA_BYTE_7_3   BIT3
 set     CAN_WORD110_DATA_BYTE_7_4   BIT4
 set     CAN_WORD110_DATA_BYTE_7_5   BIT5
 set     CAN_WORD110_DATA_BYTE_7_6   BIT6
 set     CAN_WORD110_DATA_BYTE_7_7   BIT7

 set     CAN_WORD110_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD110_DATA_BYTE_6_0   BIT8
 set     CAN_WORD110_DATA_BYTE_6_1   BIT9
 set     CAN_WORD110_DATA_BYTE_6_2   BIT10
 set     CAN_WORD110_DATA_BYTE_6_3   BIT11
 set     CAN_WORD110_DATA_BYTE_6_4   BIT12
 set     CAN_WORD110_DATA_BYTE_6_5   BIT13
 set     CAN_WORD110_DATA_BYTE_6_6   BIT14
 set     CAN_WORD110_DATA_BYTE_6_7   BIT15

 set     CAN_WORD110_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD110_DATA_BYTE_5_0   BIT16
 set     CAN_WORD110_DATA_BYTE_5_1   BIT17
 set     CAN_WORD110_DATA_BYTE_5_2   BIT18
 set     CAN_WORD110_DATA_BYTE_5_3   BIT19
 set     CAN_WORD110_DATA_BYTE_5_4   BIT20
 set     CAN_WORD110_DATA_BYTE_5_5   BIT21
 set     CAN_WORD110_DATA_BYTE_5_6   BIT22
 set     CAN_WORD110_DATA_BYTE_5_7   BIT23

 set     CAN_WORD110_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD110_DATA_BYTE_4_0   BIT24
 set     CAN_WORD110_DATA_BYTE_4_1   BIT25
 set     CAN_WORD110_DATA_BYTE_4_2   BIT26
 set     CAN_WORD110_DATA_BYTE_4_3   BIT27
 set     CAN_WORD110_DATA_BYTE_4_4   BIT28
 set     CAN_WORD110_DATA_BYTE_4_5   BIT29
 set     CAN_WORD110_DATA_BYTE_4_6   BIT30
 set     CAN_WORD110_DATA_BYTE_4_7   BIT31

 set     CAN_CS11_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS11_TIME_STAMP_0       BIT0
 set     CAN_CS11_TIME_STAMP_1       BIT1
 set     CAN_CS11_TIME_STAMP_2       BIT2
 set     CAN_CS11_TIME_STAMP_3       BIT3
 set     CAN_CS11_TIME_STAMP_4       BIT4
 set     CAN_CS11_TIME_STAMP_5       BIT5
 set     CAN_CS11_TIME_STAMP_6       BIT6
 set     CAN_CS11_TIME_STAMP_7       BIT7
 set     CAN_CS11_TIME_STAMP_8       BIT8
 set     CAN_CS11_TIME_STAMP_9       BIT9
 set     CAN_CS11_TIME_STAMP_10      BIT10
 set     CAN_CS11_TIME_STAMP_11      BIT11
 set     CAN_CS11_TIME_STAMP_12      BIT12
 set     CAN_CS11_TIME_STAMP_13      BIT13
 set     CAN_CS11_TIME_STAMP_14      BIT14
 set     CAN_CS11_TIME_STAMP_15      BIT15

 set     CAN_CS11_DLC                (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS11_DLC_0              BIT16
 set     CAN_CS11_DLC_1              BIT17
 set     CAN_CS11_DLC_2              BIT18
 set     CAN_CS11_DLC_3              BIT19

 set     CAN_CS11_RTR                BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS11_IDE                BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS11_SRR                BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS11_CODE               (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS11_CODE_0             BIT24
 set     CAN_CS11_CODE_1             BIT25
 set     CAN_CS11_CODE_2             BIT26
 set     CAN_CS11_CODE_3             BIT27

 set     CAN_ID11_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID11_EXT_0              BIT0
 set     CAN_ID11_EXT_1              BIT1
 set     CAN_ID11_EXT_2              BIT2
 set     CAN_ID11_EXT_3              BIT3
 set     CAN_ID11_EXT_4              BIT4
 set     CAN_ID11_EXT_5              BIT5
 set     CAN_ID11_EXT_6              BIT6
 set     CAN_ID11_EXT_7              BIT7
 set     CAN_ID11_EXT_8              BIT8
 set     CAN_ID11_EXT_9              BIT9
 set     CAN_ID11_EXT_10             BIT10
 set     CAN_ID11_EXT_11             BIT11
 set     CAN_ID11_EXT_12             BIT12
 set     CAN_ID11_EXT_13             BIT13
 set     CAN_ID11_EXT_14             BIT14
 set     CAN_ID11_EXT_15             BIT15
 set     CAN_ID11_EXT_16             BIT16
 set     CAN_ID11_EXT_17             BIT17

 set     CAN_ID11_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID11_STD_0              BIT18
 set     CAN_ID11_STD_1              BIT19
 set     CAN_ID11_STD_2              BIT20
 set     CAN_ID11_STD_3              BIT21
 set     CAN_ID11_STD_4              BIT22
 set     CAN_ID11_STD_5              BIT23
 set     CAN_ID11_STD_6              BIT24
 set     CAN_ID11_STD_7              BIT25
 set     CAN_ID11_STD_8              BIT26
 set     CAN_ID11_STD_9              BIT27
 set     CAN_ID11_STD_10             BIT28

 set     CAN_ID11_PRIO               (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID11_PRIO_0             BIT29
 set     CAN_ID11_PRIO_1             BIT30
 set     CAN_ID11_PRIO_2             BIT31

 set     CAN_WORD011_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD011_DATA_BYTE_3_0   BIT0
 set     CAN_WORD011_DATA_BYTE_3_1   BIT1
 set     CAN_WORD011_DATA_BYTE_3_2   BIT2
 set     CAN_WORD011_DATA_BYTE_3_3   BIT3
 set     CAN_WORD011_DATA_BYTE_3_4   BIT4
 set     CAN_WORD011_DATA_BYTE_3_5   BIT5
 set     CAN_WORD011_DATA_BYTE_3_6   BIT6
 set     CAN_WORD011_DATA_BYTE_3_7   BIT7

 set     CAN_WORD011_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD011_DATA_BYTE_2_0   BIT8
 set     CAN_WORD011_DATA_BYTE_2_1   BIT9
 set     CAN_WORD011_DATA_BYTE_2_2   BIT10
 set     CAN_WORD011_DATA_BYTE_2_3   BIT11
 set     CAN_WORD011_DATA_BYTE_2_4   BIT12
 set     CAN_WORD011_DATA_BYTE_2_5   BIT13
 set     CAN_WORD011_DATA_BYTE_2_6   BIT14
 set     CAN_WORD011_DATA_BYTE_2_7   BIT15

 set     CAN_WORD011_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD011_DATA_BYTE_1_0   BIT16
 set     CAN_WORD011_DATA_BYTE_1_1   BIT17
 set     CAN_WORD011_DATA_BYTE_1_2   BIT18
 set     CAN_WORD011_DATA_BYTE_1_3   BIT19
 set     CAN_WORD011_DATA_BYTE_1_4   BIT20
 set     CAN_WORD011_DATA_BYTE_1_5   BIT21
 set     CAN_WORD011_DATA_BYTE_1_6   BIT22
 set     CAN_WORD011_DATA_BYTE_1_7   BIT23

 set     CAN_WORD011_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD011_DATA_BYTE_0_0   BIT24
 set     CAN_WORD011_DATA_BYTE_0_1   BIT25
 set     CAN_WORD011_DATA_BYTE_0_2   BIT26
 set     CAN_WORD011_DATA_BYTE_0_3   BIT27
 set     CAN_WORD011_DATA_BYTE_0_4   BIT28
 set     CAN_WORD011_DATA_BYTE_0_5   BIT29
 set     CAN_WORD011_DATA_BYTE_0_6   BIT30
 set     CAN_WORD011_DATA_BYTE_0_7   BIT31

 set     CAN_WORD111_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD111_DATA_BYTE_7_0   BIT0
 set     CAN_WORD111_DATA_BYTE_7_1   BIT1
 set     CAN_WORD111_DATA_BYTE_7_2   BIT2
 set     CAN_WORD111_DATA_BYTE_7_3   BIT3
 set     CAN_WORD111_DATA_BYTE_7_4   BIT4
 set     CAN_WORD111_DATA_BYTE_7_5   BIT5
 set     CAN_WORD111_DATA_BYTE_7_6   BIT6
 set     CAN_WORD111_DATA_BYTE_7_7   BIT7

 set     CAN_WORD111_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD111_DATA_BYTE_6_0   BIT8
 set     CAN_WORD111_DATA_BYTE_6_1   BIT9
 set     CAN_WORD111_DATA_BYTE_6_2   BIT10
 set     CAN_WORD111_DATA_BYTE_6_3   BIT11
 set     CAN_WORD111_DATA_BYTE_6_4   BIT12
 set     CAN_WORD111_DATA_BYTE_6_5   BIT13
 set     CAN_WORD111_DATA_BYTE_6_6   BIT14
 set     CAN_WORD111_DATA_BYTE_6_7   BIT15

 set     CAN_WORD111_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD111_DATA_BYTE_5_0   BIT16
 set     CAN_WORD111_DATA_BYTE_5_1   BIT17
 set     CAN_WORD111_DATA_BYTE_5_2   BIT18
 set     CAN_WORD111_DATA_BYTE_5_3   BIT19
 set     CAN_WORD111_DATA_BYTE_5_4   BIT20
 set     CAN_WORD111_DATA_BYTE_5_5   BIT21
 set     CAN_WORD111_DATA_BYTE_5_6   BIT22
 set     CAN_WORD111_DATA_BYTE_5_7   BIT23

 set     CAN_WORD111_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD111_DATA_BYTE_4_0   BIT24
 set     CAN_WORD111_DATA_BYTE_4_1   BIT25
 set     CAN_WORD111_DATA_BYTE_4_2   BIT26
 set     CAN_WORD111_DATA_BYTE_4_3   BIT27
 set     CAN_WORD111_DATA_BYTE_4_4   BIT28
 set     CAN_WORD111_DATA_BYTE_4_5   BIT29
 set     CAN_WORD111_DATA_BYTE_4_6   BIT30
 set     CAN_WORD111_DATA_BYTE_4_7   BIT31

 set     CAN_CS12_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS12_TIME_STAMP_0       BIT0
 set     CAN_CS12_TIME_STAMP_1       BIT1
 set     CAN_CS12_TIME_STAMP_2       BIT2
 set     CAN_CS12_TIME_STAMP_3       BIT3
 set     CAN_CS12_TIME_STAMP_4       BIT4
 set     CAN_CS12_TIME_STAMP_5       BIT5
 set     CAN_CS12_TIME_STAMP_6       BIT6
 set     CAN_CS12_TIME_STAMP_7       BIT7
 set     CAN_CS12_TIME_STAMP_8       BIT8
 set     CAN_CS12_TIME_STAMP_9       BIT9
 set     CAN_CS12_TIME_STAMP_10      BIT10
 set     CAN_CS12_TIME_STAMP_11      BIT11
 set     CAN_CS12_TIME_STAMP_12      BIT12
 set     CAN_CS12_TIME_STAMP_13      BIT13
 set     CAN_CS12_TIME_STAMP_14      BIT14
 set     CAN_CS12_TIME_STAMP_15      BIT15

 set     CAN_CS12_DLC                (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS12_DLC_0              BIT16
 set     CAN_CS12_DLC_1              BIT17
 set     CAN_CS12_DLC_2              BIT18
 set     CAN_CS12_DLC_3              BIT19

 set     CAN_CS12_RTR                BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS12_IDE                BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS12_SRR                BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS12_CODE               (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS12_CODE_0             BIT24
 set     CAN_CS12_CODE_1             BIT25
 set     CAN_CS12_CODE_2             BIT26
 set     CAN_CS12_CODE_3             BIT27

 set     CAN_ID12_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID12_EXT_0              BIT0
 set     CAN_ID12_EXT_1              BIT1
 set     CAN_ID12_EXT_2              BIT2
 set     CAN_ID12_EXT_3              BIT3
 set     CAN_ID12_EXT_4              BIT4
 set     CAN_ID12_EXT_5              BIT5
 set     CAN_ID12_EXT_6              BIT6
 set     CAN_ID12_EXT_7              BIT7
 set     CAN_ID12_EXT_8              BIT8
 set     CAN_ID12_EXT_9              BIT9
 set     CAN_ID12_EXT_10             BIT10
 set     CAN_ID12_EXT_11             BIT11
 set     CAN_ID12_EXT_12             BIT12
 set     CAN_ID12_EXT_13             BIT13
 set     CAN_ID12_EXT_14             BIT14
 set     CAN_ID12_EXT_15             BIT15
 set     CAN_ID12_EXT_16             BIT16
 set     CAN_ID12_EXT_17             BIT17

 set     CAN_ID12_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID12_STD_0              BIT18
 set     CAN_ID12_STD_1              BIT19
 set     CAN_ID12_STD_2              BIT20
 set     CAN_ID12_STD_3              BIT21
 set     CAN_ID12_STD_4              BIT22
 set     CAN_ID12_STD_5              BIT23
 set     CAN_ID12_STD_6              BIT24
 set     CAN_ID12_STD_7              BIT25
 set     CAN_ID12_STD_8              BIT26
 set     CAN_ID12_STD_9              BIT27
 set     CAN_ID12_STD_10             BIT28

 set     CAN_ID12_PRIO               (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID12_PRIO_0             BIT29
 set     CAN_ID12_PRIO_1             BIT30
 set     CAN_ID12_PRIO_2             BIT31

 set     CAN_WORD012_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD012_DATA_BYTE_3_0   BIT0
 set     CAN_WORD012_DATA_BYTE_3_1   BIT1
 set     CAN_WORD012_DATA_BYTE_3_2   BIT2
 set     CAN_WORD012_DATA_BYTE_3_3   BIT3
 set     CAN_WORD012_DATA_BYTE_3_4   BIT4
 set     CAN_WORD012_DATA_BYTE_3_5   BIT5
 set     CAN_WORD012_DATA_BYTE_3_6   BIT6
 set     CAN_WORD012_DATA_BYTE_3_7   BIT7

 set     CAN_WORD012_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD012_DATA_BYTE_2_0   BIT8
 set     CAN_WORD012_DATA_BYTE_2_1   BIT9
 set     CAN_WORD012_DATA_BYTE_2_2   BIT10
 set     CAN_WORD012_DATA_BYTE_2_3   BIT11
 set     CAN_WORD012_DATA_BYTE_2_4   BIT12
 set     CAN_WORD012_DATA_BYTE_2_5   BIT13
 set     CAN_WORD012_DATA_BYTE_2_6   BIT14
 set     CAN_WORD012_DATA_BYTE_2_7   BIT15

 set     CAN_WORD012_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD012_DATA_BYTE_1_0   BIT16
 set     CAN_WORD012_DATA_BYTE_1_1   BIT17
 set     CAN_WORD012_DATA_BYTE_1_2   BIT18
 set     CAN_WORD012_DATA_BYTE_1_3   BIT19
 set     CAN_WORD012_DATA_BYTE_1_4   BIT20
 set     CAN_WORD012_DATA_BYTE_1_5   BIT21
 set     CAN_WORD012_DATA_BYTE_1_6   BIT22
 set     CAN_WORD012_DATA_BYTE_1_7   BIT23

 set     CAN_WORD012_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD012_DATA_BYTE_0_0   BIT24
 set     CAN_WORD012_DATA_BYTE_0_1   BIT25
 set     CAN_WORD012_DATA_BYTE_0_2   BIT26
 set     CAN_WORD012_DATA_BYTE_0_3   BIT27
 set     CAN_WORD012_DATA_BYTE_0_4   BIT28
 set     CAN_WORD012_DATA_BYTE_0_5   BIT29
 set     CAN_WORD012_DATA_BYTE_0_6   BIT30
 set     CAN_WORD012_DATA_BYTE_0_7   BIT31

 set     CAN_WORD112_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD112_DATA_BYTE_7_0   BIT0
 set     CAN_WORD112_DATA_BYTE_7_1   BIT1
 set     CAN_WORD112_DATA_BYTE_7_2   BIT2
 set     CAN_WORD112_DATA_BYTE_7_3   BIT3
 set     CAN_WORD112_DATA_BYTE_7_4   BIT4
 set     CAN_WORD112_DATA_BYTE_7_5   BIT5
 set     CAN_WORD112_DATA_BYTE_7_6   BIT6
 set     CAN_WORD112_DATA_BYTE_7_7   BIT7

 set     CAN_WORD112_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD112_DATA_BYTE_6_0   BIT8
 set     CAN_WORD112_DATA_BYTE_6_1   BIT9
 set     CAN_WORD112_DATA_BYTE_6_2   BIT10
 set     CAN_WORD112_DATA_BYTE_6_3   BIT11
 set     CAN_WORD112_DATA_BYTE_6_4   BIT12
 set     CAN_WORD112_DATA_BYTE_6_5   BIT13
 set     CAN_WORD112_DATA_BYTE_6_6   BIT14
 set     CAN_WORD112_DATA_BYTE_6_7   BIT15

 set     CAN_WORD112_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD112_DATA_BYTE_5_0   BIT16
 set     CAN_WORD112_DATA_BYTE_5_1   BIT17
 set     CAN_WORD112_DATA_BYTE_5_2   BIT18
 set     CAN_WORD112_DATA_BYTE_5_3   BIT19
 set     CAN_WORD112_DATA_BYTE_5_4   BIT20
 set     CAN_WORD112_DATA_BYTE_5_5   BIT21
 set     CAN_WORD112_DATA_BYTE_5_6   BIT22
 set     CAN_WORD112_DATA_BYTE_5_7   BIT23

 set     CAN_WORD112_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD112_DATA_BYTE_4_0   BIT24
 set     CAN_WORD112_DATA_BYTE_4_1   BIT25
 set     CAN_WORD112_DATA_BYTE_4_2   BIT26
 set     CAN_WORD112_DATA_BYTE_4_3   BIT27
 set     CAN_WORD112_DATA_BYTE_4_4   BIT28
 set     CAN_WORD112_DATA_BYTE_4_5   BIT29
 set     CAN_WORD112_DATA_BYTE_4_6   BIT30
 set     CAN_WORD112_DATA_BYTE_4_7   BIT31

 set     CAN_CS13_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS13_TIME_STAMP_0       BIT0
 set     CAN_CS13_TIME_STAMP_1       BIT1
 set     CAN_CS13_TIME_STAMP_2       BIT2
 set     CAN_CS13_TIME_STAMP_3       BIT3
 set     CAN_CS13_TIME_STAMP_4       BIT4
 set     CAN_CS13_TIME_STAMP_5       BIT5
 set     CAN_CS13_TIME_STAMP_6       BIT6
 set     CAN_CS13_TIME_STAMP_7       BIT7
 set     CAN_CS13_TIME_STAMP_8       BIT8
 set     CAN_CS13_TIME_STAMP_9       BIT9
 set     CAN_CS13_TIME_STAMP_10      BIT10
 set     CAN_CS13_TIME_STAMP_11      BIT11
 set     CAN_CS13_TIME_STAMP_12      BIT12
 set     CAN_CS13_TIME_STAMP_13      BIT13
 set     CAN_CS13_TIME_STAMP_14      BIT14
 set     CAN_CS13_TIME_STAMP_15      BIT15

 set     CAN_CS13_DLC                (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS13_DLC_0              BIT16
 set     CAN_CS13_DLC_1              BIT17
 set     CAN_CS13_DLC_2              BIT18
 set     CAN_CS13_DLC_3              BIT19

 set     CAN_CS13_RTR                BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS13_IDE                BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS13_SRR                BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS13_CODE               (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS13_CODE_0             BIT24
 set     CAN_CS13_CODE_1             BIT25
 set     CAN_CS13_CODE_2             BIT26
 set     CAN_CS13_CODE_3             BIT27

 set     CAN_ID13_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID13_EXT_0              BIT0
 set     CAN_ID13_EXT_1              BIT1
 set     CAN_ID13_EXT_2              BIT2
 set     CAN_ID13_EXT_3              BIT3
 set     CAN_ID13_EXT_4              BIT4
 set     CAN_ID13_EXT_5              BIT5
 set     CAN_ID13_EXT_6              BIT6
 set     CAN_ID13_EXT_7              BIT7
 set     CAN_ID13_EXT_8              BIT8
 set     CAN_ID13_EXT_9              BIT9
 set     CAN_ID13_EXT_10             BIT10
 set     CAN_ID13_EXT_11             BIT11
 set     CAN_ID13_EXT_12             BIT12
 set     CAN_ID13_EXT_13             BIT13
 set     CAN_ID13_EXT_14             BIT14
 set     CAN_ID13_EXT_15             BIT15
 set     CAN_ID13_EXT_16             BIT16
 set     CAN_ID13_EXT_17             BIT17

 set     CAN_ID13_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID13_STD_0              BIT18
 set     CAN_ID13_STD_1              BIT19
 set     CAN_ID13_STD_2              BIT20
 set     CAN_ID13_STD_3              BIT21
 set     CAN_ID13_STD_4              BIT22
 set     CAN_ID13_STD_5              BIT23
 set     CAN_ID13_STD_6              BIT24
 set     CAN_ID13_STD_7              BIT25
 set     CAN_ID13_STD_8              BIT26
 set     CAN_ID13_STD_9              BIT27
 set     CAN_ID13_STD_10             BIT28

 set     CAN_ID13_PRIO               (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID13_PRIO_0             BIT29
 set     CAN_ID13_PRIO_1             BIT30
 set     CAN_ID13_PRIO_2             BIT31

 set     CAN_WORD013_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD013_DATA_BYTE_3_0   BIT0
 set     CAN_WORD013_DATA_BYTE_3_1   BIT1
 set     CAN_WORD013_DATA_BYTE_3_2   BIT2
 set     CAN_WORD013_DATA_BYTE_3_3   BIT3
 set     CAN_WORD013_DATA_BYTE_3_4   BIT4
 set     CAN_WORD013_DATA_BYTE_3_5   BIT5
 set     CAN_WORD013_DATA_BYTE_3_6   BIT6
 set     CAN_WORD013_DATA_BYTE_3_7   BIT7

 set     CAN_WORD013_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD013_DATA_BYTE_2_0   BIT8
 set     CAN_WORD013_DATA_BYTE_2_1   BIT9
 set     CAN_WORD013_DATA_BYTE_2_2   BIT10
 set     CAN_WORD013_DATA_BYTE_2_3   BIT11
 set     CAN_WORD013_DATA_BYTE_2_4   BIT12
 set     CAN_WORD013_DATA_BYTE_2_5   BIT13
 set     CAN_WORD013_DATA_BYTE_2_6   BIT14
 set     CAN_WORD013_DATA_BYTE_2_7   BIT15

 set     CAN_WORD013_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD013_DATA_BYTE_1_0   BIT16
 set     CAN_WORD013_DATA_BYTE_1_1   BIT17
 set     CAN_WORD013_DATA_BYTE_1_2   BIT18
 set     CAN_WORD013_DATA_BYTE_1_3   BIT19
 set     CAN_WORD013_DATA_BYTE_1_4   BIT20
 set     CAN_WORD013_DATA_BYTE_1_5   BIT21
 set     CAN_WORD013_DATA_BYTE_1_6   BIT22
 set     CAN_WORD013_DATA_BYTE_1_7   BIT23

 set     CAN_WORD013_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD013_DATA_BYTE_0_0   BIT24
 set     CAN_WORD013_DATA_BYTE_0_1   BIT25
 set     CAN_WORD013_DATA_BYTE_0_2   BIT26
 set     CAN_WORD013_DATA_BYTE_0_3   BIT27
 set     CAN_WORD013_DATA_BYTE_0_4   BIT28
 set     CAN_WORD013_DATA_BYTE_0_5   BIT29
 set     CAN_WORD013_DATA_BYTE_0_6   BIT30
 set     CAN_WORD013_DATA_BYTE_0_7   BIT31

 set     CAN_WORD113_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD113_DATA_BYTE_7_0   BIT0
 set     CAN_WORD113_DATA_BYTE_7_1   BIT1
 set     CAN_WORD113_DATA_BYTE_7_2   BIT2
 set     CAN_WORD113_DATA_BYTE_7_3   BIT3
 set     CAN_WORD113_DATA_BYTE_7_4   BIT4
 set     CAN_WORD113_DATA_BYTE_7_5   BIT5
 set     CAN_WORD113_DATA_BYTE_7_6   BIT6
 set     CAN_WORD113_DATA_BYTE_7_7   BIT7

 set     CAN_WORD113_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD113_DATA_BYTE_6_0   BIT8
 set     CAN_WORD113_DATA_BYTE_6_1   BIT9
 set     CAN_WORD113_DATA_BYTE_6_2   BIT10
 set     CAN_WORD113_DATA_BYTE_6_3   BIT11
 set     CAN_WORD113_DATA_BYTE_6_4   BIT12
 set     CAN_WORD113_DATA_BYTE_6_5   BIT13
 set     CAN_WORD113_DATA_BYTE_6_6   BIT14
 set     CAN_WORD113_DATA_BYTE_6_7   BIT15

 set     CAN_WORD113_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD113_DATA_BYTE_5_0   BIT16
 set     CAN_WORD113_DATA_BYTE_5_1   BIT17
 set     CAN_WORD113_DATA_BYTE_5_2   BIT18
 set     CAN_WORD113_DATA_BYTE_5_3   BIT19
 set     CAN_WORD113_DATA_BYTE_5_4   BIT20
 set     CAN_WORD113_DATA_BYTE_5_5   BIT21
 set     CAN_WORD113_DATA_BYTE_5_6   BIT22
 set     CAN_WORD113_DATA_BYTE_5_7   BIT23

 set     CAN_WORD113_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD113_DATA_BYTE_4_0   BIT24
 set     CAN_WORD113_DATA_BYTE_4_1   BIT25
 set     CAN_WORD113_DATA_BYTE_4_2   BIT26
 set     CAN_WORD113_DATA_BYTE_4_3   BIT27
 set     CAN_WORD113_DATA_BYTE_4_4   BIT28
 set     CAN_WORD113_DATA_BYTE_4_5   BIT29
 set     CAN_WORD113_DATA_BYTE_4_6   BIT30
 set     CAN_WORD113_DATA_BYTE_4_7   BIT31

 set     CAN_CS14_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS14_TIME_STAMP_0       BIT0
 set     CAN_CS14_TIME_STAMP_1       BIT1
 set     CAN_CS14_TIME_STAMP_2       BIT2
 set     CAN_CS14_TIME_STAMP_3       BIT3
 set     CAN_CS14_TIME_STAMP_4       BIT4
 set     CAN_CS14_TIME_STAMP_5       BIT5
 set     CAN_CS14_TIME_STAMP_6       BIT6
 set     CAN_CS14_TIME_STAMP_7       BIT7
 set     CAN_CS14_TIME_STAMP_8       BIT8
 set     CAN_CS14_TIME_STAMP_9       BIT9
 set     CAN_CS14_TIME_STAMP_10      BIT10
 set     CAN_CS14_TIME_STAMP_11      BIT11
 set     CAN_CS14_TIME_STAMP_12      BIT12
 set     CAN_CS14_TIME_STAMP_13      BIT13
 set     CAN_CS14_TIME_STAMP_14      BIT14
 set     CAN_CS14_TIME_STAMP_15      BIT15

 set     CAN_CS14_DLC                (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS14_DLC_0              BIT16
 set     CAN_CS14_DLC_1              BIT17
 set     CAN_CS14_DLC_2              BIT18
 set     CAN_CS14_DLC_3              BIT19

 set     CAN_CS14_RTR                BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS14_IDE                BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS14_SRR                BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS14_CODE               (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS14_CODE_0             BIT24
 set     CAN_CS14_CODE_1             BIT25
 set     CAN_CS14_CODE_2             BIT26
 set     CAN_CS14_CODE_3             BIT27

 set     CAN_ID14_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID14_EXT_0              BIT0
 set     CAN_ID14_EXT_1              BIT1
 set     CAN_ID14_EXT_2              BIT2
 set     CAN_ID14_EXT_3              BIT3
 set     CAN_ID14_EXT_4              BIT4
 set     CAN_ID14_EXT_5              BIT5
 set     CAN_ID14_EXT_6              BIT6
 set     CAN_ID14_EXT_7              BIT7
 set     CAN_ID14_EXT_8              BIT8
 set     CAN_ID14_EXT_9              BIT9
 set     CAN_ID14_EXT_10             BIT10
 set     CAN_ID14_EXT_11             BIT11
 set     CAN_ID14_EXT_12             BIT12
 set     CAN_ID14_EXT_13             BIT13
 set     CAN_ID14_EXT_14             BIT14
 set     CAN_ID14_EXT_15             BIT15
 set     CAN_ID14_EXT_16             BIT16
 set     CAN_ID14_EXT_17             BIT17

 set     CAN_ID14_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID14_STD_0              BIT18
 set     CAN_ID14_STD_1              BIT19
 set     CAN_ID14_STD_2              BIT20
 set     CAN_ID14_STD_3              BIT21
 set     CAN_ID14_STD_4              BIT22
 set     CAN_ID14_STD_5              BIT23
 set     CAN_ID14_STD_6              BIT24
 set     CAN_ID14_STD_7              BIT25
 set     CAN_ID14_STD_8              BIT26
 set     CAN_ID14_STD_9              BIT27
 set     CAN_ID14_STD_10             BIT28

 set     CAN_ID14_PRIO               (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID14_PRIO_0             BIT29
 set     CAN_ID14_PRIO_1             BIT30
 set     CAN_ID14_PRIO_2             BIT31

 set     CAN_WORD014_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD014_DATA_BYTE_3_0   BIT0
 set     CAN_WORD014_DATA_BYTE_3_1   BIT1
 set     CAN_WORD014_DATA_BYTE_3_2   BIT2
 set     CAN_WORD014_DATA_BYTE_3_3   BIT3
 set     CAN_WORD014_DATA_BYTE_3_4   BIT4
 set     CAN_WORD014_DATA_BYTE_3_5   BIT5
 set     CAN_WORD014_DATA_BYTE_3_6   BIT6
 set     CAN_WORD014_DATA_BYTE_3_7   BIT7

 set     CAN_WORD014_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD014_DATA_BYTE_2_0   BIT8
 set     CAN_WORD014_DATA_BYTE_2_1   BIT9
 set     CAN_WORD014_DATA_BYTE_2_2   BIT10
 set     CAN_WORD014_DATA_BYTE_2_3   BIT11
 set     CAN_WORD014_DATA_BYTE_2_4   BIT12
 set     CAN_WORD014_DATA_BYTE_2_5   BIT13
 set     CAN_WORD014_DATA_BYTE_2_6   BIT14
 set     CAN_WORD014_DATA_BYTE_2_7   BIT15

 set     CAN_WORD014_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD014_DATA_BYTE_1_0   BIT16
 set     CAN_WORD014_DATA_BYTE_1_1   BIT17
 set     CAN_WORD014_DATA_BYTE_1_2   BIT18
 set     CAN_WORD014_DATA_BYTE_1_3   BIT19
 set     CAN_WORD014_DATA_BYTE_1_4   BIT20
 set     CAN_WORD014_DATA_BYTE_1_5   BIT21
 set     CAN_WORD014_DATA_BYTE_1_6   BIT22
 set     CAN_WORD014_DATA_BYTE_1_7   BIT23

 set     CAN_WORD014_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD014_DATA_BYTE_0_0   BIT24
 set     CAN_WORD014_DATA_BYTE_0_1   BIT25
 set     CAN_WORD014_DATA_BYTE_0_2   BIT26
 set     CAN_WORD014_DATA_BYTE_0_3   BIT27
 set     CAN_WORD014_DATA_BYTE_0_4   BIT28
 set     CAN_WORD014_DATA_BYTE_0_5   BIT29
 set     CAN_WORD014_DATA_BYTE_0_6   BIT30
 set     CAN_WORD014_DATA_BYTE_0_7   BIT31

 set     CAN_WORD114_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD114_DATA_BYTE_7_0   BIT0
 set     CAN_WORD114_DATA_BYTE_7_1   BIT1
 set     CAN_WORD114_DATA_BYTE_7_2   BIT2
 set     CAN_WORD114_DATA_BYTE_7_3   BIT3
 set     CAN_WORD114_DATA_BYTE_7_4   BIT4
 set     CAN_WORD114_DATA_BYTE_7_5   BIT5
 set     CAN_WORD114_DATA_BYTE_7_6   BIT6
 set     CAN_WORD114_DATA_BYTE_7_7   BIT7

 set     CAN_WORD114_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD114_DATA_BYTE_6_0   BIT8
 set     CAN_WORD114_DATA_BYTE_6_1   BIT9
 set     CAN_WORD114_DATA_BYTE_6_2   BIT10
 set     CAN_WORD114_DATA_BYTE_6_3   BIT11
 set     CAN_WORD114_DATA_BYTE_6_4   BIT12
 set     CAN_WORD114_DATA_BYTE_6_5   BIT13
 set     CAN_WORD114_DATA_BYTE_6_6   BIT14
 set     CAN_WORD114_DATA_BYTE_6_7   BIT15

 set     CAN_WORD114_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD114_DATA_BYTE_5_0   BIT16
 set     CAN_WORD114_DATA_BYTE_5_1   BIT17
 set     CAN_WORD114_DATA_BYTE_5_2   BIT18
 set     CAN_WORD114_DATA_BYTE_5_3   BIT19
 set     CAN_WORD114_DATA_BYTE_5_4   BIT20
 set     CAN_WORD114_DATA_BYTE_5_5   BIT21
 set     CAN_WORD114_DATA_BYTE_5_6   BIT22
 set     CAN_WORD114_DATA_BYTE_5_7   BIT23

 set     CAN_WORD114_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD114_DATA_BYTE_4_0   BIT24
 set     CAN_WORD114_DATA_BYTE_4_1   BIT25
 set     CAN_WORD114_DATA_BYTE_4_2   BIT26
 set     CAN_WORD114_DATA_BYTE_4_3   BIT27
 set     CAN_WORD114_DATA_BYTE_4_4   BIT28
 set     CAN_WORD114_DATA_BYTE_4_5   BIT29
 set     CAN_WORD114_DATA_BYTE_4_6   BIT30
 set     CAN_WORD114_DATA_BYTE_4_7   BIT31

 set     CAN_CS15_TIME_STAMP         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field appears on the CAN bus.
 set     CAN_CS15_TIME_STAMP_0       BIT0
 set     CAN_CS15_TIME_STAMP_1       BIT1
 set     CAN_CS15_TIME_STAMP_2       BIT2
 set     CAN_CS15_TIME_STAMP_3       BIT3
 set     CAN_CS15_TIME_STAMP_4       BIT4
 set     CAN_CS15_TIME_STAMP_5       BIT5
 set     CAN_CS15_TIME_STAMP_6       BIT6
 set     CAN_CS15_TIME_STAMP_7       BIT7
 set     CAN_CS15_TIME_STAMP_8       BIT8
 set     CAN_CS15_TIME_STAMP_9       BIT9
 set     CAN_CS15_TIME_STAMP_10      BIT10
 set     CAN_CS15_TIME_STAMP_11      BIT11
 set     CAN_CS15_TIME_STAMP_12      BIT12
 set     CAN_CS15_TIME_STAMP_13      BIT13
 set     CAN_CS15_TIME_STAMP_14      BIT14
 set     CAN_CS15_TIME_STAMP_15      BIT15

 set     CAN_CS15_DLC                (BIT16|BIT17|BIT18|BIT19)
;;   Length of the data to be stored/transmitted.
 set     CAN_CS15_DLC_0              BIT16
 set     CAN_CS15_DLC_1              BIT17
 set     CAN_CS15_DLC_2              BIT18
 set     CAN_CS15_DLC_3              BIT19

 set     CAN_CS15_RTR                BIT20
;;   Remote Transmission Request. One/zero for remote/data frame.

 set     CAN_CS15_IDE                BIT21
;;   ID Extended. One/zero for extended/standard format frame.

 set     CAN_CS15_SRR                BIT22
;;   Substitute Remote Request. Contains a fixed recessive bit.

 set     CAN_CS15_CODE               (BIT24|BIT25|BIT26|BIT27)
;;   Reserved
 set     CAN_CS15_CODE_0             BIT24
 set     CAN_CS15_CODE_1             BIT25
 set     CAN_CS15_CODE_2             BIT26
 set     CAN_CS15_CODE_3             BIT27

 set     CAN_ID15_EXT                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Contains extended (LOW word) identifier of message buffer.
 set     CAN_ID15_EXT_0              BIT0
 set     CAN_ID15_EXT_1              BIT1
 set     CAN_ID15_EXT_2              BIT2
 set     CAN_ID15_EXT_3              BIT3
 set     CAN_ID15_EXT_4              BIT4
 set     CAN_ID15_EXT_5              BIT5
 set     CAN_ID15_EXT_6              BIT6
 set     CAN_ID15_EXT_7              BIT7
 set     CAN_ID15_EXT_8              BIT8
 set     CAN_ID15_EXT_9              BIT9
 set     CAN_ID15_EXT_10             BIT10
 set     CAN_ID15_EXT_11             BIT11
 set     CAN_ID15_EXT_12             BIT12
 set     CAN_ID15_EXT_13             BIT13
 set     CAN_ID15_EXT_14             BIT14
 set     CAN_ID15_EXT_15             BIT15
 set     CAN_ID15_EXT_16             BIT16
 set     CAN_ID15_EXT_17             BIT17

 set     CAN_ID15_STD                (BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28)
;;   Contains standard/extended (HIGH word) identifier of message buffer.
 set     CAN_ID15_STD_0              BIT18
 set     CAN_ID15_STD_1              BIT19
 set     CAN_ID15_STD_2              BIT20
 set     CAN_ID15_STD_3              BIT21
 set     CAN_ID15_STD_4              BIT22
 set     CAN_ID15_STD_5              BIT23
 set     CAN_ID15_STD_6              BIT24
 set     CAN_ID15_STD_7              BIT25
 set     CAN_ID15_STD_8              BIT26
 set     CAN_ID15_STD_9              BIT27
 set     CAN_ID15_STD_10             BIT28

 set     CAN_ID15_PRIO               (BIT29|BIT30|BIT31)
;;   Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular ID to define the transmission priority.
 set     CAN_ID15_PRIO_0             BIT29
 set     CAN_ID15_PRIO_1             BIT30
 set     CAN_ID15_PRIO_2             BIT31

 set     CAN_WORD015_DATA_BYTE_3     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 3 of Rx/Tx frame.
 set     CAN_WORD015_DATA_BYTE_3_0   BIT0
 set     CAN_WORD015_DATA_BYTE_3_1   BIT1
 set     CAN_WORD015_DATA_BYTE_3_2   BIT2
 set     CAN_WORD015_DATA_BYTE_3_3   BIT3
 set     CAN_WORD015_DATA_BYTE_3_4   BIT4
 set     CAN_WORD015_DATA_BYTE_3_5   BIT5
 set     CAN_WORD015_DATA_BYTE_3_6   BIT6
 set     CAN_WORD015_DATA_BYTE_3_7   BIT7

 set     CAN_WORD015_DATA_BYTE_2     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 2 of Rx/Tx frame.
 set     CAN_WORD015_DATA_BYTE_2_0   BIT8
 set     CAN_WORD015_DATA_BYTE_2_1   BIT9
 set     CAN_WORD015_DATA_BYTE_2_2   BIT10
 set     CAN_WORD015_DATA_BYTE_2_3   BIT11
 set     CAN_WORD015_DATA_BYTE_2_4   BIT12
 set     CAN_WORD015_DATA_BYTE_2_5   BIT13
 set     CAN_WORD015_DATA_BYTE_2_6   BIT14
 set     CAN_WORD015_DATA_BYTE_2_7   BIT15

 set     CAN_WORD015_DATA_BYTE_1     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 1 of Rx/Tx frame.
 set     CAN_WORD015_DATA_BYTE_1_0   BIT16
 set     CAN_WORD015_DATA_BYTE_1_1   BIT17
 set     CAN_WORD015_DATA_BYTE_1_2   BIT18
 set     CAN_WORD015_DATA_BYTE_1_3   BIT19
 set     CAN_WORD015_DATA_BYTE_1_4   BIT20
 set     CAN_WORD015_DATA_BYTE_1_5   BIT21
 set     CAN_WORD015_DATA_BYTE_1_6   BIT22
 set     CAN_WORD015_DATA_BYTE_1_7   BIT23

 set     CAN_WORD015_DATA_BYTE_0     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 0 of Rx/Tx frame.
 set     CAN_WORD015_DATA_BYTE_0_0   BIT24
 set     CAN_WORD015_DATA_BYTE_0_1   BIT25
 set     CAN_WORD015_DATA_BYTE_0_2   BIT26
 set     CAN_WORD015_DATA_BYTE_0_3   BIT27
 set     CAN_WORD015_DATA_BYTE_0_4   BIT28
 set     CAN_WORD015_DATA_BYTE_0_5   BIT29
 set     CAN_WORD015_DATA_BYTE_0_6   BIT30
 set     CAN_WORD015_DATA_BYTE_0_7   BIT31

 set     CAN_WORD115_DATA_BYTE_7     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data byte 7 of Rx/Tx frame.
 set     CAN_WORD115_DATA_BYTE_7_0   BIT0
 set     CAN_WORD115_DATA_BYTE_7_1   BIT1
 set     CAN_WORD115_DATA_BYTE_7_2   BIT2
 set     CAN_WORD115_DATA_BYTE_7_3   BIT3
 set     CAN_WORD115_DATA_BYTE_7_4   BIT4
 set     CAN_WORD115_DATA_BYTE_7_5   BIT5
 set     CAN_WORD115_DATA_BYTE_7_6   BIT6
 set     CAN_WORD115_DATA_BYTE_7_7   BIT7

 set     CAN_WORD115_DATA_BYTE_6     (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data byte 6 of Rx/Tx frame.
 set     CAN_WORD115_DATA_BYTE_6_0   BIT8
 set     CAN_WORD115_DATA_BYTE_6_1   BIT9
 set     CAN_WORD115_DATA_BYTE_6_2   BIT10
 set     CAN_WORD115_DATA_BYTE_6_3   BIT11
 set     CAN_WORD115_DATA_BYTE_6_4   BIT12
 set     CAN_WORD115_DATA_BYTE_6_5   BIT13
 set     CAN_WORD115_DATA_BYTE_6_6   BIT14
 set     CAN_WORD115_DATA_BYTE_6_7   BIT15

 set     CAN_WORD115_DATA_BYTE_5     (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Data byte 5 of Rx/Tx frame.
 set     CAN_WORD115_DATA_BYTE_5_0   BIT16
 set     CAN_WORD115_DATA_BYTE_5_1   BIT17
 set     CAN_WORD115_DATA_BYTE_5_2   BIT18
 set     CAN_WORD115_DATA_BYTE_5_3   BIT19
 set     CAN_WORD115_DATA_BYTE_5_4   BIT20
 set     CAN_WORD115_DATA_BYTE_5_5   BIT21
 set     CAN_WORD115_DATA_BYTE_5_6   BIT22
 set     CAN_WORD115_DATA_BYTE_5_7   BIT23

 set     CAN_WORD115_DATA_BYTE_4     (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Data byte 4 of Rx/Tx frame.
 set     CAN_WORD115_DATA_BYTE_4_0   BIT24
 set     CAN_WORD115_DATA_BYTE_4_1   BIT25
 set     CAN_WORD115_DATA_BYTE_4_2   BIT26
 set     CAN_WORD115_DATA_BYTE_4_3   BIT27
 set     CAN_WORD115_DATA_BYTE_4_4   BIT28
 set     CAN_WORD115_DATA_BYTE_4_5   BIT29
 set     CAN_WORD115_DATA_BYTE_4_6   BIT30
 set     CAN_WORD115_DATA_BYTE_4_7   BIT31

 set     CAN_RXIMR0_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR0_MI_0             BIT0
 set     CAN_RXIMR0_MI_1             BIT1
 set     CAN_RXIMR0_MI_2             BIT2
 set     CAN_RXIMR0_MI_3             BIT3
 set     CAN_RXIMR0_MI_4             BIT4
 set     CAN_RXIMR0_MI_5             BIT5
 set     CAN_RXIMR0_MI_6             BIT6
 set     CAN_RXIMR0_MI_7             BIT7
 set     CAN_RXIMR0_MI_8             BIT8
 set     CAN_RXIMR0_MI_9             BIT9
 set     CAN_RXIMR0_MI_10            BIT10
 set     CAN_RXIMR0_MI_11            BIT11
 set     CAN_RXIMR0_MI_12            BIT12
 set     CAN_RXIMR0_MI_13            BIT13
 set     CAN_RXIMR0_MI_14            BIT14
 set     CAN_RXIMR0_MI_15            BIT15
 set     CAN_RXIMR0_MI_16            BIT16
 set     CAN_RXIMR0_MI_17            BIT17
 set     CAN_RXIMR0_MI_18            BIT18
 set     CAN_RXIMR0_MI_19            BIT19
 set     CAN_RXIMR0_MI_20            BIT20
 set     CAN_RXIMR0_MI_21            BIT21
 set     CAN_RXIMR0_MI_22            BIT22
 set     CAN_RXIMR0_MI_23            BIT23
 set     CAN_RXIMR0_MI_24            BIT24
 set     CAN_RXIMR0_MI_25            BIT25
 set     CAN_RXIMR0_MI_26            BIT26
 set     CAN_RXIMR0_MI_27            BIT27
 set     CAN_RXIMR0_MI_28            BIT28
 set     CAN_RXIMR0_MI_29            BIT29
 set     CAN_RXIMR0_MI_30            BIT30
 set     CAN_RXIMR0_MI_31            BIT31

 set     CAN_RXIMR1_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR1_MI_0             BIT0
 set     CAN_RXIMR1_MI_1             BIT1
 set     CAN_RXIMR1_MI_2             BIT2
 set     CAN_RXIMR1_MI_3             BIT3
 set     CAN_RXIMR1_MI_4             BIT4
 set     CAN_RXIMR1_MI_5             BIT5
 set     CAN_RXIMR1_MI_6             BIT6
 set     CAN_RXIMR1_MI_7             BIT7
 set     CAN_RXIMR1_MI_8             BIT8
 set     CAN_RXIMR1_MI_9             BIT9
 set     CAN_RXIMR1_MI_10            BIT10
 set     CAN_RXIMR1_MI_11            BIT11
 set     CAN_RXIMR1_MI_12            BIT12
 set     CAN_RXIMR1_MI_13            BIT13
 set     CAN_RXIMR1_MI_14            BIT14
 set     CAN_RXIMR1_MI_15            BIT15
 set     CAN_RXIMR1_MI_16            BIT16
 set     CAN_RXIMR1_MI_17            BIT17
 set     CAN_RXIMR1_MI_18            BIT18
 set     CAN_RXIMR1_MI_19            BIT19
 set     CAN_RXIMR1_MI_20            BIT20
 set     CAN_RXIMR1_MI_21            BIT21
 set     CAN_RXIMR1_MI_22            BIT22
 set     CAN_RXIMR1_MI_23            BIT23
 set     CAN_RXIMR1_MI_24            BIT24
 set     CAN_RXIMR1_MI_25            BIT25
 set     CAN_RXIMR1_MI_26            BIT26
 set     CAN_RXIMR1_MI_27            BIT27
 set     CAN_RXIMR1_MI_28            BIT28
 set     CAN_RXIMR1_MI_29            BIT29
 set     CAN_RXIMR1_MI_30            BIT30
 set     CAN_RXIMR1_MI_31            BIT31

 set     CAN_RXIMR2_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR2_MI_0             BIT0
 set     CAN_RXIMR2_MI_1             BIT1
 set     CAN_RXIMR2_MI_2             BIT2
 set     CAN_RXIMR2_MI_3             BIT3
 set     CAN_RXIMR2_MI_4             BIT4
 set     CAN_RXIMR2_MI_5             BIT5
 set     CAN_RXIMR2_MI_6             BIT6
 set     CAN_RXIMR2_MI_7             BIT7
 set     CAN_RXIMR2_MI_8             BIT8
 set     CAN_RXIMR2_MI_9             BIT9
 set     CAN_RXIMR2_MI_10            BIT10
 set     CAN_RXIMR2_MI_11            BIT11
 set     CAN_RXIMR2_MI_12            BIT12
 set     CAN_RXIMR2_MI_13            BIT13
 set     CAN_RXIMR2_MI_14            BIT14
 set     CAN_RXIMR2_MI_15            BIT15
 set     CAN_RXIMR2_MI_16            BIT16
 set     CAN_RXIMR2_MI_17            BIT17
 set     CAN_RXIMR2_MI_18            BIT18
 set     CAN_RXIMR2_MI_19            BIT19
 set     CAN_RXIMR2_MI_20            BIT20
 set     CAN_RXIMR2_MI_21            BIT21
 set     CAN_RXIMR2_MI_22            BIT22
 set     CAN_RXIMR2_MI_23            BIT23
 set     CAN_RXIMR2_MI_24            BIT24
 set     CAN_RXIMR2_MI_25            BIT25
 set     CAN_RXIMR2_MI_26            BIT26
 set     CAN_RXIMR2_MI_27            BIT27
 set     CAN_RXIMR2_MI_28            BIT28
 set     CAN_RXIMR2_MI_29            BIT29
 set     CAN_RXIMR2_MI_30            BIT30
 set     CAN_RXIMR2_MI_31            BIT31

 set     CAN_RXIMR3_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR3_MI_0             BIT0
 set     CAN_RXIMR3_MI_1             BIT1
 set     CAN_RXIMR3_MI_2             BIT2
 set     CAN_RXIMR3_MI_3             BIT3
 set     CAN_RXIMR3_MI_4             BIT4
 set     CAN_RXIMR3_MI_5             BIT5
 set     CAN_RXIMR3_MI_6             BIT6
 set     CAN_RXIMR3_MI_7             BIT7
 set     CAN_RXIMR3_MI_8             BIT8
 set     CAN_RXIMR3_MI_9             BIT9
 set     CAN_RXIMR3_MI_10            BIT10
 set     CAN_RXIMR3_MI_11            BIT11
 set     CAN_RXIMR3_MI_12            BIT12
 set     CAN_RXIMR3_MI_13            BIT13
 set     CAN_RXIMR3_MI_14            BIT14
 set     CAN_RXIMR3_MI_15            BIT15
 set     CAN_RXIMR3_MI_16            BIT16
 set     CAN_RXIMR3_MI_17            BIT17
 set     CAN_RXIMR3_MI_18            BIT18
 set     CAN_RXIMR3_MI_19            BIT19
 set     CAN_RXIMR3_MI_20            BIT20
 set     CAN_RXIMR3_MI_21            BIT21
 set     CAN_RXIMR3_MI_22            BIT22
 set     CAN_RXIMR3_MI_23            BIT23
 set     CAN_RXIMR3_MI_24            BIT24
 set     CAN_RXIMR3_MI_25            BIT25
 set     CAN_RXIMR3_MI_26            BIT26
 set     CAN_RXIMR3_MI_27            BIT27
 set     CAN_RXIMR3_MI_28            BIT28
 set     CAN_RXIMR3_MI_29            BIT29
 set     CAN_RXIMR3_MI_30            BIT30
 set     CAN_RXIMR3_MI_31            BIT31

 set     CAN_RXIMR4_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR4_MI_0             BIT0
 set     CAN_RXIMR4_MI_1             BIT1
 set     CAN_RXIMR4_MI_2             BIT2
 set     CAN_RXIMR4_MI_3             BIT3
 set     CAN_RXIMR4_MI_4             BIT4
 set     CAN_RXIMR4_MI_5             BIT5
 set     CAN_RXIMR4_MI_6             BIT6
 set     CAN_RXIMR4_MI_7             BIT7
 set     CAN_RXIMR4_MI_8             BIT8
 set     CAN_RXIMR4_MI_9             BIT9
 set     CAN_RXIMR4_MI_10            BIT10
 set     CAN_RXIMR4_MI_11            BIT11
 set     CAN_RXIMR4_MI_12            BIT12
 set     CAN_RXIMR4_MI_13            BIT13
 set     CAN_RXIMR4_MI_14            BIT14
 set     CAN_RXIMR4_MI_15            BIT15
 set     CAN_RXIMR4_MI_16            BIT16
 set     CAN_RXIMR4_MI_17            BIT17
 set     CAN_RXIMR4_MI_18            BIT18
 set     CAN_RXIMR4_MI_19            BIT19
 set     CAN_RXIMR4_MI_20            BIT20
 set     CAN_RXIMR4_MI_21            BIT21
 set     CAN_RXIMR4_MI_22            BIT22
 set     CAN_RXIMR4_MI_23            BIT23
 set     CAN_RXIMR4_MI_24            BIT24
 set     CAN_RXIMR4_MI_25            BIT25
 set     CAN_RXIMR4_MI_26            BIT26
 set     CAN_RXIMR4_MI_27            BIT27
 set     CAN_RXIMR4_MI_28            BIT28
 set     CAN_RXIMR4_MI_29            BIT29
 set     CAN_RXIMR4_MI_30            BIT30
 set     CAN_RXIMR4_MI_31            BIT31

 set     CAN_RXIMR5_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR5_MI_0             BIT0
 set     CAN_RXIMR5_MI_1             BIT1
 set     CAN_RXIMR5_MI_2             BIT2
 set     CAN_RXIMR5_MI_3             BIT3
 set     CAN_RXIMR5_MI_4             BIT4
 set     CAN_RXIMR5_MI_5             BIT5
 set     CAN_RXIMR5_MI_6             BIT6
 set     CAN_RXIMR5_MI_7             BIT7
 set     CAN_RXIMR5_MI_8             BIT8
 set     CAN_RXIMR5_MI_9             BIT9
 set     CAN_RXIMR5_MI_10            BIT10
 set     CAN_RXIMR5_MI_11            BIT11
 set     CAN_RXIMR5_MI_12            BIT12
 set     CAN_RXIMR5_MI_13            BIT13
 set     CAN_RXIMR5_MI_14            BIT14
 set     CAN_RXIMR5_MI_15            BIT15
 set     CAN_RXIMR5_MI_16            BIT16
 set     CAN_RXIMR5_MI_17            BIT17
 set     CAN_RXIMR5_MI_18            BIT18
 set     CAN_RXIMR5_MI_19            BIT19
 set     CAN_RXIMR5_MI_20            BIT20
 set     CAN_RXIMR5_MI_21            BIT21
 set     CAN_RXIMR5_MI_22            BIT22
 set     CAN_RXIMR5_MI_23            BIT23
 set     CAN_RXIMR5_MI_24            BIT24
 set     CAN_RXIMR5_MI_25            BIT25
 set     CAN_RXIMR5_MI_26            BIT26
 set     CAN_RXIMR5_MI_27            BIT27
 set     CAN_RXIMR5_MI_28            BIT28
 set     CAN_RXIMR5_MI_29            BIT29
 set     CAN_RXIMR5_MI_30            BIT30
 set     CAN_RXIMR5_MI_31            BIT31

 set     CAN_RXIMR6_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR6_MI_0             BIT0
 set     CAN_RXIMR6_MI_1             BIT1
 set     CAN_RXIMR6_MI_2             BIT2
 set     CAN_RXIMR6_MI_3             BIT3
 set     CAN_RXIMR6_MI_4             BIT4
 set     CAN_RXIMR6_MI_5             BIT5
 set     CAN_RXIMR6_MI_6             BIT6
 set     CAN_RXIMR6_MI_7             BIT7
 set     CAN_RXIMR6_MI_8             BIT8
 set     CAN_RXIMR6_MI_9             BIT9
 set     CAN_RXIMR6_MI_10            BIT10
 set     CAN_RXIMR6_MI_11            BIT11
 set     CAN_RXIMR6_MI_12            BIT12
 set     CAN_RXIMR6_MI_13            BIT13
 set     CAN_RXIMR6_MI_14            BIT14
 set     CAN_RXIMR6_MI_15            BIT15
 set     CAN_RXIMR6_MI_16            BIT16
 set     CAN_RXIMR6_MI_17            BIT17
 set     CAN_RXIMR6_MI_18            BIT18
 set     CAN_RXIMR6_MI_19            BIT19
 set     CAN_RXIMR6_MI_20            BIT20
 set     CAN_RXIMR6_MI_21            BIT21
 set     CAN_RXIMR6_MI_22            BIT22
 set     CAN_RXIMR6_MI_23            BIT23
 set     CAN_RXIMR6_MI_24            BIT24
 set     CAN_RXIMR6_MI_25            BIT25
 set     CAN_RXIMR6_MI_26            BIT26
 set     CAN_RXIMR6_MI_27            BIT27
 set     CAN_RXIMR6_MI_28            BIT28
 set     CAN_RXIMR6_MI_29            BIT29
 set     CAN_RXIMR6_MI_30            BIT30
 set     CAN_RXIMR6_MI_31            BIT31

 set     CAN_RXIMR7_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR7_MI_0             BIT0
 set     CAN_RXIMR7_MI_1             BIT1
 set     CAN_RXIMR7_MI_2             BIT2
 set     CAN_RXIMR7_MI_3             BIT3
 set     CAN_RXIMR7_MI_4             BIT4
 set     CAN_RXIMR7_MI_5             BIT5
 set     CAN_RXIMR7_MI_6             BIT6
 set     CAN_RXIMR7_MI_7             BIT7
 set     CAN_RXIMR7_MI_8             BIT8
 set     CAN_RXIMR7_MI_9             BIT9
 set     CAN_RXIMR7_MI_10            BIT10
 set     CAN_RXIMR7_MI_11            BIT11
 set     CAN_RXIMR7_MI_12            BIT12
 set     CAN_RXIMR7_MI_13            BIT13
 set     CAN_RXIMR7_MI_14            BIT14
 set     CAN_RXIMR7_MI_15            BIT15
 set     CAN_RXIMR7_MI_16            BIT16
 set     CAN_RXIMR7_MI_17            BIT17
 set     CAN_RXIMR7_MI_18            BIT18
 set     CAN_RXIMR7_MI_19            BIT19
 set     CAN_RXIMR7_MI_20            BIT20
 set     CAN_RXIMR7_MI_21            BIT21
 set     CAN_RXIMR7_MI_22            BIT22
 set     CAN_RXIMR7_MI_23            BIT23
 set     CAN_RXIMR7_MI_24            BIT24
 set     CAN_RXIMR7_MI_25            BIT25
 set     CAN_RXIMR7_MI_26            BIT26
 set     CAN_RXIMR7_MI_27            BIT27
 set     CAN_RXIMR7_MI_28            BIT28
 set     CAN_RXIMR7_MI_29            BIT29
 set     CAN_RXIMR7_MI_30            BIT30
 set     CAN_RXIMR7_MI_31            BIT31

 set     CAN_RXIMR8_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR8_MI_0             BIT0
 set     CAN_RXIMR8_MI_1             BIT1
 set     CAN_RXIMR8_MI_2             BIT2
 set     CAN_RXIMR8_MI_3             BIT3
 set     CAN_RXIMR8_MI_4             BIT4
 set     CAN_RXIMR8_MI_5             BIT5
 set     CAN_RXIMR8_MI_6             BIT6
 set     CAN_RXIMR8_MI_7             BIT7
 set     CAN_RXIMR8_MI_8             BIT8
 set     CAN_RXIMR8_MI_9             BIT9
 set     CAN_RXIMR8_MI_10            BIT10
 set     CAN_RXIMR8_MI_11            BIT11
 set     CAN_RXIMR8_MI_12            BIT12
 set     CAN_RXIMR8_MI_13            BIT13
 set     CAN_RXIMR8_MI_14            BIT14
 set     CAN_RXIMR8_MI_15            BIT15
 set     CAN_RXIMR8_MI_16            BIT16
 set     CAN_RXIMR8_MI_17            BIT17
 set     CAN_RXIMR8_MI_18            BIT18
 set     CAN_RXIMR8_MI_19            BIT19
 set     CAN_RXIMR8_MI_20            BIT20
 set     CAN_RXIMR8_MI_21            BIT21
 set     CAN_RXIMR8_MI_22            BIT22
 set     CAN_RXIMR8_MI_23            BIT23
 set     CAN_RXIMR8_MI_24            BIT24
 set     CAN_RXIMR8_MI_25            BIT25
 set     CAN_RXIMR8_MI_26            BIT26
 set     CAN_RXIMR8_MI_27            BIT27
 set     CAN_RXIMR8_MI_28            BIT28
 set     CAN_RXIMR8_MI_29            BIT29
 set     CAN_RXIMR8_MI_30            BIT30
 set     CAN_RXIMR8_MI_31            BIT31

 set     CAN_RXIMR9_MI               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR9_MI_0             BIT0
 set     CAN_RXIMR9_MI_1             BIT1
 set     CAN_RXIMR9_MI_2             BIT2
 set     CAN_RXIMR9_MI_3             BIT3
 set     CAN_RXIMR9_MI_4             BIT4
 set     CAN_RXIMR9_MI_5             BIT5
 set     CAN_RXIMR9_MI_6             BIT6
 set     CAN_RXIMR9_MI_7             BIT7
 set     CAN_RXIMR9_MI_8             BIT8
 set     CAN_RXIMR9_MI_9             BIT9
 set     CAN_RXIMR9_MI_10            BIT10
 set     CAN_RXIMR9_MI_11            BIT11
 set     CAN_RXIMR9_MI_12            BIT12
 set     CAN_RXIMR9_MI_13            BIT13
 set     CAN_RXIMR9_MI_14            BIT14
 set     CAN_RXIMR9_MI_15            BIT15
 set     CAN_RXIMR9_MI_16            BIT16
 set     CAN_RXIMR9_MI_17            BIT17
 set     CAN_RXIMR9_MI_18            BIT18
 set     CAN_RXIMR9_MI_19            BIT19
 set     CAN_RXIMR9_MI_20            BIT20
 set     CAN_RXIMR9_MI_21            BIT21
 set     CAN_RXIMR9_MI_22            BIT22
 set     CAN_RXIMR9_MI_23            BIT23
 set     CAN_RXIMR9_MI_24            BIT24
 set     CAN_RXIMR9_MI_25            BIT25
 set     CAN_RXIMR9_MI_26            BIT26
 set     CAN_RXIMR9_MI_27            BIT27
 set     CAN_RXIMR9_MI_28            BIT28
 set     CAN_RXIMR9_MI_29            BIT29
 set     CAN_RXIMR9_MI_30            BIT30
 set     CAN_RXIMR9_MI_31            BIT31

 set     CAN_RXIMR10_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR10_MI_0            BIT0
 set     CAN_RXIMR10_MI_1            BIT1
 set     CAN_RXIMR10_MI_2            BIT2
 set     CAN_RXIMR10_MI_3            BIT3
 set     CAN_RXIMR10_MI_4            BIT4
 set     CAN_RXIMR10_MI_5            BIT5
 set     CAN_RXIMR10_MI_6            BIT6
 set     CAN_RXIMR10_MI_7            BIT7
 set     CAN_RXIMR10_MI_8            BIT8
 set     CAN_RXIMR10_MI_9            BIT9
 set     CAN_RXIMR10_MI_10           BIT10
 set     CAN_RXIMR10_MI_11           BIT11
 set     CAN_RXIMR10_MI_12           BIT12
 set     CAN_RXIMR10_MI_13           BIT13
 set     CAN_RXIMR10_MI_14           BIT14
 set     CAN_RXIMR10_MI_15           BIT15
 set     CAN_RXIMR10_MI_16           BIT16
 set     CAN_RXIMR10_MI_17           BIT17
 set     CAN_RXIMR10_MI_18           BIT18
 set     CAN_RXIMR10_MI_19           BIT19
 set     CAN_RXIMR10_MI_20           BIT20
 set     CAN_RXIMR10_MI_21           BIT21
 set     CAN_RXIMR10_MI_22           BIT22
 set     CAN_RXIMR10_MI_23           BIT23
 set     CAN_RXIMR10_MI_24           BIT24
 set     CAN_RXIMR10_MI_25           BIT25
 set     CAN_RXIMR10_MI_26           BIT26
 set     CAN_RXIMR10_MI_27           BIT27
 set     CAN_RXIMR10_MI_28           BIT28
 set     CAN_RXIMR10_MI_29           BIT29
 set     CAN_RXIMR10_MI_30           BIT30
 set     CAN_RXIMR10_MI_31           BIT31

 set     CAN_RXIMR11_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR11_MI_0            BIT0
 set     CAN_RXIMR11_MI_1            BIT1
 set     CAN_RXIMR11_MI_2            BIT2
 set     CAN_RXIMR11_MI_3            BIT3
 set     CAN_RXIMR11_MI_4            BIT4
 set     CAN_RXIMR11_MI_5            BIT5
 set     CAN_RXIMR11_MI_6            BIT6
 set     CAN_RXIMR11_MI_7            BIT7
 set     CAN_RXIMR11_MI_8            BIT8
 set     CAN_RXIMR11_MI_9            BIT9
 set     CAN_RXIMR11_MI_10           BIT10
 set     CAN_RXIMR11_MI_11           BIT11
 set     CAN_RXIMR11_MI_12           BIT12
 set     CAN_RXIMR11_MI_13           BIT13
 set     CAN_RXIMR11_MI_14           BIT14
 set     CAN_RXIMR11_MI_15           BIT15
 set     CAN_RXIMR11_MI_16           BIT16
 set     CAN_RXIMR11_MI_17           BIT17
 set     CAN_RXIMR11_MI_18           BIT18
 set     CAN_RXIMR11_MI_19           BIT19
 set     CAN_RXIMR11_MI_20           BIT20
 set     CAN_RXIMR11_MI_21           BIT21
 set     CAN_RXIMR11_MI_22           BIT22
 set     CAN_RXIMR11_MI_23           BIT23
 set     CAN_RXIMR11_MI_24           BIT24
 set     CAN_RXIMR11_MI_25           BIT25
 set     CAN_RXIMR11_MI_26           BIT26
 set     CAN_RXIMR11_MI_27           BIT27
 set     CAN_RXIMR11_MI_28           BIT28
 set     CAN_RXIMR11_MI_29           BIT29
 set     CAN_RXIMR11_MI_30           BIT30
 set     CAN_RXIMR11_MI_31           BIT31

 set     CAN_RXIMR12_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR12_MI_0            BIT0
 set     CAN_RXIMR12_MI_1            BIT1
 set     CAN_RXIMR12_MI_2            BIT2
 set     CAN_RXIMR12_MI_3            BIT3
 set     CAN_RXIMR12_MI_4            BIT4
 set     CAN_RXIMR12_MI_5            BIT5
 set     CAN_RXIMR12_MI_6            BIT6
 set     CAN_RXIMR12_MI_7            BIT7
 set     CAN_RXIMR12_MI_8            BIT8
 set     CAN_RXIMR12_MI_9            BIT9
 set     CAN_RXIMR12_MI_10           BIT10
 set     CAN_RXIMR12_MI_11           BIT11
 set     CAN_RXIMR12_MI_12           BIT12
 set     CAN_RXIMR12_MI_13           BIT13
 set     CAN_RXIMR12_MI_14           BIT14
 set     CAN_RXIMR12_MI_15           BIT15
 set     CAN_RXIMR12_MI_16           BIT16
 set     CAN_RXIMR12_MI_17           BIT17
 set     CAN_RXIMR12_MI_18           BIT18
 set     CAN_RXIMR12_MI_19           BIT19
 set     CAN_RXIMR12_MI_20           BIT20
 set     CAN_RXIMR12_MI_21           BIT21
 set     CAN_RXIMR12_MI_22           BIT22
 set     CAN_RXIMR12_MI_23           BIT23
 set     CAN_RXIMR12_MI_24           BIT24
 set     CAN_RXIMR12_MI_25           BIT25
 set     CAN_RXIMR12_MI_26           BIT26
 set     CAN_RXIMR12_MI_27           BIT27
 set     CAN_RXIMR12_MI_28           BIT28
 set     CAN_RXIMR12_MI_29           BIT29
 set     CAN_RXIMR12_MI_30           BIT30
 set     CAN_RXIMR12_MI_31           BIT31

 set     CAN_RXIMR13_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR13_MI_0            BIT0
 set     CAN_RXIMR13_MI_1            BIT1
 set     CAN_RXIMR13_MI_2            BIT2
 set     CAN_RXIMR13_MI_3            BIT3
 set     CAN_RXIMR13_MI_4            BIT4
 set     CAN_RXIMR13_MI_5            BIT5
 set     CAN_RXIMR13_MI_6            BIT6
 set     CAN_RXIMR13_MI_7            BIT7
 set     CAN_RXIMR13_MI_8            BIT8
 set     CAN_RXIMR13_MI_9            BIT9
 set     CAN_RXIMR13_MI_10           BIT10
 set     CAN_RXIMR13_MI_11           BIT11
 set     CAN_RXIMR13_MI_12           BIT12
 set     CAN_RXIMR13_MI_13           BIT13
 set     CAN_RXIMR13_MI_14           BIT14
 set     CAN_RXIMR13_MI_15           BIT15
 set     CAN_RXIMR13_MI_16           BIT16
 set     CAN_RXIMR13_MI_17           BIT17
 set     CAN_RXIMR13_MI_18           BIT18
 set     CAN_RXIMR13_MI_19           BIT19
 set     CAN_RXIMR13_MI_20           BIT20
 set     CAN_RXIMR13_MI_21           BIT21
 set     CAN_RXIMR13_MI_22           BIT22
 set     CAN_RXIMR13_MI_23           BIT23
 set     CAN_RXIMR13_MI_24           BIT24
 set     CAN_RXIMR13_MI_25           BIT25
 set     CAN_RXIMR13_MI_26           BIT26
 set     CAN_RXIMR13_MI_27           BIT27
 set     CAN_RXIMR13_MI_28           BIT28
 set     CAN_RXIMR13_MI_29           BIT29
 set     CAN_RXIMR13_MI_30           BIT30
 set     CAN_RXIMR13_MI_31           BIT31

 set     CAN_RXIMR14_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR14_MI_0            BIT0
 set     CAN_RXIMR14_MI_1            BIT1
 set     CAN_RXIMR14_MI_2            BIT2
 set     CAN_RXIMR14_MI_3            BIT3
 set     CAN_RXIMR14_MI_4            BIT4
 set     CAN_RXIMR14_MI_5            BIT5
 set     CAN_RXIMR14_MI_6            BIT6
 set     CAN_RXIMR14_MI_7            BIT7
 set     CAN_RXIMR14_MI_8            BIT8
 set     CAN_RXIMR14_MI_9            BIT9
 set     CAN_RXIMR14_MI_10           BIT10
 set     CAN_RXIMR14_MI_11           BIT11
 set     CAN_RXIMR14_MI_12           BIT12
 set     CAN_RXIMR14_MI_13           BIT13
 set     CAN_RXIMR14_MI_14           BIT14
 set     CAN_RXIMR14_MI_15           BIT15
 set     CAN_RXIMR14_MI_16           BIT16
 set     CAN_RXIMR14_MI_17           BIT17
 set     CAN_RXIMR14_MI_18           BIT18
 set     CAN_RXIMR14_MI_19           BIT19
 set     CAN_RXIMR14_MI_20           BIT20
 set     CAN_RXIMR14_MI_21           BIT21
 set     CAN_RXIMR14_MI_22           BIT22
 set     CAN_RXIMR14_MI_23           BIT23
 set     CAN_RXIMR14_MI_24           BIT24
 set     CAN_RXIMR14_MI_25           BIT25
 set     CAN_RXIMR14_MI_26           BIT26
 set     CAN_RXIMR14_MI_27           BIT27
 set     CAN_RXIMR14_MI_28           BIT28
 set     CAN_RXIMR14_MI_29           BIT29
 set     CAN_RXIMR14_MI_30           BIT30
 set     CAN_RXIMR14_MI_31           BIT31

 set     CAN_RXIMR15_MI              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Individual Mask Bits
;;     0b0 ==> The corresponding bit in the filter is "don't care."
;;     0b1 ==> The corresponding bit in the filter is checked.
 set     CAN_RXIMR15_MI_0            BIT0
 set     CAN_RXIMR15_MI_1            BIT1
 set     CAN_RXIMR15_MI_2            BIT2
 set     CAN_RXIMR15_MI_3            BIT3
 set     CAN_RXIMR15_MI_4            BIT4
 set     CAN_RXIMR15_MI_5            BIT5
 set     CAN_RXIMR15_MI_6            BIT6
 set     CAN_RXIMR15_MI_7            BIT7
 set     CAN_RXIMR15_MI_8            BIT8
 set     CAN_RXIMR15_MI_9            BIT9
 set     CAN_RXIMR15_MI_10           BIT10
 set     CAN_RXIMR15_MI_11           BIT11
 set     CAN_RXIMR15_MI_12           BIT12
 set     CAN_RXIMR15_MI_13           BIT13
 set     CAN_RXIMR15_MI_14           BIT14
 set     CAN_RXIMR15_MI_15           BIT15
 set     CAN_RXIMR15_MI_16           BIT16
 set     CAN_RXIMR15_MI_17           BIT17
 set     CAN_RXIMR15_MI_18           BIT18
 set     CAN_RXIMR15_MI_19           BIT19
 set     CAN_RXIMR15_MI_20           BIT20
 set     CAN_RXIMR15_MI_21           BIT21
 set     CAN_RXIMR15_MI_22           BIT22
 set     CAN_RXIMR15_MI_23           BIT23
 set     CAN_RXIMR15_MI_24           BIT24
 set     CAN_RXIMR15_MI_25           BIT25
 set     CAN_RXIMR15_MI_26           BIT26
 set     CAN_RXIMR15_MI_27           BIT27
 set     CAN_RXIMR15_MI_28           BIT28
 set     CAN_RXIMR15_MI_29           BIT29
 set     CAN_RXIMR15_MI_30           BIT30
 set     CAN_RXIMR15_MI_31           BIT31

 set     CMPA_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPA_CR0_HYSTCTR_0          BIT0
 set     CMPA_CR0_HYSTCTR_1          BIT1

 set     CMPA_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
;;     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPA_CR0_FILTER_CNT_0       BIT4
 set     CMPA_CR0_FILTER_CNT_1       BIT5
 set     CMPA_CR0_FILTER_CNT_2       BIT6

 set     CMPA_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator disabled.
;;     0b1 ==> Analog Comparator enabled.

 set     CMPA_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
;;     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

 set     CMPA_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
;;     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

 set     CMPA_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPA_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPA_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode not selected.
;;     0b1 ==> Windowing mode selected.

 set     CMPA_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode not selected.
;;     0b1 ==> Sampling mode selected.

 set     CMPA_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPA_FPR_FILT_PER_0         BIT0
 set     CMPA_FPR_FILT_PER_1         BIT1
 set     CMPA_FPR_FILT_PER_2         BIT2
 set     CMPA_FPR_FILT_PER_3         BIT3
 set     CMPA_FPR_FILT_PER_4         BIT4
 set     CMPA_FPR_FILT_PER_5         BIT5
 set     CMPA_FPR_FILT_PER_6         BIT6
 set     CMPA_FPR_FILT_PER_7         BIT7

 set     CMPA_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPA_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling edge on COUT has not been detected.
;;     0b1 ==> Falling edge on COUT has occurred.

 set     CMPA_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising edge on COUT has not been detected.
;;     0b1 ==> Rising edge on COUT has occurred.

 set     CMPA_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPA_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPA_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DAC Output Voltage Select
 set     CMPA_DACCR_VOSEL_0          BIT0
 set     CMPA_DACCR_VOSEL_1          BIT1
 set     CMPA_DACCR_VOSEL_2          BIT2
 set     CMPA_DACCR_VOSEL_3          BIT3
 set     CMPA_DACCR_VOSEL_4          BIT4
 set     CMPA_DACCR_VOSEL_5          BIT5

 set     CMPA_DACCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

 set     CMPA_DACCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     CMPA_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPA_MUXCR_MSEL_0           BIT0
 set     CMPA_MUXCR_MSEL_1           BIT1
 set     CMPA_MUXCR_MSEL_2           BIT2

 set     CMPA_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPA_MUXCR_PSEL_0           BIT3
 set     CMPA_MUXCR_PSEL_1           BIT4
 set     CMPA_MUXCR_PSEL_2           BIT5

 set     CMPB_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPB_CR0_HYSTCTR_0          BIT0
 set     CMPB_CR0_HYSTCTR_1          BIT1

 set     CMPB_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
;;     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPB_CR0_FILTER_CNT_0       BIT4
 set     CMPB_CR0_FILTER_CNT_1       BIT5
 set     CMPB_CR0_FILTER_CNT_2       BIT6

 set     CMPB_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator disabled.
;;     0b1 ==> Analog Comparator enabled.

 set     CMPB_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
;;     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

 set     CMPB_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
;;     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

 set     CMPB_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPB_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPB_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode not selected.
;;     0b1 ==> Windowing mode selected.

 set     CMPB_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode not selected.
;;     0b1 ==> Sampling mode selected.

 set     CMPB_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPB_FPR_FILT_PER_0         BIT0
 set     CMPB_FPR_FILT_PER_1         BIT1
 set     CMPB_FPR_FILT_PER_2         BIT2
 set     CMPB_FPR_FILT_PER_3         BIT3
 set     CMPB_FPR_FILT_PER_4         BIT4
 set     CMPB_FPR_FILT_PER_5         BIT5
 set     CMPB_FPR_FILT_PER_6         BIT6
 set     CMPB_FPR_FILT_PER_7         BIT7

 set     CMPB_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPB_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling edge on COUT has not been detected.
;;     0b1 ==> Falling edge on COUT has occurred.

 set     CMPB_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising edge on COUT has not been detected.
;;     0b1 ==> Rising edge on COUT has occurred.

 set     CMPB_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPB_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPB_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DAC Output Voltage Select
 set     CMPB_DACCR_VOSEL_0          BIT0
 set     CMPB_DACCR_VOSEL_1          BIT1
 set     CMPB_DACCR_VOSEL_2          BIT2
 set     CMPB_DACCR_VOSEL_3          BIT3
 set     CMPB_DACCR_VOSEL_4          BIT4
 set     CMPB_DACCR_VOSEL_5          BIT5

 set     CMPB_DACCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

 set     CMPB_DACCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     CMPB_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPB_MUXCR_MSEL_0           BIT0
 set     CMPB_MUXCR_MSEL_1           BIT1
 set     CMPB_MUXCR_MSEL_2           BIT2

 set     CMPB_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPB_MUXCR_PSEL_0           BIT3
 set     CMPB_MUXCR_PSEL_1           BIT4
 set     CMPB_MUXCR_PSEL_2           BIT5

 set     CMPC_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPC_CR0_HYSTCTR_0          BIT0
 set     CMPC_CR0_HYSTCTR_1          BIT1

 set     CMPC_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
;;     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPC_CR0_FILTER_CNT_0       BIT4
 set     CMPC_CR0_FILTER_CNT_1       BIT5
 set     CMPC_CR0_FILTER_CNT_2       BIT6

 set     CMPC_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator disabled.
;;     0b1 ==> Analog Comparator enabled.

 set     CMPC_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
;;     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

 set     CMPC_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
;;     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

 set     CMPC_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPC_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPC_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode not selected.
;;     0b1 ==> Windowing mode selected.

 set     CMPC_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode not selected.
;;     0b1 ==> Sampling mode selected.

 set     CMPC_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPC_FPR_FILT_PER_0         BIT0
 set     CMPC_FPR_FILT_PER_1         BIT1
 set     CMPC_FPR_FILT_PER_2         BIT2
 set     CMPC_FPR_FILT_PER_3         BIT3
 set     CMPC_FPR_FILT_PER_4         BIT4
 set     CMPC_FPR_FILT_PER_5         BIT5
 set     CMPC_FPR_FILT_PER_6         BIT6
 set     CMPC_FPR_FILT_PER_7         BIT7

 set     CMPC_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPC_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling edge on COUT has not been detected.
;;     0b1 ==> Falling edge on COUT has occurred.

 set     CMPC_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising edge on COUT has not been detected.
;;     0b1 ==> Rising edge on COUT has occurred.

 set     CMPC_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPC_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPC_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DAC Output Voltage Select
 set     CMPC_DACCR_VOSEL_0          BIT0
 set     CMPC_DACCR_VOSEL_1          BIT1
 set     CMPC_DACCR_VOSEL_2          BIT2
 set     CMPC_DACCR_VOSEL_3          BIT3
 set     CMPC_DACCR_VOSEL_4          BIT4
 set     CMPC_DACCR_VOSEL_5          BIT5

 set     CMPC_DACCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

 set     CMPC_DACCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     CMPC_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPC_MUXCR_MSEL_0           BIT0
 set     CMPC_MUXCR_MSEL_1           BIT1
 set     CMPC_MUXCR_MSEL_2           BIT2

 set     CMPC_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPC_MUXCR_PSEL_0           BIT3
 set     CMPC_MUXCR_PSEL_1           BIT4
 set     CMPC_MUXCR_PSEL_2           BIT5

 set     CMPD_CR0_HYSTCTR            (BIT0|BIT1)
;;   Comparator hard block hysteresis control
;;     0b00 ==> Level 0
;;     0b01 ==> Level 1
;;     0b10 ==> Level 2
;;     0b11 ==> Level 3
 set     CMPD_CR0_HYSTCTR_0          BIT0
 set     CMPD_CR0_HYSTCTR_1          BIT1

 set     CMPD_CR0_FILTER_CNT         (BIT4|BIT5|BIT6)
;;   Filter Sample Count
;;     0b000 ==> Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
;;     0b001 ==> 1 consecutive sample must agree (comparator output is simply sampled).
;;     0b010 ==> 2 consecutive samples must agree.
;;     0b011 ==> 3 consecutive samples must agree.
;;     0b100 ==> 4 consecutive samples must agree.
;;     0b101 ==> 5 consecutive samples must agree.
;;     0b110 ==> 6 consecutive samples must agree.
;;     0b111 ==> 7 consecutive samples must agree.
 set     CMPD_CR0_FILTER_CNT_0       BIT4
 set     CMPD_CR0_FILTER_CNT_1       BIT5
 set     CMPD_CR0_FILTER_CNT_2       BIT6

 set     CMPD_CR1_EN                 BIT0
;;   Comparator Module Enable
;;     0b0 ==> Analog Comparator disabled.
;;     0b1 ==> Analog Comparator enabled.

 set     CMPD_CR1_OPE                BIT1
;;   Comparator Output Pin Enable
;;     0b0 ==> The comparator output (CMPO) is not available on the associated CMPO output pin. Instead, the INV bit is driven if the comparator owns the pin (usually a result of properly setting pin mux controls at the SoC level). If the comparator does not own the pin, this bit has no effect.
;;     0b1 ==> The comparator output (CMPO) is available on the associated CMPO output pin. The comparator output (CMPO) is driven out on the associated CMPO output pin if the comparator owns the pin. If the comparator does not own the pin, this bit has no effect.

 set     CMPD_CR1_COS                BIT2
;;   Comparator Output Select
;;     0b0 ==> Set CMPO to equal COUT (filtered comparator output).
;;     0b1 ==> Set CMPO to equal COUTA (unfiltered comparator output).

 set     CMPD_CR1_INV                BIT3
;;   Comparator INVERT
;;     0b0 ==> Does not invert the comparator output.
;;     0b1 ==> Inverts the comparator output.

 set     CMPD_CR1_PMODE              BIT4
;;   Power Mode Select
;;     0b0 ==> Low Speed (LS) comparison mode selected. In this mode, CMP has slower output propagation delay and lower current consumption.
;;     0b1 ==> High Speed (HS) comparison mode selected. In this mode, CMP has faster output propagation delay and higher current consumption.

 set     CMPD_CR1_WE                 BIT6
;;   Windowing Enable
;;     0b0 ==> Windowing mode not selected.
;;     0b1 ==> Windowing mode selected.

 set     CMPD_CR1_SE                 BIT7
;;   Sample Enable
;;     0b0 ==> Sampling mode not selected.
;;     0b1 ==> Sampling mode selected.

 set     CMPD_FPR_FILT_PER           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Filter Sample Period
 set     CMPD_FPR_FILT_PER_0         BIT0
 set     CMPD_FPR_FILT_PER_1         BIT1
 set     CMPD_FPR_FILT_PER_2         BIT2
 set     CMPD_FPR_FILT_PER_3         BIT3
 set     CMPD_FPR_FILT_PER_4         BIT4
 set     CMPD_FPR_FILT_PER_5         BIT5
 set     CMPD_FPR_FILT_PER_6         BIT6
 set     CMPD_FPR_FILT_PER_7         BIT7

 set     CMPD_SCR_COUT               BIT0
;;   Analog Comparator Output

 set     CMPD_SCR_CFF                BIT1
;;   Analog Comparator Flag Falling
;;     0b0 ==> Falling edge on COUT has not been detected.
;;     0b1 ==> Falling edge on COUT has occurred.

 set     CMPD_SCR_CFR                BIT2
;;   Analog Comparator Flag Rising
;;     0b0 ==> Rising edge on COUT has not been detected.
;;     0b1 ==> Rising edge on COUT has occurred.

 set     CMPD_SCR_IEF                BIT3
;;   Comparator Interrupt Enable Falling
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPD_SCR_IER                BIT4
;;   Comparator Interrupt Enable Rising
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     CMPD_DACCR_VOSEL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   DAC Output Voltage Select
 set     CMPD_DACCR_VOSEL_0          BIT0
 set     CMPD_DACCR_VOSEL_1          BIT1
 set     CMPD_DACCR_VOSEL_2          BIT2
 set     CMPD_DACCR_VOSEL_3          BIT3
 set     CMPD_DACCR_VOSEL_4          BIT4
 set     CMPD_DACCR_VOSEL_5          BIT5

 set     CMPD_DACCR_VRSEL            BIT6
;;   Supply Voltage Reference Source Select
;;     0b0 ==> Vin1 is selected as resistor ladder network supply reference Vin.
;;     0b1 ==> Vin2 is selected as resistor ladder network supply reference Vin.

 set     CMPD_DACCR_DACEN            BIT7
;;   DAC Enable
;;     0b0 ==> DAC is disabled.
;;     0b1 ==> DAC is enabled.

 set     CMPD_MUXCR_MSEL             (BIT0|BIT1|BIT2)
;;   Minus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPD_MUXCR_MSEL_0           BIT0
 set     CMPD_MUXCR_MSEL_1           BIT1
 set     CMPD_MUXCR_MSEL_2           BIT2

 set     CMPD_MUXCR_PSEL             (BIT3|BIT4|BIT5)
;;   Plus Input MUX Control
;;     0b000 ==> IN0
;;     0b001 ==> IN1
;;     0b010 ==> IN2
;;     0b011 ==> IN3
;;     0b100 ==> IN4
;;     0b101 ==> IN5
;;     0b110 ==> IN6
;;     0b111 ==> IN7
 set     CMPD_MUXCR_PSEL_0           BIT3
 set     CMPD_MUXCR_PSEL_1           BIT4
 set     CMPD_MUXCR_PSEL_2           BIT5

 set     COP_CTRL_CWP                BIT0
;;   COP Write Protect
;;     0b0 ==> The CTRL, INTVAL and TOUT registers are readable and writable. (default)
;;     0b1 ==> The CTRL, INTVAL and TOUT registers are read-only.

 set     COP_CTRL_CEN                BIT1
;;   COP Enable
;;     0b0 ==> COP counter is disabled.
;;     0b1 ==> COP counter is enabled. (default)

 set     COP_CTRL_CWEN               BIT2
;;   COP Wait Mode Enable
;;     0b0 ==> COP counter stops in wait mode. (default)
;;     0b1 ==> COP counter runs in wait mode if CEN is set to one.

 set     COP_CTRL_CSEN               BIT3
;;   COP Stop Mode Enable
;;     0b0 ==> COP counter stops in stop mode. (default)
;;     0b1 ==> COP counter runs in stop mode if CEN is set to one.

 set     COP_CTRL_CLOREN             BIT4
;;   COP Loss of Reference Enable
;;     0b0 ==> COP loss of reference counter is disabled. (default)
;;     0b1 ==> COP loss of reference counter is enabled.

 set     COP_CTRL_CLKSEL             (BIT5|BIT6)
;;   Clock Source Select
;;     0b00 ==> Relaxation oscillator output (ROSC) is used to clock the counter (default)
;;     0b01 ==> Crystal oscillator output (COSC) is used to clock the counter
;;     0b10 ==> IP bus clock is used to clock the counter Do not select the IP bus clock to clock the counter if the application requires the COP to wake the device from stop mode.
;;     0b11 ==> Low speed oscillator is used to clock the counter
 set     COP_CTRL_CLKSEL_0           BIT5
 set     COP_CTRL_CLKSEL_1           BIT6

 set     COP_CTRL_INTEN              BIT7
;;   Interrupt Enable
;;     0b0 ==> COP interrupt is disabled. (default)
;;     0b1 ==> COP interrupt is enabled.

 set     COP_CTRL_PSS                (BIT8|BIT9)
;;   Prescaler Select
;;     0b00 ==> No division
;;     0b01 ==> Divide by 16
;;     0b10 ==> Divide by 256
;;     0b11 ==> Divide by 1024
 set     COP_CTRL_PSS_0              BIT8
 set     COP_CTRL_PSS_1              BIT9

 set     COP_TOUT_TIMEOUT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Timeout Period
 set     COP_TOUT_TIMEOUT_0          BIT0
 set     COP_TOUT_TIMEOUT_1          BIT1
 set     COP_TOUT_TIMEOUT_2          BIT2
 set     COP_TOUT_TIMEOUT_3          BIT3
 set     COP_TOUT_TIMEOUT_4          BIT4
 set     COP_TOUT_TIMEOUT_5          BIT5
 set     COP_TOUT_TIMEOUT_6          BIT6
 set     COP_TOUT_TIMEOUT_7          BIT7
 set     COP_TOUT_TIMEOUT_8          BIT8
 set     COP_TOUT_TIMEOUT_9          BIT9
 set     COP_TOUT_TIMEOUT_10         BIT10
 set     COP_TOUT_TIMEOUT_11         BIT11
 set     COP_TOUT_TIMEOUT_12         BIT12
 set     COP_TOUT_TIMEOUT_13         BIT13
 set     COP_TOUT_TIMEOUT_14         BIT14
 set     COP_TOUT_TIMEOUT_15         BIT15

 set     COP_CNTR_COUNT_SERVICE      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Count/Service
 set     COP_CNTR_COUNT_SERVICE_0    BIT0
 set     COP_CNTR_COUNT_SERVICE_1    BIT1
 set     COP_CNTR_COUNT_SERVICE_2    BIT2
 set     COP_CNTR_COUNT_SERVICE_3    BIT3
 set     COP_CNTR_COUNT_SERVICE_4    BIT4
 set     COP_CNTR_COUNT_SERVICE_5    BIT5
 set     COP_CNTR_COUNT_SERVICE_6    BIT6
 set     COP_CNTR_COUNT_SERVICE_7    BIT7
 set     COP_CNTR_COUNT_SERVICE_8    BIT8
 set     COP_CNTR_COUNT_SERVICE_9    BIT9
 set     COP_CNTR_COUNT_SERVICE_10   BIT10
 set     COP_CNTR_COUNT_SERVICE_11   BIT11
 set     COP_CNTR_COUNT_SERVICE_12   BIT12
 set     COP_CNTR_COUNT_SERVICE_13   BIT13
 set     COP_CNTR_COUNT_SERVICE_14   BIT14
 set     COP_CNTR_COUNT_SERVICE_15   BIT15

 set     COP_INTVAL_INTERRUPT_VALUE  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   COP Interrupt Value
 set     COP_INTVAL_INTERRUPT_VALUE_0 BIT0
 set     COP_INTVAL_INTERRUPT_VALUE_1 BIT1
 set     COP_INTVAL_INTERRUPT_VALUE_2 BIT2
 set     COP_INTVAL_INTERRUPT_VALUE_3 BIT3
 set     COP_INTVAL_INTERRUPT_VALUE_4 BIT4
 set     COP_INTVAL_INTERRUPT_VALUE_5 BIT5
 set     COP_INTVAL_INTERRUPT_VALUE_6 BIT6
 set     COP_INTVAL_INTERRUPT_VALUE_7 BIT7
 set     COP_INTVAL_INTERRUPT_VALUE_8 BIT8
 set     COP_INTVAL_INTERRUPT_VALUE_9 BIT9
 set     COP_INTVAL_INTERRUPT_VALUE_10 BIT10
 set     COP_INTVAL_INTERRUPT_VALUE_11 BIT11
 set     COP_INTVAL_INTERRUPT_VALUE_12 BIT12
 set     COP_INTVAL_INTERRUPT_VALUE_13 BIT13
 set     COP_INTVAL_INTERRUPT_VALUE_14 BIT14
 set     COP_INTVAL_INTERRUPT_VALUE_15 BIT15

 set     CRC_CRC_LL                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   CRC Low Lower Byte
 set     CRC_CRC_LL_0                BIT0
 set     CRC_CRC_LL_1                BIT1
 set     CRC_CRC_LL_2                BIT2
 set     CRC_CRC_LL_3                BIT3
 set     CRC_CRC_LL_4                BIT4
 set     CRC_CRC_LL_5                BIT5
 set     CRC_CRC_LL_6                BIT6
 set     CRC_CRC_LL_7                BIT7

 set     CRC_CRC_LU                  (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   CRC Low Upper Byte
 set     CRC_CRC_LU_0                BIT8
 set     CRC_CRC_LU_1                BIT9
 set     CRC_CRC_LU_2                BIT10
 set     CRC_CRC_LU_3                BIT11
 set     CRC_CRC_LU_4                BIT12
 set     CRC_CRC_LU_5                BIT13
 set     CRC_CRC_LU_6                BIT14
 set     CRC_CRC_LU_7                BIT15

 set     CRC_CRC_HL                  (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   CRC High Lower Byte
 set     CRC_CRC_HL_0                BIT16
 set     CRC_CRC_HL_1                BIT17
 set     CRC_CRC_HL_2                BIT18
 set     CRC_CRC_HL_3                BIT19
 set     CRC_CRC_HL_4                BIT20
 set     CRC_CRC_HL_5                BIT21
 set     CRC_CRC_HL_6                BIT22
 set     CRC_CRC_HL_7                BIT23

 set     CRC_CRC_HU                  (BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   CRC High Upper Byte
 set     CRC_CRC_HU_0                BIT24
 set     CRC_CRC_HU_1                BIT25
 set     CRC_CRC_HU_2                BIT26
 set     CRC_CRC_HU_3                BIT27
 set     CRC_CRC_HU_4                BIT28
 set     CRC_CRC_HU_5                BIT29
 set     CRC_CRC_HU_6                BIT30
 set     CRC_CRC_HU_7                BIT31

 set     CRC_GPOLY_LOW               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Low polynominal half-word
 set     CRC_GPOLY_LOW_0             BIT0
 set     CRC_GPOLY_LOW_1             BIT1
 set     CRC_GPOLY_LOW_2             BIT2
 set     CRC_GPOLY_LOW_3             BIT3
 set     CRC_GPOLY_LOW_4             BIT4
 set     CRC_GPOLY_LOW_5             BIT5
 set     CRC_GPOLY_LOW_6             BIT6
 set     CRC_GPOLY_LOW_7             BIT7
 set     CRC_GPOLY_LOW_8             BIT8
 set     CRC_GPOLY_LOW_9             BIT9
 set     CRC_GPOLY_LOW_10            BIT10
 set     CRC_GPOLY_LOW_11            BIT11
 set     CRC_GPOLY_LOW_12            BIT12
 set     CRC_GPOLY_LOW_13            BIT13
 set     CRC_GPOLY_LOW_14            BIT14
 set     CRC_GPOLY_LOW_15            BIT15

 set     CRC_GPOLY_HIGH              (BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   High polynominal half-word
 set     CRC_GPOLY_HIGH_0            BIT16
 set     CRC_GPOLY_HIGH_1            BIT17
 set     CRC_GPOLY_HIGH_2            BIT18
 set     CRC_GPOLY_HIGH_3            BIT19
 set     CRC_GPOLY_HIGH_4            BIT20
 set     CRC_GPOLY_HIGH_5            BIT21
 set     CRC_GPOLY_HIGH_6            BIT22
 set     CRC_GPOLY_HIGH_7            BIT23
 set     CRC_GPOLY_HIGH_8            BIT24
 set     CRC_GPOLY_HIGH_9            BIT25
 set     CRC_GPOLY_HIGH_10           BIT26
 set     CRC_GPOLY_HIGH_11           BIT27
 set     CRC_GPOLY_HIGH_12           BIT28
 set     CRC_GPOLY_HIGH_13           BIT29
 set     CRC_GPOLY_HIGH_14           BIT30
 set     CRC_GPOLY_HIGH_15           BIT31

 set     CRC_CTRL_TCRC               BIT24
;;     0b0 ==> 16-bit CRC protocol.
;;     0b1 ==> 32-bit CRC protocol.

 set     CRC_CTRL_WAS                BIT25
;;   Write CRC data register as seed
;;     0b0 ==> Writes to the CRC data register are data values.
;;     0b1 ==> Writes to the CRC data register are seed values.

 set     CRC_CTRL_FXOR               BIT26
;;   Complement Read of CRC data register
;;     0b0 ==> No XOR on reading.
;;     0b1 ==> Invert or complement the read value of the CRC data register.

 set     CRC_CTRL_TOTR               (BIT28|BIT29)
;;   Type of Transpose for Read
;;     0b00 ==> No transposition.
;;     0b01 ==> Bits in bytes are transposed; bytes are not transposed.
;;     0b10 ==> Both bits in bytes and bytes are transposed.
;;     0b11 ==> Only bytes are transposed; no bits in a byte are transposed.
 set     CRC_CTRL_TOTR_0             BIT28
 set     CRC_CTRL_TOTR_1             BIT29

 set     CRC_CTRL_TOT                (BIT30|BIT31)
;;   Type of Transpose for Writes
;;     0b00 ==> No transposition.
;;     0b01 ==> Bits in bytes are transposed; bytes are not transposed.
;;     0b10 ==> Both bits in bytes and bytes are transposed.
;;     0b11 ==> Only bytes are transposed; no bits in a byte are transposed.
 set     CRC_CTRL_TOT_0              BIT30
 set     CRC_CTRL_TOT_1              BIT31

 set     DAC_CTRL0_PDN               BIT0
;;   Power Down
;;     0b0 ==> DAC is operational.
;;     0b1 ==> DAC is powered down. (default)

 set     DAC_CTRL0_FORMAT            BIT1
;;   Data Format
;;     0b0 ==> Data words are right justified. (default)
;;     0b1 ==> Data words are left justified.

 set     DAC_CTRL0_SYNC_EN           BIT2
;;   Sync Enable
;;     0b0 ==> Asynchronous mode. Data written to the buffered data register is presented to DAC inputs on the next clock cycle.
;;     0b1 ==> Synchronous mode. Rising edge of SYNC_IN updates data in the buffered data register presented to the DAC input.

 set     DAC_CTRL0_AUTO              BIT3
;;   Automatic Mode
;;     0b0 ==> Normal mode. Automatic waveform generation disabled.
;;     0b1 ==> Automatic waveform generation enabled.

 set     DAC_CTRL0_DOWN              BIT4
;;   Enable Down Counting
;;     0b0 ==> Down counting disabled.
;;     0b1 ==> Down counting enabled.

 set     DAC_CTRL0_UP                BIT5
;;   Enable Up Counting
;;     0b0 ==> Up counting disabled.
;;     0b1 ==> Up counting enabled.

 set     DAC_CTRL0_HSLS              BIT6
;;   High/Low Speed
;;     0b0 ==> High speed mode (default)
;;     0b1 ==> Low speed mode

 set     DAC_CTRL0_DMA_EN            BIT7
;;   Enable DMA Support
;;     0b0 ==> DMA support disabled (default)
;;     0b1 ==> DMA support enabled

 set     DAC_CTRL0_WTMK_LVL          (BIT8|BIT9)
;;   Watermark Level
;;     0b00 ==> Watermark value is 0
;;     0b01 ==> Watermark value is 2 (default)
;;     0b10 ==> Watermark value is 4
;;     0b11 ==> Watermark value is 6
 set     DAC_CTRL0_WTMK_LVL_0        BIT8
 set     DAC_CTRL0_WTMK_LVL_1        BIT9

 set     DAC_CTRL0_FILT_EN           BIT12
;;   Glitch Filter Enable
;;     0b0 ==> Filter disabled.
;;     0b1 ==> Filter enabled.

 set     DAC_DATAREG_FMT1_DATA       (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   DAC data (left justified)
 set     DAC_DATAREG_FMT1_DATA_0     BIT4
 set     DAC_DATAREG_FMT1_DATA_1     BIT5
 set     DAC_DATAREG_FMT1_DATA_2     BIT6
 set     DAC_DATAREG_FMT1_DATA_3     BIT7
 set     DAC_DATAREG_FMT1_DATA_4     BIT8
 set     DAC_DATAREG_FMT1_DATA_5     BIT9
 set     DAC_DATAREG_FMT1_DATA_6     BIT10
 set     DAC_DATAREG_FMT1_DATA_7     BIT11
 set     DAC_DATAREG_FMT1_DATA_8     BIT12
 set     DAC_DATAREG_FMT1_DATA_9     BIT13
 set     DAC_DATAREG_FMT1_DATA_10    BIT14
 set     DAC_DATAREG_FMT1_DATA_11    BIT15

 set     DAC_DATAREG_FMT0_DATA       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
;;   DAC data (right justified)
 set     DAC_DATAREG_FMT0_DATA_0     BIT0
 set     DAC_DATAREG_FMT0_DATA_1     BIT1
 set     DAC_DATAREG_FMT0_DATA_2     BIT2
 set     DAC_DATAREG_FMT0_DATA_3     BIT3
 set     DAC_DATAREG_FMT0_DATA_4     BIT4
 set     DAC_DATAREG_FMT0_DATA_5     BIT5
 set     DAC_DATAREG_FMT0_DATA_6     BIT6
 set     DAC_DATAREG_FMT0_DATA_7     BIT7
 set     DAC_DATAREG_FMT0_DATA_8     BIT8
 set     DAC_DATAREG_FMT0_DATA_9     BIT9
 set     DAC_DATAREG_FMT0_DATA_10    BIT10
 set     DAC_DATAREG_FMT0_DATA_11    BIT11

 set     DAC_STEPVAL_FMT0_STEP       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
;;   STEP size (right justified)
 set     DAC_STEPVAL_FMT0_STEP_0     BIT0
 set     DAC_STEPVAL_FMT0_STEP_1     BIT1
 set     DAC_STEPVAL_FMT0_STEP_2     BIT2
 set     DAC_STEPVAL_FMT0_STEP_3     BIT3
 set     DAC_STEPVAL_FMT0_STEP_4     BIT4
 set     DAC_STEPVAL_FMT0_STEP_5     BIT5
 set     DAC_STEPVAL_FMT0_STEP_6     BIT6
 set     DAC_STEPVAL_FMT0_STEP_7     BIT7
 set     DAC_STEPVAL_FMT0_STEP_8     BIT8
 set     DAC_STEPVAL_FMT0_STEP_9     BIT9
 set     DAC_STEPVAL_FMT0_STEP_10    BIT10
 set     DAC_STEPVAL_FMT0_STEP_11    BIT11

 set     DAC_STEPVAL_FMT1_STEP       (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   STEP size (left justified)
 set     DAC_STEPVAL_FMT1_STEP_0     BIT4
 set     DAC_STEPVAL_FMT1_STEP_1     BIT5
 set     DAC_STEPVAL_FMT1_STEP_2     BIT6
 set     DAC_STEPVAL_FMT1_STEP_3     BIT7
 set     DAC_STEPVAL_FMT1_STEP_4     BIT8
 set     DAC_STEPVAL_FMT1_STEP_5     BIT9
 set     DAC_STEPVAL_FMT1_STEP_6     BIT10
 set     DAC_STEPVAL_FMT1_STEP_7     BIT11
 set     DAC_STEPVAL_FMT1_STEP_8     BIT12
 set     DAC_STEPVAL_FMT1_STEP_9     BIT13
 set     DAC_STEPVAL_FMT1_STEP_10    BIT14
 set     DAC_STEPVAL_FMT1_STEP_11    BIT15

 set     DAC_MINVAL_FMT1_MINVAL      (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Minimum value (left justified)
 set     DAC_MINVAL_FMT1_MINVAL_0    BIT4
 set     DAC_MINVAL_FMT1_MINVAL_1    BIT5
 set     DAC_MINVAL_FMT1_MINVAL_2    BIT6
 set     DAC_MINVAL_FMT1_MINVAL_3    BIT7
 set     DAC_MINVAL_FMT1_MINVAL_4    BIT8
 set     DAC_MINVAL_FMT1_MINVAL_5    BIT9
 set     DAC_MINVAL_FMT1_MINVAL_6    BIT10
 set     DAC_MINVAL_FMT1_MINVAL_7    BIT11
 set     DAC_MINVAL_FMT1_MINVAL_8    BIT12
 set     DAC_MINVAL_FMT1_MINVAL_9    BIT13
 set     DAC_MINVAL_FMT1_MINVAL_10   BIT14
 set     DAC_MINVAL_FMT1_MINVAL_11   BIT15

 set     DAC_MINVAL_FMT0_MINVAL      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
;;   Minimum value (right justified)
 set     DAC_MINVAL_FMT0_MINVAL_0    BIT0
 set     DAC_MINVAL_FMT0_MINVAL_1    BIT1
 set     DAC_MINVAL_FMT0_MINVAL_2    BIT2
 set     DAC_MINVAL_FMT0_MINVAL_3    BIT3
 set     DAC_MINVAL_FMT0_MINVAL_4    BIT4
 set     DAC_MINVAL_FMT0_MINVAL_5    BIT5
 set     DAC_MINVAL_FMT0_MINVAL_6    BIT6
 set     DAC_MINVAL_FMT0_MINVAL_7    BIT7
 set     DAC_MINVAL_FMT0_MINVAL_8    BIT8
 set     DAC_MINVAL_FMT0_MINVAL_9    BIT9
 set     DAC_MINVAL_FMT0_MINVAL_10   BIT10
 set     DAC_MINVAL_FMT0_MINVAL_11   BIT11

 set     DAC_MAXVAL_FMT0_MAXVAL      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11)
;;   Maximum value (right justified)
 set     DAC_MAXVAL_FMT0_MAXVAL_0    BIT0
 set     DAC_MAXVAL_FMT0_MAXVAL_1    BIT1
 set     DAC_MAXVAL_FMT0_MAXVAL_2    BIT2
 set     DAC_MAXVAL_FMT0_MAXVAL_3    BIT3
 set     DAC_MAXVAL_FMT0_MAXVAL_4    BIT4
 set     DAC_MAXVAL_FMT0_MAXVAL_5    BIT5
 set     DAC_MAXVAL_FMT0_MAXVAL_6    BIT6
 set     DAC_MAXVAL_FMT0_MAXVAL_7    BIT7
 set     DAC_MAXVAL_FMT0_MAXVAL_8    BIT8
 set     DAC_MAXVAL_FMT0_MAXVAL_9    BIT9
 set     DAC_MAXVAL_FMT0_MAXVAL_10   BIT10
 set     DAC_MAXVAL_FMT0_MAXVAL_11   BIT11

 set     DAC_MAXVAL_FMT1_MAXVAL      (BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Maximum value (left justified)
 set     DAC_MAXVAL_FMT1_MAXVAL_0    BIT4
 set     DAC_MAXVAL_FMT1_MAXVAL_1    BIT5
 set     DAC_MAXVAL_FMT1_MAXVAL_2    BIT6
 set     DAC_MAXVAL_FMT1_MAXVAL_3    BIT7
 set     DAC_MAXVAL_FMT1_MAXVAL_4    BIT8
 set     DAC_MAXVAL_FMT1_MAXVAL_5    BIT9
 set     DAC_MAXVAL_FMT1_MAXVAL_6    BIT10
 set     DAC_MAXVAL_FMT1_MAXVAL_7    BIT11
 set     DAC_MAXVAL_FMT1_MAXVAL_8    BIT12
 set     DAC_MAXVAL_FMT1_MAXVAL_9    BIT13
 set     DAC_MAXVAL_FMT1_MAXVAL_10   BIT14
 set     DAC_MAXVAL_FMT1_MAXVAL_11   BIT15

 set     DAC_STATUS_EMPTY            BIT0
;;   Indicates empty status of FIFO
;;     0b0 ==> FIFO is not empty.
;;     0b1 ==> FIFO is empty (on reset).

 set     DAC_STATUS_FULL             BIT1
;;   Indicates full status of FIFO
;;     0b0 ==> FIFO is not full (on reset).
;;     0b1 ==> FIFO is full.

 set     DAC_CTRL1_FILT_CNT          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Glitch Filter Count
 set     DAC_CTRL1_FILT_CNT_0        BIT0
 set     DAC_CTRL1_FILT_CNT_1        BIT1
 set     DAC_CTRL1_FILT_CNT_2        BIT2
 set     DAC_CTRL1_FILT_CNT_3        BIT3
 set     DAC_CTRL1_FILT_CNT_4        BIT4
 set     DAC_CTRL1_FILT_CNT_5        BIT5

 set     DMA_REQC_DMAC3              (BIT0|BIT1|BIT2|BIT3)
;;   DMA channel 3
;;     0b0000 ==> Select request 0 as the source
;;     0b0001 ==> Select request 1 as the source
;;     0b0010 ==> Select request 2 as the source
;;     0b0011 ==> Select request 3 as the source
;;     0b0100 ==> Select request 4 as the source
;;     0b0101 ==> Select request 5 as the source
;;     0b0110 ==> Select request 6 as the source
;;     0b0111 ==> Select request 7 as the source
;;     0b1000 ==> Select request 8 as the source
;;     0b1001 ==> Select request 9 as the source
;;     0b1010 ==> Select request 10 as the source
;;     0b1011 ==> Select request 11 as the source
;;     0b1100 ==> Select request 12 as the source
;;     0b1101 ==> Select request 13 as the source
;;     0b1110 ==> Select request 14 as the source
;;     0b1111 ==> Select request 15 as the source
 set     DMA_REQC_DMAC3_0            BIT0
 set     DMA_REQC_DMAC3_1            BIT1
 set     DMA_REQC_DMAC3_2            BIT2
 set     DMA_REQC_DMAC3_3            BIT3

 set     DMA_REQC_CFSM3              BIT7
;;   Clear state machine control 3
;;     0b0 ==> No effect
;;     0b1 ==> Clear state machine for DMA channel 3

 set     DMA_REQC_DMAC2              (BIT8|BIT9|BIT10|BIT11)
;;   DMA channel 2
;;     0b0000 ==> Select request 0 as the source
;;     0b0001 ==> Select request 1 as the source
;;     0b0010 ==> Select request 2 as the source
;;     0b0011 ==> Select request 3 as the source
;;     0b0100 ==> Select request 4 as the source
;;     0b0101 ==> Select request 5 as the source
;;     0b0110 ==> Select request 6 as the source
;;     0b0111 ==> Select request 7 as the source
;;     0b1000 ==> Select request 8 as the source
;;     0b1001 ==> Select request 9 as the source
;;     0b1010 ==> Select request 10 as the source
;;     0b1011 ==> Select request 11 as the source
;;     0b1100 ==> Select request 12 as the source
;;     0b1101 ==> Select request 13 as the source
;;     0b1110 ==> Select request 14 as the source
;;     0b1111 ==> Select request 15 as the source
 set     DMA_REQC_DMAC2_0            BIT8
 set     DMA_REQC_DMAC2_1            BIT9
 set     DMA_REQC_DMAC2_2            BIT10
 set     DMA_REQC_DMAC2_3            BIT11

 set     DMA_REQC_CFSM2              BIT15
;;   Clear state machine control 2
;;     0b0 ==> No effect
;;     0b1 ==> Clear state machine for DMA channel 2

 set     DMA_REQC_DMAC1              (BIT16|BIT17|BIT18|BIT19)
;;   DMA channel 1
;;     0b0000 ==> Select request 0 as the source
;;     0b0001 ==> Select request 1 as the source
;;     0b0010 ==> Select request 2 as the source
;;     0b0011 ==> Select request 3 as the source
;;     0b0100 ==> Select request 4 as the source
;;     0b0101 ==> Select request 5 as the source
;;     0b0110 ==> Select request 6 as the source
;;     0b0111 ==> Select request 7 as the source
;;     0b1000 ==> Select request 8 as the source
;;     0b1001 ==> Select request 9 as the source
;;     0b1010 ==> Select request 10 as the source
;;     0b1011 ==> Select request 11 as the source
;;     0b1100 ==> Select request 12 as the source
;;     0b1101 ==> Select request 13 as the source
;;     0b1110 ==> Select request 14 as the source
;;     0b1111 ==> Select request 15 as the source
 set     DMA_REQC_DMAC1_0            BIT16
 set     DMA_REQC_DMAC1_1            BIT17
 set     DMA_REQC_DMAC1_2            BIT18
 set     DMA_REQC_DMAC1_3            BIT19

 set     DMA_REQC_CFSM1              BIT23
;;   Clear state machine control 1
;;     0b0 ==> No effect
;;     0b1 ==> Clear state machine for DMA channel 1

 set     DMA_REQC_DMAC0              (BIT24|BIT25|BIT26|BIT27)
;;   DMA channel 0
;;     0b0000 ==> Select request 0 as the source
;;     0b0001 ==> Select request 1 as the source
;;     0b0010 ==> Select request 2 as the source
;;     0b0011 ==> Select request 3 as the source
;;     0b0100 ==> Select request 4 as the source
;;     0b0101 ==> Select request 5 as the source
;;     0b0110 ==> Select request 6 as the source
;;     0b0111 ==> Select request 7 as the source
;;     0b1000 ==> Select request 8 as the source
;;     0b1001 ==> Select request 9 as the source
;;     0b1010 ==> Select request 10 as the source
;;     0b1011 ==> Select request 11 as the source
;;     0b1100 ==> Select request 12 as the source
;;     0b1101 ==> Select request 13 as the source
;;     0b1110 ==> Select request 14 as the source
;;     0b1111 ==> Select request 15 as the source
 set     DMA_REQC_DMAC0_0            BIT24
 set     DMA_REQC_DMAC0_1            BIT25
 set     DMA_REQC_DMAC0_2            BIT26
 set     DMA_REQC_DMAC0_3            BIT27

 set     DMA_REQC_CFSM0              BIT31
;;   Clear state machine control 0
;;     0b0 ==> No effect
;;     0b1 ==> Clear state machine for DMA channel 0

 set     DMA_SAR0_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_SAR0_SAR_0              BIT0
 set     DMA_SAR0_SAR_1              BIT1
 set     DMA_SAR0_SAR_2              BIT2
 set     DMA_SAR0_SAR_3              BIT3
 set     DMA_SAR0_SAR_4              BIT4
 set     DMA_SAR0_SAR_5              BIT5
 set     DMA_SAR0_SAR_6              BIT6
 set     DMA_SAR0_SAR_7              BIT7
 set     DMA_SAR0_SAR_8              BIT8
 set     DMA_SAR0_SAR_9              BIT9
 set     DMA_SAR0_SAR_10             BIT10
 set     DMA_SAR0_SAR_11             BIT11
 set     DMA_SAR0_SAR_12             BIT12
 set     DMA_SAR0_SAR_13             BIT13
 set     DMA_SAR0_SAR_14             BIT14
 set     DMA_SAR0_SAR_15             BIT15
 set     DMA_SAR0_SAR_16             BIT16
 set     DMA_SAR0_SAR_17             BIT17
 set     DMA_SAR0_SAR_18             BIT18
 set     DMA_SAR0_SAR_19             BIT19
 set     DMA_SAR0_SAR_20             BIT20
 set     DMA_SAR0_SAR_21             BIT21
 set     DMA_SAR0_SAR_22             BIT22
 set     DMA_SAR0_SAR_23             BIT23
 set     DMA_SAR0_SAR_24             BIT24
 set     DMA_SAR0_SAR_25             BIT25
 set     DMA_SAR0_SAR_26             BIT26
 set     DMA_SAR0_SAR_27             BIT27
 set     DMA_SAR0_SAR_28             BIT28
 set     DMA_SAR0_SAR_29             BIT29
 set     DMA_SAR0_SAR_30             BIT30
 set     DMA_SAR0_SAR_31             BIT31

 set     DMA_DAR0_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_DAR0_DAR_0              BIT0
 set     DMA_DAR0_DAR_1              BIT1
 set     DMA_DAR0_DAR_2              BIT2
 set     DMA_DAR0_DAR_3              BIT3
 set     DMA_DAR0_DAR_4              BIT4
 set     DMA_DAR0_DAR_5              BIT5
 set     DMA_DAR0_DAR_6              BIT6
 set     DMA_DAR0_DAR_7              BIT7
 set     DMA_DAR0_DAR_8              BIT8
 set     DMA_DAR0_DAR_9              BIT9
 set     DMA_DAR0_DAR_10             BIT10
 set     DMA_DAR0_DAR_11             BIT11
 set     DMA_DAR0_DAR_12             BIT12
 set     DMA_DAR0_DAR_13             BIT13
 set     DMA_DAR0_DAR_14             BIT14
 set     DMA_DAR0_DAR_15             BIT15
 set     DMA_DAR0_DAR_16             BIT16
 set     DMA_DAR0_DAR_17             BIT17
 set     DMA_DAR0_DAR_18             BIT18
 set     DMA_DAR0_DAR_19             BIT19
 set     DMA_DAR0_DAR_20             BIT20
 set     DMA_DAR0_DAR_21             BIT21
 set     DMA_DAR0_DAR_22             BIT22
 set     DMA_DAR0_DAR_23             BIT23
 set     DMA_DAR0_DAR_24             BIT24
 set     DMA_DAR0_DAR_25             BIT25
 set     DMA_DAR0_DAR_26             BIT26
 set     DMA_DAR0_DAR_27             BIT27
 set     DMA_DAR0_DAR_28             BIT28
 set     DMA_DAR0_DAR_29             BIT29
 set     DMA_DAR0_DAR_30             BIT30
 set     DMA_DAR0_DAR_31             BIT31

 set     DMA_DSR_BCR0_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
 set     DMA_DSR_BCR0_BCR_0          BIT0
 set     DMA_DSR_BCR0_BCR_1          BIT1
 set     DMA_DSR_BCR0_BCR_2          BIT2
 set     DMA_DSR_BCR0_BCR_3          BIT3
 set     DMA_DSR_BCR0_BCR_4          BIT4
 set     DMA_DSR_BCR0_BCR_5          BIT5
 set     DMA_DSR_BCR0_BCR_6          BIT6
 set     DMA_DSR_BCR0_BCR_7          BIT7
 set     DMA_DSR_BCR0_BCR_8          BIT8
 set     DMA_DSR_BCR0_BCR_9          BIT9
 set     DMA_DSR_BCR0_BCR_10         BIT10
 set     DMA_DSR_BCR0_BCR_11         BIT11
 set     DMA_DSR_BCR0_BCR_12         BIT12
 set     DMA_DSR_BCR0_BCR_13         BIT13
 set     DMA_DSR_BCR0_BCR_14         BIT14
 set     DMA_DSR_BCR0_BCR_15         BIT15
 set     DMA_DSR_BCR0_BCR_16         BIT16
 set     DMA_DSR_BCR0_BCR_17         BIT17
 set     DMA_DSR_BCR0_BCR_18         BIT18
 set     DMA_DSR_BCR0_BCR_19         BIT19
 set     DMA_DSR_BCR0_BCR_20         BIT20
 set     DMA_DSR_BCR0_BCR_21         BIT21
 set     DMA_DSR_BCR0_BCR_22         BIT22
 set     DMA_DSR_BCR0_BCR_23         BIT23

 set     DMA_DSR_BCR0_DONE           BIT24
;;   Transactions done
;;     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
;;     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

 set     DMA_DSR_BCR0_BSY            BIT25
;;   Busy
;;     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
;;     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

 set     DMA_DSR_BCR0_REQ            BIT26
;;   Request
;;     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
;;     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

 set     DMA_DSR_BCR0_BED            BIT28
;;   Bus error on destination
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

 set     DMA_DSR_BCR0_BES            BIT29
;;   Bus error on source
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

 set     DMA_DSR_BCR0_CE             BIT30
;;   Configuration error
;;     0b0 ==> No configuration error exists.
;;     0b1 ==> A configuration error has occurred.

 set     DMA_DCR0_LCH2               (BIT0|BIT1)
;;   Link channel 2
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR0_LCH2_0             BIT0
 set     DMA_DCR0_LCH2_1             BIT1

 set     DMA_DCR0_LCH1               (BIT2|BIT3)
;;   Link channel 1
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR0_LCH1_0             BIT2
 set     DMA_DCR0_LCH1_1             BIT3

 set     DMA_DCR0_LINKCC             (BIT4|BIT5)
;;   Link channel control
;;     0b00 ==> No channel-to-channel linking
;;     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
;;     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
;;     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
 set     DMA_DCR0_LINKCC_0           BIT4
 set     DMA_DCR0_LINKCC_1           BIT5

 set     DMA_DCR0_D_REQ              BIT7
;;   Disable request
;;     0b0 ==> ERQ bit is not affected.
;;     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

 set     DMA_DCR0_DMOD               (BIT8|BIT9|BIT10|BIT11)
;;   Destination address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR0_DMOD_0             BIT8
 set     DMA_DCR0_DMOD_1             BIT9
 set     DMA_DCR0_DMOD_2             BIT10
 set     DMA_DCR0_DMOD_3             BIT11

 set     DMA_DCR0_SMOD               (BIT12|BIT13|BIT14|BIT15)
;;   Source address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR0_SMOD_0             BIT12
 set     DMA_DCR0_SMOD_1             BIT13
 set     DMA_DCR0_SMOD_2             BIT14
 set     DMA_DCR0_SMOD_3             BIT15

 set     DMA_DCR0_START              BIT16
;;   Start transfer
;;     0b0 ==> DMA inactive
;;     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

 set     DMA_DCR0_DSIZE              (BIT17|BIT18)
;;   Destination size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR0_DSIZE_0            BIT17
 set     DMA_DCR0_DSIZE_1            BIT18

 set     DMA_DCR0_DINC               BIT19
;;   Destination increment
;;     0b0 ==> No change to the DAR after a successful transfer.
;;     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

 set     DMA_DCR0_SSIZE              (BIT20|BIT21)
;;   Source size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR0_SSIZE_0            BIT20
 set     DMA_DCR0_SSIZE_1            BIT21

 set     DMA_DCR0_SINC               BIT22
;;   Source increment
;;     0b0 ==> No change to SAR after a successful transfer.
;;     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

 set     DMA_DCR0_AA                 BIT28
;;   Auto-align
;;     0b0 ==> Auto-align disabled
;;     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

 set     DMA_DCR0_CS                 BIT29
;;   Cycle steal
;;     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
;;     0b1 ==> Forces a single read/write transfer per request.

 set     DMA_DCR0_ERQ                BIT30
;;   Enable peripheral request
;;     0b0 ==> Peripheral request is ignored.
;;     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

 set     DMA_DCR0_EINT               BIT31
;;   Enable interrupt on completion of transfer
;;     0b0 ==> No interrupt is generated.
;;     0b1 ==> Interrupt signal is enabled.

 set     DMA_SAR1_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_SAR1_SAR_0              BIT0
 set     DMA_SAR1_SAR_1              BIT1
 set     DMA_SAR1_SAR_2              BIT2
 set     DMA_SAR1_SAR_3              BIT3
 set     DMA_SAR1_SAR_4              BIT4
 set     DMA_SAR1_SAR_5              BIT5
 set     DMA_SAR1_SAR_6              BIT6
 set     DMA_SAR1_SAR_7              BIT7
 set     DMA_SAR1_SAR_8              BIT8
 set     DMA_SAR1_SAR_9              BIT9
 set     DMA_SAR1_SAR_10             BIT10
 set     DMA_SAR1_SAR_11             BIT11
 set     DMA_SAR1_SAR_12             BIT12
 set     DMA_SAR1_SAR_13             BIT13
 set     DMA_SAR1_SAR_14             BIT14
 set     DMA_SAR1_SAR_15             BIT15
 set     DMA_SAR1_SAR_16             BIT16
 set     DMA_SAR1_SAR_17             BIT17
 set     DMA_SAR1_SAR_18             BIT18
 set     DMA_SAR1_SAR_19             BIT19
 set     DMA_SAR1_SAR_20             BIT20
 set     DMA_SAR1_SAR_21             BIT21
 set     DMA_SAR1_SAR_22             BIT22
 set     DMA_SAR1_SAR_23             BIT23
 set     DMA_SAR1_SAR_24             BIT24
 set     DMA_SAR1_SAR_25             BIT25
 set     DMA_SAR1_SAR_26             BIT26
 set     DMA_SAR1_SAR_27             BIT27
 set     DMA_SAR1_SAR_28             BIT28
 set     DMA_SAR1_SAR_29             BIT29
 set     DMA_SAR1_SAR_30             BIT30
 set     DMA_SAR1_SAR_31             BIT31

 set     DMA_DAR1_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_DAR1_DAR_0              BIT0
 set     DMA_DAR1_DAR_1              BIT1
 set     DMA_DAR1_DAR_2              BIT2
 set     DMA_DAR1_DAR_3              BIT3
 set     DMA_DAR1_DAR_4              BIT4
 set     DMA_DAR1_DAR_5              BIT5
 set     DMA_DAR1_DAR_6              BIT6
 set     DMA_DAR1_DAR_7              BIT7
 set     DMA_DAR1_DAR_8              BIT8
 set     DMA_DAR1_DAR_9              BIT9
 set     DMA_DAR1_DAR_10             BIT10
 set     DMA_DAR1_DAR_11             BIT11
 set     DMA_DAR1_DAR_12             BIT12
 set     DMA_DAR1_DAR_13             BIT13
 set     DMA_DAR1_DAR_14             BIT14
 set     DMA_DAR1_DAR_15             BIT15
 set     DMA_DAR1_DAR_16             BIT16
 set     DMA_DAR1_DAR_17             BIT17
 set     DMA_DAR1_DAR_18             BIT18
 set     DMA_DAR1_DAR_19             BIT19
 set     DMA_DAR1_DAR_20             BIT20
 set     DMA_DAR1_DAR_21             BIT21
 set     DMA_DAR1_DAR_22             BIT22
 set     DMA_DAR1_DAR_23             BIT23
 set     DMA_DAR1_DAR_24             BIT24
 set     DMA_DAR1_DAR_25             BIT25
 set     DMA_DAR1_DAR_26             BIT26
 set     DMA_DAR1_DAR_27             BIT27
 set     DMA_DAR1_DAR_28             BIT28
 set     DMA_DAR1_DAR_29             BIT29
 set     DMA_DAR1_DAR_30             BIT30
 set     DMA_DAR1_DAR_31             BIT31

 set     DMA_DSR_BCR1_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
 set     DMA_DSR_BCR1_BCR_0          BIT0
 set     DMA_DSR_BCR1_BCR_1          BIT1
 set     DMA_DSR_BCR1_BCR_2          BIT2
 set     DMA_DSR_BCR1_BCR_3          BIT3
 set     DMA_DSR_BCR1_BCR_4          BIT4
 set     DMA_DSR_BCR1_BCR_5          BIT5
 set     DMA_DSR_BCR1_BCR_6          BIT6
 set     DMA_DSR_BCR1_BCR_7          BIT7
 set     DMA_DSR_BCR1_BCR_8          BIT8
 set     DMA_DSR_BCR1_BCR_9          BIT9
 set     DMA_DSR_BCR1_BCR_10         BIT10
 set     DMA_DSR_BCR1_BCR_11         BIT11
 set     DMA_DSR_BCR1_BCR_12         BIT12
 set     DMA_DSR_BCR1_BCR_13         BIT13
 set     DMA_DSR_BCR1_BCR_14         BIT14
 set     DMA_DSR_BCR1_BCR_15         BIT15
 set     DMA_DSR_BCR1_BCR_16         BIT16
 set     DMA_DSR_BCR1_BCR_17         BIT17
 set     DMA_DSR_BCR1_BCR_18         BIT18
 set     DMA_DSR_BCR1_BCR_19         BIT19
 set     DMA_DSR_BCR1_BCR_20         BIT20
 set     DMA_DSR_BCR1_BCR_21         BIT21
 set     DMA_DSR_BCR1_BCR_22         BIT22
 set     DMA_DSR_BCR1_BCR_23         BIT23

 set     DMA_DSR_BCR1_DONE           BIT24
;;   Transactions done
;;     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
;;     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

 set     DMA_DSR_BCR1_BSY            BIT25
;;   Busy
;;     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
;;     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

 set     DMA_DSR_BCR1_REQ            BIT26
;;   Request
;;     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
;;     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

 set     DMA_DSR_BCR1_BED            BIT28
;;   Bus error on destination
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

 set     DMA_DSR_BCR1_BES            BIT29
;;   Bus error on source
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

 set     DMA_DSR_BCR1_CE             BIT30
;;   Configuration error
;;     0b0 ==> No configuration error exists.
;;     0b1 ==> A configuration error has occurred.

 set     DMA_DCR1_LCH2               (BIT0|BIT1)
;;   Link channel 2
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR1_LCH2_0             BIT0
 set     DMA_DCR1_LCH2_1             BIT1

 set     DMA_DCR1_LCH1               (BIT2|BIT3)
;;   Link channel 1
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR1_LCH1_0             BIT2
 set     DMA_DCR1_LCH1_1             BIT3

 set     DMA_DCR1_LINKCC             (BIT4|BIT5)
;;   Link channel control
;;     0b00 ==> No channel-to-channel linking
;;     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
;;     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
;;     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
 set     DMA_DCR1_LINKCC_0           BIT4
 set     DMA_DCR1_LINKCC_1           BIT5

 set     DMA_DCR1_D_REQ              BIT7
;;   Disable request
;;     0b0 ==> ERQ bit is not affected.
;;     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

 set     DMA_DCR1_DMOD               (BIT8|BIT9|BIT10|BIT11)
;;   Destination address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR1_DMOD_0             BIT8
 set     DMA_DCR1_DMOD_1             BIT9
 set     DMA_DCR1_DMOD_2             BIT10
 set     DMA_DCR1_DMOD_3             BIT11

 set     DMA_DCR1_SMOD               (BIT12|BIT13|BIT14|BIT15)
;;   Source address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR1_SMOD_0             BIT12
 set     DMA_DCR1_SMOD_1             BIT13
 set     DMA_DCR1_SMOD_2             BIT14
 set     DMA_DCR1_SMOD_3             BIT15

 set     DMA_DCR1_START              BIT16
;;   Start transfer
;;     0b0 ==> DMA inactive
;;     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

 set     DMA_DCR1_DSIZE              (BIT17|BIT18)
;;   Destination size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR1_DSIZE_0            BIT17
 set     DMA_DCR1_DSIZE_1            BIT18

 set     DMA_DCR1_DINC               BIT19
;;   Destination increment
;;     0b0 ==> No change to the DAR after a successful transfer.
;;     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

 set     DMA_DCR1_SSIZE              (BIT20|BIT21)
;;   Source size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR1_SSIZE_0            BIT20
 set     DMA_DCR1_SSIZE_1            BIT21

 set     DMA_DCR1_SINC               BIT22
;;   Source increment
;;     0b0 ==> No change to SAR after a successful transfer.
;;     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

 set     DMA_DCR1_AA                 BIT28
;;   Auto-align
;;     0b0 ==> Auto-align disabled
;;     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

 set     DMA_DCR1_CS                 BIT29
;;   Cycle steal
;;     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
;;     0b1 ==> Forces a single read/write transfer per request.

 set     DMA_DCR1_ERQ                BIT30
;;   Enable peripheral request
;;     0b0 ==> Peripheral request is ignored.
;;     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

 set     DMA_DCR1_EINT               BIT31
;;   Enable interrupt on completion of transfer
;;     0b0 ==> No interrupt is generated.
;;     0b1 ==> Interrupt signal is enabled.

 set     DMA_SAR2_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_SAR2_SAR_0              BIT0
 set     DMA_SAR2_SAR_1              BIT1
 set     DMA_SAR2_SAR_2              BIT2
 set     DMA_SAR2_SAR_3              BIT3
 set     DMA_SAR2_SAR_4              BIT4
 set     DMA_SAR2_SAR_5              BIT5
 set     DMA_SAR2_SAR_6              BIT6
 set     DMA_SAR2_SAR_7              BIT7
 set     DMA_SAR2_SAR_8              BIT8
 set     DMA_SAR2_SAR_9              BIT9
 set     DMA_SAR2_SAR_10             BIT10
 set     DMA_SAR2_SAR_11             BIT11
 set     DMA_SAR2_SAR_12             BIT12
 set     DMA_SAR2_SAR_13             BIT13
 set     DMA_SAR2_SAR_14             BIT14
 set     DMA_SAR2_SAR_15             BIT15
 set     DMA_SAR2_SAR_16             BIT16
 set     DMA_SAR2_SAR_17             BIT17
 set     DMA_SAR2_SAR_18             BIT18
 set     DMA_SAR2_SAR_19             BIT19
 set     DMA_SAR2_SAR_20             BIT20
 set     DMA_SAR2_SAR_21             BIT21
 set     DMA_SAR2_SAR_22             BIT22
 set     DMA_SAR2_SAR_23             BIT23
 set     DMA_SAR2_SAR_24             BIT24
 set     DMA_SAR2_SAR_25             BIT25
 set     DMA_SAR2_SAR_26             BIT26
 set     DMA_SAR2_SAR_27             BIT27
 set     DMA_SAR2_SAR_28             BIT28
 set     DMA_SAR2_SAR_29             BIT29
 set     DMA_SAR2_SAR_30             BIT30
 set     DMA_SAR2_SAR_31             BIT31

 set     DMA_DAR2_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_DAR2_DAR_0              BIT0
 set     DMA_DAR2_DAR_1              BIT1
 set     DMA_DAR2_DAR_2              BIT2
 set     DMA_DAR2_DAR_3              BIT3
 set     DMA_DAR2_DAR_4              BIT4
 set     DMA_DAR2_DAR_5              BIT5
 set     DMA_DAR2_DAR_6              BIT6
 set     DMA_DAR2_DAR_7              BIT7
 set     DMA_DAR2_DAR_8              BIT8
 set     DMA_DAR2_DAR_9              BIT9
 set     DMA_DAR2_DAR_10             BIT10
 set     DMA_DAR2_DAR_11             BIT11
 set     DMA_DAR2_DAR_12             BIT12
 set     DMA_DAR2_DAR_13             BIT13
 set     DMA_DAR2_DAR_14             BIT14
 set     DMA_DAR2_DAR_15             BIT15
 set     DMA_DAR2_DAR_16             BIT16
 set     DMA_DAR2_DAR_17             BIT17
 set     DMA_DAR2_DAR_18             BIT18
 set     DMA_DAR2_DAR_19             BIT19
 set     DMA_DAR2_DAR_20             BIT20
 set     DMA_DAR2_DAR_21             BIT21
 set     DMA_DAR2_DAR_22             BIT22
 set     DMA_DAR2_DAR_23             BIT23
 set     DMA_DAR2_DAR_24             BIT24
 set     DMA_DAR2_DAR_25             BIT25
 set     DMA_DAR2_DAR_26             BIT26
 set     DMA_DAR2_DAR_27             BIT27
 set     DMA_DAR2_DAR_28             BIT28
 set     DMA_DAR2_DAR_29             BIT29
 set     DMA_DAR2_DAR_30             BIT30
 set     DMA_DAR2_DAR_31             BIT31

 set     DMA_DSR_BCR2_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
 set     DMA_DSR_BCR2_BCR_0          BIT0
 set     DMA_DSR_BCR2_BCR_1          BIT1
 set     DMA_DSR_BCR2_BCR_2          BIT2
 set     DMA_DSR_BCR2_BCR_3          BIT3
 set     DMA_DSR_BCR2_BCR_4          BIT4
 set     DMA_DSR_BCR2_BCR_5          BIT5
 set     DMA_DSR_BCR2_BCR_6          BIT6
 set     DMA_DSR_BCR2_BCR_7          BIT7
 set     DMA_DSR_BCR2_BCR_8          BIT8
 set     DMA_DSR_BCR2_BCR_9          BIT9
 set     DMA_DSR_BCR2_BCR_10         BIT10
 set     DMA_DSR_BCR2_BCR_11         BIT11
 set     DMA_DSR_BCR2_BCR_12         BIT12
 set     DMA_DSR_BCR2_BCR_13         BIT13
 set     DMA_DSR_BCR2_BCR_14         BIT14
 set     DMA_DSR_BCR2_BCR_15         BIT15
 set     DMA_DSR_BCR2_BCR_16         BIT16
 set     DMA_DSR_BCR2_BCR_17         BIT17
 set     DMA_DSR_BCR2_BCR_18         BIT18
 set     DMA_DSR_BCR2_BCR_19         BIT19
 set     DMA_DSR_BCR2_BCR_20         BIT20
 set     DMA_DSR_BCR2_BCR_21         BIT21
 set     DMA_DSR_BCR2_BCR_22         BIT22
 set     DMA_DSR_BCR2_BCR_23         BIT23

 set     DMA_DSR_BCR2_DONE           BIT24
;;   Transactions done
;;     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
;;     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

 set     DMA_DSR_BCR2_BSY            BIT25
;;   Busy
;;     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
;;     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

 set     DMA_DSR_BCR2_REQ            BIT26
;;   Request
;;     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
;;     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

 set     DMA_DSR_BCR2_BED            BIT28
;;   Bus error on destination
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

 set     DMA_DSR_BCR2_BES            BIT29
;;   Bus error on source
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

 set     DMA_DSR_BCR2_CE             BIT30
;;   Configuration error
;;     0b0 ==> No configuration error exists.
;;     0b1 ==> A configuration error has occurred.

 set     DMA_DCR2_LCH2               (BIT0|BIT1)
;;   Link channel 2
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR2_LCH2_0             BIT0
 set     DMA_DCR2_LCH2_1             BIT1

 set     DMA_DCR2_LCH1               (BIT2|BIT3)
;;   Link channel 1
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR2_LCH1_0             BIT2
 set     DMA_DCR2_LCH1_1             BIT3

 set     DMA_DCR2_LINKCC             (BIT4|BIT5)
;;   Link channel control
;;     0b00 ==> No channel-to-channel linking
;;     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
;;     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
;;     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
 set     DMA_DCR2_LINKCC_0           BIT4
 set     DMA_DCR2_LINKCC_1           BIT5

 set     DMA_DCR2_D_REQ              BIT7
;;   Disable request
;;     0b0 ==> ERQ bit is not affected.
;;     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

 set     DMA_DCR2_DMOD               (BIT8|BIT9|BIT10|BIT11)
;;   Destination address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR2_DMOD_0             BIT8
 set     DMA_DCR2_DMOD_1             BIT9
 set     DMA_DCR2_DMOD_2             BIT10
 set     DMA_DCR2_DMOD_3             BIT11

 set     DMA_DCR2_SMOD               (BIT12|BIT13|BIT14|BIT15)
;;   Source address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR2_SMOD_0             BIT12
 set     DMA_DCR2_SMOD_1             BIT13
 set     DMA_DCR2_SMOD_2             BIT14
 set     DMA_DCR2_SMOD_3             BIT15

 set     DMA_DCR2_START              BIT16
;;   Start transfer
;;     0b0 ==> DMA inactive
;;     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

 set     DMA_DCR2_DSIZE              (BIT17|BIT18)
;;   Destination size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR2_DSIZE_0            BIT17
 set     DMA_DCR2_DSIZE_1            BIT18

 set     DMA_DCR2_DINC               BIT19
;;   Destination increment
;;     0b0 ==> No change to the DAR after a successful transfer.
;;     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

 set     DMA_DCR2_SSIZE              (BIT20|BIT21)
;;   Source size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR2_SSIZE_0            BIT20
 set     DMA_DCR2_SSIZE_1            BIT21

 set     DMA_DCR2_SINC               BIT22
;;   Source increment
;;     0b0 ==> No change to SAR after a successful transfer.
;;     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

 set     DMA_DCR2_AA                 BIT28
;;   Auto-align
;;     0b0 ==> Auto-align disabled
;;     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

 set     DMA_DCR2_CS                 BIT29
;;   Cycle steal
;;     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
;;     0b1 ==> Forces a single read/write transfer per request.

 set     DMA_DCR2_ERQ                BIT30
;;   Enable peripheral request
;;     0b0 ==> Peripheral request is ignored.
;;     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

 set     DMA_DCR2_EINT               BIT31
;;   Enable interrupt on completion of transfer
;;     0b0 ==> No interrupt is generated.
;;     0b1 ==> Interrupt signal is enabled.

 set     DMA_SAR3_SAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_SAR3_SAR_0              BIT0
 set     DMA_SAR3_SAR_1              BIT1
 set     DMA_SAR3_SAR_2              BIT2
 set     DMA_SAR3_SAR_3              BIT3
 set     DMA_SAR3_SAR_4              BIT4
 set     DMA_SAR3_SAR_5              BIT5
 set     DMA_SAR3_SAR_6              BIT6
 set     DMA_SAR3_SAR_7              BIT7
 set     DMA_SAR3_SAR_8              BIT8
 set     DMA_SAR3_SAR_9              BIT9
 set     DMA_SAR3_SAR_10             BIT10
 set     DMA_SAR3_SAR_11             BIT11
 set     DMA_SAR3_SAR_12             BIT12
 set     DMA_SAR3_SAR_13             BIT13
 set     DMA_SAR3_SAR_14             BIT14
 set     DMA_SAR3_SAR_15             BIT15
 set     DMA_SAR3_SAR_16             BIT16
 set     DMA_SAR3_SAR_17             BIT17
 set     DMA_SAR3_SAR_18             BIT18
 set     DMA_SAR3_SAR_19             BIT19
 set     DMA_SAR3_SAR_20             BIT20
 set     DMA_SAR3_SAR_21             BIT21
 set     DMA_SAR3_SAR_22             BIT22
 set     DMA_SAR3_SAR_23             BIT23
 set     DMA_SAR3_SAR_24             BIT24
 set     DMA_SAR3_SAR_25             BIT25
 set     DMA_SAR3_SAR_26             BIT26
 set     DMA_SAR3_SAR_27             BIT27
 set     DMA_SAR3_SAR_28             BIT28
 set     DMA_SAR3_SAR_29             BIT29
 set     DMA_SAR3_SAR_30             BIT30
 set     DMA_SAR3_SAR_31             BIT31

 set     DMA_DAR3_DAR                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
 set     DMA_DAR3_DAR_0              BIT0
 set     DMA_DAR3_DAR_1              BIT1
 set     DMA_DAR3_DAR_2              BIT2
 set     DMA_DAR3_DAR_3              BIT3
 set     DMA_DAR3_DAR_4              BIT4
 set     DMA_DAR3_DAR_5              BIT5
 set     DMA_DAR3_DAR_6              BIT6
 set     DMA_DAR3_DAR_7              BIT7
 set     DMA_DAR3_DAR_8              BIT8
 set     DMA_DAR3_DAR_9              BIT9
 set     DMA_DAR3_DAR_10             BIT10
 set     DMA_DAR3_DAR_11             BIT11
 set     DMA_DAR3_DAR_12             BIT12
 set     DMA_DAR3_DAR_13             BIT13
 set     DMA_DAR3_DAR_14             BIT14
 set     DMA_DAR3_DAR_15             BIT15
 set     DMA_DAR3_DAR_16             BIT16
 set     DMA_DAR3_DAR_17             BIT17
 set     DMA_DAR3_DAR_18             BIT18
 set     DMA_DAR3_DAR_19             BIT19
 set     DMA_DAR3_DAR_20             BIT20
 set     DMA_DAR3_DAR_21             BIT21
 set     DMA_DAR3_DAR_22             BIT22
 set     DMA_DAR3_DAR_23             BIT23
 set     DMA_DAR3_DAR_24             BIT24
 set     DMA_DAR3_DAR_25             BIT25
 set     DMA_DAR3_DAR_26             BIT26
 set     DMA_DAR3_DAR_27             BIT27
 set     DMA_DAR3_DAR_28             BIT28
 set     DMA_DAR3_DAR_29             BIT29
 set     DMA_DAR3_DAR_30             BIT30
 set     DMA_DAR3_DAR_31             BIT31

 set     DMA_DSR_BCR3_BCR            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
 set     DMA_DSR_BCR3_BCR_0          BIT0
 set     DMA_DSR_BCR3_BCR_1          BIT1
 set     DMA_DSR_BCR3_BCR_2          BIT2
 set     DMA_DSR_BCR3_BCR_3          BIT3
 set     DMA_DSR_BCR3_BCR_4          BIT4
 set     DMA_DSR_BCR3_BCR_5          BIT5
 set     DMA_DSR_BCR3_BCR_6          BIT6
 set     DMA_DSR_BCR3_BCR_7          BIT7
 set     DMA_DSR_BCR3_BCR_8          BIT8
 set     DMA_DSR_BCR3_BCR_9          BIT9
 set     DMA_DSR_BCR3_BCR_10         BIT10
 set     DMA_DSR_BCR3_BCR_11         BIT11
 set     DMA_DSR_BCR3_BCR_12         BIT12
 set     DMA_DSR_BCR3_BCR_13         BIT13
 set     DMA_DSR_BCR3_BCR_14         BIT14
 set     DMA_DSR_BCR3_BCR_15         BIT15
 set     DMA_DSR_BCR3_BCR_16         BIT16
 set     DMA_DSR_BCR3_BCR_17         BIT17
 set     DMA_DSR_BCR3_BCR_18         BIT18
 set     DMA_DSR_BCR3_BCR_19         BIT19
 set     DMA_DSR_BCR3_BCR_20         BIT20
 set     DMA_DSR_BCR3_BCR_21         BIT21
 set     DMA_DSR_BCR3_BCR_22         BIT22
 set     DMA_DSR_BCR3_BCR_23         BIT23

 set     DMA_DSR_BCR3_DONE           BIT24
;;   Transactions done
;;     0b0 ==> DMA transfer is not yet complete. Writing a 0 has no effect.
;;     0b1 ==> DMA transfer completed. Writing a 1 to this bit clears all DMA status bits and should be used in an interrupt service routine to clear the DMA interrupt and error bits.

 set     DMA_DSR_BCR3_BSY            BIT25
;;   Busy
;;     0b0 ==> DMA channel is inactive. Cleared when the DMA has finished the last transaction.
;;     0b1 ==> BSY is set the first time the channel is enabled after a transfer is initiated.

 set     DMA_DSR_BCR3_REQ            BIT26
;;   Request
;;     0b0 ==> No request is pending or the channel is currently active. Cleared when the channel is selected.
;;     0b1 ==> The DMA channel has a transfer remaining and the channel is not selected.

 set     DMA_DSR_BCR3_BED            BIT28
;;   Bus error on destination
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the write portion of a transfer.

 set     DMA_DSR_BCR3_BES            BIT29
;;   Bus error on source
;;     0b0 ==> No bus error occurred.
;;     0b1 ==> The DMA channel terminated with a bus error during the read portion of a transfer.

 set     DMA_DSR_BCR3_CE             BIT30
;;   Configuration error
;;     0b0 ==> No configuration error exists.
;;     0b1 ==> A configuration error has occurred.

 set     DMA_DCR3_LCH2               (BIT0|BIT1)
;;   Link channel 2
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR3_LCH2_0             BIT0
 set     DMA_DCR3_LCH2_1             BIT1

 set     DMA_DCR3_LCH1               (BIT2|BIT3)
;;   Link channel 1
;;     0b00 ==> DMA Channel 0
;;     0b01 ==> DMA Channel 1
;;     0b10 ==> DMA Channel 2
;;     0b11 ==> DMA Channel 3
 set     DMA_DCR3_LCH1_0             BIT2
 set     DMA_DCR3_LCH1_1             BIT3

 set     DMA_DCR3_LINKCC             (BIT4|BIT5)
;;   Link channel control
;;     0b00 ==> No channel-to-channel linking
;;     0b01 ==> Perform a link to channel LCH1 after each cycle-steal transfer followed by a link to LCH2 after the BCR decrements to zero
;;     0b10 ==> Perform a link to channel LCH1 after each cycle-steal transfer
;;     0b11 ==> Perform a link to channel LCH1 after the BCR decrements to zero
 set     DMA_DCR3_LINKCC_0           BIT4
 set     DMA_DCR3_LINKCC_1           BIT5

 set     DMA_DCR3_D_REQ              BIT7
;;   Disable request
;;     0b0 ==> ERQ bit is not affected.
;;     0b1 ==> ERQ bit is cleared when the BCR is exhausted.

 set     DMA_DCR3_DMOD               (BIT8|BIT9|BIT10|BIT11)
;;   Destination address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR3_DMOD_0             BIT8
 set     DMA_DCR3_DMOD_1             BIT9
 set     DMA_DCR3_DMOD_2             BIT10
 set     DMA_DCR3_DMOD_3             BIT11

 set     DMA_DCR3_SMOD               (BIT12|BIT13|BIT14|BIT15)
;;   Source address modulo
;;     0b0000 ==> Buffer disabled
;;     0b0001 ==> Circular buffer size is 16 bytes
;;     0b0010 ==> Circular buffer size is 32 bytes
;;     0b0011 ==> Circular buffer size is 64 bytes
;;     0b0100 ==> Circular buffer size is 128 bytes
;;     0b0101 ==> Circular buffer size is 256 bytes
;;     0b0110 ==> Circular buffer size is 512 bytes
;;     0b0111 ==> Circular buffer size is 1 KB
;;     0b1000 ==> Circular buffer size is 2 KB
;;     0b1001 ==> Circular buffer size is 4 KB
;;     0b1010 ==> Circular buffer size is 8 KB
;;     0b1011 ==> Circular buffer size is 16 KB
;;     0b1100 ==> Circular buffer size is 32 KB
;;     0b1101 ==> Circular buffer size is 64 KB
;;     0b1110 ==> Circular buffer size is 128 KB
;;     0b1111 ==> Circular buffer size is 256 KB
 set     DMA_DCR3_SMOD_0             BIT12
 set     DMA_DCR3_SMOD_1             BIT13
 set     DMA_DCR3_SMOD_2             BIT14
 set     DMA_DCR3_SMOD_3             BIT15

 set     DMA_DCR3_START              BIT16
;;   Start transfer
;;     0b0 ==> DMA inactive
;;     0b1 ==> The DMA begins the transfer in accordance to the values in the TCDn. START is cleared automatically after one module clock and always reads as logic 0.

 set     DMA_DCR3_DSIZE              (BIT17|BIT18)
;;   Destination size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR3_DSIZE_0            BIT17
 set     DMA_DCR3_DSIZE_1            BIT18

 set     DMA_DCR3_DINC               BIT19
;;   Destination increment
;;     0b0 ==> No change to the DAR after a successful transfer.
;;     0b1 ==> The DAR increments by 1, 2, 4 depending upon the size of the transfer.

 set     DMA_DCR3_SSIZE              (BIT20|BIT21)
;;   Source size
;;     0b00 ==> Longword
;;     0b01 ==> Byte
;;     0b10 ==> Word
;;     0b11 ==> Reserved (generates a configuration error (DSRn[CE]) if incorrectly specified at time of channel activation)
 set     DMA_DCR3_SSIZE_0            BIT20
 set     DMA_DCR3_SSIZE_1            BIT21

 set     DMA_DCR3_SINC               BIT22
;;   Source increment
;;     0b0 ==> No change to SAR after a successful transfer.
;;     0b1 ==> The SAR increments by 1, 2, 4 as determined by the transfer size.

 set     DMA_DCR3_AA                 BIT28
;;   Auto-align
;;     0b0 ==> Auto-align disabled
;;     0b1 ==> If SSIZE indicates a transfer no smaller than DSIZE, source accesses are auto-aligned; otherwise, destination accesses are auto-aligned. Source alignment takes precedence over destination alignment. If auto-alignment is enabled, the appropriate address register increments, regardless of DINC or SINC.

 set     DMA_DCR3_CS                 BIT29
;;   Cycle steal
;;     0b0 ==> DMA continuously makes read/write transfers until the BCR decrements to 0.
;;     0b1 ==> Forces a single read/write transfer per request.

 set     DMA_DCR3_ERQ                BIT30
;;   Enable peripheral request
;;     0b0 ==> Peripheral request is ignored.
;;     0b1 ==> Enables peripheral request, defined by the appropriate REQC[DMACn] field, to initiate transfer. A software-initiated request (setting the START bit) is always enabled.

 set     DMA_DCR3_EINT               BIT31
;;   Enable interrupt on completion of transfer
;;     0b0 ==> No interrupt is generated.
;;     0b1 ==> Interrupt signal is enabled.

 set     EWM_CTRL_EWMEN              BIT0
;;   EWM enable.

 set     EWM_CTRL_ASSIN              BIT1
;;   EWM_in's Assertion State Select.

 set     EWM_CTRL_INEN               BIT2
;;   Input Enable.

 set     EWM_CTRL_INTEN              BIT3
;;   Interrupt Enable.

 set     EWM_SERV_SERVICE            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_SERV_SERVICE_0          BIT0
 set     EWM_SERV_SERVICE_1          BIT1
 set     EWM_SERV_SERVICE_2          BIT2
 set     EWM_SERV_SERVICE_3          BIT3
 set     EWM_SERV_SERVICE_4          BIT4
 set     EWM_SERV_SERVICE_5          BIT5
 set     EWM_SERV_SERVICE_6          BIT6
 set     EWM_SERV_SERVICE_7          BIT7

 set     EWM_CMPL_COMPAREL           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_CMPL_COMPAREL_0         BIT0
 set     EWM_CMPL_COMPAREL_1         BIT1
 set     EWM_CMPL_COMPAREL_2         BIT2
 set     EWM_CMPL_COMPAREL_3         BIT3
 set     EWM_CMPL_COMPAREL_4         BIT4
 set     EWM_CMPL_COMPAREL_5         BIT5
 set     EWM_CMPL_COMPAREL_6         BIT6
 set     EWM_CMPL_COMPAREL_7         BIT7

 set     EWM_CMPH_COMPAREH           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_CMPH_COMPAREH_0         BIT0
 set     EWM_CMPH_COMPAREH_1         BIT1
 set     EWM_CMPH_COMPAREH_2         BIT2
 set     EWM_CMPH_COMPAREH_3         BIT3
 set     EWM_CMPH_COMPAREH_4         BIT4
 set     EWM_CMPH_COMPAREH_5         BIT5
 set     EWM_CMPH_COMPAREH_6         BIT6
 set     EWM_CMPH_COMPAREH_7         BIT7

 set     EWM_CLKCTRL_CLKSEL          (BIT0|BIT1)
 set     EWM_CLKCTRL_CLKSEL_0        BIT0
 set     EWM_CLKCTRL_CLKSEL_1        BIT1

 set     EWM_CLKPRESCALER_CLK_DIV    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     EWM_CLKPRESCALER_CLK_DIV_0  BIT0
 set     EWM_CLKPRESCALER_CLK_DIV_1  BIT1
 set     EWM_CLKPRESCALER_CLK_DIV_2  BIT2
 set     EWM_CLKPRESCALER_CLK_DIV_3  BIT3
 set     EWM_CLKPRESCALER_CLK_DIV_4  BIT4
 set     EWM_CLKPRESCALER_CLK_DIV_5  BIT5
 set     EWM_CLKPRESCALER_CLK_DIV_6  BIT6
 set     EWM_CLKPRESCALER_CLK_DIV_7  BIT7

 set     FMC_PFAPR_M0AP              (BIT0|BIT1)
;;   Master 0 Access Protection
;;     0b00 ==> No access may be performed by this master
;;     0b01 ==> Only read accesses may be performed by this master
;;     0b10 ==> Only write accesses may be performed by this master
;;     0b11 ==> Both read and write accesses may be performed by this master
 set     FMC_PFAPR_M0AP_0            BIT0
 set     FMC_PFAPR_M0AP_1            BIT1

 set     FMC_PFAPR_M1AP              (BIT2|BIT3)
;;   Master 1 Access Protection
;;     0b00 ==> No access may be performed by this master
;;     0b01 ==> Only read accesses may be performed by this master
;;     0b10 ==> Only write accesses may be performed by this master
;;     0b11 ==> Both read and write accesses may be performed by this master
 set     FMC_PFAPR_M1AP_0            BIT2
 set     FMC_PFAPR_M1AP_1            BIT3

 set     FMC_PFAPR_M2AP              (BIT4|BIT5)
;;   Master 2 Access Protection
;;     0b00 ==> No access may be performed by this master
;;     0b01 ==> Only read accesses may be performed by this master
;;     0b10 ==> Only write accesses may be performed by this master
;;     0b11 ==> Both read and write accesses may be performed by this master
 set     FMC_PFAPR_M2AP_0            BIT4
 set     FMC_PFAPR_M2AP_1            BIT5

 set     FMC_PFAPR_M3AP              (BIT6|BIT7)
;;   Master 3 Access Protection
;;     0b00 ==> No access may be performed by this master
;;     0b01 ==> Only read accesses may be performed by this master
;;     0b10 ==> Only write accesses may be performed by this master
;;     0b11 ==> Both read and write accesses may be performed by this master
 set     FMC_PFAPR_M3AP_0            BIT6
 set     FMC_PFAPR_M3AP_1            BIT7

 set     FMC_PFAPR_M0PFD             BIT16
;;   Master 0 Prefetch Disable
;;     0b0 ==> Prefetching for this master is enabled.
;;     0b1 ==> Prefetching for this master is disabled.

 set     FMC_PFAPR_M1PFD             BIT17
;;   Master 1 Prefetch Disable
;;     0b0 ==> Prefetching for this master is enabled.
;;     0b1 ==> Prefetching for this master is disabled.

 set     FMC_PFAPR_M2PFD             BIT18
;;   Master 2 Prefetch Disable
;;     0b0 ==> Prefetching for this master is enabled.
;;     0b1 ==> Prefetching for this master is disabled.

 set     FMC_PFAPR_M3PFD             BIT19
;;   Master 3 Prefetch Disable
;;     0b0 ==> Prefetching for this master is enabled.
;;     0b1 ==> Prefetching for this master is disabled.

 set     FMC_PFB0CR_B0SEBE           BIT0
;;   Bank 0 Single Entry Buffer Enable
;;     0b0 ==> Single entry buffer is disabled.
;;     0b1 ==> Single entry buffer is enabled.

 set     FMC_PFB0CR_B0IPE            BIT1
;;   Bank 0 Instruction Prefetch Enable
;;     0b0 ==> Do not prefetch in response to instruction fetches.
;;     0b1 ==> Enable prefetches in response to instruction fetches.

 set     FMC_PFB0CR_B0DPE            BIT2
;;   Bank 0 Data Prefetch Enable
;;     0b0 ==> Do not prefetch in response to data references.
;;     0b1 ==> Enable prefetches in response to data references.

 set     FMC_PFB0CR_B0ICE            BIT3
;;   Bank 0 Instruction Cache Enable
;;     0b0 ==> Do not cache instruction fetches.
;;     0b1 ==> Cache instruction fetches.

 set     FMC_PFB0CR_B0DCE            BIT4
;;   Bank 0 Data Cache Enable
;;     0b0 ==> Do not cache data references.
;;     0b1 ==> Cache data references.

 set     FMC_PFB0CR_CRC              (BIT5|BIT6|BIT7)
;;   Cache Replacement Control
;;     0b000 ==> LRU replacement algorithm per set across all four ways
;;     0b001 ==> Reserved
;;     0b010 ==> Independent LRU with ways [0-1] for ifetches, [2-3] for data
;;     0b011 ==> Independent LRU with ways [0-2] for ifetches, [3] for data
;;     0b1xx ==> Reserved
 set     FMC_PFB0CR_CRC_0            BIT5
 set     FMC_PFB0CR_CRC_1            BIT6
 set     FMC_PFB0CR_CRC_2            BIT7

 set     FMC_PFB0CR_B0MW             (BIT17|BIT18)
;;   Bank 0 Memory Width
;;     0b00 ==> 32 bits
;;     0b01 ==> 64 bits
;;     0b1x ==> Reserved
 set     FMC_PFB0CR_B0MW_0           BIT17
 set     FMC_PFB0CR_B0MW_1           BIT18

 set     FMC_PFB0CR_S_B_INV          BIT19
;;   Invalidate Prefetch Speculation Buffer
;;     0b0 ==> Speculation buffer and single entry buffer are not affected.
;;     0b1 ==> Invalidate (clear) speculation buffer and single entry buffer.

 set     FMC_PFB0CR_CINV_WAY         (BIT20|BIT21|BIT22|BIT23)
;;   Cache Invalidate Way x
;;     0b0 ==> No cache way invalidation for the corresponding cache
;;     0b1 ==> Invalidate cache way for the corresponding cache: clear the tag, data, and vld bits of ways selected
 set     FMC_PFB0CR_CINV_WAY_0       BIT20
 set     FMC_PFB0CR_CINV_WAY_1       BIT21
 set     FMC_PFB0CR_CINV_WAY_2       BIT22
 set     FMC_PFB0CR_CINV_WAY_3       BIT23

 set     FMC_PFB0CR_CLCK_WAY         (BIT24|BIT25|BIT26|BIT27)
;;   Cache Lock Way x
;;     0b0 ==> Cache way is unlocked and may be displaced
;;     0b1 ==> Cache way is locked and its contents are not displaced
 set     FMC_PFB0CR_CLCK_WAY_0       BIT24
 set     FMC_PFB0CR_CLCK_WAY_1       BIT25
 set     FMC_PFB0CR_CLCK_WAY_2       BIT26
 set     FMC_PFB0CR_CLCK_WAY_3       BIT27

 set     FMC_PFB0CR_B0RWSC           (BIT28|BIT29|BIT30|BIT31)
;;   Bank 0 Read Wait State Control
 set     FMC_PFB0CR_B0RWSC_0         BIT28
 set     FMC_PFB0CR_B0RWSC_1         BIT29
 set     FMC_PFB0CR_B0RWSC_2         BIT30
 set     FMC_PFB0CR_B0RWSC_3         BIT31

 set     FMC_PFB1CR_B1MW             (BIT17|BIT18)
;;   Bank 1 Memory Width
;;     0b00 ==> 32 bits
;;     0b01 ==> 64 bits
;;     0b10 ==> Reserved
;;     0b11 ==> Reserved
 set     FMC_PFB1CR_B1MW_0           BIT17
 set     FMC_PFB1CR_B1MW_1           BIT18

 set     FMC_PFB1CR_B1RWSC           (BIT28|BIT29|BIT30|BIT31)
;;   Bank 1 Read Wait State Control
 set     FMC_PFB1CR_B1RWSC_0         BIT28
 set     FMC_PFB1CR_B1RWSC_1         BIT29
 set     FMC_PFB1CR_B1RWSC_2         BIT30
 set     FMC_PFB1CR_B1RWSC_3         BIT31

 set     FMC_TAGVDW0S0_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S0_tag_0         BIT6
 set     FMC_TAGVDW0S0_tag_1         BIT7
 set     FMC_TAGVDW0S0_tag_2         BIT8
 set     FMC_TAGVDW0S0_tag_3         BIT9
 set     FMC_TAGVDW0S0_tag_4         BIT10
 set     FMC_TAGVDW0S0_tag_5         BIT11
 set     FMC_TAGVDW0S0_tag_6         BIT12
 set     FMC_TAGVDW0S0_tag_7         BIT13
 set     FMC_TAGVDW0S0_tag_8         BIT14
 set     FMC_TAGVDW0S0_tag_9         BIT15
 set     FMC_TAGVDW0S0_tag_10        BIT16
 set     FMC_TAGVDW0S0_tag_11        BIT17
 set     FMC_TAGVDW0S0_tag_12        BIT18

 set     FMC_TAGVDW0S1_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S1_tag_0         BIT6
 set     FMC_TAGVDW0S1_tag_1         BIT7
 set     FMC_TAGVDW0S1_tag_2         BIT8
 set     FMC_TAGVDW0S1_tag_3         BIT9
 set     FMC_TAGVDW0S1_tag_4         BIT10
 set     FMC_TAGVDW0S1_tag_5         BIT11
 set     FMC_TAGVDW0S1_tag_6         BIT12
 set     FMC_TAGVDW0S1_tag_7         BIT13
 set     FMC_TAGVDW0S1_tag_8         BIT14
 set     FMC_TAGVDW0S1_tag_9         BIT15
 set     FMC_TAGVDW0S1_tag_10        BIT16
 set     FMC_TAGVDW0S1_tag_11        BIT17
 set     FMC_TAGVDW0S1_tag_12        BIT18

 set     FMC_TAGVDW0S2_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S2_tag_0         BIT6
 set     FMC_TAGVDW0S2_tag_1         BIT7
 set     FMC_TAGVDW0S2_tag_2         BIT8
 set     FMC_TAGVDW0S2_tag_3         BIT9
 set     FMC_TAGVDW0S2_tag_4         BIT10
 set     FMC_TAGVDW0S2_tag_5         BIT11
 set     FMC_TAGVDW0S2_tag_6         BIT12
 set     FMC_TAGVDW0S2_tag_7         BIT13
 set     FMC_TAGVDW0S2_tag_8         BIT14
 set     FMC_TAGVDW0S2_tag_9         BIT15
 set     FMC_TAGVDW0S2_tag_10        BIT16
 set     FMC_TAGVDW0S2_tag_11        BIT17
 set     FMC_TAGVDW0S2_tag_12        BIT18

 set     FMC_TAGVDW0S3_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S3_tag_0         BIT6
 set     FMC_TAGVDW0S3_tag_1         BIT7
 set     FMC_TAGVDW0S3_tag_2         BIT8
 set     FMC_TAGVDW0S3_tag_3         BIT9
 set     FMC_TAGVDW0S3_tag_4         BIT10
 set     FMC_TAGVDW0S3_tag_5         BIT11
 set     FMC_TAGVDW0S3_tag_6         BIT12
 set     FMC_TAGVDW0S3_tag_7         BIT13
 set     FMC_TAGVDW0S3_tag_8         BIT14
 set     FMC_TAGVDW0S3_tag_9         BIT15
 set     FMC_TAGVDW0S3_tag_10        BIT16
 set     FMC_TAGVDW0S3_tag_11        BIT17
 set     FMC_TAGVDW0S3_tag_12        BIT18

 set     FMC_TAGVDW0S4_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S4_tag_0         BIT6
 set     FMC_TAGVDW0S4_tag_1         BIT7
 set     FMC_TAGVDW0S4_tag_2         BIT8
 set     FMC_TAGVDW0S4_tag_3         BIT9
 set     FMC_TAGVDW0S4_tag_4         BIT10
 set     FMC_TAGVDW0S4_tag_5         BIT11
 set     FMC_TAGVDW0S4_tag_6         BIT12
 set     FMC_TAGVDW0S4_tag_7         BIT13
 set     FMC_TAGVDW0S4_tag_8         BIT14
 set     FMC_TAGVDW0S4_tag_9         BIT15
 set     FMC_TAGVDW0S4_tag_10        BIT16
 set     FMC_TAGVDW0S4_tag_11        BIT17
 set     FMC_TAGVDW0S4_tag_12        BIT18

 set     FMC_TAGVDW0S5_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S5_tag_0         BIT6
 set     FMC_TAGVDW0S5_tag_1         BIT7
 set     FMC_TAGVDW0S5_tag_2         BIT8
 set     FMC_TAGVDW0S5_tag_3         BIT9
 set     FMC_TAGVDW0S5_tag_4         BIT10
 set     FMC_TAGVDW0S5_tag_5         BIT11
 set     FMC_TAGVDW0S5_tag_6         BIT12
 set     FMC_TAGVDW0S5_tag_7         BIT13
 set     FMC_TAGVDW0S5_tag_8         BIT14
 set     FMC_TAGVDW0S5_tag_9         BIT15
 set     FMC_TAGVDW0S5_tag_10        BIT16
 set     FMC_TAGVDW0S5_tag_11        BIT17
 set     FMC_TAGVDW0S5_tag_12        BIT18

 set     FMC_TAGVDW0S6_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S6_tag_0         BIT6
 set     FMC_TAGVDW0S6_tag_1         BIT7
 set     FMC_TAGVDW0S6_tag_2         BIT8
 set     FMC_TAGVDW0S6_tag_3         BIT9
 set     FMC_TAGVDW0S6_tag_4         BIT10
 set     FMC_TAGVDW0S6_tag_5         BIT11
 set     FMC_TAGVDW0S6_tag_6         BIT12
 set     FMC_TAGVDW0S6_tag_7         BIT13
 set     FMC_TAGVDW0S6_tag_8         BIT14
 set     FMC_TAGVDW0S6_tag_9         BIT15
 set     FMC_TAGVDW0S6_tag_10        BIT16
 set     FMC_TAGVDW0S6_tag_11        BIT17
 set     FMC_TAGVDW0S6_tag_12        BIT18

 set     FMC_TAGVDW0S7_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW0S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW0S7_tag_0         BIT6
 set     FMC_TAGVDW0S7_tag_1         BIT7
 set     FMC_TAGVDW0S7_tag_2         BIT8
 set     FMC_TAGVDW0S7_tag_3         BIT9
 set     FMC_TAGVDW0S7_tag_4         BIT10
 set     FMC_TAGVDW0S7_tag_5         BIT11
 set     FMC_TAGVDW0S7_tag_6         BIT12
 set     FMC_TAGVDW0S7_tag_7         BIT13
 set     FMC_TAGVDW0S7_tag_8         BIT14
 set     FMC_TAGVDW0S7_tag_9         BIT15
 set     FMC_TAGVDW0S7_tag_10        BIT16
 set     FMC_TAGVDW0S7_tag_11        BIT17
 set     FMC_TAGVDW0S7_tag_12        BIT18

 set     FMC_TAGVDW1S0_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S0_tag_0         BIT6
 set     FMC_TAGVDW1S0_tag_1         BIT7
 set     FMC_TAGVDW1S0_tag_2         BIT8
 set     FMC_TAGVDW1S0_tag_3         BIT9
 set     FMC_TAGVDW1S0_tag_4         BIT10
 set     FMC_TAGVDW1S0_tag_5         BIT11
 set     FMC_TAGVDW1S0_tag_6         BIT12
 set     FMC_TAGVDW1S0_tag_7         BIT13
 set     FMC_TAGVDW1S0_tag_8         BIT14
 set     FMC_TAGVDW1S0_tag_9         BIT15
 set     FMC_TAGVDW1S0_tag_10        BIT16
 set     FMC_TAGVDW1S0_tag_11        BIT17
 set     FMC_TAGVDW1S0_tag_12        BIT18

 set     FMC_TAGVDW1S1_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S1_tag_0         BIT6
 set     FMC_TAGVDW1S1_tag_1         BIT7
 set     FMC_TAGVDW1S1_tag_2         BIT8
 set     FMC_TAGVDW1S1_tag_3         BIT9
 set     FMC_TAGVDW1S1_tag_4         BIT10
 set     FMC_TAGVDW1S1_tag_5         BIT11
 set     FMC_TAGVDW1S1_tag_6         BIT12
 set     FMC_TAGVDW1S1_tag_7         BIT13
 set     FMC_TAGVDW1S1_tag_8         BIT14
 set     FMC_TAGVDW1S1_tag_9         BIT15
 set     FMC_TAGVDW1S1_tag_10        BIT16
 set     FMC_TAGVDW1S1_tag_11        BIT17
 set     FMC_TAGVDW1S1_tag_12        BIT18

 set     FMC_TAGVDW1S2_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S2_tag_0         BIT6
 set     FMC_TAGVDW1S2_tag_1         BIT7
 set     FMC_TAGVDW1S2_tag_2         BIT8
 set     FMC_TAGVDW1S2_tag_3         BIT9
 set     FMC_TAGVDW1S2_tag_4         BIT10
 set     FMC_TAGVDW1S2_tag_5         BIT11
 set     FMC_TAGVDW1S2_tag_6         BIT12
 set     FMC_TAGVDW1S2_tag_7         BIT13
 set     FMC_TAGVDW1S2_tag_8         BIT14
 set     FMC_TAGVDW1S2_tag_9         BIT15
 set     FMC_TAGVDW1S2_tag_10        BIT16
 set     FMC_TAGVDW1S2_tag_11        BIT17
 set     FMC_TAGVDW1S2_tag_12        BIT18

 set     FMC_TAGVDW1S3_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S3_tag_0         BIT6
 set     FMC_TAGVDW1S3_tag_1         BIT7
 set     FMC_TAGVDW1S3_tag_2         BIT8
 set     FMC_TAGVDW1S3_tag_3         BIT9
 set     FMC_TAGVDW1S3_tag_4         BIT10
 set     FMC_TAGVDW1S3_tag_5         BIT11
 set     FMC_TAGVDW1S3_tag_6         BIT12
 set     FMC_TAGVDW1S3_tag_7         BIT13
 set     FMC_TAGVDW1S3_tag_8         BIT14
 set     FMC_TAGVDW1S3_tag_9         BIT15
 set     FMC_TAGVDW1S3_tag_10        BIT16
 set     FMC_TAGVDW1S3_tag_11        BIT17
 set     FMC_TAGVDW1S3_tag_12        BIT18

 set     FMC_TAGVDW1S4_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S4_tag_0         BIT6
 set     FMC_TAGVDW1S4_tag_1         BIT7
 set     FMC_TAGVDW1S4_tag_2         BIT8
 set     FMC_TAGVDW1S4_tag_3         BIT9
 set     FMC_TAGVDW1S4_tag_4         BIT10
 set     FMC_TAGVDW1S4_tag_5         BIT11
 set     FMC_TAGVDW1S4_tag_6         BIT12
 set     FMC_TAGVDW1S4_tag_7         BIT13
 set     FMC_TAGVDW1S4_tag_8         BIT14
 set     FMC_TAGVDW1S4_tag_9         BIT15
 set     FMC_TAGVDW1S4_tag_10        BIT16
 set     FMC_TAGVDW1S4_tag_11        BIT17
 set     FMC_TAGVDW1S4_tag_12        BIT18

 set     FMC_TAGVDW1S5_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S5_tag_0         BIT6
 set     FMC_TAGVDW1S5_tag_1         BIT7
 set     FMC_TAGVDW1S5_tag_2         BIT8
 set     FMC_TAGVDW1S5_tag_3         BIT9
 set     FMC_TAGVDW1S5_tag_4         BIT10
 set     FMC_TAGVDW1S5_tag_5         BIT11
 set     FMC_TAGVDW1S5_tag_6         BIT12
 set     FMC_TAGVDW1S5_tag_7         BIT13
 set     FMC_TAGVDW1S5_tag_8         BIT14
 set     FMC_TAGVDW1S5_tag_9         BIT15
 set     FMC_TAGVDW1S5_tag_10        BIT16
 set     FMC_TAGVDW1S5_tag_11        BIT17
 set     FMC_TAGVDW1S5_tag_12        BIT18

 set     FMC_TAGVDW1S6_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S6_tag_0         BIT6
 set     FMC_TAGVDW1S6_tag_1         BIT7
 set     FMC_TAGVDW1S6_tag_2         BIT8
 set     FMC_TAGVDW1S6_tag_3         BIT9
 set     FMC_TAGVDW1S6_tag_4         BIT10
 set     FMC_TAGVDW1S6_tag_5         BIT11
 set     FMC_TAGVDW1S6_tag_6         BIT12
 set     FMC_TAGVDW1S6_tag_7         BIT13
 set     FMC_TAGVDW1S6_tag_8         BIT14
 set     FMC_TAGVDW1S6_tag_9         BIT15
 set     FMC_TAGVDW1S6_tag_10        BIT16
 set     FMC_TAGVDW1S6_tag_11        BIT17
 set     FMC_TAGVDW1S6_tag_12        BIT18

 set     FMC_TAGVDW1S7_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW1S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW1S7_tag_0         BIT6
 set     FMC_TAGVDW1S7_tag_1         BIT7
 set     FMC_TAGVDW1S7_tag_2         BIT8
 set     FMC_TAGVDW1S7_tag_3         BIT9
 set     FMC_TAGVDW1S7_tag_4         BIT10
 set     FMC_TAGVDW1S7_tag_5         BIT11
 set     FMC_TAGVDW1S7_tag_6         BIT12
 set     FMC_TAGVDW1S7_tag_7         BIT13
 set     FMC_TAGVDW1S7_tag_8         BIT14
 set     FMC_TAGVDW1S7_tag_9         BIT15
 set     FMC_TAGVDW1S7_tag_10        BIT16
 set     FMC_TAGVDW1S7_tag_11        BIT17
 set     FMC_TAGVDW1S7_tag_12        BIT18

 set     FMC_TAGVDW2S0_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S0_tag_0         BIT6
 set     FMC_TAGVDW2S0_tag_1         BIT7
 set     FMC_TAGVDW2S0_tag_2         BIT8
 set     FMC_TAGVDW2S0_tag_3         BIT9
 set     FMC_TAGVDW2S0_tag_4         BIT10
 set     FMC_TAGVDW2S0_tag_5         BIT11
 set     FMC_TAGVDW2S0_tag_6         BIT12
 set     FMC_TAGVDW2S0_tag_7         BIT13
 set     FMC_TAGVDW2S0_tag_8         BIT14
 set     FMC_TAGVDW2S0_tag_9         BIT15
 set     FMC_TAGVDW2S0_tag_10        BIT16
 set     FMC_TAGVDW2S0_tag_11        BIT17
 set     FMC_TAGVDW2S0_tag_12        BIT18

 set     FMC_TAGVDW2S1_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S1_tag_0         BIT6
 set     FMC_TAGVDW2S1_tag_1         BIT7
 set     FMC_TAGVDW2S1_tag_2         BIT8
 set     FMC_TAGVDW2S1_tag_3         BIT9
 set     FMC_TAGVDW2S1_tag_4         BIT10
 set     FMC_TAGVDW2S1_tag_5         BIT11
 set     FMC_TAGVDW2S1_tag_6         BIT12
 set     FMC_TAGVDW2S1_tag_7         BIT13
 set     FMC_TAGVDW2S1_tag_8         BIT14
 set     FMC_TAGVDW2S1_tag_9         BIT15
 set     FMC_TAGVDW2S1_tag_10        BIT16
 set     FMC_TAGVDW2S1_tag_11        BIT17
 set     FMC_TAGVDW2S1_tag_12        BIT18

 set     FMC_TAGVDW2S2_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S2_tag_0         BIT6
 set     FMC_TAGVDW2S2_tag_1         BIT7
 set     FMC_TAGVDW2S2_tag_2         BIT8
 set     FMC_TAGVDW2S2_tag_3         BIT9
 set     FMC_TAGVDW2S2_tag_4         BIT10
 set     FMC_TAGVDW2S2_tag_5         BIT11
 set     FMC_TAGVDW2S2_tag_6         BIT12
 set     FMC_TAGVDW2S2_tag_7         BIT13
 set     FMC_TAGVDW2S2_tag_8         BIT14
 set     FMC_TAGVDW2S2_tag_9         BIT15
 set     FMC_TAGVDW2S2_tag_10        BIT16
 set     FMC_TAGVDW2S2_tag_11        BIT17
 set     FMC_TAGVDW2S2_tag_12        BIT18

 set     FMC_TAGVDW2S3_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S3_tag_0         BIT6
 set     FMC_TAGVDW2S3_tag_1         BIT7
 set     FMC_TAGVDW2S3_tag_2         BIT8
 set     FMC_TAGVDW2S3_tag_3         BIT9
 set     FMC_TAGVDW2S3_tag_4         BIT10
 set     FMC_TAGVDW2S3_tag_5         BIT11
 set     FMC_TAGVDW2S3_tag_6         BIT12
 set     FMC_TAGVDW2S3_tag_7         BIT13
 set     FMC_TAGVDW2S3_tag_8         BIT14
 set     FMC_TAGVDW2S3_tag_9         BIT15
 set     FMC_TAGVDW2S3_tag_10        BIT16
 set     FMC_TAGVDW2S3_tag_11        BIT17
 set     FMC_TAGVDW2S3_tag_12        BIT18

 set     FMC_TAGVDW2S4_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S4_tag_0         BIT6
 set     FMC_TAGVDW2S4_tag_1         BIT7
 set     FMC_TAGVDW2S4_tag_2         BIT8
 set     FMC_TAGVDW2S4_tag_3         BIT9
 set     FMC_TAGVDW2S4_tag_4         BIT10
 set     FMC_TAGVDW2S4_tag_5         BIT11
 set     FMC_TAGVDW2S4_tag_6         BIT12
 set     FMC_TAGVDW2S4_tag_7         BIT13
 set     FMC_TAGVDW2S4_tag_8         BIT14
 set     FMC_TAGVDW2S4_tag_9         BIT15
 set     FMC_TAGVDW2S4_tag_10        BIT16
 set     FMC_TAGVDW2S4_tag_11        BIT17
 set     FMC_TAGVDW2S4_tag_12        BIT18

 set     FMC_TAGVDW2S5_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S5_tag_0         BIT6
 set     FMC_TAGVDW2S5_tag_1         BIT7
 set     FMC_TAGVDW2S5_tag_2         BIT8
 set     FMC_TAGVDW2S5_tag_3         BIT9
 set     FMC_TAGVDW2S5_tag_4         BIT10
 set     FMC_TAGVDW2S5_tag_5         BIT11
 set     FMC_TAGVDW2S5_tag_6         BIT12
 set     FMC_TAGVDW2S5_tag_7         BIT13
 set     FMC_TAGVDW2S5_tag_8         BIT14
 set     FMC_TAGVDW2S5_tag_9         BIT15
 set     FMC_TAGVDW2S5_tag_10        BIT16
 set     FMC_TAGVDW2S5_tag_11        BIT17
 set     FMC_TAGVDW2S5_tag_12        BIT18

 set     FMC_TAGVDW2S6_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S6_tag_0         BIT6
 set     FMC_TAGVDW2S6_tag_1         BIT7
 set     FMC_TAGVDW2S6_tag_2         BIT8
 set     FMC_TAGVDW2S6_tag_3         BIT9
 set     FMC_TAGVDW2S6_tag_4         BIT10
 set     FMC_TAGVDW2S6_tag_5         BIT11
 set     FMC_TAGVDW2S6_tag_6         BIT12
 set     FMC_TAGVDW2S6_tag_7         BIT13
 set     FMC_TAGVDW2S6_tag_8         BIT14
 set     FMC_TAGVDW2S6_tag_9         BIT15
 set     FMC_TAGVDW2S6_tag_10        BIT16
 set     FMC_TAGVDW2S6_tag_11        BIT17
 set     FMC_TAGVDW2S6_tag_12        BIT18

 set     FMC_TAGVDW2S7_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW2S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW2S7_tag_0         BIT6
 set     FMC_TAGVDW2S7_tag_1         BIT7
 set     FMC_TAGVDW2S7_tag_2         BIT8
 set     FMC_TAGVDW2S7_tag_3         BIT9
 set     FMC_TAGVDW2S7_tag_4         BIT10
 set     FMC_TAGVDW2S7_tag_5         BIT11
 set     FMC_TAGVDW2S7_tag_6         BIT12
 set     FMC_TAGVDW2S7_tag_7         BIT13
 set     FMC_TAGVDW2S7_tag_8         BIT14
 set     FMC_TAGVDW2S7_tag_9         BIT15
 set     FMC_TAGVDW2S7_tag_10        BIT16
 set     FMC_TAGVDW2S7_tag_11        BIT17
 set     FMC_TAGVDW2S7_tag_12        BIT18

 set     FMC_TAGVDW3S0_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S0_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S0_tag_0         BIT6
 set     FMC_TAGVDW3S0_tag_1         BIT7
 set     FMC_TAGVDW3S0_tag_2         BIT8
 set     FMC_TAGVDW3S0_tag_3         BIT9
 set     FMC_TAGVDW3S0_tag_4         BIT10
 set     FMC_TAGVDW3S0_tag_5         BIT11
 set     FMC_TAGVDW3S0_tag_6         BIT12
 set     FMC_TAGVDW3S0_tag_7         BIT13
 set     FMC_TAGVDW3S0_tag_8         BIT14
 set     FMC_TAGVDW3S0_tag_9         BIT15
 set     FMC_TAGVDW3S0_tag_10        BIT16
 set     FMC_TAGVDW3S0_tag_11        BIT17
 set     FMC_TAGVDW3S0_tag_12        BIT18

 set     FMC_TAGVDW3S1_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S1_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S1_tag_0         BIT6
 set     FMC_TAGVDW3S1_tag_1         BIT7
 set     FMC_TAGVDW3S1_tag_2         BIT8
 set     FMC_TAGVDW3S1_tag_3         BIT9
 set     FMC_TAGVDW3S1_tag_4         BIT10
 set     FMC_TAGVDW3S1_tag_5         BIT11
 set     FMC_TAGVDW3S1_tag_6         BIT12
 set     FMC_TAGVDW3S1_tag_7         BIT13
 set     FMC_TAGVDW3S1_tag_8         BIT14
 set     FMC_TAGVDW3S1_tag_9         BIT15
 set     FMC_TAGVDW3S1_tag_10        BIT16
 set     FMC_TAGVDW3S1_tag_11        BIT17
 set     FMC_TAGVDW3S1_tag_12        BIT18

 set     FMC_TAGVDW3S2_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S2_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S2_tag_0         BIT6
 set     FMC_TAGVDW3S2_tag_1         BIT7
 set     FMC_TAGVDW3S2_tag_2         BIT8
 set     FMC_TAGVDW3S2_tag_3         BIT9
 set     FMC_TAGVDW3S2_tag_4         BIT10
 set     FMC_TAGVDW3S2_tag_5         BIT11
 set     FMC_TAGVDW3S2_tag_6         BIT12
 set     FMC_TAGVDW3S2_tag_7         BIT13
 set     FMC_TAGVDW3S2_tag_8         BIT14
 set     FMC_TAGVDW3S2_tag_9         BIT15
 set     FMC_TAGVDW3S2_tag_10        BIT16
 set     FMC_TAGVDW3S2_tag_11        BIT17
 set     FMC_TAGVDW3S2_tag_12        BIT18

 set     FMC_TAGVDW3S3_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S3_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S3_tag_0         BIT6
 set     FMC_TAGVDW3S3_tag_1         BIT7
 set     FMC_TAGVDW3S3_tag_2         BIT8
 set     FMC_TAGVDW3S3_tag_3         BIT9
 set     FMC_TAGVDW3S3_tag_4         BIT10
 set     FMC_TAGVDW3S3_tag_5         BIT11
 set     FMC_TAGVDW3S3_tag_6         BIT12
 set     FMC_TAGVDW3S3_tag_7         BIT13
 set     FMC_TAGVDW3S3_tag_8         BIT14
 set     FMC_TAGVDW3S3_tag_9         BIT15
 set     FMC_TAGVDW3S3_tag_10        BIT16
 set     FMC_TAGVDW3S3_tag_11        BIT17
 set     FMC_TAGVDW3S3_tag_12        BIT18

 set     FMC_TAGVDW3S4_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S4_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S4_tag_0         BIT6
 set     FMC_TAGVDW3S4_tag_1         BIT7
 set     FMC_TAGVDW3S4_tag_2         BIT8
 set     FMC_TAGVDW3S4_tag_3         BIT9
 set     FMC_TAGVDW3S4_tag_4         BIT10
 set     FMC_TAGVDW3S4_tag_5         BIT11
 set     FMC_TAGVDW3S4_tag_6         BIT12
 set     FMC_TAGVDW3S4_tag_7         BIT13
 set     FMC_TAGVDW3S4_tag_8         BIT14
 set     FMC_TAGVDW3S4_tag_9         BIT15
 set     FMC_TAGVDW3S4_tag_10        BIT16
 set     FMC_TAGVDW3S4_tag_11        BIT17
 set     FMC_TAGVDW3S4_tag_12        BIT18

 set     FMC_TAGVDW3S5_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S5_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S5_tag_0         BIT6
 set     FMC_TAGVDW3S5_tag_1         BIT7
 set     FMC_TAGVDW3S5_tag_2         BIT8
 set     FMC_TAGVDW3S5_tag_3         BIT9
 set     FMC_TAGVDW3S5_tag_4         BIT10
 set     FMC_TAGVDW3S5_tag_5         BIT11
 set     FMC_TAGVDW3S5_tag_6         BIT12
 set     FMC_TAGVDW3S5_tag_7         BIT13
 set     FMC_TAGVDW3S5_tag_8         BIT14
 set     FMC_TAGVDW3S5_tag_9         BIT15
 set     FMC_TAGVDW3S5_tag_10        BIT16
 set     FMC_TAGVDW3S5_tag_11        BIT17
 set     FMC_TAGVDW3S5_tag_12        BIT18

 set     FMC_TAGVDW3S6_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S6_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S6_tag_0         BIT6
 set     FMC_TAGVDW3S6_tag_1         BIT7
 set     FMC_TAGVDW3S6_tag_2         BIT8
 set     FMC_TAGVDW3S6_tag_3         BIT9
 set     FMC_TAGVDW3S6_tag_4         BIT10
 set     FMC_TAGVDW3S6_tag_5         BIT11
 set     FMC_TAGVDW3S6_tag_6         BIT12
 set     FMC_TAGVDW3S6_tag_7         BIT13
 set     FMC_TAGVDW3S6_tag_8         BIT14
 set     FMC_TAGVDW3S6_tag_9         BIT15
 set     FMC_TAGVDW3S6_tag_10        BIT16
 set     FMC_TAGVDW3S6_tag_11        BIT17
 set     FMC_TAGVDW3S6_tag_12        BIT18

 set     FMC_TAGVDW3S7_valid         BIT0
;;   1-bit valid for cache entry

 set     FMC_TAGVDW3S7_tag           (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18)
;;   13-bit tag for cache entry
 set     FMC_TAGVDW3S7_tag_0         BIT6
 set     FMC_TAGVDW3S7_tag_1         BIT7
 set     FMC_TAGVDW3S7_tag_2         BIT8
 set     FMC_TAGVDW3S7_tag_3         BIT9
 set     FMC_TAGVDW3S7_tag_4         BIT10
 set     FMC_TAGVDW3S7_tag_5         BIT11
 set     FMC_TAGVDW3S7_tag_6         BIT12
 set     FMC_TAGVDW3S7_tag_7         BIT13
 set     FMC_TAGVDW3S7_tag_8         BIT14
 set     FMC_TAGVDW3S7_tag_9         BIT15
 set     FMC_TAGVDW3S7_tag_10        BIT16
 set     FMC_TAGVDW3S7_tag_11        BIT17
 set     FMC_TAGVDW3S7_tag_12        BIT18

 set     FMC_DATAW0S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S0U_data_0        BIT0
 set     FMC_DATAW0S0U_data_1        BIT1
 set     FMC_DATAW0S0U_data_2        BIT2
 set     FMC_DATAW0S0U_data_3        BIT3
 set     FMC_DATAW0S0U_data_4        BIT4
 set     FMC_DATAW0S0U_data_5        BIT5
 set     FMC_DATAW0S0U_data_6        BIT6
 set     FMC_DATAW0S0U_data_7        BIT7
 set     FMC_DATAW0S0U_data_8        BIT8
 set     FMC_DATAW0S0U_data_9        BIT9
 set     FMC_DATAW0S0U_data_10       BIT10
 set     FMC_DATAW0S0U_data_11       BIT11
 set     FMC_DATAW0S0U_data_12       BIT12
 set     FMC_DATAW0S0U_data_13       BIT13
 set     FMC_DATAW0S0U_data_14       BIT14
 set     FMC_DATAW0S0U_data_15       BIT15
 set     FMC_DATAW0S0U_data_16       BIT16
 set     FMC_DATAW0S0U_data_17       BIT17
 set     FMC_DATAW0S0U_data_18       BIT18
 set     FMC_DATAW0S0U_data_19       BIT19
 set     FMC_DATAW0S0U_data_20       BIT20
 set     FMC_DATAW0S0U_data_21       BIT21
 set     FMC_DATAW0S0U_data_22       BIT22
 set     FMC_DATAW0S0U_data_23       BIT23
 set     FMC_DATAW0S0U_data_24       BIT24
 set     FMC_DATAW0S0U_data_25       BIT25
 set     FMC_DATAW0S0U_data_26       BIT26
 set     FMC_DATAW0S0U_data_27       BIT27
 set     FMC_DATAW0S0U_data_28       BIT28
 set     FMC_DATAW0S0U_data_29       BIT29
 set     FMC_DATAW0S0U_data_30       BIT30
 set     FMC_DATAW0S0U_data_31       BIT31

 set     FMC_DATAW0S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S0L_data_0        BIT0
 set     FMC_DATAW0S0L_data_1        BIT1
 set     FMC_DATAW0S0L_data_2        BIT2
 set     FMC_DATAW0S0L_data_3        BIT3
 set     FMC_DATAW0S0L_data_4        BIT4
 set     FMC_DATAW0S0L_data_5        BIT5
 set     FMC_DATAW0S0L_data_6        BIT6
 set     FMC_DATAW0S0L_data_7        BIT7
 set     FMC_DATAW0S0L_data_8        BIT8
 set     FMC_DATAW0S0L_data_9        BIT9
 set     FMC_DATAW0S0L_data_10       BIT10
 set     FMC_DATAW0S0L_data_11       BIT11
 set     FMC_DATAW0S0L_data_12       BIT12
 set     FMC_DATAW0S0L_data_13       BIT13
 set     FMC_DATAW0S0L_data_14       BIT14
 set     FMC_DATAW0S0L_data_15       BIT15
 set     FMC_DATAW0S0L_data_16       BIT16
 set     FMC_DATAW0S0L_data_17       BIT17
 set     FMC_DATAW0S0L_data_18       BIT18
 set     FMC_DATAW0S0L_data_19       BIT19
 set     FMC_DATAW0S0L_data_20       BIT20
 set     FMC_DATAW0S0L_data_21       BIT21
 set     FMC_DATAW0S0L_data_22       BIT22
 set     FMC_DATAW0S0L_data_23       BIT23
 set     FMC_DATAW0S0L_data_24       BIT24
 set     FMC_DATAW0S0L_data_25       BIT25
 set     FMC_DATAW0S0L_data_26       BIT26
 set     FMC_DATAW0S0L_data_27       BIT27
 set     FMC_DATAW0S0L_data_28       BIT28
 set     FMC_DATAW0S0L_data_29       BIT29
 set     FMC_DATAW0S0L_data_30       BIT30
 set     FMC_DATAW0S0L_data_31       BIT31

 set     FMC_DATAW0S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S1U_data_0        BIT0
 set     FMC_DATAW0S1U_data_1        BIT1
 set     FMC_DATAW0S1U_data_2        BIT2
 set     FMC_DATAW0S1U_data_3        BIT3
 set     FMC_DATAW0S1U_data_4        BIT4
 set     FMC_DATAW0S1U_data_5        BIT5
 set     FMC_DATAW0S1U_data_6        BIT6
 set     FMC_DATAW0S1U_data_7        BIT7
 set     FMC_DATAW0S1U_data_8        BIT8
 set     FMC_DATAW0S1U_data_9        BIT9
 set     FMC_DATAW0S1U_data_10       BIT10
 set     FMC_DATAW0S1U_data_11       BIT11
 set     FMC_DATAW0S1U_data_12       BIT12
 set     FMC_DATAW0S1U_data_13       BIT13
 set     FMC_DATAW0S1U_data_14       BIT14
 set     FMC_DATAW0S1U_data_15       BIT15
 set     FMC_DATAW0S1U_data_16       BIT16
 set     FMC_DATAW0S1U_data_17       BIT17
 set     FMC_DATAW0S1U_data_18       BIT18
 set     FMC_DATAW0S1U_data_19       BIT19
 set     FMC_DATAW0S1U_data_20       BIT20
 set     FMC_DATAW0S1U_data_21       BIT21
 set     FMC_DATAW0S1U_data_22       BIT22
 set     FMC_DATAW0S1U_data_23       BIT23
 set     FMC_DATAW0S1U_data_24       BIT24
 set     FMC_DATAW0S1U_data_25       BIT25
 set     FMC_DATAW0S1U_data_26       BIT26
 set     FMC_DATAW0S1U_data_27       BIT27
 set     FMC_DATAW0S1U_data_28       BIT28
 set     FMC_DATAW0S1U_data_29       BIT29
 set     FMC_DATAW0S1U_data_30       BIT30
 set     FMC_DATAW0S1U_data_31       BIT31

 set     FMC_DATAW0S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S1L_data_0        BIT0
 set     FMC_DATAW0S1L_data_1        BIT1
 set     FMC_DATAW0S1L_data_2        BIT2
 set     FMC_DATAW0S1L_data_3        BIT3
 set     FMC_DATAW0S1L_data_4        BIT4
 set     FMC_DATAW0S1L_data_5        BIT5
 set     FMC_DATAW0S1L_data_6        BIT6
 set     FMC_DATAW0S1L_data_7        BIT7
 set     FMC_DATAW0S1L_data_8        BIT8
 set     FMC_DATAW0S1L_data_9        BIT9
 set     FMC_DATAW0S1L_data_10       BIT10
 set     FMC_DATAW0S1L_data_11       BIT11
 set     FMC_DATAW0S1L_data_12       BIT12
 set     FMC_DATAW0S1L_data_13       BIT13
 set     FMC_DATAW0S1L_data_14       BIT14
 set     FMC_DATAW0S1L_data_15       BIT15
 set     FMC_DATAW0S1L_data_16       BIT16
 set     FMC_DATAW0S1L_data_17       BIT17
 set     FMC_DATAW0S1L_data_18       BIT18
 set     FMC_DATAW0S1L_data_19       BIT19
 set     FMC_DATAW0S1L_data_20       BIT20
 set     FMC_DATAW0S1L_data_21       BIT21
 set     FMC_DATAW0S1L_data_22       BIT22
 set     FMC_DATAW0S1L_data_23       BIT23
 set     FMC_DATAW0S1L_data_24       BIT24
 set     FMC_DATAW0S1L_data_25       BIT25
 set     FMC_DATAW0S1L_data_26       BIT26
 set     FMC_DATAW0S1L_data_27       BIT27
 set     FMC_DATAW0S1L_data_28       BIT28
 set     FMC_DATAW0S1L_data_29       BIT29
 set     FMC_DATAW0S1L_data_30       BIT30
 set     FMC_DATAW0S1L_data_31       BIT31

 set     FMC_DATAW0S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S2U_data_0        BIT0
 set     FMC_DATAW0S2U_data_1        BIT1
 set     FMC_DATAW0S2U_data_2        BIT2
 set     FMC_DATAW0S2U_data_3        BIT3
 set     FMC_DATAW0S2U_data_4        BIT4
 set     FMC_DATAW0S2U_data_5        BIT5
 set     FMC_DATAW0S2U_data_6        BIT6
 set     FMC_DATAW0S2U_data_7        BIT7
 set     FMC_DATAW0S2U_data_8        BIT8
 set     FMC_DATAW0S2U_data_9        BIT9
 set     FMC_DATAW0S2U_data_10       BIT10
 set     FMC_DATAW0S2U_data_11       BIT11
 set     FMC_DATAW0S2U_data_12       BIT12
 set     FMC_DATAW0S2U_data_13       BIT13
 set     FMC_DATAW0S2U_data_14       BIT14
 set     FMC_DATAW0S2U_data_15       BIT15
 set     FMC_DATAW0S2U_data_16       BIT16
 set     FMC_DATAW0S2U_data_17       BIT17
 set     FMC_DATAW0S2U_data_18       BIT18
 set     FMC_DATAW0S2U_data_19       BIT19
 set     FMC_DATAW0S2U_data_20       BIT20
 set     FMC_DATAW0S2U_data_21       BIT21
 set     FMC_DATAW0S2U_data_22       BIT22
 set     FMC_DATAW0S2U_data_23       BIT23
 set     FMC_DATAW0S2U_data_24       BIT24
 set     FMC_DATAW0S2U_data_25       BIT25
 set     FMC_DATAW0S2U_data_26       BIT26
 set     FMC_DATAW0S2U_data_27       BIT27
 set     FMC_DATAW0S2U_data_28       BIT28
 set     FMC_DATAW0S2U_data_29       BIT29
 set     FMC_DATAW0S2U_data_30       BIT30
 set     FMC_DATAW0S2U_data_31       BIT31

 set     FMC_DATAW0S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S2L_data_0        BIT0
 set     FMC_DATAW0S2L_data_1        BIT1
 set     FMC_DATAW0S2L_data_2        BIT2
 set     FMC_DATAW0S2L_data_3        BIT3
 set     FMC_DATAW0S2L_data_4        BIT4
 set     FMC_DATAW0S2L_data_5        BIT5
 set     FMC_DATAW0S2L_data_6        BIT6
 set     FMC_DATAW0S2L_data_7        BIT7
 set     FMC_DATAW0S2L_data_8        BIT8
 set     FMC_DATAW0S2L_data_9        BIT9
 set     FMC_DATAW0S2L_data_10       BIT10
 set     FMC_DATAW0S2L_data_11       BIT11
 set     FMC_DATAW0S2L_data_12       BIT12
 set     FMC_DATAW0S2L_data_13       BIT13
 set     FMC_DATAW0S2L_data_14       BIT14
 set     FMC_DATAW0S2L_data_15       BIT15
 set     FMC_DATAW0S2L_data_16       BIT16
 set     FMC_DATAW0S2L_data_17       BIT17
 set     FMC_DATAW0S2L_data_18       BIT18
 set     FMC_DATAW0S2L_data_19       BIT19
 set     FMC_DATAW0S2L_data_20       BIT20
 set     FMC_DATAW0S2L_data_21       BIT21
 set     FMC_DATAW0S2L_data_22       BIT22
 set     FMC_DATAW0S2L_data_23       BIT23
 set     FMC_DATAW0S2L_data_24       BIT24
 set     FMC_DATAW0S2L_data_25       BIT25
 set     FMC_DATAW0S2L_data_26       BIT26
 set     FMC_DATAW0S2L_data_27       BIT27
 set     FMC_DATAW0S2L_data_28       BIT28
 set     FMC_DATAW0S2L_data_29       BIT29
 set     FMC_DATAW0S2L_data_30       BIT30
 set     FMC_DATAW0S2L_data_31       BIT31

 set     FMC_DATAW0S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S3U_data_0        BIT0
 set     FMC_DATAW0S3U_data_1        BIT1
 set     FMC_DATAW0S3U_data_2        BIT2
 set     FMC_DATAW0S3U_data_3        BIT3
 set     FMC_DATAW0S3U_data_4        BIT4
 set     FMC_DATAW0S3U_data_5        BIT5
 set     FMC_DATAW0S3U_data_6        BIT6
 set     FMC_DATAW0S3U_data_7        BIT7
 set     FMC_DATAW0S3U_data_8        BIT8
 set     FMC_DATAW0S3U_data_9        BIT9
 set     FMC_DATAW0S3U_data_10       BIT10
 set     FMC_DATAW0S3U_data_11       BIT11
 set     FMC_DATAW0S3U_data_12       BIT12
 set     FMC_DATAW0S3U_data_13       BIT13
 set     FMC_DATAW0S3U_data_14       BIT14
 set     FMC_DATAW0S3U_data_15       BIT15
 set     FMC_DATAW0S3U_data_16       BIT16
 set     FMC_DATAW0S3U_data_17       BIT17
 set     FMC_DATAW0S3U_data_18       BIT18
 set     FMC_DATAW0S3U_data_19       BIT19
 set     FMC_DATAW0S3U_data_20       BIT20
 set     FMC_DATAW0S3U_data_21       BIT21
 set     FMC_DATAW0S3U_data_22       BIT22
 set     FMC_DATAW0S3U_data_23       BIT23
 set     FMC_DATAW0S3U_data_24       BIT24
 set     FMC_DATAW0S3U_data_25       BIT25
 set     FMC_DATAW0S3U_data_26       BIT26
 set     FMC_DATAW0S3U_data_27       BIT27
 set     FMC_DATAW0S3U_data_28       BIT28
 set     FMC_DATAW0S3U_data_29       BIT29
 set     FMC_DATAW0S3U_data_30       BIT30
 set     FMC_DATAW0S3U_data_31       BIT31

 set     FMC_DATAW0S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S3L_data_0        BIT0
 set     FMC_DATAW0S3L_data_1        BIT1
 set     FMC_DATAW0S3L_data_2        BIT2
 set     FMC_DATAW0S3L_data_3        BIT3
 set     FMC_DATAW0S3L_data_4        BIT4
 set     FMC_DATAW0S3L_data_5        BIT5
 set     FMC_DATAW0S3L_data_6        BIT6
 set     FMC_DATAW0S3L_data_7        BIT7
 set     FMC_DATAW0S3L_data_8        BIT8
 set     FMC_DATAW0S3L_data_9        BIT9
 set     FMC_DATAW0S3L_data_10       BIT10
 set     FMC_DATAW0S3L_data_11       BIT11
 set     FMC_DATAW0S3L_data_12       BIT12
 set     FMC_DATAW0S3L_data_13       BIT13
 set     FMC_DATAW0S3L_data_14       BIT14
 set     FMC_DATAW0S3L_data_15       BIT15
 set     FMC_DATAW0S3L_data_16       BIT16
 set     FMC_DATAW0S3L_data_17       BIT17
 set     FMC_DATAW0S3L_data_18       BIT18
 set     FMC_DATAW0S3L_data_19       BIT19
 set     FMC_DATAW0S3L_data_20       BIT20
 set     FMC_DATAW0S3L_data_21       BIT21
 set     FMC_DATAW0S3L_data_22       BIT22
 set     FMC_DATAW0S3L_data_23       BIT23
 set     FMC_DATAW0S3L_data_24       BIT24
 set     FMC_DATAW0S3L_data_25       BIT25
 set     FMC_DATAW0S3L_data_26       BIT26
 set     FMC_DATAW0S3L_data_27       BIT27
 set     FMC_DATAW0S3L_data_28       BIT28
 set     FMC_DATAW0S3L_data_29       BIT29
 set     FMC_DATAW0S3L_data_30       BIT30
 set     FMC_DATAW0S3L_data_31       BIT31

 set     FMC_DATAW0S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S4U_data_0        BIT0
 set     FMC_DATAW0S4U_data_1        BIT1
 set     FMC_DATAW0S4U_data_2        BIT2
 set     FMC_DATAW0S4U_data_3        BIT3
 set     FMC_DATAW0S4U_data_4        BIT4
 set     FMC_DATAW0S4U_data_5        BIT5
 set     FMC_DATAW0S4U_data_6        BIT6
 set     FMC_DATAW0S4U_data_7        BIT7
 set     FMC_DATAW0S4U_data_8        BIT8
 set     FMC_DATAW0S4U_data_9        BIT9
 set     FMC_DATAW0S4U_data_10       BIT10
 set     FMC_DATAW0S4U_data_11       BIT11
 set     FMC_DATAW0S4U_data_12       BIT12
 set     FMC_DATAW0S4U_data_13       BIT13
 set     FMC_DATAW0S4U_data_14       BIT14
 set     FMC_DATAW0S4U_data_15       BIT15
 set     FMC_DATAW0S4U_data_16       BIT16
 set     FMC_DATAW0S4U_data_17       BIT17
 set     FMC_DATAW0S4U_data_18       BIT18
 set     FMC_DATAW0S4U_data_19       BIT19
 set     FMC_DATAW0S4U_data_20       BIT20
 set     FMC_DATAW0S4U_data_21       BIT21
 set     FMC_DATAW0S4U_data_22       BIT22
 set     FMC_DATAW0S4U_data_23       BIT23
 set     FMC_DATAW0S4U_data_24       BIT24
 set     FMC_DATAW0S4U_data_25       BIT25
 set     FMC_DATAW0S4U_data_26       BIT26
 set     FMC_DATAW0S4U_data_27       BIT27
 set     FMC_DATAW0S4U_data_28       BIT28
 set     FMC_DATAW0S4U_data_29       BIT29
 set     FMC_DATAW0S4U_data_30       BIT30
 set     FMC_DATAW0S4U_data_31       BIT31

 set     FMC_DATAW0S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S4L_data_0        BIT0
 set     FMC_DATAW0S4L_data_1        BIT1
 set     FMC_DATAW0S4L_data_2        BIT2
 set     FMC_DATAW0S4L_data_3        BIT3
 set     FMC_DATAW0S4L_data_4        BIT4
 set     FMC_DATAW0S4L_data_5        BIT5
 set     FMC_DATAW0S4L_data_6        BIT6
 set     FMC_DATAW0S4L_data_7        BIT7
 set     FMC_DATAW0S4L_data_8        BIT8
 set     FMC_DATAW0S4L_data_9        BIT9
 set     FMC_DATAW0S4L_data_10       BIT10
 set     FMC_DATAW0S4L_data_11       BIT11
 set     FMC_DATAW0S4L_data_12       BIT12
 set     FMC_DATAW0S4L_data_13       BIT13
 set     FMC_DATAW0S4L_data_14       BIT14
 set     FMC_DATAW0S4L_data_15       BIT15
 set     FMC_DATAW0S4L_data_16       BIT16
 set     FMC_DATAW0S4L_data_17       BIT17
 set     FMC_DATAW0S4L_data_18       BIT18
 set     FMC_DATAW0S4L_data_19       BIT19
 set     FMC_DATAW0S4L_data_20       BIT20
 set     FMC_DATAW0S4L_data_21       BIT21
 set     FMC_DATAW0S4L_data_22       BIT22
 set     FMC_DATAW0S4L_data_23       BIT23
 set     FMC_DATAW0S4L_data_24       BIT24
 set     FMC_DATAW0S4L_data_25       BIT25
 set     FMC_DATAW0S4L_data_26       BIT26
 set     FMC_DATAW0S4L_data_27       BIT27
 set     FMC_DATAW0S4L_data_28       BIT28
 set     FMC_DATAW0S4L_data_29       BIT29
 set     FMC_DATAW0S4L_data_30       BIT30
 set     FMC_DATAW0S4L_data_31       BIT31

 set     FMC_DATAW0S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S5U_data_0        BIT0
 set     FMC_DATAW0S5U_data_1        BIT1
 set     FMC_DATAW0S5U_data_2        BIT2
 set     FMC_DATAW0S5U_data_3        BIT3
 set     FMC_DATAW0S5U_data_4        BIT4
 set     FMC_DATAW0S5U_data_5        BIT5
 set     FMC_DATAW0S5U_data_6        BIT6
 set     FMC_DATAW0S5U_data_7        BIT7
 set     FMC_DATAW0S5U_data_8        BIT8
 set     FMC_DATAW0S5U_data_9        BIT9
 set     FMC_DATAW0S5U_data_10       BIT10
 set     FMC_DATAW0S5U_data_11       BIT11
 set     FMC_DATAW0S5U_data_12       BIT12
 set     FMC_DATAW0S5U_data_13       BIT13
 set     FMC_DATAW0S5U_data_14       BIT14
 set     FMC_DATAW0S5U_data_15       BIT15
 set     FMC_DATAW0S5U_data_16       BIT16
 set     FMC_DATAW0S5U_data_17       BIT17
 set     FMC_DATAW0S5U_data_18       BIT18
 set     FMC_DATAW0S5U_data_19       BIT19
 set     FMC_DATAW0S5U_data_20       BIT20
 set     FMC_DATAW0S5U_data_21       BIT21
 set     FMC_DATAW0S5U_data_22       BIT22
 set     FMC_DATAW0S5U_data_23       BIT23
 set     FMC_DATAW0S5U_data_24       BIT24
 set     FMC_DATAW0S5U_data_25       BIT25
 set     FMC_DATAW0S5U_data_26       BIT26
 set     FMC_DATAW0S5U_data_27       BIT27
 set     FMC_DATAW0S5U_data_28       BIT28
 set     FMC_DATAW0S5U_data_29       BIT29
 set     FMC_DATAW0S5U_data_30       BIT30
 set     FMC_DATAW0S5U_data_31       BIT31

 set     FMC_DATAW0S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S5L_data_0        BIT0
 set     FMC_DATAW0S5L_data_1        BIT1
 set     FMC_DATAW0S5L_data_2        BIT2
 set     FMC_DATAW0S5L_data_3        BIT3
 set     FMC_DATAW0S5L_data_4        BIT4
 set     FMC_DATAW0S5L_data_5        BIT5
 set     FMC_DATAW0S5L_data_6        BIT6
 set     FMC_DATAW0S5L_data_7        BIT7
 set     FMC_DATAW0S5L_data_8        BIT8
 set     FMC_DATAW0S5L_data_9        BIT9
 set     FMC_DATAW0S5L_data_10       BIT10
 set     FMC_DATAW0S5L_data_11       BIT11
 set     FMC_DATAW0S5L_data_12       BIT12
 set     FMC_DATAW0S5L_data_13       BIT13
 set     FMC_DATAW0S5L_data_14       BIT14
 set     FMC_DATAW0S5L_data_15       BIT15
 set     FMC_DATAW0S5L_data_16       BIT16
 set     FMC_DATAW0S5L_data_17       BIT17
 set     FMC_DATAW0S5L_data_18       BIT18
 set     FMC_DATAW0S5L_data_19       BIT19
 set     FMC_DATAW0S5L_data_20       BIT20
 set     FMC_DATAW0S5L_data_21       BIT21
 set     FMC_DATAW0S5L_data_22       BIT22
 set     FMC_DATAW0S5L_data_23       BIT23
 set     FMC_DATAW0S5L_data_24       BIT24
 set     FMC_DATAW0S5L_data_25       BIT25
 set     FMC_DATAW0S5L_data_26       BIT26
 set     FMC_DATAW0S5L_data_27       BIT27
 set     FMC_DATAW0S5L_data_28       BIT28
 set     FMC_DATAW0S5L_data_29       BIT29
 set     FMC_DATAW0S5L_data_30       BIT30
 set     FMC_DATAW0S5L_data_31       BIT31

 set     FMC_DATAW0S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S6U_data_0        BIT0
 set     FMC_DATAW0S6U_data_1        BIT1
 set     FMC_DATAW0S6U_data_2        BIT2
 set     FMC_DATAW0S6U_data_3        BIT3
 set     FMC_DATAW0S6U_data_4        BIT4
 set     FMC_DATAW0S6U_data_5        BIT5
 set     FMC_DATAW0S6U_data_6        BIT6
 set     FMC_DATAW0S6U_data_7        BIT7
 set     FMC_DATAW0S6U_data_8        BIT8
 set     FMC_DATAW0S6U_data_9        BIT9
 set     FMC_DATAW0S6U_data_10       BIT10
 set     FMC_DATAW0S6U_data_11       BIT11
 set     FMC_DATAW0S6U_data_12       BIT12
 set     FMC_DATAW0S6U_data_13       BIT13
 set     FMC_DATAW0S6U_data_14       BIT14
 set     FMC_DATAW0S6U_data_15       BIT15
 set     FMC_DATAW0S6U_data_16       BIT16
 set     FMC_DATAW0S6U_data_17       BIT17
 set     FMC_DATAW0S6U_data_18       BIT18
 set     FMC_DATAW0S6U_data_19       BIT19
 set     FMC_DATAW0S6U_data_20       BIT20
 set     FMC_DATAW0S6U_data_21       BIT21
 set     FMC_DATAW0S6U_data_22       BIT22
 set     FMC_DATAW0S6U_data_23       BIT23
 set     FMC_DATAW0S6U_data_24       BIT24
 set     FMC_DATAW0S6U_data_25       BIT25
 set     FMC_DATAW0S6U_data_26       BIT26
 set     FMC_DATAW0S6U_data_27       BIT27
 set     FMC_DATAW0S6U_data_28       BIT28
 set     FMC_DATAW0S6U_data_29       BIT29
 set     FMC_DATAW0S6U_data_30       BIT30
 set     FMC_DATAW0S6U_data_31       BIT31

 set     FMC_DATAW0S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S6L_data_0        BIT0
 set     FMC_DATAW0S6L_data_1        BIT1
 set     FMC_DATAW0S6L_data_2        BIT2
 set     FMC_DATAW0S6L_data_3        BIT3
 set     FMC_DATAW0S6L_data_4        BIT4
 set     FMC_DATAW0S6L_data_5        BIT5
 set     FMC_DATAW0S6L_data_6        BIT6
 set     FMC_DATAW0S6L_data_7        BIT7
 set     FMC_DATAW0S6L_data_8        BIT8
 set     FMC_DATAW0S6L_data_9        BIT9
 set     FMC_DATAW0S6L_data_10       BIT10
 set     FMC_DATAW0S6L_data_11       BIT11
 set     FMC_DATAW0S6L_data_12       BIT12
 set     FMC_DATAW0S6L_data_13       BIT13
 set     FMC_DATAW0S6L_data_14       BIT14
 set     FMC_DATAW0S6L_data_15       BIT15
 set     FMC_DATAW0S6L_data_16       BIT16
 set     FMC_DATAW0S6L_data_17       BIT17
 set     FMC_DATAW0S6L_data_18       BIT18
 set     FMC_DATAW0S6L_data_19       BIT19
 set     FMC_DATAW0S6L_data_20       BIT20
 set     FMC_DATAW0S6L_data_21       BIT21
 set     FMC_DATAW0S6L_data_22       BIT22
 set     FMC_DATAW0S6L_data_23       BIT23
 set     FMC_DATAW0S6L_data_24       BIT24
 set     FMC_DATAW0S6L_data_25       BIT25
 set     FMC_DATAW0S6L_data_26       BIT26
 set     FMC_DATAW0S6L_data_27       BIT27
 set     FMC_DATAW0S6L_data_28       BIT28
 set     FMC_DATAW0S6L_data_29       BIT29
 set     FMC_DATAW0S6L_data_30       BIT30
 set     FMC_DATAW0S6L_data_31       BIT31

 set     FMC_DATAW0S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW0S7U_data_0        BIT0
 set     FMC_DATAW0S7U_data_1        BIT1
 set     FMC_DATAW0S7U_data_2        BIT2
 set     FMC_DATAW0S7U_data_3        BIT3
 set     FMC_DATAW0S7U_data_4        BIT4
 set     FMC_DATAW0S7U_data_5        BIT5
 set     FMC_DATAW0S7U_data_6        BIT6
 set     FMC_DATAW0S7U_data_7        BIT7
 set     FMC_DATAW0S7U_data_8        BIT8
 set     FMC_DATAW0S7U_data_9        BIT9
 set     FMC_DATAW0S7U_data_10       BIT10
 set     FMC_DATAW0S7U_data_11       BIT11
 set     FMC_DATAW0S7U_data_12       BIT12
 set     FMC_DATAW0S7U_data_13       BIT13
 set     FMC_DATAW0S7U_data_14       BIT14
 set     FMC_DATAW0S7U_data_15       BIT15
 set     FMC_DATAW0S7U_data_16       BIT16
 set     FMC_DATAW0S7U_data_17       BIT17
 set     FMC_DATAW0S7U_data_18       BIT18
 set     FMC_DATAW0S7U_data_19       BIT19
 set     FMC_DATAW0S7U_data_20       BIT20
 set     FMC_DATAW0S7U_data_21       BIT21
 set     FMC_DATAW0S7U_data_22       BIT22
 set     FMC_DATAW0S7U_data_23       BIT23
 set     FMC_DATAW0S7U_data_24       BIT24
 set     FMC_DATAW0S7U_data_25       BIT25
 set     FMC_DATAW0S7U_data_26       BIT26
 set     FMC_DATAW0S7U_data_27       BIT27
 set     FMC_DATAW0S7U_data_28       BIT28
 set     FMC_DATAW0S7U_data_29       BIT29
 set     FMC_DATAW0S7U_data_30       BIT30
 set     FMC_DATAW0S7U_data_31       BIT31

 set     FMC_DATAW0S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW0S7L_data_0        BIT0
 set     FMC_DATAW0S7L_data_1        BIT1
 set     FMC_DATAW0S7L_data_2        BIT2
 set     FMC_DATAW0S7L_data_3        BIT3
 set     FMC_DATAW0S7L_data_4        BIT4
 set     FMC_DATAW0S7L_data_5        BIT5
 set     FMC_DATAW0S7L_data_6        BIT6
 set     FMC_DATAW0S7L_data_7        BIT7
 set     FMC_DATAW0S7L_data_8        BIT8
 set     FMC_DATAW0S7L_data_9        BIT9
 set     FMC_DATAW0S7L_data_10       BIT10
 set     FMC_DATAW0S7L_data_11       BIT11
 set     FMC_DATAW0S7L_data_12       BIT12
 set     FMC_DATAW0S7L_data_13       BIT13
 set     FMC_DATAW0S7L_data_14       BIT14
 set     FMC_DATAW0S7L_data_15       BIT15
 set     FMC_DATAW0S7L_data_16       BIT16
 set     FMC_DATAW0S7L_data_17       BIT17
 set     FMC_DATAW0S7L_data_18       BIT18
 set     FMC_DATAW0S7L_data_19       BIT19
 set     FMC_DATAW0S7L_data_20       BIT20
 set     FMC_DATAW0S7L_data_21       BIT21
 set     FMC_DATAW0S7L_data_22       BIT22
 set     FMC_DATAW0S7L_data_23       BIT23
 set     FMC_DATAW0S7L_data_24       BIT24
 set     FMC_DATAW0S7L_data_25       BIT25
 set     FMC_DATAW0S7L_data_26       BIT26
 set     FMC_DATAW0S7L_data_27       BIT27
 set     FMC_DATAW0S7L_data_28       BIT28
 set     FMC_DATAW0S7L_data_29       BIT29
 set     FMC_DATAW0S7L_data_30       BIT30
 set     FMC_DATAW0S7L_data_31       BIT31

 set     FMC_DATAW1S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S0U_data_0        BIT0
 set     FMC_DATAW1S0U_data_1        BIT1
 set     FMC_DATAW1S0U_data_2        BIT2
 set     FMC_DATAW1S0U_data_3        BIT3
 set     FMC_DATAW1S0U_data_4        BIT4
 set     FMC_DATAW1S0U_data_5        BIT5
 set     FMC_DATAW1S0U_data_6        BIT6
 set     FMC_DATAW1S0U_data_7        BIT7
 set     FMC_DATAW1S0U_data_8        BIT8
 set     FMC_DATAW1S0U_data_9        BIT9
 set     FMC_DATAW1S0U_data_10       BIT10
 set     FMC_DATAW1S0U_data_11       BIT11
 set     FMC_DATAW1S0U_data_12       BIT12
 set     FMC_DATAW1S0U_data_13       BIT13
 set     FMC_DATAW1S0U_data_14       BIT14
 set     FMC_DATAW1S0U_data_15       BIT15
 set     FMC_DATAW1S0U_data_16       BIT16
 set     FMC_DATAW1S0U_data_17       BIT17
 set     FMC_DATAW1S0U_data_18       BIT18
 set     FMC_DATAW1S0U_data_19       BIT19
 set     FMC_DATAW1S0U_data_20       BIT20
 set     FMC_DATAW1S0U_data_21       BIT21
 set     FMC_DATAW1S0U_data_22       BIT22
 set     FMC_DATAW1S0U_data_23       BIT23
 set     FMC_DATAW1S0U_data_24       BIT24
 set     FMC_DATAW1S0U_data_25       BIT25
 set     FMC_DATAW1S0U_data_26       BIT26
 set     FMC_DATAW1S0U_data_27       BIT27
 set     FMC_DATAW1S0U_data_28       BIT28
 set     FMC_DATAW1S0U_data_29       BIT29
 set     FMC_DATAW1S0U_data_30       BIT30
 set     FMC_DATAW1S0U_data_31       BIT31

 set     FMC_DATAW1S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S0L_data_0        BIT0
 set     FMC_DATAW1S0L_data_1        BIT1
 set     FMC_DATAW1S0L_data_2        BIT2
 set     FMC_DATAW1S0L_data_3        BIT3
 set     FMC_DATAW1S0L_data_4        BIT4
 set     FMC_DATAW1S0L_data_5        BIT5
 set     FMC_DATAW1S0L_data_6        BIT6
 set     FMC_DATAW1S0L_data_7        BIT7
 set     FMC_DATAW1S0L_data_8        BIT8
 set     FMC_DATAW1S0L_data_9        BIT9
 set     FMC_DATAW1S0L_data_10       BIT10
 set     FMC_DATAW1S0L_data_11       BIT11
 set     FMC_DATAW1S0L_data_12       BIT12
 set     FMC_DATAW1S0L_data_13       BIT13
 set     FMC_DATAW1S0L_data_14       BIT14
 set     FMC_DATAW1S0L_data_15       BIT15
 set     FMC_DATAW1S0L_data_16       BIT16
 set     FMC_DATAW1S0L_data_17       BIT17
 set     FMC_DATAW1S0L_data_18       BIT18
 set     FMC_DATAW1S0L_data_19       BIT19
 set     FMC_DATAW1S0L_data_20       BIT20
 set     FMC_DATAW1S0L_data_21       BIT21
 set     FMC_DATAW1S0L_data_22       BIT22
 set     FMC_DATAW1S0L_data_23       BIT23
 set     FMC_DATAW1S0L_data_24       BIT24
 set     FMC_DATAW1S0L_data_25       BIT25
 set     FMC_DATAW1S0L_data_26       BIT26
 set     FMC_DATAW1S0L_data_27       BIT27
 set     FMC_DATAW1S0L_data_28       BIT28
 set     FMC_DATAW1S0L_data_29       BIT29
 set     FMC_DATAW1S0L_data_30       BIT30
 set     FMC_DATAW1S0L_data_31       BIT31

 set     FMC_DATAW1S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S1U_data_0        BIT0
 set     FMC_DATAW1S1U_data_1        BIT1
 set     FMC_DATAW1S1U_data_2        BIT2
 set     FMC_DATAW1S1U_data_3        BIT3
 set     FMC_DATAW1S1U_data_4        BIT4
 set     FMC_DATAW1S1U_data_5        BIT5
 set     FMC_DATAW1S1U_data_6        BIT6
 set     FMC_DATAW1S1U_data_7        BIT7
 set     FMC_DATAW1S1U_data_8        BIT8
 set     FMC_DATAW1S1U_data_9        BIT9
 set     FMC_DATAW1S1U_data_10       BIT10
 set     FMC_DATAW1S1U_data_11       BIT11
 set     FMC_DATAW1S1U_data_12       BIT12
 set     FMC_DATAW1S1U_data_13       BIT13
 set     FMC_DATAW1S1U_data_14       BIT14
 set     FMC_DATAW1S1U_data_15       BIT15
 set     FMC_DATAW1S1U_data_16       BIT16
 set     FMC_DATAW1S1U_data_17       BIT17
 set     FMC_DATAW1S1U_data_18       BIT18
 set     FMC_DATAW1S1U_data_19       BIT19
 set     FMC_DATAW1S1U_data_20       BIT20
 set     FMC_DATAW1S1U_data_21       BIT21
 set     FMC_DATAW1S1U_data_22       BIT22
 set     FMC_DATAW1S1U_data_23       BIT23
 set     FMC_DATAW1S1U_data_24       BIT24
 set     FMC_DATAW1S1U_data_25       BIT25
 set     FMC_DATAW1S1U_data_26       BIT26
 set     FMC_DATAW1S1U_data_27       BIT27
 set     FMC_DATAW1S1U_data_28       BIT28
 set     FMC_DATAW1S1U_data_29       BIT29
 set     FMC_DATAW1S1U_data_30       BIT30
 set     FMC_DATAW1S1U_data_31       BIT31

 set     FMC_DATAW1S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S1L_data_0        BIT0
 set     FMC_DATAW1S1L_data_1        BIT1
 set     FMC_DATAW1S1L_data_2        BIT2
 set     FMC_DATAW1S1L_data_3        BIT3
 set     FMC_DATAW1S1L_data_4        BIT4
 set     FMC_DATAW1S1L_data_5        BIT5
 set     FMC_DATAW1S1L_data_6        BIT6
 set     FMC_DATAW1S1L_data_7        BIT7
 set     FMC_DATAW1S1L_data_8        BIT8
 set     FMC_DATAW1S1L_data_9        BIT9
 set     FMC_DATAW1S1L_data_10       BIT10
 set     FMC_DATAW1S1L_data_11       BIT11
 set     FMC_DATAW1S1L_data_12       BIT12
 set     FMC_DATAW1S1L_data_13       BIT13
 set     FMC_DATAW1S1L_data_14       BIT14
 set     FMC_DATAW1S1L_data_15       BIT15
 set     FMC_DATAW1S1L_data_16       BIT16
 set     FMC_DATAW1S1L_data_17       BIT17
 set     FMC_DATAW1S1L_data_18       BIT18
 set     FMC_DATAW1S1L_data_19       BIT19
 set     FMC_DATAW1S1L_data_20       BIT20
 set     FMC_DATAW1S1L_data_21       BIT21
 set     FMC_DATAW1S1L_data_22       BIT22
 set     FMC_DATAW1S1L_data_23       BIT23
 set     FMC_DATAW1S1L_data_24       BIT24
 set     FMC_DATAW1S1L_data_25       BIT25
 set     FMC_DATAW1S1L_data_26       BIT26
 set     FMC_DATAW1S1L_data_27       BIT27
 set     FMC_DATAW1S1L_data_28       BIT28
 set     FMC_DATAW1S1L_data_29       BIT29
 set     FMC_DATAW1S1L_data_30       BIT30
 set     FMC_DATAW1S1L_data_31       BIT31

 set     FMC_DATAW1S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S2U_data_0        BIT0
 set     FMC_DATAW1S2U_data_1        BIT1
 set     FMC_DATAW1S2U_data_2        BIT2
 set     FMC_DATAW1S2U_data_3        BIT3
 set     FMC_DATAW1S2U_data_4        BIT4
 set     FMC_DATAW1S2U_data_5        BIT5
 set     FMC_DATAW1S2U_data_6        BIT6
 set     FMC_DATAW1S2U_data_7        BIT7
 set     FMC_DATAW1S2U_data_8        BIT8
 set     FMC_DATAW1S2U_data_9        BIT9
 set     FMC_DATAW1S2U_data_10       BIT10
 set     FMC_DATAW1S2U_data_11       BIT11
 set     FMC_DATAW1S2U_data_12       BIT12
 set     FMC_DATAW1S2U_data_13       BIT13
 set     FMC_DATAW1S2U_data_14       BIT14
 set     FMC_DATAW1S2U_data_15       BIT15
 set     FMC_DATAW1S2U_data_16       BIT16
 set     FMC_DATAW1S2U_data_17       BIT17
 set     FMC_DATAW1S2U_data_18       BIT18
 set     FMC_DATAW1S2U_data_19       BIT19
 set     FMC_DATAW1S2U_data_20       BIT20
 set     FMC_DATAW1S2U_data_21       BIT21
 set     FMC_DATAW1S2U_data_22       BIT22
 set     FMC_DATAW1S2U_data_23       BIT23
 set     FMC_DATAW1S2U_data_24       BIT24
 set     FMC_DATAW1S2U_data_25       BIT25
 set     FMC_DATAW1S2U_data_26       BIT26
 set     FMC_DATAW1S2U_data_27       BIT27
 set     FMC_DATAW1S2U_data_28       BIT28
 set     FMC_DATAW1S2U_data_29       BIT29
 set     FMC_DATAW1S2U_data_30       BIT30
 set     FMC_DATAW1S2U_data_31       BIT31

 set     FMC_DATAW1S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S2L_data_0        BIT0
 set     FMC_DATAW1S2L_data_1        BIT1
 set     FMC_DATAW1S2L_data_2        BIT2
 set     FMC_DATAW1S2L_data_3        BIT3
 set     FMC_DATAW1S2L_data_4        BIT4
 set     FMC_DATAW1S2L_data_5        BIT5
 set     FMC_DATAW1S2L_data_6        BIT6
 set     FMC_DATAW1S2L_data_7        BIT7
 set     FMC_DATAW1S2L_data_8        BIT8
 set     FMC_DATAW1S2L_data_9        BIT9
 set     FMC_DATAW1S2L_data_10       BIT10
 set     FMC_DATAW1S2L_data_11       BIT11
 set     FMC_DATAW1S2L_data_12       BIT12
 set     FMC_DATAW1S2L_data_13       BIT13
 set     FMC_DATAW1S2L_data_14       BIT14
 set     FMC_DATAW1S2L_data_15       BIT15
 set     FMC_DATAW1S2L_data_16       BIT16
 set     FMC_DATAW1S2L_data_17       BIT17
 set     FMC_DATAW1S2L_data_18       BIT18
 set     FMC_DATAW1S2L_data_19       BIT19
 set     FMC_DATAW1S2L_data_20       BIT20
 set     FMC_DATAW1S2L_data_21       BIT21
 set     FMC_DATAW1S2L_data_22       BIT22
 set     FMC_DATAW1S2L_data_23       BIT23
 set     FMC_DATAW1S2L_data_24       BIT24
 set     FMC_DATAW1S2L_data_25       BIT25
 set     FMC_DATAW1S2L_data_26       BIT26
 set     FMC_DATAW1S2L_data_27       BIT27
 set     FMC_DATAW1S2L_data_28       BIT28
 set     FMC_DATAW1S2L_data_29       BIT29
 set     FMC_DATAW1S2L_data_30       BIT30
 set     FMC_DATAW1S2L_data_31       BIT31

 set     FMC_DATAW1S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S3U_data_0        BIT0
 set     FMC_DATAW1S3U_data_1        BIT1
 set     FMC_DATAW1S3U_data_2        BIT2
 set     FMC_DATAW1S3U_data_3        BIT3
 set     FMC_DATAW1S3U_data_4        BIT4
 set     FMC_DATAW1S3U_data_5        BIT5
 set     FMC_DATAW1S3U_data_6        BIT6
 set     FMC_DATAW1S3U_data_7        BIT7
 set     FMC_DATAW1S3U_data_8        BIT8
 set     FMC_DATAW1S3U_data_9        BIT9
 set     FMC_DATAW1S3U_data_10       BIT10
 set     FMC_DATAW1S3U_data_11       BIT11
 set     FMC_DATAW1S3U_data_12       BIT12
 set     FMC_DATAW1S3U_data_13       BIT13
 set     FMC_DATAW1S3U_data_14       BIT14
 set     FMC_DATAW1S3U_data_15       BIT15
 set     FMC_DATAW1S3U_data_16       BIT16
 set     FMC_DATAW1S3U_data_17       BIT17
 set     FMC_DATAW1S3U_data_18       BIT18
 set     FMC_DATAW1S3U_data_19       BIT19
 set     FMC_DATAW1S3U_data_20       BIT20
 set     FMC_DATAW1S3U_data_21       BIT21
 set     FMC_DATAW1S3U_data_22       BIT22
 set     FMC_DATAW1S3U_data_23       BIT23
 set     FMC_DATAW1S3U_data_24       BIT24
 set     FMC_DATAW1S3U_data_25       BIT25
 set     FMC_DATAW1S3U_data_26       BIT26
 set     FMC_DATAW1S3U_data_27       BIT27
 set     FMC_DATAW1S3U_data_28       BIT28
 set     FMC_DATAW1S3U_data_29       BIT29
 set     FMC_DATAW1S3U_data_30       BIT30
 set     FMC_DATAW1S3U_data_31       BIT31

 set     FMC_DATAW1S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S3L_data_0        BIT0
 set     FMC_DATAW1S3L_data_1        BIT1
 set     FMC_DATAW1S3L_data_2        BIT2
 set     FMC_DATAW1S3L_data_3        BIT3
 set     FMC_DATAW1S3L_data_4        BIT4
 set     FMC_DATAW1S3L_data_5        BIT5
 set     FMC_DATAW1S3L_data_6        BIT6
 set     FMC_DATAW1S3L_data_7        BIT7
 set     FMC_DATAW1S3L_data_8        BIT8
 set     FMC_DATAW1S3L_data_9        BIT9
 set     FMC_DATAW1S3L_data_10       BIT10
 set     FMC_DATAW1S3L_data_11       BIT11
 set     FMC_DATAW1S3L_data_12       BIT12
 set     FMC_DATAW1S3L_data_13       BIT13
 set     FMC_DATAW1S3L_data_14       BIT14
 set     FMC_DATAW1S3L_data_15       BIT15
 set     FMC_DATAW1S3L_data_16       BIT16
 set     FMC_DATAW1S3L_data_17       BIT17
 set     FMC_DATAW1S3L_data_18       BIT18
 set     FMC_DATAW1S3L_data_19       BIT19
 set     FMC_DATAW1S3L_data_20       BIT20
 set     FMC_DATAW1S3L_data_21       BIT21
 set     FMC_DATAW1S3L_data_22       BIT22
 set     FMC_DATAW1S3L_data_23       BIT23
 set     FMC_DATAW1S3L_data_24       BIT24
 set     FMC_DATAW1S3L_data_25       BIT25
 set     FMC_DATAW1S3L_data_26       BIT26
 set     FMC_DATAW1S3L_data_27       BIT27
 set     FMC_DATAW1S3L_data_28       BIT28
 set     FMC_DATAW1S3L_data_29       BIT29
 set     FMC_DATAW1S3L_data_30       BIT30
 set     FMC_DATAW1S3L_data_31       BIT31

 set     FMC_DATAW1S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S4U_data_0        BIT0
 set     FMC_DATAW1S4U_data_1        BIT1
 set     FMC_DATAW1S4U_data_2        BIT2
 set     FMC_DATAW1S4U_data_3        BIT3
 set     FMC_DATAW1S4U_data_4        BIT4
 set     FMC_DATAW1S4U_data_5        BIT5
 set     FMC_DATAW1S4U_data_6        BIT6
 set     FMC_DATAW1S4U_data_7        BIT7
 set     FMC_DATAW1S4U_data_8        BIT8
 set     FMC_DATAW1S4U_data_9        BIT9
 set     FMC_DATAW1S4U_data_10       BIT10
 set     FMC_DATAW1S4U_data_11       BIT11
 set     FMC_DATAW1S4U_data_12       BIT12
 set     FMC_DATAW1S4U_data_13       BIT13
 set     FMC_DATAW1S4U_data_14       BIT14
 set     FMC_DATAW1S4U_data_15       BIT15
 set     FMC_DATAW1S4U_data_16       BIT16
 set     FMC_DATAW1S4U_data_17       BIT17
 set     FMC_DATAW1S4U_data_18       BIT18
 set     FMC_DATAW1S4U_data_19       BIT19
 set     FMC_DATAW1S4U_data_20       BIT20
 set     FMC_DATAW1S4U_data_21       BIT21
 set     FMC_DATAW1S4U_data_22       BIT22
 set     FMC_DATAW1S4U_data_23       BIT23
 set     FMC_DATAW1S4U_data_24       BIT24
 set     FMC_DATAW1S4U_data_25       BIT25
 set     FMC_DATAW1S4U_data_26       BIT26
 set     FMC_DATAW1S4U_data_27       BIT27
 set     FMC_DATAW1S4U_data_28       BIT28
 set     FMC_DATAW1S4U_data_29       BIT29
 set     FMC_DATAW1S4U_data_30       BIT30
 set     FMC_DATAW1S4U_data_31       BIT31

 set     FMC_DATAW1S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S4L_data_0        BIT0
 set     FMC_DATAW1S4L_data_1        BIT1
 set     FMC_DATAW1S4L_data_2        BIT2
 set     FMC_DATAW1S4L_data_3        BIT3
 set     FMC_DATAW1S4L_data_4        BIT4
 set     FMC_DATAW1S4L_data_5        BIT5
 set     FMC_DATAW1S4L_data_6        BIT6
 set     FMC_DATAW1S4L_data_7        BIT7
 set     FMC_DATAW1S4L_data_8        BIT8
 set     FMC_DATAW1S4L_data_9        BIT9
 set     FMC_DATAW1S4L_data_10       BIT10
 set     FMC_DATAW1S4L_data_11       BIT11
 set     FMC_DATAW1S4L_data_12       BIT12
 set     FMC_DATAW1S4L_data_13       BIT13
 set     FMC_DATAW1S4L_data_14       BIT14
 set     FMC_DATAW1S4L_data_15       BIT15
 set     FMC_DATAW1S4L_data_16       BIT16
 set     FMC_DATAW1S4L_data_17       BIT17
 set     FMC_DATAW1S4L_data_18       BIT18
 set     FMC_DATAW1S4L_data_19       BIT19
 set     FMC_DATAW1S4L_data_20       BIT20
 set     FMC_DATAW1S4L_data_21       BIT21
 set     FMC_DATAW1S4L_data_22       BIT22
 set     FMC_DATAW1S4L_data_23       BIT23
 set     FMC_DATAW1S4L_data_24       BIT24
 set     FMC_DATAW1S4L_data_25       BIT25
 set     FMC_DATAW1S4L_data_26       BIT26
 set     FMC_DATAW1S4L_data_27       BIT27
 set     FMC_DATAW1S4L_data_28       BIT28
 set     FMC_DATAW1S4L_data_29       BIT29
 set     FMC_DATAW1S4L_data_30       BIT30
 set     FMC_DATAW1S4L_data_31       BIT31

 set     FMC_DATAW1S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S5U_data_0        BIT0
 set     FMC_DATAW1S5U_data_1        BIT1
 set     FMC_DATAW1S5U_data_2        BIT2
 set     FMC_DATAW1S5U_data_3        BIT3
 set     FMC_DATAW1S5U_data_4        BIT4
 set     FMC_DATAW1S5U_data_5        BIT5
 set     FMC_DATAW1S5U_data_6        BIT6
 set     FMC_DATAW1S5U_data_7        BIT7
 set     FMC_DATAW1S5U_data_8        BIT8
 set     FMC_DATAW1S5U_data_9        BIT9
 set     FMC_DATAW1S5U_data_10       BIT10
 set     FMC_DATAW1S5U_data_11       BIT11
 set     FMC_DATAW1S5U_data_12       BIT12
 set     FMC_DATAW1S5U_data_13       BIT13
 set     FMC_DATAW1S5U_data_14       BIT14
 set     FMC_DATAW1S5U_data_15       BIT15
 set     FMC_DATAW1S5U_data_16       BIT16
 set     FMC_DATAW1S5U_data_17       BIT17
 set     FMC_DATAW1S5U_data_18       BIT18
 set     FMC_DATAW1S5U_data_19       BIT19
 set     FMC_DATAW1S5U_data_20       BIT20
 set     FMC_DATAW1S5U_data_21       BIT21
 set     FMC_DATAW1S5U_data_22       BIT22
 set     FMC_DATAW1S5U_data_23       BIT23
 set     FMC_DATAW1S5U_data_24       BIT24
 set     FMC_DATAW1S5U_data_25       BIT25
 set     FMC_DATAW1S5U_data_26       BIT26
 set     FMC_DATAW1S5U_data_27       BIT27
 set     FMC_DATAW1S5U_data_28       BIT28
 set     FMC_DATAW1S5U_data_29       BIT29
 set     FMC_DATAW1S5U_data_30       BIT30
 set     FMC_DATAW1S5U_data_31       BIT31

 set     FMC_DATAW1S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S5L_data_0        BIT0
 set     FMC_DATAW1S5L_data_1        BIT1
 set     FMC_DATAW1S5L_data_2        BIT2
 set     FMC_DATAW1S5L_data_3        BIT3
 set     FMC_DATAW1S5L_data_4        BIT4
 set     FMC_DATAW1S5L_data_5        BIT5
 set     FMC_DATAW1S5L_data_6        BIT6
 set     FMC_DATAW1S5L_data_7        BIT7
 set     FMC_DATAW1S5L_data_8        BIT8
 set     FMC_DATAW1S5L_data_9        BIT9
 set     FMC_DATAW1S5L_data_10       BIT10
 set     FMC_DATAW1S5L_data_11       BIT11
 set     FMC_DATAW1S5L_data_12       BIT12
 set     FMC_DATAW1S5L_data_13       BIT13
 set     FMC_DATAW1S5L_data_14       BIT14
 set     FMC_DATAW1S5L_data_15       BIT15
 set     FMC_DATAW1S5L_data_16       BIT16
 set     FMC_DATAW1S5L_data_17       BIT17
 set     FMC_DATAW1S5L_data_18       BIT18
 set     FMC_DATAW1S5L_data_19       BIT19
 set     FMC_DATAW1S5L_data_20       BIT20
 set     FMC_DATAW1S5L_data_21       BIT21
 set     FMC_DATAW1S5L_data_22       BIT22
 set     FMC_DATAW1S5L_data_23       BIT23
 set     FMC_DATAW1S5L_data_24       BIT24
 set     FMC_DATAW1S5L_data_25       BIT25
 set     FMC_DATAW1S5L_data_26       BIT26
 set     FMC_DATAW1S5L_data_27       BIT27
 set     FMC_DATAW1S5L_data_28       BIT28
 set     FMC_DATAW1S5L_data_29       BIT29
 set     FMC_DATAW1S5L_data_30       BIT30
 set     FMC_DATAW1S5L_data_31       BIT31

 set     FMC_DATAW1S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S6U_data_0        BIT0
 set     FMC_DATAW1S6U_data_1        BIT1
 set     FMC_DATAW1S6U_data_2        BIT2
 set     FMC_DATAW1S6U_data_3        BIT3
 set     FMC_DATAW1S6U_data_4        BIT4
 set     FMC_DATAW1S6U_data_5        BIT5
 set     FMC_DATAW1S6U_data_6        BIT6
 set     FMC_DATAW1S6U_data_7        BIT7
 set     FMC_DATAW1S6U_data_8        BIT8
 set     FMC_DATAW1S6U_data_9        BIT9
 set     FMC_DATAW1S6U_data_10       BIT10
 set     FMC_DATAW1S6U_data_11       BIT11
 set     FMC_DATAW1S6U_data_12       BIT12
 set     FMC_DATAW1S6U_data_13       BIT13
 set     FMC_DATAW1S6U_data_14       BIT14
 set     FMC_DATAW1S6U_data_15       BIT15
 set     FMC_DATAW1S6U_data_16       BIT16
 set     FMC_DATAW1S6U_data_17       BIT17
 set     FMC_DATAW1S6U_data_18       BIT18
 set     FMC_DATAW1S6U_data_19       BIT19
 set     FMC_DATAW1S6U_data_20       BIT20
 set     FMC_DATAW1S6U_data_21       BIT21
 set     FMC_DATAW1S6U_data_22       BIT22
 set     FMC_DATAW1S6U_data_23       BIT23
 set     FMC_DATAW1S6U_data_24       BIT24
 set     FMC_DATAW1S6U_data_25       BIT25
 set     FMC_DATAW1S6U_data_26       BIT26
 set     FMC_DATAW1S6U_data_27       BIT27
 set     FMC_DATAW1S6U_data_28       BIT28
 set     FMC_DATAW1S6U_data_29       BIT29
 set     FMC_DATAW1S6U_data_30       BIT30
 set     FMC_DATAW1S6U_data_31       BIT31

 set     FMC_DATAW1S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S6L_data_0        BIT0
 set     FMC_DATAW1S6L_data_1        BIT1
 set     FMC_DATAW1S6L_data_2        BIT2
 set     FMC_DATAW1S6L_data_3        BIT3
 set     FMC_DATAW1S6L_data_4        BIT4
 set     FMC_DATAW1S6L_data_5        BIT5
 set     FMC_DATAW1S6L_data_6        BIT6
 set     FMC_DATAW1S6L_data_7        BIT7
 set     FMC_DATAW1S6L_data_8        BIT8
 set     FMC_DATAW1S6L_data_9        BIT9
 set     FMC_DATAW1S6L_data_10       BIT10
 set     FMC_DATAW1S6L_data_11       BIT11
 set     FMC_DATAW1S6L_data_12       BIT12
 set     FMC_DATAW1S6L_data_13       BIT13
 set     FMC_DATAW1S6L_data_14       BIT14
 set     FMC_DATAW1S6L_data_15       BIT15
 set     FMC_DATAW1S6L_data_16       BIT16
 set     FMC_DATAW1S6L_data_17       BIT17
 set     FMC_DATAW1S6L_data_18       BIT18
 set     FMC_DATAW1S6L_data_19       BIT19
 set     FMC_DATAW1S6L_data_20       BIT20
 set     FMC_DATAW1S6L_data_21       BIT21
 set     FMC_DATAW1S6L_data_22       BIT22
 set     FMC_DATAW1S6L_data_23       BIT23
 set     FMC_DATAW1S6L_data_24       BIT24
 set     FMC_DATAW1S6L_data_25       BIT25
 set     FMC_DATAW1S6L_data_26       BIT26
 set     FMC_DATAW1S6L_data_27       BIT27
 set     FMC_DATAW1S6L_data_28       BIT28
 set     FMC_DATAW1S6L_data_29       BIT29
 set     FMC_DATAW1S6L_data_30       BIT30
 set     FMC_DATAW1S6L_data_31       BIT31

 set     FMC_DATAW1S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW1S7U_data_0        BIT0
 set     FMC_DATAW1S7U_data_1        BIT1
 set     FMC_DATAW1S7U_data_2        BIT2
 set     FMC_DATAW1S7U_data_3        BIT3
 set     FMC_DATAW1S7U_data_4        BIT4
 set     FMC_DATAW1S7U_data_5        BIT5
 set     FMC_DATAW1S7U_data_6        BIT6
 set     FMC_DATAW1S7U_data_7        BIT7
 set     FMC_DATAW1S7U_data_8        BIT8
 set     FMC_DATAW1S7U_data_9        BIT9
 set     FMC_DATAW1S7U_data_10       BIT10
 set     FMC_DATAW1S7U_data_11       BIT11
 set     FMC_DATAW1S7U_data_12       BIT12
 set     FMC_DATAW1S7U_data_13       BIT13
 set     FMC_DATAW1S7U_data_14       BIT14
 set     FMC_DATAW1S7U_data_15       BIT15
 set     FMC_DATAW1S7U_data_16       BIT16
 set     FMC_DATAW1S7U_data_17       BIT17
 set     FMC_DATAW1S7U_data_18       BIT18
 set     FMC_DATAW1S7U_data_19       BIT19
 set     FMC_DATAW1S7U_data_20       BIT20
 set     FMC_DATAW1S7U_data_21       BIT21
 set     FMC_DATAW1S7U_data_22       BIT22
 set     FMC_DATAW1S7U_data_23       BIT23
 set     FMC_DATAW1S7U_data_24       BIT24
 set     FMC_DATAW1S7U_data_25       BIT25
 set     FMC_DATAW1S7U_data_26       BIT26
 set     FMC_DATAW1S7U_data_27       BIT27
 set     FMC_DATAW1S7U_data_28       BIT28
 set     FMC_DATAW1S7U_data_29       BIT29
 set     FMC_DATAW1S7U_data_30       BIT30
 set     FMC_DATAW1S7U_data_31       BIT31

 set     FMC_DATAW1S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW1S7L_data_0        BIT0
 set     FMC_DATAW1S7L_data_1        BIT1
 set     FMC_DATAW1S7L_data_2        BIT2
 set     FMC_DATAW1S7L_data_3        BIT3
 set     FMC_DATAW1S7L_data_4        BIT4
 set     FMC_DATAW1S7L_data_5        BIT5
 set     FMC_DATAW1S7L_data_6        BIT6
 set     FMC_DATAW1S7L_data_7        BIT7
 set     FMC_DATAW1S7L_data_8        BIT8
 set     FMC_DATAW1S7L_data_9        BIT9
 set     FMC_DATAW1S7L_data_10       BIT10
 set     FMC_DATAW1S7L_data_11       BIT11
 set     FMC_DATAW1S7L_data_12       BIT12
 set     FMC_DATAW1S7L_data_13       BIT13
 set     FMC_DATAW1S7L_data_14       BIT14
 set     FMC_DATAW1S7L_data_15       BIT15
 set     FMC_DATAW1S7L_data_16       BIT16
 set     FMC_DATAW1S7L_data_17       BIT17
 set     FMC_DATAW1S7L_data_18       BIT18
 set     FMC_DATAW1S7L_data_19       BIT19
 set     FMC_DATAW1S7L_data_20       BIT20
 set     FMC_DATAW1S7L_data_21       BIT21
 set     FMC_DATAW1S7L_data_22       BIT22
 set     FMC_DATAW1S7L_data_23       BIT23
 set     FMC_DATAW1S7L_data_24       BIT24
 set     FMC_DATAW1S7L_data_25       BIT25
 set     FMC_DATAW1S7L_data_26       BIT26
 set     FMC_DATAW1S7L_data_27       BIT27
 set     FMC_DATAW1S7L_data_28       BIT28
 set     FMC_DATAW1S7L_data_29       BIT29
 set     FMC_DATAW1S7L_data_30       BIT30
 set     FMC_DATAW1S7L_data_31       BIT31

 set     FMC_DATAW2S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S0U_data_0        BIT0
 set     FMC_DATAW2S0U_data_1        BIT1
 set     FMC_DATAW2S0U_data_2        BIT2
 set     FMC_DATAW2S0U_data_3        BIT3
 set     FMC_DATAW2S0U_data_4        BIT4
 set     FMC_DATAW2S0U_data_5        BIT5
 set     FMC_DATAW2S0U_data_6        BIT6
 set     FMC_DATAW2S0U_data_7        BIT7
 set     FMC_DATAW2S0U_data_8        BIT8
 set     FMC_DATAW2S0U_data_9        BIT9
 set     FMC_DATAW2S0U_data_10       BIT10
 set     FMC_DATAW2S0U_data_11       BIT11
 set     FMC_DATAW2S0U_data_12       BIT12
 set     FMC_DATAW2S0U_data_13       BIT13
 set     FMC_DATAW2S0U_data_14       BIT14
 set     FMC_DATAW2S0U_data_15       BIT15
 set     FMC_DATAW2S0U_data_16       BIT16
 set     FMC_DATAW2S0U_data_17       BIT17
 set     FMC_DATAW2S0U_data_18       BIT18
 set     FMC_DATAW2S0U_data_19       BIT19
 set     FMC_DATAW2S0U_data_20       BIT20
 set     FMC_DATAW2S0U_data_21       BIT21
 set     FMC_DATAW2S0U_data_22       BIT22
 set     FMC_DATAW2S0U_data_23       BIT23
 set     FMC_DATAW2S0U_data_24       BIT24
 set     FMC_DATAW2S0U_data_25       BIT25
 set     FMC_DATAW2S0U_data_26       BIT26
 set     FMC_DATAW2S0U_data_27       BIT27
 set     FMC_DATAW2S0U_data_28       BIT28
 set     FMC_DATAW2S0U_data_29       BIT29
 set     FMC_DATAW2S0U_data_30       BIT30
 set     FMC_DATAW2S0U_data_31       BIT31

 set     FMC_DATAW2S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S0L_data_0        BIT0
 set     FMC_DATAW2S0L_data_1        BIT1
 set     FMC_DATAW2S0L_data_2        BIT2
 set     FMC_DATAW2S0L_data_3        BIT3
 set     FMC_DATAW2S0L_data_4        BIT4
 set     FMC_DATAW2S0L_data_5        BIT5
 set     FMC_DATAW2S0L_data_6        BIT6
 set     FMC_DATAW2S0L_data_7        BIT7
 set     FMC_DATAW2S0L_data_8        BIT8
 set     FMC_DATAW2S0L_data_9        BIT9
 set     FMC_DATAW2S0L_data_10       BIT10
 set     FMC_DATAW2S0L_data_11       BIT11
 set     FMC_DATAW2S0L_data_12       BIT12
 set     FMC_DATAW2S0L_data_13       BIT13
 set     FMC_DATAW2S0L_data_14       BIT14
 set     FMC_DATAW2S0L_data_15       BIT15
 set     FMC_DATAW2S0L_data_16       BIT16
 set     FMC_DATAW2S0L_data_17       BIT17
 set     FMC_DATAW2S0L_data_18       BIT18
 set     FMC_DATAW2S0L_data_19       BIT19
 set     FMC_DATAW2S0L_data_20       BIT20
 set     FMC_DATAW2S0L_data_21       BIT21
 set     FMC_DATAW2S0L_data_22       BIT22
 set     FMC_DATAW2S0L_data_23       BIT23
 set     FMC_DATAW2S0L_data_24       BIT24
 set     FMC_DATAW2S0L_data_25       BIT25
 set     FMC_DATAW2S0L_data_26       BIT26
 set     FMC_DATAW2S0L_data_27       BIT27
 set     FMC_DATAW2S0L_data_28       BIT28
 set     FMC_DATAW2S0L_data_29       BIT29
 set     FMC_DATAW2S0L_data_30       BIT30
 set     FMC_DATAW2S0L_data_31       BIT31

 set     FMC_DATAW2S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S1U_data_0        BIT0
 set     FMC_DATAW2S1U_data_1        BIT1
 set     FMC_DATAW2S1U_data_2        BIT2
 set     FMC_DATAW2S1U_data_3        BIT3
 set     FMC_DATAW2S1U_data_4        BIT4
 set     FMC_DATAW2S1U_data_5        BIT5
 set     FMC_DATAW2S1U_data_6        BIT6
 set     FMC_DATAW2S1U_data_7        BIT7
 set     FMC_DATAW2S1U_data_8        BIT8
 set     FMC_DATAW2S1U_data_9        BIT9
 set     FMC_DATAW2S1U_data_10       BIT10
 set     FMC_DATAW2S1U_data_11       BIT11
 set     FMC_DATAW2S1U_data_12       BIT12
 set     FMC_DATAW2S1U_data_13       BIT13
 set     FMC_DATAW2S1U_data_14       BIT14
 set     FMC_DATAW2S1U_data_15       BIT15
 set     FMC_DATAW2S1U_data_16       BIT16
 set     FMC_DATAW2S1U_data_17       BIT17
 set     FMC_DATAW2S1U_data_18       BIT18
 set     FMC_DATAW2S1U_data_19       BIT19
 set     FMC_DATAW2S1U_data_20       BIT20
 set     FMC_DATAW2S1U_data_21       BIT21
 set     FMC_DATAW2S1U_data_22       BIT22
 set     FMC_DATAW2S1U_data_23       BIT23
 set     FMC_DATAW2S1U_data_24       BIT24
 set     FMC_DATAW2S1U_data_25       BIT25
 set     FMC_DATAW2S1U_data_26       BIT26
 set     FMC_DATAW2S1U_data_27       BIT27
 set     FMC_DATAW2S1U_data_28       BIT28
 set     FMC_DATAW2S1U_data_29       BIT29
 set     FMC_DATAW2S1U_data_30       BIT30
 set     FMC_DATAW2S1U_data_31       BIT31

 set     FMC_DATAW2S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S1L_data_0        BIT0
 set     FMC_DATAW2S1L_data_1        BIT1
 set     FMC_DATAW2S1L_data_2        BIT2
 set     FMC_DATAW2S1L_data_3        BIT3
 set     FMC_DATAW2S1L_data_4        BIT4
 set     FMC_DATAW2S1L_data_5        BIT5
 set     FMC_DATAW2S1L_data_6        BIT6
 set     FMC_DATAW2S1L_data_7        BIT7
 set     FMC_DATAW2S1L_data_8        BIT8
 set     FMC_DATAW2S1L_data_9        BIT9
 set     FMC_DATAW2S1L_data_10       BIT10
 set     FMC_DATAW2S1L_data_11       BIT11
 set     FMC_DATAW2S1L_data_12       BIT12
 set     FMC_DATAW2S1L_data_13       BIT13
 set     FMC_DATAW2S1L_data_14       BIT14
 set     FMC_DATAW2S1L_data_15       BIT15
 set     FMC_DATAW2S1L_data_16       BIT16
 set     FMC_DATAW2S1L_data_17       BIT17
 set     FMC_DATAW2S1L_data_18       BIT18
 set     FMC_DATAW2S1L_data_19       BIT19
 set     FMC_DATAW2S1L_data_20       BIT20
 set     FMC_DATAW2S1L_data_21       BIT21
 set     FMC_DATAW2S1L_data_22       BIT22
 set     FMC_DATAW2S1L_data_23       BIT23
 set     FMC_DATAW2S1L_data_24       BIT24
 set     FMC_DATAW2S1L_data_25       BIT25
 set     FMC_DATAW2S1L_data_26       BIT26
 set     FMC_DATAW2S1L_data_27       BIT27
 set     FMC_DATAW2S1L_data_28       BIT28
 set     FMC_DATAW2S1L_data_29       BIT29
 set     FMC_DATAW2S1L_data_30       BIT30
 set     FMC_DATAW2S1L_data_31       BIT31

 set     FMC_DATAW2S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S2U_data_0        BIT0
 set     FMC_DATAW2S2U_data_1        BIT1
 set     FMC_DATAW2S2U_data_2        BIT2
 set     FMC_DATAW2S2U_data_3        BIT3
 set     FMC_DATAW2S2U_data_4        BIT4
 set     FMC_DATAW2S2U_data_5        BIT5
 set     FMC_DATAW2S2U_data_6        BIT6
 set     FMC_DATAW2S2U_data_7        BIT7
 set     FMC_DATAW2S2U_data_8        BIT8
 set     FMC_DATAW2S2U_data_9        BIT9
 set     FMC_DATAW2S2U_data_10       BIT10
 set     FMC_DATAW2S2U_data_11       BIT11
 set     FMC_DATAW2S2U_data_12       BIT12
 set     FMC_DATAW2S2U_data_13       BIT13
 set     FMC_DATAW2S2U_data_14       BIT14
 set     FMC_DATAW2S2U_data_15       BIT15
 set     FMC_DATAW2S2U_data_16       BIT16
 set     FMC_DATAW2S2U_data_17       BIT17
 set     FMC_DATAW2S2U_data_18       BIT18
 set     FMC_DATAW2S2U_data_19       BIT19
 set     FMC_DATAW2S2U_data_20       BIT20
 set     FMC_DATAW2S2U_data_21       BIT21
 set     FMC_DATAW2S2U_data_22       BIT22
 set     FMC_DATAW2S2U_data_23       BIT23
 set     FMC_DATAW2S2U_data_24       BIT24
 set     FMC_DATAW2S2U_data_25       BIT25
 set     FMC_DATAW2S2U_data_26       BIT26
 set     FMC_DATAW2S2U_data_27       BIT27
 set     FMC_DATAW2S2U_data_28       BIT28
 set     FMC_DATAW2S2U_data_29       BIT29
 set     FMC_DATAW2S2U_data_30       BIT30
 set     FMC_DATAW2S2U_data_31       BIT31

 set     FMC_DATAW2S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S2L_data_0        BIT0
 set     FMC_DATAW2S2L_data_1        BIT1
 set     FMC_DATAW2S2L_data_2        BIT2
 set     FMC_DATAW2S2L_data_3        BIT3
 set     FMC_DATAW2S2L_data_4        BIT4
 set     FMC_DATAW2S2L_data_5        BIT5
 set     FMC_DATAW2S2L_data_6        BIT6
 set     FMC_DATAW2S2L_data_7        BIT7
 set     FMC_DATAW2S2L_data_8        BIT8
 set     FMC_DATAW2S2L_data_9        BIT9
 set     FMC_DATAW2S2L_data_10       BIT10
 set     FMC_DATAW2S2L_data_11       BIT11
 set     FMC_DATAW2S2L_data_12       BIT12
 set     FMC_DATAW2S2L_data_13       BIT13
 set     FMC_DATAW2S2L_data_14       BIT14
 set     FMC_DATAW2S2L_data_15       BIT15
 set     FMC_DATAW2S2L_data_16       BIT16
 set     FMC_DATAW2S2L_data_17       BIT17
 set     FMC_DATAW2S2L_data_18       BIT18
 set     FMC_DATAW2S2L_data_19       BIT19
 set     FMC_DATAW2S2L_data_20       BIT20
 set     FMC_DATAW2S2L_data_21       BIT21
 set     FMC_DATAW2S2L_data_22       BIT22
 set     FMC_DATAW2S2L_data_23       BIT23
 set     FMC_DATAW2S2L_data_24       BIT24
 set     FMC_DATAW2S2L_data_25       BIT25
 set     FMC_DATAW2S2L_data_26       BIT26
 set     FMC_DATAW2S2L_data_27       BIT27
 set     FMC_DATAW2S2L_data_28       BIT28
 set     FMC_DATAW2S2L_data_29       BIT29
 set     FMC_DATAW2S2L_data_30       BIT30
 set     FMC_DATAW2S2L_data_31       BIT31

 set     FMC_DATAW2S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S3U_data_0        BIT0
 set     FMC_DATAW2S3U_data_1        BIT1
 set     FMC_DATAW2S3U_data_2        BIT2
 set     FMC_DATAW2S3U_data_3        BIT3
 set     FMC_DATAW2S3U_data_4        BIT4
 set     FMC_DATAW2S3U_data_5        BIT5
 set     FMC_DATAW2S3U_data_6        BIT6
 set     FMC_DATAW2S3U_data_7        BIT7
 set     FMC_DATAW2S3U_data_8        BIT8
 set     FMC_DATAW2S3U_data_9        BIT9
 set     FMC_DATAW2S3U_data_10       BIT10
 set     FMC_DATAW2S3U_data_11       BIT11
 set     FMC_DATAW2S3U_data_12       BIT12
 set     FMC_DATAW2S3U_data_13       BIT13
 set     FMC_DATAW2S3U_data_14       BIT14
 set     FMC_DATAW2S3U_data_15       BIT15
 set     FMC_DATAW2S3U_data_16       BIT16
 set     FMC_DATAW2S3U_data_17       BIT17
 set     FMC_DATAW2S3U_data_18       BIT18
 set     FMC_DATAW2S3U_data_19       BIT19
 set     FMC_DATAW2S3U_data_20       BIT20
 set     FMC_DATAW2S3U_data_21       BIT21
 set     FMC_DATAW2S3U_data_22       BIT22
 set     FMC_DATAW2S3U_data_23       BIT23
 set     FMC_DATAW2S3U_data_24       BIT24
 set     FMC_DATAW2S3U_data_25       BIT25
 set     FMC_DATAW2S3U_data_26       BIT26
 set     FMC_DATAW2S3U_data_27       BIT27
 set     FMC_DATAW2S3U_data_28       BIT28
 set     FMC_DATAW2S3U_data_29       BIT29
 set     FMC_DATAW2S3U_data_30       BIT30
 set     FMC_DATAW2S3U_data_31       BIT31

 set     FMC_DATAW2S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S3L_data_0        BIT0
 set     FMC_DATAW2S3L_data_1        BIT1
 set     FMC_DATAW2S3L_data_2        BIT2
 set     FMC_DATAW2S3L_data_3        BIT3
 set     FMC_DATAW2S3L_data_4        BIT4
 set     FMC_DATAW2S3L_data_5        BIT5
 set     FMC_DATAW2S3L_data_6        BIT6
 set     FMC_DATAW2S3L_data_7        BIT7
 set     FMC_DATAW2S3L_data_8        BIT8
 set     FMC_DATAW2S3L_data_9        BIT9
 set     FMC_DATAW2S3L_data_10       BIT10
 set     FMC_DATAW2S3L_data_11       BIT11
 set     FMC_DATAW2S3L_data_12       BIT12
 set     FMC_DATAW2S3L_data_13       BIT13
 set     FMC_DATAW2S3L_data_14       BIT14
 set     FMC_DATAW2S3L_data_15       BIT15
 set     FMC_DATAW2S3L_data_16       BIT16
 set     FMC_DATAW2S3L_data_17       BIT17
 set     FMC_DATAW2S3L_data_18       BIT18
 set     FMC_DATAW2S3L_data_19       BIT19
 set     FMC_DATAW2S3L_data_20       BIT20
 set     FMC_DATAW2S3L_data_21       BIT21
 set     FMC_DATAW2S3L_data_22       BIT22
 set     FMC_DATAW2S3L_data_23       BIT23
 set     FMC_DATAW2S3L_data_24       BIT24
 set     FMC_DATAW2S3L_data_25       BIT25
 set     FMC_DATAW2S3L_data_26       BIT26
 set     FMC_DATAW2S3L_data_27       BIT27
 set     FMC_DATAW2S3L_data_28       BIT28
 set     FMC_DATAW2S3L_data_29       BIT29
 set     FMC_DATAW2S3L_data_30       BIT30
 set     FMC_DATAW2S3L_data_31       BIT31

 set     FMC_DATAW2S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S4U_data_0        BIT0
 set     FMC_DATAW2S4U_data_1        BIT1
 set     FMC_DATAW2S4U_data_2        BIT2
 set     FMC_DATAW2S4U_data_3        BIT3
 set     FMC_DATAW2S4U_data_4        BIT4
 set     FMC_DATAW2S4U_data_5        BIT5
 set     FMC_DATAW2S4U_data_6        BIT6
 set     FMC_DATAW2S4U_data_7        BIT7
 set     FMC_DATAW2S4U_data_8        BIT8
 set     FMC_DATAW2S4U_data_9        BIT9
 set     FMC_DATAW2S4U_data_10       BIT10
 set     FMC_DATAW2S4U_data_11       BIT11
 set     FMC_DATAW2S4U_data_12       BIT12
 set     FMC_DATAW2S4U_data_13       BIT13
 set     FMC_DATAW2S4U_data_14       BIT14
 set     FMC_DATAW2S4U_data_15       BIT15
 set     FMC_DATAW2S4U_data_16       BIT16
 set     FMC_DATAW2S4U_data_17       BIT17
 set     FMC_DATAW2S4U_data_18       BIT18
 set     FMC_DATAW2S4U_data_19       BIT19
 set     FMC_DATAW2S4U_data_20       BIT20
 set     FMC_DATAW2S4U_data_21       BIT21
 set     FMC_DATAW2S4U_data_22       BIT22
 set     FMC_DATAW2S4U_data_23       BIT23
 set     FMC_DATAW2S4U_data_24       BIT24
 set     FMC_DATAW2S4U_data_25       BIT25
 set     FMC_DATAW2S4U_data_26       BIT26
 set     FMC_DATAW2S4U_data_27       BIT27
 set     FMC_DATAW2S4U_data_28       BIT28
 set     FMC_DATAW2S4U_data_29       BIT29
 set     FMC_DATAW2S4U_data_30       BIT30
 set     FMC_DATAW2S4U_data_31       BIT31

 set     FMC_DATAW2S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S4L_data_0        BIT0
 set     FMC_DATAW2S4L_data_1        BIT1
 set     FMC_DATAW2S4L_data_2        BIT2
 set     FMC_DATAW2S4L_data_3        BIT3
 set     FMC_DATAW2S4L_data_4        BIT4
 set     FMC_DATAW2S4L_data_5        BIT5
 set     FMC_DATAW2S4L_data_6        BIT6
 set     FMC_DATAW2S4L_data_7        BIT7
 set     FMC_DATAW2S4L_data_8        BIT8
 set     FMC_DATAW2S4L_data_9        BIT9
 set     FMC_DATAW2S4L_data_10       BIT10
 set     FMC_DATAW2S4L_data_11       BIT11
 set     FMC_DATAW2S4L_data_12       BIT12
 set     FMC_DATAW2S4L_data_13       BIT13
 set     FMC_DATAW2S4L_data_14       BIT14
 set     FMC_DATAW2S4L_data_15       BIT15
 set     FMC_DATAW2S4L_data_16       BIT16
 set     FMC_DATAW2S4L_data_17       BIT17
 set     FMC_DATAW2S4L_data_18       BIT18
 set     FMC_DATAW2S4L_data_19       BIT19
 set     FMC_DATAW2S4L_data_20       BIT20
 set     FMC_DATAW2S4L_data_21       BIT21
 set     FMC_DATAW2S4L_data_22       BIT22
 set     FMC_DATAW2S4L_data_23       BIT23
 set     FMC_DATAW2S4L_data_24       BIT24
 set     FMC_DATAW2S4L_data_25       BIT25
 set     FMC_DATAW2S4L_data_26       BIT26
 set     FMC_DATAW2S4L_data_27       BIT27
 set     FMC_DATAW2S4L_data_28       BIT28
 set     FMC_DATAW2S4L_data_29       BIT29
 set     FMC_DATAW2S4L_data_30       BIT30
 set     FMC_DATAW2S4L_data_31       BIT31

 set     FMC_DATAW2S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S5U_data_0        BIT0
 set     FMC_DATAW2S5U_data_1        BIT1
 set     FMC_DATAW2S5U_data_2        BIT2
 set     FMC_DATAW2S5U_data_3        BIT3
 set     FMC_DATAW2S5U_data_4        BIT4
 set     FMC_DATAW2S5U_data_5        BIT5
 set     FMC_DATAW2S5U_data_6        BIT6
 set     FMC_DATAW2S5U_data_7        BIT7
 set     FMC_DATAW2S5U_data_8        BIT8
 set     FMC_DATAW2S5U_data_9        BIT9
 set     FMC_DATAW2S5U_data_10       BIT10
 set     FMC_DATAW2S5U_data_11       BIT11
 set     FMC_DATAW2S5U_data_12       BIT12
 set     FMC_DATAW2S5U_data_13       BIT13
 set     FMC_DATAW2S5U_data_14       BIT14
 set     FMC_DATAW2S5U_data_15       BIT15
 set     FMC_DATAW2S5U_data_16       BIT16
 set     FMC_DATAW2S5U_data_17       BIT17
 set     FMC_DATAW2S5U_data_18       BIT18
 set     FMC_DATAW2S5U_data_19       BIT19
 set     FMC_DATAW2S5U_data_20       BIT20
 set     FMC_DATAW2S5U_data_21       BIT21
 set     FMC_DATAW2S5U_data_22       BIT22
 set     FMC_DATAW2S5U_data_23       BIT23
 set     FMC_DATAW2S5U_data_24       BIT24
 set     FMC_DATAW2S5U_data_25       BIT25
 set     FMC_DATAW2S5U_data_26       BIT26
 set     FMC_DATAW2S5U_data_27       BIT27
 set     FMC_DATAW2S5U_data_28       BIT28
 set     FMC_DATAW2S5U_data_29       BIT29
 set     FMC_DATAW2S5U_data_30       BIT30
 set     FMC_DATAW2S5U_data_31       BIT31

 set     FMC_DATAW2S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S5L_data_0        BIT0
 set     FMC_DATAW2S5L_data_1        BIT1
 set     FMC_DATAW2S5L_data_2        BIT2
 set     FMC_DATAW2S5L_data_3        BIT3
 set     FMC_DATAW2S5L_data_4        BIT4
 set     FMC_DATAW2S5L_data_5        BIT5
 set     FMC_DATAW2S5L_data_6        BIT6
 set     FMC_DATAW2S5L_data_7        BIT7
 set     FMC_DATAW2S5L_data_8        BIT8
 set     FMC_DATAW2S5L_data_9        BIT9
 set     FMC_DATAW2S5L_data_10       BIT10
 set     FMC_DATAW2S5L_data_11       BIT11
 set     FMC_DATAW2S5L_data_12       BIT12
 set     FMC_DATAW2S5L_data_13       BIT13
 set     FMC_DATAW2S5L_data_14       BIT14
 set     FMC_DATAW2S5L_data_15       BIT15
 set     FMC_DATAW2S5L_data_16       BIT16
 set     FMC_DATAW2S5L_data_17       BIT17
 set     FMC_DATAW2S5L_data_18       BIT18
 set     FMC_DATAW2S5L_data_19       BIT19
 set     FMC_DATAW2S5L_data_20       BIT20
 set     FMC_DATAW2S5L_data_21       BIT21
 set     FMC_DATAW2S5L_data_22       BIT22
 set     FMC_DATAW2S5L_data_23       BIT23
 set     FMC_DATAW2S5L_data_24       BIT24
 set     FMC_DATAW2S5L_data_25       BIT25
 set     FMC_DATAW2S5L_data_26       BIT26
 set     FMC_DATAW2S5L_data_27       BIT27
 set     FMC_DATAW2S5L_data_28       BIT28
 set     FMC_DATAW2S5L_data_29       BIT29
 set     FMC_DATAW2S5L_data_30       BIT30
 set     FMC_DATAW2S5L_data_31       BIT31

 set     FMC_DATAW2S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S6U_data_0        BIT0
 set     FMC_DATAW2S6U_data_1        BIT1
 set     FMC_DATAW2S6U_data_2        BIT2
 set     FMC_DATAW2S6U_data_3        BIT3
 set     FMC_DATAW2S6U_data_4        BIT4
 set     FMC_DATAW2S6U_data_5        BIT5
 set     FMC_DATAW2S6U_data_6        BIT6
 set     FMC_DATAW2S6U_data_7        BIT7
 set     FMC_DATAW2S6U_data_8        BIT8
 set     FMC_DATAW2S6U_data_9        BIT9
 set     FMC_DATAW2S6U_data_10       BIT10
 set     FMC_DATAW2S6U_data_11       BIT11
 set     FMC_DATAW2S6U_data_12       BIT12
 set     FMC_DATAW2S6U_data_13       BIT13
 set     FMC_DATAW2S6U_data_14       BIT14
 set     FMC_DATAW2S6U_data_15       BIT15
 set     FMC_DATAW2S6U_data_16       BIT16
 set     FMC_DATAW2S6U_data_17       BIT17
 set     FMC_DATAW2S6U_data_18       BIT18
 set     FMC_DATAW2S6U_data_19       BIT19
 set     FMC_DATAW2S6U_data_20       BIT20
 set     FMC_DATAW2S6U_data_21       BIT21
 set     FMC_DATAW2S6U_data_22       BIT22
 set     FMC_DATAW2S6U_data_23       BIT23
 set     FMC_DATAW2S6U_data_24       BIT24
 set     FMC_DATAW2S6U_data_25       BIT25
 set     FMC_DATAW2S6U_data_26       BIT26
 set     FMC_DATAW2S6U_data_27       BIT27
 set     FMC_DATAW2S6U_data_28       BIT28
 set     FMC_DATAW2S6U_data_29       BIT29
 set     FMC_DATAW2S6U_data_30       BIT30
 set     FMC_DATAW2S6U_data_31       BIT31

 set     FMC_DATAW2S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S6L_data_0        BIT0
 set     FMC_DATAW2S6L_data_1        BIT1
 set     FMC_DATAW2S6L_data_2        BIT2
 set     FMC_DATAW2S6L_data_3        BIT3
 set     FMC_DATAW2S6L_data_4        BIT4
 set     FMC_DATAW2S6L_data_5        BIT5
 set     FMC_DATAW2S6L_data_6        BIT6
 set     FMC_DATAW2S6L_data_7        BIT7
 set     FMC_DATAW2S6L_data_8        BIT8
 set     FMC_DATAW2S6L_data_9        BIT9
 set     FMC_DATAW2S6L_data_10       BIT10
 set     FMC_DATAW2S6L_data_11       BIT11
 set     FMC_DATAW2S6L_data_12       BIT12
 set     FMC_DATAW2S6L_data_13       BIT13
 set     FMC_DATAW2S6L_data_14       BIT14
 set     FMC_DATAW2S6L_data_15       BIT15
 set     FMC_DATAW2S6L_data_16       BIT16
 set     FMC_DATAW2S6L_data_17       BIT17
 set     FMC_DATAW2S6L_data_18       BIT18
 set     FMC_DATAW2S6L_data_19       BIT19
 set     FMC_DATAW2S6L_data_20       BIT20
 set     FMC_DATAW2S6L_data_21       BIT21
 set     FMC_DATAW2S6L_data_22       BIT22
 set     FMC_DATAW2S6L_data_23       BIT23
 set     FMC_DATAW2S6L_data_24       BIT24
 set     FMC_DATAW2S6L_data_25       BIT25
 set     FMC_DATAW2S6L_data_26       BIT26
 set     FMC_DATAW2S6L_data_27       BIT27
 set     FMC_DATAW2S6L_data_28       BIT28
 set     FMC_DATAW2S6L_data_29       BIT29
 set     FMC_DATAW2S6L_data_30       BIT30
 set     FMC_DATAW2S6L_data_31       BIT31

 set     FMC_DATAW2S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW2S7U_data_0        BIT0
 set     FMC_DATAW2S7U_data_1        BIT1
 set     FMC_DATAW2S7U_data_2        BIT2
 set     FMC_DATAW2S7U_data_3        BIT3
 set     FMC_DATAW2S7U_data_4        BIT4
 set     FMC_DATAW2S7U_data_5        BIT5
 set     FMC_DATAW2S7U_data_6        BIT6
 set     FMC_DATAW2S7U_data_7        BIT7
 set     FMC_DATAW2S7U_data_8        BIT8
 set     FMC_DATAW2S7U_data_9        BIT9
 set     FMC_DATAW2S7U_data_10       BIT10
 set     FMC_DATAW2S7U_data_11       BIT11
 set     FMC_DATAW2S7U_data_12       BIT12
 set     FMC_DATAW2S7U_data_13       BIT13
 set     FMC_DATAW2S7U_data_14       BIT14
 set     FMC_DATAW2S7U_data_15       BIT15
 set     FMC_DATAW2S7U_data_16       BIT16
 set     FMC_DATAW2S7U_data_17       BIT17
 set     FMC_DATAW2S7U_data_18       BIT18
 set     FMC_DATAW2S7U_data_19       BIT19
 set     FMC_DATAW2S7U_data_20       BIT20
 set     FMC_DATAW2S7U_data_21       BIT21
 set     FMC_DATAW2S7U_data_22       BIT22
 set     FMC_DATAW2S7U_data_23       BIT23
 set     FMC_DATAW2S7U_data_24       BIT24
 set     FMC_DATAW2S7U_data_25       BIT25
 set     FMC_DATAW2S7U_data_26       BIT26
 set     FMC_DATAW2S7U_data_27       BIT27
 set     FMC_DATAW2S7U_data_28       BIT28
 set     FMC_DATAW2S7U_data_29       BIT29
 set     FMC_DATAW2S7U_data_30       BIT30
 set     FMC_DATAW2S7U_data_31       BIT31

 set     FMC_DATAW2S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW2S7L_data_0        BIT0
 set     FMC_DATAW2S7L_data_1        BIT1
 set     FMC_DATAW2S7L_data_2        BIT2
 set     FMC_DATAW2S7L_data_3        BIT3
 set     FMC_DATAW2S7L_data_4        BIT4
 set     FMC_DATAW2S7L_data_5        BIT5
 set     FMC_DATAW2S7L_data_6        BIT6
 set     FMC_DATAW2S7L_data_7        BIT7
 set     FMC_DATAW2S7L_data_8        BIT8
 set     FMC_DATAW2S7L_data_9        BIT9
 set     FMC_DATAW2S7L_data_10       BIT10
 set     FMC_DATAW2S7L_data_11       BIT11
 set     FMC_DATAW2S7L_data_12       BIT12
 set     FMC_DATAW2S7L_data_13       BIT13
 set     FMC_DATAW2S7L_data_14       BIT14
 set     FMC_DATAW2S7L_data_15       BIT15
 set     FMC_DATAW2S7L_data_16       BIT16
 set     FMC_DATAW2S7L_data_17       BIT17
 set     FMC_DATAW2S7L_data_18       BIT18
 set     FMC_DATAW2S7L_data_19       BIT19
 set     FMC_DATAW2S7L_data_20       BIT20
 set     FMC_DATAW2S7L_data_21       BIT21
 set     FMC_DATAW2S7L_data_22       BIT22
 set     FMC_DATAW2S7L_data_23       BIT23
 set     FMC_DATAW2S7L_data_24       BIT24
 set     FMC_DATAW2S7L_data_25       BIT25
 set     FMC_DATAW2S7L_data_26       BIT26
 set     FMC_DATAW2S7L_data_27       BIT27
 set     FMC_DATAW2S7L_data_28       BIT28
 set     FMC_DATAW2S7L_data_29       BIT29
 set     FMC_DATAW2S7L_data_30       BIT30
 set     FMC_DATAW2S7L_data_31       BIT31

 set     FMC_DATAW3S0U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S0U_data_0        BIT0
 set     FMC_DATAW3S0U_data_1        BIT1
 set     FMC_DATAW3S0U_data_2        BIT2
 set     FMC_DATAW3S0U_data_3        BIT3
 set     FMC_DATAW3S0U_data_4        BIT4
 set     FMC_DATAW3S0U_data_5        BIT5
 set     FMC_DATAW3S0U_data_6        BIT6
 set     FMC_DATAW3S0U_data_7        BIT7
 set     FMC_DATAW3S0U_data_8        BIT8
 set     FMC_DATAW3S0U_data_9        BIT9
 set     FMC_DATAW3S0U_data_10       BIT10
 set     FMC_DATAW3S0U_data_11       BIT11
 set     FMC_DATAW3S0U_data_12       BIT12
 set     FMC_DATAW3S0U_data_13       BIT13
 set     FMC_DATAW3S0U_data_14       BIT14
 set     FMC_DATAW3S0U_data_15       BIT15
 set     FMC_DATAW3S0U_data_16       BIT16
 set     FMC_DATAW3S0U_data_17       BIT17
 set     FMC_DATAW3S0U_data_18       BIT18
 set     FMC_DATAW3S0U_data_19       BIT19
 set     FMC_DATAW3S0U_data_20       BIT20
 set     FMC_DATAW3S0U_data_21       BIT21
 set     FMC_DATAW3S0U_data_22       BIT22
 set     FMC_DATAW3S0U_data_23       BIT23
 set     FMC_DATAW3S0U_data_24       BIT24
 set     FMC_DATAW3S0U_data_25       BIT25
 set     FMC_DATAW3S0U_data_26       BIT26
 set     FMC_DATAW3S0U_data_27       BIT27
 set     FMC_DATAW3S0U_data_28       BIT28
 set     FMC_DATAW3S0U_data_29       BIT29
 set     FMC_DATAW3S0U_data_30       BIT30
 set     FMC_DATAW3S0U_data_31       BIT31

 set     FMC_DATAW3S0L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S0L_data_0        BIT0
 set     FMC_DATAW3S0L_data_1        BIT1
 set     FMC_DATAW3S0L_data_2        BIT2
 set     FMC_DATAW3S0L_data_3        BIT3
 set     FMC_DATAW3S0L_data_4        BIT4
 set     FMC_DATAW3S0L_data_5        BIT5
 set     FMC_DATAW3S0L_data_6        BIT6
 set     FMC_DATAW3S0L_data_7        BIT7
 set     FMC_DATAW3S0L_data_8        BIT8
 set     FMC_DATAW3S0L_data_9        BIT9
 set     FMC_DATAW3S0L_data_10       BIT10
 set     FMC_DATAW3S0L_data_11       BIT11
 set     FMC_DATAW3S0L_data_12       BIT12
 set     FMC_DATAW3S0L_data_13       BIT13
 set     FMC_DATAW3S0L_data_14       BIT14
 set     FMC_DATAW3S0L_data_15       BIT15
 set     FMC_DATAW3S0L_data_16       BIT16
 set     FMC_DATAW3S0L_data_17       BIT17
 set     FMC_DATAW3S0L_data_18       BIT18
 set     FMC_DATAW3S0L_data_19       BIT19
 set     FMC_DATAW3S0L_data_20       BIT20
 set     FMC_DATAW3S0L_data_21       BIT21
 set     FMC_DATAW3S0L_data_22       BIT22
 set     FMC_DATAW3S0L_data_23       BIT23
 set     FMC_DATAW3S0L_data_24       BIT24
 set     FMC_DATAW3S0L_data_25       BIT25
 set     FMC_DATAW3S0L_data_26       BIT26
 set     FMC_DATAW3S0L_data_27       BIT27
 set     FMC_DATAW3S0L_data_28       BIT28
 set     FMC_DATAW3S0L_data_29       BIT29
 set     FMC_DATAW3S0L_data_30       BIT30
 set     FMC_DATAW3S0L_data_31       BIT31

 set     FMC_DATAW3S1U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S1U_data_0        BIT0
 set     FMC_DATAW3S1U_data_1        BIT1
 set     FMC_DATAW3S1U_data_2        BIT2
 set     FMC_DATAW3S1U_data_3        BIT3
 set     FMC_DATAW3S1U_data_4        BIT4
 set     FMC_DATAW3S1U_data_5        BIT5
 set     FMC_DATAW3S1U_data_6        BIT6
 set     FMC_DATAW3S1U_data_7        BIT7
 set     FMC_DATAW3S1U_data_8        BIT8
 set     FMC_DATAW3S1U_data_9        BIT9
 set     FMC_DATAW3S1U_data_10       BIT10
 set     FMC_DATAW3S1U_data_11       BIT11
 set     FMC_DATAW3S1U_data_12       BIT12
 set     FMC_DATAW3S1U_data_13       BIT13
 set     FMC_DATAW3S1U_data_14       BIT14
 set     FMC_DATAW3S1U_data_15       BIT15
 set     FMC_DATAW3S1U_data_16       BIT16
 set     FMC_DATAW3S1U_data_17       BIT17
 set     FMC_DATAW3S1U_data_18       BIT18
 set     FMC_DATAW3S1U_data_19       BIT19
 set     FMC_DATAW3S1U_data_20       BIT20
 set     FMC_DATAW3S1U_data_21       BIT21
 set     FMC_DATAW3S1U_data_22       BIT22
 set     FMC_DATAW3S1U_data_23       BIT23
 set     FMC_DATAW3S1U_data_24       BIT24
 set     FMC_DATAW3S1U_data_25       BIT25
 set     FMC_DATAW3S1U_data_26       BIT26
 set     FMC_DATAW3S1U_data_27       BIT27
 set     FMC_DATAW3S1U_data_28       BIT28
 set     FMC_DATAW3S1U_data_29       BIT29
 set     FMC_DATAW3S1U_data_30       BIT30
 set     FMC_DATAW3S1U_data_31       BIT31

 set     FMC_DATAW3S1L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S1L_data_0        BIT0
 set     FMC_DATAW3S1L_data_1        BIT1
 set     FMC_DATAW3S1L_data_2        BIT2
 set     FMC_DATAW3S1L_data_3        BIT3
 set     FMC_DATAW3S1L_data_4        BIT4
 set     FMC_DATAW3S1L_data_5        BIT5
 set     FMC_DATAW3S1L_data_6        BIT6
 set     FMC_DATAW3S1L_data_7        BIT7
 set     FMC_DATAW3S1L_data_8        BIT8
 set     FMC_DATAW3S1L_data_9        BIT9
 set     FMC_DATAW3S1L_data_10       BIT10
 set     FMC_DATAW3S1L_data_11       BIT11
 set     FMC_DATAW3S1L_data_12       BIT12
 set     FMC_DATAW3S1L_data_13       BIT13
 set     FMC_DATAW3S1L_data_14       BIT14
 set     FMC_DATAW3S1L_data_15       BIT15
 set     FMC_DATAW3S1L_data_16       BIT16
 set     FMC_DATAW3S1L_data_17       BIT17
 set     FMC_DATAW3S1L_data_18       BIT18
 set     FMC_DATAW3S1L_data_19       BIT19
 set     FMC_DATAW3S1L_data_20       BIT20
 set     FMC_DATAW3S1L_data_21       BIT21
 set     FMC_DATAW3S1L_data_22       BIT22
 set     FMC_DATAW3S1L_data_23       BIT23
 set     FMC_DATAW3S1L_data_24       BIT24
 set     FMC_DATAW3S1L_data_25       BIT25
 set     FMC_DATAW3S1L_data_26       BIT26
 set     FMC_DATAW3S1L_data_27       BIT27
 set     FMC_DATAW3S1L_data_28       BIT28
 set     FMC_DATAW3S1L_data_29       BIT29
 set     FMC_DATAW3S1L_data_30       BIT30
 set     FMC_DATAW3S1L_data_31       BIT31

 set     FMC_DATAW3S2U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S2U_data_0        BIT0
 set     FMC_DATAW3S2U_data_1        BIT1
 set     FMC_DATAW3S2U_data_2        BIT2
 set     FMC_DATAW3S2U_data_3        BIT3
 set     FMC_DATAW3S2U_data_4        BIT4
 set     FMC_DATAW3S2U_data_5        BIT5
 set     FMC_DATAW3S2U_data_6        BIT6
 set     FMC_DATAW3S2U_data_7        BIT7
 set     FMC_DATAW3S2U_data_8        BIT8
 set     FMC_DATAW3S2U_data_9        BIT9
 set     FMC_DATAW3S2U_data_10       BIT10
 set     FMC_DATAW3S2U_data_11       BIT11
 set     FMC_DATAW3S2U_data_12       BIT12
 set     FMC_DATAW3S2U_data_13       BIT13
 set     FMC_DATAW3S2U_data_14       BIT14
 set     FMC_DATAW3S2U_data_15       BIT15
 set     FMC_DATAW3S2U_data_16       BIT16
 set     FMC_DATAW3S2U_data_17       BIT17
 set     FMC_DATAW3S2U_data_18       BIT18
 set     FMC_DATAW3S2U_data_19       BIT19
 set     FMC_DATAW3S2U_data_20       BIT20
 set     FMC_DATAW3S2U_data_21       BIT21
 set     FMC_DATAW3S2U_data_22       BIT22
 set     FMC_DATAW3S2U_data_23       BIT23
 set     FMC_DATAW3S2U_data_24       BIT24
 set     FMC_DATAW3S2U_data_25       BIT25
 set     FMC_DATAW3S2U_data_26       BIT26
 set     FMC_DATAW3S2U_data_27       BIT27
 set     FMC_DATAW3S2U_data_28       BIT28
 set     FMC_DATAW3S2U_data_29       BIT29
 set     FMC_DATAW3S2U_data_30       BIT30
 set     FMC_DATAW3S2U_data_31       BIT31

 set     FMC_DATAW3S2L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S2L_data_0        BIT0
 set     FMC_DATAW3S2L_data_1        BIT1
 set     FMC_DATAW3S2L_data_2        BIT2
 set     FMC_DATAW3S2L_data_3        BIT3
 set     FMC_DATAW3S2L_data_4        BIT4
 set     FMC_DATAW3S2L_data_5        BIT5
 set     FMC_DATAW3S2L_data_6        BIT6
 set     FMC_DATAW3S2L_data_7        BIT7
 set     FMC_DATAW3S2L_data_8        BIT8
 set     FMC_DATAW3S2L_data_9        BIT9
 set     FMC_DATAW3S2L_data_10       BIT10
 set     FMC_DATAW3S2L_data_11       BIT11
 set     FMC_DATAW3S2L_data_12       BIT12
 set     FMC_DATAW3S2L_data_13       BIT13
 set     FMC_DATAW3S2L_data_14       BIT14
 set     FMC_DATAW3S2L_data_15       BIT15
 set     FMC_DATAW3S2L_data_16       BIT16
 set     FMC_DATAW3S2L_data_17       BIT17
 set     FMC_DATAW3S2L_data_18       BIT18
 set     FMC_DATAW3S2L_data_19       BIT19
 set     FMC_DATAW3S2L_data_20       BIT20
 set     FMC_DATAW3S2L_data_21       BIT21
 set     FMC_DATAW3S2L_data_22       BIT22
 set     FMC_DATAW3S2L_data_23       BIT23
 set     FMC_DATAW3S2L_data_24       BIT24
 set     FMC_DATAW3S2L_data_25       BIT25
 set     FMC_DATAW3S2L_data_26       BIT26
 set     FMC_DATAW3S2L_data_27       BIT27
 set     FMC_DATAW3S2L_data_28       BIT28
 set     FMC_DATAW3S2L_data_29       BIT29
 set     FMC_DATAW3S2L_data_30       BIT30
 set     FMC_DATAW3S2L_data_31       BIT31

 set     FMC_DATAW3S3U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S3U_data_0        BIT0
 set     FMC_DATAW3S3U_data_1        BIT1
 set     FMC_DATAW3S3U_data_2        BIT2
 set     FMC_DATAW3S3U_data_3        BIT3
 set     FMC_DATAW3S3U_data_4        BIT4
 set     FMC_DATAW3S3U_data_5        BIT5
 set     FMC_DATAW3S3U_data_6        BIT6
 set     FMC_DATAW3S3U_data_7        BIT7
 set     FMC_DATAW3S3U_data_8        BIT8
 set     FMC_DATAW3S3U_data_9        BIT9
 set     FMC_DATAW3S3U_data_10       BIT10
 set     FMC_DATAW3S3U_data_11       BIT11
 set     FMC_DATAW3S3U_data_12       BIT12
 set     FMC_DATAW3S3U_data_13       BIT13
 set     FMC_DATAW3S3U_data_14       BIT14
 set     FMC_DATAW3S3U_data_15       BIT15
 set     FMC_DATAW3S3U_data_16       BIT16
 set     FMC_DATAW3S3U_data_17       BIT17
 set     FMC_DATAW3S3U_data_18       BIT18
 set     FMC_DATAW3S3U_data_19       BIT19
 set     FMC_DATAW3S3U_data_20       BIT20
 set     FMC_DATAW3S3U_data_21       BIT21
 set     FMC_DATAW3S3U_data_22       BIT22
 set     FMC_DATAW3S3U_data_23       BIT23
 set     FMC_DATAW3S3U_data_24       BIT24
 set     FMC_DATAW3S3U_data_25       BIT25
 set     FMC_DATAW3S3U_data_26       BIT26
 set     FMC_DATAW3S3U_data_27       BIT27
 set     FMC_DATAW3S3U_data_28       BIT28
 set     FMC_DATAW3S3U_data_29       BIT29
 set     FMC_DATAW3S3U_data_30       BIT30
 set     FMC_DATAW3S3U_data_31       BIT31

 set     FMC_DATAW3S3L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S3L_data_0        BIT0
 set     FMC_DATAW3S3L_data_1        BIT1
 set     FMC_DATAW3S3L_data_2        BIT2
 set     FMC_DATAW3S3L_data_3        BIT3
 set     FMC_DATAW3S3L_data_4        BIT4
 set     FMC_DATAW3S3L_data_5        BIT5
 set     FMC_DATAW3S3L_data_6        BIT6
 set     FMC_DATAW3S3L_data_7        BIT7
 set     FMC_DATAW3S3L_data_8        BIT8
 set     FMC_DATAW3S3L_data_9        BIT9
 set     FMC_DATAW3S3L_data_10       BIT10
 set     FMC_DATAW3S3L_data_11       BIT11
 set     FMC_DATAW3S3L_data_12       BIT12
 set     FMC_DATAW3S3L_data_13       BIT13
 set     FMC_DATAW3S3L_data_14       BIT14
 set     FMC_DATAW3S3L_data_15       BIT15
 set     FMC_DATAW3S3L_data_16       BIT16
 set     FMC_DATAW3S3L_data_17       BIT17
 set     FMC_DATAW3S3L_data_18       BIT18
 set     FMC_DATAW3S3L_data_19       BIT19
 set     FMC_DATAW3S3L_data_20       BIT20
 set     FMC_DATAW3S3L_data_21       BIT21
 set     FMC_DATAW3S3L_data_22       BIT22
 set     FMC_DATAW3S3L_data_23       BIT23
 set     FMC_DATAW3S3L_data_24       BIT24
 set     FMC_DATAW3S3L_data_25       BIT25
 set     FMC_DATAW3S3L_data_26       BIT26
 set     FMC_DATAW3S3L_data_27       BIT27
 set     FMC_DATAW3S3L_data_28       BIT28
 set     FMC_DATAW3S3L_data_29       BIT29
 set     FMC_DATAW3S3L_data_30       BIT30
 set     FMC_DATAW3S3L_data_31       BIT31

 set     FMC_DATAW3S4U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S4U_data_0        BIT0
 set     FMC_DATAW3S4U_data_1        BIT1
 set     FMC_DATAW3S4U_data_2        BIT2
 set     FMC_DATAW3S4U_data_3        BIT3
 set     FMC_DATAW3S4U_data_4        BIT4
 set     FMC_DATAW3S4U_data_5        BIT5
 set     FMC_DATAW3S4U_data_6        BIT6
 set     FMC_DATAW3S4U_data_7        BIT7
 set     FMC_DATAW3S4U_data_8        BIT8
 set     FMC_DATAW3S4U_data_9        BIT9
 set     FMC_DATAW3S4U_data_10       BIT10
 set     FMC_DATAW3S4U_data_11       BIT11
 set     FMC_DATAW3S4U_data_12       BIT12
 set     FMC_DATAW3S4U_data_13       BIT13
 set     FMC_DATAW3S4U_data_14       BIT14
 set     FMC_DATAW3S4U_data_15       BIT15
 set     FMC_DATAW3S4U_data_16       BIT16
 set     FMC_DATAW3S4U_data_17       BIT17
 set     FMC_DATAW3S4U_data_18       BIT18
 set     FMC_DATAW3S4U_data_19       BIT19
 set     FMC_DATAW3S4U_data_20       BIT20
 set     FMC_DATAW3S4U_data_21       BIT21
 set     FMC_DATAW3S4U_data_22       BIT22
 set     FMC_DATAW3S4U_data_23       BIT23
 set     FMC_DATAW3S4U_data_24       BIT24
 set     FMC_DATAW3S4U_data_25       BIT25
 set     FMC_DATAW3S4U_data_26       BIT26
 set     FMC_DATAW3S4U_data_27       BIT27
 set     FMC_DATAW3S4U_data_28       BIT28
 set     FMC_DATAW3S4U_data_29       BIT29
 set     FMC_DATAW3S4U_data_30       BIT30
 set     FMC_DATAW3S4U_data_31       BIT31

 set     FMC_DATAW3S4L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S4L_data_0        BIT0
 set     FMC_DATAW3S4L_data_1        BIT1
 set     FMC_DATAW3S4L_data_2        BIT2
 set     FMC_DATAW3S4L_data_3        BIT3
 set     FMC_DATAW3S4L_data_4        BIT4
 set     FMC_DATAW3S4L_data_5        BIT5
 set     FMC_DATAW3S4L_data_6        BIT6
 set     FMC_DATAW3S4L_data_7        BIT7
 set     FMC_DATAW3S4L_data_8        BIT8
 set     FMC_DATAW3S4L_data_9        BIT9
 set     FMC_DATAW3S4L_data_10       BIT10
 set     FMC_DATAW3S4L_data_11       BIT11
 set     FMC_DATAW3S4L_data_12       BIT12
 set     FMC_DATAW3S4L_data_13       BIT13
 set     FMC_DATAW3S4L_data_14       BIT14
 set     FMC_DATAW3S4L_data_15       BIT15
 set     FMC_DATAW3S4L_data_16       BIT16
 set     FMC_DATAW3S4L_data_17       BIT17
 set     FMC_DATAW3S4L_data_18       BIT18
 set     FMC_DATAW3S4L_data_19       BIT19
 set     FMC_DATAW3S4L_data_20       BIT20
 set     FMC_DATAW3S4L_data_21       BIT21
 set     FMC_DATAW3S4L_data_22       BIT22
 set     FMC_DATAW3S4L_data_23       BIT23
 set     FMC_DATAW3S4L_data_24       BIT24
 set     FMC_DATAW3S4L_data_25       BIT25
 set     FMC_DATAW3S4L_data_26       BIT26
 set     FMC_DATAW3S4L_data_27       BIT27
 set     FMC_DATAW3S4L_data_28       BIT28
 set     FMC_DATAW3S4L_data_29       BIT29
 set     FMC_DATAW3S4L_data_30       BIT30
 set     FMC_DATAW3S4L_data_31       BIT31

 set     FMC_DATAW3S5U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S5U_data_0        BIT0
 set     FMC_DATAW3S5U_data_1        BIT1
 set     FMC_DATAW3S5U_data_2        BIT2
 set     FMC_DATAW3S5U_data_3        BIT3
 set     FMC_DATAW3S5U_data_4        BIT4
 set     FMC_DATAW3S5U_data_5        BIT5
 set     FMC_DATAW3S5U_data_6        BIT6
 set     FMC_DATAW3S5U_data_7        BIT7
 set     FMC_DATAW3S5U_data_8        BIT8
 set     FMC_DATAW3S5U_data_9        BIT9
 set     FMC_DATAW3S5U_data_10       BIT10
 set     FMC_DATAW3S5U_data_11       BIT11
 set     FMC_DATAW3S5U_data_12       BIT12
 set     FMC_DATAW3S5U_data_13       BIT13
 set     FMC_DATAW3S5U_data_14       BIT14
 set     FMC_DATAW3S5U_data_15       BIT15
 set     FMC_DATAW3S5U_data_16       BIT16
 set     FMC_DATAW3S5U_data_17       BIT17
 set     FMC_DATAW3S5U_data_18       BIT18
 set     FMC_DATAW3S5U_data_19       BIT19
 set     FMC_DATAW3S5U_data_20       BIT20
 set     FMC_DATAW3S5U_data_21       BIT21
 set     FMC_DATAW3S5U_data_22       BIT22
 set     FMC_DATAW3S5U_data_23       BIT23
 set     FMC_DATAW3S5U_data_24       BIT24
 set     FMC_DATAW3S5U_data_25       BIT25
 set     FMC_DATAW3S5U_data_26       BIT26
 set     FMC_DATAW3S5U_data_27       BIT27
 set     FMC_DATAW3S5U_data_28       BIT28
 set     FMC_DATAW3S5U_data_29       BIT29
 set     FMC_DATAW3S5U_data_30       BIT30
 set     FMC_DATAW3S5U_data_31       BIT31

 set     FMC_DATAW3S5L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S5L_data_0        BIT0
 set     FMC_DATAW3S5L_data_1        BIT1
 set     FMC_DATAW3S5L_data_2        BIT2
 set     FMC_DATAW3S5L_data_3        BIT3
 set     FMC_DATAW3S5L_data_4        BIT4
 set     FMC_DATAW3S5L_data_5        BIT5
 set     FMC_DATAW3S5L_data_6        BIT6
 set     FMC_DATAW3S5L_data_7        BIT7
 set     FMC_DATAW3S5L_data_8        BIT8
 set     FMC_DATAW3S5L_data_9        BIT9
 set     FMC_DATAW3S5L_data_10       BIT10
 set     FMC_DATAW3S5L_data_11       BIT11
 set     FMC_DATAW3S5L_data_12       BIT12
 set     FMC_DATAW3S5L_data_13       BIT13
 set     FMC_DATAW3S5L_data_14       BIT14
 set     FMC_DATAW3S5L_data_15       BIT15
 set     FMC_DATAW3S5L_data_16       BIT16
 set     FMC_DATAW3S5L_data_17       BIT17
 set     FMC_DATAW3S5L_data_18       BIT18
 set     FMC_DATAW3S5L_data_19       BIT19
 set     FMC_DATAW3S5L_data_20       BIT20
 set     FMC_DATAW3S5L_data_21       BIT21
 set     FMC_DATAW3S5L_data_22       BIT22
 set     FMC_DATAW3S5L_data_23       BIT23
 set     FMC_DATAW3S5L_data_24       BIT24
 set     FMC_DATAW3S5L_data_25       BIT25
 set     FMC_DATAW3S5L_data_26       BIT26
 set     FMC_DATAW3S5L_data_27       BIT27
 set     FMC_DATAW3S5L_data_28       BIT28
 set     FMC_DATAW3S5L_data_29       BIT29
 set     FMC_DATAW3S5L_data_30       BIT30
 set     FMC_DATAW3S5L_data_31       BIT31

 set     FMC_DATAW3S6U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S6U_data_0        BIT0
 set     FMC_DATAW3S6U_data_1        BIT1
 set     FMC_DATAW3S6U_data_2        BIT2
 set     FMC_DATAW3S6U_data_3        BIT3
 set     FMC_DATAW3S6U_data_4        BIT4
 set     FMC_DATAW3S6U_data_5        BIT5
 set     FMC_DATAW3S6U_data_6        BIT6
 set     FMC_DATAW3S6U_data_7        BIT7
 set     FMC_DATAW3S6U_data_8        BIT8
 set     FMC_DATAW3S6U_data_9        BIT9
 set     FMC_DATAW3S6U_data_10       BIT10
 set     FMC_DATAW3S6U_data_11       BIT11
 set     FMC_DATAW3S6U_data_12       BIT12
 set     FMC_DATAW3S6U_data_13       BIT13
 set     FMC_DATAW3S6U_data_14       BIT14
 set     FMC_DATAW3S6U_data_15       BIT15
 set     FMC_DATAW3S6U_data_16       BIT16
 set     FMC_DATAW3S6U_data_17       BIT17
 set     FMC_DATAW3S6U_data_18       BIT18
 set     FMC_DATAW3S6U_data_19       BIT19
 set     FMC_DATAW3S6U_data_20       BIT20
 set     FMC_DATAW3S6U_data_21       BIT21
 set     FMC_DATAW3S6U_data_22       BIT22
 set     FMC_DATAW3S6U_data_23       BIT23
 set     FMC_DATAW3S6U_data_24       BIT24
 set     FMC_DATAW3S6U_data_25       BIT25
 set     FMC_DATAW3S6U_data_26       BIT26
 set     FMC_DATAW3S6U_data_27       BIT27
 set     FMC_DATAW3S6U_data_28       BIT28
 set     FMC_DATAW3S6U_data_29       BIT29
 set     FMC_DATAW3S6U_data_30       BIT30
 set     FMC_DATAW3S6U_data_31       BIT31

 set     FMC_DATAW3S6L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S6L_data_0        BIT0
 set     FMC_DATAW3S6L_data_1        BIT1
 set     FMC_DATAW3S6L_data_2        BIT2
 set     FMC_DATAW3S6L_data_3        BIT3
 set     FMC_DATAW3S6L_data_4        BIT4
 set     FMC_DATAW3S6L_data_5        BIT5
 set     FMC_DATAW3S6L_data_6        BIT6
 set     FMC_DATAW3S6L_data_7        BIT7
 set     FMC_DATAW3S6L_data_8        BIT8
 set     FMC_DATAW3S6L_data_9        BIT9
 set     FMC_DATAW3S6L_data_10       BIT10
 set     FMC_DATAW3S6L_data_11       BIT11
 set     FMC_DATAW3S6L_data_12       BIT12
 set     FMC_DATAW3S6L_data_13       BIT13
 set     FMC_DATAW3S6L_data_14       BIT14
 set     FMC_DATAW3S6L_data_15       BIT15
 set     FMC_DATAW3S6L_data_16       BIT16
 set     FMC_DATAW3S6L_data_17       BIT17
 set     FMC_DATAW3S6L_data_18       BIT18
 set     FMC_DATAW3S6L_data_19       BIT19
 set     FMC_DATAW3S6L_data_20       BIT20
 set     FMC_DATAW3S6L_data_21       BIT21
 set     FMC_DATAW3S6L_data_22       BIT22
 set     FMC_DATAW3S6L_data_23       BIT23
 set     FMC_DATAW3S6L_data_24       BIT24
 set     FMC_DATAW3S6L_data_25       BIT25
 set     FMC_DATAW3S6L_data_26       BIT26
 set     FMC_DATAW3S6L_data_27       BIT27
 set     FMC_DATAW3S6L_data_28       BIT28
 set     FMC_DATAW3S6L_data_29       BIT29
 set     FMC_DATAW3S6L_data_30       BIT30
 set     FMC_DATAW3S6L_data_31       BIT31

 set     FMC_DATAW3S7U_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [63:32] of data entry
 set     FMC_DATAW3S7U_data_0        BIT0
 set     FMC_DATAW3S7U_data_1        BIT1
 set     FMC_DATAW3S7U_data_2        BIT2
 set     FMC_DATAW3S7U_data_3        BIT3
 set     FMC_DATAW3S7U_data_4        BIT4
 set     FMC_DATAW3S7U_data_5        BIT5
 set     FMC_DATAW3S7U_data_6        BIT6
 set     FMC_DATAW3S7U_data_7        BIT7
 set     FMC_DATAW3S7U_data_8        BIT8
 set     FMC_DATAW3S7U_data_9        BIT9
 set     FMC_DATAW3S7U_data_10       BIT10
 set     FMC_DATAW3S7U_data_11       BIT11
 set     FMC_DATAW3S7U_data_12       BIT12
 set     FMC_DATAW3S7U_data_13       BIT13
 set     FMC_DATAW3S7U_data_14       BIT14
 set     FMC_DATAW3S7U_data_15       BIT15
 set     FMC_DATAW3S7U_data_16       BIT16
 set     FMC_DATAW3S7U_data_17       BIT17
 set     FMC_DATAW3S7U_data_18       BIT18
 set     FMC_DATAW3S7U_data_19       BIT19
 set     FMC_DATAW3S7U_data_20       BIT20
 set     FMC_DATAW3S7U_data_21       BIT21
 set     FMC_DATAW3S7U_data_22       BIT22
 set     FMC_DATAW3S7U_data_23       BIT23
 set     FMC_DATAW3S7U_data_24       BIT24
 set     FMC_DATAW3S7U_data_25       BIT25
 set     FMC_DATAW3S7U_data_26       BIT26
 set     FMC_DATAW3S7U_data_27       BIT27
 set     FMC_DATAW3S7U_data_28       BIT28
 set     FMC_DATAW3S7U_data_29       BIT29
 set     FMC_DATAW3S7U_data_30       BIT30
 set     FMC_DATAW3S7U_data_31       BIT31

 set     FMC_DATAW3S7L_data          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Bits [31:0] of data entry
 set     FMC_DATAW3S7L_data_0        BIT0
 set     FMC_DATAW3S7L_data_1        BIT1
 set     FMC_DATAW3S7L_data_2        BIT2
 set     FMC_DATAW3S7L_data_3        BIT3
 set     FMC_DATAW3S7L_data_4        BIT4
 set     FMC_DATAW3S7L_data_5        BIT5
 set     FMC_DATAW3S7L_data_6        BIT6
 set     FMC_DATAW3S7L_data_7        BIT7
 set     FMC_DATAW3S7L_data_8        BIT8
 set     FMC_DATAW3S7L_data_9        BIT9
 set     FMC_DATAW3S7L_data_10       BIT10
 set     FMC_DATAW3S7L_data_11       BIT11
 set     FMC_DATAW3S7L_data_12       BIT12
 set     FMC_DATAW3S7L_data_13       BIT13
 set     FMC_DATAW3S7L_data_14       BIT14
 set     FMC_DATAW3S7L_data_15       BIT15
 set     FMC_DATAW3S7L_data_16       BIT16
 set     FMC_DATAW3S7L_data_17       BIT17
 set     FMC_DATAW3S7L_data_18       BIT18
 set     FMC_DATAW3S7L_data_19       BIT19
 set     FMC_DATAW3S7L_data_20       BIT20
 set     FMC_DATAW3S7L_data_21       BIT21
 set     FMC_DATAW3S7L_data_22       BIT22
 set     FMC_DATAW3S7L_data_23       BIT23
 set     FMC_DATAW3S7L_data_24       BIT24
 set     FMC_DATAW3S7L_data_25       BIT25
 set     FMC_DATAW3S7L_data_26       BIT26
 set     FMC_DATAW3S7L_data_27       BIT27
 set     FMC_DATAW3S7L_data_28       BIT28
 set     FMC_DATAW3S7L_data_29       BIT29
 set     FMC_DATAW3S7L_data_30       BIT30
 set     FMC_DATAW3S7L_data_31       BIT31

 set     FTFL_FSTAT_MGSTAT0          BIT0
;;   Memory Controller Command Completion Status Flag

 set     FTFL_FSTAT_FPVIOL           BIT4
;;   Flash Protection Violation Flag
;;     0b0 ==> No protection violation detected
;;     0b1 ==> Protection violation detected

 set     FTFL_FSTAT_ACCERR           BIT5
;;   Flash Access Error Flag
;;     0b0 ==> No access error detected
;;     0b1 ==> Access error detected

 set     FTFL_FSTAT_RDCOLERR         BIT6
;;   FTFL Read Collision Error Flag
;;     0b0 ==> No collision error detected
;;     0b1 ==> Collision error detected

 set     FTFL_FSTAT_CCIF             BIT7
;;   Command Complete Interrupt Flag
;;     0b0 ==> FTFL command or EEPROM file system operation in progress
;;     0b1 ==> FTFL command or EEPROM file system operation has completed

 set     FTFL_FCNFG_EEERDY           BIT0
;;     0b0 ==> FlexRAM is not available for EEPROM operation.
;;     0b1 ==> FlexRAM is available for EEPROM operations where: reads from the FlexRAM return data previously written to the FlexRAM in EEPROM mode and writes to the FlexRAM clear EEERDY and launch an EEPROM operation to store the written data in the FlexRAM and EEPROM backup.

 set     FTFL_FCNFG_RAMRDY           BIT1
;;   RAM Ready
;;     0b0 ==> FlexRAM is not available for traditional RAM access.
;;     0b1 ==> FlexRAM is available as traditional RAM only; writes to the FlexRAM do not trigger EEPROM operations.

 set     FTFL_FCNFG_PFLSH            BIT2
;;   FTFL configuration
;;     0b0 ==> FTFL configured for FlexMemory that supports data flash and/or EEPROM
;;     0b1 ==> Reserved

 set     FTFL_FCNFG_ERSSUSP          BIT4
;;   Erase Suspend
;;     0b0 ==> No suspend requested
;;     0b1 ==> Suspend the current Erase Flash Sector command execution.

 set     FTFL_FCNFG_ERSAREQ          BIT5
;;   Erase All Request
;;     0b0 ==> No request or request complete
;;     0b1 ==> Request to: run the Erase All Blocks command, verify the erased state, program the security byte in the Flash Configuration Field to the unsecure state, and release MCU security by setting the FSEC[SEC] field to the unsecure state.

 set     FTFL_FCNFG_RDCOLLIE         BIT6
;;   Read Collision Error Interrupt Enable
;;     0b0 ==> Read collision error interrupt disabled
;;     0b1 ==> Read collision error interrupt enabled. An interrupt request is generated whenever an FTFL read collision error is detected (see the description of FSTAT[RDCOLERR]).

 set     FTFL_FCNFG_CCIE             BIT7
;;   Command Complete Interrupt Enable
;;     0b0 ==> Command complete interrupt disabled
;;     0b1 ==> Command complete interrupt enabled. An interrupt request is generated whenever the FSTAT[CCIF] flag is set.

 set     FTFL_FSEC_SEC               (BIT0|BIT1)
;;   Flash Security
;;     0b00 ==> MCU security status is secure
;;     0b01 ==> MCU security status is secure
;;     0b10 ==> MCU security status is unsecure (The standard shipping condition of the FTFL is unsecure.)
;;     0b11 ==> MCU security status is secure
 set     FTFL_FSEC_SEC_0             BIT0
 set     FTFL_FSEC_SEC_1             BIT1

 set     FTFL_FSEC_FSLACC            (BIT2|BIT3)
;;   Freescale Failure Analysis Access Code
;;     0b00 ==> Freescale factory access granted
;;     0b01 ==> Freescale factory access denied
;;     0b10 ==> Freescale factory access denied
;;     0b11 ==> Freescale factory access granted
 set     FTFL_FSEC_FSLACC_0          BIT2
 set     FTFL_FSEC_FSLACC_1          BIT3

 set     FTFL_FSEC_MEEN              (BIT4|BIT5)
;;   Mass Erase Enable Bits
;;     0b00 ==> Mass erase is enabled
;;     0b01 ==> Mass erase is enabled
;;     0b10 ==> Mass erase is disabled
;;     0b11 ==> Mass erase is enabled
 set     FTFL_FSEC_MEEN_0            BIT4
 set     FTFL_FSEC_MEEN_1            BIT5

 set     FTFL_FSEC_KEYEN             (BIT6|BIT7)
;;   Backdoor Key Security Enable
;;     0b00 ==> Backdoor key access disabled
;;     0b01 ==> Backdoor key access disabled (preferred KEYEN state to disable backdoor key access)
;;     0b10 ==> Backdoor key access enabled
;;     0b11 ==> Backdoor key access disabled
 set     FTFL_FSEC_KEYEN_0           BIT6
 set     FTFL_FSEC_KEYEN_1           BIT7

 set     FTFL_FOPT_OPT               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Nonvolatile Option
 set     FTFL_FOPT_OPT_0             BIT0
 set     FTFL_FOPT_OPT_1             BIT1
 set     FTFL_FOPT_OPT_2             BIT2
 set     FTFL_FOPT_OPT_3             BIT3
 set     FTFL_FOPT_OPT_4             BIT4
 set     FTFL_FOPT_OPT_5             BIT5
 set     FTFL_FOPT_OPT_6             BIT6
 set     FTFL_FOPT_OPT_7             BIT7

 set     FTFL_FCCOB3_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB3_CCOBn_0         BIT0
 set     FTFL_FCCOB3_CCOBn_1         BIT1
 set     FTFL_FCCOB3_CCOBn_2         BIT2
 set     FTFL_FCCOB3_CCOBn_3         BIT3
 set     FTFL_FCCOB3_CCOBn_4         BIT4
 set     FTFL_FCCOB3_CCOBn_5         BIT5
 set     FTFL_FCCOB3_CCOBn_6         BIT6
 set     FTFL_FCCOB3_CCOBn_7         BIT7

 set     FTFL_FCCOB2_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB2_CCOBn_0         BIT0
 set     FTFL_FCCOB2_CCOBn_1         BIT1
 set     FTFL_FCCOB2_CCOBn_2         BIT2
 set     FTFL_FCCOB2_CCOBn_3         BIT3
 set     FTFL_FCCOB2_CCOBn_4         BIT4
 set     FTFL_FCCOB2_CCOBn_5         BIT5
 set     FTFL_FCCOB2_CCOBn_6         BIT6
 set     FTFL_FCCOB2_CCOBn_7         BIT7

 set     FTFL_FCCOB1_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB1_CCOBn_0         BIT0
 set     FTFL_FCCOB1_CCOBn_1         BIT1
 set     FTFL_FCCOB1_CCOBn_2         BIT2
 set     FTFL_FCCOB1_CCOBn_3         BIT3
 set     FTFL_FCCOB1_CCOBn_4         BIT4
 set     FTFL_FCCOB1_CCOBn_5         BIT5
 set     FTFL_FCCOB1_CCOBn_6         BIT6
 set     FTFL_FCCOB1_CCOBn_7         BIT7

 set     FTFL_FCCOB0_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB0_CCOBn_0         BIT0
 set     FTFL_FCCOB0_CCOBn_1         BIT1
 set     FTFL_FCCOB0_CCOBn_2         BIT2
 set     FTFL_FCCOB0_CCOBn_3         BIT3
 set     FTFL_FCCOB0_CCOBn_4         BIT4
 set     FTFL_FCCOB0_CCOBn_5         BIT5
 set     FTFL_FCCOB0_CCOBn_6         BIT6
 set     FTFL_FCCOB0_CCOBn_7         BIT7

 set     FTFL_FCCOB7_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB7_CCOBn_0         BIT0
 set     FTFL_FCCOB7_CCOBn_1         BIT1
 set     FTFL_FCCOB7_CCOBn_2         BIT2
 set     FTFL_FCCOB7_CCOBn_3         BIT3
 set     FTFL_FCCOB7_CCOBn_4         BIT4
 set     FTFL_FCCOB7_CCOBn_5         BIT5
 set     FTFL_FCCOB7_CCOBn_6         BIT6
 set     FTFL_FCCOB7_CCOBn_7         BIT7

 set     FTFL_FCCOB6_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB6_CCOBn_0         BIT0
 set     FTFL_FCCOB6_CCOBn_1         BIT1
 set     FTFL_FCCOB6_CCOBn_2         BIT2
 set     FTFL_FCCOB6_CCOBn_3         BIT3
 set     FTFL_FCCOB6_CCOBn_4         BIT4
 set     FTFL_FCCOB6_CCOBn_5         BIT5
 set     FTFL_FCCOB6_CCOBn_6         BIT6
 set     FTFL_FCCOB6_CCOBn_7         BIT7

 set     FTFL_FCCOB5_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB5_CCOBn_0         BIT0
 set     FTFL_FCCOB5_CCOBn_1         BIT1
 set     FTFL_FCCOB5_CCOBn_2         BIT2
 set     FTFL_FCCOB5_CCOBn_3         BIT3
 set     FTFL_FCCOB5_CCOBn_4         BIT4
 set     FTFL_FCCOB5_CCOBn_5         BIT5
 set     FTFL_FCCOB5_CCOBn_6         BIT6
 set     FTFL_FCCOB5_CCOBn_7         BIT7

 set     FTFL_FCCOB4_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB4_CCOBn_0         BIT0
 set     FTFL_FCCOB4_CCOBn_1         BIT1
 set     FTFL_FCCOB4_CCOBn_2         BIT2
 set     FTFL_FCCOB4_CCOBn_3         BIT3
 set     FTFL_FCCOB4_CCOBn_4         BIT4
 set     FTFL_FCCOB4_CCOBn_5         BIT5
 set     FTFL_FCCOB4_CCOBn_6         BIT6
 set     FTFL_FCCOB4_CCOBn_7         BIT7

 set     FTFL_FCCOBB_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOBB_CCOBn_0         BIT0
 set     FTFL_FCCOBB_CCOBn_1         BIT1
 set     FTFL_FCCOBB_CCOBn_2         BIT2
 set     FTFL_FCCOBB_CCOBn_3         BIT3
 set     FTFL_FCCOBB_CCOBn_4         BIT4
 set     FTFL_FCCOBB_CCOBn_5         BIT5
 set     FTFL_FCCOBB_CCOBn_6         BIT6
 set     FTFL_FCCOBB_CCOBn_7         BIT7

 set     FTFL_FCCOBA_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOBA_CCOBn_0         BIT0
 set     FTFL_FCCOBA_CCOBn_1         BIT1
 set     FTFL_FCCOBA_CCOBn_2         BIT2
 set     FTFL_FCCOBA_CCOBn_3         BIT3
 set     FTFL_FCCOBA_CCOBn_4         BIT4
 set     FTFL_FCCOBA_CCOBn_5         BIT5
 set     FTFL_FCCOBA_CCOBn_6         BIT6
 set     FTFL_FCCOBA_CCOBn_7         BIT7

 set     FTFL_FCCOB9_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB9_CCOBn_0         BIT0
 set     FTFL_FCCOB9_CCOBn_1         BIT1
 set     FTFL_FCCOB9_CCOBn_2         BIT2
 set     FTFL_FCCOB9_CCOBn_3         BIT3
 set     FTFL_FCCOB9_CCOBn_4         BIT4
 set     FTFL_FCCOB9_CCOBn_5         BIT5
 set     FTFL_FCCOB9_CCOBn_6         BIT6
 set     FTFL_FCCOB9_CCOBn_7         BIT7

 set     FTFL_FCCOB8_CCOBn           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     FTFL_FCCOB8_CCOBn_0         BIT0
 set     FTFL_FCCOB8_CCOBn_1         BIT1
 set     FTFL_FCCOB8_CCOBn_2         BIT2
 set     FTFL_FCCOB8_CCOBn_3         BIT3
 set     FTFL_FCCOB8_CCOBn_4         BIT4
 set     FTFL_FCCOB8_CCOBn_5         BIT5
 set     FTFL_FCCOB8_CCOBn_6         BIT6
 set     FTFL_FCCOB8_CCOBn_7         BIT7

 set     FTFL_FPROT3_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b0 ==> Program flash region is protected.
;;     0b1 ==> Program flash region is not protected
 set     FTFL_FPROT3_PROT_0          BIT0
 set     FTFL_FPROT3_PROT_1          BIT1
 set     FTFL_FPROT3_PROT_2          BIT2
 set     FTFL_FPROT3_PROT_3          BIT3
 set     FTFL_FPROT3_PROT_4          BIT4
 set     FTFL_FPROT3_PROT_5          BIT5
 set     FTFL_FPROT3_PROT_6          BIT6
 set     FTFL_FPROT3_PROT_7          BIT7

 set     FTFL_FPROT2_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b0 ==> Program flash region is protected.
;;     0b1 ==> Program flash region is not protected
 set     FTFL_FPROT2_PROT_0          BIT0
 set     FTFL_FPROT2_PROT_1          BIT1
 set     FTFL_FPROT2_PROT_2          BIT2
 set     FTFL_FPROT2_PROT_3          BIT3
 set     FTFL_FPROT2_PROT_4          BIT4
 set     FTFL_FPROT2_PROT_5          BIT5
 set     FTFL_FPROT2_PROT_6          BIT6
 set     FTFL_FPROT2_PROT_7          BIT7

 set     FTFL_FPROT1_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b0 ==> Program flash region is protected.
;;     0b1 ==> Program flash region is not protected
 set     FTFL_FPROT1_PROT_0          BIT0
 set     FTFL_FPROT1_PROT_1          BIT1
 set     FTFL_FPROT1_PROT_2          BIT2
 set     FTFL_FPROT1_PROT_3          BIT3
 set     FTFL_FPROT1_PROT_4          BIT4
 set     FTFL_FPROT1_PROT_5          BIT5
 set     FTFL_FPROT1_PROT_6          BIT6
 set     FTFL_FPROT1_PROT_7          BIT7

 set     FTFL_FPROT0_PROT            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Program Flash Region Protect
;;     0b0 ==> Program flash region is protected.
;;     0b1 ==> Program flash region is not protected
 set     FTFL_FPROT0_PROT_0          BIT0
 set     FTFL_FPROT0_PROT_1          BIT1
 set     FTFL_FPROT0_PROT_2          BIT2
 set     FTFL_FPROT0_PROT_3          BIT3
 set     FTFL_FPROT0_PROT_4          BIT4
 set     FTFL_FPROT0_PROT_5          BIT5
 set     FTFL_FPROT0_PROT_6          BIT6
 set     FTFL_FPROT0_PROT_7          BIT7

 set     FTFL_FEPROT_EPROT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   EEPROM Region Protect
;;     0b0 ==> EEPROM region is protected
;;     0b1 ==> EEPROM region is not protected
 set     FTFL_FEPROT_EPROT_0         BIT0
 set     FTFL_FEPROT_EPROT_1         BIT1
 set     FTFL_FEPROT_EPROT_2         BIT2
 set     FTFL_FEPROT_EPROT_3         BIT3
 set     FTFL_FEPROT_EPROT_4         BIT4
 set     FTFL_FEPROT_EPROT_5         BIT5
 set     FTFL_FEPROT_EPROT_6         BIT6
 set     FTFL_FEPROT_EPROT_7         BIT7

 set     FTFL_FDPROT_DPROT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data Flash Region Protect
;;     0b0 ==> Data Flash region is protected
;;     0b1 ==> Data Flash region is not protected
 set     FTFL_FDPROT_DPROT_0         BIT0
 set     FTFL_FDPROT_DPROT_1         BIT1
 set     FTFL_FDPROT_DPROT_2         BIT2
 set     FTFL_FDPROT_DPROT_3         BIT3
 set     FTFL_FDPROT_DPROT_4         BIT4
 set     FTFL_FDPROT_DPROT_5         BIT5
 set     FTFL_FDPROT_DPROT_6         BIT6
 set     FTFL_FDPROT_DPROT_7         BIT7

 set     GPIOA_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0 ==> Pull resistor is disabled
;;     0b1 ==> Pull resistor is enabled
 set     GPIOA_PUR_PU_0              BIT0
 set     GPIOA_PUR_PU_1              BIT1
 set     GPIOA_PUR_PU_2              BIT2
 set     GPIOA_PUR_PU_3              BIT3
 set     GPIOA_PUR_PU_4              BIT4
 set     GPIOA_PUR_PU_5              BIT5
 set     GPIOA_PUR_PU_6              BIT6
 set     GPIOA_PUR_PU_7              BIT7
 set     GPIOA_PUR_PU_8              BIT8
 set     GPIOA_PUR_PU_9              BIT9
 set     GPIOA_PUR_PU_10             BIT10
 set     GPIOA_PUR_PU_11             BIT11
 set     GPIOA_PUR_PU_12             BIT12
 set     GPIOA_PUR_PU_13             BIT13
 set     GPIOA_PUR_PU_14             BIT14
 set     GPIOA_PUR_PU_15             BIT15

 set     GPIOA_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOA_DR_D_0                BIT0
 set     GPIOA_DR_D_1                BIT1
 set     GPIOA_DR_D_2                BIT2
 set     GPIOA_DR_D_3                BIT3
 set     GPIOA_DR_D_4                BIT4
 set     GPIOA_DR_D_5                BIT5
 set     GPIOA_DR_D_6                BIT6
 set     GPIOA_DR_D_7                BIT7
 set     GPIOA_DR_D_8                BIT8
 set     GPIOA_DR_D_9                BIT9
 set     GPIOA_DR_D_10               BIT10
 set     GPIOA_DR_D_11               BIT11
 set     GPIOA_DR_D_12               BIT12
 set     GPIOA_DR_D_13               BIT13
 set     GPIOA_DR_D_14               BIT14
 set     GPIOA_DR_D_15               BIT15

 set     GPIOA_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0 ==> Pin is an input
;;     0b1 ==> Pin is an output
 set     GPIOA_DDR_DD_0              BIT0
 set     GPIOA_DDR_DD_1              BIT1
 set     GPIOA_DDR_DD_2              BIT2
 set     GPIOA_DDR_DD_3              BIT3
 set     GPIOA_DDR_DD_4              BIT4
 set     GPIOA_DDR_DD_5              BIT5
 set     GPIOA_DDR_DD_6              BIT6
 set     GPIOA_DDR_DD_7              BIT7
 set     GPIOA_DDR_DD_8              BIT8
 set     GPIOA_DDR_DD_9              BIT9
 set     GPIOA_DDR_DD_10             BIT10
 set     GPIOA_DDR_DD_11             BIT11
 set     GPIOA_DDR_DD_12             BIT12
 set     GPIOA_DDR_DD_13             BIT13
 set     GPIOA_DDR_DD_14             BIT14
 set     GPIOA_DDR_DD_15             BIT15

 set     GPIOA_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0 ==> Pin is for GPIO (GPIO mode)
;;     0b1 ==> Pin is for peripheral (peripheral mode)
 set     GPIOA_PER_PE_0              BIT0
 set     GPIOA_PER_PE_1              BIT1
 set     GPIOA_PER_PE_2              BIT2
 set     GPIOA_PER_PE_3              BIT3
 set     GPIOA_PER_PE_4              BIT4
 set     GPIOA_PER_PE_5              BIT5
 set     GPIOA_PER_PE_6              BIT6
 set     GPIOA_PER_PE_7              BIT7
 set     GPIOA_PER_PE_8              BIT8
 set     GPIOA_PER_PE_9              BIT9
 set     GPIOA_PER_PE_10             BIT10
 set     GPIOA_PER_PE_11             BIT11
 set     GPIOA_PER_PE_12             BIT12
 set     GPIOA_PER_PE_13             BIT13
 set     GPIOA_PER_PE_14             BIT14
 set     GPIOA_PER_PE_15             BIT15

 set     GPIOA_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0 ==> Deassert software interrupt
;;     0b1 ==> Assert software interrupt
 set     GPIOA_IAR_IA_0              BIT0
 set     GPIOA_IAR_IA_1              BIT1
 set     GPIOA_IAR_IA_2              BIT2
 set     GPIOA_IAR_IA_3              BIT3
 set     GPIOA_IAR_IA_4              BIT4
 set     GPIOA_IAR_IA_5              BIT5
 set     GPIOA_IAR_IA_6              BIT6
 set     GPIOA_IAR_IA_7              BIT7
 set     GPIOA_IAR_IA_8              BIT8
 set     GPIOA_IAR_IA_9              BIT9
 set     GPIOA_IAR_IA_10             BIT10
 set     GPIOA_IAR_IA_11             BIT11
 set     GPIOA_IAR_IA_12             BIT12
 set     GPIOA_IAR_IA_13             BIT13
 set     GPIOA_IAR_IA_14             BIT14
 set     GPIOA_IAR_IA_15             BIT15

 set     GPIOA_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0 ==> External Interrupt is disabled
;;     0b1 ==> External Interrupt is enabled
 set     GPIOA_IENR_IEN_0            BIT0
 set     GPIOA_IENR_IEN_1            BIT1
 set     GPIOA_IENR_IEN_2            BIT2
 set     GPIOA_IENR_IEN_3            BIT3
 set     GPIOA_IENR_IEN_4            BIT4
 set     GPIOA_IENR_IEN_5            BIT5
 set     GPIOA_IENR_IEN_6            BIT6
 set     GPIOA_IENR_IEN_7            BIT7
 set     GPIOA_IENR_IEN_8            BIT8
 set     GPIOA_IENR_IEN_9            BIT9
 set     GPIOA_IENR_IEN_10           BIT10
 set     GPIOA_IENR_IEN_11           BIT11
 set     GPIOA_IENR_IEN_12           BIT12
 set     GPIOA_IENR_IEN_13           BIT13
 set     GPIOA_IENR_IEN_14           BIT14
 set     GPIOA_IENR_IEN_15           BIT15

 set     GPIOA_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0 ==> Interrupt occurred on rising edge
;;     0b1 ==> Interrupt occurred on falling edge
 set     GPIOA_IPOLR_IPOL_0          BIT0
 set     GPIOA_IPOLR_IPOL_1          BIT1
 set     GPIOA_IPOLR_IPOL_2          BIT2
 set     GPIOA_IPOLR_IPOL_3          BIT3
 set     GPIOA_IPOLR_IPOL_4          BIT4
 set     GPIOA_IPOLR_IPOL_5          BIT5
 set     GPIOA_IPOLR_IPOL_6          BIT6
 set     GPIOA_IPOLR_IPOL_7          BIT7
 set     GPIOA_IPOLR_IPOL_8          BIT8
 set     GPIOA_IPOLR_IPOL_9          BIT9
 set     GPIOA_IPOLR_IPOL_10         BIT10
 set     GPIOA_IPOLR_IPOL_11         BIT11
 set     GPIOA_IPOLR_IPOL_12         BIT12
 set     GPIOA_IPOLR_IPOL_13         BIT13
 set     GPIOA_IPOLR_IPOL_14         BIT14
 set     GPIOA_IPOLR_IPOL_15         BIT15

 set     GPIOA_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0 ==> No Interrupt
;;     0b1 ==> Interrupt occurred
 set     GPIOA_IPR_IP_0              BIT0
 set     GPIOA_IPR_IP_1              BIT1
 set     GPIOA_IPR_IP_2              BIT2
 set     GPIOA_IPR_IP_3              BIT3
 set     GPIOA_IPR_IP_4              BIT4
 set     GPIOA_IPR_IP_5              BIT5
 set     GPIOA_IPR_IP_6              BIT6
 set     GPIOA_IPR_IP_7              BIT7
 set     GPIOA_IPR_IP_8              BIT8
 set     GPIOA_IPR_IP_9              BIT9
 set     GPIOA_IPR_IP_10             BIT10
 set     GPIOA_IPR_IP_11             BIT11
 set     GPIOA_IPR_IP_12             BIT12
 set     GPIOA_IPR_IP_13             BIT13
 set     GPIOA_IPR_IP_14             BIT14
 set     GPIOA_IPR_IP_15             BIT15

 set     GPIOA_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0 ==> No edge detected if read; no effect if writing
;;     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOA_IESR_IES_0            BIT0
 set     GPIOA_IESR_IES_1            BIT1
 set     GPIOA_IESR_IES_2            BIT2
 set     GPIOA_IESR_IES_3            BIT3
 set     GPIOA_IESR_IES_4            BIT4
 set     GPIOA_IESR_IES_5            BIT5
 set     GPIOA_IESR_IES_6            BIT6
 set     GPIOA_IESR_IES_7            BIT7
 set     GPIOA_IESR_IES_8            BIT8
 set     GPIOA_IESR_IES_9            BIT9
 set     GPIOA_IESR_IES_10           BIT10
 set     GPIOA_IESR_IES_11           BIT11
 set     GPIOA_IESR_IES_12           BIT12
 set     GPIOA_IESR_IES_13           BIT13
 set     GPIOA_IESR_IES_14           BIT14
 set     GPIOA_IESR_IES_15           BIT15

 set     GPIOA_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0 ==> Open Drain Mode
;;     0b1 ==> Push-Pull Mode
 set     GPIOA_PPMODE_PPMODE_0       BIT0
 set     GPIOA_PPMODE_PPMODE_1       BIT1
 set     GPIOA_PPMODE_PPMODE_2       BIT2
 set     GPIOA_PPMODE_PPMODE_3       BIT3
 set     GPIOA_PPMODE_PPMODE_4       BIT4
 set     GPIOA_PPMODE_PPMODE_5       BIT5
 set     GPIOA_PPMODE_PPMODE_6       BIT6
 set     GPIOA_PPMODE_PPMODE_7       BIT7
 set     GPIOA_PPMODE_PPMODE_8       BIT8
 set     GPIOA_PPMODE_PPMODE_9       BIT9
 set     GPIOA_PPMODE_PPMODE_10      BIT10
 set     GPIOA_PPMODE_PPMODE_11      BIT11
 set     GPIOA_PPMODE_PPMODE_12      BIT12
 set     GPIOA_PPMODE_PPMODE_13      BIT13
 set     GPIOA_PPMODE_PPMODE_14      BIT14
 set     GPIOA_PPMODE_PPMODE_15      BIT15

 set     GPIOA_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOA_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOA_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOA_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOA_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOA_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOA_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOA_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOA_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOA_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOA_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOA_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOA_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOA_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOA_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOA_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOA_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOA_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0 ==> Low drive strength
;;     0b1 ==> High drive strength
 set     GPIOA_DRIVE_DRIVE_0         BIT0
 set     GPIOA_DRIVE_DRIVE_1         BIT1
 set     GPIOA_DRIVE_DRIVE_2         BIT2
 set     GPIOA_DRIVE_DRIVE_3         BIT3
 set     GPIOA_DRIVE_DRIVE_4         BIT4
 set     GPIOA_DRIVE_DRIVE_5         BIT5
 set     GPIOA_DRIVE_DRIVE_6         BIT6
 set     GPIOA_DRIVE_DRIVE_7         BIT7
 set     GPIOA_DRIVE_DRIVE_8         BIT8
 set     GPIOA_DRIVE_DRIVE_9         BIT9
 set     GPIOA_DRIVE_DRIVE_10        BIT10
 set     GPIOA_DRIVE_DRIVE_11        BIT11
 set     GPIOA_DRIVE_DRIVE_12        BIT12
 set     GPIOA_DRIVE_DRIVE_13        BIT13
 set     GPIOA_DRIVE_DRIVE_14        BIT14
 set     GPIOA_DRIVE_DRIVE_15        BIT15

 set     GPIOA_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0 ==> Pulldown resistor
;;     0b1 ==> Pullup resistor
 set     GPIOA_PUS_PUS_0             BIT0
 set     GPIOA_PUS_PUS_1             BIT1
 set     GPIOA_PUS_PUS_2             BIT2
 set     GPIOA_PUS_PUS_3             BIT3
 set     GPIOA_PUS_PUS_4             BIT4
 set     GPIOA_PUS_PUS_5             BIT5
 set     GPIOA_PUS_PUS_6             BIT6
 set     GPIOA_PUS_PUS_7             BIT7
 set     GPIOA_PUS_PUS_8             BIT8
 set     GPIOA_PUS_PUS_9             BIT9
 set     GPIOA_PUS_PUS_10            BIT10
 set     GPIOA_PUS_PUS_11            BIT11
 set     GPIOA_PUS_PUS_12            BIT12
 set     GPIOA_PUS_PUS_13            BIT13
 set     GPIOA_PUS_PUS_14            BIT14
 set     GPIOA_PUS_PUS_15            BIT15

 set     GPIOA_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOA_SRE_SRE_0             BIT0
 set     GPIOA_SRE_SRE_1             BIT1
 set     GPIOA_SRE_SRE_2             BIT2
 set     GPIOA_SRE_SRE_3             BIT3
 set     GPIOA_SRE_SRE_4             BIT4
 set     GPIOA_SRE_SRE_5             BIT5
 set     GPIOA_SRE_SRE_6             BIT6
 set     GPIOA_SRE_SRE_7             BIT7
 set     GPIOA_SRE_SRE_8             BIT8
 set     GPIOA_SRE_SRE_9             BIT9
 set     GPIOA_SRE_SRE_10            BIT10
 set     GPIOA_SRE_SRE_11            BIT11
 set     GPIOA_SRE_SRE_12            BIT12
 set     GPIOA_SRE_SRE_13            BIT13
 set     GPIOA_SRE_SRE_14            BIT14
 set     GPIOA_SRE_SRE_15            BIT15

 set     GPIOB_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0 ==> Pull resistor is disabled
;;     0b1 ==> Pull resistor is enabled
 set     GPIOB_PUR_PU_0              BIT0
 set     GPIOB_PUR_PU_1              BIT1
 set     GPIOB_PUR_PU_2              BIT2
 set     GPIOB_PUR_PU_3              BIT3
 set     GPIOB_PUR_PU_4              BIT4
 set     GPIOB_PUR_PU_5              BIT5
 set     GPIOB_PUR_PU_6              BIT6
 set     GPIOB_PUR_PU_7              BIT7
 set     GPIOB_PUR_PU_8              BIT8
 set     GPIOB_PUR_PU_9              BIT9
 set     GPIOB_PUR_PU_10             BIT10
 set     GPIOB_PUR_PU_11             BIT11
 set     GPIOB_PUR_PU_12             BIT12
 set     GPIOB_PUR_PU_13             BIT13
 set     GPIOB_PUR_PU_14             BIT14
 set     GPIOB_PUR_PU_15             BIT15

 set     GPIOB_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOB_DR_D_0                BIT0
 set     GPIOB_DR_D_1                BIT1
 set     GPIOB_DR_D_2                BIT2
 set     GPIOB_DR_D_3                BIT3
 set     GPIOB_DR_D_4                BIT4
 set     GPIOB_DR_D_5                BIT5
 set     GPIOB_DR_D_6                BIT6
 set     GPIOB_DR_D_7                BIT7
 set     GPIOB_DR_D_8                BIT8
 set     GPIOB_DR_D_9                BIT9
 set     GPIOB_DR_D_10               BIT10
 set     GPIOB_DR_D_11               BIT11
 set     GPIOB_DR_D_12               BIT12
 set     GPIOB_DR_D_13               BIT13
 set     GPIOB_DR_D_14               BIT14
 set     GPIOB_DR_D_15               BIT15

 set     GPIOB_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0 ==> Pin is an input
;;     0b1 ==> Pin is an output
 set     GPIOB_DDR_DD_0              BIT0
 set     GPIOB_DDR_DD_1              BIT1
 set     GPIOB_DDR_DD_2              BIT2
 set     GPIOB_DDR_DD_3              BIT3
 set     GPIOB_DDR_DD_4              BIT4
 set     GPIOB_DDR_DD_5              BIT5
 set     GPIOB_DDR_DD_6              BIT6
 set     GPIOB_DDR_DD_7              BIT7
 set     GPIOB_DDR_DD_8              BIT8
 set     GPIOB_DDR_DD_9              BIT9
 set     GPIOB_DDR_DD_10             BIT10
 set     GPIOB_DDR_DD_11             BIT11
 set     GPIOB_DDR_DD_12             BIT12
 set     GPIOB_DDR_DD_13             BIT13
 set     GPIOB_DDR_DD_14             BIT14
 set     GPIOB_DDR_DD_15             BIT15

 set     GPIOB_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0 ==> Pin is for GPIO (GPIO mode)
;;     0b1 ==> Pin is for peripheral (peripheral mode)
 set     GPIOB_PER_PE_0              BIT0
 set     GPIOB_PER_PE_1              BIT1
 set     GPIOB_PER_PE_2              BIT2
 set     GPIOB_PER_PE_3              BIT3
 set     GPIOB_PER_PE_4              BIT4
 set     GPIOB_PER_PE_5              BIT5
 set     GPIOB_PER_PE_6              BIT6
 set     GPIOB_PER_PE_7              BIT7
 set     GPIOB_PER_PE_8              BIT8
 set     GPIOB_PER_PE_9              BIT9
 set     GPIOB_PER_PE_10             BIT10
 set     GPIOB_PER_PE_11             BIT11
 set     GPIOB_PER_PE_12             BIT12
 set     GPIOB_PER_PE_13             BIT13
 set     GPIOB_PER_PE_14             BIT14
 set     GPIOB_PER_PE_15             BIT15

 set     GPIOB_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0 ==> Deassert software interrupt
;;     0b1 ==> Assert software interrupt
 set     GPIOB_IAR_IA_0              BIT0
 set     GPIOB_IAR_IA_1              BIT1
 set     GPIOB_IAR_IA_2              BIT2
 set     GPIOB_IAR_IA_3              BIT3
 set     GPIOB_IAR_IA_4              BIT4
 set     GPIOB_IAR_IA_5              BIT5
 set     GPIOB_IAR_IA_6              BIT6
 set     GPIOB_IAR_IA_7              BIT7
 set     GPIOB_IAR_IA_8              BIT8
 set     GPIOB_IAR_IA_9              BIT9
 set     GPIOB_IAR_IA_10             BIT10
 set     GPIOB_IAR_IA_11             BIT11
 set     GPIOB_IAR_IA_12             BIT12
 set     GPIOB_IAR_IA_13             BIT13
 set     GPIOB_IAR_IA_14             BIT14
 set     GPIOB_IAR_IA_15             BIT15

 set     GPIOB_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0 ==> External Interrupt is disabled
;;     0b1 ==> External Interrupt is enabled
 set     GPIOB_IENR_IEN_0            BIT0
 set     GPIOB_IENR_IEN_1            BIT1
 set     GPIOB_IENR_IEN_2            BIT2
 set     GPIOB_IENR_IEN_3            BIT3
 set     GPIOB_IENR_IEN_4            BIT4
 set     GPIOB_IENR_IEN_5            BIT5
 set     GPIOB_IENR_IEN_6            BIT6
 set     GPIOB_IENR_IEN_7            BIT7
 set     GPIOB_IENR_IEN_8            BIT8
 set     GPIOB_IENR_IEN_9            BIT9
 set     GPIOB_IENR_IEN_10           BIT10
 set     GPIOB_IENR_IEN_11           BIT11
 set     GPIOB_IENR_IEN_12           BIT12
 set     GPIOB_IENR_IEN_13           BIT13
 set     GPIOB_IENR_IEN_14           BIT14
 set     GPIOB_IENR_IEN_15           BIT15

 set     GPIOB_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0 ==> Interrupt occurred on rising edge
;;     0b1 ==> Interrupt occurred on falling edge
 set     GPIOB_IPOLR_IPOL_0          BIT0
 set     GPIOB_IPOLR_IPOL_1          BIT1
 set     GPIOB_IPOLR_IPOL_2          BIT2
 set     GPIOB_IPOLR_IPOL_3          BIT3
 set     GPIOB_IPOLR_IPOL_4          BIT4
 set     GPIOB_IPOLR_IPOL_5          BIT5
 set     GPIOB_IPOLR_IPOL_6          BIT6
 set     GPIOB_IPOLR_IPOL_7          BIT7
 set     GPIOB_IPOLR_IPOL_8          BIT8
 set     GPIOB_IPOLR_IPOL_9          BIT9
 set     GPIOB_IPOLR_IPOL_10         BIT10
 set     GPIOB_IPOLR_IPOL_11         BIT11
 set     GPIOB_IPOLR_IPOL_12         BIT12
 set     GPIOB_IPOLR_IPOL_13         BIT13
 set     GPIOB_IPOLR_IPOL_14         BIT14
 set     GPIOB_IPOLR_IPOL_15         BIT15

 set     GPIOB_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0 ==> No Interrupt
;;     0b1 ==> Interrupt occurred
 set     GPIOB_IPR_IP_0              BIT0
 set     GPIOB_IPR_IP_1              BIT1
 set     GPIOB_IPR_IP_2              BIT2
 set     GPIOB_IPR_IP_3              BIT3
 set     GPIOB_IPR_IP_4              BIT4
 set     GPIOB_IPR_IP_5              BIT5
 set     GPIOB_IPR_IP_6              BIT6
 set     GPIOB_IPR_IP_7              BIT7
 set     GPIOB_IPR_IP_8              BIT8
 set     GPIOB_IPR_IP_9              BIT9
 set     GPIOB_IPR_IP_10             BIT10
 set     GPIOB_IPR_IP_11             BIT11
 set     GPIOB_IPR_IP_12             BIT12
 set     GPIOB_IPR_IP_13             BIT13
 set     GPIOB_IPR_IP_14             BIT14
 set     GPIOB_IPR_IP_15             BIT15

 set     GPIOB_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0 ==> No edge detected if read; no effect if writing
;;     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOB_IESR_IES_0            BIT0
 set     GPIOB_IESR_IES_1            BIT1
 set     GPIOB_IESR_IES_2            BIT2
 set     GPIOB_IESR_IES_3            BIT3
 set     GPIOB_IESR_IES_4            BIT4
 set     GPIOB_IESR_IES_5            BIT5
 set     GPIOB_IESR_IES_6            BIT6
 set     GPIOB_IESR_IES_7            BIT7
 set     GPIOB_IESR_IES_8            BIT8
 set     GPIOB_IESR_IES_9            BIT9
 set     GPIOB_IESR_IES_10           BIT10
 set     GPIOB_IESR_IES_11           BIT11
 set     GPIOB_IESR_IES_12           BIT12
 set     GPIOB_IESR_IES_13           BIT13
 set     GPIOB_IESR_IES_14           BIT14
 set     GPIOB_IESR_IES_15           BIT15

 set     GPIOB_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0 ==> Open Drain Mode
;;     0b1 ==> Push-Pull Mode
 set     GPIOB_PPMODE_PPMODE_0       BIT0
 set     GPIOB_PPMODE_PPMODE_1       BIT1
 set     GPIOB_PPMODE_PPMODE_2       BIT2
 set     GPIOB_PPMODE_PPMODE_3       BIT3
 set     GPIOB_PPMODE_PPMODE_4       BIT4
 set     GPIOB_PPMODE_PPMODE_5       BIT5
 set     GPIOB_PPMODE_PPMODE_6       BIT6
 set     GPIOB_PPMODE_PPMODE_7       BIT7
 set     GPIOB_PPMODE_PPMODE_8       BIT8
 set     GPIOB_PPMODE_PPMODE_9       BIT9
 set     GPIOB_PPMODE_PPMODE_10      BIT10
 set     GPIOB_PPMODE_PPMODE_11      BIT11
 set     GPIOB_PPMODE_PPMODE_12      BIT12
 set     GPIOB_PPMODE_PPMODE_13      BIT13
 set     GPIOB_PPMODE_PPMODE_14      BIT14
 set     GPIOB_PPMODE_PPMODE_15      BIT15

 set     GPIOB_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOB_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOB_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOB_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOB_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOB_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOB_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOB_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOB_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOB_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOB_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOB_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOB_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOB_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOB_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOB_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOB_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOB_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0 ==> Low drive strength
;;     0b1 ==> High drive strength
 set     GPIOB_DRIVE_DRIVE_0         BIT0
 set     GPIOB_DRIVE_DRIVE_1         BIT1
 set     GPIOB_DRIVE_DRIVE_2         BIT2
 set     GPIOB_DRIVE_DRIVE_3         BIT3
 set     GPIOB_DRIVE_DRIVE_4         BIT4
 set     GPIOB_DRIVE_DRIVE_5         BIT5
 set     GPIOB_DRIVE_DRIVE_6         BIT6
 set     GPIOB_DRIVE_DRIVE_7         BIT7
 set     GPIOB_DRIVE_DRIVE_8         BIT8
 set     GPIOB_DRIVE_DRIVE_9         BIT9
 set     GPIOB_DRIVE_DRIVE_10        BIT10
 set     GPIOB_DRIVE_DRIVE_11        BIT11
 set     GPIOB_DRIVE_DRIVE_12        BIT12
 set     GPIOB_DRIVE_DRIVE_13        BIT13
 set     GPIOB_DRIVE_DRIVE_14        BIT14
 set     GPIOB_DRIVE_DRIVE_15        BIT15

 set     GPIOB_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0 ==> Pulldown resistor
;;     0b1 ==> Pullup resistor
 set     GPIOB_PUS_PUS_0             BIT0
 set     GPIOB_PUS_PUS_1             BIT1
 set     GPIOB_PUS_PUS_2             BIT2
 set     GPIOB_PUS_PUS_3             BIT3
 set     GPIOB_PUS_PUS_4             BIT4
 set     GPIOB_PUS_PUS_5             BIT5
 set     GPIOB_PUS_PUS_6             BIT6
 set     GPIOB_PUS_PUS_7             BIT7
 set     GPIOB_PUS_PUS_8             BIT8
 set     GPIOB_PUS_PUS_9             BIT9
 set     GPIOB_PUS_PUS_10            BIT10
 set     GPIOB_PUS_PUS_11            BIT11
 set     GPIOB_PUS_PUS_12            BIT12
 set     GPIOB_PUS_PUS_13            BIT13
 set     GPIOB_PUS_PUS_14            BIT14
 set     GPIOB_PUS_PUS_15            BIT15

 set     GPIOB_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOB_SRE_SRE_0             BIT0
 set     GPIOB_SRE_SRE_1             BIT1
 set     GPIOB_SRE_SRE_2             BIT2
 set     GPIOB_SRE_SRE_3             BIT3
 set     GPIOB_SRE_SRE_4             BIT4
 set     GPIOB_SRE_SRE_5             BIT5
 set     GPIOB_SRE_SRE_6             BIT6
 set     GPIOB_SRE_SRE_7             BIT7
 set     GPIOB_SRE_SRE_8             BIT8
 set     GPIOB_SRE_SRE_9             BIT9
 set     GPIOB_SRE_SRE_10            BIT10
 set     GPIOB_SRE_SRE_11            BIT11
 set     GPIOB_SRE_SRE_12            BIT12
 set     GPIOB_SRE_SRE_13            BIT13
 set     GPIOB_SRE_SRE_14            BIT14
 set     GPIOB_SRE_SRE_15            BIT15

 set     GPIOC_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0 ==> Pull resistor is disabled
;;     0b1 ==> Pull resistor is enabled
 set     GPIOC_PUR_PU_0              BIT0
 set     GPIOC_PUR_PU_1              BIT1
 set     GPIOC_PUR_PU_2              BIT2
 set     GPIOC_PUR_PU_3              BIT3
 set     GPIOC_PUR_PU_4              BIT4
 set     GPIOC_PUR_PU_5              BIT5
 set     GPIOC_PUR_PU_6              BIT6
 set     GPIOC_PUR_PU_7              BIT7
 set     GPIOC_PUR_PU_8              BIT8
 set     GPIOC_PUR_PU_9              BIT9
 set     GPIOC_PUR_PU_10             BIT10
 set     GPIOC_PUR_PU_11             BIT11
 set     GPIOC_PUR_PU_12             BIT12
 set     GPIOC_PUR_PU_13             BIT13
 set     GPIOC_PUR_PU_14             BIT14
 set     GPIOC_PUR_PU_15             BIT15

 set     GPIOC_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOC_DR_D_0                BIT0
 set     GPIOC_DR_D_1                BIT1
 set     GPIOC_DR_D_2                BIT2
 set     GPIOC_DR_D_3                BIT3
 set     GPIOC_DR_D_4                BIT4
 set     GPIOC_DR_D_5                BIT5
 set     GPIOC_DR_D_6                BIT6
 set     GPIOC_DR_D_7                BIT7
 set     GPIOC_DR_D_8                BIT8
 set     GPIOC_DR_D_9                BIT9
 set     GPIOC_DR_D_10               BIT10
 set     GPIOC_DR_D_11               BIT11
 set     GPIOC_DR_D_12               BIT12
 set     GPIOC_DR_D_13               BIT13
 set     GPIOC_DR_D_14               BIT14
 set     GPIOC_DR_D_15               BIT15

 set     GPIOC_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0 ==> Pin is an input
;;     0b1 ==> Pin is an output
 set     GPIOC_DDR_DD_0              BIT0
 set     GPIOC_DDR_DD_1              BIT1
 set     GPIOC_DDR_DD_2              BIT2
 set     GPIOC_DDR_DD_3              BIT3
 set     GPIOC_DDR_DD_4              BIT4
 set     GPIOC_DDR_DD_5              BIT5
 set     GPIOC_DDR_DD_6              BIT6
 set     GPIOC_DDR_DD_7              BIT7
 set     GPIOC_DDR_DD_8              BIT8
 set     GPIOC_DDR_DD_9              BIT9
 set     GPIOC_DDR_DD_10             BIT10
 set     GPIOC_DDR_DD_11             BIT11
 set     GPIOC_DDR_DD_12             BIT12
 set     GPIOC_DDR_DD_13             BIT13
 set     GPIOC_DDR_DD_14             BIT14
 set     GPIOC_DDR_DD_15             BIT15

 set     GPIOC_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0 ==> Pin is for GPIO (GPIO mode)
;;     0b1 ==> Pin is for peripheral (peripheral mode)
 set     GPIOC_PER_PE_0              BIT0
 set     GPIOC_PER_PE_1              BIT1
 set     GPIOC_PER_PE_2              BIT2
 set     GPIOC_PER_PE_3              BIT3
 set     GPIOC_PER_PE_4              BIT4
 set     GPIOC_PER_PE_5              BIT5
 set     GPIOC_PER_PE_6              BIT6
 set     GPIOC_PER_PE_7              BIT7
 set     GPIOC_PER_PE_8              BIT8
 set     GPIOC_PER_PE_9              BIT9
 set     GPIOC_PER_PE_10             BIT10
 set     GPIOC_PER_PE_11             BIT11
 set     GPIOC_PER_PE_12             BIT12
 set     GPIOC_PER_PE_13             BIT13
 set     GPIOC_PER_PE_14             BIT14
 set     GPIOC_PER_PE_15             BIT15

 set     GPIOC_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0 ==> Deassert software interrupt
;;     0b1 ==> Assert software interrupt
 set     GPIOC_IAR_IA_0              BIT0
 set     GPIOC_IAR_IA_1              BIT1
 set     GPIOC_IAR_IA_2              BIT2
 set     GPIOC_IAR_IA_3              BIT3
 set     GPIOC_IAR_IA_4              BIT4
 set     GPIOC_IAR_IA_5              BIT5
 set     GPIOC_IAR_IA_6              BIT6
 set     GPIOC_IAR_IA_7              BIT7
 set     GPIOC_IAR_IA_8              BIT8
 set     GPIOC_IAR_IA_9              BIT9
 set     GPIOC_IAR_IA_10             BIT10
 set     GPIOC_IAR_IA_11             BIT11
 set     GPIOC_IAR_IA_12             BIT12
 set     GPIOC_IAR_IA_13             BIT13
 set     GPIOC_IAR_IA_14             BIT14
 set     GPIOC_IAR_IA_15             BIT15

 set     GPIOC_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0 ==> External Interrupt is disabled
;;     0b1 ==> External Interrupt is enabled
 set     GPIOC_IENR_IEN_0            BIT0
 set     GPIOC_IENR_IEN_1            BIT1
 set     GPIOC_IENR_IEN_2            BIT2
 set     GPIOC_IENR_IEN_3            BIT3
 set     GPIOC_IENR_IEN_4            BIT4
 set     GPIOC_IENR_IEN_5            BIT5
 set     GPIOC_IENR_IEN_6            BIT6
 set     GPIOC_IENR_IEN_7            BIT7
 set     GPIOC_IENR_IEN_8            BIT8
 set     GPIOC_IENR_IEN_9            BIT9
 set     GPIOC_IENR_IEN_10           BIT10
 set     GPIOC_IENR_IEN_11           BIT11
 set     GPIOC_IENR_IEN_12           BIT12
 set     GPIOC_IENR_IEN_13           BIT13
 set     GPIOC_IENR_IEN_14           BIT14
 set     GPIOC_IENR_IEN_15           BIT15

 set     GPIOC_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0 ==> Interrupt occurred on rising edge
;;     0b1 ==> Interrupt occurred on falling edge
 set     GPIOC_IPOLR_IPOL_0          BIT0
 set     GPIOC_IPOLR_IPOL_1          BIT1
 set     GPIOC_IPOLR_IPOL_2          BIT2
 set     GPIOC_IPOLR_IPOL_3          BIT3
 set     GPIOC_IPOLR_IPOL_4          BIT4
 set     GPIOC_IPOLR_IPOL_5          BIT5
 set     GPIOC_IPOLR_IPOL_6          BIT6
 set     GPIOC_IPOLR_IPOL_7          BIT7
 set     GPIOC_IPOLR_IPOL_8          BIT8
 set     GPIOC_IPOLR_IPOL_9          BIT9
 set     GPIOC_IPOLR_IPOL_10         BIT10
 set     GPIOC_IPOLR_IPOL_11         BIT11
 set     GPIOC_IPOLR_IPOL_12         BIT12
 set     GPIOC_IPOLR_IPOL_13         BIT13
 set     GPIOC_IPOLR_IPOL_14         BIT14
 set     GPIOC_IPOLR_IPOL_15         BIT15

 set     GPIOC_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0 ==> No Interrupt
;;     0b1 ==> Interrupt occurred
 set     GPIOC_IPR_IP_0              BIT0
 set     GPIOC_IPR_IP_1              BIT1
 set     GPIOC_IPR_IP_2              BIT2
 set     GPIOC_IPR_IP_3              BIT3
 set     GPIOC_IPR_IP_4              BIT4
 set     GPIOC_IPR_IP_5              BIT5
 set     GPIOC_IPR_IP_6              BIT6
 set     GPIOC_IPR_IP_7              BIT7
 set     GPIOC_IPR_IP_8              BIT8
 set     GPIOC_IPR_IP_9              BIT9
 set     GPIOC_IPR_IP_10             BIT10
 set     GPIOC_IPR_IP_11             BIT11
 set     GPIOC_IPR_IP_12             BIT12
 set     GPIOC_IPR_IP_13             BIT13
 set     GPIOC_IPR_IP_14             BIT14
 set     GPIOC_IPR_IP_15             BIT15

 set     GPIOC_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0 ==> No edge detected if read; no effect if writing
;;     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOC_IESR_IES_0            BIT0
 set     GPIOC_IESR_IES_1            BIT1
 set     GPIOC_IESR_IES_2            BIT2
 set     GPIOC_IESR_IES_3            BIT3
 set     GPIOC_IESR_IES_4            BIT4
 set     GPIOC_IESR_IES_5            BIT5
 set     GPIOC_IESR_IES_6            BIT6
 set     GPIOC_IESR_IES_7            BIT7
 set     GPIOC_IESR_IES_8            BIT8
 set     GPIOC_IESR_IES_9            BIT9
 set     GPIOC_IESR_IES_10           BIT10
 set     GPIOC_IESR_IES_11           BIT11
 set     GPIOC_IESR_IES_12           BIT12
 set     GPIOC_IESR_IES_13           BIT13
 set     GPIOC_IESR_IES_14           BIT14
 set     GPIOC_IESR_IES_15           BIT15

 set     GPIOC_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0 ==> Open Drain Mode
;;     0b1 ==> Push-Pull Mode
 set     GPIOC_PPMODE_PPMODE_0       BIT0
 set     GPIOC_PPMODE_PPMODE_1       BIT1
 set     GPIOC_PPMODE_PPMODE_2       BIT2
 set     GPIOC_PPMODE_PPMODE_3       BIT3
 set     GPIOC_PPMODE_PPMODE_4       BIT4
 set     GPIOC_PPMODE_PPMODE_5       BIT5
 set     GPIOC_PPMODE_PPMODE_6       BIT6
 set     GPIOC_PPMODE_PPMODE_7       BIT7
 set     GPIOC_PPMODE_PPMODE_8       BIT8
 set     GPIOC_PPMODE_PPMODE_9       BIT9
 set     GPIOC_PPMODE_PPMODE_10      BIT10
 set     GPIOC_PPMODE_PPMODE_11      BIT11
 set     GPIOC_PPMODE_PPMODE_12      BIT12
 set     GPIOC_PPMODE_PPMODE_13      BIT13
 set     GPIOC_PPMODE_PPMODE_14      BIT14
 set     GPIOC_PPMODE_PPMODE_15      BIT15

 set     GPIOC_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOC_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOC_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOC_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOC_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOC_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOC_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOC_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOC_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOC_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOC_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOC_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOC_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOC_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOC_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOC_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOC_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOC_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0 ==> Low drive strength
;;     0b1 ==> High drive strength
 set     GPIOC_DRIVE_DRIVE_0         BIT0
 set     GPIOC_DRIVE_DRIVE_1         BIT1
 set     GPIOC_DRIVE_DRIVE_2         BIT2
 set     GPIOC_DRIVE_DRIVE_3         BIT3
 set     GPIOC_DRIVE_DRIVE_4         BIT4
 set     GPIOC_DRIVE_DRIVE_5         BIT5
 set     GPIOC_DRIVE_DRIVE_6         BIT6
 set     GPIOC_DRIVE_DRIVE_7         BIT7
 set     GPIOC_DRIVE_DRIVE_8         BIT8
 set     GPIOC_DRIVE_DRIVE_9         BIT9
 set     GPIOC_DRIVE_DRIVE_10        BIT10
 set     GPIOC_DRIVE_DRIVE_11        BIT11
 set     GPIOC_DRIVE_DRIVE_12        BIT12
 set     GPIOC_DRIVE_DRIVE_13        BIT13
 set     GPIOC_DRIVE_DRIVE_14        BIT14
 set     GPIOC_DRIVE_DRIVE_15        BIT15

 set     GPIOC_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0 ==> Pulldown resistor
;;     0b1 ==> Pullup resistor
 set     GPIOC_PUS_PUS_0             BIT0
 set     GPIOC_PUS_PUS_1             BIT1
 set     GPIOC_PUS_PUS_2             BIT2
 set     GPIOC_PUS_PUS_3             BIT3
 set     GPIOC_PUS_PUS_4             BIT4
 set     GPIOC_PUS_PUS_5             BIT5
 set     GPIOC_PUS_PUS_6             BIT6
 set     GPIOC_PUS_PUS_7             BIT7
 set     GPIOC_PUS_PUS_8             BIT8
 set     GPIOC_PUS_PUS_9             BIT9
 set     GPIOC_PUS_PUS_10            BIT10
 set     GPIOC_PUS_PUS_11            BIT11
 set     GPIOC_PUS_PUS_12            BIT12
 set     GPIOC_PUS_PUS_13            BIT13
 set     GPIOC_PUS_PUS_14            BIT14
 set     GPIOC_PUS_PUS_15            BIT15

 set     GPIOC_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOC_SRE_SRE_0             BIT0
 set     GPIOC_SRE_SRE_1             BIT1
 set     GPIOC_SRE_SRE_2             BIT2
 set     GPIOC_SRE_SRE_3             BIT3
 set     GPIOC_SRE_SRE_4             BIT4
 set     GPIOC_SRE_SRE_5             BIT5
 set     GPIOC_SRE_SRE_6             BIT6
 set     GPIOC_SRE_SRE_7             BIT7
 set     GPIOC_SRE_SRE_8             BIT8
 set     GPIOC_SRE_SRE_9             BIT9
 set     GPIOC_SRE_SRE_10            BIT10
 set     GPIOC_SRE_SRE_11            BIT11
 set     GPIOC_SRE_SRE_12            BIT12
 set     GPIOC_SRE_SRE_13            BIT13
 set     GPIOC_SRE_SRE_14            BIT14
 set     GPIOC_SRE_SRE_15            BIT15

 set     GPIOD_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0 ==> Pull resistor is disabled
;;     0b1 ==> Pull resistor is enabled
 set     GPIOD_PUR_PU_0              BIT0
 set     GPIOD_PUR_PU_1              BIT1
 set     GPIOD_PUR_PU_2              BIT2
 set     GPIOD_PUR_PU_3              BIT3
 set     GPIOD_PUR_PU_4              BIT4
 set     GPIOD_PUR_PU_5              BIT5
 set     GPIOD_PUR_PU_6              BIT6
 set     GPIOD_PUR_PU_7              BIT7
 set     GPIOD_PUR_PU_8              BIT8
 set     GPIOD_PUR_PU_9              BIT9
 set     GPIOD_PUR_PU_10             BIT10
 set     GPIOD_PUR_PU_11             BIT11
 set     GPIOD_PUR_PU_12             BIT12
 set     GPIOD_PUR_PU_13             BIT13
 set     GPIOD_PUR_PU_14             BIT14
 set     GPIOD_PUR_PU_15             BIT15

 set     GPIOD_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOD_DR_D_0                BIT0
 set     GPIOD_DR_D_1                BIT1
 set     GPIOD_DR_D_2                BIT2
 set     GPIOD_DR_D_3                BIT3
 set     GPIOD_DR_D_4                BIT4
 set     GPIOD_DR_D_5                BIT5
 set     GPIOD_DR_D_6                BIT6
 set     GPIOD_DR_D_7                BIT7
 set     GPIOD_DR_D_8                BIT8
 set     GPIOD_DR_D_9                BIT9
 set     GPIOD_DR_D_10               BIT10
 set     GPIOD_DR_D_11               BIT11
 set     GPIOD_DR_D_12               BIT12
 set     GPIOD_DR_D_13               BIT13
 set     GPIOD_DR_D_14               BIT14
 set     GPIOD_DR_D_15               BIT15

 set     GPIOD_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0 ==> Pin is an input
;;     0b1 ==> Pin is an output
 set     GPIOD_DDR_DD_0              BIT0
 set     GPIOD_DDR_DD_1              BIT1
 set     GPIOD_DDR_DD_2              BIT2
 set     GPIOD_DDR_DD_3              BIT3
 set     GPIOD_DDR_DD_4              BIT4
 set     GPIOD_DDR_DD_5              BIT5
 set     GPIOD_DDR_DD_6              BIT6
 set     GPIOD_DDR_DD_7              BIT7
 set     GPIOD_DDR_DD_8              BIT8
 set     GPIOD_DDR_DD_9              BIT9
 set     GPIOD_DDR_DD_10             BIT10
 set     GPIOD_DDR_DD_11             BIT11
 set     GPIOD_DDR_DD_12             BIT12
 set     GPIOD_DDR_DD_13             BIT13
 set     GPIOD_DDR_DD_14             BIT14
 set     GPIOD_DDR_DD_15             BIT15

 set     GPIOD_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0 ==> Pin is for GPIO (GPIO mode)
;;     0b1 ==> Pin is for peripheral (peripheral mode)
 set     GPIOD_PER_PE_0              BIT0
 set     GPIOD_PER_PE_1              BIT1
 set     GPIOD_PER_PE_2              BIT2
 set     GPIOD_PER_PE_3              BIT3
 set     GPIOD_PER_PE_4              BIT4
 set     GPIOD_PER_PE_5              BIT5
 set     GPIOD_PER_PE_6              BIT6
 set     GPIOD_PER_PE_7              BIT7
 set     GPIOD_PER_PE_8              BIT8
 set     GPIOD_PER_PE_9              BIT9
 set     GPIOD_PER_PE_10             BIT10
 set     GPIOD_PER_PE_11             BIT11
 set     GPIOD_PER_PE_12             BIT12
 set     GPIOD_PER_PE_13             BIT13
 set     GPIOD_PER_PE_14             BIT14
 set     GPIOD_PER_PE_15             BIT15

 set     GPIOD_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0 ==> Deassert software interrupt
;;     0b1 ==> Assert software interrupt
 set     GPIOD_IAR_IA_0              BIT0
 set     GPIOD_IAR_IA_1              BIT1
 set     GPIOD_IAR_IA_2              BIT2
 set     GPIOD_IAR_IA_3              BIT3
 set     GPIOD_IAR_IA_4              BIT4
 set     GPIOD_IAR_IA_5              BIT5
 set     GPIOD_IAR_IA_6              BIT6
 set     GPIOD_IAR_IA_7              BIT7
 set     GPIOD_IAR_IA_8              BIT8
 set     GPIOD_IAR_IA_9              BIT9
 set     GPIOD_IAR_IA_10             BIT10
 set     GPIOD_IAR_IA_11             BIT11
 set     GPIOD_IAR_IA_12             BIT12
 set     GPIOD_IAR_IA_13             BIT13
 set     GPIOD_IAR_IA_14             BIT14
 set     GPIOD_IAR_IA_15             BIT15

 set     GPIOD_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0 ==> External Interrupt is disabled
;;     0b1 ==> External Interrupt is enabled
 set     GPIOD_IENR_IEN_0            BIT0
 set     GPIOD_IENR_IEN_1            BIT1
 set     GPIOD_IENR_IEN_2            BIT2
 set     GPIOD_IENR_IEN_3            BIT3
 set     GPIOD_IENR_IEN_4            BIT4
 set     GPIOD_IENR_IEN_5            BIT5
 set     GPIOD_IENR_IEN_6            BIT6
 set     GPIOD_IENR_IEN_7            BIT7
 set     GPIOD_IENR_IEN_8            BIT8
 set     GPIOD_IENR_IEN_9            BIT9
 set     GPIOD_IENR_IEN_10           BIT10
 set     GPIOD_IENR_IEN_11           BIT11
 set     GPIOD_IENR_IEN_12           BIT12
 set     GPIOD_IENR_IEN_13           BIT13
 set     GPIOD_IENR_IEN_14           BIT14
 set     GPIOD_IENR_IEN_15           BIT15

 set     GPIOD_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0 ==> Interrupt occurred on rising edge
;;     0b1 ==> Interrupt occurred on falling edge
 set     GPIOD_IPOLR_IPOL_0          BIT0
 set     GPIOD_IPOLR_IPOL_1          BIT1
 set     GPIOD_IPOLR_IPOL_2          BIT2
 set     GPIOD_IPOLR_IPOL_3          BIT3
 set     GPIOD_IPOLR_IPOL_4          BIT4
 set     GPIOD_IPOLR_IPOL_5          BIT5
 set     GPIOD_IPOLR_IPOL_6          BIT6
 set     GPIOD_IPOLR_IPOL_7          BIT7
 set     GPIOD_IPOLR_IPOL_8          BIT8
 set     GPIOD_IPOLR_IPOL_9          BIT9
 set     GPIOD_IPOLR_IPOL_10         BIT10
 set     GPIOD_IPOLR_IPOL_11         BIT11
 set     GPIOD_IPOLR_IPOL_12         BIT12
 set     GPIOD_IPOLR_IPOL_13         BIT13
 set     GPIOD_IPOLR_IPOL_14         BIT14
 set     GPIOD_IPOLR_IPOL_15         BIT15

 set     GPIOD_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0 ==> No Interrupt
;;     0b1 ==> Interrupt occurred
 set     GPIOD_IPR_IP_0              BIT0
 set     GPIOD_IPR_IP_1              BIT1
 set     GPIOD_IPR_IP_2              BIT2
 set     GPIOD_IPR_IP_3              BIT3
 set     GPIOD_IPR_IP_4              BIT4
 set     GPIOD_IPR_IP_5              BIT5
 set     GPIOD_IPR_IP_6              BIT6
 set     GPIOD_IPR_IP_7              BIT7
 set     GPIOD_IPR_IP_8              BIT8
 set     GPIOD_IPR_IP_9              BIT9
 set     GPIOD_IPR_IP_10             BIT10
 set     GPIOD_IPR_IP_11             BIT11
 set     GPIOD_IPR_IP_12             BIT12
 set     GPIOD_IPR_IP_13             BIT13
 set     GPIOD_IPR_IP_14             BIT14
 set     GPIOD_IPR_IP_15             BIT15

 set     GPIOD_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0 ==> No edge detected if read; no effect if writing
;;     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOD_IESR_IES_0            BIT0
 set     GPIOD_IESR_IES_1            BIT1
 set     GPIOD_IESR_IES_2            BIT2
 set     GPIOD_IESR_IES_3            BIT3
 set     GPIOD_IESR_IES_4            BIT4
 set     GPIOD_IESR_IES_5            BIT5
 set     GPIOD_IESR_IES_6            BIT6
 set     GPIOD_IESR_IES_7            BIT7
 set     GPIOD_IESR_IES_8            BIT8
 set     GPIOD_IESR_IES_9            BIT9
 set     GPIOD_IESR_IES_10           BIT10
 set     GPIOD_IESR_IES_11           BIT11
 set     GPIOD_IESR_IES_12           BIT12
 set     GPIOD_IESR_IES_13           BIT13
 set     GPIOD_IESR_IES_14           BIT14
 set     GPIOD_IESR_IES_15           BIT15

 set     GPIOD_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0 ==> Open Drain Mode
;;     0b1 ==> Push-Pull Mode
 set     GPIOD_PPMODE_PPMODE_0       BIT0
 set     GPIOD_PPMODE_PPMODE_1       BIT1
 set     GPIOD_PPMODE_PPMODE_2       BIT2
 set     GPIOD_PPMODE_PPMODE_3       BIT3
 set     GPIOD_PPMODE_PPMODE_4       BIT4
 set     GPIOD_PPMODE_PPMODE_5       BIT5
 set     GPIOD_PPMODE_PPMODE_6       BIT6
 set     GPIOD_PPMODE_PPMODE_7       BIT7
 set     GPIOD_PPMODE_PPMODE_8       BIT8
 set     GPIOD_PPMODE_PPMODE_9       BIT9
 set     GPIOD_PPMODE_PPMODE_10      BIT10
 set     GPIOD_PPMODE_PPMODE_11      BIT11
 set     GPIOD_PPMODE_PPMODE_12      BIT12
 set     GPIOD_PPMODE_PPMODE_13      BIT13
 set     GPIOD_PPMODE_PPMODE_14      BIT14
 set     GPIOD_PPMODE_PPMODE_15      BIT15

 set     GPIOD_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOD_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOD_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOD_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOD_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOD_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOD_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOD_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOD_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOD_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOD_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOD_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOD_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOD_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOD_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOD_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOD_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOD_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0 ==> Low drive strength
;;     0b1 ==> High drive strength
 set     GPIOD_DRIVE_DRIVE_0         BIT0
 set     GPIOD_DRIVE_DRIVE_1         BIT1
 set     GPIOD_DRIVE_DRIVE_2         BIT2
 set     GPIOD_DRIVE_DRIVE_3         BIT3
 set     GPIOD_DRIVE_DRIVE_4         BIT4
 set     GPIOD_DRIVE_DRIVE_5         BIT5
 set     GPIOD_DRIVE_DRIVE_6         BIT6
 set     GPIOD_DRIVE_DRIVE_7         BIT7
 set     GPIOD_DRIVE_DRIVE_8         BIT8
 set     GPIOD_DRIVE_DRIVE_9         BIT9
 set     GPIOD_DRIVE_DRIVE_10        BIT10
 set     GPIOD_DRIVE_DRIVE_11        BIT11
 set     GPIOD_DRIVE_DRIVE_12        BIT12
 set     GPIOD_DRIVE_DRIVE_13        BIT13
 set     GPIOD_DRIVE_DRIVE_14        BIT14
 set     GPIOD_DRIVE_DRIVE_15        BIT15

 set     GPIOD_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0 ==> Pulldown resistor
;;     0b1 ==> Pullup resistor
 set     GPIOD_PUS_PUS_0             BIT0
 set     GPIOD_PUS_PUS_1             BIT1
 set     GPIOD_PUS_PUS_2             BIT2
 set     GPIOD_PUS_PUS_3             BIT3
 set     GPIOD_PUS_PUS_4             BIT4
 set     GPIOD_PUS_PUS_5             BIT5
 set     GPIOD_PUS_PUS_6             BIT6
 set     GPIOD_PUS_PUS_7             BIT7
 set     GPIOD_PUS_PUS_8             BIT8
 set     GPIOD_PUS_PUS_9             BIT9
 set     GPIOD_PUS_PUS_10            BIT10
 set     GPIOD_PUS_PUS_11            BIT11
 set     GPIOD_PUS_PUS_12            BIT12
 set     GPIOD_PUS_PUS_13            BIT13
 set     GPIOD_PUS_PUS_14            BIT14
 set     GPIOD_PUS_PUS_15            BIT15

 set     GPIOD_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOD_SRE_SRE_0             BIT0
 set     GPIOD_SRE_SRE_1             BIT1
 set     GPIOD_SRE_SRE_2             BIT2
 set     GPIOD_SRE_SRE_3             BIT3
 set     GPIOD_SRE_SRE_4             BIT4
 set     GPIOD_SRE_SRE_5             BIT5
 set     GPIOD_SRE_SRE_6             BIT6
 set     GPIOD_SRE_SRE_7             BIT7
 set     GPIOD_SRE_SRE_8             BIT8
 set     GPIOD_SRE_SRE_9             BIT9
 set     GPIOD_SRE_SRE_10            BIT10
 set     GPIOD_SRE_SRE_11            BIT11
 set     GPIOD_SRE_SRE_12            BIT12
 set     GPIOD_SRE_SRE_13            BIT13
 set     GPIOD_SRE_SRE_14            BIT14
 set     GPIOD_SRE_SRE_15            BIT15

 set     GPIOE_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0 ==> Pull resistor is disabled
;;     0b1 ==> Pull resistor is enabled
 set     GPIOE_PUR_PU_0              BIT0
 set     GPIOE_PUR_PU_1              BIT1
 set     GPIOE_PUR_PU_2              BIT2
 set     GPIOE_PUR_PU_3              BIT3
 set     GPIOE_PUR_PU_4              BIT4
 set     GPIOE_PUR_PU_5              BIT5
 set     GPIOE_PUR_PU_6              BIT6
 set     GPIOE_PUR_PU_7              BIT7
 set     GPIOE_PUR_PU_8              BIT8
 set     GPIOE_PUR_PU_9              BIT9
 set     GPIOE_PUR_PU_10             BIT10
 set     GPIOE_PUR_PU_11             BIT11
 set     GPIOE_PUR_PU_12             BIT12
 set     GPIOE_PUR_PU_13             BIT13
 set     GPIOE_PUR_PU_14             BIT14
 set     GPIOE_PUR_PU_15             BIT15

 set     GPIOE_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOE_DR_D_0                BIT0
 set     GPIOE_DR_D_1                BIT1
 set     GPIOE_DR_D_2                BIT2
 set     GPIOE_DR_D_3                BIT3
 set     GPIOE_DR_D_4                BIT4
 set     GPIOE_DR_D_5                BIT5
 set     GPIOE_DR_D_6                BIT6
 set     GPIOE_DR_D_7                BIT7
 set     GPIOE_DR_D_8                BIT8
 set     GPIOE_DR_D_9                BIT9
 set     GPIOE_DR_D_10               BIT10
 set     GPIOE_DR_D_11               BIT11
 set     GPIOE_DR_D_12               BIT12
 set     GPIOE_DR_D_13               BIT13
 set     GPIOE_DR_D_14               BIT14
 set     GPIOE_DR_D_15               BIT15

 set     GPIOE_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0 ==> Pin is an input
;;     0b1 ==> Pin is an output
 set     GPIOE_DDR_DD_0              BIT0
 set     GPIOE_DDR_DD_1              BIT1
 set     GPIOE_DDR_DD_2              BIT2
 set     GPIOE_DDR_DD_3              BIT3
 set     GPIOE_DDR_DD_4              BIT4
 set     GPIOE_DDR_DD_5              BIT5
 set     GPIOE_DDR_DD_6              BIT6
 set     GPIOE_DDR_DD_7              BIT7
 set     GPIOE_DDR_DD_8              BIT8
 set     GPIOE_DDR_DD_9              BIT9
 set     GPIOE_DDR_DD_10             BIT10
 set     GPIOE_DDR_DD_11             BIT11
 set     GPIOE_DDR_DD_12             BIT12
 set     GPIOE_DDR_DD_13             BIT13
 set     GPIOE_DDR_DD_14             BIT14
 set     GPIOE_DDR_DD_15             BIT15

 set     GPIOE_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0 ==> Pin is for GPIO (GPIO mode)
;;     0b1 ==> Pin is for peripheral (peripheral mode)
 set     GPIOE_PER_PE_0              BIT0
 set     GPIOE_PER_PE_1              BIT1
 set     GPIOE_PER_PE_2              BIT2
 set     GPIOE_PER_PE_3              BIT3
 set     GPIOE_PER_PE_4              BIT4
 set     GPIOE_PER_PE_5              BIT5
 set     GPIOE_PER_PE_6              BIT6
 set     GPIOE_PER_PE_7              BIT7
 set     GPIOE_PER_PE_8              BIT8
 set     GPIOE_PER_PE_9              BIT9
 set     GPIOE_PER_PE_10             BIT10
 set     GPIOE_PER_PE_11             BIT11
 set     GPIOE_PER_PE_12             BIT12
 set     GPIOE_PER_PE_13             BIT13
 set     GPIOE_PER_PE_14             BIT14
 set     GPIOE_PER_PE_15             BIT15

 set     GPIOE_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0 ==> Deassert software interrupt
;;     0b1 ==> Assert software interrupt
 set     GPIOE_IAR_IA_0              BIT0
 set     GPIOE_IAR_IA_1              BIT1
 set     GPIOE_IAR_IA_2              BIT2
 set     GPIOE_IAR_IA_3              BIT3
 set     GPIOE_IAR_IA_4              BIT4
 set     GPIOE_IAR_IA_5              BIT5
 set     GPIOE_IAR_IA_6              BIT6
 set     GPIOE_IAR_IA_7              BIT7
 set     GPIOE_IAR_IA_8              BIT8
 set     GPIOE_IAR_IA_9              BIT9
 set     GPIOE_IAR_IA_10             BIT10
 set     GPIOE_IAR_IA_11             BIT11
 set     GPIOE_IAR_IA_12             BIT12
 set     GPIOE_IAR_IA_13             BIT13
 set     GPIOE_IAR_IA_14             BIT14
 set     GPIOE_IAR_IA_15             BIT15

 set     GPIOE_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0 ==> External Interrupt is disabled
;;     0b1 ==> External Interrupt is enabled
 set     GPIOE_IENR_IEN_0            BIT0
 set     GPIOE_IENR_IEN_1            BIT1
 set     GPIOE_IENR_IEN_2            BIT2
 set     GPIOE_IENR_IEN_3            BIT3
 set     GPIOE_IENR_IEN_4            BIT4
 set     GPIOE_IENR_IEN_5            BIT5
 set     GPIOE_IENR_IEN_6            BIT6
 set     GPIOE_IENR_IEN_7            BIT7
 set     GPIOE_IENR_IEN_8            BIT8
 set     GPIOE_IENR_IEN_9            BIT9
 set     GPIOE_IENR_IEN_10           BIT10
 set     GPIOE_IENR_IEN_11           BIT11
 set     GPIOE_IENR_IEN_12           BIT12
 set     GPIOE_IENR_IEN_13           BIT13
 set     GPIOE_IENR_IEN_14           BIT14
 set     GPIOE_IENR_IEN_15           BIT15

 set     GPIOE_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0 ==> Interrupt occurred on rising edge
;;     0b1 ==> Interrupt occurred on falling edge
 set     GPIOE_IPOLR_IPOL_0          BIT0
 set     GPIOE_IPOLR_IPOL_1          BIT1
 set     GPIOE_IPOLR_IPOL_2          BIT2
 set     GPIOE_IPOLR_IPOL_3          BIT3
 set     GPIOE_IPOLR_IPOL_4          BIT4
 set     GPIOE_IPOLR_IPOL_5          BIT5
 set     GPIOE_IPOLR_IPOL_6          BIT6
 set     GPIOE_IPOLR_IPOL_7          BIT7
 set     GPIOE_IPOLR_IPOL_8          BIT8
 set     GPIOE_IPOLR_IPOL_9          BIT9
 set     GPIOE_IPOLR_IPOL_10         BIT10
 set     GPIOE_IPOLR_IPOL_11         BIT11
 set     GPIOE_IPOLR_IPOL_12         BIT12
 set     GPIOE_IPOLR_IPOL_13         BIT13
 set     GPIOE_IPOLR_IPOL_14         BIT14
 set     GPIOE_IPOLR_IPOL_15         BIT15

 set     GPIOE_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0 ==> No Interrupt
;;     0b1 ==> Interrupt occurred
 set     GPIOE_IPR_IP_0              BIT0
 set     GPIOE_IPR_IP_1              BIT1
 set     GPIOE_IPR_IP_2              BIT2
 set     GPIOE_IPR_IP_3              BIT3
 set     GPIOE_IPR_IP_4              BIT4
 set     GPIOE_IPR_IP_5              BIT5
 set     GPIOE_IPR_IP_6              BIT6
 set     GPIOE_IPR_IP_7              BIT7
 set     GPIOE_IPR_IP_8              BIT8
 set     GPIOE_IPR_IP_9              BIT9
 set     GPIOE_IPR_IP_10             BIT10
 set     GPIOE_IPR_IP_11             BIT11
 set     GPIOE_IPR_IP_12             BIT12
 set     GPIOE_IPR_IP_13             BIT13
 set     GPIOE_IPR_IP_14             BIT14
 set     GPIOE_IPR_IP_15             BIT15

 set     GPIOE_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0 ==> No edge detected if read; no effect if writing
;;     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOE_IESR_IES_0            BIT0
 set     GPIOE_IESR_IES_1            BIT1
 set     GPIOE_IESR_IES_2            BIT2
 set     GPIOE_IESR_IES_3            BIT3
 set     GPIOE_IESR_IES_4            BIT4
 set     GPIOE_IESR_IES_5            BIT5
 set     GPIOE_IESR_IES_6            BIT6
 set     GPIOE_IESR_IES_7            BIT7
 set     GPIOE_IESR_IES_8            BIT8
 set     GPIOE_IESR_IES_9            BIT9
 set     GPIOE_IESR_IES_10           BIT10
 set     GPIOE_IESR_IES_11           BIT11
 set     GPIOE_IESR_IES_12           BIT12
 set     GPIOE_IESR_IES_13           BIT13
 set     GPIOE_IESR_IES_14           BIT14
 set     GPIOE_IESR_IES_15           BIT15

 set     GPIOE_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0 ==> Open Drain Mode
;;     0b1 ==> Push-Pull Mode
 set     GPIOE_PPMODE_PPMODE_0       BIT0
 set     GPIOE_PPMODE_PPMODE_1       BIT1
 set     GPIOE_PPMODE_PPMODE_2       BIT2
 set     GPIOE_PPMODE_PPMODE_3       BIT3
 set     GPIOE_PPMODE_PPMODE_4       BIT4
 set     GPIOE_PPMODE_PPMODE_5       BIT5
 set     GPIOE_PPMODE_PPMODE_6       BIT6
 set     GPIOE_PPMODE_PPMODE_7       BIT7
 set     GPIOE_PPMODE_PPMODE_8       BIT8
 set     GPIOE_PPMODE_PPMODE_9       BIT9
 set     GPIOE_PPMODE_PPMODE_10      BIT10
 set     GPIOE_PPMODE_PPMODE_11      BIT11
 set     GPIOE_PPMODE_PPMODE_12      BIT12
 set     GPIOE_PPMODE_PPMODE_13      BIT13
 set     GPIOE_PPMODE_PPMODE_14      BIT14
 set     GPIOE_PPMODE_PPMODE_15      BIT15

 set     GPIOE_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOE_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOE_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOE_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOE_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOE_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOE_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOE_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOE_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOE_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOE_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOE_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOE_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOE_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOE_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOE_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOE_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOE_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0 ==> Low drive strength
;;     0b1 ==> High drive strength
 set     GPIOE_DRIVE_DRIVE_0         BIT0
 set     GPIOE_DRIVE_DRIVE_1         BIT1
 set     GPIOE_DRIVE_DRIVE_2         BIT2
 set     GPIOE_DRIVE_DRIVE_3         BIT3
 set     GPIOE_DRIVE_DRIVE_4         BIT4
 set     GPIOE_DRIVE_DRIVE_5         BIT5
 set     GPIOE_DRIVE_DRIVE_6         BIT6
 set     GPIOE_DRIVE_DRIVE_7         BIT7
 set     GPIOE_DRIVE_DRIVE_8         BIT8
 set     GPIOE_DRIVE_DRIVE_9         BIT9
 set     GPIOE_DRIVE_DRIVE_10        BIT10
 set     GPIOE_DRIVE_DRIVE_11        BIT11
 set     GPIOE_DRIVE_DRIVE_12        BIT12
 set     GPIOE_DRIVE_DRIVE_13        BIT13
 set     GPIOE_DRIVE_DRIVE_14        BIT14
 set     GPIOE_DRIVE_DRIVE_15        BIT15

 set     GPIOE_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0 ==> Pulldown resistor
;;     0b1 ==> Pullup resistor
 set     GPIOE_PUS_PUS_0             BIT0
 set     GPIOE_PUS_PUS_1             BIT1
 set     GPIOE_PUS_PUS_2             BIT2
 set     GPIOE_PUS_PUS_3             BIT3
 set     GPIOE_PUS_PUS_4             BIT4
 set     GPIOE_PUS_PUS_5             BIT5
 set     GPIOE_PUS_PUS_6             BIT6
 set     GPIOE_PUS_PUS_7             BIT7
 set     GPIOE_PUS_PUS_8             BIT8
 set     GPIOE_PUS_PUS_9             BIT9
 set     GPIOE_PUS_PUS_10            BIT10
 set     GPIOE_PUS_PUS_11            BIT11
 set     GPIOE_PUS_PUS_12            BIT12
 set     GPIOE_PUS_PUS_13            BIT13
 set     GPIOE_PUS_PUS_14            BIT14
 set     GPIOE_PUS_PUS_15            BIT15

 set     GPIOE_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOE_SRE_SRE_0             BIT0
 set     GPIOE_SRE_SRE_1             BIT1
 set     GPIOE_SRE_SRE_2             BIT2
 set     GPIOE_SRE_SRE_3             BIT3
 set     GPIOE_SRE_SRE_4             BIT4
 set     GPIOE_SRE_SRE_5             BIT5
 set     GPIOE_SRE_SRE_6             BIT6
 set     GPIOE_SRE_SRE_7             BIT7
 set     GPIOE_SRE_SRE_8             BIT8
 set     GPIOE_SRE_SRE_9             BIT9
 set     GPIOE_SRE_SRE_10            BIT10
 set     GPIOE_SRE_SRE_11            BIT11
 set     GPIOE_SRE_SRE_12            BIT12
 set     GPIOE_SRE_SRE_13            BIT13
 set     GPIOE_SRE_SRE_14            BIT14
 set     GPIOE_SRE_SRE_15            BIT15

 set     GPIOF_PUR_PU                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Enable Bits
;;     0b0 ==> Pull resistor is disabled
;;     0b1 ==> Pull resistor is enabled
 set     GPIOF_PUR_PU_0              BIT0
 set     GPIOF_PUR_PU_1              BIT1
 set     GPIOF_PUR_PU_2              BIT2
 set     GPIOF_PUR_PU_3              BIT3
 set     GPIOF_PUR_PU_4              BIT4
 set     GPIOF_PUR_PU_5              BIT5
 set     GPIOF_PUR_PU_6              BIT6
 set     GPIOF_PUR_PU_7              BIT7
 set     GPIOF_PUR_PU_8              BIT8
 set     GPIOF_PUR_PU_9              BIT9
 set     GPIOF_PUR_PU_10             BIT10
 set     GPIOF_PUR_PU_11             BIT11
 set     GPIOF_PUR_PU_12             BIT12
 set     GPIOF_PUR_PU_13             BIT13
 set     GPIOF_PUR_PU_14             BIT14
 set     GPIOF_PUR_PU_15             BIT15

 set     GPIOF_DR_D                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Bits
 set     GPIOF_DR_D_0                BIT0
 set     GPIOF_DR_D_1                BIT1
 set     GPIOF_DR_D_2                BIT2
 set     GPIOF_DR_D_3                BIT3
 set     GPIOF_DR_D_4                BIT4
 set     GPIOF_DR_D_5                BIT5
 set     GPIOF_DR_D_6                BIT6
 set     GPIOF_DR_D_7                BIT7
 set     GPIOF_DR_D_8                BIT8
 set     GPIOF_DR_D_9                BIT9
 set     GPIOF_DR_D_10               BIT10
 set     GPIOF_DR_D_11               BIT11
 set     GPIOF_DR_D_12               BIT12
 set     GPIOF_DR_D_13               BIT13
 set     GPIOF_DR_D_14               BIT14
 set     GPIOF_DR_D_15               BIT15

 set     GPIOF_DDR_DD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Data Direction Bits
;;     0b0 ==> Pin is an input
;;     0b1 ==> Pin is an output
 set     GPIOF_DDR_DD_0              BIT0
 set     GPIOF_DDR_DD_1              BIT1
 set     GPIOF_DDR_DD_2              BIT2
 set     GPIOF_DDR_DD_3              BIT3
 set     GPIOF_DDR_DD_4              BIT4
 set     GPIOF_DDR_DD_5              BIT5
 set     GPIOF_DDR_DD_6              BIT6
 set     GPIOF_DDR_DD_7              BIT7
 set     GPIOF_DDR_DD_8              BIT8
 set     GPIOF_DDR_DD_9              BIT9
 set     GPIOF_DDR_DD_10             BIT10
 set     GPIOF_DDR_DD_11             BIT11
 set     GPIOF_DDR_DD_12             BIT12
 set     GPIOF_DDR_DD_13             BIT13
 set     GPIOF_DDR_DD_14             BIT14
 set     GPIOF_DDR_DD_15             BIT15

 set     GPIOF_PER_PE                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Peripheral Enable Bits
;;     0b0 ==> Pin is for GPIO (GPIO mode)
;;     0b1 ==> Pin is for peripheral (peripheral mode)
 set     GPIOF_PER_PE_0              BIT0
 set     GPIOF_PER_PE_1              BIT1
 set     GPIOF_PER_PE_2              BIT2
 set     GPIOF_PER_PE_3              BIT3
 set     GPIOF_PER_PE_4              BIT4
 set     GPIOF_PER_PE_5              BIT5
 set     GPIOF_PER_PE_6              BIT6
 set     GPIOF_PER_PE_7              BIT7
 set     GPIOF_PER_PE_8              BIT8
 set     GPIOF_PER_PE_9              BIT9
 set     GPIOF_PER_PE_10             BIT10
 set     GPIOF_PER_PE_11             BIT11
 set     GPIOF_PER_PE_12             BIT12
 set     GPIOF_PER_PE_13             BIT13
 set     GPIOF_PER_PE_14             BIT14
 set     GPIOF_PER_PE_15             BIT15

 set     GPIOF_IAR_IA                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Assert Bits
;;     0b0 ==> Deassert software interrupt
;;     0b1 ==> Assert software interrupt
 set     GPIOF_IAR_IA_0              BIT0
 set     GPIOF_IAR_IA_1              BIT1
 set     GPIOF_IAR_IA_2              BIT2
 set     GPIOF_IAR_IA_3              BIT3
 set     GPIOF_IAR_IA_4              BIT4
 set     GPIOF_IAR_IA_5              BIT5
 set     GPIOF_IAR_IA_6              BIT6
 set     GPIOF_IAR_IA_7              BIT7
 set     GPIOF_IAR_IA_8              BIT8
 set     GPIOF_IAR_IA_9              BIT9
 set     GPIOF_IAR_IA_10             BIT10
 set     GPIOF_IAR_IA_11             BIT11
 set     GPIOF_IAR_IA_12             BIT12
 set     GPIOF_IAR_IA_13             BIT13
 set     GPIOF_IAR_IA_14             BIT14
 set     GPIOF_IAR_IA_15             BIT15

 set     GPIOF_IENR_IEN              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Enable Bits
;;     0b0 ==> External Interrupt is disabled
;;     0b1 ==> External Interrupt is enabled
 set     GPIOF_IENR_IEN_0            BIT0
 set     GPIOF_IENR_IEN_1            BIT1
 set     GPIOF_IENR_IEN_2            BIT2
 set     GPIOF_IENR_IEN_3            BIT3
 set     GPIOF_IENR_IEN_4            BIT4
 set     GPIOF_IENR_IEN_5            BIT5
 set     GPIOF_IENR_IEN_6            BIT6
 set     GPIOF_IENR_IEN_7            BIT7
 set     GPIOF_IENR_IEN_8            BIT8
 set     GPIOF_IENR_IEN_9            BIT9
 set     GPIOF_IENR_IEN_10           BIT10
 set     GPIOF_IENR_IEN_11           BIT11
 set     GPIOF_IENR_IEN_12           BIT12
 set     GPIOF_IENR_IEN_13           BIT13
 set     GPIOF_IENR_IEN_14           BIT14
 set     GPIOF_IENR_IEN_15           BIT15

 set     GPIOF_IPOLR_IPOL            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Polarity Bits
;;     0b0 ==> Interrupt occurred on rising edge
;;     0b1 ==> Interrupt occurred on falling edge
 set     GPIOF_IPOLR_IPOL_0          BIT0
 set     GPIOF_IPOLR_IPOL_1          BIT1
 set     GPIOF_IPOLR_IPOL_2          BIT2
 set     GPIOF_IPOLR_IPOL_3          BIT3
 set     GPIOF_IPOLR_IPOL_4          BIT4
 set     GPIOF_IPOLR_IPOL_5          BIT5
 set     GPIOF_IPOLR_IPOL_6          BIT6
 set     GPIOF_IPOLR_IPOL_7          BIT7
 set     GPIOF_IPOLR_IPOL_8          BIT8
 set     GPIOF_IPOLR_IPOL_9          BIT9
 set     GPIOF_IPOLR_IPOL_10         BIT10
 set     GPIOF_IPOLR_IPOL_11         BIT11
 set     GPIOF_IPOLR_IPOL_12         BIT12
 set     GPIOF_IPOLR_IPOL_13         BIT13
 set     GPIOF_IPOLR_IPOL_14         BIT14
 set     GPIOF_IPOLR_IPOL_15         BIT15

 set     GPIOF_IPR_IP                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Pending Bits
;;     0b0 ==> No Interrupt
;;     0b1 ==> Interrupt occurred
 set     GPIOF_IPR_IP_0              BIT0
 set     GPIOF_IPR_IP_1              BIT1
 set     GPIOF_IPR_IP_2              BIT2
 set     GPIOF_IPR_IP_3              BIT3
 set     GPIOF_IPR_IP_4              BIT4
 set     GPIOF_IPR_IP_5              BIT5
 set     GPIOF_IPR_IP_6              BIT6
 set     GPIOF_IPR_IP_7              BIT7
 set     GPIOF_IPR_IP_8              BIT8
 set     GPIOF_IPR_IP_9              BIT9
 set     GPIOF_IPR_IP_10             BIT10
 set     GPIOF_IPR_IP_11             BIT11
 set     GPIOF_IPR_IP_12             BIT12
 set     GPIOF_IPR_IP_13             BIT13
 set     GPIOF_IPR_IP_14             BIT14
 set     GPIOF_IPR_IP_15             BIT15

 set     GPIOF_IESR_IES              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Interrupt Edge-Sensitive Bits
;;     0b0 ==> No edge detected if read; no effect if writing
;;     0b1 ==> An edge detected if read; clear corresponding Interrupt Pending bit if writing
 set     GPIOF_IESR_IES_0            BIT0
 set     GPIOF_IESR_IES_1            BIT1
 set     GPIOF_IESR_IES_2            BIT2
 set     GPIOF_IESR_IES_3            BIT3
 set     GPIOF_IESR_IES_4            BIT4
 set     GPIOF_IESR_IES_5            BIT5
 set     GPIOF_IESR_IES_6            BIT6
 set     GPIOF_IESR_IES_7            BIT7
 set     GPIOF_IESR_IES_8            BIT8
 set     GPIOF_IESR_IES_9            BIT9
 set     GPIOF_IESR_IES_10           BIT10
 set     GPIOF_IESR_IES_11           BIT11
 set     GPIOF_IESR_IES_12           BIT12
 set     GPIOF_IESR_IES_13           BIT13
 set     GPIOF_IESR_IES_14           BIT14
 set     GPIOF_IESR_IES_15           BIT15

 set     GPIOF_PPMODE_PPMODE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Push-Pull Mode Bits
;;     0b0 ==> Open Drain Mode
;;     0b1 ==> Push-Pull Mode
 set     GPIOF_PPMODE_PPMODE_0       BIT0
 set     GPIOF_PPMODE_PPMODE_1       BIT1
 set     GPIOF_PPMODE_PPMODE_2       BIT2
 set     GPIOF_PPMODE_PPMODE_3       BIT3
 set     GPIOF_PPMODE_PPMODE_4       BIT4
 set     GPIOF_PPMODE_PPMODE_5       BIT5
 set     GPIOF_PPMODE_PPMODE_6       BIT6
 set     GPIOF_PPMODE_PPMODE_7       BIT7
 set     GPIOF_PPMODE_PPMODE_8       BIT8
 set     GPIOF_PPMODE_PPMODE_9       BIT9
 set     GPIOF_PPMODE_PPMODE_10      BIT10
 set     GPIOF_PPMODE_PPMODE_11      BIT11
 set     GPIOF_PPMODE_PPMODE_12      BIT12
 set     GPIOF_PPMODE_PPMODE_13      BIT13
 set     GPIOF_PPMODE_PPMODE_14      BIT14
 set     GPIOF_PPMODE_PPMODE_15      BIT15

 set     GPIOF_RAWDATA_RAW_DATA      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Raw Data Bits
 set     GPIOF_RAWDATA_RAW_DATA_0    BIT0
 set     GPIOF_RAWDATA_RAW_DATA_1    BIT1
 set     GPIOF_RAWDATA_RAW_DATA_2    BIT2
 set     GPIOF_RAWDATA_RAW_DATA_3    BIT3
 set     GPIOF_RAWDATA_RAW_DATA_4    BIT4
 set     GPIOF_RAWDATA_RAW_DATA_5    BIT5
 set     GPIOF_RAWDATA_RAW_DATA_6    BIT6
 set     GPIOF_RAWDATA_RAW_DATA_7    BIT7
 set     GPIOF_RAWDATA_RAW_DATA_8    BIT8
 set     GPIOF_RAWDATA_RAW_DATA_9    BIT9
 set     GPIOF_RAWDATA_RAW_DATA_10   BIT10
 set     GPIOF_RAWDATA_RAW_DATA_11   BIT11
 set     GPIOF_RAWDATA_RAW_DATA_12   BIT12
 set     GPIOF_RAWDATA_RAW_DATA_13   BIT13
 set     GPIOF_RAWDATA_RAW_DATA_14   BIT14
 set     GPIOF_RAWDATA_RAW_DATA_15   BIT15

 set     GPIOF_DRIVE_DRIVE           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Drive Strength Selector Bits
;;     0b0 ==> Low drive strength
;;     0b1 ==> High drive strength
 set     GPIOF_DRIVE_DRIVE_0         BIT0
 set     GPIOF_DRIVE_DRIVE_1         BIT1
 set     GPIOF_DRIVE_DRIVE_2         BIT2
 set     GPIOF_DRIVE_DRIVE_3         BIT3
 set     GPIOF_DRIVE_DRIVE_4         BIT4
 set     GPIOF_DRIVE_DRIVE_5         BIT5
 set     GPIOF_DRIVE_DRIVE_6         BIT6
 set     GPIOF_DRIVE_DRIVE_7         BIT7
 set     GPIOF_DRIVE_DRIVE_8         BIT8
 set     GPIOF_DRIVE_DRIVE_9         BIT9
 set     GPIOF_DRIVE_DRIVE_10        BIT10
 set     GPIOF_DRIVE_DRIVE_11        BIT11
 set     GPIOF_DRIVE_DRIVE_12        BIT12
 set     GPIOF_DRIVE_DRIVE_13        BIT13
 set     GPIOF_DRIVE_DRIVE_14        BIT14
 set     GPIOF_DRIVE_DRIVE_15        BIT15

 set     GPIOF_PUS_PUS               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pull Resistor Type Select Bits
;;     0b0 ==> Pulldown resistor
;;     0b1 ==> Pullup resistor
 set     GPIOF_PUS_PUS_0             BIT0
 set     GPIOF_PUS_PUS_1             BIT1
 set     GPIOF_PUS_PUS_2             BIT2
 set     GPIOF_PUS_PUS_3             BIT3
 set     GPIOF_PUS_PUS_4             BIT4
 set     GPIOF_PUS_PUS_5             BIT5
 set     GPIOF_PUS_PUS_6             BIT6
 set     GPIOF_PUS_PUS_7             BIT7
 set     GPIOF_PUS_PUS_8             BIT8
 set     GPIOF_PUS_PUS_9             BIT9
 set     GPIOF_PUS_PUS_10            BIT10
 set     GPIOF_PUS_PUS_11            BIT11
 set     GPIOF_PUS_PUS_12            BIT12
 set     GPIOF_PUS_PUS_13            BIT13
 set     GPIOF_PUS_PUS_14            BIT14
 set     GPIOF_PUS_PUS_15            BIT15

 set     GPIOF_SRE_SRE               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Slew Rate Enable
;;     0b0 ==> Slew rate is enabled (the turn-on time of the output transistor is faster)
;;     0b1 ==> Slew rate is disabled (the turn-on time of the output transistor is slower)
 set     GPIOF_SRE_SRE_0             BIT0
 set     GPIOF_SRE_SRE_1             BIT1
 set     GPIOF_SRE_SRE_2             BIT2
 set     GPIOF_SRE_SRE_3             BIT3
 set     GPIOF_SRE_SRE_4             BIT4
 set     GPIOF_SRE_SRE_5             BIT5
 set     GPIOF_SRE_SRE_6             BIT6
 set     GPIOF_SRE_SRE_7             BIT7
 set     GPIOF_SRE_SRE_8             BIT8
 set     GPIOF_SRE_SRE_9             BIT9
 set     GPIOF_SRE_SRE_10            BIT10
 set     GPIOF_SRE_SRE_11            BIT11
 set     GPIOF_SRE_SRE_12            BIT12
 set     GPIOF_SRE_SRE_13            BIT13
 set     GPIOF_SRE_SRE_14            BIT14
 set     GPIOF_SRE_SRE_15            BIT15

 set     I2C0_A1_AD                  (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Address
 set     I2C0_A1_AD_0                BIT1
 set     I2C0_A1_AD_1                BIT2
 set     I2C0_A1_AD_2                BIT3
 set     I2C0_A1_AD_3                BIT4
 set     I2C0_A1_AD_4                BIT5
 set     I2C0_A1_AD_5                BIT6
 set     I2C0_A1_AD_6                BIT7

 set     I2C0_F_ICR                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   ClockRate
 set     I2C0_F_ICR_0                BIT0
 set     I2C0_F_ICR_1                BIT1
 set     I2C0_F_ICR_2                BIT2
 set     I2C0_F_ICR_3                BIT3
 set     I2C0_F_ICR_4                BIT4
 set     I2C0_F_ICR_5                BIT5

 set     I2C0_F_MULT                 (BIT6|BIT7)
;;     0b00 ==> mul = 1
;;     0b01 ==> mul = 2
;;     0b10 ==> mul = 4
;;     0b11 ==> Reserved
 set     I2C0_F_MULT_0               BIT6
 set     I2C0_F_MULT_1               BIT7

 set     I2C0_C1_DMAEN               BIT0
;;   DMA Enable
;;     0b0 ==> All DMA signalling disabled.
;;     0b1 ==> DMA transfer is enabled and the following conditions trigger the DMA request: While FACK = 0, a data byte is received, either address or data is transmitted. (ACK/NACK automatic) While FACK = 0, the first byte received matches the A1 register or is general call address. If any address matching occurs, IAAS and TCF are set. If the direction of transfer is known from master to slave, then it is not required to check the SRW. With this assumption, DMA can also be used in this
;;             case. In other cases, if the master reads data from the slave, then it is required to rewrite the C1 register operation. With this assumption, DMA cannot be used. When FACK = 1, an address or a data byte is transmitted.

 set     I2C0_C1_WUEN                BIT1
;;   Wakeup Enable
;;     0b0 ==> Normal operation. No interrupt generated when address matching in low power mode.
;;     0b1 ==> Enables the wakeup function in low power mode.

 set     I2C0_C1_RSTA                BIT2
;;   Repeat START

 set     I2C0_C1_TXAK                BIT3
;;   Transmit Acknowledge Enable
;;     0b0 ==> An acknowledge signal is sent to the bus on the following receiving byte (if FACK is cleared) or the current receiving byte (if FACK is set).
;;     0b1 ==> No acknowledge signal is sent to the bus on the following receiving data byte (if FACK is cleared) or the current receiving data byte (if FACK is set).

 set     I2C0_C1_TX                  BIT4
;;   Transmit Mode Select
;;     0b0 ==> Receive
;;     0b1 ==> Transmit

 set     I2C0_C1_MST                 BIT5
;;   Master Mode Select
;;     0b0 ==> Slave mode
;;     0b1 ==> Master mode

 set     I2C0_C1_IICIE               BIT6
;;   I2C Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     I2C0_C1_IICEN               BIT7
;;   I2C Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     I2C0_S_RXAK                 BIT0
;;   Receive Acknowledge
;;     0b0 ==> Acknowledge signal was received after the completion of one byte of data transmission on the bus
;;     0b1 ==> No acknowledge signal detected

 set     I2C0_S_IICIF                BIT1
;;   Interrupt Flag
;;     0b0 ==> No interrupt pending
;;     0b1 ==> Interrupt pending

 set     I2C0_S_SRW                  BIT2
;;   Slave Read/Write
;;     0b0 ==> Slave receive, master writing to slave
;;     0b1 ==> Slave transmit, master reading from slave

 set     I2C0_S_RAM                  BIT3
;;   Range Address Match
;;     0b0 ==> Not addressed
;;     0b1 ==> Addressed as a slave

 set     I2C0_S_ARBL                 BIT4
;;   Arbitration Lost
;;     0b0 ==> Standard bus operation.
;;     0b1 ==> Loss of arbitration.

 set     I2C0_S_BUSY                 BIT5
;;   Bus Busy
;;     0b0 ==> Bus is idle
;;     0b1 ==> Bus is busy

 set     I2C0_S_IAAS                 BIT6
;;   Addressed As A Slave
;;     0b0 ==> Not addressed
;;     0b1 ==> Addressed as a slave

 set     I2C0_S_TCF                  BIT7
;;   Transfer Complete Flag
;;     0b0 ==> Transfer in progress
;;     0b1 ==> Transfer complete

 set     I2C0_D_DATA                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data
 set     I2C0_D_DATA_0               BIT0
 set     I2C0_D_DATA_1               BIT1
 set     I2C0_D_DATA_2               BIT2
 set     I2C0_D_DATA_3               BIT3
 set     I2C0_D_DATA_4               BIT4
 set     I2C0_D_DATA_5               BIT5
 set     I2C0_D_DATA_6               BIT6
 set     I2C0_D_DATA_7               BIT7

 set     I2C0_C2_AD                  (BIT0|BIT1|BIT2)
;;   Slave Address
 set     I2C0_C2_AD_0                BIT0
 set     I2C0_C2_AD_1                BIT1
 set     I2C0_C2_AD_2                BIT2

 set     I2C0_C2_RMEN                BIT3
;;   Range Address Matching Enable
;;     0b0 ==> Range mode disabled. No address match occurs for an address within the range of values of the A1 and RA registers.
;;     0b1 ==> Range mode enabled. Address matching occurs when a slave receives an address within the range of values of the A1 and RA registers.

 set     I2C0_C2_SBRC                BIT4
;;   Slave Baud Rate Control
;;     0b0 ==> The slave baud rate follows the master baud rate and clock stretching may occur
;;     0b1 ==> Slave baud rate is independent of the master baud rate

 set     I2C0_C2_HDRS                BIT5
;;   High Drive Select
;;     0b0 ==> Normal drive mode
;;     0b1 ==> High drive mode

 set     I2C0_C2_ADEXT               BIT6
;;   Address Extension
;;     0b0 ==> 7-bit address scheme
;;     0b1 ==> 10-bit address scheme

 set     I2C0_C2_GCAEN               BIT7
;;   General Call Address Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     I2C0_FLT_FLT                (BIT0|BIT1|BIT2)
;;   I2C Programmable Filter Factor
;;     0b0 ==> No filter/bypass
 set     I2C0_FLT_FLT_0              BIT0
 set     I2C0_FLT_FLT_1              BIT1
 set     I2C0_FLT_FLT_2              BIT2

 set     I2C0_FLT_STARTF             BIT4
;;   I2C Bus Start Detect Flag
;;     0b0 ==> No start happens on I2C bus
;;     0b1 ==> Start detected on I2C bus

 set     I2C0_FLT_SSIE               BIT5
;;   I2C Bus Stop or Start Interrupt Enable
;;     0b0 ==> Stop or start detection interrupt is disabled
;;     0b1 ==> Stop or start detection interrupt is enabled

 set     I2C0_FLT_STOPF              BIT6
;;   I2C Bus Stop Detect Flag
;;     0b0 ==> No stop happens on I2C bus
;;     0b1 ==> Stop detected on I2C bus

 set     I2C0_FLT_SHEN               BIT7
;;   Stop Hold Enable
;;     0b0 ==> Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
;;     0b1 ==> Stop holdoff is enabled.

 set     I2C0_RA_RAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Range Slave Address
 set     I2C0_RA_RAD_0               BIT1
 set     I2C0_RA_RAD_1               BIT2
 set     I2C0_RA_RAD_2               BIT3
 set     I2C0_RA_RAD_3               BIT4
 set     I2C0_RA_RAD_4               BIT5
 set     I2C0_RA_RAD_5               BIT6
 set     I2C0_RA_RAD_6               BIT7

 set     I2C0_SMB_SHTF2IE            BIT0
;;   SHTF2 Interrupt Enable
;;     0b0 ==> SHTF2 interrupt is disabled
;;     0b1 ==> SHTF2 interrupt is enabled

 set     I2C0_SMB_SHTF2              BIT1
;;   SCL High Timeout Flag 2
;;     0b0 ==> No SCL high and SDA low timeout occurs
;;     0b1 ==> SCL high and SDA low timeout occurs

 set     I2C0_SMB_SHTF1              BIT2
;;   SCL High Timeout Flag 1
;;     0b0 ==> No SCL high and SDA high timeout occurs
;;     0b1 ==> SCL high and SDA high timeout occurs

 set     I2C0_SMB_SLTF               BIT3
;;   SCL Low Timeout Flag
;;     0b0 ==> No low timeout occurs
;;     0b1 ==> Low timeout occurs

 set     I2C0_SMB_TCKSEL             BIT4
;;   Timeout Counter Clock Select
;;     0b0 ==> Timeout counter counts at the frequency of the bus clock / 64
;;     0b1 ==> Timeout counter counts at the frequency of the bus clock

 set     I2C0_SMB_SIICAEN            BIT5
;;   Second I2C Address Enable
;;     0b0 ==> I2C address register 2 matching is disabled
;;     0b1 ==> I2C address register 2 matching is enabled

 set     I2C0_SMB_ALERTEN            BIT6
;;   SMBus Alert Response Address Enable
;;     0b0 ==> SMBus alert response address matching is disabled
;;     0b1 ==> SMBus alert response address matching is enabled

 set     I2C0_SMB_FACK               BIT7
;;   Fast NACK/ACK Enable
;;     0b0 ==> An ACK or NACK is sent on the following receiving data byte
;;     0b1 ==> Writing 0 to TXAK after receiving a data byte generates an ACK. Writing 1 to TXAK after receiving a data byte generates a NACK.

 set     I2C0_A2_SAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   SMBus Address
 set     I2C0_A2_SAD_0               BIT1
 set     I2C0_A2_SAD_1               BIT2
 set     I2C0_A2_SAD_2               BIT3
 set     I2C0_A2_SAD_3               BIT4
 set     I2C0_A2_SAD_4               BIT5
 set     I2C0_A2_SAD_5               BIT6
 set     I2C0_A2_SAD_6               BIT7

 set     I2C0_SLTH_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     I2C0_SLTH_SSLT_0            BIT0
 set     I2C0_SLTH_SSLT_1            BIT1
 set     I2C0_SLTH_SSLT_2            BIT2
 set     I2C0_SLTH_SSLT_3            BIT3
 set     I2C0_SLTH_SSLT_4            BIT4
 set     I2C0_SLTH_SSLT_5            BIT5
 set     I2C0_SLTH_SSLT_6            BIT6
 set     I2C0_SLTH_SSLT_7            BIT7

 set     I2C0_SLTL_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     I2C0_SLTL_SSLT_0            BIT0
 set     I2C0_SLTL_SSLT_1            BIT1
 set     I2C0_SLTL_SSLT_2            BIT2
 set     I2C0_SLTL_SSLT_3            BIT3
 set     I2C0_SLTL_SSLT_4            BIT4
 set     I2C0_SLTL_SSLT_5            BIT5
 set     I2C0_SLTL_SSLT_6            BIT6
 set     I2C0_SLTL_SSLT_7            BIT7

 set     I2C1_A1_AD                  (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Address
 set     I2C1_A1_AD_0                BIT1
 set     I2C1_A1_AD_1                BIT2
 set     I2C1_A1_AD_2                BIT3
 set     I2C1_A1_AD_3                BIT4
 set     I2C1_A1_AD_4                BIT5
 set     I2C1_A1_AD_5                BIT6
 set     I2C1_A1_AD_6                BIT7

 set     I2C1_F_ICR                  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   ClockRate
 set     I2C1_F_ICR_0                BIT0
 set     I2C1_F_ICR_1                BIT1
 set     I2C1_F_ICR_2                BIT2
 set     I2C1_F_ICR_3                BIT3
 set     I2C1_F_ICR_4                BIT4
 set     I2C1_F_ICR_5                BIT5

 set     I2C1_F_MULT                 (BIT6|BIT7)
;;     0b00 ==> mul = 1
;;     0b01 ==> mul = 2
;;     0b10 ==> mul = 4
;;     0b11 ==> Reserved
 set     I2C1_F_MULT_0               BIT6
 set     I2C1_F_MULT_1               BIT7

 set     I2C1_C1_DMAEN               BIT0
;;   DMA Enable
;;     0b0 ==> All DMA signalling disabled.
;;     0b1 ==> DMA transfer is enabled and the following conditions trigger the DMA request: While FACK = 0, a data byte is received, either address or data is transmitted. (ACK/NACK automatic) While FACK = 0, the first byte received matches the A1 register or is general call address. If any address matching occurs, IAAS and TCF are set. If the direction of transfer is known from master to slave, then it is not required to check the SRW. With this assumption, DMA can also be used in this
;;             case. In other cases, if the master reads data from the slave, then it is required to rewrite the C1 register operation. With this assumption, DMA cannot be used. When FACK = 1, an address or a data byte is transmitted.

 set     I2C1_C1_WUEN                BIT1
;;   Wakeup Enable
;;     0b0 ==> Normal operation. No interrupt generated when address matching in low power mode.
;;     0b1 ==> Enables the wakeup function in low power mode.

 set     I2C1_C1_RSTA                BIT2
;;   Repeat START

 set     I2C1_C1_TXAK                BIT3
;;   Transmit Acknowledge Enable
;;     0b0 ==> An acknowledge signal is sent to the bus on the following receiving byte (if FACK is cleared) or the current receiving byte (if FACK is set).
;;     0b1 ==> No acknowledge signal is sent to the bus on the following receiving data byte (if FACK is cleared) or the current receiving data byte (if FACK is set).

 set     I2C1_C1_TX                  BIT4
;;   Transmit Mode Select
;;     0b0 ==> Receive
;;     0b1 ==> Transmit

 set     I2C1_C1_MST                 BIT5
;;   Master Mode Select
;;     0b0 ==> Slave mode
;;     0b1 ==> Master mode

 set     I2C1_C1_IICIE               BIT6
;;   I2C Interrupt Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     I2C1_C1_IICEN               BIT7
;;   I2C Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     I2C1_S_RXAK                 BIT0
;;   Receive Acknowledge
;;     0b0 ==> Acknowledge signal was received after the completion of one byte of data transmission on the bus
;;     0b1 ==> No acknowledge signal detected

 set     I2C1_S_IICIF                BIT1
;;   Interrupt Flag
;;     0b0 ==> No interrupt pending
;;     0b1 ==> Interrupt pending

 set     I2C1_S_SRW                  BIT2
;;   Slave Read/Write
;;     0b0 ==> Slave receive, master writing to slave
;;     0b1 ==> Slave transmit, master reading from slave

 set     I2C1_S_RAM                  BIT3
;;   Range Address Match
;;     0b0 ==> Not addressed
;;     0b1 ==> Addressed as a slave

 set     I2C1_S_ARBL                 BIT4
;;   Arbitration Lost
;;     0b0 ==> Standard bus operation.
;;     0b1 ==> Loss of arbitration.

 set     I2C1_S_BUSY                 BIT5
;;   Bus Busy
;;     0b0 ==> Bus is idle
;;     0b1 ==> Bus is busy

 set     I2C1_S_IAAS                 BIT6
;;   Addressed As A Slave
;;     0b0 ==> Not addressed
;;     0b1 ==> Addressed as a slave

 set     I2C1_S_TCF                  BIT7
;;   Transfer Complete Flag
;;     0b0 ==> Transfer in progress
;;     0b1 ==> Transfer complete

 set     I2C1_D_DATA                 (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Data
 set     I2C1_D_DATA_0               BIT0
 set     I2C1_D_DATA_1               BIT1
 set     I2C1_D_DATA_2               BIT2
 set     I2C1_D_DATA_3               BIT3
 set     I2C1_D_DATA_4               BIT4
 set     I2C1_D_DATA_5               BIT5
 set     I2C1_D_DATA_6               BIT6
 set     I2C1_D_DATA_7               BIT7

 set     I2C1_C2_AD                  (BIT0|BIT1|BIT2)
;;   Slave Address
 set     I2C1_C2_AD_0                BIT0
 set     I2C1_C2_AD_1                BIT1
 set     I2C1_C2_AD_2                BIT2

 set     I2C1_C2_RMEN                BIT3
;;   Range Address Matching Enable
;;     0b0 ==> Range mode disabled. No address match occurs for an address within the range of values of the A1 and RA registers.
;;     0b1 ==> Range mode enabled. Address matching occurs when a slave receives an address within the range of values of the A1 and RA registers.

 set     I2C1_C2_SBRC                BIT4
;;   Slave Baud Rate Control
;;     0b0 ==> The slave baud rate follows the master baud rate and clock stretching may occur
;;     0b1 ==> Slave baud rate is independent of the master baud rate

 set     I2C1_C2_HDRS                BIT5
;;   High Drive Select
;;     0b0 ==> Normal drive mode
;;     0b1 ==> High drive mode

 set     I2C1_C2_ADEXT               BIT6
;;   Address Extension
;;     0b0 ==> 7-bit address scheme
;;     0b1 ==> 10-bit address scheme

 set     I2C1_C2_GCAEN               BIT7
;;   General Call Address Enable
;;     0b0 ==> Disabled
;;     0b1 ==> Enabled

 set     I2C1_FLT_FLT                (BIT0|BIT1|BIT2)
;;   I2C Programmable Filter Factor
;;     0b0 ==> No filter/bypass
 set     I2C1_FLT_FLT_0              BIT0
 set     I2C1_FLT_FLT_1              BIT1
 set     I2C1_FLT_FLT_2              BIT2

 set     I2C1_FLT_STARTF             BIT4
;;   I2C Bus Start Detect Flag
;;     0b0 ==> No start happens on I2C bus
;;     0b1 ==> Start detected on I2C bus

 set     I2C1_FLT_SSIE               BIT5
;;   I2C Bus Stop or Start Interrupt Enable
;;     0b0 ==> Stop or start detection interrupt is disabled
;;     0b1 ==> Stop or start detection interrupt is enabled

 set     I2C1_FLT_STOPF              BIT6
;;   I2C Bus Stop Detect Flag
;;     0b0 ==> No stop happens on I2C bus
;;     0b1 ==> Stop detected on I2C bus

 set     I2C1_FLT_SHEN               BIT7
;;   Stop Hold Enable
;;     0b0 ==> Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
;;     0b1 ==> Stop holdoff is enabled.

 set     I2C1_RA_RAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Range Slave Address
 set     I2C1_RA_RAD_0               BIT1
 set     I2C1_RA_RAD_1               BIT2
 set     I2C1_RA_RAD_2               BIT3
 set     I2C1_RA_RAD_3               BIT4
 set     I2C1_RA_RAD_4               BIT5
 set     I2C1_RA_RAD_5               BIT6
 set     I2C1_RA_RAD_6               BIT7

 set     I2C1_SMB_SHTF2IE            BIT0
;;   SHTF2 Interrupt Enable
;;     0b0 ==> SHTF2 interrupt is disabled
;;     0b1 ==> SHTF2 interrupt is enabled

 set     I2C1_SMB_SHTF2              BIT1
;;   SCL High Timeout Flag 2
;;     0b0 ==> No SCL high and SDA low timeout occurs
;;     0b1 ==> SCL high and SDA low timeout occurs

 set     I2C1_SMB_SHTF1              BIT2
;;   SCL High Timeout Flag 1
;;     0b0 ==> No SCL high and SDA high timeout occurs
;;     0b1 ==> SCL high and SDA high timeout occurs

 set     I2C1_SMB_SLTF               BIT3
;;   SCL Low Timeout Flag
;;     0b0 ==> No low timeout occurs
;;     0b1 ==> Low timeout occurs

 set     I2C1_SMB_TCKSEL             BIT4
;;   Timeout Counter Clock Select
;;     0b0 ==> Timeout counter counts at the frequency of the bus clock / 64
;;     0b1 ==> Timeout counter counts at the frequency of the bus clock

 set     I2C1_SMB_SIICAEN            BIT5
;;   Second I2C Address Enable
;;     0b0 ==> I2C address register 2 matching is disabled
;;     0b1 ==> I2C address register 2 matching is enabled

 set     I2C1_SMB_ALERTEN            BIT6
;;   SMBus Alert Response Address Enable
;;     0b0 ==> SMBus alert response address matching is disabled
;;     0b1 ==> SMBus alert response address matching is enabled

 set     I2C1_SMB_FACK               BIT7
;;   Fast NACK/ACK Enable
;;     0b0 ==> An ACK or NACK is sent on the following receiving data byte
;;     0b1 ==> Writing 0 to TXAK after receiving a data byte generates an ACK. Writing 1 to TXAK after receiving a data byte generates a NACK.

 set     I2C1_A2_SAD                 (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   SMBus Address
 set     I2C1_A2_SAD_0               BIT1
 set     I2C1_A2_SAD_1               BIT2
 set     I2C1_A2_SAD_2               BIT3
 set     I2C1_A2_SAD_3               BIT4
 set     I2C1_A2_SAD_4               BIT5
 set     I2C1_A2_SAD_5               BIT6
 set     I2C1_A2_SAD_6               BIT7

 set     I2C1_SLTH_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     I2C1_SLTH_SSLT_0            BIT0
 set     I2C1_SLTH_SSLT_1            BIT1
 set     I2C1_SLTH_SSLT_2            BIT2
 set     I2C1_SLTH_SSLT_3            BIT3
 set     I2C1_SLTH_SSLT_4            BIT4
 set     I2C1_SLTH_SSLT_5            BIT5
 set     I2C1_SLTH_SSLT_6            BIT6
 set     I2C1_SLTH_SSLT_7            BIT7

 set     I2C1_SLTL_SSLT              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
 set     I2C1_SLTL_SSLT_0            BIT0
 set     I2C1_SLTL_SSLT_1            BIT1
 set     I2C1_SLTL_SSLT_2            BIT2
 set     I2C1_SLTL_SSLT_3            BIT3
 set     I2C1_SLTL_SSLT_4            BIT4
 set     I2C1_SLTL_SSLT_5            BIT5
 set     I2C1_SLTL_SSLT_6            BIT6
 set     I2C1_SLTL_SSLT_7            BIT7

 set     INTC_IPR0_STPCNT            (BIT0|BIT1)
;;   EOnCE Step Counter Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_STPCNT_0          BIT0
 set     INTC_IPR0_STPCNT_1          BIT1

 set     INTC_IPR0_BKPT              (BIT2|BIT3)
;;   EOnCE Breakpoint Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_BKPT_0            BIT2
 set     INTC_IPR0_BKPT_1            BIT3

 set     INTC_IPR0_TRBUF             (BIT4|BIT5)
;;   EOnCE Trace Buffer Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_TRBUF_0           BIT4
 set     INTC_IPR0_TRBUF_1           BIT5

 set     INTC_IPR0_TX_REG            (BIT6|BIT7)
;;   EOnCE Transmit Register Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_TX_REG_0          BIT6
 set     INTC_IPR0_TX_REG_1          BIT7

 set     INTC_IPR0_RX_REG            (BIT8|BIT9)
;;   EOnCE Receive Register Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_RX_REG_0          BIT8
 set     INTC_IPR0_RX_REG_1          BIT9

 set     INTC_IPR0_BUS_ERR           (BIT10|BIT11)
;;   Bus Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR0_BUS_ERR_0         BIT10
 set     INTC_IPR0_BUS_ERR_1         BIT11

 set     INTC_IPR1_XBARA             (BIT2|BIT3)
;;   Inter-Peripheral Crossbar Switch A (XBARA) Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR1_XBARA_0           BIT2
 set     INTC_IPR1_XBARA_1           BIT3

 set     INTC_IPR1_LVI1              (BIT4|BIT5)
;;   Low Voltage Detector Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR1_LVI1_0            BIT4
 set     INTC_IPR1_LVI1_1            BIT5

 set     INTC_IPR1_OCCS              (BIT6|BIT7)
;;   PLL Loss of Reference or Change in Lock Status Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 1
;;     0b10 ==> IRQ Priority Level 2
;;     0b11 ==> IRQ Priority Level 3
 set     INTC_IPR1_OCCS_0            BIT6
 set     INTC_IPR1_OCCS_1            BIT7

 set     INTC_IPR1_TMRB_3            (BIT8|BIT9)
;;   Timer B Channel 3 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR1_TMRB_3_0          BIT8
 set     INTC_IPR1_TMRB_3_1          BIT9

 set     INTC_IPR1_TMRB_2            (BIT10|BIT11)
;;   Timer B Channel 2 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR1_TMRB_2_0          BIT10
 set     INTC_IPR1_TMRB_2_1          BIT11

 set     INTC_IPR1_TMRB_1            (BIT12|BIT13)
;;   Timer B Channel 1 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR1_TMRB_1_0          BIT12
 set     INTC_IPR1_TMRB_1_1          BIT13

 set     INTC_IPR1_TMRB_0            (BIT14|BIT15)
;;   Timer B Channel 0 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR1_TMRB_0_0          BIT14
 set     INTC_IPR1_TMRB_0_1          BIT15

 set     INTC_IPR2_TMRA_3            (BIT0|BIT1)
;;   Timer A Channel 3 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_3_0          BIT0
 set     INTC_IPR2_TMRA_3_1          BIT1

 set     INTC_IPR2_TMRA_2            (BIT2|BIT3)
;;   Timer A Channel 2 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_2_0          BIT2
 set     INTC_IPR2_TMRA_2_1          BIT3

 set     INTC_IPR2_TMRA_1            (BIT4|BIT5)
;;   Timer A Channel 1 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_1_0          BIT4
 set     INTC_IPR2_TMRA_1_1          BIT5

 set     INTC_IPR2_TMRA_0            (BIT6|BIT7)
;;   Timer A Channel 0 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_TMRA_0_0          BIT6
 set     INTC_IPR2_TMRA_0_1          BIT7

 set     INTC_IPR2_ADC_CC1           (BIT8|BIT9)
;;   ADC_CYC Conversion Complete Interrupt Priority Level (converter B in non-simultaneous parallel scan mode)
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_CC1_0         BIT8
 set     INTC_IPR2_ADC_CC1_1         BIT9

 set     INTC_IPR2_ADC_CC0           (BIT10|BIT11)
;;   ADC_CYC Conversion Complete Interrupt Priority Level (any scan type except converter B in non-simultaneous parallel scan mode)
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_CC0_0         BIT10
 set     INTC_IPR2_ADC_CC0_1         BIT11

 set     INTC_IPR2_ADC_ERR           (BIT12|BIT13)
;;   ADC_CYC Zero Crossing, High Limit, or Low Limit Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_ERR_0         BIT12
 set     INTC_IPR2_ADC_ERR_1         BIT13

 set     INTC_IPR2_ADC_COCO          (BIT14|BIT15)
;;   ADC_SAR Conversion Complete Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR2_ADC_COCO_0        BIT14
 set     INTC_IPR2_ADC_COCO_1        BIT15

 set     INTC_IPR3_DMACH3            (BIT0|BIT1)
;;   DMA Channel 3 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH3_0          BIT0
 set     INTC_IPR3_DMACH3_1          BIT1

 set     INTC_IPR3_DMACH2            (BIT2|BIT3)
;;   DMA Channel 2 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH2_0          BIT2
 set     INTC_IPR3_DMACH2_1          BIT3

 set     INTC_IPR3_DMACH1            (BIT4|BIT5)
;;   DMA Channel 1 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH1_0          BIT4
 set     INTC_IPR3_DMACH1_1          BIT5

 set     INTC_IPR3_DMACH0            (BIT6|BIT7)
;;   DMA Channel 0 Service Request Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_DMACH0_0          BIT6
 set     INTC_IPR3_DMACH0_1          BIT7

 set     INTC_IPR3_CAN_MB_OR         (BIT8|BIT9)
;;   CAN Message Buffer Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_CAN_MB_OR_0       BIT8
 set     INTC_IPR3_CAN_MB_OR_1       BIT9

 set     INTC_IPR3_CAN_BUS_OFF       (BIT10|BIT11)
;;   CAN Bus Off Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_CAN_BUS_OFF_0     BIT10
 set     INTC_IPR3_CAN_BUS_OFF_1     BIT11

 set     INTC_IPR3_CAN_ERROR         (BIT12|BIT13)
;;   CAN Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_CAN_ERROR_0       BIT12
 set     INTC_IPR3_CAN_ERROR_1       BIT13

 set     INTC_IPR3_CAN_TX_WARN       (BIT14|BIT15)
;;   CAN Transmit Warning Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR3_CAN_TX_WARN_0     BIT14
 set     INTC_IPR3_CAN_TX_WARN_1     BIT15

 set     INTC_IPR4_CAN_RX_WARN       (BIT0|BIT1)
;;   CAN Receive Warning Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR4_CAN_RX_WARN_0     BIT0
 set     INTC_IPR4_CAN_RX_WARN_1     BIT1

 set     INTC_IPR4_CAN_WAKEUP        (BIT2|BIT3)
;;   CAN Wakeup Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR4_CAN_WAKEUP_0      BIT2
 set     INTC_IPR4_CAN_WAKEUP_1      BIT3

 set     INTC_IPR4_QSCI1_RERR        (BIT12|BIT13)
;;   QSCI 1 Receiver Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR4_QSCI1_RERR_0      BIT12
 set     INTC_IPR4_QSCI1_RERR_1      BIT13

 set     INTC_IPR4_QSCI1_RCV         (BIT14|BIT15)
;;   QSCI 1 Receive Data Register Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR4_QSCI1_RCV_0       BIT14
 set     INTC_IPR4_QSCI1_RCV_1       BIT15

 set     INTC_IPR5_QSCI1_TIDLE       (BIT0|BIT1)
;;   QSCI 1 Transmitter Idle Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI1_TIDLE_0     BIT0
 set     INTC_IPR5_QSCI1_TIDLE_1     BIT1

 set     INTC_IPR5_QSCI1_TDRE        (BIT2|BIT3)
;;   QSCI 1 Transmit Data Register Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI1_TDRE_0      BIT2
 set     INTC_IPR5_QSCI1_TDRE_1      BIT3

 set     INTC_IPR5_QSCI0_RERR        (BIT4|BIT5)
;;   QSCI0 Receiver Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_RERR_0      BIT4
 set     INTC_IPR5_QSCI0_RERR_1      BIT5

 set     INTC_IPR5_QSCI0_RCV         (BIT6|BIT7)
;;   QSCI 0 Receive Data Register Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_RCV_0       BIT6
 set     INTC_IPR5_QSCI0_RCV_1       BIT7

 set     INTC_IPR5_QSCI0_TIDLE       (BIT8|BIT9)
;;   QSCI 0 Transmitter Idle Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_TIDLE_0     BIT8
 set     INTC_IPR5_QSCI0_TIDLE_1     BIT9

 set     INTC_IPR5_QSCI0_TDRE        (BIT10|BIT11)
;;   QSCI 0 Transmit Data Register Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR5_QSCI0_TDRE_0      BIT10
 set     INTC_IPR5_QSCI0_TDRE_1      BIT11

 set     INTC_IPR6_QSPI1_XMIT        (BIT0|BIT1)
;;   QSPI1 Transmitter Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_QSPI1_XMIT_0      BIT0
 set     INTC_IPR6_QSPI1_XMIT_1      BIT1

 set     INTC_IPR6_QSPI1_RCV         (BIT2|BIT3)
;;   QSPI1 Receiver Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_QSPI1_RCV_0       BIT2
 set     INTC_IPR6_QSPI1_RCV_1       BIT3

 set     INTC_IPR6_QSPI0_XMIT        (BIT4|BIT5)
;;   QSPI0 Transmitter Empty Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_QSPI0_XMIT_0      BIT4
 set     INTC_IPR6_QSPI0_XMIT_1      BIT5

 set     INTC_IPR6_QSPI0_RCV         (BIT6|BIT7)
;;   QSPI0 Receiver Full Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_QSPI0_RCV_0       BIT6
 set     INTC_IPR6_QSPI0_RCV_1       BIT7

 set     INTC_IPR6_IIC1              (BIT8|BIT9)
;;   IIC1 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_IIC1_0            BIT8
 set     INTC_IPR6_IIC1_1            BIT9

 set     INTC_IPR6_IIC0              (BIT10|BIT11)
;;   IIC0 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR6_IIC0_0            BIT10
 set     INTC_IPR6_IIC0_1            BIT11

 set     INTC_IPR8_PWMA_FAULT        (BIT8|BIT9)
;;   PWMA Fault Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_FAULT_0      BIT8
 set     INTC_IPR8_PWMA_FAULT_1      BIT9

 set     INTC_IPR8_PWMA_RERR         (BIT10|BIT11)
;;   PWMA Reload Error Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_RERR_0       BIT10
 set     INTC_IPR8_PWMA_RERR_1       BIT11

 set     INTC_IPR8_PWMA_RELOAD3      (BIT12|BIT13)
;;   PWMA Submodule 3 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_RELOAD3_0    BIT12
 set     INTC_IPR8_PWMA_RELOAD3_1    BIT13

 set     INTC_IPR8_PWMA_CAP          (BIT14|BIT15)
;;   PWMA Submodule Capture Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR8_PWMA_CAP_0        BIT14
 set     INTC_IPR8_PWMA_CAP_1        BIT15

 set     INTC_IPR9_PWMA_CMP3         (BIT0|BIT1)
;;   PWMA Submodule 3 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP3_0       BIT0
 set     INTC_IPR9_PWMA_CMP3_1       BIT1

 set     INTC_IPR9_PWMA_RELOAD2      (BIT2|BIT3)
;;   PWMA Submodule 2 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_RELOAD2_0    BIT2
 set     INTC_IPR9_PWMA_RELOAD2_1    BIT3

 set     INTC_IPR9_PWMA_CMP2         (BIT4|BIT5)
;;   PWMA Submodule 2 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP2_0       BIT4
 set     INTC_IPR9_PWMA_CMP2_1       BIT5

 set     INTC_IPR9_PWMA_RELOAD1      (BIT6|BIT7)
;;   PWMA Submodule 1 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_RELOAD1_0    BIT6
 set     INTC_IPR9_PWMA_RELOAD1_1    BIT7

 set     INTC_IPR9_PWMA_CMP1         (BIT8|BIT9)
;;   PWMA Submodule 1 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP1_0       BIT8
 set     INTC_IPR9_PWMA_CMP1_1       BIT9

 set     INTC_IPR9_PWMA_RELOAD0      (BIT10|BIT11)
;;   PWMA Submodule 0 Reload Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_RELOAD0_0    BIT10
 set     INTC_IPR9_PWMA_RELOAD0_1    BIT11

 set     INTC_IPR9_PWMA_CMP0         (BIT12|BIT13)
;;   PWMA Submodule 0 Compare Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_PWMA_CMP0_0       BIT12
 set     INTC_IPR9_PWMA_CMP0_1       BIT13

 set     INTC_IPR9_FTFL_RDCOL        (BIT14|BIT15)
;;   FTFL Access Error Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR9_FTFL_RDCOL_0      BIT14
 set     INTC_IPR9_FTFL_RDCOL_1      BIT15

 set     INTC_IPR10_FTFL_CC          (BIT0|BIT1)
;;   FTFL Command Complete Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_FTFL_CC_0        BIT0
 set     INTC_IPR10_FTFL_CC_1        BIT1

 set     INTC_IPR10_CMPD             (BIT2|BIT3)
;;   Comparator D Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPD_0           BIT2
 set     INTC_IPR10_CMPD_1           BIT3

 set     INTC_IPR10_CMPC             (BIT4|BIT5)
;;   Comparator C Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPC_0           BIT4
 set     INTC_IPR10_CMPC_1           BIT5

 set     INTC_IPR10_CMPB             (BIT6|BIT7)
;;   Comparator B Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPB_0           BIT6
 set     INTC_IPR10_CMPB_1           BIT7

 set     INTC_IPR10_CMPA             (BIT8|BIT9)
;;   Comparator A Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_CMPA_0           BIT8
 set     INTC_IPR10_CMPA_1           BIT9

 set     INTC_IPR10_PIT1_ROLLOVR     (BIT10|BIT11)
;;   PIT1 Roll Over Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_PIT1_ROLLOVR_0   BIT10
 set     INTC_IPR10_PIT1_ROLLOVR_1   BIT11

 set     INTC_IPR10_PIT0_ROLLOVR     (BIT12|BIT13)
;;   PIT0 Roll Over Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_PIT0_ROLLOVR_0   BIT12
 set     INTC_IPR10_PIT0_ROLLOVR_1   BIT13

 set     INTC_IPR10_PDB1             (BIT14|BIT15)
;;   PDB1 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR10_PDB1_0           BIT14
 set     INTC_IPR10_PDB1_1           BIT15

 set     INTC_IPR11_PDB0             (BIT0|BIT1)
;;   PDB0 Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_PDB0_0           BIT0
 set     INTC_IPR11_PDB0_1           BIT1

 set     INTC_IPR11_GPIOG            (BIT8|BIT9)
;;   GPIO G Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOG_0          BIT8
 set     INTC_IPR11_GPIOG_1          BIT9

 set     INTC_IPR11_GPIOF            (BIT10|BIT11)
;;   GPIO F Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOF_0          BIT10
 set     INTC_IPR11_GPIOF_1          BIT11

 set     INTC_IPR11_GPIOE            (BIT12|BIT13)
;;   GPIO E Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOE_0          BIT12
 set     INTC_IPR11_GPIOE_1          BIT13

 set     INTC_IPR11_GPIOD            (BIT14|BIT15)
;;   GPIO D Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR11_GPIOD_0          BIT14
 set     INTC_IPR11_GPIOD_1          BIT15

 set     INTC_IPR12_GPIOC            (BIT0|BIT1)
;;   GPIO C Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_GPIOC_0          BIT0
 set     INTC_IPR12_GPIOC_1          BIT1

 set     INTC_IPR12_GPIOB            (BIT2|BIT3)
;;   GPIO B Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_GPIOB_0          BIT2
 set     INTC_IPR12_GPIOB_1          BIT3

 set     INTC_IPR12_GPIOA            (BIT4|BIT5)
;;   GPIO A Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_GPIOA_0          BIT4
 set     INTC_IPR12_GPIOA_1          BIT5

 set     INTC_IPR12_COP_INT          (BIT6|BIT7)
;;   COP Watchdog Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_COP_INT_0        BIT6
 set     INTC_IPR12_COP_INT_1        BIT7

 set     INTC_IPR12_EWM_INT          (BIT8|BIT9)
;;   External Watchdog Monitor Interrupt Priority Level
;;     0b00 ==> IRQ disabled (default)
;;     0b01 ==> IRQ Priority Level 0
;;     0b10 ==> IRQ Priority Level 1
;;     0b11 ==> IRQ Priority Level 2
 set     INTC_IPR12_EWM_INT_0        BIT8
 set     INTC_IPR12_EWM_INT_1        BIT9

 set     INTC_VBA_VECTOR_BASE_ADDRESS (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
;;   Interrupt Vector Base Address
 set     INTC_VBA_VECTOR_BASE_ADDRESS_0 BIT0
 set     INTC_VBA_VECTOR_BASE_ADDRESS_1 BIT1
 set     INTC_VBA_VECTOR_BASE_ADDRESS_2 BIT2
 set     INTC_VBA_VECTOR_BASE_ADDRESS_3 BIT3
 set     INTC_VBA_VECTOR_BASE_ADDRESS_4 BIT4
 set     INTC_VBA_VECTOR_BASE_ADDRESS_5 BIT5
 set     INTC_VBA_VECTOR_BASE_ADDRESS_6 BIT6
 set     INTC_VBA_VECTOR_BASE_ADDRESS_7 BIT7
 set     INTC_VBA_VECTOR_BASE_ADDRESS_8 BIT8
 set     INTC_VBA_VECTOR_BASE_ADDRESS_9 BIT9
 set     INTC_VBA_VECTOR_BASE_ADDRESS_10 BIT10
 set     INTC_VBA_VECTOR_BASE_ADDRESS_11 BIT11
 set     INTC_VBA_VECTOR_BASE_ADDRESS_12 BIT12

 set     INTC_FIM0_FAST_INTERRUPT_0  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Fast Interrupt 0 Vector Number
 set     INTC_FIM0_FAST_INTERRUPT_0_0 BIT0
 set     INTC_FIM0_FAST_INTERRUPT_0_1 BIT1
 set     INTC_FIM0_FAST_INTERRUPT_0_2 BIT2
 set     INTC_FIM0_FAST_INTERRUPT_0_3 BIT3
 set     INTC_FIM0_FAST_INTERRUPT_0_4 BIT4
 set     INTC_FIM0_FAST_INTERRUPT_0_5 BIT5
 set     INTC_FIM0_FAST_INTERRUPT_0_6 BIT6

 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_0 BIT0
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_1 BIT1
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_2 BIT2
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_3 BIT3
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_4 BIT4
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_5 BIT5
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_6 BIT6
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_7 BIT7
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_8 BIT8
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_9 BIT9
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_10 BIT10
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_11 BIT11
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_12 BIT12
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_13 BIT13
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_14 BIT14
 set     INTC_FIVAL0_FI_0_VECTOR_ADDRESS_LOW_15 BIT15

 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH (BIT0|BIT1|BIT2|BIT3|BIT4)
;;   Upper 5 bits of vector address for fast interrupt 0
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_0 BIT0
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_1 BIT1
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_2 BIT2
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_3 BIT3
 set     INTC_FIVAH0_FI_0_VECTOR_ADDRESS_HIGH_4 BIT4

 set     INTC_FIM1_FAST_INTERRUPT_1  (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Fast Interrupt 1 Vector Number
 set     INTC_FIM1_FAST_INTERRUPT_1_0 BIT0
 set     INTC_FIM1_FAST_INTERRUPT_1_1 BIT1
 set     INTC_FIM1_FAST_INTERRUPT_1_2 BIT2
 set     INTC_FIM1_FAST_INTERRUPT_1_3 BIT3
 set     INTC_FIM1_FAST_INTERRUPT_1_4 BIT4
 set     INTC_FIM1_FAST_INTERRUPT_1_5 BIT5
 set     INTC_FIM1_FAST_INTERRUPT_1_6 BIT6

 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Lower 16 bits of vector address for fast interrupt 1
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_0 BIT0
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_1 BIT1
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_2 BIT2
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_3 BIT3
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_4 BIT4
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_5 BIT5
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_6 BIT6
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_7 BIT7
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_8 BIT8
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_9 BIT9
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_10 BIT10
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_11 BIT11
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_12 BIT12
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_13 BIT13
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_14 BIT14
 set     INTC_FIVAL1_FI_1_VECTOR_ADDRESS_LOW_15 BIT15

 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH (BIT0|BIT1|BIT2|BIT3|BIT4)
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_0 BIT0
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_1 BIT1
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_2 BIT2
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_3 BIT3
 set     INTC_FIVAH1_FI_1_VECTOR_ADDRESS_HIGH_4 BIT4

 set     INTC_IRQP0_PENDING          (BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP0_PENDING_0        BIT1
 set     INTC_IRQP0_PENDING_1        BIT2
 set     INTC_IRQP0_PENDING_2        BIT3
 set     INTC_IRQP0_PENDING_3        BIT4
 set     INTC_IRQP0_PENDING_4        BIT5
 set     INTC_IRQP0_PENDING_5        BIT6
 set     INTC_IRQP0_PENDING_6        BIT7
 set     INTC_IRQP0_PENDING_7        BIT8
 set     INTC_IRQP0_PENDING_8        BIT9
 set     INTC_IRQP0_PENDING_9        BIT10
 set     INTC_IRQP0_PENDING_10       BIT11
 set     INTC_IRQP0_PENDING_11       BIT12
 set     INTC_IRQP0_PENDING_12       BIT13
 set     INTC_IRQP0_PENDING_13       BIT14
 set     INTC_IRQP0_PENDING_14       BIT15

 set     INTC_IRQP1_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP1_PENDING_0        BIT0
 set     INTC_IRQP1_PENDING_1        BIT1
 set     INTC_IRQP1_PENDING_2        BIT2
 set     INTC_IRQP1_PENDING_3        BIT3
 set     INTC_IRQP1_PENDING_4        BIT4
 set     INTC_IRQP1_PENDING_5        BIT5
 set     INTC_IRQP1_PENDING_6        BIT6
 set     INTC_IRQP1_PENDING_7        BIT7
 set     INTC_IRQP1_PENDING_8        BIT8
 set     INTC_IRQP1_PENDING_9        BIT9
 set     INTC_IRQP1_PENDING_10       BIT10
 set     INTC_IRQP1_PENDING_11       BIT11
 set     INTC_IRQP1_PENDING_12       BIT12
 set     INTC_IRQP1_PENDING_13       BIT13
 set     INTC_IRQP1_PENDING_14       BIT14
 set     INTC_IRQP1_PENDING_15       BIT15

 set     INTC_IRQP2_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP2_PENDING_0        BIT0
 set     INTC_IRQP2_PENDING_1        BIT1
 set     INTC_IRQP2_PENDING_2        BIT2
 set     INTC_IRQP2_PENDING_3        BIT3
 set     INTC_IRQP2_PENDING_4        BIT4
 set     INTC_IRQP2_PENDING_5        BIT5
 set     INTC_IRQP2_PENDING_6        BIT6
 set     INTC_IRQP2_PENDING_7        BIT7
 set     INTC_IRQP2_PENDING_8        BIT8
 set     INTC_IRQP2_PENDING_9        BIT9
 set     INTC_IRQP2_PENDING_10       BIT10
 set     INTC_IRQP2_PENDING_11       BIT11
 set     INTC_IRQP2_PENDING_12       BIT12
 set     INTC_IRQP2_PENDING_13       BIT13
 set     INTC_IRQP2_PENDING_14       BIT14
 set     INTC_IRQP2_PENDING_15       BIT15

 set     INTC_IRQP3_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP3_PENDING_0        BIT0
 set     INTC_IRQP3_PENDING_1        BIT1
 set     INTC_IRQP3_PENDING_2        BIT2
 set     INTC_IRQP3_PENDING_3        BIT3
 set     INTC_IRQP3_PENDING_4        BIT4
 set     INTC_IRQP3_PENDING_5        BIT5
 set     INTC_IRQP3_PENDING_6        BIT6
 set     INTC_IRQP3_PENDING_7        BIT7
 set     INTC_IRQP3_PENDING_8        BIT8
 set     INTC_IRQP3_PENDING_9        BIT9
 set     INTC_IRQP3_PENDING_10       BIT10
 set     INTC_IRQP3_PENDING_11       BIT11
 set     INTC_IRQP3_PENDING_12       BIT12
 set     INTC_IRQP3_PENDING_13       BIT13
 set     INTC_IRQP3_PENDING_14       BIT14
 set     INTC_IRQP3_PENDING_15       BIT15

 set     INTC_IRQP4_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP4_PENDING_0        BIT0
 set     INTC_IRQP4_PENDING_1        BIT1
 set     INTC_IRQP4_PENDING_2        BIT2
 set     INTC_IRQP4_PENDING_3        BIT3
 set     INTC_IRQP4_PENDING_4        BIT4
 set     INTC_IRQP4_PENDING_5        BIT5
 set     INTC_IRQP4_PENDING_6        BIT6
 set     INTC_IRQP4_PENDING_7        BIT7
 set     INTC_IRQP4_PENDING_8        BIT8
 set     INTC_IRQP4_PENDING_9        BIT9
 set     INTC_IRQP4_PENDING_10       BIT10
 set     INTC_IRQP4_PENDING_11       BIT11
 set     INTC_IRQP4_PENDING_12       BIT12
 set     INTC_IRQP4_PENDING_13       BIT13
 set     INTC_IRQP4_PENDING_14       BIT14
 set     INTC_IRQP4_PENDING_15       BIT15

 set     INTC_IRQP5_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP5_PENDING_0        BIT0
 set     INTC_IRQP5_PENDING_1        BIT1
 set     INTC_IRQP5_PENDING_2        BIT2
 set     INTC_IRQP5_PENDING_3        BIT3
 set     INTC_IRQP5_PENDING_4        BIT4
 set     INTC_IRQP5_PENDING_5        BIT5
 set     INTC_IRQP5_PENDING_6        BIT6
 set     INTC_IRQP5_PENDING_7        BIT7
 set     INTC_IRQP5_PENDING_8        BIT8
 set     INTC_IRQP5_PENDING_9        BIT9
 set     INTC_IRQP5_PENDING_10       BIT10
 set     INTC_IRQP5_PENDING_11       BIT11
 set     INTC_IRQP5_PENDING_12       BIT12
 set     INTC_IRQP5_PENDING_13       BIT13
 set     INTC_IRQP5_PENDING_14       BIT14
 set     INTC_IRQP5_PENDING_15       BIT15

 set     INTC_IRQP6_PENDING          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13)
;;   Pending IRQs
;;     0b0 ==> IRQ pending for this vector number
;;     0b1 ==> No IRQ pending for this vector number
 set     INTC_IRQP6_PENDING_0        BIT0
 set     INTC_IRQP6_PENDING_1        BIT1
 set     INTC_IRQP6_PENDING_2        BIT2
 set     INTC_IRQP6_PENDING_3        BIT3
 set     INTC_IRQP6_PENDING_4        BIT4
 set     INTC_IRQP6_PENDING_5        BIT5
 set     INTC_IRQP6_PENDING_6        BIT6
 set     INTC_IRQP6_PENDING_7        BIT7
 set     INTC_IRQP6_PENDING_8        BIT8
 set     INTC_IRQP6_PENDING_9        BIT9
 set     INTC_IRQP6_PENDING_10       BIT10
 set     INTC_IRQP6_PENDING_11       BIT11
 set     INTC_IRQP6_PENDING_12       BIT12
 set     INTC_IRQP6_PENDING_13       BIT13

 set     INTC_CTRL_INT_DIS           BIT5
;;   Interrupt disable
;;     0b0 ==> Normal operation. (default)
;;     0b1 ==> All interrupts disabled.

 set     INTC_CTRL_VAB               (BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12)
;;   Vector number
 set     INTC_CTRL_VAB_0             BIT6
 set     INTC_CTRL_VAB_1             BIT7
 set     INTC_CTRL_VAB_2             BIT8
 set     INTC_CTRL_VAB_3             BIT9
 set     INTC_CTRL_VAB_4             BIT10
 set     INTC_CTRL_VAB_5             BIT11
 set     INTC_CTRL_VAB_6             BIT12

 set     INTC_CTRL_IPIC              (BIT13|BIT14)
;;   Interrupt Priority Level
;;     0b00 ==> Required nested exception priority levels are 0, 1, 2, or 3.
;;     0b01 ==> Required nested exception priority levels are 1, 2, or 3.
;;     0b10 ==> Required nested exception priority levels are 2 or3.
;;     0b11 ==> Required nested exception priority level is 3.
 set     INTC_CTRL_IPIC_0            BIT13
 set     INTC_CTRL_IPIC_1            BIT14

 set     INTC_CTRL_INT               BIT15
;;   Interrupt
;;     0b0 ==> No interrupt is being sent to the core.
;;     0b1 ==> An interrupt is being sent to the core.

 set     MCM_PLASC_ASC               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Each bit in the ASC field indicates if there is a corresponding connection to the AXBS slave input port. For this device, this field always read 0x0F.
;;     0b0 ==> A bus slave connection to AXBS input port n is absent
;;     0b1 ==> A bus slave connection to AXBS input port n is present
 set     MCM_PLASC_ASC_0             BIT0
 set     MCM_PLASC_ASC_1             BIT1
 set     MCM_PLASC_ASC_2             BIT2
 set     MCM_PLASC_ASC_3             BIT3
 set     MCM_PLASC_ASC_4             BIT4
 set     MCM_PLASC_ASC_5             BIT5
 set     MCM_PLASC_ASC_6             BIT6
 set     MCM_PLASC_ASC_7             BIT7

 set     MCM_PLASC_DP64              BIT15
;;   Indicates if the datapath is 32 or 64 bits wide
;;     0b0 ==> Datapath width is 32 bits
;;     0b1 ==> Datapath width is 64 bits

 set     MCM_PLAMC_AMC               (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Each bit in the AMC field indicates if there is a corresponding connection to the AXBS master input port. For this device, this field always reads 0x0F.
;;     0b0 ==> A bus master connection to AXBS input port n is absent
;;     0b1 ==> A bus master connection to AXBS input port n is present
 set     MCM_PLAMC_AMC_0             BIT0
 set     MCM_PLAMC_AMC_1             BIT1
 set     MCM_PLAMC_AMC_2             BIT2
 set     MCM_PLAMC_AMC_3             BIT3
 set     MCM_PLAMC_AMC_4             BIT4
 set     MCM_PLAMC_AMC_5             BIT5
 set     MCM_PLAMC_AMC_6             BIT6
 set     MCM_PLAMC_AMC_7             BIT7

 set     MCM_CPCR_INSDIS             BIT16
;;   Disable instructions supported only by DSP56800EX core
;;     0b0 ==> BFSC and 32-bit multiply and MAC instructions enabled
;;     0b1 ==> BFSC and 32-bit multiply and MAC instructions disabled

 set     MCM_CPCR_RCDIS              BIT17
;;   Disable core reverse carry
;;     0b0 ==> Core reverse carry enabled
;;     0b1 ==> Core reverse carry disabled

 set     MCM_CPCR_SRDIS              BIT18
;;   Disable core new shadow region
;;     0b0 ==> Core new shadow region enabled
;;     0b1 ==> Core new shadow region disabled

 set     MCM_CPCR_IBDIS              BIT19
;;   Disable core instruction buffer
;;     0b0 ==> Core longword instruction buffer enabled
;;     0b1 ==> Core longword instruction buffer disabled

 set     MCM_CFADR_ADDR              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Indicates the faulting address of the last core access terminated with an error response.
 set     MCM_CFADR_ADDR_0            BIT0
 set     MCM_CFADR_ADDR_1            BIT1
 set     MCM_CFADR_ADDR_2            BIT2
 set     MCM_CFADR_ADDR_3            BIT3
 set     MCM_CFADR_ADDR_4            BIT4
 set     MCM_CFADR_ADDR_5            BIT5
 set     MCM_CFADR_ADDR_6            BIT6
 set     MCM_CFADR_ADDR_7            BIT7
 set     MCM_CFADR_ADDR_8            BIT8
 set     MCM_CFADR_ADDR_9            BIT9
 set     MCM_CFADR_ADDR_10           BIT10
 set     MCM_CFADR_ADDR_11           BIT11
 set     MCM_CFADR_ADDR_12           BIT12
 set     MCM_CFADR_ADDR_13           BIT13
 set     MCM_CFADR_ADDR_14           BIT14
 set     MCM_CFADR_ADDR_15           BIT15
 set     MCM_CFADR_ADDR_16           BIT16
 set     MCM_CFADR_ADDR_17           BIT17
 set     MCM_CFADR_ADDR_18           BIT18
 set     MCM_CFADR_ADDR_19           BIT19
 set     MCM_CFADR_ADDR_20           BIT20
 set     MCM_CFADR_ADDR_21           BIT21
 set     MCM_CFADR_ADDR_22           BIT22
 set     MCM_CFADR_ADDR_23           BIT23
 set     MCM_CFADR_ADDR_24           BIT24
 set     MCM_CFADR_ADDR_25           BIT25
 set     MCM_CFADR_ADDR_26           BIT26
 set     MCM_CFADR_ADDR_27           BIT27
 set     MCM_CFADR_ADDR_28           BIT28
 set     MCM_CFADR_ADDR_29           BIT29
 set     MCM_CFADR_ADDR_30           BIT30
 set     MCM_CFADR_ADDR_31           BIT31

 set     MCM_CFATR_TYPE              BIT0
;;   Type of last faulted core access
;;     0b0 ==> Instruction
;;     0b1 ==> Data

 set     MCM_CFATR_BUFFER            BIT2
;;   Indicates if last faulted core access was bufferable
;;     0b0 ==> Non-bufferable
;;     0b1 ==> Bufferable

 set     MCM_CFATR_SIZE              (BIT4|BIT5|BIT6)
;;   Size of last faulted core access
;;     0b000 ==> 8-bit
;;     0b001 ==> 16-bit
;;     0b010 ==> 32-bit
 set     MCM_CFATR_SIZE_0            BIT4
 set     MCM_CFATR_SIZE_1            BIT5
 set     MCM_CFATR_SIZE_2            BIT6

 set     MCM_CFATR_DIR               BIT7
;;   Direction of last faulted core access
;;     0b0 ==> Core read access
;;     0b1 ==> Core write access

 set     MCM_CFLOC_LOC               (BIT6|BIT7)
;;   Location of last captured fault
;;     0b00 ==> Error occurred on M0 (instruction bus)
;;     0b01 ==> Error occured on M1 (operand A bus)
;;     0b10 ==> Error occured on M2 (operand B bus)
;;     0b11 ==> Reserved
 set     MCM_CFLOC_LOC_0             BIT6
 set     MCM_CFLOC_LOC_1             BIT7

 set     MCM_CFIER_ECFEI             BIT7
;;   Enable core fault error interrupt
;;     0b0 ==> Do not generate an error interrupt on a faulted system bus cycle
;;     0b1 ==> Generate an error interrupt to the interrupt controller on a faulted system bus cycle

 set     MCM_CFISR_CFEI              BIT7
;;   Core fault error interrupt flag
;;     0b0 ==> No bus error
;;     0b1 ==> A bus error has occurred. The faulting address, attributes (and possibly write data) are captured in the CFADR, CFATR, and CFDTR registers. The error interrupt is enabled only if CFIER[ECFEI] is set.

 set     MCM_CFDTR_DATA              (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23|BIT24|BIT25|BIT26|BIT27|BIT28|BIT29|BIT30|BIT31)
;;   Contains write data associated with the faulting access of the last internal bus write access. The data value is taken directly from the write data bus. Read data is not captured.
 set     MCM_CFDTR_DATA_0            BIT0
 set     MCM_CFDTR_DATA_1            BIT1
 set     MCM_CFDTR_DATA_2            BIT2
 set     MCM_CFDTR_DATA_3            BIT3
 set     MCM_CFDTR_DATA_4            BIT4
 set     MCM_CFDTR_DATA_5            BIT5
 set     MCM_CFDTR_DATA_6            BIT6
 set     MCM_CFDTR_DATA_7            BIT7
 set     MCM_CFDTR_DATA_8            BIT8
 set     MCM_CFDTR_DATA_9            BIT9
 set     MCM_CFDTR_DATA_10           BIT10
 set     MCM_CFDTR_DATA_11           BIT11
 set     MCM_CFDTR_DATA_12           BIT12
 set     MCM_CFDTR_DATA_13           BIT13
 set     MCM_CFDTR_DATA_14           BIT14
 set     MCM_CFDTR_DATA_15           BIT15
 set     MCM_CFDTR_DATA_16           BIT16
 set     MCM_CFDTR_DATA_17           BIT17
 set     MCM_CFDTR_DATA_18           BIT18
 set     MCM_CFDTR_DATA_19           BIT19
 set     MCM_CFDTR_DATA_20           BIT20
 set     MCM_CFDTR_DATA_21           BIT21
 set     MCM_CFDTR_DATA_22           BIT22
 set     MCM_CFDTR_DATA_23           BIT23
 set     MCM_CFDTR_DATA_24           BIT24
 set     MCM_CFDTR_DATA_25           BIT25
 set     MCM_CFDTR_DATA_26           BIT26
 set     MCM_CFDTR_DATA_27           BIT27
 set     MCM_CFDTR_DATA_28           BIT28
 set     MCM_CFDTR_DATA_29           BIT29
 set     MCM_CFDTR_DATA_30           BIT30
 set     MCM_CFDTR_DATA_31           BIT31

 set     MCM_RPCR_RPE                BIT0
;;   Resource Protection Enable
;;     0b0 ==> Resource protection disabled
;;     0b1 ==> Resource protection enabled

 set     MCM_RPCR_RL                 BIT1
;;   Register Lock
;;     0b0 ==> RP register values may be changed
;;     0b1 ==> RP registers are locked and may not be changed until after a system reset

 set     MCM_UFLASHBAR_FBA           (BIT12|BIT13|BIT14|BIT15|BIT16|BIT17)
;;   Flash Base Address for User Region
 set     MCM_UFLASHBAR_FBA_0         BIT12
 set     MCM_UFLASHBAR_FBA_1         BIT13
 set     MCM_UFLASHBAR_FBA_2         BIT14
 set     MCM_UFLASHBAR_FBA_3         BIT15
 set     MCM_UFLASHBAR_FBA_4         BIT16
 set     MCM_UFLASHBAR_FBA_5         BIT17

 set     MCM_UPRAMBAR_RBA            (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14)
;;   Program RAM Base Address for User Region
 set     MCM_UPRAMBAR_RBA_0          BIT8
 set     MCM_UPRAMBAR_RBA_1          BIT9
 set     MCM_UPRAMBAR_RBA_2          BIT10
 set     MCM_UPRAMBAR_RBA_3          BIT11
 set     MCM_UPRAMBAR_RBA_4          BIT12
 set     MCM_UPRAMBAR_RBA_5          BIT13
 set     MCM_UPRAMBAR_RBA_6          BIT14

 set     MCM_SRPOSP_SRPOSP           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20|BIT21|BIT22|BIT23)
;;   Resource protection "other" SP
 set     MCM_SRPOSP_SRPOSP_0         BIT0
 set     MCM_SRPOSP_SRPOSP_1         BIT1
 set     MCM_SRPOSP_SRPOSP_2         BIT2
 set     MCM_SRPOSP_SRPOSP_3         BIT3
 set     MCM_SRPOSP_SRPOSP_4         BIT4
 set     MCM_SRPOSP_SRPOSP_5         BIT5
 set     MCM_SRPOSP_SRPOSP_6         BIT6
 set     MCM_SRPOSP_SRPOSP_7         BIT7
 set     MCM_SRPOSP_SRPOSP_8         BIT8
 set     MCM_SRPOSP_SRPOSP_9         BIT9
 set     MCM_SRPOSP_SRPOSP_10        BIT10
 set     MCM_SRPOSP_SRPOSP_11        BIT11
 set     MCM_SRPOSP_SRPOSP_12        BIT12
 set     MCM_SRPOSP_SRPOSP_13        BIT13
 set     MCM_SRPOSP_SRPOSP_14        BIT14
 set     MCM_SRPOSP_SRPOSP_15        BIT15
 set     MCM_SRPOSP_SRPOSP_16        BIT16
 set     MCM_SRPOSP_SRPOSP_17        BIT17
 set     MCM_SRPOSP_SRPOSP_18        BIT18
 set     MCM_SRPOSP_SRPOSP_19        BIT19
 set     MCM_SRPOSP_SRPOSP_20        BIT20
 set     MCM_SRPOSP_SRPOSP_21        BIT21
 set     MCM_SRPOSP_SRPOSP_22        BIT22
 set     MCM_SRPOSP_SRPOSP_23        BIT23

 set     MCM_SRPIPC_SRPIFPC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
;;   Resource Protection Illegal Faulting PC
 set     MCM_SRPIPC_SRPIFPC_0        BIT0
 set     MCM_SRPIPC_SRPIFPC_1        BIT1
 set     MCM_SRPIPC_SRPIFPC_2        BIT2
 set     MCM_SRPIPC_SRPIFPC_3        BIT3
 set     MCM_SRPIPC_SRPIFPC_4        BIT4
 set     MCM_SRPIPC_SRPIFPC_5        BIT5
 set     MCM_SRPIPC_SRPIFPC_6        BIT6
 set     MCM_SRPIPC_SRPIFPC_7        BIT7
 set     MCM_SRPIPC_SRPIFPC_8        BIT8
 set     MCM_SRPIPC_SRPIFPC_9        BIT9
 set     MCM_SRPIPC_SRPIFPC_10       BIT10
 set     MCM_SRPIPC_SRPIFPC_11       BIT11
 set     MCM_SRPIPC_SRPIFPC_12       BIT12
 set     MCM_SRPIPC_SRPIFPC_13       BIT13
 set     MCM_SRPIPC_SRPIFPC_14       BIT14
 set     MCM_SRPIPC_SRPIFPC_15       BIT15
 set     MCM_SRPIPC_SRPIFPC_16       BIT16
 set     MCM_SRPIPC_SRPIFPC_17       BIT17
 set     MCM_SRPIPC_SRPIFPC_18       BIT18
 set     MCM_SRPIPC_SRPIFPC_19       BIT19
 set     MCM_SRPIPC_SRPIFPC_20       BIT20

 set     MCM_SRPIPC_SRPIFV           BIT31
;;   Resource Protection Illegal Fault Valid

 set     MCM_SRPMPC_SRPMFPC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15|BIT16|BIT17|BIT18|BIT19|BIT20)
;;   Resource Protection Misaligned Faulting PC
 set     MCM_SRPMPC_SRPMFPC_0        BIT0
 set     MCM_SRPMPC_SRPMFPC_1        BIT1
 set     MCM_SRPMPC_SRPMFPC_2        BIT2
 set     MCM_SRPMPC_SRPMFPC_3        BIT3
 set     MCM_SRPMPC_SRPMFPC_4        BIT4
 set     MCM_SRPMPC_SRPMFPC_5        BIT5
 set     MCM_SRPMPC_SRPMFPC_6        BIT6
 set     MCM_SRPMPC_SRPMFPC_7        BIT7
 set     MCM_SRPMPC_SRPMFPC_8        BIT8
 set     MCM_SRPMPC_SRPMFPC_9        BIT9
 set     MCM_SRPMPC_SRPMFPC_10       BIT10
 set     MCM_SRPMPC_SRPMFPC_11       BIT11
 set     MCM_SRPMPC_SRPMFPC_12       BIT12
 set     MCM_SRPMPC_SRPMFPC_13       BIT13
 set     MCM_SRPMPC_SRPMFPC_14       BIT14
 set     MCM_SRPMPC_SRPMFPC_15       BIT15
 set     MCM_SRPMPC_SRPMFPC_16       BIT16
 set     MCM_SRPMPC_SRPMFPC_17       BIT17
 set     MCM_SRPMPC_SRPMFPC_18       BIT18
 set     MCM_SRPMPC_SRPMFPC_19       BIT19
 set     MCM_SRPMPC_SRPMFPC_20       BIT20

 set     MCM_SRPMPC_SRPMFV           BIT31
;;   Resource Protection Misaligned Fault Valid

 set     OCCS_CTRL_ZSRC              BIT0
;;   CLOCK Source
;;     0b0 ==> MSTR_OSC
;;     0b1 ==> PLL output divided by 2

 set     OCCS_CTRL_PRECS             (BIT2|BIT3)
;;   Prescaler Clock Select
;;     0b00 ==> 8 MHz relaxation oscillator selected (reset value)
;;     0b01 ==> External reference selected
;;     0b10 ==> 32 kHz relaxation oscillator selected
;;     0b11 ==> Reserved
 set     OCCS_CTRL_PRECS_0           BIT2
 set     OCCS_CTRL_PRECS_1           BIT3

 set     OCCS_CTRL_PLLPD             BIT4
;;   PLL Power Down
;;     0b0 ==> PLL enabled
;;     0b1 ==> PLL powered down

 set     OCCS_CTRL_LCKON             BIT7
;;   Lock Detector On
;;     0b0 ==> Lock detector disabled
;;     0b1 ==> Lock detector enabled

 set     OCCS_CTRL_LOCIE             BIT11
;;   Loss of Reference Clock Interrupt Enable
;;     0b0 ==> Interrupt disabled.
;;     0b1 ==> Interrupt enabled.

 set     OCCS_CTRL_PLLIE0            (BIT12|BIT13)
;;   PLL Interrupt Enable 0
;;     0b00 ==> Disable interrupt.
;;     0b01 ==> Enable interrupt on any rising edge of LCK0.
;;     0b10 ==> Enable interrupt on falling edge of LCK0.
;;     0b11 ==> Enable interrupt on any edge change of LCK0.
 set     OCCS_CTRL_PLLIE0_0          BIT12
 set     OCCS_CTRL_PLLIE0_1          BIT13

 set     OCCS_CTRL_PLLIE1            (BIT14|BIT15)
;;   PLL Interrupt Enable 1
;;     0b00 ==> Disable interrupt.
;;     0b01 ==> Enable interrupt on any rising edge of LCK1.
;;     0b10 ==> Enable interrupt on falling edge of LCK1.
;;     0b11 ==> Enable interrupt on any edge change of LCK1.
 set     OCCS_CTRL_PLLIE1_0          BIT14
 set     OCCS_CTRL_PLLIE1_1          BIT15

 set     OCCS_DIVBY_PLLDB            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   PLL Divide By
 set     OCCS_DIVBY_PLLDB_0          BIT0
 set     OCCS_DIVBY_PLLDB_1          BIT1
 set     OCCS_DIVBY_PLLDB_2          BIT2
 set     OCCS_DIVBY_PLLDB_3          BIT3
 set     OCCS_DIVBY_PLLDB_4          BIT4
 set     OCCS_DIVBY_PLLDB_5          BIT5

 set     OCCS_DIVBY_COD              (BIT8|BIT9|BIT10|BIT11)
;;   Clock Output Divide or Postscaler
;;     0b0000 ==> Divide clock output by 1.
;;     0b0001 ==> Divide clock output by 2.
;;     0b0010 ==> Divide clock output by 4.
;;     0b0011 ==> Divide clock output by 8.
;;     0b0100 ==> Divide clock output by 16.
;;     0b0101 ==> Divide clock output by 32.
;;     0b0110 ==> Divide clock output by 64.
;;     0b0111 ==> Divide clock output by 128.
;;     0b1xxx ==> Divide clock output by 256.
 set     OCCS_DIVBY_COD_0            BIT8
 set     OCCS_DIVBY_COD_1            BIT9
 set     OCCS_DIVBY_COD_2            BIT10
 set     OCCS_DIVBY_COD_3            BIT11

 set     OCCS_DIVBY_LORTP            (BIT12|BIT13|BIT14|BIT15)
;;   Loss of Reference Clock Trip Point
 set     OCCS_DIVBY_LORTP_0          BIT12
 set     OCCS_DIVBY_LORTP_1          BIT13
 set     OCCS_DIVBY_LORTP_2          BIT14
 set     OCCS_DIVBY_LORTP_3          BIT15

 set     OCCS_STAT_ZSRCS             (BIT0|BIT1)
;;   CLOCK Source Status
;;     0b00 ==> MSTR_OSC
;;     0b01 ==> PLL output divided by 2
;;     0b1x ==> Synchronization in progress
 set     OCCS_STAT_ZSRCS_0           BIT0
 set     OCCS_STAT_ZSRCS_1           BIT1

 set     OCCS_STAT_PLLPDN            BIT4
;;   PLL Power Down
;;     0b0 ==> PLL not powered down.
;;     0b1 ==> PLL powered down.

 set     OCCS_STAT_LCK0              BIT5
;;   PLL Lock 0 Status
;;     0b0 ==> PLL is unlocked.
;;     0b1 ==> PLL is locked (coarse).

 set     OCCS_STAT_LCK1              BIT6
;;   PLL Lock 1 Status
;;     0b0 ==> PLL is unlocked.
;;     0b1 ==> PLL is locked (fine).

 set     OCCS_STAT_OSC_OK            BIT7
;;   OSC_OK Indicator from XOSC
;;     0b0 ==> Oscillator clock is still not stable, or XOSC is disabled.
;;     0b1 ==> XOSC OK indicator after crystal oscillator startup.

 set     OCCS_STAT_MON_FAILURE       BIT8
;;   XOSC Clock Monitor Failure Indicator
;;     0b0 ==> No clock failure, or clock monitor is disabled.
;;     0b1 ==> Clock failure detected on XOSC reference clock when clock monitor is enabled.

 set     OCCS_STAT_LOCI              BIT13
;;   Loss of Reference Clock Interrupt
;;     0b0 ==> Oscillator clock normal.
;;     0b1 ==> Loss of oscillator clock detected.

 set     OCCS_STAT_LOLI0             BIT14
;;   PLL Lock or Loss of Lock Interrupt 0
;;     0b0 ==> No lock or loss of lock event has occurred.
;;     0b1 ==> PLL lock status based on PLLIE0.

 set     OCCS_STAT_LOLI1             BIT15
;;   PLL Lock or Loss of Lock Interrupt 1
;;     0b0 ==> No lock or loss of lock event has occurred.
;;     0b1 ==> PLL lock status based on PLLIE1.

 set     OCCS_OSCTL1_FREQ_TRIM8M     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9)
;;   8 MHz Relaxation Oscillator Frequency Trim
 set     OCCS_OSCTL1_FREQ_TRIM8M_0   BIT0
 set     OCCS_OSCTL1_FREQ_TRIM8M_1   BIT1
 set     OCCS_OSCTL1_FREQ_TRIM8M_2   BIT2
 set     OCCS_OSCTL1_FREQ_TRIM8M_3   BIT3
 set     OCCS_OSCTL1_FREQ_TRIM8M_4   BIT4
 set     OCCS_OSCTL1_FREQ_TRIM8M_5   BIT5
 set     OCCS_OSCTL1_FREQ_TRIM8M_6   BIT6
 set     OCCS_OSCTL1_FREQ_TRIM8M_7   BIT7
 set     OCCS_OSCTL1_FREQ_TRIM8M_8   BIT8
 set     OCCS_OSCTL1_FREQ_TRIM8M_9   BIT9

 set     OCCS_OSCTL1_EXT_SEL         BIT10
;;   External Clock In Select
;;     0b0 ==> Use the output of the crystal oscillator as the external clock input.
;;     0b1 ==> Use CLKIN as the external clock input.

 set     OCCS_OSCTL1_OSC_DIV2        BIT11
;;   Oscillator Divide By 2
;;     0b0 ==> External oscillator output is not divided.
;;     0b1 ==> External oscillator output is divided by 2 before use as MSTR_OSC.

 set     OCCS_OSCTL1_CLK_MODE        BIT12
;;   Crystal Oscillator Clock Mode
;;     0b0 ==> Crystal oscillator enabled.
;;     0b1 ==> External clock bypass mode. This enables the crystal oscillator's external clock bypass mode and allows an external clock source on the EXTAL input of the oscillator to propagate directly to the oscillator's clock output.

 set     OCCS_OSCTL1_COHL            BIT13
;;   Crystal Oscillator High/Low Power Level
;;     0b0 ==> High power mode.
;;     0b1 ==> Low power mode.

 set     OCCS_OSCTL1_ROSB            BIT14
;;   8 MHz Relaxation Oscillator Standby
;;     0b0 ==> Normal mode. The relaxation oscillator output frequency is 8 MHz.
;;     0b1 ==> Standby mode. The relaxation oscillator output frequency is reduced to 400 kHz (+/-50%). The PLL should be disabled in this mode and MSTR_OSC should be selected as the output clock.

 set     OCCS_OSCTL1_ROPD            BIT15
;;   8 MHz Relaxation Oscillator Power Down
;;     0b0 ==> Relaxation oscillator enabled.
;;     0b1 ==> Relaxation oscillator powered down.

 set     OCCS_OSCTL2_FREQ_TRIM32K    (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
;;   32 kHz Internal RC Oscillator Frequency Trim
 set     OCCS_OSCTL2_FREQ_TRIM32K_0  BIT0
 set     OCCS_OSCTL2_FREQ_TRIM32K_1  BIT1
 set     OCCS_OSCTL2_FREQ_TRIM32K_2  BIT2
 set     OCCS_OSCTL2_FREQ_TRIM32K_3  BIT3
 set     OCCS_OSCTL2_FREQ_TRIM32K_4  BIT4
 set     OCCS_OSCTL2_FREQ_TRIM32K_5  BIT5
 set     OCCS_OSCTL2_FREQ_TRIM32K_6  BIT6
 set     OCCS_OSCTL2_FREQ_TRIM32K_7  BIT7
 set     OCCS_OSCTL2_FREQ_TRIM32K_8  BIT8

 set     OCCS_OSCTL2_MON_ENABLE      BIT9
;;   XOSC Clock Monitor Enable Control

 set     OCCS_OSCTL2_TEMP_TRIM8M     (BIT10|BIT11|BIT12|BIT13)
;;   8 MHz Internal Relaxation Oscillator Temperature Trim
 set     OCCS_OSCTL2_TEMP_TRIM8M_0   BIT10
 set     OCCS_OSCTL2_TEMP_TRIM8M_1   BIT11
 set     OCCS_OSCTL2_TEMP_TRIM8M_2   BIT12
 set     OCCS_OSCTL2_TEMP_TRIM8M_3   BIT13

 set     OCCS_OSCTL2_COPD            BIT14
;;   Crystal Oscillator Power Down
;;     0b0 ==> Crystal oscillator enabled.
;;     0b1 ==> Crystal oscillator powered down.

 set     OCCS_OSCTL2_ROPD32K         BIT15
;;   32 kHz RC Oscillator Power Down

 set     OCCS_CLKCHKR_REF_CNT        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6)
;;   Reference Count
 set     OCCS_CLKCHKR_REF_CNT_0      BIT0
 set     OCCS_CLKCHKR_REF_CNT_1      BIT1
 set     OCCS_CLKCHKR_REF_CNT_2      BIT2
 set     OCCS_CLKCHKR_REF_CNT_3      BIT3
 set     OCCS_CLKCHKR_REF_CNT_4      BIT4
 set     OCCS_CLKCHKR_REF_CNT_5      BIT5
 set     OCCS_CLKCHKR_REF_CNT_6      BIT6

 set     OCCS_CLKCHKR_CHK_ENA        BIT15
;;   Check Enable
;;     0b0 ==> Writing a low while the clock checking operation is in progress stops the check in its current state. Reading a low after a check has been started indicates that the check operation is complete and the final values are valid in the REF_CNT and TARGET_CNT fields.
;;     0b1 ==> Writing a one clears the REF_CNT and TARGET_CNT fields and starts the clock checking function. The CLK_ENA bit remains high while the operation is in progress.

 set     OCCS_CLKCHKT_TARGET_CNT     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   CLKCHKT Target Count
 set     OCCS_CLKCHKT_TARGET_CNT_0   BIT0
 set     OCCS_CLKCHKT_TARGET_CNT_1   BIT1
 set     OCCS_CLKCHKT_TARGET_CNT_2   BIT2
 set     OCCS_CLKCHKT_TARGET_CNT_3   BIT3
 set     OCCS_CLKCHKT_TARGET_CNT_4   BIT4
 set     OCCS_CLKCHKT_TARGET_CNT_5   BIT5
 set     OCCS_CLKCHKT_TARGET_CNT_6   BIT6
 set     OCCS_CLKCHKT_TARGET_CNT_7   BIT7
 set     OCCS_CLKCHKT_TARGET_CNT_8   BIT8
 set     OCCS_CLKCHKT_TARGET_CNT_9   BIT9
 set     OCCS_CLKCHKT_TARGET_CNT_10  BIT10

 set     OCCS_PROT_PLLEP             (BIT0|BIT1)
;;   PLL Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     OCCS_PROT_PLLEP_0           BIT0
 set     OCCS_PROT_PLLEP_1           BIT1

 set     OCCS_PROT_OSCEP             (BIT2|BIT3)
;;   Oscillator Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     OCCS_PROT_OSCEP_0           BIT2
 set     OCCS_PROT_OSCEP_1           BIT3

 set     OCCS_PROT_FRQEP             (BIT4|BIT5)
;;   Frequency Enable Protection
;;     0b00 ==> Write protection off (default).
;;     0b01 ==> Write protection on.
;;     0b10 ==> Write protection off and locked until chip reset.
;;     0b11 ==> Write protection on and locked until chip reset.
 set     OCCS_PROT_FRQEP_0           BIT4
 set     OCCS_PROT_FRQEP_1           BIT5

 set     PDB0_MCTRL_PDBEN            BIT0
;;   PDB Module Enable
;;     0b0 ==> Counter is off and all Trigger and PreTrigger outputs are low.
;;     0b1 ==> Counter is enabled.

 set     PDB0_MCTRL_TRIGSEL          (BIT4|BIT5|BIT6)
;;   Input Trigger Select
;;     0b000 ==> TriggerIn0 is selected.
;;     0b001 ==> TriggerIn1 is selected.
;;     0b010 ==> TriggerIn2 is selected.
;;     0b011 ==> TriggerIn3 is selected.
;;     0b100 ==> TriggerIn4 is selected.
;;     0b101 ==> TriggerIn5 is selected.
;;     0b110 ==> TriggerIn6 is selected.
;;     0b111 ==> SWTRIG is selected.
 set     PDB0_MCTRL_TRIGSEL_0        BIT4
 set     PDB0_MCTRL_TRIGSEL_1        BIT5
 set     PDB0_MCTRL_TRIGSEL_2        BIT6

 set     PDB0_MCTRL_SWTRIG           BIT7
;;   Software Trigger

 set     PDB0_MCTRL_COIE             BIT8
;;   Counter Overflow Interrupt Enable
;;     0b0 ==> Counter roll over interrupt requests disabled.
;;     0b1 ==> Counter roll over interrupt requests enabled.

 set     PDB0_MCTRL_COF              BIT9
;;   Counter Overflow Flag

 set     PDB0_MCTRL_CONT             BIT10
;;   Continuous Mode Enable
;;     0b0 ==> Module is in one-shot mode.
;;     0b1 ==> Module is in continuous mode.

 set     PDB0_MCTRL_LDOK             BIT11
;;   Load OK

 set     PDB0_MCTRL_LDMOD            BIT12
;;   Load Mode Select
;;     0b0 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect immediately after logic 1 is written to the MCTRL[LDOK] bit.
;;     0b1 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect when the counter rolls over or a trigger signal is received after logic 1 is written to the MCTRL[LDOK] bit.

 set     PDB0_MCTRL_PRESCALER        (BIT13|BIT14|BIT15)
;;   Clock Prescaler Select
;;     0b000 ==> Timer uses peripheral clock.
;;     0b001 ==> Timer uses peripheral clock / 2.
;;     0b010 ==> Timer uses peripheral clock / 4.
;;     0b011 ==> Timer uses peripheral clock / 8.
;;     0b100 ==> Timer uses peripheral clock / 16.
;;     0b101 ==> Timer uses peripheral clock / 32.
;;     0b110 ==> Timer uses peripheral clock / 64.
;;     0b111 ==> Timer uses peripheral clock / 128.
 set     PDB0_MCTRL_PRESCALER_0      BIT13
 set     PDB0_MCTRL_PRESCALER_1      BIT14
 set     PDB0_MCTRL_PRESCALER_2      BIT15

 set     PDB0_CTRLA_ENB              BIT0
;;   Trigger B Enable
;;     0b0 ==> Trigger B is disabled and forced to 0.
;;     0b1 ==> Trigger B is enabled.

 set     PDB0_CTRLA_ENA              BIT1
;;   Trigger A Enable
;;     0b0 ==> Trigger A is disabled and forced to 0.
;;     0b1 ==> Trigger A is enabled.

 set     PDB0_CTRLA_BYPB             BIT2
;;   Bypass B
;;     0b0 ==> Trigger B is generated normally.
;;     0b1 ==> Trigger B generation is bypassed and Trigger B is a single pulse created by the selected trigger source.

 set     PDB0_CTRLA_BYPA             BIT3
;;   Bypass A
;;     0b0 ==> Trigger A is generated normally.
;;     0b1 ==> Trigger A generation is bypassed and Trigger A is a single pulse created by the selected trigger source.

 set     PDB0_CTRLA_ABSEL            BIT4
;;   Trigger A Output Select
;;     0b0 ==> Trigger A is a function of DELAYA only. Trigger B is a function of DELAYB only.
;;     0b1 ==> Trigger A and Trigger B outputs are a function of combined DELAYA and DELAYB. Trigger A is an extended pulse (as in trigger pulsed output operation) and Trigger B is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

 set     PDB0_CTRLA_AINIT            BIT5
;;   Initial Value A

 set     PDB0_CTRLA_DBIE             BIT8
;;   Delay B Interrupt Enable
;;     0b0 ==> DELAYB successful compare interrupt requests disabled.
;;     0b1 ==> DELAYB successful compare interrupt requests enabled.

 set     PDB0_CTRLA_DBF              BIT9
;;   Delay B Flag

 set     PDB0_CTRLA_DAIE             BIT10
;;   Delay A Interrupt Enable
;;     0b0 ==> DELAYA successful compare interrupt requests disabled.
;;     0b1 ==> DELAYA successful compare interrupt requests enabled.

 set     PDB0_CTRLA_DAF              BIT11
;;   Delay A Flag

 set     PDB0_CTRLA_FLENA            BIT12
;;   Fault A Length
;;     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
;;     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

 set     PDB0_CTRLA_FPOLA            BIT13
;;   Fault A Polarity
;;     0b0 ==> A logic 0 on Fault A indicates a fault condition
;;     0b1 ==> A logic 1 on Fault A indicates a fault condition.

 set     PDB0_CTRLA_FLTAEN           BIT14
;;   Fault A Enable
;;     0b0 ==> Fault A input is ignored.
;;     0b1 ==> A logic 1 on the Fault A input forces TriggerA output to CTRLA[AINIT] until a counter reload occurs.

 set     PDB0_CTRLA_FLTA             BIT15
;;   Fault A Input Status

 set     PDB0_CTRLC_END              BIT0
;;   Trigger D Enable
;;     0b0 ==> Trigger D is disabled and forced to 0.
;;     0b1 ==> Trigger D is enabled.

 set     PDB0_CTRLC_ENC              BIT1
;;   Trigger C Enable
;;     0b0 ==> Trigger C is disabled and forced to 0.
;;     0b1 ==> Trigger C is enabled.

 set     PDB0_CTRLC_BYPD             BIT2
;;   Bypass D
;;     0b0 ==> Trigger D is generated normally.
;;     0b1 ==> Trigger D generation is bypassed and Trigger D is a single pulse created by the selected trigger source.

 set     PDB0_CTRLC_BYPC             BIT3
;;   Bypass C
;;     0b0 ==> Trigger C is generated normally.
;;     0b1 ==> Trigger C generation is bypassed and Trigger C is a single pulse created by the selected trigger source.

 set     PDB0_CTRLC_CDSEL            BIT4
;;   Trigger C Output Select
;;     0b0 ==> Trigger C is a function of DELAYC only. Trigger D is a function of DELAYD only.
;;     0b1 ==> Trigger C and Trigger D outputs are a function of combined DELAYC and DELAYD. Trigger C is an extended pulse (as in trigger pulsed output operation) and Trigger D is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

 set     PDB0_CTRLC_CINIT            BIT5
;;   Initial Value C

 set     PDB0_CTRLC_DDIE             BIT8
;;   Delay D Interrupt Enable
;;     0b0 ==> DELAYD successful compare interrupt requests disabled.
;;     0b1 ==> DELAYD successful compare interrupt requests enabled.

 set     PDB0_CTRLC_DDF              BIT9
;;   Delay D Flag

 set     PDB0_CTRLC_DCIE             BIT10
;;   Delay C Interrupt Enable
;;     0b0 ==> DELAYC successful compare interrupt requests disabled.
;;     0b1 ==> DELAYC successful compare interrupt requests enabled.

 set     PDB0_CTRLC_DCF              BIT11
;;   Delay C Flag

 set     PDB0_CTRLC_FLENC            BIT12
;;   Fault C Length
;;     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
;;     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

 set     PDB0_CTRLC_FPOLC            BIT13
;;   Fault C Polarity
;;     0b0 ==> A logic 0 on Fault C indicates a fault condition.
;;     0b1 ==> A logic 1 on Fault C indicates a fault condition.

 set     PDB0_CTRLC_FLTCEN           BIT14
;;   Fault C Enable.
;;     0b0 ==> Fault C input is ignored.
;;     0b1 ==> A logic 1 on the Fault C input forces Trigger C output to CTRLC[CINIT] until a counter reload occurs.

 set     PDB0_CTRLC_FLTC             BIT15
;;   Fault C Input Status

 set     PDB0_DELAYA_DELAYA          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay A
 set     PDB0_DELAYA_DELAYA_0        BIT0
 set     PDB0_DELAYA_DELAYA_1        BIT1
 set     PDB0_DELAYA_DELAYA_2        BIT2
 set     PDB0_DELAYA_DELAYA_3        BIT3
 set     PDB0_DELAYA_DELAYA_4        BIT4
 set     PDB0_DELAYA_DELAYA_5        BIT5
 set     PDB0_DELAYA_DELAYA_6        BIT6
 set     PDB0_DELAYA_DELAYA_7        BIT7
 set     PDB0_DELAYA_DELAYA_8        BIT8
 set     PDB0_DELAYA_DELAYA_9        BIT9
 set     PDB0_DELAYA_DELAYA_10       BIT10
 set     PDB0_DELAYA_DELAYA_11       BIT11
 set     PDB0_DELAYA_DELAYA_12       BIT12
 set     PDB0_DELAYA_DELAYA_13       BIT13
 set     PDB0_DELAYA_DELAYA_14       BIT14
 set     PDB0_DELAYA_DELAYA_15       BIT15

 set     PDB0_DELAYB_DELAYB          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay B
 set     PDB0_DELAYB_DELAYB_0        BIT0
 set     PDB0_DELAYB_DELAYB_1        BIT1
 set     PDB0_DELAYB_DELAYB_2        BIT2
 set     PDB0_DELAYB_DELAYB_3        BIT3
 set     PDB0_DELAYB_DELAYB_4        BIT4
 set     PDB0_DELAYB_DELAYB_5        BIT5
 set     PDB0_DELAYB_DELAYB_6        BIT6
 set     PDB0_DELAYB_DELAYB_7        BIT7
 set     PDB0_DELAYB_DELAYB_8        BIT8
 set     PDB0_DELAYB_DELAYB_9        BIT9
 set     PDB0_DELAYB_DELAYB_10       BIT10
 set     PDB0_DELAYB_DELAYB_11       BIT11
 set     PDB0_DELAYB_DELAYB_12       BIT12
 set     PDB0_DELAYB_DELAYB_13       BIT13
 set     PDB0_DELAYB_DELAYB_14       BIT14
 set     PDB0_DELAYB_DELAYB_15       BIT15

 set     PDB0_DELAYC_DELAYC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay C
 set     PDB0_DELAYC_DELAYC_0        BIT0
 set     PDB0_DELAYC_DELAYC_1        BIT1
 set     PDB0_DELAYC_DELAYC_2        BIT2
 set     PDB0_DELAYC_DELAYC_3        BIT3
 set     PDB0_DELAYC_DELAYC_4        BIT4
 set     PDB0_DELAYC_DELAYC_5        BIT5
 set     PDB0_DELAYC_DELAYC_6        BIT6
 set     PDB0_DELAYC_DELAYC_7        BIT7
 set     PDB0_DELAYC_DELAYC_8        BIT8
 set     PDB0_DELAYC_DELAYC_9        BIT9
 set     PDB0_DELAYC_DELAYC_10       BIT10
 set     PDB0_DELAYC_DELAYC_11       BIT11
 set     PDB0_DELAYC_DELAYC_12       BIT12
 set     PDB0_DELAYC_DELAYC_13       BIT13
 set     PDB0_DELAYC_DELAYC_14       BIT14
 set     PDB0_DELAYC_DELAYC_15       BIT15

 set     PDB0_DELAYD_DELAYD          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay D
 set     PDB0_DELAYD_DELAYD_0        BIT0
 set     PDB0_DELAYD_DELAYD_1        BIT1
 set     PDB0_DELAYD_DELAYD_2        BIT2
 set     PDB0_DELAYD_DELAYD_3        BIT3
 set     PDB0_DELAYD_DELAYD_4        BIT4
 set     PDB0_DELAYD_DELAYD_5        BIT5
 set     PDB0_DELAYD_DELAYD_6        BIT6
 set     PDB0_DELAYD_DELAYD_7        BIT7
 set     PDB0_DELAYD_DELAYD_8        BIT8
 set     PDB0_DELAYD_DELAYD_9        BIT9
 set     PDB0_DELAYD_DELAYD_10       BIT10
 set     PDB0_DELAYD_DELAYD_11       BIT11
 set     PDB0_DELAYD_DELAYD_12       BIT12
 set     PDB0_DELAYD_DELAYD_13       BIT13
 set     PDB0_DELAYD_DELAYD_14       BIT14
 set     PDB0_DELAYD_DELAYD_15       BIT15

 set     PDB0_MOD_MOD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PDB0_MOD_MOD_0              BIT0
 set     PDB0_MOD_MOD_1              BIT1
 set     PDB0_MOD_MOD_2              BIT2
 set     PDB0_MOD_MOD_3              BIT3
 set     PDB0_MOD_MOD_4              BIT4
 set     PDB0_MOD_MOD_5              BIT5
 set     PDB0_MOD_MOD_6              BIT6
 set     PDB0_MOD_MOD_7              BIT7
 set     PDB0_MOD_MOD_8              BIT8
 set     PDB0_MOD_MOD_9              BIT9
 set     PDB0_MOD_MOD_10             BIT10
 set     PDB0_MOD_MOD_11             BIT11
 set     PDB0_MOD_MOD_12             BIT12
 set     PDB0_MOD_MOD_13             BIT13
 set     PDB0_MOD_MOD_14             BIT14
 set     PDB0_MOD_MOD_15             BIT15

 set     PDB0_CNTR_COUNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PDB0_CNTR_COUNT_0           BIT0
 set     PDB0_CNTR_COUNT_1           BIT1
 set     PDB0_CNTR_COUNT_2           BIT2
 set     PDB0_CNTR_COUNT_3           BIT3
 set     PDB0_CNTR_COUNT_4           BIT4
 set     PDB0_CNTR_COUNT_5           BIT5
 set     PDB0_CNTR_COUNT_6           BIT6
 set     PDB0_CNTR_COUNT_7           BIT7
 set     PDB0_CNTR_COUNT_8           BIT8
 set     PDB0_CNTR_COUNT_9           BIT9
 set     PDB0_CNTR_COUNT_10          BIT10
 set     PDB0_CNTR_COUNT_11          BIT11
 set     PDB0_CNTR_COUNT_12          BIT12
 set     PDB0_CNTR_COUNT_13          BIT13
 set     PDB0_CNTR_COUNT_14          BIT14
 set     PDB0_CNTR_COUNT_15          BIT15

 set     PDB1_MCTRL_PDBEN            BIT0
;;   PDB Module Enable
;;     0b0 ==> Counter is off and all Trigger and PreTrigger outputs are low.
;;     0b1 ==> Counter is enabled.

 set     PDB1_MCTRL_TRIGSEL          (BIT4|BIT5|BIT6)
;;   Input Trigger Select
;;     0b000 ==> TriggerIn0 is selected.
;;     0b001 ==> TriggerIn1 is selected.
;;     0b010 ==> TriggerIn2 is selected.
;;     0b011 ==> TriggerIn3 is selected.
;;     0b100 ==> TriggerIn4 is selected.
;;     0b101 ==> TriggerIn5 is selected.
;;     0b110 ==> TriggerIn6 is selected.
;;     0b111 ==> SWTRIG is selected.
 set     PDB1_MCTRL_TRIGSEL_0        BIT4
 set     PDB1_MCTRL_TRIGSEL_1        BIT5
 set     PDB1_MCTRL_TRIGSEL_2        BIT6

 set     PDB1_MCTRL_SWTRIG           BIT7
;;   Software Trigger

 set     PDB1_MCTRL_COIE             BIT8
;;   Counter Overflow Interrupt Enable
;;     0b0 ==> Counter roll over interrupt requests disabled.
;;     0b1 ==> Counter roll over interrupt requests enabled.

 set     PDB1_MCTRL_COF              BIT9
;;   Counter Overflow Flag

 set     PDB1_MCTRL_CONT             BIT10
;;   Continuous Mode Enable
;;     0b0 ==> Module is in one-shot mode.
;;     0b1 ==> Module is in continuous mode.

 set     PDB1_MCTRL_LDOK             BIT11
;;   Load OK

 set     PDB1_MCTRL_LDMOD            BIT12
;;   Load Mode Select
;;     0b0 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect immediately after logic 1 is written to the MCTRL[LDOK] bit.
;;     0b1 ==> DELAY* and MOD registers are loaded into a set of buffers and take effect when the counter rolls over or a trigger signal is received after logic 1 is written to the MCTRL[LDOK] bit.

 set     PDB1_MCTRL_PRESCALER        (BIT13|BIT14|BIT15)
;;   Clock Prescaler Select
;;     0b000 ==> Timer uses peripheral clock.
;;     0b001 ==> Timer uses peripheral clock / 2.
;;     0b010 ==> Timer uses peripheral clock / 4.
;;     0b011 ==> Timer uses peripheral clock / 8.
;;     0b100 ==> Timer uses peripheral clock / 16.
;;     0b101 ==> Timer uses peripheral clock / 32.
;;     0b110 ==> Timer uses peripheral clock / 64.
;;     0b111 ==> Timer uses peripheral clock / 128.
 set     PDB1_MCTRL_PRESCALER_0      BIT13
 set     PDB1_MCTRL_PRESCALER_1      BIT14
 set     PDB1_MCTRL_PRESCALER_2      BIT15

 set     PDB1_CTRLA_ENB              BIT0
;;   Trigger B Enable
;;     0b0 ==> Trigger B is disabled and forced to 0.
;;     0b1 ==> Trigger B is enabled.

 set     PDB1_CTRLA_ENA              BIT1
;;   Trigger A Enable
;;     0b0 ==> Trigger A is disabled and forced to 0.
;;     0b1 ==> Trigger A is enabled.

 set     PDB1_CTRLA_BYPB             BIT2
;;   Bypass B
;;     0b0 ==> Trigger B is generated normally.
;;     0b1 ==> Trigger B generation is bypassed and Trigger B is a single pulse created by the selected trigger source.

 set     PDB1_CTRLA_BYPA             BIT3
;;   Bypass A
;;     0b0 ==> Trigger A is generated normally.
;;     0b1 ==> Trigger A generation is bypassed and Trigger A is a single pulse created by the selected trigger source.

 set     PDB1_CTRLA_ABSEL            BIT4
;;   Trigger A Output Select
;;     0b0 ==> Trigger A is a function of DELAYA only. Trigger B is a function of DELAYB only.
;;     0b1 ==> Trigger A and Trigger B outputs are a function of combined DELAYA and DELAYB. Trigger A is an extended pulse (as in trigger pulsed output operation) and Trigger B is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

 set     PDB1_CTRLA_AINIT            BIT5
;;   Initial Value A

 set     PDB1_CTRLA_DBIE             BIT8
;;   Delay B Interrupt Enable
;;     0b0 ==> DELAYB successful compare interrupt requests disabled.
;;     0b1 ==> DELAYB successful compare interrupt requests enabled.

 set     PDB1_CTRLA_DBF              BIT9
;;   Delay B Flag

 set     PDB1_CTRLA_DAIE             BIT10
;;   Delay A Interrupt Enable
;;     0b0 ==> DELAYA successful compare interrupt requests disabled.
;;     0b1 ==> DELAYA successful compare interrupt requests enabled.

 set     PDB1_CTRLA_DAF              BIT11
;;   Delay A Flag

 set     PDB1_CTRLA_FLENA            BIT12
;;   Fault A Length
;;     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
;;     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

 set     PDB1_CTRLA_FPOLA            BIT13
;;   Fault A Polarity
;;     0b0 ==> A logic 0 on Fault A indicates a fault condition
;;     0b1 ==> A logic 1 on Fault A indicates a fault condition.

 set     PDB1_CTRLA_FLTAEN           BIT14
;;   Fault A Enable
;;     0b0 ==> Fault A input is ignored.
;;     0b1 ==> A logic 1 on the Fault A input forces TriggerA output to CTRLA[AINIT] until a counter reload occurs.

 set     PDB1_CTRLA_FLTA             BIT15
;;   Fault A Input Status

 set     PDB1_CTRLC_END              BIT0
;;   Trigger D Enable
;;     0b0 ==> Trigger D is disabled and forced to 0.
;;     0b1 ==> Trigger D is enabled.

 set     PDB1_CTRLC_ENC              BIT1
;;   Trigger C Enable
;;     0b0 ==> Trigger C is disabled and forced to 0.
;;     0b1 ==> Trigger C is enabled.

 set     PDB1_CTRLC_BYPD             BIT2
;;   Bypass D
;;     0b0 ==> Trigger D is generated normally.
;;     0b1 ==> Trigger D generation is bypassed and Trigger D is a single pulse created by the selected trigger source.

 set     PDB1_CTRLC_BYPC             BIT3
;;   Bypass C
;;     0b0 ==> Trigger C is generated normally.
;;     0b1 ==> Trigger C generation is bypassed and Trigger C is a single pulse created by the selected trigger source.

 set     PDB1_CTRLC_CDSEL            BIT4
;;   Trigger C Output Select
;;     0b0 ==> Trigger C is a function of DELAYC only. Trigger D is a function of DELAYD only.
;;     0b1 ==> Trigger C and Trigger D outputs are a function of combined DELAYC and DELAYD. Trigger C is an extended pulse (as in trigger pulsed output operation) and Trigger D is a dual pulse (as in two-shot mode with trigger configured for simultaneous sampling).

 set     PDB1_CTRLC_CINIT            BIT5
;;   Initial Value C

 set     PDB1_CTRLC_DDIE             BIT8
;;   Delay D Interrupt Enable
;;     0b0 ==> DELAYD successful compare interrupt requests disabled.
;;     0b1 ==> DELAYD successful compare interrupt requests enabled.

 set     PDB1_CTRLC_DDF              BIT9
;;   Delay D Flag

 set     PDB1_CTRLC_DCIE             BIT10
;;   Delay C Interrupt Enable
;;     0b0 ==> DELAYC successful compare interrupt requests disabled.
;;     0b1 ==> DELAYC successful compare interrupt requests enabled.

 set     PDB1_CTRLC_DCF              BIT11
;;   Delay C Flag

 set     PDB1_CTRLC_FLENC            BIT12
;;   Fault C Length
;;     0b0 ==> Fault input must be active at least 2 IPBus clock cycles.
;;     0b1 ==> Fault input must be active at least 4 IPBus clock cycles.

 set     PDB1_CTRLC_FPOLC            BIT13
;;   Fault C Polarity
;;     0b0 ==> A logic 0 on Fault C indicates a fault condition.
;;     0b1 ==> A logic 1 on Fault C indicates a fault condition.

 set     PDB1_CTRLC_FLTCEN           BIT14
;;   Fault C Enable.
;;     0b0 ==> Fault C input is ignored.
;;     0b1 ==> A logic 1 on the Fault C input forces Trigger C output to CTRLC[CINIT] until a counter reload occurs.

 set     PDB1_CTRLC_FLTC             BIT15
;;   Fault C Input Status

 set     PDB1_DELAYA_DELAYA          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay A
 set     PDB1_DELAYA_DELAYA_0        BIT0
 set     PDB1_DELAYA_DELAYA_1        BIT1
 set     PDB1_DELAYA_DELAYA_2        BIT2
 set     PDB1_DELAYA_DELAYA_3        BIT3
 set     PDB1_DELAYA_DELAYA_4        BIT4
 set     PDB1_DELAYA_DELAYA_5        BIT5
 set     PDB1_DELAYA_DELAYA_6        BIT6
 set     PDB1_DELAYA_DELAYA_7        BIT7
 set     PDB1_DELAYA_DELAYA_8        BIT8
 set     PDB1_DELAYA_DELAYA_9        BIT9
 set     PDB1_DELAYA_DELAYA_10       BIT10
 set     PDB1_DELAYA_DELAYA_11       BIT11
 set     PDB1_DELAYA_DELAYA_12       BIT12
 set     PDB1_DELAYA_DELAYA_13       BIT13
 set     PDB1_DELAYA_DELAYA_14       BIT14
 set     PDB1_DELAYA_DELAYA_15       BIT15

 set     PDB1_DELAYB_DELAYB          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay B
 set     PDB1_DELAYB_DELAYB_0        BIT0
 set     PDB1_DELAYB_DELAYB_1        BIT1
 set     PDB1_DELAYB_DELAYB_2        BIT2
 set     PDB1_DELAYB_DELAYB_3        BIT3
 set     PDB1_DELAYB_DELAYB_4        BIT4
 set     PDB1_DELAYB_DELAYB_5        BIT5
 set     PDB1_DELAYB_DELAYB_6        BIT6
 set     PDB1_DELAYB_DELAYB_7        BIT7
 set     PDB1_DELAYB_DELAYB_8        BIT8
 set     PDB1_DELAYB_DELAYB_9        BIT9
 set     PDB1_DELAYB_DELAYB_10       BIT10
 set     PDB1_DELAYB_DELAYB_11       BIT11
 set     PDB1_DELAYB_DELAYB_12       BIT12
 set     PDB1_DELAYB_DELAYB_13       BIT13
 set     PDB1_DELAYB_DELAYB_14       BIT14
 set     PDB1_DELAYB_DELAYB_15       BIT15

 set     PDB1_DELAYC_DELAYC          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay C
 set     PDB1_DELAYC_DELAYC_0        BIT0
 set     PDB1_DELAYC_DELAYC_1        BIT1
 set     PDB1_DELAYC_DELAYC_2        BIT2
 set     PDB1_DELAYC_DELAYC_3        BIT3
 set     PDB1_DELAYC_DELAYC_4        BIT4
 set     PDB1_DELAYC_DELAYC_5        BIT5
 set     PDB1_DELAYC_DELAYC_6        BIT6
 set     PDB1_DELAYC_DELAYC_7        BIT7
 set     PDB1_DELAYC_DELAYC_8        BIT8
 set     PDB1_DELAYC_DELAYC_9        BIT9
 set     PDB1_DELAYC_DELAYC_10       BIT10
 set     PDB1_DELAYC_DELAYC_11       BIT11
 set     PDB1_DELAYC_DELAYC_12       BIT12
 set     PDB1_DELAYC_DELAYC_13       BIT13
 set     PDB1_DELAYC_DELAYC_14       BIT14
 set     PDB1_DELAYC_DELAYC_15       BIT15

 set     PDB1_DELAYD_DELAYD          (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Delay D
 set     PDB1_DELAYD_DELAYD_0        BIT0
 set     PDB1_DELAYD_DELAYD_1        BIT1
 set     PDB1_DELAYD_DELAYD_2        BIT2
 set     PDB1_DELAYD_DELAYD_3        BIT3
 set     PDB1_DELAYD_DELAYD_4        BIT4
 set     PDB1_DELAYD_DELAYD_5        BIT5
 set     PDB1_DELAYD_DELAYD_6        BIT6
 set     PDB1_DELAYD_DELAYD_7        BIT7
 set     PDB1_DELAYD_DELAYD_8        BIT8
 set     PDB1_DELAYD_DELAYD_9        BIT9
 set     PDB1_DELAYD_DELAYD_10       BIT10
 set     PDB1_DELAYD_DELAYD_11       BIT11
 set     PDB1_DELAYD_DELAYD_12       BIT12
 set     PDB1_DELAYD_DELAYD_13       BIT13
 set     PDB1_DELAYD_DELAYD_14       BIT14
 set     PDB1_DELAYD_DELAYD_15       BIT15

 set     PDB1_MOD_MOD                (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PDB1_MOD_MOD_0              BIT0
 set     PDB1_MOD_MOD_1              BIT1
 set     PDB1_MOD_MOD_2              BIT2
 set     PDB1_MOD_MOD_3              BIT3
 set     PDB1_MOD_MOD_4              BIT4
 set     PDB1_MOD_MOD_5              BIT5
 set     PDB1_MOD_MOD_6              BIT6
 set     PDB1_MOD_MOD_7              BIT7
 set     PDB1_MOD_MOD_8              BIT8
 set     PDB1_MOD_MOD_9              BIT9
 set     PDB1_MOD_MOD_10             BIT10
 set     PDB1_MOD_MOD_11             BIT11
 set     PDB1_MOD_MOD_12             BIT12
 set     PDB1_MOD_MOD_13             BIT13
 set     PDB1_MOD_MOD_14             BIT14
 set     PDB1_MOD_MOD_15             BIT15

 set     PDB1_CNTR_COUNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PDB1_CNTR_COUNT_0           BIT0
 set     PDB1_CNTR_COUNT_1           BIT1
 set     PDB1_CNTR_COUNT_2           BIT2
 set     PDB1_CNTR_COUNT_3           BIT3
 set     PDB1_CNTR_COUNT_4           BIT4
 set     PDB1_CNTR_COUNT_5           BIT5
 set     PDB1_CNTR_COUNT_6           BIT6
 set     PDB1_CNTR_COUNT_7           BIT7
 set     PDB1_CNTR_COUNT_8           BIT8
 set     PDB1_CNTR_COUNT_9           BIT9
 set     PDB1_CNTR_COUNT_10          BIT10
 set     PDB1_CNTR_COUNT_11          BIT11
 set     PDB1_CNTR_COUNT_12          BIT12
 set     PDB1_CNTR_COUNT_13          BIT13
 set     PDB1_CNTR_COUNT_14          BIT14
 set     PDB1_CNTR_COUNT_15          BIT15

 set     PIT0_CTRL_CNT_EN            BIT0
;;   Count Enable
;;     0b0 ==> PIT counter reset (default).
;;     0b1 ==> PIT counter active.

 set     PIT0_CTRL_PRIE              BIT1
;;   PIT Roll-Over Interrupt Enable.
;;     0b0 ==> PIT roll-over interrupt disabled (default).
;;     0b1 ==> PIT roll-over interrupt enabled.

 set     PIT0_CTRL_PRF               BIT2
;;   PIT Roll-Over Flag.
;;     0b0 ==> PIT counter has not reached the modulo value. (default)
;;     0b1 ==> PIT counter has reached the modulo value.

 set     PIT0_CTRL_PRESCALER         (BIT3|BIT4|BIT5|BIT6)
;;     0b0000 ==> Clock
;;     0b0001 ==> Clock divided by 2
;;     0b0010 ==> Clock divided by 4
;;     0b0011 ==> Clock divided by 8
;;     0b0100 ==> Clock divided by 16
;;     0b0101 ==> Clock divided by 32
;;     0b0110 ==> Clock divided by 64
;;     0b0111 ==> Clock divided by 128
;;     0b1000 ==> Clock divided by 256
;;     0b1001 ==> Clock divided by 512
;;     0b1010 ==> Clock divided by 1024
;;     0b1011 ==> Clock divided by 2048
;;     0b1100 ==> Clock divided by 4096
;;     0b1101 ==> Clock divided by 8192
;;     0b1110 ==> Clock divided by 16384
;;     0b1111 ==> Clock divided by 32768
 set     PIT0_CTRL_PRESCALER_0       BIT3
 set     PIT0_CTRL_PRESCALER_1       BIT4
 set     PIT0_CTRL_PRESCALER_2       BIT5
 set     PIT0_CTRL_PRESCALER_3       BIT6

 set     PIT0_CTRL_CLKSEL            (BIT8|BIT9)
;;     0b00 ==> Selects IPBus clock
;;     0b01 ==> Selects alternate clock 1
;;     0b10 ==> Selects alternate clock 2
;;     0b11 ==> Selects alternate clock 3
 set     PIT0_CTRL_CLKSEL_0          BIT8
 set     PIT0_CTRL_CLKSEL_1          BIT9

 set     PIT0_CTRL_SLAVE             BIT15
;;     0b0 ==> CNT_EN from this PIT is used to control operation (default).
;;     0b1 ==> CNT_EN from master PIT is used to control operation.

 set     PIT0_MOD_MODULO_VALUE       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT0_MOD_MODULO_VALUE_0     BIT0
 set     PIT0_MOD_MODULO_VALUE_1     BIT1
 set     PIT0_MOD_MODULO_VALUE_2     BIT2
 set     PIT0_MOD_MODULO_VALUE_3     BIT3
 set     PIT0_MOD_MODULO_VALUE_4     BIT4
 set     PIT0_MOD_MODULO_VALUE_5     BIT5
 set     PIT0_MOD_MODULO_VALUE_6     BIT6
 set     PIT0_MOD_MODULO_VALUE_7     BIT7
 set     PIT0_MOD_MODULO_VALUE_8     BIT8
 set     PIT0_MOD_MODULO_VALUE_9     BIT9
 set     PIT0_MOD_MODULO_VALUE_10    BIT10
 set     PIT0_MOD_MODULO_VALUE_11    BIT11
 set     PIT0_MOD_MODULO_VALUE_12    BIT12
 set     PIT0_MOD_MODULO_VALUE_13    BIT13
 set     PIT0_MOD_MODULO_VALUE_14    BIT14
 set     PIT0_MOD_MODULO_VALUE_15    BIT15

 set     PIT0_CNTR_COUNTER_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT0_CNTR_COUNTER_VALUE_0   BIT0
 set     PIT0_CNTR_COUNTER_VALUE_1   BIT1
 set     PIT0_CNTR_COUNTER_VALUE_2   BIT2
 set     PIT0_CNTR_COUNTER_VALUE_3   BIT3
 set     PIT0_CNTR_COUNTER_VALUE_4   BIT4
 set     PIT0_CNTR_COUNTER_VALUE_5   BIT5
 set     PIT0_CNTR_COUNTER_VALUE_6   BIT6
 set     PIT0_CNTR_COUNTER_VALUE_7   BIT7
 set     PIT0_CNTR_COUNTER_VALUE_8   BIT8
 set     PIT0_CNTR_COUNTER_VALUE_9   BIT9
 set     PIT0_CNTR_COUNTER_VALUE_10  BIT10
 set     PIT0_CNTR_COUNTER_VALUE_11  BIT11
 set     PIT0_CNTR_COUNTER_VALUE_12  BIT12
 set     PIT0_CNTR_COUNTER_VALUE_13  BIT13
 set     PIT0_CNTR_COUNTER_VALUE_14  BIT14
 set     PIT0_CNTR_COUNTER_VALUE_15  BIT15

 set     PIT1_CTRL_CNT_EN            BIT0
;;   Count Enable
;;     0b0 ==> PIT counter reset (default).
;;     0b1 ==> PIT counter active.

 set     PIT1_CTRL_PRIE              BIT1
;;   PIT Roll-Over Interrupt Enable.
;;     0b0 ==> PIT roll-over interrupt disabled (default).
;;     0b1 ==> PIT roll-over interrupt enabled.

 set     PIT1_CTRL_PRF               BIT2
;;   PIT Roll-Over Flag.
;;     0b0 ==> PIT counter has not reached the modulo value. (default)
;;     0b1 ==> PIT counter has reached the modulo value.

 set     PIT1_CTRL_PRESCALER         (BIT3|BIT4|BIT5|BIT6)
;;     0b0000 ==> Clock
;;     0b0001 ==> Clock divided by 2
;;     0b0010 ==> Clock divided by 4
;;     0b0011 ==> Clock divided by 8
;;     0b0100 ==> Clock divided by 16
;;     0b0101 ==> Clock divided by 32
;;     0b0110 ==> Clock divided by 64
;;     0b0111 ==> Clock divided by 128
;;     0b1000 ==> Clock divided by 256
;;     0b1001 ==> Clock divided by 512
;;     0b1010 ==> Clock divided by 1024
;;     0b1011 ==> Clock divided by 2048
;;     0b1100 ==> Clock divided by 4096
;;     0b1101 ==> Clock divided by 8192
;;     0b1110 ==> Clock divided by 16384
;;     0b1111 ==> Clock divided by 32768
 set     PIT1_CTRL_PRESCALER_0       BIT3
 set     PIT1_CTRL_PRESCALER_1       BIT4
 set     PIT1_CTRL_PRESCALER_2       BIT5
 set     PIT1_CTRL_PRESCALER_3       BIT6

 set     PIT1_CTRL_CLKSEL            (BIT8|BIT9)
;;     0b00 ==> Selects IPBus clock
;;     0b01 ==> Selects alternate clock 1
;;     0b10 ==> Selects alternate clock 2
;;     0b11 ==> Selects alternate clock 3
 set     PIT1_CTRL_CLKSEL_0          BIT8
 set     PIT1_CTRL_CLKSEL_1          BIT9

 set     PIT1_CTRL_SLAVE             BIT15
;;     0b0 ==> CNT_EN from this PIT is used to control operation (default).
;;     0b1 ==> CNT_EN from master PIT is used to control operation.

 set     PIT1_MOD_MODULO_VALUE       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT1_MOD_MODULO_VALUE_0     BIT0
 set     PIT1_MOD_MODULO_VALUE_1     BIT1
 set     PIT1_MOD_MODULO_VALUE_2     BIT2
 set     PIT1_MOD_MODULO_VALUE_3     BIT3
 set     PIT1_MOD_MODULO_VALUE_4     BIT4
 set     PIT1_MOD_MODULO_VALUE_5     BIT5
 set     PIT1_MOD_MODULO_VALUE_6     BIT6
 set     PIT1_MOD_MODULO_VALUE_7     BIT7
 set     PIT1_MOD_MODULO_VALUE_8     BIT8
 set     PIT1_MOD_MODULO_VALUE_9     BIT9
 set     PIT1_MOD_MODULO_VALUE_10    BIT10
 set     PIT1_MOD_MODULO_VALUE_11    BIT11
 set     PIT1_MOD_MODULO_VALUE_12    BIT12
 set     PIT1_MOD_MODULO_VALUE_13    BIT13
 set     PIT1_MOD_MODULO_VALUE_14    BIT14
 set     PIT1_MOD_MODULO_VALUE_15    BIT15

 set     PIT1_CNTR_COUNTER_VALUE     (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PIT1_CNTR_COUNTER_VALUE_0   BIT0
 set     PIT1_CNTR_COUNTER_VALUE_1   BIT1
 set     PIT1_CNTR_COUNTER_VALUE_2   BIT2
 set     PIT1_CNTR_COUNTER_VALUE_3   BIT3
 set     PIT1_CNTR_COUNTER_VALUE_4   BIT4
 set     PIT1_CNTR_COUNTER_VALUE_5   BIT5
 set     PIT1_CNTR_COUNTER_VALUE_6   BIT6
 set     PIT1_CNTR_COUNTER_VALUE_7   BIT7
 set     PIT1_CNTR_COUNTER_VALUE_8   BIT8
 set     PIT1_CNTR_COUNTER_VALUE_9   BIT9
 set     PIT1_CNTR_COUNTER_VALUE_10  BIT10
 set     PIT1_CNTR_COUNTER_VALUE_11  BIT11
 set     PIT1_CNTR_COUNTER_VALUE_12  BIT12
 set     PIT1_CNTR_COUNTER_VALUE_13  BIT13
 set     PIT1_CNTR_COUNTER_VALUE_14  BIT14
 set     PIT1_CNTR_COUNTER_VALUE_15  BIT15

 set     PMC_CTRL_LV22IE             BIT0
;;   2.2 V Low Voltage Interrupt Enable
;;     0b0 ==> Disable setting the low voltage interrupt.
;;     0b1 ==> Enable setting the low voltage interrupt.

 set     PMC_CTRL_LV27IE             BIT1
;;   2.7 V Low Voltage Interrupt Enable
;;     0b0 ==> Disable setting the low voltage interrupt.
;;     0b1 ==> Enable setting the low voltage interrupt.

 set     PMC_CTRL_HV22IE             BIT2
;;   2.2 V High Voltage Interrupt Enable
;;     0b0 ==> Disable setting the high voltage interrupt.
;;     0b1 ==> Enable setting the high voltage interrupt.

 set     PMC_CTRL_HV27IE             BIT3
;;   2.7 V High Voltage Interrupt Enable
;;     0b0 ==> Disable setting the high voltage interrupt.
;;     0b1 ==> Enable setting the high voltage interrupt.

 set     PMC_CTRL_VRBEN              BIT7
;;   Voltage Reference Buffer Enable
;;     0b0 ==> Disable voltage reference buffering.
;;     0b1 ==> Enable voltage reference buffering.

 set     PMC_CTRL_TRIM               (BIT12|BIT13|BIT14|BIT15)
;;   Bandgap Trim
 set     PMC_CTRL_TRIM_0             BIT12
 set     PMC_CTRL_TRIM_1             BIT13
 set     PMC_CTRL_TRIM_2             BIT14
 set     PMC_CTRL_TRIM_3             BIT15

 set     PMC_STS_LV22F               BIT0
;;   2.2 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply is not below the 2.2 V threshold.
;;     0b1 ==> 3.3 V supply is below the 2.2 V threshold.

 set     PMC_STS_LV27F               BIT1
;;   2.7 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply is not below the 2.7 V threshold.
;;     0b1 ==> 3.3 V supply is below the 2.7 V threshold.

 set     PMC_STS_SLV22F              BIT2
;;   Sticky 2.2 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply has not dropped below the 2.2 V threshold.
;;     0b1 ==> 3.3 V supply has dropped below the 2.2 V threshold.

 set     PMC_STS_SLV27F              BIT3
;;   Sticky 2.7 V Low Voltage Flag
;;     0b0 ==> 3.3 V supply has not dropped below the 2.7 V threshold.
;;     0b1 ==> 3.3 V supply has dropped below the 2.7 V threshold.

 set     PMC_STS_LVI                 BIT4
;;   Low Voltage Interrupt
;;     0b0 ==> Low voltage interrupt cleared.
;;     0b1 ==> Low voltage interrupt asserted.

 set     PMC_STS_SR27                BIT5
;;   Small Regulator 2.7 V Active Flag
;;     0b0 ==> The small regulator 2.7 V supply is not ready to be used.
;;     0b1 ==> The small regulator 2.7 V supply is ready to be used.

 set     PWMA_SM0CNT_CNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWMA_SM0CNT_CNT_0           BIT0
 set     PWMA_SM0CNT_CNT_1           BIT1
 set     PWMA_SM0CNT_CNT_2           BIT2
 set     PWMA_SM0CNT_CNT_3           BIT3
 set     PWMA_SM0CNT_CNT_4           BIT4
 set     PWMA_SM0CNT_CNT_5           BIT5
 set     PWMA_SM0CNT_CNT_6           BIT6
 set     PWMA_SM0CNT_CNT_7           BIT7
 set     PWMA_SM0CNT_CNT_8           BIT8
 set     PWMA_SM0CNT_CNT_9           BIT9
 set     PWMA_SM0CNT_CNT_10          BIT10
 set     PWMA_SM0CNT_CNT_11          BIT11
 set     PWMA_SM0CNT_CNT_12          BIT12
 set     PWMA_SM0CNT_CNT_13          BIT13
 set     PWMA_SM0CNT_CNT_14          BIT14
 set     PWMA_SM0CNT_CNT_15          BIT15

 set     PWMA_SM0INIT_INIT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWMA_SM0INIT_INIT_0         BIT0
 set     PWMA_SM0INIT_INIT_1         BIT1
 set     PWMA_SM0INIT_INIT_2         BIT2
 set     PWMA_SM0INIT_INIT_3         BIT3
 set     PWMA_SM0INIT_INIT_4         BIT4
 set     PWMA_SM0INIT_INIT_5         BIT5
 set     PWMA_SM0INIT_INIT_6         BIT6
 set     PWMA_SM0INIT_INIT_7         BIT7
 set     PWMA_SM0INIT_INIT_8         BIT8
 set     PWMA_SM0INIT_INIT_9         BIT9
 set     PWMA_SM0INIT_INIT_10        BIT10
 set     PWMA_SM0INIT_INIT_11        BIT11
 set     PWMA_SM0INIT_INIT_12        BIT12
 set     PWMA_SM0INIT_INIT_13        BIT13
 set     PWMA_SM0INIT_INIT_14        BIT14
 set     PWMA_SM0INIT_INIT_15        BIT15

 set     PWMA_SM0CTRL2_CLK_SEL       (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWMA_SM0CTRL2_CLK_SEL_0     BIT0
 set     PWMA_SM0CTRL2_CLK_SEL_1     BIT1

 set     PWMA_SM0CTRL2_RELOAD_SEL    BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWMA_SM0CTRL2_FORCE_SEL     (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWMA_SM0CTRL2_FORCE_SEL_0   BIT3
 set     PWMA_SM0CTRL2_FORCE_SEL_1   BIT4
 set     PWMA_SM0CTRL2_FORCE_SEL_2   BIT5

 set     PWMA_SM0CTRL2_FORCE         BIT6
;;   Force Initialization

 set     PWMA_SM0CTRL2_FRCEN         BIT7
;;   Force Initialization Enable
;;     0b0 ==> Initialization from a FORCE_OUT event is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT event is enabled.

 set     PWMA_SM0CTRL2_INIT_SEL      (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWMA_SM0CTRL2_INIT_SEL_0    BIT8
 set     PWMA_SM0CTRL2_INIT_SEL_1    BIT9

 set     PWMA_SM0CTRL2_PWMX_INIT     BIT10
;;   PWM_X Initial Value

 set     PWMA_SM0CTRL2_PWM45_INIT    BIT11
;;   PWM45 Initial Value

 set     PWMA_SM0CTRL2_PWM23_INIT    BIT12
;;   PWM23 Initial Value

 set     PWMA_SM0CTRL2_INDEP         BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWMA_SM0CTRL2_WAITEN        BIT14
;;   WAIT Enable

 set     PWMA_SM0CTRL2_DBGEN         BIT15
;;   Debug Enable

 set     PWMA_SM0CTRL_DBLEN          BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWMA_SM0CTRL_DBLX           BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWMA_SM0CTRL_LDMOD          BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWMA_SM0CTRL_PRSC           (BIT4|BIT5|BIT6)
;;   Prescaler
;;     0b000 ==> PWM clock frequency = fclk
;;     0b001 ==> PWM clock frequency = fclk/2
;;     0b010 ==> PWM clock frequency = fclk/4
;;     0b011 ==> PWM clock frequency = fclk/8
;;     0b100 ==> PWM clock frequency = fclk/16
;;     0b101 ==> PWM clock frequency = fclk/32
;;     0b110 ==> PWM clock frequency = fclk/64
;;     0b111 ==> PWM clock frequency = fclk/128
 set     PWMA_SM0CTRL_PRSC_0         BIT4
 set     PWMA_SM0CTRL_PRSC_1         BIT5
 set     PWMA_SM0CTRL_PRSC_2         BIT6

 set     PWMA_SM0CTRL_DT             (BIT8|BIT9)
;;   Deadtime
 set     PWMA_SM0CTRL_DT_0           BIT8
 set     PWMA_SM0CTRL_DT_1           BIT9

 set     PWMA_SM0CTRL_FULL           BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWMA_SM0CTRL_HALF           BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWMA_SM0CTRL_LDFQ           (BIT12|BIT13|BIT14|BIT15)
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWMA_SM0CTRL_LDFQ_0         BIT12
 set     PWMA_SM0CTRL_LDFQ_1         BIT13
 set     PWMA_SM0CTRL_LDFQ_2         BIT14
 set     PWMA_SM0CTRL_LDFQ_3         BIT15

 set     PWMA_SM0VAL0_VAL0           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWMA_SM0VAL0_VAL0_0         BIT0
 set     PWMA_SM0VAL0_VAL0_1         BIT1
 set     PWMA_SM0VAL0_VAL0_2         BIT2
 set     PWMA_SM0VAL0_VAL0_3         BIT3
 set     PWMA_SM0VAL0_VAL0_4         BIT4
 set     PWMA_SM0VAL0_VAL0_5         BIT5
 set     PWMA_SM0VAL0_VAL0_6         BIT6
 set     PWMA_SM0VAL0_VAL0_7         BIT7
 set     PWMA_SM0VAL0_VAL0_8         BIT8
 set     PWMA_SM0VAL0_VAL0_9         BIT9
 set     PWMA_SM0VAL0_VAL0_10        BIT10
 set     PWMA_SM0VAL0_VAL0_11        BIT11
 set     PWMA_SM0VAL0_VAL0_12        BIT12
 set     PWMA_SM0VAL0_VAL0_13        BIT13
 set     PWMA_SM0VAL0_VAL0_14        BIT14
 set     PWMA_SM0VAL0_VAL0_15        BIT15

 set     PWMA_SM0FRACVAL1_FRACVAL1   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWMA_SM0FRACVAL1_FRACVAL1_0 BIT11
 set     PWMA_SM0FRACVAL1_FRACVAL1_1 BIT12
 set     PWMA_SM0FRACVAL1_FRACVAL1_2 BIT13
 set     PWMA_SM0FRACVAL1_FRACVAL1_3 BIT14
 set     PWMA_SM0FRACVAL1_FRACVAL1_4 BIT15

 set     PWMA_SM0VAL1_VAL1           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWMA_SM0VAL1_VAL1_0         BIT0
 set     PWMA_SM0VAL1_VAL1_1         BIT1
 set     PWMA_SM0VAL1_VAL1_2         BIT2
 set     PWMA_SM0VAL1_VAL1_3         BIT3
 set     PWMA_SM0VAL1_VAL1_4         BIT4
 set     PWMA_SM0VAL1_VAL1_5         BIT5
 set     PWMA_SM0VAL1_VAL1_6         BIT6
 set     PWMA_SM0VAL1_VAL1_7         BIT7
 set     PWMA_SM0VAL1_VAL1_8         BIT8
 set     PWMA_SM0VAL1_VAL1_9         BIT9
 set     PWMA_SM0VAL1_VAL1_10        BIT10
 set     PWMA_SM0VAL1_VAL1_11        BIT11
 set     PWMA_SM0VAL1_VAL1_12        BIT12
 set     PWMA_SM0VAL1_VAL1_13        BIT13
 set     PWMA_SM0VAL1_VAL1_14        BIT14
 set     PWMA_SM0VAL1_VAL1_15        BIT15

 set     PWMA_SM0FRACVAL2_FRACVAL2   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWMA_SM0FRACVAL2_FRACVAL2_0 BIT11
 set     PWMA_SM0FRACVAL2_FRACVAL2_1 BIT12
 set     PWMA_SM0FRACVAL2_FRACVAL2_2 BIT13
 set     PWMA_SM0FRACVAL2_FRACVAL2_3 BIT14
 set     PWMA_SM0FRACVAL2_FRACVAL2_4 BIT15

 set     PWMA_SM0VAL2_VAL2           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWMA_SM0VAL2_VAL2_0         BIT0
 set     PWMA_SM0VAL2_VAL2_1         BIT1
 set     PWMA_SM0VAL2_VAL2_2         BIT2
 set     PWMA_SM0VAL2_VAL2_3         BIT3
 set     PWMA_SM0VAL2_VAL2_4         BIT4
 set     PWMA_SM0VAL2_VAL2_5         BIT5
 set     PWMA_SM0VAL2_VAL2_6         BIT6
 set     PWMA_SM0VAL2_VAL2_7         BIT7
 set     PWMA_SM0VAL2_VAL2_8         BIT8
 set     PWMA_SM0VAL2_VAL2_9         BIT9
 set     PWMA_SM0VAL2_VAL2_10        BIT10
 set     PWMA_SM0VAL2_VAL2_11        BIT11
 set     PWMA_SM0VAL2_VAL2_12        BIT12
 set     PWMA_SM0VAL2_VAL2_13        BIT13
 set     PWMA_SM0VAL2_VAL2_14        BIT14
 set     PWMA_SM0VAL2_VAL2_15        BIT15

 set     PWMA_SM0FRACVAL3_FRACVAL3   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWMA_SM0FRACVAL3_FRACVAL3_0 BIT11
 set     PWMA_SM0FRACVAL3_FRACVAL3_1 BIT12
 set     PWMA_SM0FRACVAL3_FRACVAL3_2 BIT13
 set     PWMA_SM0FRACVAL3_FRACVAL3_3 BIT14
 set     PWMA_SM0FRACVAL3_FRACVAL3_4 BIT15

 set     PWMA_SM0VAL3_VAL3           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWMA_SM0VAL3_VAL3_0         BIT0
 set     PWMA_SM0VAL3_VAL3_1         BIT1
 set     PWMA_SM0VAL3_VAL3_2         BIT2
 set     PWMA_SM0VAL3_VAL3_3         BIT3
 set     PWMA_SM0VAL3_VAL3_4         BIT4
 set     PWMA_SM0VAL3_VAL3_5         BIT5
 set     PWMA_SM0VAL3_VAL3_6         BIT6
 set     PWMA_SM0VAL3_VAL3_7         BIT7
 set     PWMA_SM0VAL3_VAL3_8         BIT8
 set     PWMA_SM0VAL3_VAL3_9         BIT9
 set     PWMA_SM0VAL3_VAL3_10        BIT10
 set     PWMA_SM0VAL3_VAL3_11        BIT11
 set     PWMA_SM0VAL3_VAL3_12        BIT12
 set     PWMA_SM0VAL3_VAL3_13        BIT13
 set     PWMA_SM0VAL3_VAL3_14        BIT14
 set     PWMA_SM0VAL3_VAL3_15        BIT15

 set     PWMA_SM0FRACVAL4_FRACVAL4   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWMA_SM0FRACVAL4_FRACVAL4_0 BIT11
 set     PWMA_SM0FRACVAL4_FRACVAL4_1 BIT12
 set     PWMA_SM0FRACVAL4_FRACVAL4_2 BIT13
 set     PWMA_SM0FRACVAL4_FRACVAL4_3 BIT14
 set     PWMA_SM0FRACVAL4_FRACVAL4_4 BIT15

 set     PWMA_SM0VAL4_VAL4           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWMA_SM0VAL4_VAL4_0         BIT0
 set     PWMA_SM0VAL4_VAL4_1         BIT1
 set     PWMA_SM0VAL4_VAL4_2         BIT2
 set     PWMA_SM0VAL4_VAL4_3         BIT3
 set     PWMA_SM0VAL4_VAL4_4         BIT4
 set     PWMA_SM0VAL4_VAL4_5         BIT5
 set     PWMA_SM0VAL4_VAL4_6         BIT6
 set     PWMA_SM0VAL4_VAL4_7         BIT7
 set     PWMA_SM0VAL4_VAL4_8         BIT8
 set     PWMA_SM0VAL4_VAL4_9         BIT9
 set     PWMA_SM0VAL4_VAL4_10        BIT10
 set     PWMA_SM0VAL4_VAL4_11        BIT11
 set     PWMA_SM0VAL4_VAL4_12        BIT12
 set     PWMA_SM0VAL4_VAL4_13        BIT13
 set     PWMA_SM0VAL4_VAL4_14        BIT14
 set     PWMA_SM0VAL4_VAL4_15        BIT15

 set     PWMA_SM0FRACVAL5_FRACVAL5   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWMA_SM0FRACVAL5_FRACVAL5_0 BIT11
 set     PWMA_SM0FRACVAL5_FRACVAL5_1 BIT12
 set     PWMA_SM0FRACVAL5_FRACVAL5_2 BIT13
 set     PWMA_SM0FRACVAL5_FRACVAL5_3 BIT14
 set     PWMA_SM0FRACVAL5_FRACVAL5_4 BIT15

 set     PWMA_SM0VAL5_VAL5           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWMA_SM0VAL5_VAL5_0         BIT0
 set     PWMA_SM0VAL5_VAL5_1         BIT1
 set     PWMA_SM0VAL5_VAL5_2         BIT2
 set     PWMA_SM0VAL5_VAL5_3         BIT3
 set     PWMA_SM0VAL5_VAL5_4         BIT4
 set     PWMA_SM0VAL5_VAL5_5         BIT5
 set     PWMA_SM0VAL5_VAL5_6         BIT6
 set     PWMA_SM0VAL5_VAL5_7         BIT7
 set     PWMA_SM0VAL5_VAL5_8         BIT8
 set     PWMA_SM0VAL5_VAL5_9         BIT9
 set     PWMA_SM0VAL5_VAL5_10        BIT10
 set     PWMA_SM0VAL5_VAL5_11        BIT11
 set     PWMA_SM0VAL5_VAL5_12        BIT12
 set     PWMA_SM0VAL5_VAL5_13        BIT13
 set     PWMA_SM0VAL5_VAL5_14        BIT14
 set     PWMA_SM0VAL5_VAL5_15        BIT15

 set     PWMA_SM0FRCTRL_FRAC1_EN     BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWMA_SM0FRCTRL_FRAC23_EN    BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWMA_SM0FRCTRL_FRAC45_EN    BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWMA_SM0FRCTRL_FRAC_PU      BIT8
;;   Fractional Delay Circuit Power Up
;;     0b0 ==> Turn off fractional delay logic.
;;     0b1 ==> Power up fractional delay logic.

 set     PWMA_SM0FRCTRL_TEST         BIT15
;;   Test Status Bit

 set     PWMA_SM0OCTRL_PWMXFS        (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM0OCTRL_PWMXFS_0      BIT0
 set     PWMA_SM0OCTRL_PWMXFS_1      BIT1

 set     PWMA_SM0OCTRL_PWMBFS        (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM0OCTRL_PWMBFS_0      BIT2
 set     PWMA_SM0OCTRL_PWMBFS_1      BIT3

 set     PWMA_SM0OCTRL_PWMAFS        (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM0OCTRL_PWMAFS_0      BIT4
 set     PWMA_SM0OCTRL_PWMAFS_1      BIT5

 set     PWMA_SM0OCTRL_POLX          BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWMA_SM0OCTRL_POLB          BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWMA_SM0OCTRL_POLA          BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWMA_SM0OCTRL_PWMX_IN       BIT13
;;   PWM_X Input

 set     PWMA_SM0OCTRL_PWMB_IN       BIT14
;;   PWM_B Input

 set     PWMA_SM0OCTRL_PWMA_IN       BIT15
;;   PWM_A Input

 set     PWMA_SM0STS_CMPF            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b0 ==> No compare event has occurred for a particular VALx value.
;;     0b1 ==> A compare event has occurred for a particular VALx value.
 set     PWMA_SM0STS_CMPF_0          BIT0
 set     PWMA_SM0STS_CMPF_1          BIT1
 set     PWMA_SM0STS_CMPF_2          BIT2
 set     PWMA_SM0STS_CMPF_3          BIT3
 set     PWMA_SM0STS_CMPF_4          BIT4
 set     PWMA_SM0STS_CMPF_5          BIT5

 set     PWMA_SM0STS_CFX0            BIT6
;;   Capture Flag X0

 set     PWMA_SM0STS_CFX1            BIT7
;;   Capture Flag X1

 set     PWMA_SM0STS_CFB0            BIT8
;;   Capture Flag B0

 set     PWMA_SM0STS_CFB1            BIT9
;;   Capture Flag B1

 set     PWMA_SM0STS_CFA0            BIT10
;;   Capture Flag A0

 set     PWMA_SM0STS_CFA1            BIT11
;;   Capture Flag A1

 set     PWMA_SM0STS_RF              BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWMA_SM0STS_REF             BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWMA_SM0STS_RUF             BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWMA_SM0INTEN_CMPIE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b0 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b1 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWMA_SM0INTEN_CMPIE_0       BIT0
 set     PWMA_SM0INTEN_CMPIE_1       BIT1
 set     PWMA_SM0INTEN_CMPIE_2       BIT2
 set     PWMA_SM0INTEN_CMPIE_3       BIT3
 set     PWMA_SM0INTEN_CMPIE_4       BIT4
 set     PWMA_SM0INTEN_CMPIE_5       BIT5

 set     PWMA_SM0INTEN_CX0IE         BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWMA_SM0INTEN_CX1IE         BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWMA_SM0INTEN_CB0IE         BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWMA_SM0INTEN_CB1IE         BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWMA_SM0INTEN_CA0IE         BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWMA_SM0INTEN_CA1IE         BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWMA_SM0INTEN_RIE           BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWMA_SM0INTEN_REIE          BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWMA_SM0DMAEN_CX0DE         BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWMA_SM0DMAEN_CX1DE         BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWMA_SM0DMAEN_CB0DE         BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWMA_SM0DMAEN_CB1DE         BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWMA_SM0DMAEN_CA0DE         BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWMA_SM0DMAEN_CA1DE         BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWMA_SM0DMAEN_CAPTDE        (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWMA_SM0DMAEN_CAPTDE_0      BIT6
 set     PWMA_SM0DMAEN_CAPTDE_1      BIT7

 set     PWMA_SM0DMAEN_FAND          BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWMA_SM0DMAEN_VALDE         BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled
;;     0b1 ==> DMA write requests for the VALx and FRACVALx registers enabled

 set     PWMA_SM0TCTRL_OUT_TRIG_EN   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0b0 ==> PWM_OUT_TRIGx will not set when the counter value matches the VALx value.
;;     0b1 ==> PWM_OUT_TRIGx will set when the counter value matches the VALx value.
 set     PWMA_SM0TCTRL_OUT_TRIG_EN_0 BIT0
 set     PWMA_SM0TCTRL_OUT_TRIG_EN_1 BIT1
 set     PWMA_SM0TCTRL_OUT_TRIG_EN_2 BIT2
 set     PWMA_SM0TCTRL_OUT_TRIG_EN_3 BIT3
 set     PWMA_SM0TCTRL_OUT_TRIG_EN_4 BIT4
 set     PWMA_SM0TCTRL_OUT_TRIG_EN_5 BIT5

 set     PWMA_SM0TCTRL_PWBOT1        BIT14
;;   Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_OUT_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_OUT_TRIG1 port.

 set     PWMA_SM0TCTRL_PWAOT0        BIT15
;;   Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_OUT_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_OUT_TRIG0 port.

 set     PWMA_SM0DISMAP0_DIS0A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWMA_SM0DISMAP0_DIS0A_0     BIT0
 set     PWMA_SM0DISMAP0_DIS0A_1     BIT1
 set     PWMA_SM0DISMAP0_DIS0A_2     BIT2
 set     PWMA_SM0DISMAP0_DIS0A_3     BIT3

 set     PWMA_SM0DISMAP0_DIS0B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWMA_SM0DISMAP0_DIS0B_0     BIT4
 set     PWMA_SM0DISMAP0_DIS0B_1     BIT5
 set     PWMA_SM0DISMAP0_DIS0B_2     BIT6
 set     PWMA_SM0DISMAP0_DIS0B_3     BIT7

 set     PWMA_SM0DISMAP0_DIS0X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWMA_SM0DISMAP0_DIS0X_0     BIT8
 set     PWMA_SM0DISMAP0_DIS0X_1     BIT9
 set     PWMA_SM0DISMAP0_DIS0X_2     BIT10
 set     PWMA_SM0DISMAP0_DIS0X_3     BIT11

 set     PWMA_SM0DISMAP1_DIS1A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWMA_SM0DISMAP1_DIS1A_0     BIT0
 set     PWMA_SM0DISMAP1_DIS1A_1     BIT1
 set     PWMA_SM0DISMAP1_DIS1A_2     BIT2
 set     PWMA_SM0DISMAP1_DIS1A_3     BIT3

 set     PWMA_SM0DISMAP1_DIS1B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWMA_SM0DISMAP1_DIS1B_0     BIT4
 set     PWMA_SM0DISMAP1_DIS1B_1     BIT5
 set     PWMA_SM0DISMAP1_DIS1B_2     BIT6
 set     PWMA_SM0DISMAP1_DIS1B_3     BIT7

 set     PWMA_SM0DISMAP1_DIS1X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWMA_SM0DISMAP1_DIS1X_0     BIT8
 set     PWMA_SM0DISMAP1_DIS1X_1     BIT9
 set     PWMA_SM0DISMAP1_DIS1X_2     BIT10
 set     PWMA_SM0DISMAP1_DIS1X_3     BIT11

 set     PWMA_SM0DTCNT0_DTCNT0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 0
 set     PWMA_SM0DTCNT0_DTCNT0_0     BIT0
 set     PWMA_SM0DTCNT0_DTCNT0_1     BIT1
 set     PWMA_SM0DTCNT0_DTCNT0_2     BIT2
 set     PWMA_SM0DTCNT0_DTCNT0_3     BIT3
 set     PWMA_SM0DTCNT0_DTCNT0_4     BIT4
 set     PWMA_SM0DTCNT0_DTCNT0_5     BIT5
 set     PWMA_SM0DTCNT0_DTCNT0_6     BIT6
 set     PWMA_SM0DTCNT0_DTCNT0_7     BIT7
 set     PWMA_SM0DTCNT0_DTCNT0_8     BIT8
 set     PWMA_SM0DTCNT0_DTCNT0_9     BIT9
 set     PWMA_SM0DTCNT0_DTCNT0_10    BIT10

 set     PWMA_SM0DTCNT1_DTCNT1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 1
 set     PWMA_SM0DTCNT1_DTCNT1_0     BIT0
 set     PWMA_SM0DTCNT1_DTCNT1_1     BIT1
 set     PWMA_SM0DTCNT1_DTCNT1_2     BIT2
 set     PWMA_SM0DTCNT1_DTCNT1_3     BIT3
 set     PWMA_SM0DTCNT1_DTCNT1_4     BIT4
 set     PWMA_SM0DTCNT1_DTCNT1_5     BIT5
 set     PWMA_SM0DTCNT1_DTCNT1_6     BIT6
 set     PWMA_SM0DTCNT1_DTCNT1_7     BIT7
 set     PWMA_SM0DTCNT1_DTCNT1_8     BIT8
 set     PWMA_SM0DTCNT1_DTCNT1_9     BIT9
 set     PWMA_SM0DTCNT1_DTCNT1_10    BIT10

 set     PWMA_SM0CAPTCTRLA_ARMA      BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWMA_SM0CAPTCTRLA_ONESHOTA  BIT1
;;   One Shot Mode A
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLA[ARMA] is cleared. No further captures will be performed until CAPTCTRLA[ARMA] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLA[ARMA] is then cleared.

 set     PWMA_SM0CAPTCTRLA_EDGA0     (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM0CAPTCTRLA_EDGA0_0   BIT2
 set     PWMA_SM0CAPTCTRLA_EDGA0_1   BIT3

 set     PWMA_SM0CAPTCTRLA_EDGA1     (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM0CAPTCTRLA_EDGA1_0   BIT4
 set     PWMA_SM0CAPTCTRLA_EDGA1_1   BIT5

 set     PWMA_SM0CAPTCTRLA_INP_SELA  BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLA[EDGA0] and CAPTCTRLA[EDGA1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRA[EDGA0] and/or CAPTCTRLA[EDGA1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM0CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM0CAPTCTRLA_CFAWM     (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWMA_SM0CAPTCTRLA_CFAWM_0   BIT8
 set     PWMA_SM0CAPTCTRLA_CFAWM_1   BIT9

 set     PWMA_SM0CAPTCTRLA_CA0CNT    (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWMA_SM0CAPTCTRLA_CA0CNT_0  BIT10
 set     PWMA_SM0CAPTCTRLA_CA0CNT_1  BIT11
 set     PWMA_SM0CAPTCTRLA_CA0CNT_2  BIT12

 set     PWMA_SM0CAPTCTRLA_CA1CNT    (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWMA_SM0CAPTCTRLA_CA1CNT_0  BIT13
 set     PWMA_SM0CAPTCTRLA_CA1CNT_1  BIT14
 set     PWMA_SM0CAPTCTRLA_CA1CNT_2  BIT15

 set     PWMA_SM0CAPTCOMPA_EDGCMPA   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_0 BIT0
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_1 BIT1
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_2 BIT2
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_3 BIT3
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_4 BIT4
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_5 BIT5
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_6 BIT6
 set     PWMA_SM0CAPTCOMPA_EDGCMPA_7 BIT7

 set     PWMA_SM0CAPTCOMPA_EDGCNTA   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_0 BIT8
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_1 BIT9
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_2 BIT10
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_3 BIT11
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_4 BIT12
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_5 BIT13
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_6 BIT14
 set     PWMA_SM0CAPTCOMPA_EDGCNTA_7 BIT15

 set     PWMA_SM0CAPTCTRLB_ARMB      BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWMA_SM0CAPTCTRLB_ONESHOTB  BIT1
;;   One Shot Mode B
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLB[ARMB] is cleared. No further captures will be performed until CAPTCTRLB[ARMB] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLB[ARMB] is then cleared.

 set     PWMA_SM0CAPTCTRLB_EDGB0     (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM0CAPTCTRLB_EDGB0_0   BIT2
 set     PWMA_SM0CAPTCTRLB_EDGB0_1   BIT3

 set     PWMA_SM0CAPTCTRLB_EDGB1     (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM0CAPTCTRLB_EDGB1_0   BIT4
 set     PWMA_SM0CAPTCTRLB_EDGB1_1   BIT5

 set     PWMA_SM0CAPTCTRLB_INP_SELB  BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLB[EDGB0] and CAPTCTRLB[EDGB1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRB[EDGB0] and/or CAPTCTRLB[EDGB1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM0CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM0CAPTCTRLB_CFBWM     (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWMA_SM0CAPTCTRLB_CFBWM_0   BIT8
 set     PWMA_SM0CAPTCTRLB_CFBWM_1   BIT9

 set     PWMA_SM0CAPTCTRLB_CB0CNT    (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWMA_SM0CAPTCTRLB_CB0CNT_0  BIT10
 set     PWMA_SM0CAPTCTRLB_CB0CNT_1  BIT11
 set     PWMA_SM0CAPTCTRLB_CB0CNT_2  BIT12

 set     PWMA_SM0CAPTCTRLB_CB1CNT    (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWMA_SM0CAPTCTRLB_CB1CNT_0  BIT13
 set     PWMA_SM0CAPTCTRLB_CB1CNT_1  BIT14
 set     PWMA_SM0CAPTCTRLB_CB1CNT_2  BIT15

 set     PWMA_SM0CAPTCOMPB_EDGCMPB   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_0 BIT0
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_1 BIT1
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_2 BIT2
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_3 BIT3
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_4 BIT4
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_5 BIT5
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_6 BIT6
 set     PWMA_SM0CAPTCOMPB_EDGCMPB_7 BIT7

 set     PWMA_SM0CAPTCOMPB_EDGCNTB   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_0 BIT8
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_1 BIT9
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_2 BIT10
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_3 BIT11
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_4 BIT12
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_5 BIT13
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_6 BIT14
 set     PWMA_SM0CAPTCOMPB_EDGCNTB_7 BIT15

 set     PWMA_SM0CAPTCTRLX_ARMX      BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWMA_SM0CAPTCTRLX_ONESHOTX  BIT1
;;   One Shot Mode Aux
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and the ARMX bit is cleared. No further captures will be performed until the ARMX bit is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled capture
;;             circuit and the ARMX bit is then cleared.

 set     PWMA_SM0CAPTCTRLX_EDGX0     (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM0CAPTCTRLX_EDGX0_0   BIT2
 set     PWMA_SM0CAPTCTRLX_EDGX0_1   BIT3

 set     PWMA_SM0CAPTCTRLX_EDGX1     (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM0CAPTCTRLX_EDGX1_0   BIT4
 set     PWMA_SM0CAPTCTRLX_EDGX1_1   BIT5

 set     PWMA_SM0CAPTCTRLX_INP_SELX  BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLX[EDGX0] and CAPTCTRLX[EDGX1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRX[EDGX0] and/or CAPTCTRLX[EDGX1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM0CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM0CAPTCTRLX_CFXWM     (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWMA_SM0CAPTCTRLX_CFXWM_0   BIT8
 set     PWMA_SM0CAPTCTRLX_CFXWM_1   BIT9

 set     PWMA_SM0CAPTCTRLX_CX0CNT    (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWMA_SM0CAPTCTRLX_CX0CNT_0  BIT10
 set     PWMA_SM0CAPTCTRLX_CX0CNT_1  BIT11
 set     PWMA_SM0CAPTCTRLX_CX0CNT_2  BIT12

 set     PWMA_SM0CAPTCTRLX_CX1CNT    (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWMA_SM0CAPTCTRLX_CX1CNT_0  BIT13
 set     PWMA_SM0CAPTCTRLX_CX1CNT_1  BIT14
 set     PWMA_SM0CAPTCTRLX_CX1CNT_2  BIT15

 set     PWMA_SM0CAPTCOMPX_EDGCMPX   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_0 BIT0
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_1 BIT1
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_2 BIT2
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_3 BIT3
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_4 BIT4
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_5 BIT5
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_6 BIT6
 set     PWMA_SM0CAPTCOMPX_EDGCMPX_7 BIT7

 set     PWMA_SM0CAPTCOMPX_EDGCNTX   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_0 BIT8
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_1 BIT9
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_2 BIT10
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_3 BIT11
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_4 BIT12
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_5 BIT13
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_6 BIT14
 set     PWMA_SM0CAPTCOMPX_EDGCNTX_7 BIT15

 set     PWMA_SM0CVAL0_CAPTVAL0      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM0CVAL0_CAPTVAL0_0    BIT0
 set     PWMA_SM0CVAL0_CAPTVAL0_1    BIT1
 set     PWMA_SM0CVAL0_CAPTVAL0_2    BIT2
 set     PWMA_SM0CVAL0_CAPTVAL0_3    BIT3
 set     PWMA_SM0CVAL0_CAPTVAL0_4    BIT4
 set     PWMA_SM0CVAL0_CAPTVAL0_5    BIT5
 set     PWMA_SM0CVAL0_CAPTVAL0_6    BIT6
 set     PWMA_SM0CVAL0_CAPTVAL0_7    BIT7
 set     PWMA_SM0CVAL0_CAPTVAL0_8    BIT8
 set     PWMA_SM0CVAL0_CAPTVAL0_9    BIT9
 set     PWMA_SM0CVAL0_CAPTVAL0_10   BIT10
 set     PWMA_SM0CVAL0_CAPTVAL0_11   BIT11
 set     PWMA_SM0CVAL0_CAPTVAL0_12   BIT12
 set     PWMA_SM0CVAL0_CAPTVAL0_13   BIT13
 set     PWMA_SM0CVAL0_CAPTVAL0_14   BIT14
 set     PWMA_SM0CVAL0_CAPTVAL0_15   BIT15

 set     PWMA_SM0CVAL0CYC_CVAL0CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM0CVAL0CYC_CVAL0CYC_0 BIT0
 set     PWMA_SM0CVAL0CYC_CVAL0CYC_1 BIT1
 set     PWMA_SM0CVAL0CYC_CVAL0CYC_2 BIT2
 set     PWMA_SM0CVAL0CYC_CVAL0CYC_3 BIT3

 set     PWMA_SM0CVAL1_CAPTVAL1      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM0CVAL1_CAPTVAL1_0    BIT0
 set     PWMA_SM0CVAL1_CAPTVAL1_1    BIT1
 set     PWMA_SM0CVAL1_CAPTVAL1_2    BIT2
 set     PWMA_SM0CVAL1_CAPTVAL1_3    BIT3
 set     PWMA_SM0CVAL1_CAPTVAL1_4    BIT4
 set     PWMA_SM0CVAL1_CAPTVAL1_5    BIT5
 set     PWMA_SM0CVAL1_CAPTVAL1_6    BIT6
 set     PWMA_SM0CVAL1_CAPTVAL1_7    BIT7
 set     PWMA_SM0CVAL1_CAPTVAL1_8    BIT8
 set     PWMA_SM0CVAL1_CAPTVAL1_9    BIT9
 set     PWMA_SM0CVAL1_CAPTVAL1_10   BIT10
 set     PWMA_SM0CVAL1_CAPTVAL1_11   BIT11
 set     PWMA_SM0CVAL1_CAPTVAL1_12   BIT12
 set     PWMA_SM0CVAL1_CAPTVAL1_13   BIT13
 set     PWMA_SM0CVAL1_CAPTVAL1_14   BIT14
 set     PWMA_SM0CVAL1_CAPTVAL1_15   BIT15

 set     PWMA_SM0CVAL1CYC_CVAL1CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM0CVAL1CYC_CVAL1CYC_0 BIT0
 set     PWMA_SM0CVAL1CYC_CVAL1CYC_1 BIT1
 set     PWMA_SM0CVAL1CYC_CVAL1CYC_2 BIT2
 set     PWMA_SM0CVAL1CYC_CVAL1CYC_3 BIT3

 set     PWMA_SM0CVAL2_CAPTVAL2      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM0CVAL2_CAPTVAL2_0    BIT0
 set     PWMA_SM0CVAL2_CAPTVAL2_1    BIT1
 set     PWMA_SM0CVAL2_CAPTVAL2_2    BIT2
 set     PWMA_SM0CVAL2_CAPTVAL2_3    BIT3
 set     PWMA_SM0CVAL2_CAPTVAL2_4    BIT4
 set     PWMA_SM0CVAL2_CAPTVAL2_5    BIT5
 set     PWMA_SM0CVAL2_CAPTVAL2_6    BIT6
 set     PWMA_SM0CVAL2_CAPTVAL2_7    BIT7
 set     PWMA_SM0CVAL2_CAPTVAL2_8    BIT8
 set     PWMA_SM0CVAL2_CAPTVAL2_9    BIT9
 set     PWMA_SM0CVAL2_CAPTVAL2_10   BIT10
 set     PWMA_SM0CVAL2_CAPTVAL2_11   BIT11
 set     PWMA_SM0CVAL2_CAPTVAL2_12   BIT12
 set     PWMA_SM0CVAL2_CAPTVAL2_13   BIT13
 set     PWMA_SM0CVAL2_CAPTVAL2_14   BIT14
 set     PWMA_SM0CVAL2_CAPTVAL2_15   BIT15

 set     PWMA_SM0CVAL2CYC_CVAL2CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM0CVAL2CYC_CVAL2CYC_0 BIT0
 set     PWMA_SM0CVAL2CYC_CVAL2CYC_1 BIT1
 set     PWMA_SM0CVAL2CYC_CVAL2CYC_2 BIT2
 set     PWMA_SM0CVAL2CYC_CVAL2CYC_3 BIT3

 set     PWMA_SM0CVAL3_CAPTVAL3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM0CVAL3_CAPTVAL3_0    BIT0
 set     PWMA_SM0CVAL3_CAPTVAL3_1    BIT1
 set     PWMA_SM0CVAL3_CAPTVAL3_2    BIT2
 set     PWMA_SM0CVAL3_CAPTVAL3_3    BIT3
 set     PWMA_SM0CVAL3_CAPTVAL3_4    BIT4
 set     PWMA_SM0CVAL3_CAPTVAL3_5    BIT5
 set     PWMA_SM0CVAL3_CAPTVAL3_6    BIT6
 set     PWMA_SM0CVAL3_CAPTVAL3_7    BIT7
 set     PWMA_SM0CVAL3_CAPTVAL3_8    BIT8
 set     PWMA_SM0CVAL3_CAPTVAL3_9    BIT9
 set     PWMA_SM0CVAL3_CAPTVAL3_10   BIT10
 set     PWMA_SM0CVAL3_CAPTVAL3_11   BIT11
 set     PWMA_SM0CVAL3_CAPTVAL3_12   BIT12
 set     PWMA_SM0CVAL3_CAPTVAL3_13   BIT13
 set     PWMA_SM0CVAL3_CAPTVAL3_14   BIT14
 set     PWMA_SM0CVAL3_CAPTVAL3_15   BIT15

 set     PWMA_SM0CVAL3CYC_CVAL3CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM0CVAL3CYC_CVAL3CYC_0 BIT0
 set     PWMA_SM0CVAL3CYC_CVAL3CYC_1 BIT1
 set     PWMA_SM0CVAL3CYC_CVAL3CYC_2 BIT2
 set     PWMA_SM0CVAL3CYC_CVAL3CYC_3 BIT3

 set     PWMA_SM0CVAL4_CAPTVAL4      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM0CVAL4_CAPTVAL4_0    BIT0
 set     PWMA_SM0CVAL4_CAPTVAL4_1    BIT1
 set     PWMA_SM0CVAL4_CAPTVAL4_2    BIT2
 set     PWMA_SM0CVAL4_CAPTVAL4_3    BIT3
 set     PWMA_SM0CVAL4_CAPTVAL4_4    BIT4
 set     PWMA_SM0CVAL4_CAPTVAL4_5    BIT5
 set     PWMA_SM0CVAL4_CAPTVAL4_6    BIT6
 set     PWMA_SM0CVAL4_CAPTVAL4_7    BIT7
 set     PWMA_SM0CVAL4_CAPTVAL4_8    BIT8
 set     PWMA_SM0CVAL4_CAPTVAL4_9    BIT9
 set     PWMA_SM0CVAL4_CAPTVAL4_10   BIT10
 set     PWMA_SM0CVAL4_CAPTVAL4_11   BIT11
 set     PWMA_SM0CVAL4_CAPTVAL4_12   BIT12
 set     PWMA_SM0CVAL4_CAPTVAL4_13   BIT13
 set     PWMA_SM0CVAL4_CAPTVAL4_14   BIT14
 set     PWMA_SM0CVAL4_CAPTVAL4_15   BIT15

 set     PWMA_SM0CVAL4CYC_CVAL4CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM0CVAL4CYC_CVAL4CYC_0 BIT0
 set     PWMA_SM0CVAL4CYC_CVAL4CYC_1 BIT1
 set     PWMA_SM0CVAL4CYC_CVAL4CYC_2 BIT2
 set     PWMA_SM0CVAL4CYC_CVAL4CYC_3 BIT3

 set     PWMA_SM0CVAL5_CAPTVAL5      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM0CVAL5_CAPTVAL5_0    BIT0
 set     PWMA_SM0CVAL5_CAPTVAL5_1    BIT1
 set     PWMA_SM0CVAL5_CAPTVAL5_2    BIT2
 set     PWMA_SM0CVAL5_CAPTVAL5_3    BIT3
 set     PWMA_SM0CVAL5_CAPTVAL5_4    BIT4
 set     PWMA_SM0CVAL5_CAPTVAL5_5    BIT5
 set     PWMA_SM0CVAL5_CAPTVAL5_6    BIT6
 set     PWMA_SM0CVAL5_CAPTVAL5_7    BIT7
 set     PWMA_SM0CVAL5_CAPTVAL5_8    BIT8
 set     PWMA_SM0CVAL5_CAPTVAL5_9    BIT9
 set     PWMA_SM0CVAL5_CAPTVAL5_10   BIT10
 set     PWMA_SM0CVAL5_CAPTVAL5_11   BIT11
 set     PWMA_SM0CVAL5_CAPTVAL5_12   BIT12
 set     PWMA_SM0CVAL5_CAPTVAL5_13   BIT13
 set     PWMA_SM0CVAL5_CAPTVAL5_14   BIT14
 set     PWMA_SM0CVAL5_CAPTVAL5_15   BIT15

 set     PWMA_SM0CVAL5CYC_CVAL5CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM0CVAL5CYC_CVAL5CYC_0 BIT0
 set     PWMA_SM0CVAL5CYC_CVAL5CYC_1 BIT1
 set     PWMA_SM0CVAL5CYC_CVAL5CYC_2 BIT2
 set     PWMA_SM0CVAL5CYC_CVAL5CYC_3 BIT3

 set     PWMA_SM1CNT_CNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWMA_SM1CNT_CNT_0           BIT0
 set     PWMA_SM1CNT_CNT_1           BIT1
 set     PWMA_SM1CNT_CNT_2           BIT2
 set     PWMA_SM1CNT_CNT_3           BIT3
 set     PWMA_SM1CNT_CNT_4           BIT4
 set     PWMA_SM1CNT_CNT_5           BIT5
 set     PWMA_SM1CNT_CNT_6           BIT6
 set     PWMA_SM1CNT_CNT_7           BIT7
 set     PWMA_SM1CNT_CNT_8           BIT8
 set     PWMA_SM1CNT_CNT_9           BIT9
 set     PWMA_SM1CNT_CNT_10          BIT10
 set     PWMA_SM1CNT_CNT_11          BIT11
 set     PWMA_SM1CNT_CNT_12          BIT12
 set     PWMA_SM1CNT_CNT_13          BIT13
 set     PWMA_SM1CNT_CNT_14          BIT14
 set     PWMA_SM1CNT_CNT_15          BIT15

 set     PWMA_SM1INIT_INIT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWMA_SM1INIT_INIT_0         BIT0
 set     PWMA_SM1INIT_INIT_1         BIT1
 set     PWMA_SM1INIT_INIT_2         BIT2
 set     PWMA_SM1INIT_INIT_3         BIT3
 set     PWMA_SM1INIT_INIT_4         BIT4
 set     PWMA_SM1INIT_INIT_5         BIT5
 set     PWMA_SM1INIT_INIT_6         BIT6
 set     PWMA_SM1INIT_INIT_7         BIT7
 set     PWMA_SM1INIT_INIT_8         BIT8
 set     PWMA_SM1INIT_INIT_9         BIT9
 set     PWMA_SM1INIT_INIT_10        BIT10
 set     PWMA_SM1INIT_INIT_11        BIT11
 set     PWMA_SM1INIT_INIT_12        BIT12
 set     PWMA_SM1INIT_INIT_13        BIT13
 set     PWMA_SM1INIT_INIT_14        BIT14
 set     PWMA_SM1INIT_INIT_15        BIT15

 set     PWMA_SM1CTRL2_CLK_SEL       (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWMA_SM1CTRL2_CLK_SEL_0     BIT0
 set     PWMA_SM1CTRL2_CLK_SEL_1     BIT1

 set     PWMA_SM1CTRL2_RELOAD_SEL    BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWMA_SM1CTRL2_FORCE_SEL     (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWMA_SM1CTRL2_FORCE_SEL_0   BIT3
 set     PWMA_SM1CTRL2_FORCE_SEL_1   BIT4
 set     PWMA_SM1CTRL2_FORCE_SEL_2   BIT5

 set     PWMA_SM1CTRL2_FORCE         BIT6
;;   Force Initialization

 set     PWMA_SM1CTRL2_FRCEN         BIT7
;;   Force Initialization Enable
;;     0b0 ==> Initialization from a FORCE_OUT event is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT event is enabled.

 set     PWMA_SM1CTRL2_INIT_SEL      (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWMA_SM1CTRL2_INIT_SEL_0    BIT8
 set     PWMA_SM1CTRL2_INIT_SEL_1    BIT9

 set     PWMA_SM1CTRL2_PWMX_INIT     BIT10
;;   PWM_X Initial Value

 set     PWMA_SM1CTRL2_PWM45_INIT    BIT11
;;   PWM45 Initial Value

 set     PWMA_SM1CTRL2_PWM23_INIT    BIT12
;;   PWM23 Initial Value

 set     PWMA_SM1CTRL2_INDEP         BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWMA_SM1CTRL2_WAITEN        BIT14
;;   WAIT Enable

 set     PWMA_SM1CTRL2_DBGEN         BIT15
;;   Debug Enable

 set     PWMA_SM1CTRL_DBLEN          BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWMA_SM1CTRL_DBLX           BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWMA_SM1CTRL_LDMOD          BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWMA_SM1CTRL_PRSC           (BIT4|BIT5|BIT6)
;;   Prescaler
;;     0b000 ==> PWM clock frequency = fclk
;;     0b001 ==> PWM clock frequency = fclk/2
;;     0b010 ==> PWM clock frequency = fclk/4
;;     0b011 ==> PWM clock frequency = fclk/8
;;     0b100 ==> PWM clock frequency = fclk/16
;;     0b101 ==> PWM clock frequency = fclk/32
;;     0b110 ==> PWM clock frequency = fclk/64
;;     0b111 ==> PWM clock frequency = fclk/128
 set     PWMA_SM1CTRL_PRSC_0         BIT4
 set     PWMA_SM1CTRL_PRSC_1         BIT5
 set     PWMA_SM1CTRL_PRSC_2         BIT6

 set     PWMA_SM1CTRL_DT             (BIT8|BIT9)
;;   Deadtime
 set     PWMA_SM1CTRL_DT_0           BIT8
 set     PWMA_SM1CTRL_DT_1           BIT9

 set     PWMA_SM1CTRL_FULL           BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWMA_SM1CTRL_HALF           BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWMA_SM1CTRL_LDFQ           (BIT12|BIT13|BIT14|BIT15)
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWMA_SM1CTRL_LDFQ_0         BIT12
 set     PWMA_SM1CTRL_LDFQ_1         BIT13
 set     PWMA_SM1CTRL_LDFQ_2         BIT14
 set     PWMA_SM1CTRL_LDFQ_3         BIT15

 set     PWMA_SM1VAL0_VAL0           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWMA_SM1VAL0_VAL0_0         BIT0
 set     PWMA_SM1VAL0_VAL0_1         BIT1
 set     PWMA_SM1VAL0_VAL0_2         BIT2
 set     PWMA_SM1VAL0_VAL0_3         BIT3
 set     PWMA_SM1VAL0_VAL0_4         BIT4
 set     PWMA_SM1VAL0_VAL0_5         BIT5
 set     PWMA_SM1VAL0_VAL0_6         BIT6
 set     PWMA_SM1VAL0_VAL0_7         BIT7
 set     PWMA_SM1VAL0_VAL0_8         BIT8
 set     PWMA_SM1VAL0_VAL0_9         BIT9
 set     PWMA_SM1VAL0_VAL0_10        BIT10
 set     PWMA_SM1VAL0_VAL0_11        BIT11
 set     PWMA_SM1VAL0_VAL0_12        BIT12
 set     PWMA_SM1VAL0_VAL0_13        BIT13
 set     PWMA_SM1VAL0_VAL0_14        BIT14
 set     PWMA_SM1VAL0_VAL0_15        BIT15

 set     PWMA_SM1FRACVAL1_FRACVAL1   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWMA_SM1FRACVAL1_FRACVAL1_0 BIT11
 set     PWMA_SM1FRACVAL1_FRACVAL1_1 BIT12
 set     PWMA_SM1FRACVAL1_FRACVAL1_2 BIT13
 set     PWMA_SM1FRACVAL1_FRACVAL1_3 BIT14
 set     PWMA_SM1FRACVAL1_FRACVAL1_4 BIT15

 set     PWMA_SM1VAL1_VAL1           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWMA_SM1VAL1_VAL1_0         BIT0
 set     PWMA_SM1VAL1_VAL1_1         BIT1
 set     PWMA_SM1VAL1_VAL1_2         BIT2
 set     PWMA_SM1VAL1_VAL1_3         BIT3
 set     PWMA_SM1VAL1_VAL1_4         BIT4
 set     PWMA_SM1VAL1_VAL1_5         BIT5
 set     PWMA_SM1VAL1_VAL1_6         BIT6
 set     PWMA_SM1VAL1_VAL1_7         BIT7
 set     PWMA_SM1VAL1_VAL1_8         BIT8
 set     PWMA_SM1VAL1_VAL1_9         BIT9
 set     PWMA_SM1VAL1_VAL1_10        BIT10
 set     PWMA_SM1VAL1_VAL1_11        BIT11
 set     PWMA_SM1VAL1_VAL1_12        BIT12
 set     PWMA_SM1VAL1_VAL1_13        BIT13
 set     PWMA_SM1VAL1_VAL1_14        BIT14
 set     PWMA_SM1VAL1_VAL1_15        BIT15

 set     PWMA_SM1FRACVAL2_FRACVAL2   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWMA_SM1FRACVAL2_FRACVAL2_0 BIT11
 set     PWMA_SM1FRACVAL2_FRACVAL2_1 BIT12
 set     PWMA_SM1FRACVAL2_FRACVAL2_2 BIT13
 set     PWMA_SM1FRACVAL2_FRACVAL2_3 BIT14
 set     PWMA_SM1FRACVAL2_FRACVAL2_4 BIT15

 set     PWMA_SM1VAL2_VAL2           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWMA_SM1VAL2_VAL2_0         BIT0
 set     PWMA_SM1VAL2_VAL2_1         BIT1
 set     PWMA_SM1VAL2_VAL2_2         BIT2
 set     PWMA_SM1VAL2_VAL2_3         BIT3
 set     PWMA_SM1VAL2_VAL2_4         BIT4
 set     PWMA_SM1VAL2_VAL2_5         BIT5
 set     PWMA_SM1VAL2_VAL2_6         BIT6
 set     PWMA_SM1VAL2_VAL2_7         BIT7
 set     PWMA_SM1VAL2_VAL2_8         BIT8
 set     PWMA_SM1VAL2_VAL2_9         BIT9
 set     PWMA_SM1VAL2_VAL2_10        BIT10
 set     PWMA_SM1VAL2_VAL2_11        BIT11
 set     PWMA_SM1VAL2_VAL2_12        BIT12
 set     PWMA_SM1VAL2_VAL2_13        BIT13
 set     PWMA_SM1VAL2_VAL2_14        BIT14
 set     PWMA_SM1VAL2_VAL2_15        BIT15

 set     PWMA_SM1FRACVAL3_FRACVAL3   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWMA_SM1FRACVAL3_FRACVAL3_0 BIT11
 set     PWMA_SM1FRACVAL3_FRACVAL3_1 BIT12
 set     PWMA_SM1FRACVAL3_FRACVAL3_2 BIT13
 set     PWMA_SM1FRACVAL3_FRACVAL3_3 BIT14
 set     PWMA_SM1FRACVAL3_FRACVAL3_4 BIT15

 set     PWMA_SM1VAL3_VAL3           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWMA_SM1VAL3_VAL3_0         BIT0
 set     PWMA_SM1VAL3_VAL3_1         BIT1
 set     PWMA_SM1VAL3_VAL3_2         BIT2
 set     PWMA_SM1VAL3_VAL3_3         BIT3
 set     PWMA_SM1VAL3_VAL3_4         BIT4
 set     PWMA_SM1VAL3_VAL3_5         BIT5
 set     PWMA_SM1VAL3_VAL3_6         BIT6
 set     PWMA_SM1VAL3_VAL3_7         BIT7
 set     PWMA_SM1VAL3_VAL3_8         BIT8
 set     PWMA_SM1VAL3_VAL3_9         BIT9
 set     PWMA_SM1VAL3_VAL3_10        BIT10
 set     PWMA_SM1VAL3_VAL3_11        BIT11
 set     PWMA_SM1VAL3_VAL3_12        BIT12
 set     PWMA_SM1VAL3_VAL3_13        BIT13
 set     PWMA_SM1VAL3_VAL3_14        BIT14
 set     PWMA_SM1VAL3_VAL3_15        BIT15

 set     PWMA_SM1FRACVAL4_FRACVAL4   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWMA_SM1FRACVAL4_FRACVAL4_0 BIT11
 set     PWMA_SM1FRACVAL4_FRACVAL4_1 BIT12
 set     PWMA_SM1FRACVAL4_FRACVAL4_2 BIT13
 set     PWMA_SM1FRACVAL4_FRACVAL4_3 BIT14
 set     PWMA_SM1FRACVAL4_FRACVAL4_4 BIT15

 set     PWMA_SM1VAL4_VAL4           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWMA_SM1VAL4_VAL4_0         BIT0
 set     PWMA_SM1VAL4_VAL4_1         BIT1
 set     PWMA_SM1VAL4_VAL4_2         BIT2
 set     PWMA_SM1VAL4_VAL4_3         BIT3
 set     PWMA_SM1VAL4_VAL4_4         BIT4
 set     PWMA_SM1VAL4_VAL4_5         BIT5
 set     PWMA_SM1VAL4_VAL4_6         BIT6
 set     PWMA_SM1VAL4_VAL4_7         BIT7
 set     PWMA_SM1VAL4_VAL4_8         BIT8
 set     PWMA_SM1VAL4_VAL4_9         BIT9
 set     PWMA_SM1VAL4_VAL4_10        BIT10
 set     PWMA_SM1VAL4_VAL4_11        BIT11
 set     PWMA_SM1VAL4_VAL4_12        BIT12
 set     PWMA_SM1VAL4_VAL4_13        BIT13
 set     PWMA_SM1VAL4_VAL4_14        BIT14
 set     PWMA_SM1VAL4_VAL4_15        BIT15

 set     PWMA_SM1FRACVAL5_FRACVAL5   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWMA_SM1FRACVAL5_FRACVAL5_0 BIT11
 set     PWMA_SM1FRACVAL5_FRACVAL5_1 BIT12
 set     PWMA_SM1FRACVAL5_FRACVAL5_2 BIT13
 set     PWMA_SM1FRACVAL5_FRACVAL5_3 BIT14
 set     PWMA_SM1FRACVAL5_FRACVAL5_4 BIT15

 set     PWMA_SM1VAL5_VAL5           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWMA_SM1VAL5_VAL5_0         BIT0
 set     PWMA_SM1VAL5_VAL5_1         BIT1
 set     PWMA_SM1VAL5_VAL5_2         BIT2
 set     PWMA_SM1VAL5_VAL5_3         BIT3
 set     PWMA_SM1VAL5_VAL5_4         BIT4
 set     PWMA_SM1VAL5_VAL5_5         BIT5
 set     PWMA_SM1VAL5_VAL5_6         BIT6
 set     PWMA_SM1VAL5_VAL5_7         BIT7
 set     PWMA_SM1VAL5_VAL5_8         BIT8
 set     PWMA_SM1VAL5_VAL5_9         BIT9
 set     PWMA_SM1VAL5_VAL5_10        BIT10
 set     PWMA_SM1VAL5_VAL5_11        BIT11
 set     PWMA_SM1VAL5_VAL5_12        BIT12
 set     PWMA_SM1VAL5_VAL5_13        BIT13
 set     PWMA_SM1VAL5_VAL5_14        BIT14
 set     PWMA_SM1VAL5_VAL5_15        BIT15

 set     PWMA_SM1FRCTRL_FRAC1_EN     BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWMA_SM1FRCTRL_FRAC23_EN    BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWMA_SM1FRCTRL_FRAC45_EN    BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWMA_SM1FRCTRL_FRAC_PU      BIT8
;;   Fractional Delay Circuit Power Up
;;     0b0 ==> Turn off fractional delay logic.
;;     0b1 ==> Power up fractional delay logic.

 set     PWMA_SM1FRCTRL_TEST         BIT15
;;   Test Status Bit

 set     PWMA_SM1OCTRL_PWMXFS        (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM1OCTRL_PWMXFS_0      BIT0
 set     PWMA_SM1OCTRL_PWMXFS_1      BIT1

 set     PWMA_SM1OCTRL_PWMBFS        (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM1OCTRL_PWMBFS_0      BIT2
 set     PWMA_SM1OCTRL_PWMBFS_1      BIT3

 set     PWMA_SM1OCTRL_PWMAFS        (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM1OCTRL_PWMAFS_0      BIT4
 set     PWMA_SM1OCTRL_PWMAFS_1      BIT5

 set     PWMA_SM1OCTRL_POLX          BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWMA_SM1OCTRL_POLB          BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWMA_SM1OCTRL_POLA          BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWMA_SM1OCTRL_PWMX_IN       BIT13
;;   PWM_X Input

 set     PWMA_SM1OCTRL_PWMB_IN       BIT14
;;   PWM_B Input

 set     PWMA_SM1OCTRL_PWMA_IN       BIT15
;;   PWM_A Input

 set     PWMA_SM1STS_CMPF            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b0 ==> No compare event has occurred for a particular VALx value.
;;     0b1 ==> A compare event has occurred for a particular VALx value.
 set     PWMA_SM1STS_CMPF_0          BIT0
 set     PWMA_SM1STS_CMPF_1          BIT1
 set     PWMA_SM1STS_CMPF_2          BIT2
 set     PWMA_SM1STS_CMPF_3          BIT3
 set     PWMA_SM1STS_CMPF_4          BIT4
 set     PWMA_SM1STS_CMPF_5          BIT5

 set     PWMA_SM1STS_CFX0            BIT6
;;   Capture Flag X0

 set     PWMA_SM1STS_CFX1            BIT7
;;   Capture Flag X1

 set     PWMA_SM1STS_CFB0            BIT8
;;   Capture Flag B0

 set     PWMA_SM1STS_CFB1            BIT9
;;   Capture Flag B1

 set     PWMA_SM1STS_CFA0            BIT10
;;   Capture Flag A0

 set     PWMA_SM1STS_CFA1            BIT11
;;   Capture Flag A1

 set     PWMA_SM1STS_RF              BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWMA_SM1STS_REF             BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWMA_SM1STS_RUF             BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWMA_SM1INTEN_CMPIE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b0 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b1 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWMA_SM1INTEN_CMPIE_0       BIT0
 set     PWMA_SM1INTEN_CMPIE_1       BIT1
 set     PWMA_SM1INTEN_CMPIE_2       BIT2
 set     PWMA_SM1INTEN_CMPIE_3       BIT3
 set     PWMA_SM1INTEN_CMPIE_4       BIT4
 set     PWMA_SM1INTEN_CMPIE_5       BIT5

 set     PWMA_SM1INTEN_CX0IE         BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWMA_SM1INTEN_CX1IE         BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWMA_SM1INTEN_CB0IE         BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWMA_SM1INTEN_CB1IE         BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWMA_SM1INTEN_CA0IE         BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWMA_SM1INTEN_CA1IE         BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWMA_SM1INTEN_RIE           BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWMA_SM1INTEN_REIE          BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWMA_SM1DMAEN_CX0DE         BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWMA_SM1DMAEN_CX1DE         BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWMA_SM1DMAEN_CB0DE         BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWMA_SM1DMAEN_CB1DE         BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWMA_SM1DMAEN_CA0DE         BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWMA_SM1DMAEN_CA1DE         BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWMA_SM1DMAEN_CAPTDE        (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWMA_SM1DMAEN_CAPTDE_0      BIT6
 set     PWMA_SM1DMAEN_CAPTDE_1      BIT7

 set     PWMA_SM1DMAEN_FAND          BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWMA_SM1DMAEN_VALDE         BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled
;;     0b1 ==> DMA write requests for the VALx and FRACVALx registers enabled

 set     PWMA_SM1TCTRL_OUT_TRIG_EN   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0b0 ==> PWM_OUT_TRIGx will not set when the counter value matches the VALx value.
;;     0b1 ==> PWM_OUT_TRIGx will set when the counter value matches the VALx value.
 set     PWMA_SM1TCTRL_OUT_TRIG_EN_0 BIT0
 set     PWMA_SM1TCTRL_OUT_TRIG_EN_1 BIT1
 set     PWMA_SM1TCTRL_OUT_TRIG_EN_2 BIT2
 set     PWMA_SM1TCTRL_OUT_TRIG_EN_3 BIT3
 set     PWMA_SM1TCTRL_OUT_TRIG_EN_4 BIT4
 set     PWMA_SM1TCTRL_OUT_TRIG_EN_5 BIT5

 set     PWMA_SM1TCTRL_PWBOT1        BIT14
;;   Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_OUT_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_OUT_TRIG1 port.

 set     PWMA_SM1TCTRL_PWAOT0        BIT15
;;   Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_OUT_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_OUT_TRIG0 port.

 set     PWMA_SM1DISMAP0_DIS0A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWMA_SM1DISMAP0_DIS0A_0     BIT0
 set     PWMA_SM1DISMAP0_DIS0A_1     BIT1
 set     PWMA_SM1DISMAP0_DIS0A_2     BIT2
 set     PWMA_SM1DISMAP0_DIS0A_3     BIT3

 set     PWMA_SM1DISMAP0_DIS0B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWMA_SM1DISMAP0_DIS0B_0     BIT4
 set     PWMA_SM1DISMAP0_DIS0B_1     BIT5
 set     PWMA_SM1DISMAP0_DIS0B_2     BIT6
 set     PWMA_SM1DISMAP0_DIS0B_3     BIT7

 set     PWMA_SM1DISMAP0_DIS0X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWMA_SM1DISMAP0_DIS0X_0     BIT8
 set     PWMA_SM1DISMAP0_DIS0X_1     BIT9
 set     PWMA_SM1DISMAP0_DIS0X_2     BIT10
 set     PWMA_SM1DISMAP0_DIS0X_3     BIT11

 set     PWMA_SM1DISMAP1_DIS1A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWMA_SM1DISMAP1_DIS1A_0     BIT0
 set     PWMA_SM1DISMAP1_DIS1A_1     BIT1
 set     PWMA_SM1DISMAP1_DIS1A_2     BIT2
 set     PWMA_SM1DISMAP1_DIS1A_3     BIT3

 set     PWMA_SM1DISMAP1_DIS1B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWMA_SM1DISMAP1_DIS1B_0     BIT4
 set     PWMA_SM1DISMAP1_DIS1B_1     BIT5
 set     PWMA_SM1DISMAP1_DIS1B_2     BIT6
 set     PWMA_SM1DISMAP1_DIS1B_3     BIT7

 set     PWMA_SM1DISMAP1_DIS1X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWMA_SM1DISMAP1_DIS1X_0     BIT8
 set     PWMA_SM1DISMAP1_DIS1X_1     BIT9
 set     PWMA_SM1DISMAP1_DIS1X_2     BIT10
 set     PWMA_SM1DISMAP1_DIS1X_3     BIT11

 set     PWMA_SM1DTCNT0_DTCNT0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 0
 set     PWMA_SM1DTCNT0_DTCNT0_0     BIT0
 set     PWMA_SM1DTCNT0_DTCNT0_1     BIT1
 set     PWMA_SM1DTCNT0_DTCNT0_2     BIT2
 set     PWMA_SM1DTCNT0_DTCNT0_3     BIT3
 set     PWMA_SM1DTCNT0_DTCNT0_4     BIT4
 set     PWMA_SM1DTCNT0_DTCNT0_5     BIT5
 set     PWMA_SM1DTCNT0_DTCNT0_6     BIT6
 set     PWMA_SM1DTCNT0_DTCNT0_7     BIT7
 set     PWMA_SM1DTCNT0_DTCNT0_8     BIT8
 set     PWMA_SM1DTCNT0_DTCNT0_9     BIT9
 set     PWMA_SM1DTCNT0_DTCNT0_10    BIT10

 set     PWMA_SM1DTCNT1_DTCNT1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 1
 set     PWMA_SM1DTCNT1_DTCNT1_0     BIT0
 set     PWMA_SM1DTCNT1_DTCNT1_1     BIT1
 set     PWMA_SM1DTCNT1_DTCNT1_2     BIT2
 set     PWMA_SM1DTCNT1_DTCNT1_3     BIT3
 set     PWMA_SM1DTCNT1_DTCNT1_4     BIT4
 set     PWMA_SM1DTCNT1_DTCNT1_5     BIT5
 set     PWMA_SM1DTCNT1_DTCNT1_6     BIT6
 set     PWMA_SM1DTCNT1_DTCNT1_7     BIT7
 set     PWMA_SM1DTCNT1_DTCNT1_8     BIT8
 set     PWMA_SM1DTCNT1_DTCNT1_9     BIT9
 set     PWMA_SM1DTCNT1_DTCNT1_10    BIT10

 set     PWMA_SM1CAPTCTRLA_ARMA      BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWMA_SM1CAPTCTRLA_ONESHOTA  BIT1
;;   One Shot Mode A
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLA[ARMA] is cleared. No further captures will be performed until CAPTCTRLA[ARMA] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLA[ARMA] is then cleared.

 set     PWMA_SM1CAPTCTRLA_EDGA0     (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM1CAPTCTRLA_EDGA0_0   BIT2
 set     PWMA_SM1CAPTCTRLA_EDGA0_1   BIT3

 set     PWMA_SM1CAPTCTRLA_EDGA1     (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM1CAPTCTRLA_EDGA1_0   BIT4
 set     PWMA_SM1CAPTCTRLA_EDGA1_1   BIT5

 set     PWMA_SM1CAPTCTRLA_INP_SELA  BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLA[EDGA0] and CAPTCTRLA[EDGA1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRA[EDGA0] and/or CAPTCTRLA[EDGA1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM1CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM1CAPTCTRLA_CFAWM     (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWMA_SM1CAPTCTRLA_CFAWM_0   BIT8
 set     PWMA_SM1CAPTCTRLA_CFAWM_1   BIT9

 set     PWMA_SM1CAPTCTRLA_CA0CNT    (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWMA_SM1CAPTCTRLA_CA0CNT_0  BIT10
 set     PWMA_SM1CAPTCTRLA_CA0CNT_1  BIT11
 set     PWMA_SM1CAPTCTRLA_CA0CNT_2  BIT12

 set     PWMA_SM1CAPTCTRLA_CA1CNT    (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWMA_SM1CAPTCTRLA_CA1CNT_0  BIT13
 set     PWMA_SM1CAPTCTRLA_CA1CNT_1  BIT14
 set     PWMA_SM1CAPTCTRLA_CA1CNT_2  BIT15

 set     PWMA_SM1CAPTCOMPA_EDGCMPA   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_0 BIT0
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_1 BIT1
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_2 BIT2
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_3 BIT3
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_4 BIT4
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_5 BIT5
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_6 BIT6
 set     PWMA_SM1CAPTCOMPA_EDGCMPA_7 BIT7

 set     PWMA_SM1CAPTCOMPA_EDGCNTA   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_0 BIT8
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_1 BIT9
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_2 BIT10
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_3 BIT11
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_4 BIT12
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_5 BIT13
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_6 BIT14
 set     PWMA_SM1CAPTCOMPA_EDGCNTA_7 BIT15

 set     PWMA_SM1CAPTCTRLB_ARMB      BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWMA_SM1CAPTCTRLB_ONESHOTB  BIT1
;;   One Shot Mode B
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLB[ARMB] is cleared. No further captures will be performed until CAPTCTRLB[ARMB] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLB[ARMB] is then cleared.

 set     PWMA_SM1CAPTCTRLB_EDGB0     (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM1CAPTCTRLB_EDGB0_0   BIT2
 set     PWMA_SM1CAPTCTRLB_EDGB0_1   BIT3

 set     PWMA_SM1CAPTCTRLB_EDGB1     (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM1CAPTCTRLB_EDGB1_0   BIT4
 set     PWMA_SM1CAPTCTRLB_EDGB1_1   BIT5

 set     PWMA_SM1CAPTCTRLB_INP_SELB  BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLB[EDGB0] and CAPTCTRLB[EDGB1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRB[EDGB0] and/or CAPTCTRLB[EDGB1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM1CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM1CAPTCTRLB_CFBWM     (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWMA_SM1CAPTCTRLB_CFBWM_0   BIT8
 set     PWMA_SM1CAPTCTRLB_CFBWM_1   BIT9

 set     PWMA_SM1CAPTCTRLB_CB0CNT    (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWMA_SM1CAPTCTRLB_CB0CNT_0  BIT10
 set     PWMA_SM1CAPTCTRLB_CB0CNT_1  BIT11
 set     PWMA_SM1CAPTCTRLB_CB0CNT_2  BIT12

 set     PWMA_SM1CAPTCTRLB_CB1CNT    (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWMA_SM1CAPTCTRLB_CB1CNT_0  BIT13
 set     PWMA_SM1CAPTCTRLB_CB1CNT_1  BIT14
 set     PWMA_SM1CAPTCTRLB_CB1CNT_2  BIT15

 set     PWMA_SM1CAPTCOMPB_EDGCMPB   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_0 BIT0
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_1 BIT1
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_2 BIT2
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_3 BIT3
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_4 BIT4
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_5 BIT5
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_6 BIT6
 set     PWMA_SM1CAPTCOMPB_EDGCMPB_7 BIT7

 set     PWMA_SM1CAPTCOMPB_EDGCNTB   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_0 BIT8
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_1 BIT9
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_2 BIT10
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_3 BIT11
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_4 BIT12
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_5 BIT13
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_6 BIT14
 set     PWMA_SM1CAPTCOMPB_EDGCNTB_7 BIT15

 set     PWMA_SM1CAPTCTRLX_ARMX      BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWMA_SM1CAPTCTRLX_ONESHOTX  BIT1
;;   One Shot Mode Aux
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and the ARMX bit is cleared. No further captures will be performed until the ARMX bit is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled capture
;;             circuit and the ARMX bit is then cleared.

 set     PWMA_SM1CAPTCTRLX_EDGX0     (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM1CAPTCTRLX_EDGX0_0   BIT2
 set     PWMA_SM1CAPTCTRLX_EDGX0_1   BIT3

 set     PWMA_SM1CAPTCTRLX_EDGX1     (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM1CAPTCTRLX_EDGX1_0   BIT4
 set     PWMA_SM1CAPTCTRLX_EDGX1_1   BIT5

 set     PWMA_SM1CAPTCTRLX_INP_SELX  BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLX[EDGX0] and CAPTCTRLX[EDGX1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRX[EDGX0] and/or CAPTCTRLX[EDGX1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM1CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM1CAPTCTRLX_CFXWM     (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWMA_SM1CAPTCTRLX_CFXWM_0   BIT8
 set     PWMA_SM1CAPTCTRLX_CFXWM_1   BIT9

 set     PWMA_SM1CAPTCTRLX_CX0CNT    (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWMA_SM1CAPTCTRLX_CX0CNT_0  BIT10
 set     PWMA_SM1CAPTCTRLX_CX0CNT_1  BIT11
 set     PWMA_SM1CAPTCTRLX_CX0CNT_2  BIT12

 set     PWMA_SM1CAPTCTRLX_CX1CNT    (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWMA_SM1CAPTCTRLX_CX1CNT_0  BIT13
 set     PWMA_SM1CAPTCTRLX_CX1CNT_1  BIT14
 set     PWMA_SM1CAPTCTRLX_CX1CNT_2  BIT15

 set     PWMA_SM1CAPTCOMPX_EDGCMPX   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_0 BIT0
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_1 BIT1
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_2 BIT2
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_3 BIT3
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_4 BIT4
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_5 BIT5
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_6 BIT6
 set     PWMA_SM1CAPTCOMPX_EDGCMPX_7 BIT7

 set     PWMA_SM1CAPTCOMPX_EDGCNTX   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_0 BIT8
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_1 BIT9
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_2 BIT10
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_3 BIT11
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_4 BIT12
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_5 BIT13
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_6 BIT14
 set     PWMA_SM1CAPTCOMPX_EDGCNTX_7 BIT15

 set     PWMA_SM1CVAL0_CAPTVAL0      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM1CVAL0_CAPTVAL0_0    BIT0
 set     PWMA_SM1CVAL0_CAPTVAL0_1    BIT1
 set     PWMA_SM1CVAL0_CAPTVAL0_2    BIT2
 set     PWMA_SM1CVAL0_CAPTVAL0_3    BIT3
 set     PWMA_SM1CVAL0_CAPTVAL0_4    BIT4
 set     PWMA_SM1CVAL0_CAPTVAL0_5    BIT5
 set     PWMA_SM1CVAL0_CAPTVAL0_6    BIT6
 set     PWMA_SM1CVAL0_CAPTVAL0_7    BIT7
 set     PWMA_SM1CVAL0_CAPTVAL0_8    BIT8
 set     PWMA_SM1CVAL0_CAPTVAL0_9    BIT9
 set     PWMA_SM1CVAL0_CAPTVAL0_10   BIT10
 set     PWMA_SM1CVAL0_CAPTVAL0_11   BIT11
 set     PWMA_SM1CVAL0_CAPTVAL0_12   BIT12
 set     PWMA_SM1CVAL0_CAPTVAL0_13   BIT13
 set     PWMA_SM1CVAL0_CAPTVAL0_14   BIT14
 set     PWMA_SM1CVAL0_CAPTVAL0_15   BIT15

 set     PWMA_SM1CVAL0CYC_CVAL0CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM1CVAL0CYC_CVAL0CYC_0 BIT0
 set     PWMA_SM1CVAL0CYC_CVAL0CYC_1 BIT1
 set     PWMA_SM1CVAL0CYC_CVAL0CYC_2 BIT2
 set     PWMA_SM1CVAL0CYC_CVAL0CYC_3 BIT3

 set     PWMA_SM1CVAL1_CAPTVAL1      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM1CVAL1_CAPTVAL1_0    BIT0
 set     PWMA_SM1CVAL1_CAPTVAL1_1    BIT1
 set     PWMA_SM1CVAL1_CAPTVAL1_2    BIT2
 set     PWMA_SM1CVAL1_CAPTVAL1_3    BIT3
 set     PWMA_SM1CVAL1_CAPTVAL1_4    BIT4
 set     PWMA_SM1CVAL1_CAPTVAL1_5    BIT5
 set     PWMA_SM1CVAL1_CAPTVAL1_6    BIT6
 set     PWMA_SM1CVAL1_CAPTVAL1_7    BIT7
 set     PWMA_SM1CVAL1_CAPTVAL1_8    BIT8
 set     PWMA_SM1CVAL1_CAPTVAL1_9    BIT9
 set     PWMA_SM1CVAL1_CAPTVAL1_10   BIT10
 set     PWMA_SM1CVAL1_CAPTVAL1_11   BIT11
 set     PWMA_SM1CVAL1_CAPTVAL1_12   BIT12
 set     PWMA_SM1CVAL1_CAPTVAL1_13   BIT13
 set     PWMA_SM1CVAL1_CAPTVAL1_14   BIT14
 set     PWMA_SM1CVAL1_CAPTVAL1_15   BIT15

 set     PWMA_SM1CVAL1CYC_CVAL1CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM1CVAL1CYC_CVAL1CYC_0 BIT0
 set     PWMA_SM1CVAL1CYC_CVAL1CYC_1 BIT1
 set     PWMA_SM1CVAL1CYC_CVAL1CYC_2 BIT2
 set     PWMA_SM1CVAL1CYC_CVAL1CYC_3 BIT3

 set     PWMA_SM1CVAL2_CAPTVAL2      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM1CVAL2_CAPTVAL2_0    BIT0
 set     PWMA_SM1CVAL2_CAPTVAL2_1    BIT1
 set     PWMA_SM1CVAL2_CAPTVAL2_2    BIT2
 set     PWMA_SM1CVAL2_CAPTVAL2_3    BIT3
 set     PWMA_SM1CVAL2_CAPTVAL2_4    BIT4
 set     PWMA_SM1CVAL2_CAPTVAL2_5    BIT5
 set     PWMA_SM1CVAL2_CAPTVAL2_6    BIT6
 set     PWMA_SM1CVAL2_CAPTVAL2_7    BIT7
 set     PWMA_SM1CVAL2_CAPTVAL2_8    BIT8
 set     PWMA_SM1CVAL2_CAPTVAL2_9    BIT9
 set     PWMA_SM1CVAL2_CAPTVAL2_10   BIT10
 set     PWMA_SM1CVAL2_CAPTVAL2_11   BIT11
 set     PWMA_SM1CVAL2_CAPTVAL2_12   BIT12
 set     PWMA_SM1CVAL2_CAPTVAL2_13   BIT13
 set     PWMA_SM1CVAL2_CAPTVAL2_14   BIT14
 set     PWMA_SM1CVAL2_CAPTVAL2_15   BIT15

 set     PWMA_SM1CVAL2CYC_CVAL2CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM1CVAL2CYC_CVAL2CYC_0 BIT0
 set     PWMA_SM1CVAL2CYC_CVAL2CYC_1 BIT1
 set     PWMA_SM1CVAL2CYC_CVAL2CYC_2 BIT2
 set     PWMA_SM1CVAL2CYC_CVAL2CYC_3 BIT3

 set     PWMA_SM1CVAL3_CAPTVAL3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM1CVAL3_CAPTVAL3_0    BIT0
 set     PWMA_SM1CVAL3_CAPTVAL3_1    BIT1
 set     PWMA_SM1CVAL3_CAPTVAL3_2    BIT2
 set     PWMA_SM1CVAL3_CAPTVAL3_3    BIT3
 set     PWMA_SM1CVAL3_CAPTVAL3_4    BIT4
 set     PWMA_SM1CVAL3_CAPTVAL3_5    BIT5
 set     PWMA_SM1CVAL3_CAPTVAL3_6    BIT6
 set     PWMA_SM1CVAL3_CAPTVAL3_7    BIT7
 set     PWMA_SM1CVAL3_CAPTVAL3_8    BIT8
 set     PWMA_SM1CVAL3_CAPTVAL3_9    BIT9
 set     PWMA_SM1CVAL3_CAPTVAL3_10   BIT10
 set     PWMA_SM1CVAL3_CAPTVAL3_11   BIT11
 set     PWMA_SM1CVAL3_CAPTVAL3_12   BIT12
 set     PWMA_SM1CVAL3_CAPTVAL3_13   BIT13
 set     PWMA_SM1CVAL3_CAPTVAL3_14   BIT14
 set     PWMA_SM1CVAL3_CAPTVAL3_15   BIT15

 set     PWMA_SM1CVAL3CYC_CVAL3CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM1CVAL3CYC_CVAL3CYC_0 BIT0
 set     PWMA_SM1CVAL3CYC_CVAL3CYC_1 BIT1
 set     PWMA_SM1CVAL3CYC_CVAL3CYC_2 BIT2
 set     PWMA_SM1CVAL3CYC_CVAL3CYC_3 BIT3

 set     PWMA_SM1CVAL4_CAPTVAL4      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM1CVAL4_CAPTVAL4_0    BIT0
 set     PWMA_SM1CVAL4_CAPTVAL4_1    BIT1
 set     PWMA_SM1CVAL4_CAPTVAL4_2    BIT2
 set     PWMA_SM1CVAL4_CAPTVAL4_3    BIT3
 set     PWMA_SM1CVAL4_CAPTVAL4_4    BIT4
 set     PWMA_SM1CVAL4_CAPTVAL4_5    BIT5
 set     PWMA_SM1CVAL4_CAPTVAL4_6    BIT6
 set     PWMA_SM1CVAL4_CAPTVAL4_7    BIT7
 set     PWMA_SM1CVAL4_CAPTVAL4_8    BIT8
 set     PWMA_SM1CVAL4_CAPTVAL4_9    BIT9
 set     PWMA_SM1CVAL4_CAPTVAL4_10   BIT10
 set     PWMA_SM1CVAL4_CAPTVAL4_11   BIT11
 set     PWMA_SM1CVAL4_CAPTVAL4_12   BIT12
 set     PWMA_SM1CVAL4_CAPTVAL4_13   BIT13
 set     PWMA_SM1CVAL4_CAPTVAL4_14   BIT14
 set     PWMA_SM1CVAL4_CAPTVAL4_15   BIT15

 set     PWMA_SM1CVAL4CYC_CVAL4CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM1CVAL4CYC_CVAL4CYC_0 BIT0
 set     PWMA_SM1CVAL4CYC_CVAL4CYC_1 BIT1
 set     PWMA_SM1CVAL4CYC_CVAL4CYC_2 BIT2
 set     PWMA_SM1CVAL4CYC_CVAL4CYC_3 BIT3

 set     PWMA_SM1CVAL5_CAPTVAL5      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM1CVAL5_CAPTVAL5_0    BIT0
 set     PWMA_SM1CVAL5_CAPTVAL5_1    BIT1
 set     PWMA_SM1CVAL5_CAPTVAL5_2    BIT2
 set     PWMA_SM1CVAL5_CAPTVAL5_3    BIT3
 set     PWMA_SM1CVAL5_CAPTVAL5_4    BIT4
 set     PWMA_SM1CVAL5_CAPTVAL5_5    BIT5
 set     PWMA_SM1CVAL5_CAPTVAL5_6    BIT6
 set     PWMA_SM1CVAL5_CAPTVAL5_7    BIT7
 set     PWMA_SM1CVAL5_CAPTVAL5_8    BIT8
 set     PWMA_SM1CVAL5_CAPTVAL5_9    BIT9
 set     PWMA_SM1CVAL5_CAPTVAL5_10   BIT10
 set     PWMA_SM1CVAL5_CAPTVAL5_11   BIT11
 set     PWMA_SM1CVAL5_CAPTVAL5_12   BIT12
 set     PWMA_SM1CVAL5_CAPTVAL5_13   BIT13
 set     PWMA_SM1CVAL5_CAPTVAL5_14   BIT14
 set     PWMA_SM1CVAL5_CAPTVAL5_15   BIT15

 set     PWMA_SM1CVAL5CYC_CVAL5CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM1CVAL5CYC_CVAL5CYC_0 BIT0
 set     PWMA_SM1CVAL5CYC_CVAL5CYC_1 BIT1
 set     PWMA_SM1CVAL5CYC_CVAL5CYC_2 BIT2
 set     PWMA_SM1CVAL5CYC_CVAL5CYC_3 BIT3

 set     PWMA_SM2CNT_CNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWMA_SM2CNT_CNT_0           BIT0
 set     PWMA_SM2CNT_CNT_1           BIT1
 set     PWMA_SM2CNT_CNT_2           BIT2
 set     PWMA_SM2CNT_CNT_3           BIT3
 set     PWMA_SM2CNT_CNT_4           BIT4
 set     PWMA_SM2CNT_CNT_5           BIT5
 set     PWMA_SM2CNT_CNT_6           BIT6
 set     PWMA_SM2CNT_CNT_7           BIT7
 set     PWMA_SM2CNT_CNT_8           BIT8
 set     PWMA_SM2CNT_CNT_9           BIT9
 set     PWMA_SM2CNT_CNT_10          BIT10
 set     PWMA_SM2CNT_CNT_11          BIT11
 set     PWMA_SM2CNT_CNT_12          BIT12
 set     PWMA_SM2CNT_CNT_13          BIT13
 set     PWMA_SM2CNT_CNT_14          BIT14
 set     PWMA_SM2CNT_CNT_15          BIT15

 set     PWMA_SM2INIT_INIT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWMA_SM2INIT_INIT_0         BIT0
 set     PWMA_SM2INIT_INIT_1         BIT1
 set     PWMA_SM2INIT_INIT_2         BIT2
 set     PWMA_SM2INIT_INIT_3         BIT3
 set     PWMA_SM2INIT_INIT_4         BIT4
 set     PWMA_SM2INIT_INIT_5         BIT5
 set     PWMA_SM2INIT_INIT_6         BIT6
 set     PWMA_SM2INIT_INIT_7         BIT7
 set     PWMA_SM2INIT_INIT_8         BIT8
 set     PWMA_SM2INIT_INIT_9         BIT9
 set     PWMA_SM2INIT_INIT_10        BIT10
 set     PWMA_SM2INIT_INIT_11        BIT11
 set     PWMA_SM2INIT_INIT_12        BIT12
 set     PWMA_SM2INIT_INIT_13        BIT13
 set     PWMA_SM2INIT_INIT_14        BIT14
 set     PWMA_SM2INIT_INIT_15        BIT15

 set     PWMA_SM2CTRL2_CLK_SEL       (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWMA_SM2CTRL2_CLK_SEL_0     BIT0
 set     PWMA_SM2CTRL2_CLK_SEL_1     BIT1

 set     PWMA_SM2CTRL2_RELOAD_SEL    BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWMA_SM2CTRL2_FORCE_SEL     (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWMA_SM2CTRL2_FORCE_SEL_0   BIT3
 set     PWMA_SM2CTRL2_FORCE_SEL_1   BIT4
 set     PWMA_SM2CTRL2_FORCE_SEL_2   BIT5

 set     PWMA_SM2CTRL2_FORCE         BIT6
;;   Force Initialization

 set     PWMA_SM2CTRL2_FRCEN         BIT7
;;   Force Initialization Enable
;;     0b0 ==> Initialization from a FORCE_OUT event is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT event is enabled.

 set     PWMA_SM2CTRL2_INIT_SEL      (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWMA_SM2CTRL2_INIT_SEL_0    BIT8
 set     PWMA_SM2CTRL2_INIT_SEL_1    BIT9

 set     PWMA_SM2CTRL2_PWMX_INIT     BIT10
;;   PWM_X Initial Value

 set     PWMA_SM2CTRL2_PWM45_INIT    BIT11
;;   PWM45 Initial Value

 set     PWMA_SM2CTRL2_PWM23_INIT    BIT12
;;   PWM23 Initial Value

 set     PWMA_SM2CTRL2_INDEP         BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWMA_SM2CTRL2_WAITEN        BIT14
;;   WAIT Enable

 set     PWMA_SM2CTRL2_DBGEN         BIT15
;;   Debug Enable

 set     PWMA_SM2CTRL_DBLEN          BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWMA_SM2CTRL_DBLX           BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWMA_SM2CTRL_LDMOD          BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWMA_SM2CTRL_PRSC           (BIT4|BIT5|BIT6)
;;   Prescaler
;;     0b000 ==> PWM clock frequency = fclk
;;     0b001 ==> PWM clock frequency = fclk/2
;;     0b010 ==> PWM clock frequency = fclk/4
;;     0b011 ==> PWM clock frequency = fclk/8
;;     0b100 ==> PWM clock frequency = fclk/16
;;     0b101 ==> PWM clock frequency = fclk/32
;;     0b110 ==> PWM clock frequency = fclk/64
;;     0b111 ==> PWM clock frequency = fclk/128
 set     PWMA_SM2CTRL_PRSC_0         BIT4
 set     PWMA_SM2CTRL_PRSC_1         BIT5
 set     PWMA_SM2CTRL_PRSC_2         BIT6

 set     PWMA_SM2CTRL_DT             (BIT8|BIT9)
;;   Deadtime
 set     PWMA_SM2CTRL_DT_0           BIT8
 set     PWMA_SM2CTRL_DT_1           BIT9

 set     PWMA_SM2CTRL_FULL           BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWMA_SM2CTRL_HALF           BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWMA_SM2CTRL_LDFQ           (BIT12|BIT13|BIT14|BIT15)
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWMA_SM2CTRL_LDFQ_0         BIT12
 set     PWMA_SM2CTRL_LDFQ_1         BIT13
 set     PWMA_SM2CTRL_LDFQ_2         BIT14
 set     PWMA_SM2CTRL_LDFQ_3         BIT15

 set     PWMA_SM2VAL0_VAL0           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWMA_SM2VAL0_VAL0_0         BIT0
 set     PWMA_SM2VAL0_VAL0_1         BIT1
 set     PWMA_SM2VAL0_VAL0_2         BIT2
 set     PWMA_SM2VAL0_VAL0_3         BIT3
 set     PWMA_SM2VAL0_VAL0_4         BIT4
 set     PWMA_SM2VAL0_VAL0_5         BIT5
 set     PWMA_SM2VAL0_VAL0_6         BIT6
 set     PWMA_SM2VAL0_VAL0_7         BIT7
 set     PWMA_SM2VAL0_VAL0_8         BIT8
 set     PWMA_SM2VAL0_VAL0_9         BIT9
 set     PWMA_SM2VAL0_VAL0_10        BIT10
 set     PWMA_SM2VAL0_VAL0_11        BIT11
 set     PWMA_SM2VAL0_VAL0_12        BIT12
 set     PWMA_SM2VAL0_VAL0_13        BIT13
 set     PWMA_SM2VAL0_VAL0_14        BIT14
 set     PWMA_SM2VAL0_VAL0_15        BIT15

 set     PWMA_SM2FRACVAL1_FRACVAL1   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWMA_SM2FRACVAL1_FRACVAL1_0 BIT11
 set     PWMA_SM2FRACVAL1_FRACVAL1_1 BIT12
 set     PWMA_SM2FRACVAL1_FRACVAL1_2 BIT13
 set     PWMA_SM2FRACVAL1_FRACVAL1_3 BIT14
 set     PWMA_SM2FRACVAL1_FRACVAL1_4 BIT15

 set     PWMA_SM2VAL1_VAL1           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWMA_SM2VAL1_VAL1_0         BIT0
 set     PWMA_SM2VAL1_VAL1_1         BIT1
 set     PWMA_SM2VAL1_VAL1_2         BIT2
 set     PWMA_SM2VAL1_VAL1_3         BIT3
 set     PWMA_SM2VAL1_VAL1_4         BIT4
 set     PWMA_SM2VAL1_VAL1_5         BIT5
 set     PWMA_SM2VAL1_VAL1_6         BIT6
 set     PWMA_SM2VAL1_VAL1_7         BIT7
 set     PWMA_SM2VAL1_VAL1_8         BIT8
 set     PWMA_SM2VAL1_VAL1_9         BIT9
 set     PWMA_SM2VAL1_VAL1_10        BIT10
 set     PWMA_SM2VAL1_VAL1_11        BIT11
 set     PWMA_SM2VAL1_VAL1_12        BIT12
 set     PWMA_SM2VAL1_VAL1_13        BIT13
 set     PWMA_SM2VAL1_VAL1_14        BIT14
 set     PWMA_SM2VAL1_VAL1_15        BIT15

 set     PWMA_SM2FRACVAL2_FRACVAL2   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWMA_SM2FRACVAL2_FRACVAL2_0 BIT11
 set     PWMA_SM2FRACVAL2_FRACVAL2_1 BIT12
 set     PWMA_SM2FRACVAL2_FRACVAL2_2 BIT13
 set     PWMA_SM2FRACVAL2_FRACVAL2_3 BIT14
 set     PWMA_SM2FRACVAL2_FRACVAL2_4 BIT15

 set     PWMA_SM2VAL2_VAL2           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWMA_SM2VAL2_VAL2_0         BIT0
 set     PWMA_SM2VAL2_VAL2_1         BIT1
 set     PWMA_SM2VAL2_VAL2_2         BIT2
 set     PWMA_SM2VAL2_VAL2_3         BIT3
 set     PWMA_SM2VAL2_VAL2_4         BIT4
 set     PWMA_SM2VAL2_VAL2_5         BIT5
 set     PWMA_SM2VAL2_VAL2_6         BIT6
 set     PWMA_SM2VAL2_VAL2_7         BIT7
 set     PWMA_SM2VAL2_VAL2_8         BIT8
 set     PWMA_SM2VAL2_VAL2_9         BIT9
 set     PWMA_SM2VAL2_VAL2_10        BIT10
 set     PWMA_SM2VAL2_VAL2_11        BIT11
 set     PWMA_SM2VAL2_VAL2_12        BIT12
 set     PWMA_SM2VAL2_VAL2_13        BIT13
 set     PWMA_SM2VAL2_VAL2_14        BIT14
 set     PWMA_SM2VAL2_VAL2_15        BIT15

 set     PWMA_SM2FRACVAL3_FRACVAL3   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWMA_SM2FRACVAL3_FRACVAL3_0 BIT11
 set     PWMA_SM2FRACVAL3_FRACVAL3_1 BIT12
 set     PWMA_SM2FRACVAL3_FRACVAL3_2 BIT13
 set     PWMA_SM2FRACVAL3_FRACVAL3_3 BIT14
 set     PWMA_SM2FRACVAL3_FRACVAL3_4 BIT15

 set     PWMA_SM2VAL3_VAL3           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWMA_SM2VAL3_VAL3_0         BIT0
 set     PWMA_SM2VAL3_VAL3_1         BIT1
 set     PWMA_SM2VAL3_VAL3_2         BIT2
 set     PWMA_SM2VAL3_VAL3_3         BIT3
 set     PWMA_SM2VAL3_VAL3_4         BIT4
 set     PWMA_SM2VAL3_VAL3_5         BIT5
 set     PWMA_SM2VAL3_VAL3_6         BIT6
 set     PWMA_SM2VAL3_VAL3_7         BIT7
 set     PWMA_SM2VAL3_VAL3_8         BIT8
 set     PWMA_SM2VAL3_VAL3_9         BIT9
 set     PWMA_SM2VAL3_VAL3_10        BIT10
 set     PWMA_SM2VAL3_VAL3_11        BIT11
 set     PWMA_SM2VAL3_VAL3_12        BIT12
 set     PWMA_SM2VAL3_VAL3_13        BIT13
 set     PWMA_SM2VAL3_VAL3_14        BIT14
 set     PWMA_SM2VAL3_VAL3_15        BIT15

 set     PWMA_SM2FRACVAL4_FRACVAL4   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWMA_SM2FRACVAL4_FRACVAL4_0 BIT11
 set     PWMA_SM2FRACVAL4_FRACVAL4_1 BIT12
 set     PWMA_SM2FRACVAL4_FRACVAL4_2 BIT13
 set     PWMA_SM2FRACVAL4_FRACVAL4_3 BIT14
 set     PWMA_SM2FRACVAL4_FRACVAL4_4 BIT15

 set     PWMA_SM2VAL4_VAL4           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWMA_SM2VAL4_VAL4_0         BIT0
 set     PWMA_SM2VAL4_VAL4_1         BIT1
 set     PWMA_SM2VAL4_VAL4_2         BIT2
 set     PWMA_SM2VAL4_VAL4_3         BIT3
 set     PWMA_SM2VAL4_VAL4_4         BIT4
 set     PWMA_SM2VAL4_VAL4_5         BIT5
 set     PWMA_SM2VAL4_VAL4_6         BIT6
 set     PWMA_SM2VAL4_VAL4_7         BIT7
 set     PWMA_SM2VAL4_VAL4_8         BIT8
 set     PWMA_SM2VAL4_VAL4_9         BIT9
 set     PWMA_SM2VAL4_VAL4_10        BIT10
 set     PWMA_SM2VAL4_VAL4_11        BIT11
 set     PWMA_SM2VAL4_VAL4_12        BIT12
 set     PWMA_SM2VAL4_VAL4_13        BIT13
 set     PWMA_SM2VAL4_VAL4_14        BIT14
 set     PWMA_SM2VAL4_VAL4_15        BIT15

 set     PWMA_SM2FRACVAL5_FRACVAL5   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWMA_SM2FRACVAL5_FRACVAL5_0 BIT11
 set     PWMA_SM2FRACVAL5_FRACVAL5_1 BIT12
 set     PWMA_SM2FRACVAL5_FRACVAL5_2 BIT13
 set     PWMA_SM2FRACVAL5_FRACVAL5_3 BIT14
 set     PWMA_SM2FRACVAL5_FRACVAL5_4 BIT15

 set     PWMA_SM2VAL5_VAL5           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWMA_SM2VAL5_VAL5_0         BIT0
 set     PWMA_SM2VAL5_VAL5_1         BIT1
 set     PWMA_SM2VAL5_VAL5_2         BIT2
 set     PWMA_SM2VAL5_VAL5_3         BIT3
 set     PWMA_SM2VAL5_VAL5_4         BIT4
 set     PWMA_SM2VAL5_VAL5_5         BIT5
 set     PWMA_SM2VAL5_VAL5_6         BIT6
 set     PWMA_SM2VAL5_VAL5_7         BIT7
 set     PWMA_SM2VAL5_VAL5_8         BIT8
 set     PWMA_SM2VAL5_VAL5_9         BIT9
 set     PWMA_SM2VAL5_VAL5_10        BIT10
 set     PWMA_SM2VAL5_VAL5_11        BIT11
 set     PWMA_SM2VAL5_VAL5_12        BIT12
 set     PWMA_SM2VAL5_VAL5_13        BIT13
 set     PWMA_SM2VAL5_VAL5_14        BIT14
 set     PWMA_SM2VAL5_VAL5_15        BIT15

 set     PWMA_SM2FRCTRL_FRAC1_EN     BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWMA_SM2FRCTRL_FRAC23_EN    BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWMA_SM2FRCTRL_FRAC45_EN    BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWMA_SM2FRCTRL_FRAC_PU      BIT8
;;   Fractional Delay Circuit Power Up
;;     0b0 ==> Turn off fractional delay logic.
;;     0b1 ==> Power up fractional delay logic.

 set     PWMA_SM2FRCTRL_TEST         BIT15
;;   Test Status Bit

 set     PWMA_SM2OCTRL_PWMXFS        (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM2OCTRL_PWMXFS_0      BIT0
 set     PWMA_SM2OCTRL_PWMXFS_1      BIT1

 set     PWMA_SM2OCTRL_PWMBFS        (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM2OCTRL_PWMBFS_0      BIT2
 set     PWMA_SM2OCTRL_PWMBFS_1      BIT3

 set     PWMA_SM2OCTRL_PWMAFS        (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM2OCTRL_PWMAFS_0      BIT4
 set     PWMA_SM2OCTRL_PWMAFS_1      BIT5

 set     PWMA_SM2OCTRL_POLX          BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWMA_SM2OCTRL_POLB          BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWMA_SM2OCTRL_POLA          BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWMA_SM2OCTRL_PWMX_IN       BIT13
;;   PWM_X Input

 set     PWMA_SM2OCTRL_PWMB_IN       BIT14
;;   PWM_B Input

 set     PWMA_SM2OCTRL_PWMA_IN       BIT15
;;   PWM_A Input

 set     PWMA_SM2STS_CMPF            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b0 ==> No compare event has occurred for a particular VALx value.
;;     0b1 ==> A compare event has occurred for a particular VALx value.
 set     PWMA_SM2STS_CMPF_0          BIT0
 set     PWMA_SM2STS_CMPF_1          BIT1
 set     PWMA_SM2STS_CMPF_2          BIT2
 set     PWMA_SM2STS_CMPF_3          BIT3
 set     PWMA_SM2STS_CMPF_4          BIT4
 set     PWMA_SM2STS_CMPF_5          BIT5

 set     PWMA_SM2STS_CFX0            BIT6
;;   Capture Flag X0

 set     PWMA_SM2STS_CFX1            BIT7
;;   Capture Flag X1

 set     PWMA_SM2STS_CFB0            BIT8
;;   Capture Flag B0

 set     PWMA_SM2STS_CFB1            BIT9
;;   Capture Flag B1

 set     PWMA_SM2STS_CFA0            BIT10
;;   Capture Flag A0

 set     PWMA_SM2STS_CFA1            BIT11
;;   Capture Flag A1

 set     PWMA_SM2STS_RF              BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWMA_SM2STS_REF             BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWMA_SM2STS_RUF             BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWMA_SM2INTEN_CMPIE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b0 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b1 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWMA_SM2INTEN_CMPIE_0       BIT0
 set     PWMA_SM2INTEN_CMPIE_1       BIT1
 set     PWMA_SM2INTEN_CMPIE_2       BIT2
 set     PWMA_SM2INTEN_CMPIE_3       BIT3
 set     PWMA_SM2INTEN_CMPIE_4       BIT4
 set     PWMA_SM2INTEN_CMPIE_5       BIT5

 set     PWMA_SM2INTEN_CX0IE         BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWMA_SM2INTEN_CX1IE         BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWMA_SM2INTEN_CB0IE         BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWMA_SM2INTEN_CB1IE         BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWMA_SM2INTEN_CA0IE         BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWMA_SM2INTEN_CA1IE         BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWMA_SM2INTEN_RIE           BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWMA_SM2INTEN_REIE          BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWMA_SM2DMAEN_CX0DE         BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWMA_SM2DMAEN_CX1DE         BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWMA_SM2DMAEN_CB0DE         BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWMA_SM2DMAEN_CB1DE         BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWMA_SM2DMAEN_CA0DE         BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWMA_SM2DMAEN_CA1DE         BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWMA_SM2DMAEN_CAPTDE        (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWMA_SM2DMAEN_CAPTDE_0      BIT6
 set     PWMA_SM2DMAEN_CAPTDE_1      BIT7

 set     PWMA_SM2DMAEN_FAND          BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWMA_SM2DMAEN_VALDE         BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled
;;     0b1 ==> DMA write requests for the VALx and FRACVALx registers enabled

 set     PWMA_SM2TCTRL_OUT_TRIG_EN   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0b0 ==> PWM_OUT_TRIGx will not set when the counter value matches the VALx value.
;;     0b1 ==> PWM_OUT_TRIGx will set when the counter value matches the VALx value.
 set     PWMA_SM2TCTRL_OUT_TRIG_EN_0 BIT0
 set     PWMA_SM2TCTRL_OUT_TRIG_EN_1 BIT1
 set     PWMA_SM2TCTRL_OUT_TRIG_EN_2 BIT2
 set     PWMA_SM2TCTRL_OUT_TRIG_EN_3 BIT3
 set     PWMA_SM2TCTRL_OUT_TRIG_EN_4 BIT4
 set     PWMA_SM2TCTRL_OUT_TRIG_EN_5 BIT5

 set     PWMA_SM2TCTRL_PWBOT1        BIT14
;;   Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_OUT_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_OUT_TRIG1 port.

 set     PWMA_SM2TCTRL_PWAOT0        BIT15
;;   Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_OUT_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_OUT_TRIG0 port.

 set     PWMA_SM2DISMAP0_DIS0A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWMA_SM2DISMAP0_DIS0A_0     BIT0
 set     PWMA_SM2DISMAP0_DIS0A_1     BIT1
 set     PWMA_SM2DISMAP0_DIS0A_2     BIT2
 set     PWMA_SM2DISMAP0_DIS0A_3     BIT3

 set     PWMA_SM2DISMAP0_DIS0B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWMA_SM2DISMAP0_DIS0B_0     BIT4
 set     PWMA_SM2DISMAP0_DIS0B_1     BIT5
 set     PWMA_SM2DISMAP0_DIS0B_2     BIT6
 set     PWMA_SM2DISMAP0_DIS0B_3     BIT7

 set     PWMA_SM2DISMAP0_DIS0X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWMA_SM2DISMAP0_DIS0X_0     BIT8
 set     PWMA_SM2DISMAP0_DIS0X_1     BIT9
 set     PWMA_SM2DISMAP0_DIS0X_2     BIT10
 set     PWMA_SM2DISMAP0_DIS0X_3     BIT11

 set     PWMA_SM2DISMAP1_DIS1A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWMA_SM2DISMAP1_DIS1A_0     BIT0
 set     PWMA_SM2DISMAP1_DIS1A_1     BIT1
 set     PWMA_SM2DISMAP1_DIS1A_2     BIT2
 set     PWMA_SM2DISMAP1_DIS1A_3     BIT3

 set     PWMA_SM2DISMAP1_DIS1B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWMA_SM2DISMAP1_DIS1B_0     BIT4
 set     PWMA_SM2DISMAP1_DIS1B_1     BIT5
 set     PWMA_SM2DISMAP1_DIS1B_2     BIT6
 set     PWMA_SM2DISMAP1_DIS1B_3     BIT7

 set     PWMA_SM2DISMAP1_DIS1X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWMA_SM2DISMAP1_DIS1X_0     BIT8
 set     PWMA_SM2DISMAP1_DIS1X_1     BIT9
 set     PWMA_SM2DISMAP1_DIS1X_2     BIT10
 set     PWMA_SM2DISMAP1_DIS1X_3     BIT11

 set     PWMA_SM2DTCNT0_DTCNT0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 0
 set     PWMA_SM2DTCNT0_DTCNT0_0     BIT0
 set     PWMA_SM2DTCNT0_DTCNT0_1     BIT1
 set     PWMA_SM2DTCNT0_DTCNT0_2     BIT2
 set     PWMA_SM2DTCNT0_DTCNT0_3     BIT3
 set     PWMA_SM2DTCNT0_DTCNT0_4     BIT4
 set     PWMA_SM2DTCNT0_DTCNT0_5     BIT5
 set     PWMA_SM2DTCNT0_DTCNT0_6     BIT6
 set     PWMA_SM2DTCNT0_DTCNT0_7     BIT7
 set     PWMA_SM2DTCNT0_DTCNT0_8     BIT8
 set     PWMA_SM2DTCNT0_DTCNT0_9     BIT9
 set     PWMA_SM2DTCNT0_DTCNT0_10    BIT10

 set     PWMA_SM2DTCNT1_DTCNT1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 1
 set     PWMA_SM2DTCNT1_DTCNT1_0     BIT0
 set     PWMA_SM2DTCNT1_DTCNT1_1     BIT1
 set     PWMA_SM2DTCNT1_DTCNT1_2     BIT2
 set     PWMA_SM2DTCNT1_DTCNT1_3     BIT3
 set     PWMA_SM2DTCNT1_DTCNT1_4     BIT4
 set     PWMA_SM2DTCNT1_DTCNT1_5     BIT5
 set     PWMA_SM2DTCNT1_DTCNT1_6     BIT6
 set     PWMA_SM2DTCNT1_DTCNT1_7     BIT7
 set     PWMA_SM2DTCNT1_DTCNT1_8     BIT8
 set     PWMA_SM2DTCNT1_DTCNT1_9     BIT9
 set     PWMA_SM2DTCNT1_DTCNT1_10    BIT10

 set     PWMA_SM2CAPTCTRLA_ARMA      BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWMA_SM2CAPTCTRLA_ONESHOTA  BIT1
;;   One Shot Mode A
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLA[ARMA] is cleared. No further captures will be performed until CAPTCTRLA[ARMA] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLA[ARMA] is then cleared.

 set     PWMA_SM2CAPTCTRLA_EDGA0     (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM2CAPTCTRLA_EDGA0_0   BIT2
 set     PWMA_SM2CAPTCTRLA_EDGA0_1   BIT3

 set     PWMA_SM2CAPTCTRLA_EDGA1     (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM2CAPTCTRLA_EDGA1_0   BIT4
 set     PWMA_SM2CAPTCTRLA_EDGA1_1   BIT5

 set     PWMA_SM2CAPTCTRLA_INP_SELA  BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLA[EDGA0] and CAPTCTRLA[EDGA1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRA[EDGA0] and/or CAPTCTRLA[EDGA1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM2CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM2CAPTCTRLA_CFAWM     (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWMA_SM2CAPTCTRLA_CFAWM_0   BIT8
 set     PWMA_SM2CAPTCTRLA_CFAWM_1   BIT9

 set     PWMA_SM2CAPTCTRLA_CA0CNT    (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWMA_SM2CAPTCTRLA_CA0CNT_0  BIT10
 set     PWMA_SM2CAPTCTRLA_CA0CNT_1  BIT11
 set     PWMA_SM2CAPTCTRLA_CA0CNT_2  BIT12

 set     PWMA_SM2CAPTCTRLA_CA1CNT    (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWMA_SM2CAPTCTRLA_CA1CNT_0  BIT13
 set     PWMA_SM2CAPTCTRLA_CA1CNT_1  BIT14
 set     PWMA_SM2CAPTCTRLA_CA1CNT_2  BIT15

 set     PWMA_SM2CAPTCOMPA_EDGCMPA   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_0 BIT0
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_1 BIT1
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_2 BIT2
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_3 BIT3
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_4 BIT4
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_5 BIT5
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_6 BIT6
 set     PWMA_SM2CAPTCOMPA_EDGCMPA_7 BIT7

 set     PWMA_SM2CAPTCOMPA_EDGCNTA   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_0 BIT8
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_1 BIT9
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_2 BIT10
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_3 BIT11
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_4 BIT12
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_5 BIT13
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_6 BIT14
 set     PWMA_SM2CAPTCOMPA_EDGCNTA_7 BIT15

 set     PWMA_SM2CAPTCTRLB_ARMB      BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWMA_SM2CAPTCTRLB_ONESHOTB  BIT1
;;   One Shot Mode B
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLB[ARMB] is cleared. No further captures will be performed until CAPTCTRLB[ARMB] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLB[ARMB] is then cleared.

 set     PWMA_SM2CAPTCTRLB_EDGB0     (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM2CAPTCTRLB_EDGB0_0   BIT2
 set     PWMA_SM2CAPTCTRLB_EDGB0_1   BIT3

 set     PWMA_SM2CAPTCTRLB_EDGB1     (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM2CAPTCTRLB_EDGB1_0   BIT4
 set     PWMA_SM2CAPTCTRLB_EDGB1_1   BIT5

 set     PWMA_SM2CAPTCTRLB_INP_SELB  BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLB[EDGB0] and CAPTCTRLB[EDGB1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRB[EDGB0] and/or CAPTCTRLB[EDGB1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM2CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM2CAPTCTRLB_CFBWM     (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWMA_SM2CAPTCTRLB_CFBWM_0   BIT8
 set     PWMA_SM2CAPTCTRLB_CFBWM_1   BIT9

 set     PWMA_SM2CAPTCTRLB_CB0CNT    (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWMA_SM2CAPTCTRLB_CB0CNT_0  BIT10
 set     PWMA_SM2CAPTCTRLB_CB0CNT_1  BIT11
 set     PWMA_SM2CAPTCTRLB_CB0CNT_2  BIT12

 set     PWMA_SM2CAPTCTRLB_CB1CNT    (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWMA_SM2CAPTCTRLB_CB1CNT_0  BIT13
 set     PWMA_SM2CAPTCTRLB_CB1CNT_1  BIT14
 set     PWMA_SM2CAPTCTRLB_CB1CNT_2  BIT15

 set     PWMA_SM2CAPTCOMPB_EDGCMPB   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_0 BIT0
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_1 BIT1
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_2 BIT2
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_3 BIT3
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_4 BIT4
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_5 BIT5
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_6 BIT6
 set     PWMA_SM2CAPTCOMPB_EDGCMPB_7 BIT7

 set     PWMA_SM2CAPTCOMPB_EDGCNTB   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_0 BIT8
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_1 BIT9
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_2 BIT10
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_3 BIT11
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_4 BIT12
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_5 BIT13
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_6 BIT14
 set     PWMA_SM2CAPTCOMPB_EDGCNTB_7 BIT15

 set     PWMA_SM2CAPTCTRLX_ARMX      BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWMA_SM2CAPTCTRLX_ONESHOTX  BIT1
;;   One Shot Mode Aux
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and the ARMX bit is cleared. No further captures will be performed until the ARMX bit is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled capture
;;             circuit and the ARMX bit is then cleared.

 set     PWMA_SM2CAPTCTRLX_EDGX0     (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM2CAPTCTRLX_EDGX0_0   BIT2
 set     PWMA_SM2CAPTCTRLX_EDGX0_1   BIT3

 set     PWMA_SM2CAPTCTRLX_EDGX1     (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM2CAPTCTRLX_EDGX1_0   BIT4
 set     PWMA_SM2CAPTCTRLX_EDGX1_1   BIT5

 set     PWMA_SM2CAPTCTRLX_INP_SELX  BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLX[EDGX0] and CAPTCTRLX[EDGX1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRX[EDGX0] and/or CAPTCTRLX[EDGX1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM2CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM2CAPTCTRLX_CFXWM     (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWMA_SM2CAPTCTRLX_CFXWM_0   BIT8
 set     PWMA_SM2CAPTCTRLX_CFXWM_1   BIT9

 set     PWMA_SM2CAPTCTRLX_CX0CNT    (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWMA_SM2CAPTCTRLX_CX0CNT_0  BIT10
 set     PWMA_SM2CAPTCTRLX_CX0CNT_1  BIT11
 set     PWMA_SM2CAPTCTRLX_CX0CNT_2  BIT12

 set     PWMA_SM2CAPTCTRLX_CX1CNT    (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWMA_SM2CAPTCTRLX_CX1CNT_0  BIT13
 set     PWMA_SM2CAPTCTRLX_CX1CNT_1  BIT14
 set     PWMA_SM2CAPTCTRLX_CX1CNT_2  BIT15

 set     PWMA_SM2CAPTCOMPX_EDGCMPX   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_0 BIT0
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_1 BIT1
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_2 BIT2
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_3 BIT3
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_4 BIT4
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_5 BIT5
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_6 BIT6
 set     PWMA_SM2CAPTCOMPX_EDGCMPX_7 BIT7

 set     PWMA_SM2CAPTCOMPX_EDGCNTX   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_0 BIT8
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_1 BIT9
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_2 BIT10
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_3 BIT11
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_4 BIT12
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_5 BIT13
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_6 BIT14
 set     PWMA_SM2CAPTCOMPX_EDGCNTX_7 BIT15

 set     PWMA_SM2CVAL0_CAPTVAL0      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM2CVAL0_CAPTVAL0_0    BIT0
 set     PWMA_SM2CVAL0_CAPTVAL0_1    BIT1
 set     PWMA_SM2CVAL0_CAPTVAL0_2    BIT2
 set     PWMA_SM2CVAL0_CAPTVAL0_3    BIT3
 set     PWMA_SM2CVAL0_CAPTVAL0_4    BIT4
 set     PWMA_SM2CVAL0_CAPTVAL0_5    BIT5
 set     PWMA_SM2CVAL0_CAPTVAL0_6    BIT6
 set     PWMA_SM2CVAL0_CAPTVAL0_7    BIT7
 set     PWMA_SM2CVAL0_CAPTVAL0_8    BIT8
 set     PWMA_SM2CVAL0_CAPTVAL0_9    BIT9
 set     PWMA_SM2CVAL0_CAPTVAL0_10   BIT10
 set     PWMA_SM2CVAL0_CAPTVAL0_11   BIT11
 set     PWMA_SM2CVAL0_CAPTVAL0_12   BIT12
 set     PWMA_SM2CVAL0_CAPTVAL0_13   BIT13
 set     PWMA_SM2CVAL0_CAPTVAL0_14   BIT14
 set     PWMA_SM2CVAL0_CAPTVAL0_15   BIT15

 set     PWMA_SM2CVAL0CYC_CVAL0CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM2CVAL0CYC_CVAL0CYC_0 BIT0
 set     PWMA_SM2CVAL0CYC_CVAL0CYC_1 BIT1
 set     PWMA_SM2CVAL0CYC_CVAL0CYC_2 BIT2
 set     PWMA_SM2CVAL0CYC_CVAL0CYC_3 BIT3

 set     PWMA_SM2CVAL1_CAPTVAL1      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM2CVAL1_CAPTVAL1_0    BIT0
 set     PWMA_SM2CVAL1_CAPTVAL1_1    BIT1
 set     PWMA_SM2CVAL1_CAPTVAL1_2    BIT2
 set     PWMA_SM2CVAL1_CAPTVAL1_3    BIT3
 set     PWMA_SM2CVAL1_CAPTVAL1_4    BIT4
 set     PWMA_SM2CVAL1_CAPTVAL1_5    BIT5
 set     PWMA_SM2CVAL1_CAPTVAL1_6    BIT6
 set     PWMA_SM2CVAL1_CAPTVAL1_7    BIT7
 set     PWMA_SM2CVAL1_CAPTVAL1_8    BIT8
 set     PWMA_SM2CVAL1_CAPTVAL1_9    BIT9
 set     PWMA_SM2CVAL1_CAPTVAL1_10   BIT10
 set     PWMA_SM2CVAL1_CAPTVAL1_11   BIT11
 set     PWMA_SM2CVAL1_CAPTVAL1_12   BIT12
 set     PWMA_SM2CVAL1_CAPTVAL1_13   BIT13
 set     PWMA_SM2CVAL1_CAPTVAL1_14   BIT14
 set     PWMA_SM2CVAL1_CAPTVAL1_15   BIT15

 set     PWMA_SM2CVAL1CYC_CVAL1CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM2CVAL1CYC_CVAL1CYC_0 BIT0
 set     PWMA_SM2CVAL1CYC_CVAL1CYC_1 BIT1
 set     PWMA_SM2CVAL1CYC_CVAL1CYC_2 BIT2
 set     PWMA_SM2CVAL1CYC_CVAL1CYC_3 BIT3

 set     PWMA_SM2CVAL2_CAPTVAL2      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM2CVAL2_CAPTVAL2_0    BIT0
 set     PWMA_SM2CVAL2_CAPTVAL2_1    BIT1
 set     PWMA_SM2CVAL2_CAPTVAL2_2    BIT2
 set     PWMA_SM2CVAL2_CAPTVAL2_3    BIT3
 set     PWMA_SM2CVAL2_CAPTVAL2_4    BIT4
 set     PWMA_SM2CVAL2_CAPTVAL2_5    BIT5
 set     PWMA_SM2CVAL2_CAPTVAL2_6    BIT6
 set     PWMA_SM2CVAL2_CAPTVAL2_7    BIT7
 set     PWMA_SM2CVAL2_CAPTVAL2_8    BIT8
 set     PWMA_SM2CVAL2_CAPTVAL2_9    BIT9
 set     PWMA_SM2CVAL2_CAPTVAL2_10   BIT10
 set     PWMA_SM2CVAL2_CAPTVAL2_11   BIT11
 set     PWMA_SM2CVAL2_CAPTVAL2_12   BIT12
 set     PWMA_SM2CVAL2_CAPTVAL2_13   BIT13
 set     PWMA_SM2CVAL2_CAPTVAL2_14   BIT14
 set     PWMA_SM2CVAL2_CAPTVAL2_15   BIT15

 set     PWMA_SM2CVAL2CYC_CVAL2CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM2CVAL2CYC_CVAL2CYC_0 BIT0
 set     PWMA_SM2CVAL2CYC_CVAL2CYC_1 BIT1
 set     PWMA_SM2CVAL2CYC_CVAL2CYC_2 BIT2
 set     PWMA_SM2CVAL2CYC_CVAL2CYC_3 BIT3

 set     PWMA_SM2CVAL3_CAPTVAL3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM2CVAL3_CAPTVAL3_0    BIT0
 set     PWMA_SM2CVAL3_CAPTVAL3_1    BIT1
 set     PWMA_SM2CVAL3_CAPTVAL3_2    BIT2
 set     PWMA_SM2CVAL3_CAPTVAL3_3    BIT3
 set     PWMA_SM2CVAL3_CAPTVAL3_4    BIT4
 set     PWMA_SM2CVAL3_CAPTVAL3_5    BIT5
 set     PWMA_SM2CVAL3_CAPTVAL3_6    BIT6
 set     PWMA_SM2CVAL3_CAPTVAL3_7    BIT7
 set     PWMA_SM2CVAL3_CAPTVAL3_8    BIT8
 set     PWMA_SM2CVAL3_CAPTVAL3_9    BIT9
 set     PWMA_SM2CVAL3_CAPTVAL3_10   BIT10
 set     PWMA_SM2CVAL3_CAPTVAL3_11   BIT11
 set     PWMA_SM2CVAL3_CAPTVAL3_12   BIT12
 set     PWMA_SM2CVAL3_CAPTVAL3_13   BIT13
 set     PWMA_SM2CVAL3_CAPTVAL3_14   BIT14
 set     PWMA_SM2CVAL3_CAPTVAL3_15   BIT15

 set     PWMA_SM2CVAL3CYC_CVAL3CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM2CVAL3CYC_CVAL3CYC_0 BIT0
 set     PWMA_SM2CVAL3CYC_CVAL3CYC_1 BIT1
 set     PWMA_SM2CVAL3CYC_CVAL3CYC_2 BIT2
 set     PWMA_SM2CVAL3CYC_CVAL3CYC_3 BIT3

 set     PWMA_SM2CVAL4_CAPTVAL4      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM2CVAL4_CAPTVAL4_0    BIT0
 set     PWMA_SM2CVAL4_CAPTVAL4_1    BIT1
 set     PWMA_SM2CVAL4_CAPTVAL4_2    BIT2
 set     PWMA_SM2CVAL4_CAPTVAL4_3    BIT3
 set     PWMA_SM2CVAL4_CAPTVAL4_4    BIT4
 set     PWMA_SM2CVAL4_CAPTVAL4_5    BIT5
 set     PWMA_SM2CVAL4_CAPTVAL4_6    BIT6
 set     PWMA_SM2CVAL4_CAPTVAL4_7    BIT7
 set     PWMA_SM2CVAL4_CAPTVAL4_8    BIT8
 set     PWMA_SM2CVAL4_CAPTVAL4_9    BIT9
 set     PWMA_SM2CVAL4_CAPTVAL4_10   BIT10
 set     PWMA_SM2CVAL4_CAPTVAL4_11   BIT11
 set     PWMA_SM2CVAL4_CAPTVAL4_12   BIT12
 set     PWMA_SM2CVAL4_CAPTVAL4_13   BIT13
 set     PWMA_SM2CVAL4_CAPTVAL4_14   BIT14
 set     PWMA_SM2CVAL4_CAPTVAL4_15   BIT15

 set     PWMA_SM2CVAL4CYC_CVAL4CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM2CVAL4CYC_CVAL4CYC_0 BIT0
 set     PWMA_SM2CVAL4CYC_CVAL4CYC_1 BIT1
 set     PWMA_SM2CVAL4CYC_CVAL4CYC_2 BIT2
 set     PWMA_SM2CVAL4CYC_CVAL4CYC_3 BIT3

 set     PWMA_SM2CVAL5_CAPTVAL5      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM2CVAL5_CAPTVAL5_0    BIT0
 set     PWMA_SM2CVAL5_CAPTVAL5_1    BIT1
 set     PWMA_SM2CVAL5_CAPTVAL5_2    BIT2
 set     PWMA_SM2CVAL5_CAPTVAL5_3    BIT3
 set     PWMA_SM2CVAL5_CAPTVAL5_4    BIT4
 set     PWMA_SM2CVAL5_CAPTVAL5_5    BIT5
 set     PWMA_SM2CVAL5_CAPTVAL5_6    BIT6
 set     PWMA_SM2CVAL5_CAPTVAL5_7    BIT7
 set     PWMA_SM2CVAL5_CAPTVAL5_8    BIT8
 set     PWMA_SM2CVAL5_CAPTVAL5_9    BIT9
 set     PWMA_SM2CVAL5_CAPTVAL5_10   BIT10
 set     PWMA_SM2CVAL5_CAPTVAL5_11   BIT11
 set     PWMA_SM2CVAL5_CAPTVAL5_12   BIT12
 set     PWMA_SM2CVAL5_CAPTVAL5_13   BIT13
 set     PWMA_SM2CVAL5_CAPTVAL5_14   BIT14
 set     PWMA_SM2CVAL5_CAPTVAL5_15   BIT15

 set     PWMA_SM2CVAL5CYC_CVAL5CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM2CVAL5CYC_CVAL5CYC_0 BIT0
 set     PWMA_SM2CVAL5CYC_CVAL5CYC_1 BIT1
 set     PWMA_SM2CVAL5CYC_CVAL5CYC_2 BIT2
 set     PWMA_SM2CVAL5CYC_CVAL5CYC_3 BIT3

 set     PWMA_SM3CNT_CNT             (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Counter Register Bits
 set     PWMA_SM3CNT_CNT_0           BIT0
 set     PWMA_SM3CNT_CNT_1           BIT1
 set     PWMA_SM3CNT_CNT_2           BIT2
 set     PWMA_SM3CNT_CNT_3           BIT3
 set     PWMA_SM3CNT_CNT_4           BIT4
 set     PWMA_SM3CNT_CNT_5           BIT5
 set     PWMA_SM3CNT_CNT_6           BIT6
 set     PWMA_SM3CNT_CNT_7           BIT7
 set     PWMA_SM3CNT_CNT_8           BIT8
 set     PWMA_SM3CNT_CNT_9           BIT9
 set     PWMA_SM3CNT_CNT_10          BIT10
 set     PWMA_SM3CNT_CNT_11          BIT11
 set     PWMA_SM3CNT_CNT_12          BIT12
 set     PWMA_SM3CNT_CNT_13          BIT13
 set     PWMA_SM3CNT_CNT_14          BIT14
 set     PWMA_SM3CNT_CNT_15          BIT15

 set     PWMA_SM3INIT_INIT           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Initial Count Register Bits
 set     PWMA_SM3INIT_INIT_0         BIT0
 set     PWMA_SM3INIT_INIT_1         BIT1
 set     PWMA_SM3INIT_INIT_2         BIT2
 set     PWMA_SM3INIT_INIT_3         BIT3
 set     PWMA_SM3INIT_INIT_4         BIT4
 set     PWMA_SM3INIT_INIT_5         BIT5
 set     PWMA_SM3INIT_INIT_6         BIT6
 set     PWMA_SM3INIT_INIT_7         BIT7
 set     PWMA_SM3INIT_INIT_8         BIT8
 set     PWMA_SM3INIT_INIT_9         BIT9
 set     PWMA_SM3INIT_INIT_10        BIT10
 set     PWMA_SM3INIT_INIT_11        BIT11
 set     PWMA_SM3INIT_INIT_12        BIT12
 set     PWMA_SM3INIT_INIT_13        BIT13
 set     PWMA_SM3INIT_INIT_14        BIT14
 set     PWMA_SM3INIT_INIT_15        BIT15

 set     PWMA_SM3CTRL2_CLK_SEL       (BIT0|BIT1)
;;   Clock Source Select
;;     0b00 ==> The IPBus clock is used as the clock for the local prescaler and counter.
;;     0b01 ==> EXT_CLK is used as the clock for the local prescaler and counter.
;;     0b10 ==> Submodule 0's clock (AUX_CLK) is used as the source clock for the local prescaler and counter. This setting should not be used in submodule 0 as it will force the clock to logic 0.
;;     0b11 ==> reserved
 set     PWMA_SM3CTRL2_CLK_SEL_0     BIT0
 set     PWMA_SM3CTRL2_CLK_SEL_1     BIT1

 set     PWMA_SM3CTRL2_RELOAD_SEL    BIT2
;;   Reload Source Select
;;     0b0 ==> The local RELOAD signal is used to reload registers.
;;     0b1 ==> The master RELOAD signal (from submodule 0) is used to reload registers. This setting should not be used in submodule 0 as it will force the RELOAD signal to logic 0.

 set     PWMA_SM3CTRL2_FORCE_SEL     (BIT3|BIT4|BIT5)
;;   This read/write bit determines the source of the FORCE OUTPUT signal for this submodule.
;;     0b000 ==> The local force signal, CTRL2[FORCE], from this submodule is used to force updates.
;;     0b001 ==> The master force signal from submodule 0 is used to force updates. This setting should not be used in submodule 0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b010 ==> The local reload signal from this submodule is used to force updates without regard to the state of LDOK.
;;     0b011 ==> The master reload signal from submodule0 is used to force updates if LDOK is set. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b100 ==> The local sync signal from this submodule is used to force updates.
;;     0b101 ==> The master sync signal from submodule0 is used to force updates. This setting should not be used in submodule0 as it will hold the FORCE OUTPUT signal to logic 0.
;;     0b110 ==> The external force signal, EXT_FORCE, from outside the PWM module causes updates.
;;     0b111 ==> The external sync signal, EXT_SYNC, from outside the PWM module causes updates.
 set     PWMA_SM3CTRL2_FORCE_SEL_0   BIT3
 set     PWMA_SM3CTRL2_FORCE_SEL_1   BIT4
 set     PWMA_SM3CTRL2_FORCE_SEL_2   BIT5

 set     PWMA_SM3CTRL2_FORCE         BIT6
;;   Force Initialization

 set     PWMA_SM3CTRL2_FRCEN         BIT7
;;   Force Initialization Enable
;;     0b0 ==> Initialization from a FORCE_OUT event is disabled.
;;     0b1 ==> Initialization from a FORCE_OUT event is enabled.

 set     PWMA_SM3CTRL2_INIT_SEL      (BIT8|BIT9)
;;   Initialization Control Select
;;     0b00 ==> Local sync (PWM_X) causes initialization.
;;     0b01 ==> Master reload from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0. The submodule counter will only reinitialize when a master reload occurs.
;;     0b10 ==> Master sync from submodule 0 causes initialization. This setting should not be used in submodule 0 as it will force the INIT signal to logic 0.
;;     0b11 ==> EXT_SYNC causes initialization.
 set     PWMA_SM3CTRL2_INIT_SEL_0    BIT8
 set     PWMA_SM3CTRL2_INIT_SEL_1    BIT9

 set     PWMA_SM3CTRL2_PWMX_INIT     BIT10
;;   PWM_X Initial Value

 set     PWMA_SM3CTRL2_PWM45_INIT    BIT11
;;   PWM45 Initial Value

 set     PWMA_SM3CTRL2_PWM23_INIT    BIT12
;;   PWM23 Initial Value

 set     PWMA_SM3CTRL2_INDEP         BIT13
;;   Independent or Complementary Pair Operation
;;     0b0 ==> PWM_A and PWM_B form a complementary PWM pair.
;;     0b1 ==> PWM_A and PWM_B outputs are independent PWMs.

 set     PWMA_SM3CTRL2_WAITEN        BIT14
;;   WAIT Enable

 set     PWMA_SM3CTRL2_DBGEN         BIT15
;;   Debug Enable

 set     PWMA_SM3CTRL_DBLEN          BIT0
;;   Double Switching Enable
;;     0b0 ==> Double switching disabled.
;;     0b1 ==> Double switching enabled.

 set     PWMA_SM3CTRL_DBLX           BIT1
;;   PWMX Double Switching Enable
;;     0b0 ==> PWMX double pulse disabled.
;;     0b1 ==> PWMX double pulse enabled.

 set     PWMA_SM3CTRL_LDMOD          BIT2
;;   Load Mode Select
;;     0b0 ==> Buffered registers of this submodule are loaded and take effect at the next PWM reload if MCTRL[LDOK] is set.
;;     0b1 ==> Buffered registers of this submodule are loaded and take effect immediately upon MCTRL[LDOK] being set. In this case it is not necessary to set CTRL[FULL] or CTRL[HALF].

 set     PWMA_SM3CTRL_PRSC           (BIT4|BIT5|BIT6)
;;   Prescaler
;;     0b000 ==> PWM clock frequency = fclk
;;     0b001 ==> PWM clock frequency = fclk/2
;;     0b010 ==> PWM clock frequency = fclk/4
;;     0b011 ==> PWM clock frequency = fclk/8
;;     0b100 ==> PWM clock frequency = fclk/16
;;     0b101 ==> PWM clock frequency = fclk/32
;;     0b110 ==> PWM clock frequency = fclk/64
;;     0b111 ==> PWM clock frequency = fclk/128
 set     PWMA_SM3CTRL_PRSC_0         BIT4
 set     PWMA_SM3CTRL_PRSC_1         BIT5
 set     PWMA_SM3CTRL_PRSC_2         BIT6

 set     PWMA_SM3CTRL_DT             (BIT8|BIT9)
;;   Deadtime
 set     PWMA_SM3CTRL_DT_0           BIT8
 set     PWMA_SM3CTRL_DT_1           BIT9

 set     PWMA_SM3CTRL_FULL           BIT10
;;   Full Cycle Reload
;;     0b0 ==> Full-cycle reloads disabled.
;;     0b1 ==> Full-cycle reloads enabled.

 set     PWMA_SM3CTRL_HALF           BIT11
;;   Half Cycle Reload
;;     0b0 ==> Half-cycle reloads disabled.
;;     0b1 ==> Half-cycle reloads enabled.

 set     PWMA_SM3CTRL_LDFQ           (BIT12|BIT13|BIT14|BIT15)
;;     0b0000 ==> Every PWM opportunity
;;     0b0001 ==> Every 2 PWM opportunities
;;     0b0010 ==> Every 3 PWM opportunities
;;     0b0011 ==> Every 4 PWM opportunities
;;     0b0100 ==> Every 5 PWM opportunities
;;     0b0101 ==> Every 6 PWM opportunities
;;     0b0110 ==> Every 7 PWM opportunities
;;     0b0111 ==> Every 8 PWM opportunities
;;     0b1000 ==> Every 9 PWM opportunities
;;     0b1001 ==> Every 10 PWM opportunities
;;     0b1010 ==> Every 11 PWM opportunities
;;     0b1011 ==> Every 12 PWM opportunities
;;     0b1100 ==> Every 13 PWM opportunities
;;     0b1101 ==> Every 14 PWM opportunities
;;     0b1110 ==> Every 15 PWM opportunities
;;     0b1111 ==> Every 16 PWM opportunities
 set     PWMA_SM3CTRL_LDFQ_0         BIT12
 set     PWMA_SM3CTRL_LDFQ_1         BIT13
 set     PWMA_SM3CTRL_LDFQ_2         BIT14
 set     PWMA_SM3CTRL_LDFQ_3         BIT15

 set     PWMA_SM3VAL0_VAL0           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 0
 set     PWMA_SM3VAL0_VAL0_0         BIT0
 set     PWMA_SM3VAL0_VAL0_1         BIT1
 set     PWMA_SM3VAL0_VAL0_2         BIT2
 set     PWMA_SM3VAL0_VAL0_3         BIT3
 set     PWMA_SM3VAL0_VAL0_4         BIT4
 set     PWMA_SM3VAL0_VAL0_5         BIT5
 set     PWMA_SM3VAL0_VAL0_6         BIT6
 set     PWMA_SM3VAL0_VAL0_7         BIT7
 set     PWMA_SM3VAL0_VAL0_8         BIT8
 set     PWMA_SM3VAL0_VAL0_9         BIT9
 set     PWMA_SM3VAL0_VAL0_10        BIT10
 set     PWMA_SM3VAL0_VAL0_11        BIT11
 set     PWMA_SM3VAL0_VAL0_12        BIT12
 set     PWMA_SM3VAL0_VAL0_13        BIT13
 set     PWMA_SM3VAL0_VAL0_14        BIT14
 set     PWMA_SM3VAL0_VAL0_15        BIT15

 set     PWMA_SM3FRACVAL1_FRACVAL1   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 1 Register
 set     PWMA_SM3FRACVAL1_FRACVAL1_0 BIT11
 set     PWMA_SM3FRACVAL1_FRACVAL1_1 BIT12
 set     PWMA_SM3FRACVAL1_FRACVAL1_2 BIT13
 set     PWMA_SM3FRACVAL1_FRACVAL1_3 BIT14
 set     PWMA_SM3FRACVAL1_FRACVAL1_4 BIT15

 set     PWMA_SM3VAL1_VAL1           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 1
 set     PWMA_SM3VAL1_VAL1_0         BIT0
 set     PWMA_SM3VAL1_VAL1_1         BIT1
 set     PWMA_SM3VAL1_VAL1_2         BIT2
 set     PWMA_SM3VAL1_VAL1_3         BIT3
 set     PWMA_SM3VAL1_VAL1_4         BIT4
 set     PWMA_SM3VAL1_VAL1_5         BIT5
 set     PWMA_SM3VAL1_VAL1_6         BIT6
 set     PWMA_SM3VAL1_VAL1_7         BIT7
 set     PWMA_SM3VAL1_VAL1_8         BIT8
 set     PWMA_SM3VAL1_VAL1_9         BIT9
 set     PWMA_SM3VAL1_VAL1_10        BIT10
 set     PWMA_SM3VAL1_VAL1_11        BIT11
 set     PWMA_SM3VAL1_VAL1_12        BIT12
 set     PWMA_SM3VAL1_VAL1_13        BIT13
 set     PWMA_SM3VAL1_VAL1_14        BIT14
 set     PWMA_SM3VAL1_VAL1_15        BIT15

 set     PWMA_SM3FRACVAL2_FRACVAL2   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 2
 set     PWMA_SM3FRACVAL2_FRACVAL2_0 BIT11
 set     PWMA_SM3FRACVAL2_FRACVAL2_1 BIT12
 set     PWMA_SM3FRACVAL2_FRACVAL2_2 BIT13
 set     PWMA_SM3FRACVAL2_FRACVAL2_3 BIT14
 set     PWMA_SM3FRACVAL2_FRACVAL2_4 BIT15

 set     PWMA_SM3VAL2_VAL2           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 2
 set     PWMA_SM3VAL2_VAL2_0         BIT0
 set     PWMA_SM3VAL2_VAL2_1         BIT1
 set     PWMA_SM3VAL2_VAL2_2         BIT2
 set     PWMA_SM3VAL2_VAL2_3         BIT3
 set     PWMA_SM3VAL2_VAL2_4         BIT4
 set     PWMA_SM3VAL2_VAL2_5         BIT5
 set     PWMA_SM3VAL2_VAL2_6         BIT6
 set     PWMA_SM3VAL2_VAL2_7         BIT7
 set     PWMA_SM3VAL2_VAL2_8         BIT8
 set     PWMA_SM3VAL2_VAL2_9         BIT9
 set     PWMA_SM3VAL2_VAL2_10        BIT10
 set     PWMA_SM3VAL2_VAL2_11        BIT11
 set     PWMA_SM3VAL2_VAL2_12        BIT12
 set     PWMA_SM3VAL2_VAL2_13        BIT13
 set     PWMA_SM3VAL2_VAL2_14        BIT14
 set     PWMA_SM3VAL2_VAL2_15        BIT15

 set     PWMA_SM3FRACVAL3_FRACVAL3   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 3
 set     PWMA_SM3FRACVAL3_FRACVAL3_0 BIT11
 set     PWMA_SM3FRACVAL3_FRACVAL3_1 BIT12
 set     PWMA_SM3FRACVAL3_FRACVAL3_2 BIT13
 set     PWMA_SM3FRACVAL3_FRACVAL3_3 BIT14
 set     PWMA_SM3FRACVAL3_FRACVAL3_4 BIT15

 set     PWMA_SM3VAL3_VAL3           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 3
 set     PWMA_SM3VAL3_VAL3_0         BIT0
 set     PWMA_SM3VAL3_VAL3_1         BIT1
 set     PWMA_SM3VAL3_VAL3_2         BIT2
 set     PWMA_SM3VAL3_VAL3_3         BIT3
 set     PWMA_SM3VAL3_VAL3_4         BIT4
 set     PWMA_SM3VAL3_VAL3_5         BIT5
 set     PWMA_SM3VAL3_VAL3_6         BIT6
 set     PWMA_SM3VAL3_VAL3_7         BIT7
 set     PWMA_SM3VAL3_VAL3_8         BIT8
 set     PWMA_SM3VAL3_VAL3_9         BIT9
 set     PWMA_SM3VAL3_VAL3_10        BIT10
 set     PWMA_SM3VAL3_VAL3_11        BIT11
 set     PWMA_SM3VAL3_VAL3_12        BIT12
 set     PWMA_SM3VAL3_VAL3_13        BIT13
 set     PWMA_SM3VAL3_VAL3_14        BIT14
 set     PWMA_SM3VAL3_VAL3_15        BIT15

 set     PWMA_SM3FRACVAL4_FRACVAL4   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 4
 set     PWMA_SM3FRACVAL4_FRACVAL4_0 BIT11
 set     PWMA_SM3FRACVAL4_FRACVAL4_1 BIT12
 set     PWMA_SM3FRACVAL4_FRACVAL4_2 BIT13
 set     PWMA_SM3FRACVAL4_FRACVAL4_3 BIT14
 set     PWMA_SM3FRACVAL4_FRACVAL4_4 BIT15

 set     PWMA_SM3VAL4_VAL4           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 4
 set     PWMA_SM3VAL4_VAL4_0         BIT0
 set     PWMA_SM3VAL4_VAL4_1         BIT1
 set     PWMA_SM3VAL4_VAL4_2         BIT2
 set     PWMA_SM3VAL4_VAL4_3         BIT3
 set     PWMA_SM3VAL4_VAL4_4         BIT4
 set     PWMA_SM3VAL4_VAL4_5         BIT5
 set     PWMA_SM3VAL4_VAL4_6         BIT6
 set     PWMA_SM3VAL4_VAL4_7         BIT7
 set     PWMA_SM3VAL4_VAL4_8         BIT8
 set     PWMA_SM3VAL4_VAL4_9         BIT9
 set     PWMA_SM3VAL4_VAL4_10        BIT10
 set     PWMA_SM3VAL4_VAL4_11        BIT11
 set     PWMA_SM3VAL4_VAL4_12        BIT12
 set     PWMA_SM3VAL4_VAL4_13        BIT13
 set     PWMA_SM3VAL4_VAL4_14        BIT14
 set     PWMA_SM3VAL4_VAL4_15        BIT15

 set     PWMA_SM3FRACVAL5_FRACVAL5   (BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Fractional Value 5
 set     PWMA_SM3FRACVAL5_FRACVAL5_0 BIT11
 set     PWMA_SM3FRACVAL5_FRACVAL5_1 BIT12
 set     PWMA_SM3FRACVAL5_FRACVAL5_2 BIT13
 set     PWMA_SM3FRACVAL5_FRACVAL5_3 BIT14
 set     PWMA_SM3FRACVAL5_FRACVAL5_4 BIT15

 set     PWMA_SM3VAL5_VAL5           (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Value Register 5
 set     PWMA_SM3VAL5_VAL5_0         BIT0
 set     PWMA_SM3VAL5_VAL5_1         BIT1
 set     PWMA_SM3VAL5_VAL5_2         BIT2
 set     PWMA_SM3VAL5_VAL5_3         BIT3
 set     PWMA_SM3VAL5_VAL5_4         BIT4
 set     PWMA_SM3VAL5_VAL5_5         BIT5
 set     PWMA_SM3VAL5_VAL5_6         BIT6
 set     PWMA_SM3VAL5_VAL5_7         BIT7
 set     PWMA_SM3VAL5_VAL5_8         BIT8
 set     PWMA_SM3VAL5_VAL5_9         BIT9
 set     PWMA_SM3VAL5_VAL5_10        BIT10
 set     PWMA_SM3VAL5_VAL5_11        BIT11
 set     PWMA_SM3VAL5_VAL5_12        BIT12
 set     PWMA_SM3VAL5_VAL5_13        BIT13
 set     PWMA_SM3VAL5_VAL5_14        BIT14
 set     PWMA_SM3VAL5_VAL5_15        BIT15

 set     PWMA_SM3FRCTRL_FRAC1_EN     BIT1
;;   Fractional Cycle PWM Period Enable
;;     0b0 ==> Disable fractional cycle length for the PWM period.
;;     0b1 ==> Enable fractional cycle length for the PWM period.

 set     PWMA_SM3FRCTRL_FRAC23_EN    BIT2
;;   Fractional Cycle Placement Enable for PWM_A
;;     0b0 ==> Disable fractional cycle placement for PWM_A.
;;     0b1 ==> Enable fractional cycle placement for PWM_A.

 set     PWMA_SM3FRCTRL_FRAC45_EN    BIT4
;;   Fractional Cycle Placement Enable for PWM_B
;;     0b0 ==> Disable fractional cycle placement for PWM_B.
;;     0b1 ==> Enable fractional cycle placement for PWM_B.

 set     PWMA_SM3FRCTRL_FRAC_PU      BIT8
;;   Fractional Delay Circuit Power Up
;;     0b0 ==> Turn off fractional delay logic.
;;     0b1 ==> Power up fractional delay logic.

 set     PWMA_SM3FRCTRL_TEST         BIT15
;;   Test Status Bit

 set     PWMA_SM3OCTRL_PWMXFS        (BIT0|BIT1)
;;   PWM_X Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM3OCTRL_PWMXFS_0      BIT0
 set     PWMA_SM3OCTRL_PWMXFS_1      BIT1

 set     PWMA_SM3OCTRL_PWMBFS        (BIT2|BIT3)
;;   PWM_B Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM3OCTRL_PWMBFS_0      BIT2
 set     PWMA_SM3OCTRL_PWMBFS_1      BIT3

 set     PWMA_SM3OCTRL_PWMAFS        (BIT4|BIT5)
;;   PWM_A Fault State
;;     0b00 ==> Output is forced to logic 0 state prior to consideration of output polarity control.
;;     0b01 ==> Output is forced to logic 1 state prior to consideration of output polarity control.
;;     0b10 ==> Output is tristated.
;;     0b11 ==> Output is tristated.
 set     PWMA_SM3OCTRL_PWMAFS_0      BIT4
 set     PWMA_SM3OCTRL_PWMAFS_1      BIT5

 set     PWMA_SM3OCTRL_POLX          BIT8
;;   PWM_X Output Polarity
;;     0b0 ==> PWM_X output not inverted. A high level on the PWM_X pin represents the "on" or "active" state.
;;     0b1 ==> PWM_X output inverted. A low level on the PWM_X pin represents the "on" or "active" state.

 set     PWMA_SM3OCTRL_POLB          BIT9
;;   PWM_B Output Polarity
;;     0b0 ==> PWM_B output not inverted. A high level on the PWM_B pin represents the "on" or "active" state.
;;     0b1 ==> PWM_B output inverted. A low level on the PWM_B pin represents the "on" or "active" state.

 set     PWMA_SM3OCTRL_POLA          BIT10
;;   PWM_A Output Polarity
;;     0b0 ==> PWM_A output not inverted. A high level on the PWM_A pin represents the "on" or "active" state.
;;     0b1 ==> PWM_A output inverted. A low level on the PWM_A pin represents the "on" or "active" state.

 set     PWMA_SM3OCTRL_PWMX_IN       BIT13
;;   PWM_X Input

 set     PWMA_SM3OCTRL_PWMB_IN       BIT14
;;   PWM_B Input

 set     PWMA_SM3OCTRL_PWMA_IN       BIT15
;;   PWM_A Input

 set     PWMA_SM3STS_CMPF            (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Flags
;;     0b0 ==> No compare event has occurred for a particular VALx value.
;;     0b1 ==> A compare event has occurred for a particular VALx value.
 set     PWMA_SM3STS_CMPF_0          BIT0
 set     PWMA_SM3STS_CMPF_1          BIT1
 set     PWMA_SM3STS_CMPF_2          BIT2
 set     PWMA_SM3STS_CMPF_3          BIT3
 set     PWMA_SM3STS_CMPF_4          BIT4
 set     PWMA_SM3STS_CMPF_5          BIT5

 set     PWMA_SM3STS_CFX0            BIT6
;;   Capture Flag X0

 set     PWMA_SM3STS_CFX1            BIT7
;;   Capture Flag X1

 set     PWMA_SM3STS_CFB0            BIT8
;;   Capture Flag B0

 set     PWMA_SM3STS_CFB1            BIT9
;;   Capture Flag B1

 set     PWMA_SM3STS_CFA0            BIT10
;;   Capture Flag A0

 set     PWMA_SM3STS_CFA1            BIT11
;;   Capture Flag A1

 set     PWMA_SM3STS_RF              BIT12
;;   Reload Flag
;;     0b0 ==> No new reload cycle since last STS[RF] clearing
;;     0b1 ==> New reload cycle since last STS[RF] clearing

 set     PWMA_SM3STS_REF             BIT13
;;   Reload Error Flag
;;     0b0 ==> No reload error occurred.
;;     0b1 ==> Reload signal occurred with non-coherent data and MCTRL[LDOK] = 0.

 set     PWMA_SM3STS_RUF             BIT14
;;   Registers Updated Flag
;;     0b0 ==> No register update has occurred since last reload.
;;     0b1 ==> At least one of the double buffered registers has been updated since the last reload.

 set     PWMA_SM3INTEN_CMPIE         (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Compare Interrupt Enables
;;     0b0 ==> The corresponding STS[CMPF] bit will not cause an interrupt request.
;;     0b1 ==> The corresponding STS[CMPF] bit will cause an interrupt request.
 set     PWMA_SM3INTEN_CMPIE_0       BIT0
 set     PWMA_SM3INTEN_CMPIE_1       BIT1
 set     PWMA_SM3INTEN_CMPIE_2       BIT2
 set     PWMA_SM3INTEN_CMPIE_3       BIT3
 set     PWMA_SM3INTEN_CMPIE_4       BIT4
 set     PWMA_SM3INTEN_CMPIE_5       BIT5

 set     PWMA_SM3INTEN_CX0IE         BIT6
;;   Capture X 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX0].
;;     0b1 ==> Interrupt request enabled for STS[CFX0].

 set     PWMA_SM3INTEN_CX1IE         BIT7
;;   Capture X 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFX1].
;;     0b1 ==> Interrupt request enabled for STS[CFX1].

 set     PWMA_SM3INTEN_CB0IE         BIT8
;;   Capture B 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB0].
;;     0b1 ==> Interrupt request enabled for STS[CFB0].

 set     PWMA_SM3INTEN_CB1IE         BIT9
;;   Capture B 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFB1].
;;     0b1 ==> Interrupt request enabled for STS[CFB1].

 set     PWMA_SM3INTEN_CA0IE         BIT10
;;   Capture A 0 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA0].
;;     0b1 ==> Interrupt request enabled for STS[CFA0].

 set     PWMA_SM3INTEN_CA1IE         BIT11
;;   Capture A 1 Interrupt Enable
;;     0b0 ==> Interrupt request disabled for STS[CFA1].
;;     0b1 ==> Interrupt request enabled for STS[CFA1].

 set     PWMA_SM3INTEN_RIE           BIT12
;;   Reload Interrupt Enable
;;     0b0 ==> STS[RF] CPU interrupt requests disabled
;;     0b1 ==> STS[RF] CPU interrupt requests enabled

 set     PWMA_SM3INTEN_REIE          BIT13
;;   Reload Error Interrupt Enable
;;     0b0 ==> STS[REF] CPU interrupt requests disabled
;;     0b1 ==> STS[REF] CPU interrupt requests enabled

 set     PWMA_SM3DMAEN_CX0DE         BIT0
;;   Capture X0 FIFO DMA Enable

 set     PWMA_SM3DMAEN_CX1DE         BIT1
;;   Capture X1 FIFO DMA Enable

 set     PWMA_SM3DMAEN_CB0DE         BIT2
;;   Capture B0 FIFO DMA Enable

 set     PWMA_SM3DMAEN_CB1DE         BIT3
;;   Capture B1 FIFO DMA Enable

 set     PWMA_SM3DMAEN_CA0DE         BIT4
;;   Capture A0 FIFO DMA Enable

 set     PWMA_SM3DMAEN_CA1DE         BIT5
;;   Capture A1 FIFO DMA Enable

 set     PWMA_SM3DMAEN_CAPTDE        (BIT6|BIT7)
;;   Capture DMA Enable Source Select
;;     0b00 ==> Read DMA requests disabled.
;;     0b01 ==> Exceeding a FIFO watermark sets the DMA read request. This requires at least one of DMAEN[CA1DE], DMAEN[CA0DE], DMAEN[CB1DE], DMAEN[CB0DE], DMAEN[CX1DE], or DMAEN[CX0DE] to also be set in order to determine to which watermark(s) the DMA request is sensitive.
;;     0b10 ==> A local sync (VAL1 matches counter) sets the read DMA request.
;;     0b11 ==> A local reload (STS[RF] being set) sets the read DMA request.
 set     PWMA_SM3DMAEN_CAPTDE_0      BIT6
 set     PWMA_SM3DMAEN_CAPTDE_1      BIT7

 set     PWMA_SM3DMAEN_FAND          BIT8
;;   FIFO Watermark AND Control
;;     0b0 ==> Selected FIFO watermarks are OR'ed together.
;;     0b1 ==> Selected FIFO watermarks are AND'ed together.

 set     PWMA_SM3DMAEN_VALDE         BIT9
;;   Value Registers DMA Enable
;;     0b0 ==> DMA write requests disabled
;;     0b1 ==> DMA write requests for the VALx and FRACVALx registers enabled

 set     PWMA_SM3TCTRL_OUT_TRIG_EN   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5)
;;   Output Trigger Enables
;;     0b0 ==> PWM_OUT_TRIGx will not set when the counter value matches the VALx value.
;;     0b1 ==> PWM_OUT_TRIGx will set when the counter value matches the VALx value.
 set     PWMA_SM3TCTRL_OUT_TRIG_EN_0 BIT0
 set     PWMA_SM3TCTRL_OUT_TRIG_EN_1 BIT1
 set     PWMA_SM3TCTRL_OUT_TRIG_EN_2 BIT2
 set     PWMA_SM3TCTRL_OUT_TRIG_EN_3 BIT3
 set     PWMA_SM3TCTRL_OUT_TRIG_EN_4 BIT4
 set     PWMA_SM3TCTRL_OUT_TRIG_EN_5 BIT5

 set     PWMA_SM3TCTRL_PWBOT1        BIT14
;;   Output Trigger 1 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG1 signal to PWM_OUT_TRIG1 port.
;;     0b1 ==> Route the PWMB output to the PWM_OUT_TRIG1 port.

 set     PWMA_SM3TCTRL_PWAOT0        BIT15
;;   Output Trigger 0 Source Select
;;     0b0 ==> Route the PWM_OUT_TRIG0 signal to PWM_OUT_TRIG0 port.
;;     0b1 ==> Route the PWMA output to the PWM_OUT_TRIG0 port.

 set     PWMA_SM3DISMAP0_DIS0A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 0
 set     PWMA_SM3DISMAP0_DIS0A_0     BIT0
 set     PWMA_SM3DISMAP0_DIS0A_1     BIT1
 set     PWMA_SM3DISMAP0_DIS0A_2     BIT2
 set     PWMA_SM3DISMAP0_DIS0A_3     BIT3

 set     PWMA_SM3DISMAP0_DIS0B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 0
 set     PWMA_SM3DISMAP0_DIS0B_0     BIT4
 set     PWMA_SM3DISMAP0_DIS0B_1     BIT5
 set     PWMA_SM3DISMAP0_DIS0B_2     BIT6
 set     PWMA_SM3DISMAP0_DIS0B_3     BIT7

 set     PWMA_SM3DISMAP0_DIS0X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 0
 set     PWMA_SM3DISMAP0_DIS0X_0     BIT8
 set     PWMA_SM3DISMAP0_DIS0X_1     BIT9
 set     PWMA_SM3DISMAP0_DIS0X_2     BIT10
 set     PWMA_SM3DISMAP0_DIS0X_3     BIT11

 set     PWMA_SM3DISMAP1_DIS1A       (BIT0|BIT1|BIT2|BIT3)
;;   PWM_A Fault Disable Mask 1
 set     PWMA_SM3DISMAP1_DIS1A_0     BIT0
 set     PWMA_SM3DISMAP1_DIS1A_1     BIT1
 set     PWMA_SM3DISMAP1_DIS1A_2     BIT2
 set     PWMA_SM3DISMAP1_DIS1A_3     BIT3

 set     PWMA_SM3DISMAP1_DIS1B       (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Fault Disable Mask 1
 set     PWMA_SM3DISMAP1_DIS1B_0     BIT4
 set     PWMA_SM3DISMAP1_DIS1B_1     BIT5
 set     PWMA_SM3DISMAP1_DIS1B_2     BIT6
 set     PWMA_SM3DISMAP1_DIS1B_3     BIT7

 set     PWMA_SM3DISMAP1_DIS1X       (BIT8|BIT9|BIT10|BIT11)
;;   PWM_X Fault Disable Mask 1
 set     PWMA_SM3DISMAP1_DIS1X_0     BIT8
 set     PWMA_SM3DISMAP1_DIS1X_1     BIT9
 set     PWMA_SM3DISMAP1_DIS1X_2     BIT10
 set     PWMA_SM3DISMAP1_DIS1X_3     BIT11

 set     PWMA_SM3DTCNT0_DTCNT0       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 0
 set     PWMA_SM3DTCNT0_DTCNT0_0     BIT0
 set     PWMA_SM3DTCNT0_DTCNT0_1     BIT1
 set     PWMA_SM3DTCNT0_DTCNT0_2     BIT2
 set     PWMA_SM3DTCNT0_DTCNT0_3     BIT3
 set     PWMA_SM3DTCNT0_DTCNT0_4     BIT4
 set     PWMA_SM3DTCNT0_DTCNT0_5     BIT5
 set     PWMA_SM3DTCNT0_DTCNT0_6     BIT6
 set     PWMA_SM3DTCNT0_DTCNT0_7     BIT7
 set     PWMA_SM3DTCNT0_DTCNT0_8     BIT8
 set     PWMA_SM3DTCNT0_DTCNT0_9     BIT9
 set     PWMA_SM3DTCNT0_DTCNT0_10    BIT10

 set     PWMA_SM3DTCNT1_DTCNT1       (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10)
;;   Deadtime Count Register 1
 set     PWMA_SM3DTCNT1_DTCNT1_0     BIT0
 set     PWMA_SM3DTCNT1_DTCNT1_1     BIT1
 set     PWMA_SM3DTCNT1_DTCNT1_2     BIT2
 set     PWMA_SM3DTCNT1_DTCNT1_3     BIT3
 set     PWMA_SM3DTCNT1_DTCNT1_4     BIT4
 set     PWMA_SM3DTCNT1_DTCNT1_5     BIT5
 set     PWMA_SM3DTCNT1_DTCNT1_6     BIT6
 set     PWMA_SM3DTCNT1_DTCNT1_7     BIT7
 set     PWMA_SM3DTCNT1_DTCNT1_8     BIT8
 set     PWMA_SM3DTCNT1_DTCNT1_9     BIT9
 set     PWMA_SM3DTCNT1_DTCNT1_10    BIT10

 set     PWMA_SM3CAPTCTRLA_ARMA      BIT0
;;   Arm A
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLA[EDGAx] is enabled.

 set     PWMA_SM3CAPTCTRLA_ONESHOTA  BIT1
;;   One Shot Mode A
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLA[ARMA] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLA[ARMA] is cleared. No further captures will be performed until CAPTCTRLA[ARMA] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLA[ARMA] is then cleared.

 set     PWMA_SM3CAPTCTRLA_EDGA0     (BIT2|BIT3)
;;   Edge A 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM3CAPTCTRLA_EDGA0_0   BIT2
 set     PWMA_SM3CAPTCTRLA_EDGA0_1   BIT3

 set     PWMA_SM3CAPTCTRLA_EDGA1     (BIT4|BIT5)
;;   Edge A 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM3CAPTCTRLA_EDGA1_0   BIT4
 set     PWMA_SM3CAPTCTRLA_EDGA1_1   BIT5

 set     PWMA_SM3CAPTCTRLA_INP_SELA  BIT6
;;   Input Select A
;;     0b0 ==> Raw PWM_A input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLA[EDGA0] and CAPTCTRLA[EDGA1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRA[EDGA0] and/or CAPTCTRLA[EDGA1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM3CAPTCTRLA_EDGCNTA_EN BIT7
;;   Edge Counter A Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM3CAPTCTRLA_CFAWM     (BIT8|BIT9)
;;   Capture A FIFOs Water Mark
 set     PWMA_SM3CAPTCTRLA_CFAWM_0   BIT8
 set     PWMA_SM3CAPTCTRLA_CFAWM_1   BIT9

 set     PWMA_SM3CAPTCTRLA_CA0CNT    (BIT10|BIT11|BIT12)
;;   Capture A0 FIFO Word Count
 set     PWMA_SM3CAPTCTRLA_CA0CNT_0  BIT10
 set     PWMA_SM3CAPTCTRLA_CA0CNT_1  BIT11
 set     PWMA_SM3CAPTCTRLA_CA0CNT_2  BIT12

 set     PWMA_SM3CAPTCTRLA_CA1CNT    (BIT13|BIT14|BIT15)
;;   Capture A1 FIFO Word Count
 set     PWMA_SM3CAPTCTRLA_CA1CNT_0  BIT13
 set     PWMA_SM3CAPTCTRLA_CA1CNT_1  BIT14
 set     PWMA_SM3CAPTCTRLA_CA1CNT_2  BIT15

 set     PWMA_SM3CAPTCOMPA_EDGCMPA   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare A
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_0 BIT0
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_1 BIT1
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_2 BIT2
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_3 BIT3
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_4 BIT4
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_5 BIT5
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_6 BIT6
 set     PWMA_SM3CAPTCOMPA_EDGCMPA_7 BIT7

 set     PWMA_SM3CAPTCOMPA_EDGCNTA   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter A
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_0 BIT8
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_1 BIT9
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_2 BIT10
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_3 BIT11
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_4 BIT12
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_5 BIT13
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_6 BIT14
 set     PWMA_SM3CAPTCOMPA_EDGCNTA_7 BIT15

 set     PWMA_SM3CAPTCTRLB_ARMB      BIT0
;;   Arm B
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLB[EDGBx] is enabled.

 set     PWMA_SM3CAPTCTRLB_ONESHOTB  BIT1
;;   One Shot Mode B
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after CAPTCTRLB[ARMB] is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and CAPTCTRLB[ARMB] is cleared. No further captures will be performed until CAPTCTRLB[ARMB] is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled
;;             capture circuit and CAPTCTRLB[ARMB] is then cleared.

 set     PWMA_SM3CAPTCTRLB_EDGB0     (BIT2|BIT3)
;;   Edge B 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM3CAPTCTRLB_EDGB0_0   BIT2
 set     PWMA_SM3CAPTCTRLB_EDGB0_1   BIT3

 set     PWMA_SM3CAPTCTRLB_EDGB1     (BIT4|BIT5)
;;   Edge B 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM3CAPTCTRLB_EDGB1_0   BIT4
 set     PWMA_SM3CAPTCTRLB_EDGB1_1   BIT5

 set     PWMA_SM3CAPTCTRLB_INP_SELB  BIT6
;;   Input Select B
;;     0b0 ==> Raw PWM_B input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLB[EDGB0] and CAPTCTRLB[EDGB1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRB[EDGB0] and/or CAPTCTRLB[EDGB1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM3CAPTCTRLB_EDGCNTB_EN BIT7
;;   Edge Counter B Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM3CAPTCTRLB_CFBWM     (BIT8|BIT9)
;;   Capture B FIFOs Water Mark
 set     PWMA_SM3CAPTCTRLB_CFBWM_0   BIT8
 set     PWMA_SM3CAPTCTRLB_CFBWM_1   BIT9

 set     PWMA_SM3CAPTCTRLB_CB0CNT    (BIT10|BIT11|BIT12)
;;   Capture B0 FIFO Word Count
 set     PWMA_SM3CAPTCTRLB_CB0CNT_0  BIT10
 set     PWMA_SM3CAPTCTRLB_CB0CNT_1  BIT11
 set     PWMA_SM3CAPTCTRLB_CB0CNT_2  BIT12

 set     PWMA_SM3CAPTCTRLB_CB1CNT    (BIT13|BIT14|BIT15)
;;   Capture B1 FIFO Word Count
 set     PWMA_SM3CAPTCTRLB_CB1CNT_0  BIT13
 set     PWMA_SM3CAPTCTRLB_CB1CNT_1  BIT14
 set     PWMA_SM3CAPTCTRLB_CB1CNT_2  BIT15

 set     PWMA_SM3CAPTCOMPB_EDGCMPB   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare B
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_0 BIT0
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_1 BIT1
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_2 BIT2
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_3 BIT3
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_4 BIT4
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_5 BIT5
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_6 BIT6
 set     PWMA_SM3CAPTCOMPB_EDGCMPB_7 BIT7

 set     PWMA_SM3CAPTCOMPB_EDGCNTB   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter B
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_0 BIT8
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_1 BIT9
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_2 BIT10
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_3 BIT11
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_4 BIT12
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_5 BIT13
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_6 BIT14
 set     PWMA_SM3CAPTCOMPB_EDGCNTB_7 BIT15

 set     PWMA_SM3CAPTCTRLX_ARMX      BIT0
;;   Arm X
;;     0b0 ==> Input capture operation is disabled.
;;     0b1 ==> Input capture operation as specified by CAPTCTRLX[EDGXx] is enabled.

 set     PWMA_SM3CAPTCTRLX_ONESHOTX  BIT1
;;   One Shot Mode Aux
;;     0b0 ==> Free running mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and capture circuit 0 is re-armed. The process continues indefinitely. If only one of the capture circuits is enabled, then captures continue indefinitely on the enabled capture circuit.
;;     0b1 ==> One shot mode is selected. If both capture circuits are enabled, then capture circuit 0 is armed first after the ARMX bit is set. Once a capture occurs, capture circuit 0 is disarmed and capture circuit 1 is armed. After capture circuit 1 performs a capture, it is disarmed and the ARMX bit is cleared. No further captures will be performed until the ARMX bit is set again. If only one of the capture circuits is enabled, then a single capture will occur on the enabled capture
;;             circuit and the ARMX bit is then cleared.

 set     PWMA_SM3CAPTCTRLX_EDGX0     (BIT2|BIT3)
;;   Edge X 0
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM3CAPTCTRLX_EDGX0_0   BIT2
 set     PWMA_SM3CAPTCTRLX_EDGX0_1   BIT3

 set     PWMA_SM3CAPTCTRLX_EDGX1     (BIT4|BIT5)
;;   Edge X 1
;;     0b00 ==> Disabled
;;     0b01 ==> Capture falling edges
;;     0b10 ==> Capture rising edges
;;     0b11 ==> Capture any edge
 set     PWMA_SM3CAPTCTRLX_EDGX1_0   BIT4
 set     PWMA_SM3CAPTCTRLX_EDGX1_1   BIT5

 set     PWMA_SM3CAPTCTRLX_INP_SELX  BIT6
;;   Input Select X
;;     0b0 ==> Raw PWM_X input signal selected as source.
;;     0b1 ==> Output of edge counter/compare selected as source. When this bitfield is set to 1, the internal edge counter is enabled and the rising and/or falling edges specified by the CAPTCTRLX[EDGX0] and CAPTCTRLX[EDGX1] fields are ignored. The software must still place a value other than 00 in either or both of the CAPTCTLRX[EDGX0] and/or CAPTCTRLX[EDGX1] fields in order to enable one or both of the capture registers.

 set     PWMA_SM3CAPTCTRLX_EDGCNTX_EN BIT7
;;   Edge Counter X Enable
;;     0b0 ==> Edge counter disabled and held in reset
;;     0b1 ==> Edge counter enabled

 set     PWMA_SM3CAPTCTRLX_CFXWM     (BIT8|BIT9)
;;   Capture X FIFOs Water Mark
 set     PWMA_SM3CAPTCTRLX_CFXWM_0   BIT8
 set     PWMA_SM3CAPTCTRLX_CFXWM_1   BIT9

 set     PWMA_SM3CAPTCTRLX_CX0CNT    (BIT10|BIT11|BIT12)
;;   Capture X0 FIFO Word Count
 set     PWMA_SM3CAPTCTRLX_CX0CNT_0  BIT10
 set     PWMA_SM3CAPTCTRLX_CX0CNT_1  BIT11
 set     PWMA_SM3CAPTCTRLX_CX0CNT_2  BIT12

 set     PWMA_SM3CAPTCTRLX_CX1CNT    (BIT13|BIT14|BIT15)
;;   Capture X1 FIFO Word Count
 set     PWMA_SM3CAPTCTRLX_CX1CNT_0  BIT13
 set     PWMA_SM3CAPTCTRLX_CX1CNT_1  BIT14
 set     PWMA_SM3CAPTCTRLX_CX1CNT_2  BIT15

 set     PWMA_SM3CAPTCOMPX_EDGCMPX   (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Edge Compare X
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_0 BIT0
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_1 BIT1
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_2 BIT2
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_3 BIT3
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_4 BIT4
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_5 BIT5
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_6 BIT6
 set     PWMA_SM3CAPTCOMPX_EDGCMPX_7 BIT7

 set     PWMA_SM3CAPTCOMPX_EDGCNTX   (BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   Edge Counter X
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_0 BIT8
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_1 BIT9
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_2 BIT10
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_3 BIT11
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_4 BIT12
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_5 BIT13
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_6 BIT14
 set     PWMA_SM3CAPTCOMPX_EDGCNTX_7 BIT15

 set     PWMA_SM3CVAL0_CAPTVAL0      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM3CVAL0_CAPTVAL0_0    BIT0
 set     PWMA_SM3CVAL0_CAPTVAL0_1    BIT1
 set     PWMA_SM3CVAL0_CAPTVAL0_2    BIT2
 set     PWMA_SM3CVAL0_CAPTVAL0_3    BIT3
 set     PWMA_SM3CVAL0_CAPTVAL0_4    BIT4
 set     PWMA_SM3CVAL0_CAPTVAL0_5    BIT5
 set     PWMA_SM3CVAL0_CAPTVAL0_6    BIT6
 set     PWMA_SM3CVAL0_CAPTVAL0_7    BIT7
 set     PWMA_SM3CVAL0_CAPTVAL0_8    BIT8
 set     PWMA_SM3CVAL0_CAPTVAL0_9    BIT9
 set     PWMA_SM3CVAL0_CAPTVAL0_10   BIT10
 set     PWMA_SM3CVAL0_CAPTVAL0_11   BIT11
 set     PWMA_SM3CVAL0_CAPTVAL0_12   BIT12
 set     PWMA_SM3CVAL0_CAPTVAL0_13   BIT13
 set     PWMA_SM3CVAL0_CAPTVAL0_14   BIT14
 set     PWMA_SM3CVAL0_CAPTVAL0_15   BIT15

 set     PWMA_SM3CVAL0CYC_CVAL0CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM3CVAL0CYC_CVAL0CYC_0 BIT0
 set     PWMA_SM3CVAL0CYC_CVAL0CYC_1 BIT1
 set     PWMA_SM3CVAL0CYC_CVAL0CYC_2 BIT2
 set     PWMA_SM3CVAL0CYC_CVAL0CYC_3 BIT3

 set     PWMA_SM3CVAL1_CAPTVAL1      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM3CVAL1_CAPTVAL1_0    BIT0
 set     PWMA_SM3CVAL1_CAPTVAL1_1    BIT1
 set     PWMA_SM3CVAL1_CAPTVAL1_2    BIT2
 set     PWMA_SM3CVAL1_CAPTVAL1_3    BIT3
 set     PWMA_SM3CVAL1_CAPTVAL1_4    BIT4
 set     PWMA_SM3CVAL1_CAPTVAL1_5    BIT5
 set     PWMA_SM3CVAL1_CAPTVAL1_6    BIT6
 set     PWMA_SM3CVAL1_CAPTVAL1_7    BIT7
 set     PWMA_SM3CVAL1_CAPTVAL1_8    BIT8
 set     PWMA_SM3CVAL1_CAPTVAL1_9    BIT9
 set     PWMA_SM3CVAL1_CAPTVAL1_10   BIT10
 set     PWMA_SM3CVAL1_CAPTVAL1_11   BIT11
 set     PWMA_SM3CVAL1_CAPTVAL1_12   BIT12
 set     PWMA_SM3CVAL1_CAPTVAL1_13   BIT13
 set     PWMA_SM3CVAL1_CAPTVAL1_14   BIT14
 set     PWMA_SM3CVAL1_CAPTVAL1_15   BIT15

 set     PWMA_SM3CVAL1CYC_CVAL1CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM3CVAL1CYC_CVAL1CYC_0 BIT0
 set     PWMA_SM3CVAL1CYC_CVAL1CYC_1 BIT1
 set     PWMA_SM3CVAL1CYC_CVAL1CYC_2 BIT2
 set     PWMA_SM3CVAL1CYC_CVAL1CYC_3 BIT3

 set     PWMA_SM3CVAL2_CAPTVAL2      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM3CVAL2_CAPTVAL2_0    BIT0
 set     PWMA_SM3CVAL2_CAPTVAL2_1    BIT1
 set     PWMA_SM3CVAL2_CAPTVAL2_2    BIT2
 set     PWMA_SM3CVAL2_CAPTVAL2_3    BIT3
 set     PWMA_SM3CVAL2_CAPTVAL2_4    BIT4
 set     PWMA_SM3CVAL2_CAPTVAL2_5    BIT5
 set     PWMA_SM3CVAL2_CAPTVAL2_6    BIT6
 set     PWMA_SM3CVAL2_CAPTVAL2_7    BIT7
 set     PWMA_SM3CVAL2_CAPTVAL2_8    BIT8
 set     PWMA_SM3CVAL2_CAPTVAL2_9    BIT9
 set     PWMA_SM3CVAL2_CAPTVAL2_10   BIT10
 set     PWMA_SM3CVAL2_CAPTVAL2_11   BIT11
 set     PWMA_SM3CVAL2_CAPTVAL2_12   BIT12
 set     PWMA_SM3CVAL2_CAPTVAL2_13   BIT13
 set     PWMA_SM3CVAL2_CAPTVAL2_14   BIT14
 set     PWMA_SM3CVAL2_CAPTVAL2_15   BIT15

 set     PWMA_SM3CVAL2CYC_CVAL2CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM3CVAL2CYC_CVAL2CYC_0 BIT0
 set     PWMA_SM3CVAL2CYC_CVAL2CYC_1 BIT1
 set     PWMA_SM3CVAL2CYC_CVAL2CYC_2 BIT2
 set     PWMA_SM3CVAL2CYC_CVAL2CYC_3 BIT3

 set     PWMA_SM3CVAL3_CAPTVAL3      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM3CVAL3_CAPTVAL3_0    BIT0
 set     PWMA_SM3CVAL3_CAPTVAL3_1    BIT1
 set     PWMA_SM3CVAL3_CAPTVAL3_2    BIT2
 set     PWMA_SM3CVAL3_CAPTVAL3_3    BIT3
 set     PWMA_SM3CVAL3_CAPTVAL3_4    BIT4
 set     PWMA_SM3CVAL3_CAPTVAL3_5    BIT5
 set     PWMA_SM3CVAL3_CAPTVAL3_6    BIT6
 set     PWMA_SM3CVAL3_CAPTVAL3_7    BIT7
 set     PWMA_SM3CVAL3_CAPTVAL3_8    BIT8
 set     PWMA_SM3CVAL3_CAPTVAL3_9    BIT9
 set     PWMA_SM3CVAL3_CAPTVAL3_10   BIT10
 set     PWMA_SM3CVAL3_CAPTVAL3_11   BIT11
 set     PWMA_SM3CVAL3_CAPTVAL3_12   BIT12
 set     PWMA_SM3CVAL3_CAPTVAL3_13   BIT13
 set     PWMA_SM3CVAL3_CAPTVAL3_14   BIT14
 set     PWMA_SM3CVAL3_CAPTVAL3_15   BIT15

 set     PWMA_SM3CVAL3CYC_CVAL3CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM3CVAL3CYC_CVAL3CYC_0 BIT0
 set     PWMA_SM3CVAL3CYC_CVAL3CYC_1 BIT1
 set     PWMA_SM3CVAL3CYC_CVAL3CYC_2 BIT2
 set     PWMA_SM3CVAL3CYC_CVAL3CYC_3 BIT3

 set     PWMA_SM3CVAL4_CAPTVAL4      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM3CVAL4_CAPTVAL4_0    BIT0
 set     PWMA_SM3CVAL4_CAPTVAL4_1    BIT1
 set     PWMA_SM3CVAL4_CAPTVAL4_2    BIT2
 set     PWMA_SM3CVAL4_CAPTVAL4_3    BIT3
 set     PWMA_SM3CVAL4_CAPTVAL4_4    BIT4
 set     PWMA_SM3CVAL4_CAPTVAL4_5    BIT5
 set     PWMA_SM3CVAL4_CAPTVAL4_6    BIT6
 set     PWMA_SM3CVAL4_CAPTVAL4_7    BIT7
 set     PWMA_SM3CVAL4_CAPTVAL4_8    BIT8
 set     PWMA_SM3CVAL4_CAPTVAL4_9    BIT9
 set     PWMA_SM3CVAL4_CAPTVAL4_10   BIT10
 set     PWMA_SM3CVAL4_CAPTVAL4_11   BIT11
 set     PWMA_SM3CVAL4_CAPTVAL4_12   BIT12
 set     PWMA_SM3CVAL4_CAPTVAL4_13   BIT13
 set     PWMA_SM3CVAL4_CAPTVAL4_14   BIT14
 set     PWMA_SM3CVAL4_CAPTVAL4_15   BIT15

 set     PWMA_SM3CVAL4CYC_CVAL4CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM3CVAL4CYC_CVAL4CYC_0 BIT0
 set     PWMA_SM3CVAL4CYC_CVAL4CYC_1 BIT1
 set     PWMA_SM3CVAL4CYC_CVAL4CYC_2 BIT2
 set     PWMA_SM3CVAL4CYC_CVAL4CYC_3 BIT3

 set     PWMA_SM3CVAL5_CAPTVAL5      (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
 set     PWMA_SM3CVAL5_CAPTVAL5_0    BIT0
 set     PWMA_SM3CVAL5_CAPTVAL5_1    BIT1
 set     PWMA_SM3CVAL5_CAPTVAL5_2    BIT2
 set     PWMA_SM3CVAL5_CAPTVAL5_3    BIT3
 set     PWMA_SM3CVAL5_CAPTVAL5_4    BIT4
 set     PWMA_SM3CVAL5_CAPTVAL5_5    BIT5
 set     PWMA_SM3CVAL5_CAPTVAL5_6    BIT6
 set     PWMA_SM3CVAL5_CAPTVAL5_7    BIT7
 set     PWMA_SM3CVAL5_CAPTVAL5_8    BIT8
 set     PWMA_SM3CVAL5_CAPTVAL5_9    BIT9
 set     PWMA_SM3CVAL5_CAPTVAL5_10   BIT10
 set     PWMA_SM3CVAL5_CAPTVAL5_11   BIT11
 set     PWMA_SM3CVAL5_CAPTVAL5_12   BIT12
 set     PWMA_SM3CVAL5_CAPTVAL5_13   BIT13
 set     PWMA_SM3CVAL5_CAPTVAL5_14   BIT14
 set     PWMA_SM3CVAL5_CAPTVAL5_15   BIT15

 set     PWMA_SM3CVAL5CYC_CVAL5CYC   (BIT0|BIT1|BIT2|BIT3)
 set     PWMA_SM3CVAL5CYC_CVAL5CYC_0 BIT0
 set     PWMA_SM3CVAL5CYC_CVAL5CYC_1 BIT1
 set     PWMA_SM3CVAL5CYC_CVAL5CYC_2 BIT2
 set     PWMA_SM3CVAL5CYC_CVAL5CYC_3 BIT3

 set     PWMA_OUTEN_PWMX_EN          (BIT0|BIT1|BIT2|BIT3)
;;   PWM_X Output Enables
;;     0b0 ==> PWM_X output disabled.
;;     0b1 ==> PWM_X output enabled.
 set     PWMA_OUTEN_PWMX_EN_0        BIT0
 set     PWMA_OUTEN_PWMX_EN_1        BIT1
 set     PWMA_OUTEN_PWMX_EN_2        BIT2
 set     PWMA_OUTEN_PWMX_EN_3        BIT3

 set     PWMA_OUTEN_PWMB_EN          (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Output Enables
;;     0b0 ==> PWM_B output disabled.
;;     0b1 ==> PWM_B output enabled.
 set     PWMA_OUTEN_PWMB_EN_0        BIT4
 set     PWMA_OUTEN_PWMB_EN_1        BIT5
 set     PWMA_OUTEN_PWMB_EN_2        BIT6
 set     PWMA_OUTEN_PWMB_EN_3        BIT7

 set     PWMA_OUTEN_PWMA_EN          (BIT8|BIT9|BIT10|BIT11)
;;   PWM_A Output Enables
;;     0b0 ==> PWM_A output disabled.
;;     0b1 ==> PWM_A output enabled.
 set     PWMA_OUTEN_PWMA_EN_0        BIT8
 set     PWMA_OUTEN_PWMA_EN_1        BIT9
 set     PWMA_OUTEN_PWMA_EN_2        BIT10
 set     PWMA_OUTEN_PWMA_EN_3        BIT11

 set     PWMA_MASK_MASKX             (BIT0|BIT1|BIT2|BIT3)
;;   PWM_X Masks
;;     0b0 ==> PWM_X output normal.
;;     0b1 ==> PWM_X output masked.
 set     PWMA_MASK_MASKX_0           BIT0
 set     PWMA_MASK_MASKX_1           BIT1
 set     PWMA_MASK_MASKX_2           BIT2
 set     PWMA_MASK_MASKX_3           BIT3

 set     PWMA_MASK_MASKB             (BIT4|BIT5|BIT6|BIT7)
;;   PWM_B Masks
;;     0b0 ==> PWM_B output normal.
;;     0b1 ==> PWM_B output masked.
 set     PWMA_MASK_MASKB_0           BIT4
 set     PWMA_MASK_MASKB_1           BIT5
 set     PWMA_MASK_MASKB_2           BIT6
 set     PWMA_MASK_MASKB_3           BIT7

 set     PWMA_MASK_MASKA             (BIT8|BIT9|BIT10|BIT11)
;;   PWM_A Masks
;;     0b0 ==> PWM_A output normal.
;;     0b1 ==> PWM_A output masked.
 set     PWMA_MASK_MASKA_0           BIT8
 set     PWMA_MASK_MASKA_1           BIT9
 set     PWMA_MASK_MASKA_2           BIT10
 set     PWMA_MASK_MASKA_3           BIT11

 set     PWMA_SWCOUT_SM0OUT45        BIT0
;;   Submodule 0 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 0 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 0 instead of PWM45.

 set     PWMA_SWCOUT_SM0OUT23        BIT1
;;   Submodule 0 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 0 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 0 instead of PWM23.

 set     PWMA_SWCOUT_SM1OUT45        BIT2
;;   Submodule 1 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 1 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 1 instead of PWM45.

 set     PWMA_SWCOUT_SM1OUT23        BIT3
;;   Submodule 1 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 1 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 1 instead of PWM23.

 set     PWMA_SWCOUT_SM2OUT45        BIT4
;;   Submodule 2 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 2 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 2 instead of PWM45.

 set     PWMA_SWCOUT_SM2OUT23        BIT5
;;   Submodule 2 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 2 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 2 instead of PWM23.

 set     PWMA_SWCOUT_SM3OUT45        BIT6
;;   Submodule 3 Software Controlled Output 45
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 3 instead of PWM45.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 3 instead of PWM45.

 set     PWMA_SWCOUT_SM3OUT23        BIT7
;;   Submodule 3 Software Controlled Output 23
;;     0b0 ==> A logic 0 is supplied to the deadtime generator of submodule 3 instead of PWM23.
;;     0b1 ==> A logic 1 is supplied to the deadtime generator of submodule 3 instead of PWM23.

 set     PWMA_DTSRCSEL_SM0SEL45      (BIT0|BIT1)
;;   Submodule 0 PWM45 Control Select
;;     0b00 ==> Generated SM0PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM0PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM0OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM0_EXTB signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM0SEL45_0    BIT0
 set     PWMA_DTSRCSEL_SM0SEL45_1    BIT1

 set     PWMA_DTSRCSEL_SM0SEL23      (BIT2|BIT3)
;;   Submodule 0 PWM23 Control Select
;;     0b00 ==> Generated SM0PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM0PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM0OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM0_EXTA signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM0SEL23_0    BIT2
 set     PWMA_DTSRCSEL_SM0SEL23_1    BIT3

 set     PWMA_DTSRCSEL_SM1SEL45      (BIT4|BIT5)
;;   Submodule 1 PWM45 Control Select
;;     0b00 ==> Generated SM1PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM1PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM1OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM1_EXTB signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM1SEL45_0    BIT4
 set     PWMA_DTSRCSEL_SM1SEL45_1    BIT5

 set     PWMA_DTSRCSEL_SM1SEL23      (BIT6|BIT7)
;;   Submodule 1 PWM23 Control Select
;;     0b00 ==> Generated SM1PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM1PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM1OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM1_EXTA signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM1SEL23_0    BIT6
 set     PWMA_DTSRCSEL_SM1SEL23_1    BIT7

 set     PWMA_DTSRCSEL_SM2SEL45      (BIT8|BIT9)
;;   Submodule 2 PWM45 Control Select
;;     0b00 ==> Generated SM2PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM2PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM2OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM2_EXTB signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM2SEL45_0    BIT8
 set     PWMA_DTSRCSEL_SM2SEL45_1    BIT9

 set     PWMA_DTSRCSEL_SM2SEL23      (BIT10|BIT11)
;;   Submodule 2 PWM23 Control Select
;;     0b00 ==> Generated SM2PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM2PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM2OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM2_EXTA signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM2SEL23_0    BIT10
 set     PWMA_DTSRCSEL_SM2SEL23_1    BIT11

 set     PWMA_DTSRCSEL_SM3SEL45      (BIT12|BIT13)
;;   Submodule 3 PWM45 Control Select
;;     0b00 ==> Generated SM3PWM45 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM3PWM45 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM3OUT45] is used by the deadtime logic.
;;     0b11 ==> PWM3_EXTB signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM3SEL45_0    BIT12
 set     PWMA_DTSRCSEL_SM3SEL45_1    BIT13

 set     PWMA_DTSRCSEL_SM3SEL23      (BIT14|BIT15)
;;   Submodule 3 PWM23 Control Select
;;     0b00 ==> Generated SM3PWM23 signal is used by the deadtime logic.
;;     0b01 ==> Inverted generated SM3PWM23 signal is used by the deadtime logic.
;;     0b10 ==> SWCOUT[SM3OUT23] is used by the deadtime logic.
;;     0b11 ==> PWM3_EXTA signal is used by the deadtime logic.
 set     PWMA_DTSRCSEL_SM3SEL23_0    BIT14
 set     PWMA_DTSRCSEL_SM3SEL23_1    BIT15

 set     PWMA_MCTRL_LDOK             (BIT0|BIT1|BIT2|BIT3)
;;   Load Okay
;;     0b0 ==> Do not load new values.
;;     0b1 ==> Load prescaler, modulus, and PWM values of the corresponding submodule.
 set     PWMA_MCTRL_LDOK_0           BIT0
 set     PWMA_MCTRL_LDOK_1           BIT1
 set     PWMA_MCTRL_LDOK_2           BIT2
 set     PWMA_MCTRL_LDOK_3           BIT3

 set     PWMA_MCTRL_CLDOK            (BIT4|BIT5|BIT6|BIT7)
;;   Clear Load Okay
 set     PWMA_MCTRL_CLDOK_0          BIT4
 set     PWMA_MCTRL_CLDOK_1          BIT5
 set     PWMA_MCTRL_CLDOK_2          BIT6
 set     PWMA_MCTRL_CLDOK_3          BIT7

 set     PWMA_MCTRL_RUN              (BIT8|BIT9|BIT10|BIT11)
;;   Run
;;     0b0 ==> PWM generator is disabled in the corresponding submodule.
;;     0b1 ==> PWM generator is enabled in the corresponding submodule.
 set     PWMA_MCTRL_RUN_0            BIT8
 set     PWMA_MCTRL_RUN_1            BIT9
 set     PWMA_MCTRL_RUN_2            BIT10
 set     PWMA_MCTRL_RUN_3            BIT11

 set     PWMA_MCTRL_IPOL             (BIT12|BIT13|BIT14|BIT15)
;;   Current Polarity
;;     0b0 ==> PWM23 is used to generate complementary PWM pair in the corresponding submodule.
;;     0b1 ==> PWM45 is used to generate complementary PWM pair in the corresponding submodule.
 set     PWMA_MCTRL_IPOL_0           BIT12
 set     PWMA_MCTRL_IPOL_1           BIT13
 set     PWMA_MCTRL_IPOL_2           BIT14
 set     PWMA_MCTRL_IPOL_3           BIT15

 set     PWMA_MCTRL2_MONPLL          (BIT0|BIT1)
;;   Monitor PLL State
;;     0b00 ==> Not locked. Do not monitor PLL operation. Resetting of the fractional delay block in case of PLL losing lock will be controlled by software.
;;     0b01 ==> Not locked. Monitor PLL operation to automatically disable the fractional delay block when the PLL encounters problems.
;;     0b10 ==> Locked. Do not monitor PLL operation. Resetting of the fractional delay block in case of PLL losing lock will be controlled by software. These bits are write protected until the next reset.
;;     0b11 ==> Locked. Monitor PLL operation to automatically disable the fractional delay block when the PLL encounters problems. These bits are write protected until the next reset.
 set     PWMA_MCTRL2_MONPLL_0        BIT0
 set     PWMA_MCTRL2_MONPLL_1        BIT1

 set     PWMA_FCTRL0_FIE             (BIT0|BIT1|BIT2|BIT3)
;;   Fault Interrupt Enables
;;     0b0 ==> FAULTx CPU interrupt requests disabled.
;;     0b1 ==> FAULTx CPU interrupt requests enabled.
 set     PWMA_FCTRL0_FIE_0           BIT0
 set     PWMA_FCTRL0_FIE_1           BIT1
 set     PWMA_FCTRL0_FIE_2           BIT2
 set     PWMA_FCTRL0_FIE_3           BIT3

 set     PWMA_FCTRL0_FSAFE           (BIT4|BIT5|BIT6|BIT7)
;;   Fault Safety Mode
;;     0b0 ==> Normal mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending on the state of FSTS[FFULL] without regard to the state of FSTS[FFPINx]. The PWM outputs disabled by this fault input will not be re-enabled until the actual FAULTx input signal de-asserts since the fault input will combinationally disable the PWM outputs (as programmed in DISMAPn).
;;     0b1 ==> Safe mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear and FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the state of FSTS[FFULL].
 set     PWMA_FCTRL0_FSAFE_0         BIT4
 set     PWMA_FCTRL0_FSAFE_1         BIT5
 set     PWMA_FCTRL0_FSAFE_2         BIT6
 set     PWMA_FCTRL0_FSAFE_3         BIT7

 set     PWMA_FCTRL0_FAUTO           (BIT8|BIT9|BIT10|BIT11)
;;   Automatic Fault Clearing
;;     0b0 ==> Manual fault clearing. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending the state of FSTS[FFULL]. This is further controlled by FCTRL[FSAFE].
;;     0b1 ==> Automatic fault clearing. PWM outputs disabled by this fault are enabled when FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the state of FSTS[FFULL] without regard to the state of FSTS[FFLAGx].
 set     PWMA_FCTRL0_FAUTO_0         BIT8
 set     PWMA_FCTRL0_FAUTO_1         BIT9
 set     PWMA_FCTRL0_FAUTO_2         BIT10
 set     PWMA_FCTRL0_FAUTO_3         BIT11

 set     PWMA_FCTRL0_FLVL            (BIT12|BIT13|BIT14|BIT15)
;;   Fault Level
;;     0b0 ==> A logic 0 on the fault input indicates a fault condition.
;;     0b1 ==> A logic 1 on the fault input indicates a fault condition.
 set     PWMA_FCTRL0_FLVL_0          BIT12
 set     PWMA_FCTRL0_FLVL_1          BIT13
 set     PWMA_FCTRL0_FLVL_2          BIT14
 set     PWMA_FCTRL0_FLVL_3          BIT15

 set     PWMA_FSTS0_FFLAG            (BIT0|BIT1|BIT2|BIT3)
;;   Fault Flags
;;     0b0 ==> No fault on the FAULTx pin.
;;     0b1 ==> Fault on the FAULTx pin.
 set     PWMA_FSTS0_FFLAG_0          BIT0
 set     PWMA_FSTS0_FFLAG_1          BIT1
 set     PWMA_FSTS0_FFLAG_2          BIT2
 set     PWMA_FSTS0_FFLAG_3          BIT3

 set     PWMA_FSTS0_FFULL            (BIT4|BIT5|BIT6|BIT7)
;;   Full Cycle
;;     0b0 ==> PWM outputs are not re-enabled at the start of a full cycle
;;     0b1 ==> PWM outputs are re-enabled at the start of a full cycle
 set     PWMA_FSTS0_FFULL_0          BIT4
 set     PWMA_FSTS0_FFULL_1          BIT5
 set     PWMA_FSTS0_FFULL_2          BIT6
 set     PWMA_FSTS0_FFULL_3          BIT7

 set     PWMA_FSTS0_FFPIN            (BIT8|BIT9|BIT10|BIT11)
;;   Filtered Fault Pins
 set     PWMA_FSTS0_FFPIN_0          BIT8
 set     PWMA_FSTS0_FFPIN_1          BIT9
 set     PWMA_FSTS0_FFPIN_2          BIT10
 set     PWMA_FSTS0_FFPIN_3          BIT11

 set     PWMA_FSTS0_FHALF            (BIT12|BIT13|BIT14|BIT15)
;;   Half Cycle Fault Recovery
;;     0b0 ==> PWM outputs are not re-enabled at the start of a half cycle.
;;     0b1 ==> PWM outputs are re-enabled at the start of a half cycle (as defined by VAL0).
 set     PWMA_FSTS0_FHALF_0          BIT12
 set     PWMA_FSTS0_FHALF_1          BIT13
 set     PWMA_FSTS0_FHALF_2          BIT14
 set     PWMA_FSTS0_FHALF_3          BIT15

 set     PWMA_FFILT0_FILT_PER        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Fault Filter Period
 set     PWMA_FFILT0_FILT_PER_0      BIT0
 set     PWMA_FFILT0_FILT_PER_1      BIT1
 set     PWMA_FFILT0_FILT_PER_2      BIT2
 set     PWMA_FFILT0_FILT_PER_3      BIT3
 set     PWMA_FFILT0_FILT_PER_4      BIT4
 set     PWMA_FFILT0_FILT_PER_5      BIT5
 set     PWMA_FFILT0_FILT_PER_6      BIT6
 set     PWMA_FFILT0_FILT_PER_7      BIT7

 set     PWMA_FFILT0_FILT_CNT        (BIT8|BIT9|BIT10)
;;   Fault Filter Count
 set     PWMA_FFILT0_FILT_CNT_0      BIT8
 set     PWMA_FFILT0_FILT_CNT_1      BIT9
 set     PWMA_FFILT0_FILT_CNT_2      BIT10

 set     PWMA_FFILT0_GSTR            BIT15
;;   Fault Glitch Stretch Enable
;;     0b0 ==> Fault input glitch stretching is disabled.
;;     0b1 ==> Input fault signals will be stretched to at least 2 IPBus clock cycles.

 set     PWMA_FTST0_FTEST            BIT0
;;   Fault Test
;;     0b0 ==> No fault
;;     0b1 ==> Cause a simulated fault

 set     PWMA_FCTRL1_FIE             (BIT0|BIT1|BIT2|BIT3)
;;   Fault Interrupt Enables
;;     0b0 ==> FAULTx CPU interrupt requests disabled.
;;     0b1 ==> FAULTx CPU interrupt requests enabled.
 set     PWMA_FCTRL1_FIE_0           BIT0
 set     PWMA_FCTRL1_FIE_1           BIT1
 set     PWMA_FCTRL1_FIE_2           BIT2
 set     PWMA_FCTRL1_FIE_3           BIT3

 set     PWMA_FCTRL1_FSAFE           (BIT4|BIT5|BIT6|BIT7)
;;   Fault Safety Mode
;;     0b0 ==> Normal mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending on the state of FSTS[FFULL] without regard to the state of FSTS[FFPINx]. The PWM outputs disabled by this fault input will not be re-enabled until the actual FAULTx input signal de-asserts since the fault input will combinationally disable the PWM outputs (as programmed in DISMAPn).
;;     0b1 ==> Safe mode. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear and FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the state of FSTS[FFULL].
 set     PWMA_FCTRL1_FSAFE_0         BIT4
 set     PWMA_FCTRL1_FSAFE_1         BIT5
 set     PWMA_FCTRL1_FSAFE_2         BIT6
 set     PWMA_FCTRL1_FSAFE_3         BIT7

 set     PWMA_FCTRL1_FAUTO           (BIT8|BIT9|BIT10|BIT11)
;;   Automatic Fault Clearing
;;     0b0 ==> Manual fault clearing. PWM outputs disabled by this fault are not enabled until FSTS[FFLAGx] is clear at the start of a half cycle or full cycle depending the state of FSTS[FFULL]. This is further controlled by FCTRL[FSAFE].
;;     0b1 ==> Automatic fault clearing. PWM outputs disabled by this fault are enabled when FSTS[FFPINx] is clear at the start of a half cycle or full cycle depending on the state of FSTS[FFULL] without regard to the state of FSTS[FFLAGx].
 set     PWMA_FCTRL1_FAUTO_0         BIT8
 set     PWMA_FCTRL1_FAUTO_1         BIT9
 set     PWMA_FCTRL1_FAUTO_2         BIT10
 set     PWMA_FCTRL1_FAUTO_3         BIT11

 set     PWMA_FCTRL1_FLVL            (BIT12|BIT13|BIT14|BIT15)
;;   Fault Level
;;     0b0 ==> A logic 0 on the fault input indicates a fault condition.
;;     0b1 ==> A logic 1 on the fault input indicates a fault condition.
 set     PWMA_FCTRL1_FLVL_0          BIT12
 set     PWMA_FCTRL1_FLVL_1          BIT13
 set     PWMA_FCTRL1_FLVL_2          BIT14
 set     PWMA_FCTRL1_FLVL_3          BIT15

 set     PWMA_FCTRL20_NOCOMB         (BIT0|BIT1|BIT2|BIT3)
;;   No Combinational Path From Fault Input To PWM Output
;;     0b0 ==> There is a combinational link from the fault inputs to the PWM outputs. The fault inputs are combined with the filtered and latched fault signals to disable the PWM outputs.
;;     0b1 ==> The direct combinational path from the fault inputs to the PWM outputs is disabled and the filtered and latched fault signals are used to disable the PWM outputs.
 set     PWMA_FCTRL20_NOCOMB_0       BIT0
 set     PWMA_FCTRL20_NOCOMB_1       BIT1
 set     PWMA_FCTRL20_NOCOMB_2       BIT2
 set     PWMA_FCTRL20_NOCOMB_3       BIT3

 set     PWMA_FSTS1_FFLAG            (BIT0|BIT1|BIT2|BIT3)
;;   Fault Flags
;;     0b0 ==> No fault on the FAULTx pin.
;;     0b1 ==> Fault on the FAULTx pin.
 set     PWMA_FSTS1_FFLAG_0          BIT0
 set     PWMA_FSTS1_FFLAG_1          BIT1
 set     PWMA_FSTS1_FFLAG_2          BIT2
 set     PWMA_FSTS1_FFLAG_3          BIT3

 set     PWMA_FSTS1_FFULL            (BIT4|BIT5|BIT6|BIT7)
;;   Full Cycle
;;     0b0 ==> PWM outputs are not re-enabled at the start of a full cycle
;;     0b1 ==> PWM outputs are re-enabled at the start of a full cycle
 set     PWMA_FSTS1_FFULL_0          BIT4
 set     PWMA_FSTS1_FFULL_1          BIT5
 set     PWMA_FSTS1_FFULL_2          BIT6
 set     PWMA_FSTS1_FFULL_3          BIT7

 set     PWMA_FSTS1_FFPIN            (BIT8|BIT9|BIT10|BIT11)
;;   Filtered Fault Pins
 set     PWMA_FSTS1_FFPIN_0          BIT8
 set     PWMA_FSTS1_FFPIN_1          BIT9
 set     PWMA_FSTS1_FFPIN_2          BIT10
 set     PWMA_FSTS1_FFPIN_3          BIT11

 set     PWMA_FSTS1_FHALF            (BIT12|BIT13|BIT14|BIT15)
;;   Half Cycle Fault Recovery
;;     0b0 ==> PWM outputs are not re-enabled at the start of a half cycle.
;;     0b1 ==> PWM outputs are re-enabled at the start of a half cycle (as defined by VAL0).
 set     PWMA_FSTS1_FHALF_0          BIT12
 set     PWMA_FSTS1_FHALF_1          BIT13
 set     PWMA_FSTS1_FHALF_2          BIT14
 set     PWMA_FSTS1_FHALF_3          BIT15

 set     PWMA_FFILT1_FILT_PER        (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7)
;;   Fault Filter Period
 set     PWMA_FFILT1_FILT_PER_0      BIT0
 set     PWMA_FFILT1_FILT_PER_1      BIT1
 set     PWMA_FFILT1_FILT_PER_2      BIT2
 set     PWMA_FFILT1_FILT_PER_3      BIT3
 set     PWMA_FFILT1_FILT_PER_4      BIT4
 set     PWMA_FFILT1_FILT_PER_5      BIT5
 set     PWMA_FFILT1_FILT_PER_6      BIT6
 set     PWMA_FFILT1_FILT_PER_7      BIT7

 set     PWMA_FFILT1_FILT_CNT        (BIT8|BIT9|BIT10)
;;   Fault Filter Count
 set     PWMA_FFILT1_FILT_CNT_0      BIT8
 set     PWMA_FFILT1_FILT_CNT_1      BIT9
 set     PWMA_FFILT1_FILT_CNT_2      BIT10

 set     PWMA_FFILT1_GSTR            BIT15
;;   Fault Glitch Stretch Enable
;;     0b0 ==> Fault input glitch stretching is disabled.
;;     0b1 ==> Input fault signals will be stretched to at least 2 IPBus clock cycles.

 set     PWMA_FTST1_FTEST            BIT0
;;   Fault Test
;;     0b0 ==> No fault
;;     0b1 ==> Cause a simulated fault

 set     PWMA_FCTRL21_NOCOMB         (BIT0|BIT1|BIT2|BIT3)
;;   No Combinational Path From Fault Input To PWM Output
;;     0b0 ==> There is a combinational link from the fault inputs to the PWM outputs. The fault inputs are combined with the filtered and latched fault signals to disable the PWM outputs.
;;     0b1 ==> The direct combinational path from the fault inputs to the PWM outputs is disabled and the filtered and latched fault signals are used to disable the PWM outputs.
 set     PWMA_FCTRL21_NOCOMB_0       BIT0
 set     PWMA_FCTRL21_NOCOMB_1       BIT1
 set     PWMA_FCTRL21_NOCOMB_2       BIT2
 set     PWMA_FCTRL21_NOCOMB_3       BIT3

 set     QSCI0_RATE_FRAC_SBR         (BIT0|BIT1|BIT2)
;;   Fractional SCI Baud Rate divider, a value from 0 to 7 that is divided by 8
 set     QSCI0_RATE_FRAC_SBR_0       BIT0
 set     QSCI0_RATE_FRAC_SBR_1       BIT1
 set     QSCI0_RATE_FRAC_SBR_2       BIT2

 set     QSCI0_RATE_SBR              (BIT3|BIT4|BIT5|BIT6|BIT7|BIT8|BIT9|BIT10|BIT11|BIT12|BIT13|BIT14|BIT15)
;;   SCI Baud Rate divider, a value from 1 to 8191
 set     QSCI0_RATE_SBR_0            BIT3
 set     QSCI0_RATE_SBR_1            BIT4
 set     QSCI0_RATE_SBR_2            BIT5
 set     QSCI0_RATE_SBR_3            BIT6
 set     QSCI0_RATE_SBR_4            BIT7
 set     QSCI0_RATE_SBR_5            BIT8
 set     QSCI0_RATE_SBR_6            BIT9
 set     QSCI0_RATE_SBR_7            BIT10
 set     QSCI0_RATE_SBR_8            BIT11
 set     QSCI0_RATE_SBR_9            BIT12
 set     QSCI0_RATE_SBR_10           BIT13
 set     QSCI0_RATE_SBR_11           BIT14
 set     QSCI0_RATE_SBR_12           BIT15

 set     QSCI0_CTRL1_SBK             BIT0
;;   Send Break
;;     0b0 ==> No break characters
;;     0b1 ==> Transmit break characters

 set     QSCI0_CTRL1_RWU             BIT1
;;   Receiver Wake-up
;;     0b0 ==> Normal operation
;;     0b1 ==> Standby state

 set     QSCI0_CTRL1_RE              BIT2
;;   Receiver Enable
;;     0b0 ==> Receiver disabled
;;     0b1 ==> Receiver enabled

 set     QSCI0_CTRL1_TE              BIT3
;;   Transmitter Enable
;;     0b0 ==> Transmitter disabled
;;     0b1 ==> Transmitter enabled

 set     QSCI0_CTRL1_REIE            BIT4
;;   Receive Error Interrupt Enable
;;     0b0 ==> Error interrupt requests disabled
;;     0b1 ==> Error interrupt requests enabled

 set     QSCI0_CTRL1_RFIE            BIT5
;;   Receiver Full Interrupt Enable
;;     0b0 ==> STAT[RDRF] and STAT[OR] interrupt requests disabled
;;     0b1 ==> STAT[RDRF] and STAT[OR] interrupt requests enabled

 set     QSCI0_CTRL1_TIIE            BIT6
;;   Transmitter Idle Interrupt Enable
;;     0b0 ==> STAT[TIDLE] interrupt requests disabled
;;     0b1 ==> STAT[TIDLE] interrupt requests enabled

 set     QSCI0_CTRL1_TEIE            BIT7
;;   Transmitter Empty Interrupt Enable
;;     0b0 ==> STAT[TDRE] interrupt requests disabled
;;     0b1 ==> STAT[TDRE] interrupt requests enabled

 set     QSCI0_CTRL1_PT              BIT8
;;   Parity Type
;;     0b0 ==> Even parity
;;     0b1 ==> Odd parity

 set     QSCI0_CTRL1_PE              BIT9
;;   Parity Enable
;;     0b0 ==> Parity function disabled
;;     0b1 ==> Parity function enabled

 set     QSCI0_CTRL1_POL             BIT10
;;   Polarity
;;     0b0 ==> Don't invert transmit and receive data bits (normal mode)
;;     0b1 ==> Invert transmit and receive data bits (inverted mode)

 set     QSCI0_CTRL1_WAKE            BIT11
;;   Wake-up Condition
;;     0b0 ==> Idle line wake-up
;;     0b1 ==> Address mark wake-up

 set     QSCI0_CTRL1_M               BIT12
;;   Data Format Mode
;;     0b0 ==> One start bit, eight data bits, one stop bit
;;     0b1 ==> One start bit, nine data bits, one stop bit

 set     QSCI0_CTRL1_RSRC            BIT13
;;   Receiver Source
;;     0b0 ==> Receiver input internally connected to transmitter output
;;     0b1 ==> Receiver input connected to TXD pin

 set     QSCI0_CTRL1_SWAI            BIT14
;;   Stop in Wait Mode
;;     0b0 ==> SCI enabled in wait mode
;;     0b1 ==> SCI disabled in wait mode

 set     QSCI0_CTRL1_LOOP            BIT15
;;   Loop Select
;;     0b0 ==> Normal operation, regardless of the value of RSRC
;;     0b1 ==> When RSRC = 0: Loop mode with internal TXD fed back to RXD
;;     0b1 ==> When RSRC = 1: Single-wire mode with TXD output fed back to RXD

 set     QSCI0_CTRL2_RDE             BIT0
;;   Receiver DMA Enable
;;     0b0 ==> Receive DMA disabled
;;     0b1 ==> Receive DMA enabled

 set     QSCI0_CTRL2_TDE             BIT1
;;   Transmitter DMA Enable
;;     0b0 ==> Transmit DMA disabled
;;     0b1 ==> Transmit DMA enabled

 set     QSCI0_CTRL2_RIIE            BIT2
;;   Receiver Idle Interrupt Enable

 set     QSCI0_CTRL2_LINMODE         BIT3
;;   Enable LIN Slave Mode
;;     0b0 ==> The LIN auto baud feature is disabled and the RATE register maintains whatever value the processor writes to it.
;;     0b1 ==> Enable LIN slave functionality. This includes a search for the break character followed by a sync character (0x55) from the master LIN device. When the break is detected (11 consecutive samples of zero), the subsequent sync character is used to measure the baud rate of the transmitting master, and the RATE register is automatically reloaded with the value needed to "match" that baud rate.

 set     QSCI0_CTRL2_RIEIE           BIT4
;;   Receiver Input Edge Interrupt Enable
;;     0b0 ==> Receiver input edge interrupt request disabled.
;;     0b1 ==> Receiver input edge interrupt request enabled.

 set     QSCI0_CTRL2_FIFO_EN         BIT5
;;   FIFO Enable
;;     0b0 ==> FIFOs are disabled.
;;     0b1 ==> FIFOs are enabled.

 set     QSCI0_CTRL2_RFWM            (BIT6|BIT7)
;;   Receive FIFO Full Water Mark
;;     0b00 ==> RDRF is set when at least 1 word is in the FIFO
;;     0b01 ==> RDRF is set when at least 2 words are in the FIFO
;;     0b10 ==> RDRF is set when at least 3 words are in the FIFO
;;     0b11 ==> RDRF is set when at least 4 words are in the FIFO
 set     QSCI0_CTRL2_RFWM_0          BIT6
 set     QSCI0_CTRL2_RFWM_1          BIT7

 set     QSCI0_CTRL2_RFCNT           (BIT8|BIT9|BIT10)
;;   Receive FIFO Count
;;     0b000 ==> 0 words in RX FIFO
;;     0b001 ==> 1 word in RX FIFO
;;     0b010 ==> 2 words in RX FIFO
;;     0b011 ==> 3 words in RX FIFO
;;     0b100 ==> 4 words in RX FIFO
;;     0b101 ==> Reserved
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     QSCI0_CTRL2_RFCNT_0         BIT8
 set     QSCI0_CTRL2_RFCNT_1         BIT9
 set     QSCI0_CTRL2_RFCNT_2         BIT10

 set     QSCI0_CTRL2_TFWM            (BIT11|BIT12)
;;   Transmit FIFO Empty Water Mark
;;     0b00 ==> TDRE is set when 0 words are in the FIFO
;;     0b01 ==> TDRE is set when 1 or fewer words are in the FIFO
;;     0b10 ==> TDRE is set when 2 or fewer words are in the FIFO
;;     0b11 ==> TDRE is set when 3 or fewer words are in the FIFO
 set     QSCI0_CTRL2_TFWM_0          BIT11
 set     QSCI0_CTRL2_TFWM_1          BIT12

 set     QSCI0_CTRL2_TFCNT           (BIT13|BIT14|BIT15)
;;   Transmit FIFO Count
;;     0b000 ==> 0 words in Tx FIFO
;;     0b001 ==> 1 word in Tx FIFO
;;     0b010 ==> 2 words in Tx FIFO
;;     0b011 ==> 3 words in Tx FIFO
;;     0b100 ==> 4 words in Tx FIFO
;;     0b101 ==> Reserved
;;     0b110 ==> Reserved
;;     0b111 ==> Reserved
 set     QSCI0_CTRL2_TFCNT_0         BIT13
 set     QSCI0_CTRL2_TFCNT_1         BIT14
 set     QSCI0_CTRL2_TFCNT_2         BIT15

 set     QSCI0_STAT_RAF              BIT0
;;   Receiver Active Flag
;;     0b0 ==> No reception in progress
;;     0b1 ==> Reception in progress

 set     QSCI0_STAT_RDMA             BIT1
;;   Receive DMA Request
;;     0b0 ==> Either CTRL2[RDE] is cleared or CTRL2[RDE] is set and CTRL2[RFCNT] is 0.
;;     0b1 ==> CTRL2[RDE] is set and CTRL2[RFCNT] is currently above 0.

 set     QSCI0_STAT_TDMA             BIT2
;;   Transmit DMA Request
;;     0b0 ==> Either CTRL2[TDE] is cleared or CTRL2[TDE] is set and CTRL2[TFCNT] is at its maximum value.
;;     0b1 ==> CTRL2[TDE] is set and CTRL2[TFCNT] is currently below its maximum value.

 set     QSCI0_STAT_LSE              BIT3
;;   LIN Sync Error
;;     0b0 ==> No error occurred since CTRL2[LINMODE] was enabled or the bit was last cleared
;;     0b1 ==> A sync error prevented loading of the RATE register with a revised value after the break was detected.

 set     QSCI0_STAT_RIEF             BIT4
;;   Receiver Input Edge Flag
;;     0b0 ==> No active edge on the receive pin has occured.
;;     0b1 ==> An active edge on the receive pin has occured.

 set     QSCI0_STAT_PF               BIT8
;;   Parity Error Flag
;;     0b0 ==> No parity error
;;     0b1 ==> Parity error

 set     QSCI0_STAT_FE               BIT9
;;   Framing Error Flag
;;     0b0 ==> No framing error
;;     0b1 ==> Framing error

 set     QSCI0_STAT_NF               BIT10
;;   Noise Flag
;;     0b0 ==> No noise
;;     0b1 ==> Noise

 set     QSCI0_STAT_OR               BIT11
;;   Overrun Flag
;;     0b0 ==> No overrun
;;     0b1 ==> Overrun

 set     QSCI0_STAT_RIDLE            BIT12
;;   Receiver Idle Line Flag
;;     0b0 ==> Receiver input is either active now or has never become active since RIDLE was last cleared
;;     0b1 ==> Receiver input has become idle (after receiving a valid frame)

 set     QSCI0_STAT_RDRF             BIT13
;;   Receive Data Register Full Flag
;;     0b0 ==> RX FIFO word count is at or below watermark
;;     0b1 ==> RX FIFO word count is above watermark

 set     QSCI0_STAT_TIDLE            BIT14
;;   Transmitter Idle Flag
;;     0b0 ==> Transmission in progress
;;     0b1 ==> No transmission in progress

 set     QSCI0_STAT_TDRE             BIT15
;;   Transmit Data Register Empty Flag
;;     0b0 ==> TX FIFO word count is above watermark
;;     0b1 ==> TX FIFO word count is at or below watermark

 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA (BIT0|BIT1|BIT2|BIT3|BIT4|BIT5|BIT6|BIT7|BIT8)
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_0 BIT0
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_1 BIT1
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_2 BIT2
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_3 BIT3
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_4 BIT4
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_5 BIT5
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_6 BIT6
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_7 BIT7
 set     QSCI0_DATA_RECEIVE_TRANSMIT_DATA_8 BIT8

 set     QSCI0_CTRL3_SHEN            BIT0
;;   Stop mode entry hold off
;;     0b0 ==> Stop mode hold off is disabled.
;;     0b1 ==> Stop mode holdoff is enabled.

 set     QSCI1_RATE_FRAC_SBR         (BIT0|BIT1|BIT2)
;;   Fractional