/* ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : TmDt1.c
**     Project     : MC56F84000_TimeDate
**     Processor   : MC56F84789VLL
**     Component   : TimeDate
**     Version     : Component 02.111, Driver 02.06, CPU db: 3.50.001
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-05-05, 13:48, # CodeGen: 9
**     Abstract    :
**         This component "TimeDate" implements real time and date.
**         The component requires a periodic interrupt generator: timer
**         compare or reload register or timer-overflow interrupt
**         (of free running counter). User can select precision of
**         selected timer.
**         The component supports also alarm with event OnAlarm.
**     Settings    :
**         Timer name                  : PIT0 (16-bit)
**
**         Counter                     : PIT0_CNTR [E102]
**         Mode register               : PIT0_CTRL [E100]
**         Run register                : PIT0_CTRL [E100]
**         Prescaler                   : PIT0_CTRL [E100]
**         Compare register            : PIT0_MOD  [E101]
**
**         Interrupt name              : INT_PIT0_ROLLOVR
**         Interrupt enable reg.       : PIT0_CTRL [E100]
**         Priority                    : 1
**         User handling procedure     : TmDt1_OnAlarm
**         This event is called whenever the current time is equal
**         to alarm time
**
**         High speed mode
**             Prescaler               : divide-by-2
**             Clock                   : 50000000 Hz
**           Resolution of timer
**             Xtal ticks              : 8000
**             microseconds            : 1000
**             milliseconds            : 1
**             seconds (real)          : 0.001
**             Hz                      : 1000
**             kHz                     : 1
**
**         Initialization:
**              Timer                  : Enabled
**
**              Time                   : 0:0:0
**              Date                   : 1/1/2015
**     Contents    :
**         SetTime  - byte TmDt1_SetTime(byte Hour, byte Min, byte Sec, byte Sec100);
**         SetDate  - byte TmDt1_SetDate(word Year, byte Month, byte Day);
**         GetDate  - byte TmDt1_GetDate(DATEREC *Date);
**         SetAlarm - byte TmDt1_SetAlarm(byte Hour, byte Min, byte Sec, byte Sec100);
**
**     Copyright : 1997 - 2014 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file TmDt1.c
** @version 02.06
** @brief
**         This component "TimeDate" implements real time and date.
**         The component requires a periodic interrupt generator: timer
**         compare or reload register or timer-overflow interrupt
**         (of free running counter). User can select precision of
**         selected timer.
**         The component supports also alarm with event OnAlarm.
*/         
/*!
**  @addtogroup TmDt1_module TmDt1 module documentation
**  @{
*/         

/* MODULE TmDt1. */

#include "Events.h"
#include "TmDt1.h"

static bool EnUser;                    /* Enable/Disable device by user */
static byte CntDay;                    /* Day counter */
static byte CntMonth;                  /* Month counter */
static word CntYear;                   /* Year Counter */
static dword TotalHthL;
static dword TotalHthH;                /* Software tick counter (1 tick = 10ms) */
static dword AlarmHth;                 /* Alarm time (compared with software tick counter) */
static bool AlarmFlg;                  /* Alarm flag */

/* Table of month length (in days) */
static const byte ULY[12] = {31U,28U,31U,30U,31U,30U,31U,31U,30U,31U,30U,31U}; /* Un-leap-year */
static const byte  LY[12] = {31U,29U,31U,30U,31U,30U,31U,31U,30U,31U,30U,31U}; /* Leap-year */
/* Number of days from beggin of the year */
static const word MONTH_DAYS[13] = {0U,31U,59U,90U,120U,151U,181U,212U,243U,273U,304U,334U}; /* Un-leap-year */

/* Internal method prototypes */
static void HWEnDi(void);
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (component TimeDate)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  setReg(PIT0_MOD,Val);                /* Store given value to the compare register */
}

/*
** ===================================================================
**     Method      :  SetPV (component TimeDate)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(PIT0_CTRL,PRESCALER,Val); /* Store given value to the prescaler */
}

/*
** ===================================================================
**     Method      :  HWEnDi (component TimeDate)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    setRegBit(PIT0_CTRL,CNT_EN);       /* Run counter */
  }
  else {                               /* Disable device? */
    clrRegBit(PIT0_CTRL,CNT_EN);       /* Stop counter */
  }
}

/*
** ===================================================================
**     Method      :  TmDt1_SetTime (component TimeDate)
**     Description :
**         This method sets a new actual time.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Hour            - Hours (0 - 23)
**         Min             - Minutes (0 - 59)
**         Sec             - Seconds (0 - 59)
**         Sec100          - Hundredths of seconds (0 - 99)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TmDt1_SetTime(byte Hour,byte Min,byte Sec,byte Sec100)
{
  bool TmrRun;                         /* Temporary flag enable/disable */

  if ((Sec100 > 0x63U) || (Sec > 0x3BU) || (Min > 0x3BU) || (Hour > 0x17U)) { /* Test correctnes of given time */
    return ERR_RANGE;                  /* If not correct then error */
  }
  TmrRun = EnUser;                     /* Store actual device state */
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Enable/disable device according to status flags */
  }
  TotalHthH = (0x00057E40UL * (dword)Hour) + (0x1770U * (dword)Min) + (0x64U * (dword)Sec) + (dword)Sec100; /* Load given time re-calculated to 10ms ticks into software tick counter */
  TotalHthL = 0U;
  AlarmFlg = (bool)((TotalHthH < AlarmHth) ? FALSE : TRUE); /* Set up alarm flag */
  if (TmrRun) {                        /* Was the device disabled? */
    EnUser = TRUE;                     /* If yes set flag "device enabled" */
    HWEnDi();                          /* Enable/disable device according to status flags */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TmDt1_SetDate (component TimeDate)
**     Description :
**         This method sets a new actual date. See limitations at the
**         page <General Info>.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Year            - Years (16-bit unsigned integer)
**         Month           - Months (8-bit unsigned integer)
**         Day             - Days (8-bit unsigned integer)
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_RANGE - Parameter out of range
** ===================================================================
*/
byte TmDt1_SetDate(word Year,byte Month,byte Day)
{
  const byte *ptr;                     /* Pointer to ULY/LY table */

  if ((Year < 0x07CEU) || (Year > 0x0833U) || (Month > 0x0CU) || (Month == 0x00U) || (Day > 0x1FU) || (Day == 0x00U)) { /* Test correctness of given parameters */
    return ERR_RANGE;                  /* If not correct then error */
  }
  if (Year & 0x03U) {                  /* Is given year un-leap-one? */
    ptr = ULY;                         /* Set pointer to un-leap-year day table */
  }
  else {                               /* Is given year leap-one? */
    ptr = LY;                          /* Set pointer to leap-year day table */
  }
  if (ptr[Month - 1U] < Day) {         /* Does the obtained number of days exceed number of days in the appropriate month & year? */
    return ERR_RANGE;                  /* If yes (incorrect date inserted) then error */
  }
  EnterCritical();                     /* Disable global interrupts */
  CntDay = Day;                        /* Set day counter to the given value */
  CntMonth = Month;                    /* Set month counter to the given value */
  CntYear = Year;                      /* Set year counter to the given value */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TmDt1_GetDate (component TimeDate)
**     Description :
**         This method returns current date.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Date            - Pointer to the structure DATEREC. It
**                           contains actual year, month, and day
**                           description.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte TmDt1_GetDate(DATEREC *Date)
{
  EnterCritical();                     /* Disable global interrupts */
  Date->Year = CntYear;                /* Year */
  Date->Month = CntMonth;              /* Month */
  Date->Day = CntDay;                  /* Day */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TmDt1_SetAlarm (component TimeDate)
**     Description :
**         This method sets a new time of alarm. (only time, not date -
**         alarm event <OnAlarm> is called every 24 hours). Setting any
**         parameter out of its range disables alarm.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Hour            - Hours (0 - 23)
**         Min             - Minutes (0 - 59)
**         Sec             - Seconds (0 - 59)
**         Sec100          - Hundredths of seconds (0 - 99)
**     Returns     :
**         ---             - Error code, possible codes: 
**                           - ERR_OK - OK 
**                           - ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte TmDt1_SetAlarm(byte Hour,byte Min,byte Sec,byte Sec100)
{
  register dword Hundredth;            /* Temporary variable */

  if ((Sec100 > 0x63U) || (Sec > 0x3BU) || (Min > 0x3BU) || (Hour > 0x17U)) { /* Test correctness of the given time */
    AlarmHth = ULONG_MAX;              /* If no correct then it means switch off the alarm */
    return ERR_OK;                     /* OK */
  }
  Hundredth = (0x00057E40UL * (dword)Hour) + (0x1770U * (dword)Min) + (0x64U * (dword)Sec) + (dword)Sec100; /* Load given time re-calculated to 10ms ticks into temporary variable */
  EnterCritical();                     /* Disable global interrupts */
  AlarmFlg = (bool)((TotalHthH < Hundredth) ? FALSE : TRUE); /* Set up alarm flag */
  AlarmHth = Hundredth;                /* Copy content of temporary variable into Alarm time variable */
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  TmDt1_Init (component TimeDate)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TmDt1_Init(void)
{
  /* PIT0_CTRL: SLAVE=0,??=0,??=0,??=0,??=0,??=0,CLKSEL=0,??=0,PRESCALER=0,PRF=0,PRIE=1,CNT_EN=0 */
  setReg(PIT0_CTRL,0x02);              /* Set up control register */
  EnUser = TRUE;                       /* Enable device */
  SetCV((word)0xC350);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x01);                   /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
  AlarmHth = ULONG_MAX;                /* Disable alarm */
  AlarmFlg = FALSE;                    /* Reset alarm flag */
  (void)TmDt1_SetDate((word)2015,(byte)1,(byte)1); /* Initial date */
  (void)TmDt1_SetTime((byte)0,(byte)0,(byte)0,(byte)0); /* Initialize time */
}

/*
** ===================================================================
**     Method      :  TmDt1_Interrupt (component TimeDate)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void TmDt1_Interrupt(void)
{
  bool UserEvent = FALSE;              /* Temporary variable */
  register dword Val32;                /* Temporary variable */
  register const byte *ptr;            /* Pointer to ULY/LY table */

  clrRegBit(PIT0_CTRL,PRF);            /* Reset interrupt request flag */
  Val32 = TotalHthL + 0x1999999AUL;    /* Add timer period to the lower part of software timer counter */
  if (Val32 < TotalHthL) {             /* Was there a carry from lower part into upper part of software timer counter? */
    TotalHthH++;                       /* If yes then increment upper part of the software timer counter */
  }
  TotalHthL = Val32;                   /* Write new value of the software timer counter */
  if (!AlarmFlg) {                     /* Has the alarm already been on? */
    if (TotalHthH >= AlarmHth) {       /* Is the condition for alarm invocation satisfied? */
      UserEvent = TRUE;                /* Set user event invocation flag */
      AlarmFlg = TRUE;                 /* Set alarm flag - alarm has been invocated */
    }
  }
  if (TotalHthH >= 0x0083D600UL) {     /* Does the counter reach 24 hours? */
    TotalHthH -= 0x0083D600UL;         /* If yes then reset it by subtracting exactly 24 hours */
    AlarmFlg = FALSE;                  /* Reset alarm flag - alarm has not occured during these 24 hours yet */
    CntDay++;                          /* Increment day counter */
    if (CntYear & 0x03U) {             /* Is this year un-leap-one? */
      ptr = ULY;                       /* Set pointer to un-leap-year day table */
    }
    else {                             /* Is this year leap-one? */
      ptr = LY;                        /* Set pointer to leap-year day table */
    }
    ptr--;                             /* Decrement the pointer */
    if (CntDay > ptr[CntMonth]) {      /* Day counter overflow? */
      CntDay = 1U;                     /* Set day counter on 1 */
      CntMonth++;                      /* Increment month counter */
      if (CntMonth > 0x0CU) {          /* Month counter overflow? */
        CntMonth = 1U;                 /* Set month counter on 1 */
        CntYear++;                     /* Increment year counter */
      }
    }
  }
  if (UserEvent) {                     /* Is the condition for user event invocation satisfied? */
    TmDt1_OnAlarm();                   /* Invoke user event */
  }
}

/* END TmDt1. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
