/* ###################################################################
**     Filename    : main.c
**     Project     : MC56F84000_PWM_sin_duty
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-04-30, 14:23, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "PWMA.h"
#include "FMSTR1.h"
#include "QSCI1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "intrinsics_56800E.h"

/*********************** variable structure define ***********************/
typedef struct
{
	Frac16  f16PwmSub_0_DutyCycleF16;
	Frac16  f16PwmSub_1_DutyCycleF16;
} PWM_COMPLEMENTARY_VALUES;

/*************************************** Global variable DEFINITIONS ******************************************/
bool   bEnable_Modulation = TRUE;
bool   bEnable_Calculation = TRUE;

PWM_COMPLEMENTARY_VALUES PwmSub01={(Frac16)(0),(Frac16)(0)};

Frac16 f16Duty_freemaster1, f16Duty_freemaster2, f16H_bridge_output;

Word16 Sine_increment[]={0,	515,	1029,	1542,	2053,	2563,	3070,	3574,	4074,	4571,	5063,	5550,	6031,	6507,	6976,	7438,	7893,	8340,	8779,	9209,	9630,	10042,	10443,	10835,	11215,	11585,	11943,	12289,	12624,	12946,	13255,	13550,	13833,	14102,	14357,	14598,	14824,	15036,	15233,	15415,	15582,	15733,	15869,	15989,	16093,	16182,	16254,	16311,	16351,	16375,	16384,	16375,	16351,	16311,	16254,	16182,	16093,	15989,	15869,	15733,	15582,	15415,	15233,	15036,	14824,	14598,	14357,	14102,	13833,	13550,	13255,	12946,	12624,	12289,	11943,	11585,	11215,	10835,	10443,	10042,	9630,	9209,	8779,	8340,	7893,	7438,	6976,	6507,	6031,	5550,	5063,	4571,	4074,	3574,	3070,	2563,	2053,	1542,	1029,	515,	0,	-515,	-1029,	-1542,	-2053,	-2563,	-3070,	-3574,	-4074,	-4571,	-5063,	-5550,	-6031,	-6507,	-6976,	-7438,	-7893,	-8340,	-8779,	-9209,	-9630,	-10042,	-10443,	-10835,	-11215,	-11585,	-11943,	-12289,	-12624,	-12946,	-13255,	-13550,	-13833,	-14102,	-14357,	-14598,	-14824,	-15036,	-15233,	-15415,	-15582,	-15733,	-15869,	-15989,	-16093,	-16182,	-16254,	-16311,	-16351,	-16375,	-16384,	-16375,	-16351,	-16311,	-16254,	-16182,	-16093,	-15989,	-15869,	-15733,	-15582,	-15415,	-15233,	-15036,	-14824,	-14598,	-14357,	-14102,	-13833,	-13550,	-13255,	-12946,	-12624,	-12289,	-11943,	-11585,	-11215,	-10835,	-10443,	-10042,	-9630,	-9209,	-8779,	-8340,	-7893,	-7438,	-6976,	-6507,	-6031,	-5550,	-5063,	-4571,	-4074,	-3574,	-3070,	-2563,	-2053,	-1542,	-1029,	-515};

unsigned int SineTable_count = 0;

/************************************** FUNCTIONS ***************************************/
void Sine_PWM_Modulation(PWM_COMPLEMENTARY_VALUES *comp);
void CalculateDutyCycle_Complementary_CenterAligned_FineRes0( Frac16 modulo, Frac16 dutyCycle_Frac);
void CalculateDutyCycle_Complementary_CenterAligned_FineRes1( Frac16 modulo, Frac16 dutyCycle_Frac);

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
  /* Write your local variable definition here */

  /*** Processor Expert internal initialisation. DON'T REMOVE THIS CODE!!! ***/
	PE_low_level_init();
  /*** End of Processor Expert internal initialisation.                    ***/

  /* Write your code here */

  for(;;) 
  {
	  FMSTR_Poll();	
  }
}

#pragma interrupt saveall
void PWMA_SM0_Reload_ISR(void)
{
	setReg16Bits(PWMA_SM0STS, PWMA_SM0STS_RF_MASK);/* Clear interrupt request flag */
	
	if(bEnable_Modulation)
		{
			Sine_PWM_Modulation(&PwmSub01);
		}
			
	if(bEnable_Calculation)
		{
			CalculateDutyCycle_Complementary_CenterAligned_FineRes0((Frac16)(PWMA_SM0VAL1+1), PwmSub01.f16PwmSub_0_DutyCycleF16);
				
			f16Duty_freemaster1 = PwmSub01.f16PwmSub_0_DutyCycleF16;

			CalculateDutyCycle_Complementary_CenterAligned_FineRes1((Frac16)(PWMA_SM1VAL1+1), PwmSub01.f16PwmSub_1_DutyCycleF16);
			
			f16Duty_freemaster2 = PwmSub01.f16PwmSub_1_DutyCycleF16;
				
			f16H_bridge_output = f16Duty_freemaster1- f16Duty_freemaster2;
			
			/* Set LDOK LDOK0 for SM0/1 update */
			setReg16Bits(PWMA_MCTRL,PWMA_MCTRL_LDOK0_MASK);
			setReg16Bits(PWMA_MCTRL,PWMA_MCTRL_LDOK1_MASK);

			FMSTR_Recorder();
		}
}

void Sine_PWM_Modulation(PWM_COMPLEMENTARY_VALUES *comp)
{
	Word16 tempW16;
	
	tempW16 = (Frac16)16383 + (Frac16)mult((Frac16)29500,(Sine_increment[SineTable_count])); 
	//Here maximum duty cycle = 0.95 = 0.5 + 0.9/2 , change 29500 to change the limit
	
	if (tempW16 >= 0)
        comp->f16PwmSub_0_DutyCycleF16 = (Frac16)tempW16;
    else
    	comp->f16PwmSub_0_DutyCycleF16 = 0;
	
    tempW16 = (Frac16)16383 - (Frac16)mult((Frac16)29500,(Sine_increment[SineTable_count]));
    if (tempW16 >= 0)
    	comp->f16PwmSub_1_DutyCycleF16 = (Frac16)tempW16;
    else
    	comp->f16PwmSub_1_DutyCycleF16 = 0;
    
    SineTable_count ++;
    if(SineTable_count>=200)
    {
    	SineTable_count = 0;
    }
}

void CalculateDutyCycle_Complementary_CenterAligned_FineRes0( Frac16 modulo, Frac16 dutyCycle_Frac)
{
	Word32 DutyCycle32;
	
	DutyCycle32 = L_mult(modulo, dutyCycle_Frac);
	/* Difference between VAL2 and VAL3 edges has to be at leat 3 clock cycles
	 * or Fractional Delay Logic disabled - PWMA_SM0FRCTRL_FRAC23_EN = 0 */
	//DutyCycle32 = DutyCycle32 - 100;
	
	    if(DutyCycle32<(2*0x10000))
	    {		
		     /* disable fractional delay logic */
		    clrReg16Bits(PWMA_SM0FRCTRL, PWMA_SM0FRCTRL_FRAC23_EN_MASK);
	    }
	    else
	    {
		/* enable fractional delay logic */
		    setReg16Bits(PWMA_SM0FRCTRL, PWMA_SM0FRCTRL_FRAC23_EN_MASK);	/**/
	    }
	
	    setReg16(PWMA_SM0VAL3, extract_h(DutyCycle32));
	    setReg16(PWMA_SM0FRACVAL3, extract_l(DutyCycle32));
	    DutyCycle32 = -DutyCycle32;
	    setReg16(PWMA_SM0VAL2, extract_h(DutyCycle32));
	    setReg16(PWMA_SM0FRACVAL2, extract_l(DutyCycle32));
}

void CalculateDutyCycle_Complementary_CenterAligned_FineRes1( Frac16 modulo, Frac16 dutyCycle_Frac)
{
	Word32 DutyCycle32;
	
	DutyCycle32 = L_mult(modulo, dutyCycle_Frac);
	/* Difference between VAL2 and VAL3 edges has to be at leat 3 clock cycles
	 * or Fractional Delay Logic disabled - PWMA_SM0FRCTRL_FRAC23_EN = 0 */
	//DutyCycle32 = DutyCycle32 - 100;
	
	    if(DutyCycle32<(2*0x10000))
	    {		
		     /* disable fractional delay logic */
		    clrReg16Bits(PWMA_SM1FRCTRL, PWMA_SM1FRCTRL_FRAC23_EN_MASK);
	    }
	    else
	    {
		/* enable fractional delay logic */
		    setReg16Bits(PWMA_SM1FRCTRL, PWMA_SM1FRCTRL_FRAC23_EN_MASK);	/**/
	    }
	
	    setReg16(PWMA_SM1VAL3, extract_h(DutyCycle32));
	    setReg16(PWMA_SM1FRACVAL3, extract_l(DutyCycle32));
	    DutyCycle32 = -DutyCycle32;
	    setReg16(PWMA_SM1VAL2, extract_h(DutyCycle32));
	    setReg16(PWMA_SM1FRACVAL2, extract_l(DutyCycle32));
}

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
