/* ###################################################################
**     Filename    : main.c
**     Project     : MC56F84000_PWM_ADC_3trigger_single_channel
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-04-28, 15:04, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "PWMA.h"
#include "ADC12.h"
#include "IO1.h"
#include "FMSTR1.h"
#include "QSCI1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/*********************** variable structure define ***********************/
typedef struct
{
    Word16 w16Adc_result0_1;
    Word16 w16Adc_result0_2;
    Word16 w16Adc_result0_3;
} ADC_RESULT;

/*************************************** Global variable DEFINITIONS ******************************************/
ADC_RESULT		 UdtADCresults;

int Result_count=0;

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */

  for(;;) 
  {
	  FMSTR_Poll();
  }
}

#pragma interrupt saveall
void PWMA_SM0_Reload_ISR(void)//For test only
{
	setReg16Bits(PWMA_SM0STS,PWMA_SM0STS_RF_MASK);	/* Clear interrupt request flag */
	
	setReg16Bits(GPIOB_DR, GPIOB_DR_D8_MASK);//Signal indicate the interrupt
	FMSTR_Recorder();
	
	clrReg16Bits(GPIOB_DR, GPIOB_DR_D8_MASK);//Signal indicate the interrupt 
		
	FMSTR_Recorder();
}

#pragma interrupt saveall
void EOS0_ISR(void)
{
	setReg16Bits(ADC12_STAT,0x800);	/* Clear interrupt request flag */
		
	setReg16Bits(GPIOB_DR, GPIOB_DR_D3_MASK);//Signal indicate the interrupt 
	FMSTR_Recorder();
	
	/* read ADC samples from channels 0&8  */
	switch(Result_count){
		
		case 0 :
			UdtADCresults.w16Adc_result0_1= ADC12_RSLT0;
			break;
		case 1:
			UdtADCresults.w16Adc_result0_2= ADC12_RSLT0;
			break;
		case 2:
			UdtADCresults.w16Adc_result0_3= ADC12_RSLT0;
			break;
		
		}
	Result_count++;
	if(Result_count>=3)
	{
		Result_count = 0;
	}
		
	clrReg16Bits(GPIOB_DR, GPIOB_DR_D3_MASK);//Signal indicate the interrupt
		
	FMSTR_Recorder();
}

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
