/* ###################################################################
**     Filename    : main.c
**     Project     : MC56F84000_PWM_ADC
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-04-27, 11:17, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "ADC12.h"
#include "PWMA.h"
#include "IO1.h"
#include "FMSTR1.h"
#include "QSCI1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "intrinsics_56800E.h"

/*********************** variable structure define ***********************/
typedef struct
{
    Word16 w16Adc_result0;
    Word16 w16Adc_result8;
} ADC_RESULT;

typedef struct
{
	Frac16  f16PwmSub_0_DutyCycleF16;//just pwmA SM0 is enabled
} PWM_COMPLEMENTARY_VALUES;

/*************************************** Global variable DEFINITIONS ******************************************/
ADC_RESULT		 UdtADCresults;
PWM_COMPLEMENTARY_VALUES PwmSub0={(Frac16)0};

bool   bEnable_Modulation = TRUE;
bool   bEnable_Calculation = TRUE;

Word16 w16PwmModulationIncrement = 0x000A;
Frac16 f16Duty_freemaster;

/********************************************* FUNCTIONS DEFINITIONS *************************************************/
void CalculateDutyCycle_Push_Pull_CenterAligned_FineRes(Word16 modulo, Frac16 dutyCycle_Frac);
void Linear_PWM_Modulation(PWM_COMPLEMENTARY_VALUES *comp, Word16 PwmModulationIncrement);

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */

  for(;;) 
  {
	  FMSTR_Poll();
  }
}

#pragma interrupt saveall
void EOS_ISR(void)
{
	setReg16Bits(ADC12_STAT,0x800);	/* Clear interrupt request flag */
	
	setReg16Bits(GPIOB_DR, GPIOB_DR_D3_MASK);//Signal indicate the interrupt,for test
	FMSTR_Recorder();
		
	/* read ADC samples from channels 0&8  */
	UdtADCresults.w16Adc_result0 = ADC12_RSLT0;
	UdtADCresults.w16Adc_result8 = ADC12_RSLT8;
	
	clrReg16Bits(GPIOB_DR, GPIOB_DR_D3_MASK);//Signal indicate the interrupt,for test
	
	FMSTR_Recorder();
}

#pragma interrupt saveall
void PWMA0_Reload_ISR(void)
{
	setReg16Bits(PWMA_SM0STS,PWMA_SM0STS_RF_MASK);	/* Clear interrupt request flag */
	
	setReg16Bits(GPIOB_DR, GPIOB_DR_D8_MASK);//Signal indicate the interrupt,for test
	FMSTR_Recorder();
	if(bEnable_Modulation)
		{
			Linear_PWM_Modulation(&PwmSub0, w16PwmModulationIncrement);
		}
	if(bEnable_Calculation)
		{
			CalculateDutyCycle_Push_Pull_CenterAligned_FineRes((Word16)(PWMA_SM0VAL1+1), PwmSub0.f16PwmSub_0_DutyCycleF16);
		}
	/* Set LDOK LDOK0 for SM0 update */
	setReg16Bits(PWMA_MCTRL,PWMA_MCTRL_LDOK0_MASK);
	
	clrReg16Bits(GPIOB_DR, GPIOB_DR_D8_MASK);//Signal indicate the interrupt,for test 
	
	FMSTR_Recorder();
}

void Linear_PWM_Modulation(PWM_COMPLEMENTARY_VALUES *comp,Word16 PwmModulationIncrement)
{
	Word16 tempW16;
	tempW16 = comp->f16PwmSub_0_DutyCycleF16 + PwmModulationIncrement;
	
	//ensure duty cycle between 0 and 1
	if (tempW16 >= 0)
	    comp->f16PwmSub_0_DutyCycleF16 = tempW16;
	else
	    comp->f16PwmSub_0_DutyCycleF16 = 0;
}

void CalculateDutyCycle_Push_Pull_CenterAligned_FineRes( Word16 modulo, Frac16 dutyCycle_Frac)
{
	Word32 DutyCycle32;
	f16Duty_freemaster = dutyCycle_Frac;
	DutyCycle32 = L_mult(modulo, dutyCycle_Frac);
	
	/* Difference between VAL2 and VAL3 edges has to be at least 3 clock cycles
	 * or Fractional Delay Logic disabled - PWMA_SM0FRCTRL_FRAC23_EN = 0 */
	if(DutyCycle32<(2*0x10000))
	{		
		/* disable fractional delay logic */
		clrReg16Bits(PWMA_SM0FRCTRL, PWMA_SM0FRCTRL_FRAC23_EN_MASK); 
	}
	else
	{
		/* enable fractional delay logic */
		setReg16Bits(PWMA_SM0FRCTRL, PWMA_SM0FRCTRL_FRAC23_EN_MASK);
	}
	setReg16(PWMA_SM0VAL3, extract_h(DutyCycle32));
	setReg16(PWMA_SM0FRACVAL3, extract_l(DutyCycle32));
	
	DutyCycle32 = -DutyCycle32;
	setReg16(PWMA_SM0VAL2, extract_h(DutyCycle32));
	setReg16(PWMA_SM0FRACVAL2, extract_l(DutyCycle32));
}


/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
