/* ###################################################################
**     Filename    : main.c
**     Project     : MC56F84000_FreeMASTER
**     Processor   : MC56F84789VLL
**     Version     : Driver 01.16
**     Compiler    : CodeWarrior DSP C Compiler
**     Date/Time   : 2015-05-11, 11:50, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/*!
** @file main.c
** @version 01.16
** @brief
**         Main module.
**         This module contains user's application code.
*/         
/*!
**  @addtogroup main_module main module documentation
**  @{
*/         
/* MODULE main */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "FMSTR1.h"
#include "QSCI1.h"
#include "IO1.h"
#include "TMRA0.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/*************************************** Global variable DEFINITIONS ******************************************/
bool   bEnable_Calculation = TRUE;

Word16 w16Base = 0x0, w16ModulationIncrement = 0x000A;

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */

  for(;;) 
  {
	  FMSTR1_Poll();
  }
}

#pragma interrupt saveall
void TMRA0_Comp1_ISR(void)
{
	clrReg16Bits(TMRA_0_CSCTRL,TMRA_0_CSCTRL_TCF1_MASK);	/* Clear interrupt request flag */
		
	setReg16Bits(GPIOB_DR, GPIOB_DR_D8_MASK);//Signal indicate the interrupt,for test
	FMSTR_Recorder();
	
	if(bEnable_Calculation)
	{
		w16Base += w16ModulationIncrement;
	}
	
	clrReg16Bits(GPIOB_DR, GPIOB_DR_D8_MASK);//Signal indicate the interrupt,for test 
		
	FMSTR_Recorder();
	
}
#pragma interrupt off

/* END main */
/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.3 [05.09]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
