/*
 * MC06XSD200.h
 * Register map for the 06XS200
 * 
 */

#ifndef MC06XSD200_H_
#define MC06XSD200_H_


/* Serial input register addresses */

/* STATR_s input address */
#define XS_SI_STATR_0   0x00U
#define XS_SI_STATR_1   0x08U

#define SOA0_MASK 0x01U
#define SOA1_MASK 0x02U
#define SOA2_MASK 0x04U

#define SOA0_SHIFT 0x00U
#define SOA1_SHIFT 0x01U
#define SOA2_SHIFT 0x02U

/* PWMR_s input address */
#define XS_SI_PWMR_0    0x01U
#define XS_SI_PWMR_1    0x09U

#define PWM0_s_MASK 0x01U
#define PWM1_s_MASK 0x02U
#define PWM2_s_MASK 0x04U
#define PWM3_s_MASK 0x08U
#define PWM4_s_MASK 0x10U
#define PWM5_s_MASK 0x20U
#define PWM6_s_MASK 0x40U
#define PWM7_s_MASK 0x80U
#define ON_s_MASK 0x100U

#define PWM0_s_SHIFT 0x00U
#define PWM1_s_SHIFT 0x01U
#define PWM2_s_SHIFT 0x02U
#define PWM3_s_SHIFT 0x03U
#define PWM4_s_SHIFT 0x04U
#define PWM5_s_SHIFT 0x05U
#define PWM6_s_SHIFT 0x06U
#define PWM7_s_SHIFT 0x07U
#define ON_s_SHIFT 0x08U


/* CONFR_s input address */
#define XS_SI_CONFR_0   0x02U
#define XS_SI_CONFR_1   0x0AU

#define DELAY0_s_MASK 0x01U
#define DELAY1_s_MASK 0x02U
#define DELAY2_s_MASK 0x04U
#define SR0_s_MASK 0x08U
#define SR1_s_MASK 0x10U
#define DIR_dis_s_MASK 0x20U
#define OLOFF_dis_s_MASK 0x40U
#define OLON_dis_s_MASK 0x80U
#define OS_dis_s_MASK  0x100U

#define DELAY0_s_SHIFT 0x00U
#define DELAY1_s_SHIFT 0x01U
#define DELAY2_s_SHIFT 0x02U
#define SR0_s_SHIFT 0x03U
#define SR1_s_SHIFT 0x04U
#define DIR_dis_s_SHIFT 0x05U
#define OLOFF_dis_s_SHIFT 0x06U
#define OLON_dis_s_SHIFT 0x07U
#define OS_dis_s_SHIFT  0x08U

/* OCR_s input address */
#define XS_SI_OCR_0     0x04U
#define XS_SI_OCR_1     0x0CU

#define OCL_s_MASK 0x01U
#define OCM_s_MASK 0x02U
#define OCH_s_MASK 0x04U
#define tOCM_s_MASK 0x08U
#define tOCH_s_MASK 0x10U
#define CSNS_ratio_s_MASK 0x20U
#define Clock_int_s_MASK 0x40U
#define PR_s_MASK 0x80U
#define HOCR_s_MASK 0x100U

#define OCL_s_SHIFT 0x00U
#define OCM_s_SHIFT 0x01U
#define OCH_s_SHIFT 0x02U
#define tOCM_s_SHIFT 0x03U
#define tOCH_s_SHIFT 0x04U
#define CSNS_ratio_s_SHIFT 0x05U
#define Clock_int_s_SHIFT 0x06U
#define PR_s_SHIFT 0x07U
#define HOCR_s_SHIFT 0x08U

/* RETRY_s input address */
#define XS_SI_RETRY_0   0x05U
#define XS_SI_RETRY_1   0x0DU

#define retry_s_MASK 0x01U
#define Retry_unlimited_s_MASK 0x02U
#define Auto_period_0_s_MASK 0x04U
#define Auto_period_1_s_MASK 0x08U
#define OFP_s_MASK 0x100U

#define retry_s_SHIFT 0x00U
#define Retry_unlimited_s_SHIFT 0x01U
#define Auto_period_0_s_SHIFT 0x02U
#define Auto_period_1_s_SHIFT 0x03U
#define OFP_s_SHIFT 0x08U

/* GCR_s input address */
#define XS_SI_GCR     0x06U 

#define OV_dis_MASK 0x01U
#define CSNS0_en_MASK 0x02U
#define CSNS1_en_MASK 0x04U
#define VDD_FAIL_en_MASK 0x08U
#define WD_dis_MASK 0x10U
#define T_H_en_MASK 0x20U
#define PARALLEL_MASK 0x40U
#define PWM_en_0_MASK 0x80U
#define PWM_en_1_MASK 0x100U

#define OV_dis_SHIFT 0x00U
#define CSNS0_en_SHIFT 0x01U
#define CSNS1_en_SHIFT 0x02U
#define VDD_FAIL_en_SHIFT 0x03U
#define WD_dis_SHIFT 0x04U
#define T_H_en_SHIFT 0x05U
#define PARALLEL_SHIFT 0x06U
#define PWM_en_0_SHIFT 0x07U
#define PWM_en_1_SHIFT 0x08U

/* CALR_s input address */
#define XS_SI_CALR_0    0x07U
#define XS_SI_CALR_1    0x0FU
#define CALR_MASK       0x15BU

/* Serial output register addresses */

/* STATR output address */
#define XS_SO_STATR     0x00U

#define SO_OUT0_MASK 0x01U
#define SO_OUT1_MASK 0x02U
#define SO_FAULT0_MASK 0x04U
#define SO_FAULT1_MASK 0x08U
#define SO_R_FULL0_MASK 0x10U
#define SO_R_FULL1_MASK 0x20U
#define SO_POR_MASK 0x40U
#define SO_UV_MASK  0x80U
#define SO_OV_MASK  0x100U

#define SO_OUT0_SHIFT 0x00U
#define SO_OUT1_SHIFT 0x01U
#define SO_FAULT0_SHIFT 0x02U
#define SO_FAULT1_SHIFT 0x03U
#define SO_R_FULL0_SHIFT 0x04U
#define SO_R_FULL1_SHIFT 0x05U
#define SO_POR_SHIFT     0x06U
#define SO_UV_SHIFT      0x07U
#define SO_OV_SHIFT      0x08U

/* FAULTR_r output address */
#define XS_SO_FAULTR_0  0x01U
#define XS_SO_FAULTR_1  0x09U

#define SO_OC_s_MASK  0x01U
#define SO_SC_s_MASK  0x02U
#define SO_OT_s_MASK  0x04U
#define SO_OS_s_MASK  0x08U
#define SO_OLOFF_MASK 0x10U
#define SO_OLON_MASK 0x20U
#define SO_OTW_MASK 0x100U

#define SO_OC_s_SHIFT 0x01U
#define SO_SC_s_SHIFT 0x02U
#define SO_OT_s_SHIFT 0x03U
#define SO_OS_s_SHIFT 0x04U
#define SO_OLOFF_SHIFT 0x05U
#define SO_OLON_SHIFT 0x06U
#define SO_OTW_SHIFT 0x08U

/* PWMR_s output address */
#define XS_SO_PWMR_0    0x02U
#define XS_SO_PWMR_1    0x0AU

#define SO_PWM_s_MASK 0xFFU
#define SO_ON_s_MASK  0x100U

#define SO_PWM_s_SHIFT 0x00U
#define SO_ON_s_SHIFT  0x08U

/* CONFR_s output address */
#define XS_SO_CONFR_0   0x03U
#define XS_SO_CONFR_1   0x0BU

#define SO_DELAY_s_MASK      0x07U
#define SO_SR_s_MASK         0x18U
#define SO_DIR_dis_s_MASK    0x20U
#define SO_OLOFF_dis_s_MASK  0x40U
#define SO_OLON_dis_s_MASK   0x80U
#define SO_OS_dis_s_MASK     0x100U

#define SO_DELAY_s_SHIFT        0x00U
#define SO_SR_s_SHIFT           0x03U
#define SO_DIR_dis_s_SHIFT      0x05U 
#define SO_OLOFF_dis_s_SHIFT    0x06U
#define SO_OLON_dis_s_SHIFT     0x07U
#define SO_OS_dis_s_SHIFT       0x08U

/* OCR_s output address */
#define XS_SO_OCR_0     0x04U
#define XS_SO_OCR_1     0x0CU

#define SO_OCL_s_MASK        0x01U
#define SO_OCM_s_MASK        0x02U
#define SO_OCH_s_MASK        0x04U
#define SO_tCOM_s_MASK       0x08U
#define SO_tOCH_s_MASK       0x10U
#define SO_CSNS_ratio_s_MASK 0x20U
#define SO_Clock_int_s_MASK  0x40U
#define SO_PR_s_MASK         0x80U
#define SO_HOCR_s_MASK       0x100U

#define SO_OCL_s_SHIFT       0x00U
#define SO_OCM_s_SHIFT       0x01U
#define SO_OCH_s_SHIFT       0x02U
#define SO_tCOM_s_SHIFT      0x03U
#define SO_tCOH_s_SHIFT      0x04U
#define SO_CSNS_ratio_s_SHIFT 0x05U
#define SO_Clock_int_s_SHIFT 0x06U
#define SO_PR_s_SHIFT        0x07U
#define SO_HOCR_s_SHIFT      0x08U

/* RETRYR_S output address */
#define XS_SO_RETRYR_0  0x05U
#define XS_SO_RETRYR_1  0x0DU

#define SO_retry_s_MASK           0x01U
#define SO_Retry_unlimited_s_MASK 0x02U
#define SO_Auto_period_s_MASK     0x0CU
#define SO_R_MASK                 0xF0U
#define SO_OFP_MASK               0x100U

#define SO_retry_s_SHIFT          0x00U
#define SO_Retry_unlimited_s_SHIFT 0x01U
#define SO_Auto_period_s_SHIFT    0x02U
#define SO_R_SHIFT                0x04U
#define SO_OFP_SHIFT              0x08U
 
/* GCR output address */
#define XS_SO_GCR      0x06U

#define SO_OV_dis_MASK    0x01U
#define SO_CSNS_en_MASK   0x06U
#define SO_VDD_Fail_en_MASK  0x08U
#define SO_WD_dis_MASK    0x10U
#define SO_T_H_en_MASK    0x20U
#define SO_PARALLEL_MASK  0x40U
#define SO_PWM_en_0_MASK    0x80U
#define SO_PWM_en_1_MASK    0x100U

#define SO_OV_dis_SHIFT   0x00U
#define SO_CSNS_en_SHIFT  0x01U
#define SO_VDD_Fail_en_SHIFT 0x03U
#define SO_WD_dis_SHIFT   0x04U
#define SO_T_H_en_SHIFT   0x05U
#define SO_PARALLEL_SHIFT 0x06U
#define SO_PWM_en_0_SHIFT   0x07U
#define SO_PWM_en_1_SHIFT   0x08U

/* DIAGR output address */
#define XS_SO_DIAGR    0x07U

#define SO_CAL_fail0_MASK 0x01U
#define SO_CAL_fail1_MASK 0x02U
#define SO_CLOCK_fail_MASK 0x04U
#define SO_IN0_MASK       0x08U
#define SO_IN1_MASK       0x10U
#define SO_ID0_MASK       0x20U
#define SO_ID1_MASK       0x40U
#define SO_CONF0_MASK     0x80U
#define SO_CONF1_MASK     0x100U

#define SO_CAL_fail0_SHIFT 0x00U
#define SO_CAL_fail1_SHIFT 0x01U
#define SO_CLOCK_fail_SHIFT 0x02U
#define SO_IN0_SHIFT       0x03U
#define SO_IN1_SHIFT       0x04U
#define SO_ID0_SHIFT       0x05U
#define SO_ID1_SHIFT       0x06U
#define SO_CONF0_SHIFT     0x07U
#define SO_CONF1_SHIFT     0x08U

/* Feature definitions in CONFR_s register */
#define SWITCH_ON_DELAY_NO_DELAY 0x00U
#define SWITCH_ON_DELAY_32_PWM_CLOCKS 0x01U
#define SWITCH_ON_DELAY_64_PWM_CLOCKS 0x02U
#define SWITCH_ON_DELAY_96_PWM_CLOCKS 0x03U
#define SWITCH_ON_DELAY_128_PWM_CLOCKS 0x04U
#define SWITCH_ON_DELAY_160_PWM_CLOCKS 0x05U
#define SWITCH_ON_DELAY_192_PWM_CLOCKS 0x06U
#define SWITCH_ON_DELAY_224_PWM_CLOCKS 0x07U

#define SLEW_RATE_LOW (0x01 << SR0_s_SHIFT)
#define SLEW_RATE_MEDIUM (0x00 << SR0_s_SHIFT)
#define SLEW_RATE_HIGH (0x03 << SR0_s_SHIFT)
#define SLEW_RATE_HIGH_MAX (0x02 << SR0_s_SHIFT)

#define DIRECT_CONTROL_ENABLE (0x00 << DIR_dis_s_SHIFT)
#define DIRECT_CONTROL_DISABLE (0x01 << DIR_dis_s_SHIFT)

#define OPEN_LOAD_DETECTION_OFF_ENABLE (0x00 << OLOFF_dis_s_SHIFT)
#define OPEN_LOAD_DETECTION_OFF_DISABLE (0x01 << OLOFF_dis_s_SHIFT)

#define OPEN_LOAD_DETECTION_ON_ENABLE (0x00 << OLON_dis_s_SHIFT)
#define OPEN_LOAD_DETECTION_ON_DISABLE (0x01 << OLON_dis_s_SHIFT)

#define SHORT_CIRCUIT_DETECTION_ENABLE (0x00 << OS_dis_s_SHIFT)
#define SHORT_CIRCUIT_DETECTION_DISABLE (0x01 << OS_dis_s_SHIFT)

/* Feature definitions in OCR_s register */
#define LOW_CURRENT_THRESHOLD_SELECT_IOCL1 ((0x00 << HOCR_s_SHIFT) | (0x01 << OCL_s_SHIFT))
#define LOW_CURRENT_THRESHOLD_SELECT_IOCL2 ((0x01 << HOCR_s_SHIFT) | (0x00 << OCL_s_SHIFT))
#define LOW_CURRENT_THRESHOLD_SELECT_IOCL3 ((0x01 << HOCR_s_SHIFT) | (0x01 << OCL_s_SHIFT))

#define MEDIUM_CURRENT_THRESHOLD_SELECT_IOCM1 (0x00 << OCM_s_SHIFT)
#define MEDIUM_CURRENT_THRESHOLD_SELECT_IOCM2 (0x01 << OCM_s_SHIFT)

#define HIGH_CURRENT_THRESHOLD_SELECT_IOCH1 (0x00 << OCH_s_SHIFT)
#define HICG_CURRENT_THRESHOLD_SELECT_IOCH2 (0x01 << OCH_s_SHIFT)
//bulb
#define THRESHOLD_ACTIVATION_TIMES_tOCH1_tOCM1_L ((0x00 << tOCH_s_SHIFT) | (0x00 << tOCM_s_SHIFT))
#define THRESHOLD_ACTIVATION_TIMES_tOCH1_tOCM2_L ((0x00 << tOCH_s_SHIFT) | (0x01 << tOCM_s_SHIFT))
#define THRESHOLD_ACTIVATION_TIMES_tOCH2_tOCM1_L ((0x01 << tOCH_s_SHIFT) | (0x00 << tOCM_s_SHIFT)) 
#define THRESHOLD_ACTIVATION_TIMES_tOCH2_tOCM2_L ((0x01 << tOCH_s_SHIFT) | (0x01 << tOCM_s_SHIFT))
//dc motor
#define THRESHOLD_ACTIVATION_TIMES_tOCM1_M ((0x00 << tOCH_s_SHIFT) | (0x00 << tOCM_s_SHIFT))
#define THRESHOLD_ACTIVATION_TIMES_tOCM2_M ((0x00 << tOCH_s_SHIFT) | (0x01 << tOCM_s_SHIFT))
#define THRESHOLD_ACTIVATION_TIMES_tOCH1 ((0x01 << tOCH_s_SHIFT) | (0x00 << tOCM_s_SHIFT)) 
#define THRESHOLD_ACTIVATION_TIMES_tOCH2 ((0x01 << tOCH_s_SHIFT) | (0x01 << tOCM_s_SHIFT))

#define CURRENT_SENSE_RATIO_LOW (0x01 << CSNS_ratio_s_SHIFT)
#define CURRENT_SENSE_RATIO_HIGH (0x00 << CSNS_ratio_s_SHIFT)

#define PWM_CLOCK_SOURCE_INTERNAL (0x01 << Clock_int_s_SHIFT)
#define PWM_CLOCK_SOURCE_EXTERNAL (0x00 << Clock_int_s_SHIFT)

#define PWM_EXTERNAL_CLOCK_DIVIDER_256 (0x00 << PR_s_SHIFT)
#define PWM_EXTERNAL_CLOCK_DIVIDER_512 (0x01 << PR_s_SHIFT)

/* Feature definitions in RETRY_s register */
#define AUTO_RETRY_PERIOD_tAUTO_00 ((0x00 << Auto_period_1_s_SHIFT) | (0x00 << Auto_period_0_s_SHIFT))
#define AUTO_RETRY_PERIOD_tAUTO_01 ((0x00 << Auto_period_1_s_SHIFT) | (0x01 << Auto_period_0_s_SHIFT))
#define AUTO_RETRY_PERIOD_tAUTO_10 ((0x01 << Auto_period_1_s_SHIFT) | (0x00 << Auto_period_0_s_SHIFT))
#define AUTO_RETRY_PERIOD_tAUTO_11 ((0x01 << Auto_period_1_s_SHIFT) | (0x01 << Auto_period_0_s_SHIFT))

#define AUTO_RETRY_NUMBER_16 (0x00 << Retry_unlimited_s_SHIFT)
#define AUTO_RETRY_NUMBER_INFINITE (0x01 << Retry_unlimited_s_SHIFT)
//Overcurrent profile specific. Dependent on CONF[x] pin state. inverted logic of functionality. TODO
#define AUTO_RETRY_BULB_ENABLED (0x00 << retry_s_SHIFT)
#define AUTO_RETRY_BULB_DISABLED (0x01 << retry_s_SHIFT)
#define AUTO_RETRY_DC_MOTOR_ENABLED (0x01 << retry_s_SHIFT)
#define AUTO_RETRY_DC_MOTOR_DISABLED (0x00 << retry_s_SHIFT)

#define RANDOM_CURRENT_OFFSET_ADD (0x01 << OFP_s_SHIFT)
#define RANDOM_CURRENT_OFFSET_SUBTRACT (0x00 << OFP_s_SHIFT)

/* Feature definitions in GCR register */
#define OVERVOLTAGE_PROTECTION_ENABLE (0x00 << OV_dis_SHIFT)
#define OVERVOLTAGE_PROTECTION_DISABLE (0x01 << OV_dis_SHIFT)

#define CSNS_FUNCTION_DISABLED ((0x00 << CSNS1_en_SHIFT) | (0x00 << CSNS0_en_SHIFT))
#define CSNS_FUNCTION_CURRENT_CH0 ((0x00 << CSNS1_en_SHIFT) | (0x01 << CSNS0_en_SHIFT))
#define CSNS_FUNCTION_CURRENT_CH1 ((0x01 << CSNS1_en_SHIFT) | (0x00 << CSNS0_en_SHIFT))
#define CSNS_FUNCTION_TEMPERATURE ((0x01 << CSNS1_en_SHIFT) | (0x01 << CSNS0_en_SHIFT))
#define CSNS_FUNCTION_CURRENT_SUM ((0x00 << CSNS1_en_SHIFT) | (0x01 << CSNS0_en_SHIFT))

#define VDD_FAILURE_DETECTION_ENABLE (0x01 << VDD_FAIL_en_SHIFT)
#define VDD_FAILURE_DETECTION_DISABLE (0x00 << VDD_FAIL_en_SHIFT)

#define WATCHDOG_DISABLE (0x01 << WD_dis_SHIFT)
#define WATCHDOG_ENABLE (0x00 << WD_dis_SHIFT)

#define TRACK_AND_HOLD_CURRENT_ENABLE (0x01 << T_H_en_SHIFT)
#define TRACK_AND_HOLD_CURRENT_DISABLE (0x00 << T_H_en_SHIFT)

#define PARALLEL_MODE_ENABLE (0x01 << PARALLEL_SHIFT)
#define PARALLEL_MODE_DISABLE (0x00 << PARALLEL_SHIFT)

#define PWM_CHANNEL_0_ENABLE (0x01 << PWM_en_0_SHIFT)
#define PWM_CHANNEL_0_DISABLE (0x00 << PWM_en_0_SHIFT)

#define PWM_CHANNEL_1_ENABLE (0x01 << PWM_en_1_SHIFT)
#define PWM_CHANNEL_1_DISABLE (0x00 << PWM_en_1_SHIFT)

//options definition of Methods
#define ES_ERR_OK                  0U
#define ES_ERR_COMM                1U
#define ES_ERR_PARA                2U

#define ES_ALL_SO_DATA_BITS     0x3FFU
#define ES_NORMAL_MODE          0x200U
#define ES_ALL_DEVICES          0xFFFFU
//SetPWMState
#define ES_PWM_DISABLE_ALL		0U						//If PWM mode is disabled, direct input pins are applied
#define ES_PWM_ENABLE_CH0_ONLY	1U						//Set PWM of channel 0 to ON status 
#define ES_PWM_ENABLE_CH1_ONLY	2U						//Set PWM of channel 1 to ON status 
#define ES_PWM_ENABLE_ALL		3U						//Set PWM of channel 0,1 to ON status 
//Diagnosis
#define ES_DIAG_CH1_DC_MOTOR    SO_CONF1_MASK           //- load is configured as a DC motor type. If not present it's bulb type.
#define ES_DIAG_CH0_DC_MOTOR    SO_CONF0_MASK           //- load is configured as a DC motor type. If not present  it's bulb type.   
#define ES_DIAG_PRODUCT_ID_BIT1 SO_ID1_MASK             //- product identification higher bit
#define ES_DIAG_PRODUCT_ID_BIT0 SO_ID0_MASK             //- product identification lower bit
#define ES_DIAG_IN1_ON          SO_IN1_MASK             //- current logic state of the direct input IN1
#define ES_DIAG_IN0_ON          SO_IN0_MASK             //- current logic state of the direct input IN0
#define ES_DIAG_CLOCKFAIL       SO_CLOCK_fail_MASK      //- External clock error occurred
#define ES_DIAG_CH1_CALIBFAIL   SO_CAL_fail1_MASK       //- Calibration failure occurred during calibration of channel's internal clock period. 
#define ES_DIAG_CH0_CALIBFAIL   SO_CAL_fail0_MASK       //- Calibration failure occurred during calibration of channel's internal clock period. 
//ConfigureMonitoring
#define ES_SENSE_DISABLE        CSNS_FUNCTION_DISABLED          //sensing disabled
#define ES_CURRENTSENSE0        CSNS_FUNCTION_CURRENT_CH0       //current sensing for channel 0 (will not apply if highest overcurrent range is not selected and the device works in Parallel mode)
#define ES_CURRENTSENSE1        CSNS_FUNCTION_CURRENT_CH1       //current sensing for channel 1
#define ES_TEMPERATURESENSE     CSNS_FUNCTION_TEMPERATURE       //temperature sensing
#define ES_CURRENTSENSE_SUM     CSNS_FUNCTION_CURRENT_SUM       //current sensing for summed channels(this option will apply only if  highest overcurrent range is not selected and the device works in Parallel mode)
//GetStatus
#define ES_STATUS_OVERVOLTAGE   SO_OV_MASK                      //Overvoltage fault
#define ES_STATUS_UNDERVOLTAGE  SO_UV_MASK                      //undervoltage fault
#define ES_STATUS_POR           SO_POR_MASK                     //power-on reset (POR) has occurred
#define ES_STATUS_FAULT0        SO_FAULT0_MASK                  //faults are detected on Channel 0
#define ES_STATUS_FAULT1        SO_FAULT1_MASK                  //faults are detected on Channel 1
#define ES_STATUS_AUTORETRY0    SO_R_FULL0_MASK                 //auto-retry counter is full on Channel 0
#define ES_STATUS_AUTORETRY1    SO_R_FULL1_MASK                 //auto-retry counter is full on Channel 1
#define ES_STATUS_OUT0          SO_OUT0_MASK                    //indicate the status of Channel 0 is ON:1  OFF:0
#define ES_STATUS_OUT1          SO_OUT1_MASK                    //indicate the status of Channel 1 is ON:1  OFF:0
//GetFaultInfo
#define ES_ERR_OC               SO_OC_s_MASK                    //overcurrent fault on corresponding channel
#define ES_ERR_SC               SO_SC_s_MASK                    //severe short-circuit fault on corresponding channel
#define ES_ERR_OT               SO_OT_s_MASK                    //overtemperature fault on corresponding channel
#define ES_ERR_OS               SO_OS_s_MASK                    //output shorted to VPWR fault on corresponding channel
#define ES_ERR_OLOFF            SO_OLOFF_MASK                   //open load in OFF state fault on corresponding channel 
#define ES_ERR_OLON             SO_OLON_MASK                    //open load in ON state fault on corresponding channel
#define ES_ERR_OTW              SO_OTW_MASK                     //overtemperature
#endif /* MC06XSD200_H_ */
