/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : SPI_Device1.c
**     Project     : FRDM-24XSMBEVB_KL25z-Demo
**     Processor   : MKL25Z128VLK4
**     Component   : SPI_Device
**     Version     : Component 01.000, Driver 01.00, CPU db: 3.00.000
**     Repository  : My Components
**     Compiler    : GNU C Compiler
**     Date/Time   : 2017-02-28, 16:43, # CodeGen: 0
**     Abstract    :
**
**     Settings    :
**          Component name                                 : SPI_Device1
**          SPI master component                           : SM1
**          SPI attribute index                            : 0
**          Require SPI Attributes                         : Enabled
**            Width                                        : 8 bits
**            MSB first                                    : yes
**            Clock polarity                               : Low
**            Clock phase                                  : Change on leading edge
**            Parity                                       : None
**            Chip select toggling                         : no
**            Clock rate index                             : 0
**          Chip select handling                           : Single GPIO pin
**            Active CS level                              : Low
**            CSPin                                        : BitIO_LDD
**          Auto Initialization                            : yes
**     Contents    :
**         RequestBus         - byte SPI_Device1_RequestBus(void);
**         ReleaseBus         - byte SPI_Device1_ReleaseBus(void);
**         Select             - void SPI_Device1_Select(void);
**         Unselect           - void SPI_Device1_Unselect(void);
**         StartBlockTransfer - byte SPI_Device1_StartBlockTransfer(void* SendDataPtr, void* ReceiveDataPtr,...
**         TransferBlock      - byte SPI_Device1_TransferBlock(void* SendDataPtr, void* ReceiveDataPtr,...
**
**     (c) Copyright <company/user-name>, 2014
http://www.<company>.com
mail: info@<company>.com
** ###################################################################*/
/*!
** @file SPI_Device1.c
** @version 01.00
** @brief
**
*/         
/*!
**  @addtogroup SPI_Device1_module SPI_Device1 module documentation
**  @{
*/         

/* MODULE SPI_Device1. */

#include "SPI_Device1.h"
#include "SM1.h"
#include "SM1_Shared.h"

bool SPI_Device1_UnselectAfter;
/*
** ===================================================================
**     Method      :  SPI_Device1_Select (component SPI_Device)
**     @brief
**         Selects the device accoding to the Chip select handling property 
**         configuration. Please note that for hardware chip selects option, 
**          it's automatically handled by the hardware. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         void            - 
** ===================================================================
*/
void SPI_Device1_Select()
{
  CSpin1_ClrVal(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_CSpin1_ID));
}
/*
** ===================================================================
**     Method      :  SPI_Device1_Unselect (component SPI_Device)
**     @brief
**         Unselects the device accoding to the Chip select handling property 
**         configuration. Please note that for hardware chip selects option, 
**          it's automatically handled by the hardware. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         void            - 
** ===================================================================
*/
void SPI_Device1_Unselect()
{
  CSpin1_SetVal(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_CSpin1_ID));
}
/*
** ===================================================================
**     Method      :  SPI_Device1_RequestBus (component SPI_Device)
**     @brief
**         Gains an exclusive access to SPI bus for this device. Must be 
**         called before the transfer and select methods. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         uint8_t         - Error code 
** ===================================================================
*/
uint8_t SPI_Device1_RequestBus()
{
  if (SM1_RequestBus()) {
    /* assign callback */
    SM1_TransferCallback = SPI_Device1_AfterTransferEnded;
    return TRUE;
  } else {
    return FALSE;
  }
}
/*
** ===================================================================
**     Method      :  SPI_Device1_ReleaseBus (component SPI_Device)
**     @brief
**         Releases the to SPI bus to ba available to other devices. Must 
**         be called after the application ended communicating with the 
**         device. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @return
**         uint8_t         - Error code 
** ===================================================================
*/
uint8_t SPI_Device1_ReleaseBus()
{
  return SM1_ReleaseBus();
}
/*
** ===================================================================
**     Method      :  SPI_Device1_StartBlockTransfer (component SPI_Device)
**     @brief
**         Starts sending data to SPI and receiving them. This method does 
**         not wait for the end of the transfer and immediatelly returns. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         void* SendDataPtr - Pointer to the block of data to send. 
**         @param
**         void* ReceiveDataPtr - Pointer to the place where the received data 
**                           are to be stored. Please note that it cannot 
**                           be NULL even, if the received data have no 
**                           meaning. 
**         @param
**         uint32_t Length - Number of characters to send/receive 
**         @param
**         bool UnselectAfterTransfer - If the 'Unselect' operation should be performed 
**                           after the transfer. 
**         @return
**         uint8_t         - Returns error code provided by SPIMaster_LDD.\<br/\>ERR_OK 
**         : No problem detected\<br/\>ERR_BUSY : the SPI device is busy. 
**         For more details see the SPIMaster_LDD documentation. 
** ===================================================================
*/
uint8_t SPI_Device1_StartBlockTransfer(void* SendDataPtr, void* ReceiveDataPtr, uint32_t Length, bool UnselectAfterTransfer)
{
LDD_TError Error;
  SPI_Device1_UnselectAfter = UnselectAfterTransfer;
  Error = SM1_ReceiveBlock(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_SM1_ID), ReceiveDataPtr, Length);
  if (Error != ERR_OK) {
    return Error;
  }
  Error = SM1_SendBlock(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_SM1_ID), SendDataPtr, Length);
  return Error;
}
/*
** ===================================================================
**     Method      :  SPI_Device1_AfterTransferEnded (component SPI_Device)
**
**     Description :
**         The function to be set as inscance of the callback from SPI
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void SPI_Device1_AfterTransferEnded(void)
{
  if (SPI_Device1_UnselectAfter) {
    SPI_Device1_Unselect();
  }
}
/*
** ===================================================================
**     Method      :  SPI_Device1_TransferBlock (component SPI_Device)
**     @brief
**         Provides complete transfer of data to SPI - sends block of data 
**         and receives the data from the device. This method waits for 
**         the whole transfer to end. 
**     Parameters  :
**         NAME            - DESCRIPTION
**         @param
**         void* SendDataPtr - Block of data to send. 
**         @param
**         void* ReceiveDataPtr - Pointer to the place where the received data 
**                           are to be stored. Please note that it cannot 
**                           be NULL even, if the received data have no 
**                           meaning. 
**         @param
**         uint32_t Length - Number of characters to send/receive 
**         @param
**         bool UnselectAfterTransfer - If the 'Unselect' operation should be performed 
**                           after the transfer. 
**         @return
**         uint8_t         - Returns error code provided by SPIMaster_LDD. 
**         ERR_OK : No problem detected 
**         ERR_BUSY : the SPI device is busy. For more details see the SPIMaster_LDD 
**         documentation. 
** ===================================================================
*/
uint8_t SPI_Device1_TransferBlock(void* SendDataPtr, void* ReceiveDataPtr, uint32_t Length, bool UnselectAfterTransfer)
{
  LDD_TError Error;    
  SPI_Device1_UnselectAfter = UnselectAfterTransfer;    
  /* configure data reception */
  Error = SM1_ReceiveBlock(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_SM1_ID), ReceiveDataPtr, Length);
  if (Error != ERR_OK) {
    return Error;
  }
  /* start sending the data */
  Error = SM1_SendBlock(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_SM1_ID), SendDataPtr, Length);
  if (Error != ERR_OK) {
    return Error;
  }
  /* wait until it's finished */
  while (!SM1_GetBlockReceivedStatus(PE_LDD_GetDeviceStructure(PE_LDD_COMPONENT_SM1_ID))) {
  }
  return ERR_OK;    
}
/* END SPI_Device1. */

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
