; Based on CPU DB MC9S08QG8_16_QFN, version 2.87.095 (RegistersPrg V1.118)

; ###################################################################
;     Filename  : MC9S08QG8.inc
;     Processor : MC9S08QG8CFF
;     FileFormat: V1.118
;     DataSheet : MC9S08QG8 Rev. 0.09 09/9/2005
;     Compiler  : Metrowerks C compiler
;     Date/Time : 06.10.2005, 07:22
;     Abstract  :
;         This header implements the mapping of IO devices.
;
;     (c) Copyright UNIS, spol. s r.o. 1997-2003
;     UNIS, spol. s r.o.
;     Jundrovska 33
;     624 00 Brno
;     Czech Republic
;     http      : www.processorexpert.com
;     mail      : info@processorexpert.com
; ###################################################################

;*** Memory Map and Interrupt Vectors
;******************************************
ROMStart:           equ   $0000E000
ROMEnd:             equ   $0000FFAD
Z_RAMStart:         equ   $00000060
Z_RAMEnd:           equ   $000000FF
RAMStart:           equ   $00000100
RAMEnd:             equ   $0000025F
ROM1Start:          equ   $0000FFC0
ROM1End:            equ   $0000FFCF
;
Vrti:               equ   $0000FFD0
Reserved2:          equ   $0000FFD2
Reserved3:          equ   $0000FFD4
Vacmp:              equ   $0000FFD6
Vadc:               equ   $0000FFD8
Vkeyboard:          equ   $0000FFDA
Viic:               equ   $0000FFDC
Vscitx:             equ   $0000FFDE
Vscirx:             equ   $0000FFE0
Vscierr:            equ   $0000FFE2
Vspi:               equ   $0000FFE4
Vmtim:              equ   $0000FFE6
Reserved13:         equ   $0000FFE8
Reserved14:         equ   $0000FFEA
Reserved15:         equ   $0000FFEC
Reserved16:         equ   $0000FFEE
Vtpmovf:            equ   $0000FFF0
Vtpmch1:            equ   $0000FFF2
Vtpmch0:            equ   $0000FFF4
Reserved20:         equ   $0000FFF6
Vlvd:               equ   $0000FFF8
Virq:               equ   $0000FFFA
Vswi:               equ   $0000FFFC
Vreset:             equ   $0000FFFE
;


;*** PTAD - Port A Data Register; 0x00000000 ***
PTAD:               equ    $00000000                                ;*** PTAD - Port A Data Register; 0x00000000 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAD_PTAD0:         equ    0                                         ; Port A Data Register Bit 0
PTAD_PTAD1:         equ    1                                         ; Port A Data Register Bit 1
PTAD_PTAD2:         equ    2                                         ; Port A Data Register Bit 2
PTAD_PTAD3:         equ    3                                         ; Port A Data Register Bit 3
PTAD_PTAD4:         equ    4                                         ; Port A Data Register Bit 4
PTAD_PTAD5:         equ    5                                         ; Port A Data Register Bit 5
; bit position masks
mPTAD_PTAD0:        equ    %00000001
mPTAD_PTAD1:        equ    %00000010
mPTAD_PTAD2:        equ    %00000100
mPTAD_PTAD3:        equ    %00001000
mPTAD_PTAD4:        equ    %00010000
mPTAD_PTAD5:        equ    %00100000


;*** PTADD - Data Direction Register A; 0x00000001 ***
PTADD:              equ    $00000001                                ;*** PTADD - Data Direction Register A; 0x00000001 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADD_PTADD0:       equ    0                                         ; Data Direction for Port A Bit 0
PTADD_PTADD1:       equ    1                                         ; Data Direction for Port A Bit 1
PTADD_PTADD2:       equ    2                                         ; Data Direction for Port A Bit 2
PTADD_PTADD3:       equ    3                                         ; Data Direction for Port A Bit 3
PTADD_PTADD4:       equ    4                                         ; Data Direction for Port A Bit 4
PTADD_PTADD5:       equ    5                                         ; Data Direction for Port A Bit 5
; bit position masks
mPTADD_PTADD0:      equ    %00000001
mPTADD_PTADD1:      equ    %00000010
mPTADD_PTADD2:      equ    %00000100
mPTADD_PTADD3:      equ    %00001000
mPTADD_PTADD4:      equ    %00010000
mPTADD_PTADD5:      equ    %00100000


;*** PTBD - Port B Data Register; 0x00000002 ***
PTBD:               equ    $00000002                                ;*** PTBD - Port B Data Register; 0x00000002 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBD_PTBD0:         equ    0                                         ; Port B Data Register Bit 0
PTBD_PTBD1:         equ    1                                         ; Port B Data Register Bit 1
PTBD_PTBD2:         equ    2                                         ; Port B Data Register Bit 2
PTBD_PTBD3:         equ    3                                         ; Port B Data Register Bit 3
PTBD_PTBD4:         equ    4                                         ; Port B Data Register Bit 4
PTBD_PTBD5:         equ    5                                         ; Port B Data Register Bit 5
PTBD_PTBD6:         equ    6                                         ; Port B Data Register Bit 6
PTBD_PTBD7:         equ    7                                         ; Port B Data Register Bit 7
; bit position masks
mPTBD_PTBD0:        equ    %00000001
mPTBD_PTBD1:        equ    %00000010
mPTBD_PTBD2:        equ    %00000100
mPTBD_PTBD3:        equ    %00001000
mPTBD_PTBD4:        equ    %00010000
mPTBD_PTBD5:        equ    %00100000
mPTBD_PTBD6:        equ    %01000000
mPTBD_PTBD7:        equ    %10000000


;*** PTBDD - Data Direction Register B; 0x00000003 ***
PTBDD:              equ    $00000003                                ;*** PTBDD - Data Direction Register B; 0x00000003 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDD_PTBDD0:       equ    0                                         ; Data Direction for Port B Bit 0
PTBDD_PTBDD1:       equ    1                                         ; Data Direction for Port B Bit 1
PTBDD_PTBDD2:       equ    2                                         ; Data Direction for Port B Bit 2
PTBDD_PTBDD3:       equ    3                                         ; Data Direction for Port B Bit 3
PTBDD_PTBDD4:       equ    4                                         ; Data Direction for Port B Bit 4
PTBDD_PTBDD5:       equ    5                                         ; Data Direction for Port B Bit 5
PTBDD_PTBDD6:       equ    6                                         ; Data Direction for Port B Bit 6
PTBDD_PTBDD7:       equ    7                                         ; Data Direction for Port B Bit 7
; bit position masks
mPTBDD_PTBDD0:      equ    %00000001
mPTBDD_PTBDD1:      equ    %00000010
mPTBDD_PTBDD2:      equ    %00000100
mPTBDD_PTBDD3:      equ    %00001000
mPTBDD_PTBDD4:      equ    %00010000
mPTBDD_PTBDD5:      equ    %00100000
mPTBDD_PTBDD6:      equ    %01000000
mPTBDD_PTBDD7:      equ    %10000000


;*** KBISC - KBI Status and Control; 0x0000000C ***
KBISC:              equ    $0000000C                                ;*** KBISC - KBI Status and Control; 0x0000000C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBISC_KBIMOD:       equ    0                                         ; Keyboard Detection Mode
KBISC_KBIE:         equ    1                                         ; Keyboard Interrupt Enable
KBISC_KBACK:        equ    2                                         ; Keyboard Interrupt Acknowledge
KBISC_KBF:          equ    3                                         ; Keyboard Interrupt Flag
; bit position masks
mKBISC_KBIMOD:      equ    %00000001
mKBISC_KBIE:        equ    %00000010
mKBISC_KBACK:       equ    %00000100
mKBISC_KBF:         equ    %00001000


;*** KBIPE - KBI Pin Enable Register; 0x0000000D ***
KBIPE:              equ    $0000000D                                ;*** KBIPE - KBI Pin Enable Register; 0x0000000D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIPE_KBIPE0:       equ    0                                         ; Keyboard Pin Enable for Port A Bit 0
KBIPE_KBIPE1:       equ    1                                         ; Keyboard Pin Enable for Port A Bit 1
KBIPE_KBIPE2:       equ    2                                         ; Keyboard Pin Enable for Port A Bit 2
KBIPE_KBIPE3:       equ    3                                         ; Keyboard Pin Enable for Port A Bit 3
KBIPE_KBIPE4:       equ    4                                         ; Keyboard Pin Enable for Port A Bit 4
KBIPE_KBIPE5:       equ    5                                         ; Keyboard Pin Enable for Port A Bit 5
KBIPE_KBIPE6:       equ    6                                         ; Keyboard Pin Enable for Port A Bit 6
KBIPE_KBIPE7:       equ    7                                         ; Keyboard Pin Enable for Port A Bit 7
; bit position masks
mKBIPE_KBIPE0:      equ    %00000001
mKBIPE_KBIPE1:      equ    %00000010
mKBIPE_KBIPE2:      equ    %00000100
mKBIPE_KBIPE3:      equ    %00001000
mKBIPE_KBIPE4:      equ    %00010000
mKBIPE_KBIPE5:      equ    %00100000
mKBIPE_KBIPE6:      equ    %01000000
mKBIPE_KBIPE7:      equ    %10000000


;*** KBIES - KBI Edge Select Register; 0x0000000E ***
KBIES:              equ    $0000000E                                ;*** KBIES - KBI Edge Select Register; 0x0000000E ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
KBIES_KBEDG0:       equ    0                                         ; Keyboard Edge Select Bit 0
KBIES_KBEDG1:       equ    1                                         ; Keyboard Edge Select Bit 1
KBIES_KBEDG2:       equ    2                                         ; Keyboard Edge Select Bit 2
KBIES_KBEDG3:       equ    3                                         ; Keyboard Edge Select Bit 3
KBIES_KBEDG4:       equ    4                                         ; Keyboard Edge Select Bit 4
KBIES_KBEDG5:       equ    5                                         ; Keyboard Edge Select Bit 5
KBIES_KBEDG6:       equ    6                                         ; Keyboard Edge Select Bit 6
KBIES_KBEDG7:       equ    7                                         ; Keyboard Edge Select Bit 7
; bit position masks
mKBIES_KBEDG0:      equ    %00000001
mKBIES_KBEDG1:      equ    %00000010
mKBIES_KBEDG2:      equ    %00000100
mKBIES_KBEDG3:      equ    %00001000
mKBIES_KBEDG4:      equ    %00010000
mKBIES_KBEDG5:      equ    %00100000
mKBIES_KBEDG6:      equ    %01000000
mKBIES_KBEDG7:      equ    %10000000


;*** IRQSC - Interrupt Request Status and Control Register; 0x0000000F ***
IRQSC:              equ    $0000000F                                ;*** IRQSC - Interrupt Request Status and Control Register; 0x0000000F ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IRQSC_IRQMOD:       equ    0                                         ; IRQ Detection Mode
IRQSC_IRQIE:        equ    1                                         ; IRQ Interrupt Enable
IRQSC_IRQACK:       equ    2                                         ; IRQ Acknowledge
IRQSC_IRQF:         equ    3                                         ; IRQ Flag
IRQSC_IRQPE:        equ    4                                         ; IRQ Pin Enable
IRQSC_IRQPDD:       equ    6                                         ; Interrupt Request (IRQ) Pull Device Disable
; bit position masks
mIRQSC_IRQMOD:      equ    %00000001
mIRQSC_IRQIE:       equ    %00000010
mIRQSC_IRQACK:      equ    %00000100
mIRQSC_IRQF:        equ    %00001000
mIRQSC_IRQPE:       equ    %00010000
mIRQSC_IRQPDD:      equ    %01000000


;*** ADCSC1 - Status and Control Register; 0x00000010 ***
ADCSC1:             equ    $00000010                                ;*** ADCSC1 - Status and Control Register; 0x00000010 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCSC1_ADCH0:       equ    0                                         ; Input Channel Select Bit 0
ADCSC1_ADCH1:       equ    1                                         ; Input Channel Select Bit 1
ADCSC1_ADCH2:       equ    2                                         ; Input Channel Select Bit 2
ADCSC1_ADCH3:       equ    3                                         ; Input Channel Select Bit 3
ADCSC1_ADCH4:       equ    4                                         ; Input Channel Select Bit 4
ADCSC1_ADCO:        equ    5                                         ; Continuous Conversion Enable
ADCSC1_AIEN:        equ    6                                         ; Interrupt Enable
ADCSC1_COCO:        equ    7                                         ; Conversion Complete Flag
; bit position masks
mADCSC1_ADCH0:      equ    %00000001
mADCSC1_ADCH1:      equ    %00000010
mADCSC1_ADCH2:      equ    %00000100
mADCSC1_ADCH3:      equ    %00001000
mADCSC1_ADCH4:      equ    %00010000
mADCSC1_ADCO:       equ    %00100000
mADCSC1_AIEN:       equ    %01000000
mADCSC1_COCO:       equ    %10000000


;*** ADCSC2 - Status and Control Register 2; 0x00000011 ***
ADCSC2:             equ    $00000011                                ;*** ADCSC2 - Status and Control Register 2; 0x00000011 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCSC2_ACFGT:       equ    4                                         ; Compare Function Greater Than Enable
ADCSC2_ACFE:        equ    5                                         ; Compare Function Enable
ADCSC2_ADTRG:       equ    6                                         ; Conversion Trigger Select
ADCSC2_ADACT:       equ    7                                         ; Conversion Active
; bit position masks
mADCSC2_ACFGT:      equ    %00010000
mADCSC2_ACFE:       equ    %00100000
mADCSC2_ADTRG:      equ    %01000000
mADCSC2_ADACT:      equ    %10000000


;*** ADCR - ADC10 Result Data Right Justified; 0x00000012 ***
ADCR:               equ    $00000012                                ;*** ADCR - ADC10 Result Data Right Justified; 0x00000012 ***


;*** ADCRH - ADC10 Result Data Right Justified High; 0x00000012 ***
ADCRH:              equ    $00000012                                ;*** ADCRH - ADC10 Result Data Right Justified High; 0x00000012 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCRH_ADR8:         equ    0                                         ; ADC10 Result Data Bit 8
ADCRH_ADR9:         equ    1                                         ; ADC10 Result Data Bit 9
; bit position masks
mADCRH_ADR8:        equ    %00000001
mADCRH_ADR9:        equ    %00000010


;*** ADCRL - ADC10 Result Data Right Justified Low; 0x00000013 ***
ADCRL:              equ    $00000013                                ;*** ADCRL - ADC10 Result Data Right Justified Low; 0x00000013 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCRL_ADR0:         equ    0                                         ; ADC10 Result Data Bit 0
ADCRL_ADR1:         equ    1                                         ; ADC10 Result Data Bit 1
ADCRL_ADR2:         equ    2                                         ; ADC10 Result Data Bit 2
ADCRL_ADR3:         equ    3                                         ; ADC10 Result Data Bit 3
ADCRL_ADR4:         equ    4                                         ; ADC10 Result Data Bit 4
ADCRL_ADR5:         equ    5                                         ; ADC10 Result Data Bit 5
ADCRL_ADR6:         equ    6                                         ; ADC10 Result Data Bit 6
ADCRL_ADR7:         equ    7                                         ; ADC10 Result Data Bit 7
; bit position masks
mADCRL_ADR0:        equ    %00000001
mADCRL_ADR1:        equ    %00000010
mADCRL_ADR2:        equ    %00000100
mADCRL_ADR3:        equ    %00001000
mADCRL_ADR4:        equ    %00010000
mADCRL_ADR5:        equ    %00100000
mADCRL_ADR6:        equ    %01000000
mADCRL_ADR7:        equ    %10000000


;*** ADCCV - Compare Value Register; 0x00000014 ***
ADCCV:              equ    $00000014                                ;*** ADCCV - Compare Value Register; 0x00000014 ***


;*** ADCCVH - Compare Value Register High; 0x00000014 ***
ADCCVH:             equ    $00000014                                ;*** ADCCVH - Compare Value Register High; 0x00000014 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCVH_ADCV8:       equ    0                                         ; Compare Function Value 8
ADCCVH_ADCV9:       equ    1                                         ; Compare Function Value 9
; bit position masks
mADCCVH_ADCV8:      equ    %00000001
mADCCVH_ADCV9:      equ    %00000010


;*** ADCCVL - Compare Value Register Low; 0x00000015 ***
ADCCVL:             equ    $00000015                                ;*** ADCCVL - Compare Value Register Low; 0x00000015 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCVL_ADCV0:       equ    0                                         ; Compare Function Value 0
ADCCVL_ADCV1:       equ    1                                         ; Compare Function Value 1
ADCCVL_ADCV2:       equ    2                                         ; Compare Function Value 2
ADCCVL_ADCV3:       equ    3                                         ; Compare Function Value 3
ADCCVL_ADCV4:       equ    4                                         ; Compare Function Value 4
ADCCVL_ADCV5:       equ    5                                         ; Compare Function Value 5
ADCCVL_ADCV6:       equ    6                                         ; Compare Function Value 6
ADCCVL_ADCV7:       equ    7                                         ; Compare Function Value 7
; bit position masks
mADCCVL_ADCV0:      equ    %00000001
mADCCVL_ADCV1:      equ    %00000010
mADCCVL_ADCV2:      equ    %00000100
mADCCVL_ADCV3:      equ    %00001000
mADCCVL_ADCV4:      equ    %00010000
mADCCVL_ADCV5:      equ    %00100000
mADCCVL_ADCV6:      equ    %01000000
mADCCVL_ADCV7:      equ    %10000000


;*** ADCCFG - Configuration Register; 0x00000016 ***
ADCCFG:             equ    $00000016                                ;*** ADCCFG - Configuration Register; 0x00000016 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ADCCFG_ADICLK0:     equ    0                                         ; Input Clock Select Bit 0
ADCCFG_ADICLK1:     equ    1                                         ; Input Clock Select Bit 1
ADCCFG_MODE0:       equ    2                                         ; Conversion Mode Selection Bit 0
ADCCFG_MODE1:       equ    3                                         ; Conversion Mode Selection Bit 1
ADCCFG_ADLSMP:      equ    4                                         ; Long Sample Time Configuration
ADCCFG_ADIV0:       equ    5                                         ; Clock Divide Select Bit 0
ADCCFG_ADIV1:       equ    6                                         ; Clock Divide Select Bit 1
ADCCFG_ADLPC:       equ    7                                         ; Low Power Configuration
; bit position masks
mADCCFG_ADICLK0:    equ    %00000001
mADCCFG_ADICLK1:    equ    %00000010
mADCCFG_MODE0:      equ    %00000100
mADCCFG_MODE1:      equ    %00001000
mADCCFG_ADLSMP:     equ    %00010000
mADCCFG_ADIV0:      equ    %00100000
mADCCFG_ADIV1:      equ    %01000000
mADCCFG_ADLPC:      equ    %10000000


;*** APCTL1 - ADC10 Pin Control 1 Register; 0x00000017 ***
APCTL1:             equ    $00000017                                ;*** APCTL1 - ADC10 Pin Control 1 Register; 0x00000017 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
APCTL1_ADPC0:       equ    0                                         ; ADC10 Pin Control 0
APCTL1_ADPC1:       equ    1                                         ; ADC10 Pin Control 1
APCTL1_ADPC2:       equ    2                                         ; ADC10 Pin Control 2
APCTL1_ADPC3:       equ    3                                         ; ADC10 Pin Control 3
APCTL1_ADPC4:       equ    4                                         ; ADC10 Pin Control 4
APCTL1_ADPC5:       equ    5                                         ; ADC10 Pin Control 5
APCTL1_ADPC6:       equ    6                                         ; ADC10 Pin Control 6
APCTL1_ADPC7:       equ    7                                         ; ADC10 Pin Control 7
; bit position masks
mAPCTL1_ADPC0:      equ    %00000001
mAPCTL1_ADPC1:      equ    %00000010
mAPCTL1_ADPC2:      equ    %00000100
mAPCTL1_ADPC3:      equ    %00001000
mAPCTL1_ADPC4:      equ    %00010000
mAPCTL1_ADPC5:      equ    %00100000
mAPCTL1_ADPC6:      equ    %01000000
mAPCTL1_ADPC7:      equ    %10000000


;*** ACMPSC - Analog Comparator Status and Control Register; 0x0000001A ***
ACMPSC:             equ    $0000001A                                ;*** ACMPSC - Analog Comparator Status and Control Register; 0x0000001A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ACMPSC_ACMOD0:      equ    0                                         ; Analog Comparator Mode Bit 0
ACMPSC_ACMOD1:      equ    1                                         ; Analog Comparator Mode Bit 1
ACMPSC_ACOPE:       equ    2                                         ; Analog Comparator Output Pin Enable
ACMPSC_ACO:         equ    3                                         ; Analog Comparator Output
ACMPSC_ACIE:        equ    4                                         ; Analog Comparator Interrupt Enable
ACMPSC_ACF:         equ    5                                         ; Analog Comparator Flag
ACMPSC_ACBGS:       equ    6                                         ; Analog Comparator Bandgap Select
ACMPSC_ACME:        equ    7                                         ; Analog Comparator Module Enable
; bit position masks
mACMPSC_ACMOD0:     equ    %00000001
mACMPSC_ACMOD1:     equ    %00000010
mACMPSC_ACOPE:      equ    %00000100
mACMPSC_ACO:        equ    %00001000
mACMPSC_ACIE:       equ    %00010000
mACMPSC_ACF:        equ    %00100000
mACMPSC_ACBGS:      equ    %01000000
mACMPSC_ACME:       equ    %10000000


;*** SCIBD - SCI Baud Rate Register; 0x00000020 ***
SCIBD:              equ    $00000020                                ;*** SCIBD - SCI Baud Rate Register; 0x00000020 ***


;*** SCIBDH - SCI Baud Rate Register High; 0x00000020 ***
SCIBDH:             equ    $00000020                                ;*** SCIBDH - SCI Baud Rate Register High; 0x00000020 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDH_SBR8:        equ    0                                         ; Baud Rate Modulo Divisor Bit 8
SCIBDH_SBR9:        equ    1                                         ; Baud Rate Modulo Divisor Bit 9
SCIBDH_SBR10:       equ    2                                         ; Baud Rate Modulo Divisor Bit 10
SCIBDH_SBR11:       equ    3                                         ; Baud Rate Modulo Divisor Bit 11
SCIBDH_SBR12:       equ    4                                         ; Baud Rate Modulo Divisor Bit 12
; bit position masks
mSCIBDH_SBR8:       equ    %00000001
mSCIBDH_SBR9:       equ    %00000010
mSCIBDH_SBR10:      equ    %00000100
mSCIBDH_SBR11:      equ    %00001000
mSCIBDH_SBR12:      equ    %00010000


;*** SCIBDL - SCI Baud Rate Register Low; 0x00000021 ***
SCIBDL:             equ    $00000021                                ;*** SCIBDL - SCI Baud Rate Register Low; 0x00000021 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIBDL_SBR0:        equ    0                                         ; Baud Rate Modulo Divisor Bit 0
SCIBDL_SBR1:        equ    1                                         ; Baud Rate Modulo Divisor Bit 1
SCIBDL_SBR2:        equ    2                                         ; Baud Rate Modulo Divisor Bit 2
SCIBDL_SBR3:        equ    3                                         ; Baud Rate Modulo Divisor Bit 3
SCIBDL_SBR4:        equ    4                                         ; Baud Rate Modulo Divisor Bit 4
SCIBDL_SBR5:        equ    5                                         ; Baud Rate Modulo Divisor Bit 5
SCIBDL_SBR6:        equ    6                                         ; Baud Rate Modulo Divisor Bit 6
SCIBDL_SBR7:        equ    7                                         ; Baud Rate Modulo Divisor Bit 7
; bit position masks
mSCIBDL_SBR0:       equ    %00000001
mSCIBDL_SBR1:       equ    %00000010
mSCIBDL_SBR2:       equ    %00000100
mSCIBDL_SBR3:       equ    %00001000
mSCIBDL_SBR4:       equ    %00010000
mSCIBDL_SBR5:       equ    %00100000
mSCIBDL_SBR6:       equ    %01000000
mSCIBDL_SBR7:       equ    %10000000


;*** SCIC1 - SCI Control Register 1; 0x00000022 ***
SCIC1:              equ    $00000022                                ;*** SCIC1 - SCI Control Register 1; 0x00000022 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC1_PT:           equ    0                                         ; Parity Type
SCIC1_PE:           equ    1                                         ; Parity Enable
SCIC1_ILT:          equ    2                                         ; Idle Line Type Select
SCIC1_WAKE:         equ    3                                         ; Receiver Wakeup Method Select
SCIC1_M:            equ    4                                         ; 9-Bit or 8-Bit Mode Select
SCIC1_RSRC:         equ    5                                         ; Receiver Source Select
SCIC1_SCISWAI:      equ    6                                         ; SCI Stops in Wait Mode
SCIC1_LOOPS:        equ    7                                         ; Loop Mode Select
; bit position masks
mSCIC1_PT:          equ    %00000001
mSCIC1_PE:          equ    %00000010
mSCIC1_ILT:         equ    %00000100
mSCIC1_WAKE:        equ    %00001000
mSCIC1_M:           equ    %00010000
mSCIC1_RSRC:        equ    %00100000
mSCIC1_SCISWAI:     equ    %01000000
mSCIC1_LOOPS:       equ    %10000000


;*** SCIC2 - SCI Control Register 2; 0x00000023 ***
SCIC2:              equ    $00000023                                ;*** SCIC2 - SCI Control Register 2; 0x00000023 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC2_SBK:          equ    0                                         ; Send Break
SCIC2_RWU:          equ    1                                         ; Receiver Wakeup Control
SCIC2_RE:           equ    2                                         ; Receiver Enable
SCIC2_TE:           equ    3                                         ; Transmitter Enable
SCIC2_ILIE:         equ    4                                         ; Idle Line Interrupt Enable (for IDLE)
SCIC2_RIE:          equ    5                                         ; Receiver Interrupt Enable (for RDRF)
SCIC2_TCIE:         equ    6                                         ; Transmission Complete Interrupt Enable (for TC)
SCIC2_TIE:          equ    7                                         ; Transmit Interrupt Enable (for TDRE)
; bit position masks
mSCIC2_SBK:         equ    %00000001
mSCIC2_RWU:         equ    %00000010
mSCIC2_RE:          equ    %00000100
mSCIC2_TE:          equ    %00001000
mSCIC2_ILIE:        equ    %00010000
mSCIC2_RIE:         equ    %00100000
mSCIC2_TCIE:        equ    %01000000
mSCIC2_TIE:         equ    %10000000


;*** SCIS1 - SCI Status Register 1; 0x00000024 ***
SCIS1:              equ    $00000024                                ;*** SCIS1 - SCI Status Register 1; 0x00000024 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS1_PF:           equ    0                                         ; Parity Error Flag
SCIS1_FE:           equ    1                                         ; Framing Error Flag
SCIS1_NF:           equ    2                                         ; Noise Flag
SCIS1_OR:           equ    3                                         ; Receiver Overrun Flag
SCIS1_IDLE:         equ    4                                         ; Idle Line Flag
SCIS1_RDRF:         equ    5                                         ; Receive Data Register Full Flag
SCIS1_TC:           equ    6                                         ; Transmission Complete Flag
SCIS1_TDRE:         equ    7                                         ; Transmit Data Register Empty Flag
; bit position masks
mSCIS1_PF:          equ    %00000001
mSCIS1_FE:          equ    %00000010
mSCIS1_NF:          equ    %00000100
mSCIS1_OR:          equ    %00001000
mSCIS1_IDLE:        equ    %00010000
mSCIS1_RDRF:        equ    %00100000
mSCIS1_TC:          equ    %01000000
mSCIS1_TDRE:        equ    %10000000


;*** SCIS2 - SCI Status Register 2; 0x00000025 ***
SCIS2:              equ    $00000025                                ;*** SCIS2 - SCI Status Register 2; 0x00000025 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIS2_RAF:          equ    0                                         ; Receiver Active Flag
SCIS2_BRK13:        equ    2                                         ; Break Character Length
; bit position masks
mSCIS2_RAF:         equ    %00000001
mSCIS2_BRK13:       equ    %00000100


;*** SCIC3 - SCI Control Register 3; 0x00000026 ***
SCIC3:              equ    $00000026                                ;*** SCIC3 - SCI Control Register 3; 0x00000026 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCIC3_PEIE:         equ    0                                         ; Parity Error Interrupt Enable
SCIC3_FEIE:         equ    1                                         ; Framing Error Interrupt Enable
SCIC3_NEIE:         equ    2                                         ; Noise Error Interrupt Enable
SCIC3_ORIE:         equ    3                                         ; Overrun Interrupt Enable
SCIC3_TXINV:        equ    4                                         ; Transmit Data Inversion
SCIC3_TXDIR:        equ    5                                         ; TxD Pin Direction in Single-Wire Mode
SCIC3_T8:           equ    6                                         ; Ninth Data Bit for Transmitter
SCIC3_R8:           equ    7                                         ; Ninth Data Bit for Receiver
; bit position masks
mSCIC3_PEIE:        equ    %00000001
mSCIC3_FEIE:        equ    %00000010
mSCIC3_NEIE:        equ    %00000100
mSCIC3_ORIE:        equ    %00001000
mSCIC3_TXINV:       equ    %00010000
mSCIC3_TXDIR:       equ    %00100000
mSCIC3_T8:          equ    %01000000
mSCIC3_R8:          equ    %10000000


;*** SCID - SCI Data Register; 0x00000027 ***
SCID:               equ    $00000027                                ;*** SCID - SCI Data Register; 0x00000027 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SCID_R0_T0:         equ    0                                         ; Receive/Transmit Data Bit 0
SCID_R1_T1:         equ    1                                         ; Receive/Transmit Data Bit 1
SCID_R2_T2:         equ    2                                         ; Receive/Transmit Data Bit 2
SCID_R3_T3:         equ    3                                         ; Receive/Transmit Data Bit 3
SCID_R4_T4:         equ    4                                         ; Receive/Transmit Data Bit 4
SCID_R5_T5:         equ    5                                         ; Receive/Transmit Data Bit 5
SCID_R6_T6:         equ    6                                         ; Receive/Transmit Data Bit 6
SCID_R7_T7:         equ    7                                         ; Receive/Transmit Data Bit 7
; bit position masks
mSCID_R0_T0:        equ    %00000001
mSCID_R1_T1:        equ    %00000010
mSCID_R2_T2:        equ    %00000100
mSCID_R3_T3:        equ    %00001000
mSCID_R4_T4:        equ    %00010000
mSCID_R5_T5:        equ    %00100000
mSCID_R6_T6:        equ    %01000000
mSCID_R7_T7:        equ    %10000000


;*** SPIC1 - SPI Control Register 1; 0x00000028 ***
SPIC1:              equ    $00000028                                ;*** SPIC1 - SPI Control Register 1; 0x00000028 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC1_LSBFE:        equ    0                                         ; LSB First (shifter direction)
SPIC1_SSOE:         equ    1                                         ; Slave Select Output Enable
SPIC1_CPHA:         equ    2                                         ; Clock Phase
SPIC1_CPOL:         equ    3                                         ; Clock Polarity
SPIC1_MSTR:         equ    4                                         ; Master/Slave Mode Select
SPIC1_SPTIE:        equ    5                                         ; SPI Transmit Interrupt Enable
SPIC1_SPE:          equ    6                                         ; SPI System Enable
SPIC1_SPIE:         equ    7                                         ; SPI Interrupt Enable
; bit position masks
mSPIC1_LSBFE:       equ    %00000001
mSPIC1_SSOE:        equ    %00000010
mSPIC1_CPHA:        equ    %00000100
mSPIC1_CPOL:        equ    %00001000
mSPIC1_MSTR:        equ    %00010000
mSPIC1_SPTIE:       equ    %00100000
mSPIC1_SPE:         equ    %01000000
mSPIC1_SPIE:        equ    %10000000


;*** SPIC2 - SPI Control Register 2; 0x00000029 ***
SPIC2:              equ    $00000029                                ;*** SPIC2 - SPI Control Register 2; 0x00000029 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIC2_SPC0:         equ    0                                         ; SPI Pin Control 0
SPIC2_SPISWAI:      equ    1                                         ; SPI Stop in Wait Mode
SPIC2_BIDIROE:      equ    3                                         ; Bidirectional Mode Output Enable
SPIC2_MODFEN:       equ    4                                         ; Master Mode-Fault Function Enable
; bit position masks
mSPIC2_SPC0:        equ    %00000001
mSPIC2_SPISWAI:     equ    %00000010
mSPIC2_BIDIROE:     equ    %00001000
mSPIC2_MODFEN:      equ    %00010000


;*** SPIBR - SPI Baud Rate Register; 0x0000002A ***
SPIBR:              equ    $0000002A                                ;*** SPIBR - SPI Baud Rate Register; 0x0000002A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIBR_SPR0:         equ    0                                         ; SPI Baud Rate Divisor Bit 0
SPIBR_SPR1:         equ    1                                         ; SPI Baud Rate Divisor Bit 1
SPIBR_SPR2:         equ    2                                         ; SPI Baud Rate Divisor Bit 2
SPIBR_SPPR0:        equ    4                                         ; SPI Baud Rate Prescale Divisor Bit 0
SPIBR_SPPR1:        equ    5                                         ; SPI Baud Rate Prescale Divisor Bit 1
SPIBR_SPPR2:        equ    6                                         ; SPI Baud Rate Prescale Divisor Bit 2
; bit position masks
mSPIBR_SPR0:        equ    %00000001
mSPIBR_SPR1:        equ    %00000010
mSPIBR_SPR2:        equ    %00000100
mSPIBR_SPPR0:       equ    %00010000
mSPIBR_SPPR1:       equ    %00100000
mSPIBR_SPPR2:       equ    %01000000


;*** SPIS - SPI Status Register; 0x0000002B ***
SPIS:               equ    $0000002B                                ;*** SPIS - SPI Status Register; 0x0000002B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPIS_MODF:          equ    4                                         ; Master Mode Fault Flag
SPIS_SPTEF:         equ    5                                         ; SPI Transmit Buffer Empty Flag
SPIS_SPRF:          equ    7                                         ; SPI Read Buffer Full Flag
; bit position masks
mSPIS_MODF:         equ    %00010000
mSPIS_SPTEF:        equ    %00100000
mSPIS_SPRF:         equ    %10000000


;*** SPID - SPI Data Register; 0x0000002D ***
SPID:               equ    $0000002D                                ;*** SPID - SPI Data Register; 0x0000002D ***


;*** IICA - IIC Address Register; 0x00000030 ***
IICA:               equ    $00000030                                ;*** IICA - IIC Address Register; 0x00000030 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICA_ADDR0:         equ    1                                         ; IIC Address Bit 0
IICA_ADDR1:         equ    2                                         ; IIC Address Bit 1
IICA_ADDR2:         equ    3                                         ; IIC Address Bit 2
IICA_ADDR3:         equ    4                                         ; IIC Address Bit 3
IICA_ADDR4:         equ    5                                         ; IIC Address Bit 4
IICA_ADDR5:         equ    6                                         ; IIC Address Bit 5
IICA_ADDR6:         equ    7                                         ; IIC Address Bit 6
; bit position masks
mIICA_ADDR0:        equ    %00000010
mIICA_ADDR1:        equ    %00000100
mIICA_ADDR2:        equ    %00001000
mIICA_ADDR3:        equ    %00010000
mIICA_ADDR4:        equ    %00100000
mIICA_ADDR5:        equ    %01000000
mIICA_ADDR6:        equ    %10000000


;*** IICF - IIC Frequency Divider Register; 0x00000031 ***
IICF:               equ    $00000031                                ;*** IICF - IIC Frequency Divider Register; 0x00000031 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICF_ICR0:          equ    0                                         ; IIC Clock Rate Bit 0
IICF_ICR1:          equ    1                                         ; IIC Clock Rate Bit 1
IICF_ICR2:          equ    2                                         ; IIC Clock Rate Bit 2
IICF_ICR3:          equ    3                                         ; IIC Clock Rate Bit 3
IICF_ICR4:          equ    4                                         ; IIC Clock Rate Bit 4
IICF_ICR5:          equ    5                                         ; IIC Clock Rate Bit 5
IICF_MULT0:         equ    6                                         ; Multiplier Factor Bit 0
IICF_MULT1:         equ    7                                         ; Multiplier Factor Bit 1
; bit position masks
mIICF_ICR0:         equ    %00000001
mIICF_ICR1:         equ    %00000010
mIICF_ICR2:         equ    %00000100
mIICF_ICR3:         equ    %00001000
mIICF_ICR4:         equ    %00010000
mIICF_ICR5:         equ    %00100000
mIICF_MULT0:        equ    %01000000
mIICF_MULT1:        equ    %10000000


;*** IICC - IIC Control Register; 0x00000032 ***
IICC:               equ    $00000032                                ;*** IICC - IIC Control Register; 0x00000032 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICC_RSTA:          equ    2                                         ; Repeat START Bit
IICC_TXAK:          equ    3                                         ; Transmit Acknowledge Enable Bit
IICC_TX:            equ    4                                         ; Transmit Mode Select Bit
IICC_MST:           equ    5                                         ; Master Mode Select Bit
IICC_IICIE:         equ    6                                         ; IIC Interrupt Enable Bit
IICC_IICEN:         equ    7                                         ; IIC Enable Bit
; bit position masks
mIICC_RSTA:         equ    %00000100
mIICC_TXAK:         equ    %00001000
mIICC_TX:           equ    %00010000
mIICC_MST:          equ    %00100000
mIICC_IICIE:        equ    %01000000
mIICC_IICEN:        equ    %10000000


;*** IICS - IIC Status Register; 0x00000033 ***
IICS:               equ    $00000033                                ;*** IICS - IIC Status Register; 0x00000033 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICS_RXAK:          equ    0                                         ; Receive Acknowledge
IICS_IICIF:         equ    1                                         ; IIC Interrupt Flag
IICS_SRW:           equ    2                                         ; Slave Read/Write
IICS_ARBL:          equ    4                                         ; Arbitration Lost
IICS_BUSY:          equ    5                                         ; Bus Busy bit
IICS_IAAS:          equ    6                                         ; Addressed as a Slave Bit
IICS_TCF:           equ    7                                         ; Transfer Complete Flag
; bit position masks
mIICS_RXAK:         equ    %00000001
mIICS_IICIF:        equ    %00000010
mIICS_SRW:          equ    %00000100
mIICS_ARBL:         equ    %00010000
mIICS_BUSY:         equ    %00100000
mIICS_IAAS:         equ    %01000000
mIICS_TCF:          equ    %10000000


;*** IICD - IIC Data I/O Register; 0x00000034 ***
IICD:               equ    $00000034                                ;*** IICD - IIC Data I/O Register; 0x00000034 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
IICD_DATA0:         equ    0                                         ; IIC Data Bit 0
IICD_DATA1:         equ    1                                         ; IIC Data Bit 1
IICD_DATA2:         equ    2                                         ; IIC Data Bit 2
IICD_DATA3:         equ    3                                         ; IIC Data Bit 3
IICD_DATA4:         equ    4                                         ; IIC Data Bit 4
IICD_DATA5:         equ    5                                         ; IIC Data Bit 5
IICD_DATA6:         equ    6                                         ; IIC Data Bit 6
IICD_DATA7:         equ    7                                         ; IIC Data Bit 7
; bit position masks
mIICD_DATA0:        equ    %00000001
mIICD_DATA1:        equ    %00000010
mIICD_DATA2:        equ    %00000100
mIICD_DATA3:        equ    %00001000
mIICD_DATA4:        equ    %00010000
mIICD_DATA5:        equ    %00100000
mIICD_DATA6:        equ    %01000000
mIICD_DATA7:        equ    %10000000


;*** ICSC1 - ICS Control Register 1; 0x00000038 ***
ICSC1:              equ    $00000038                                ;*** ICSC1 - ICS Control Register 1; 0x00000038 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC1_IREFSTEN:     equ    0                                         ; Internal Reference Stop Enable
ICSC1_IRCLKEN:      equ    1                                         ; Internal Reference Clock Enable
ICSC1_IREFS:        equ    2                                         ; Internal Reference Select
ICSC1_RDIV0:        equ    3                                         ; Reference Divider, bit 0
ICSC1_RDIV1:        equ    4                                         ; Reference Divider, bit 1
ICSC1_RDIV2:        equ    5                                         ; Reference Divider, bit 2
ICSC1_CLKS0:        equ    6                                         ; Clock Source Select, bit 0
ICSC1_CLKS1:        equ    7                                         ; Clock Source Select, bit 1
; bit position masks
mICSC1_IREFSTEN:    equ    %00000001
mICSC1_IRCLKEN:     equ    %00000010
mICSC1_IREFS:       equ    %00000100
mICSC1_RDIV0:       equ    %00001000
mICSC1_RDIV1:       equ    %00010000
mICSC1_RDIV2:       equ    %00100000
mICSC1_CLKS0:       equ    %01000000
mICSC1_CLKS1:       equ    %10000000


;*** ICSC2 - ICS Control Register 2; 0x00000039 ***
ICSC2:              equ    $00000039                                ;*** ICSC2 - ICS Control Register 2; 0x00000039 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSC2_EREFSTEN:     equ    0                                         ; External Reference Stop Enable
ICSC2_ERCLKEN:      equ    1                                         ; External Reference Enable
ICSC2_EREFS:        equ    2                                         ; External Reference Select
ICSC2_LP:           equ    3                                         ; Low Power Select
ICSC2_HGO:          equ    4                                         ; High Gain Oscillator Select
ICSC2_RANGE:        equ    5                                         ; Frequency Range Select
ICSC2_BDIV0:        equ    6                                         ; Bus Frequency Divider, bit 0
ICSC2_BDIV1:        equ    7                                         ; Bus Frequency Divider, bit 1
; bit position masks
mICSC2_EREFSTEN:    equ    %00000001
mICSC2_ERCLKEN:     equ    %00000010
mICSC2_EREFS:       equ    %00000100
mICSC2_LP:          equ    %00001000
mICSC2_HGO:         equ    %00010000
mICSC2_RANGE:       equ    %00100000
mICSC2_BDIV0:       equ    %01000000
mICSC2_BDIV1:       equ    %10000000


;*** ICSTRM - ICS Trim Register; 0x0000003A ***
ICSTRM:             equ    $0000003A                                ;*** ICSTRM - ICS Trim Register; 0x0000003A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSTRM_TRIM0:       equ    0                                         ; ICS Trim Setting, bit 0
ICSTRM_TRIM1:       equ    1                                         ; ICS Trim Setting, bit 1
ICSTRM_TRIM2:       equ    2                                         ; ICS Trim Setting, bit 2
ICSTRM_TRIM3:       equ    3                                         ; ICS Trim Setting, bit 3
ICSTRM_TRIM4:       equ    4                                         ; ICS Trim Setting, bit 4
ICSTRM_TRIM5:       equ    5                                         ; ICS Trim Setting, bit 5
ICSTRM_TRIM6:       equ    6                                         ; ICS Trim Setting, bit 6
ICSTRM_TRIM7:       equ    7                                         ; ICS Trim Setting, bit 7
; bit position masks
mICSTRM_TRIM0:      equ    %00000001
mICSTRM_TRIM1:      equ    %00000010
mICSTRM_TRIM2:      equ    %00000100
mICSTRM_TRIM3:      equ    %00001000
mICSTRM_TRIM4:      equ    %00010000
mICSTRM_TRIM5:      equ    %00100000
mICSTRM_TRIM6:      equ    %01000000
mICSTRM_TRIM7:      equ    %10000000


;*** ICSSC - ICS Status and Control; 0x0000003B ***
ICSSC:              equ    $0000003B                                ;*** ICSSC - ICS Status and Control; 0x0000003B ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
ICSSC_FTRIM:        equ    0                                         ; ICS Fine Trim
ICSSC_OSCINIT:      equ    1                                         ; OSC Initialization
ICSSC_CLKST0:       equ    2                                         ; Clock Mode Status, bit 0
ICSSC_CLKST1:       equ    3                                         ; Clock Mode Status, bit 1
; bit position masks
mICSSC_FTRIM:       equ    %00000001
mICSSC_OSCINIT:     equ    %00000010
mICSSC_CLKST0:      equ    %00000100
mICSSC_CLKST1:      equ    %00001000


;*** MTIMSC - MTIM Status and Control Register; 0x0000003C ***
MTIMSC:             equ    $0000003C                                ;*** MTIMSC - MTIM Status and Control Register; 0x0000003C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTIMSC_TSTP:        equ    4                                         ; MTIM Counter Stop
MTIMSC_TRST:        equ    5                                         ; MTIM Counter Reset
MTIMSC_TOIE:        equ    6                                         ; MTIM Overflow Interrupt Enable
MTIMSC_TOF:         equ    7                                         ; MTIM Overflow Flag
; bit position masks
mMTIMSC_TSTP:       equ    %00010000
mMTIMSC_TRST:       equ    %00100000
mMTIMSC_TOIE:       equ    %01000000
mMTIMSC_TOF:        equ    %10000000


;*** MTIMCLK - MTIM Clock Configuration Register; 0x0000003D ***
MTIMCLK:            equ    $0000003D                                ;*** MTIMCLK - MTIM Clock Configuration Register; 0x0000003D ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
MTIMCLK_PS0:        equ    0                                         ; Clock Source Prescaler, bit 0
MTIMCLK_PS1:        equ    1                                         ; Clock Source Prescaler, bit 1
MTIMCLK_PS2:        equ    2                                         ; Clock Source Prescaler, bit 2
MTIMCLK_PS3:        equ    3                                         ; Clock Source Prescaler, bit 3
MTIMCLK_CLKS0:      equ    4                                         ; Clock Source Select, bit 0
MTIMCLK_CLKS1:      equ    5                                         ; Clock Source Select, bit 1
; bit position masks
mMTIMCLK_PS0:       equ    %00000001
mMTIMCLK_PS1:       equ    %00000010
mMTIMCLK_PS2:       equ    %00000100
mMTIMCLK_PS3:       equ    %00001000
mMTIMCLK_CLKS0:     equ    %00010000
mMTIMCLK_CLKS1:     equ    %00100000


;*** MTIMCNT - MTIM Counter Register; 0x0000003E ***
MTIMCNT:            equ    $0000003E                                ;*** MTIMCNT - MTIM Counter Register; 0x0000003E ***


;*** MTIMMOD - MTIM Modulo Register; 0x0000003F ***
MTIMMOD:            equ    $0000003F                                ;*** MTIMMOD - MTIM Modulo Register; 0x0000003F ***


;*** TPMSC - TPM Timer Status and Control Register; 0x00000040 ***
TPMSC:              equ    $00000040                                ;*** TPMSC - TPM Timer Status and Control Register; 0x00000040 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPMSC_PS0:          equ    0                                         ; Prescale Divisor Select Bit 0
TPMSC_PS1:          equ    1                                         ; Prescale Divisor Select Bit 1
TPMSC_PS2:          equ    2                                         ; Prescale Divisor Select Bit 2
TPMSC_CLKSA:        equ    3                                         ; Clock Source Select A
TPMSC_CLKSB:        equ    4                                         ; Clock Source Select B
TPMSC_CPWMS:        equ    5                                         ; Center-Aligned PWM Select
TPMSC_TOIE:         equ    6                                         ; Timer Overflow Interrupt Enable
TPMSC_TOF:          equ    7                                         ; Timer Overflow Flag
; bit position masks
mTPMSC_PS0:         equ    %00000001
mTPMSC_PS1:         equ    %00000010
mTPMSC_PS2:         equ    %00000100
mTPMSC_CLKSA:       equ    %00001000
mTPMSC_CLKSB:       equ    %00010000
mTPMSC_CPWMS:       equ    %00100000
mTPMSC_TOIE:        equ    %01000000
mTPMSC_TOF:         equ    %10000000


;*** TPMCNT - TPM Counter Register; 0x00000041 ***
TPMCNT:             equ    $00000041                                ;*** TPMCNT - TPM Counter Register; 0x00000041 ***


;*** TPMCNTH - TPM Counter Register High; 0x00000041 ***
TPMCNTH:            equ    $00000041                                ;*** TPMCNTH - TPM Counter Register High; 0x00000041 ***


;*** TPMCNTL - TPM Counter Register Low; 0x00000042 ***
TPMCNTL:            equ    $00000042                                ;*** TPMCNTL - TPM Counter Register Low; 0x00000042 ***


;*** TPMMOD - TPM Timer Counter Modulo Register; 0x00000043 ***
TPMMOD:             equ    $00000043                                ;*** TPMMOD - TPM Timer Counter Modulo Register; 0x00000043 ***


;*** TPMMODH - TPM Timer Counter Modulo Register High; 0x00000043 ***
TPMMODH:            equ    $00000043                                ;*** TPMMODH - TPM Timer Counter Modulo Register High; 0x00000043 ***


;*** TPMMODL - TPM Timer Counter Modulo Register Low; 0x00000044 ***
TPMMODL:            equ    $00000044                                ;*** TPMMODL - TPM Timer Counter Modulo Register Low; 0x00000044 ***


;*** TPMC0SC - TPM Timer Channel 0 Status and Control Register; 0x00000045 ***
TPMC0SC:            equ    $00000045                                ;*** TPMC0SC - TPM Timer Channel 0 Status and Control Register; 0x00000045 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPMC0SC_ELS0A:      equ    2                                         ; Edge/Level Select Bit A
TPMC0SC_ELS0B:      equ    3                                         ; Edge/Level Select Bit B
TPMC0SC_MS0A:       equ    4                                         ; Mode Select A for TPM Channel 0
TPMC0SC_MS0B:       equ    5                                         ; Mode Select B for TPM Channel 0
TPMC0SC_CH0IE:      equ    6                                         ; Channel 0 Interrupt Enable
TPMC0SC_CH0F:       equ    7                                         ; Channel 0 Flag
; bit position masks
mTPMC0SC_ELS0A:     equ    %00000100
mTPMC0SC_ELS0B:     equ    %00001000
mTPMC0SC_MS0A:      equ    %00010000
mTPMC0SC_MS0B:      equ    %00100000
mTPMC0SC_CH0IE:     equ    %01000000
mTPMC0SC_CH0F:      equ    %10000000


;*** TPMC0V - TPM Timer Channel 0 Value Register; 0x00000046 ***
TPMC0V:             equ    $00000046                                ;*** TPMC0V - TPM Timer Channel 0 Value Register; 0x00000046 ***


;*** TPMC0VH - TPM Timer Channel 0 Value Register High; 0x00000046 ***
TPMC0VH:            equ    $00000046                                ;*** TPMC0VH - TPM Timer Channel 0 Value Register High; 0x00000046 ***


;*** TPMC0VL - TPM Timer Channel 0 Value Register Low; 0x00000047 ***
TPMC0VL:            equ    $00000047                                ;*** TPMC0VL - TPM Timer Channel 0 Value Register Low; 0x00000047 ***


;*** TPMC1SC - TPM Timer Channel 1 Status and Control Register; 0x00000048 ***
TPMC1SC:            equ    $00000048                                ;*** TPMC1SC - TPM Timer Channel 1 Status and Control Register; 0x00000048 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
TPMC1SC_ELS1A:      equ    2                                         ; Edge/Level Select Bit A
TPMC1SC_ELS1B:      equ    3                                         ; Edge/Level Select Bit B
TPMC1SC_MS1A:       equ    4                                         ; Mode Select A for TPM Channel 1
TPMC1SC_MS1B:       equ    5                                         ; Mode Select B for TPM Channel 1
TPMC1SC_CH1IE:      equ    6                                         ; Channel 1 Interrupt Enable
TPMC1SC_CH1F:       equ    7                                         ; Channel 1 Flag
; bit position masks
mTPMC1SC_ELS1A:     equ    %00000100
mTPMC1SC_ELS1B:     equ    %00001000
mTPMC1SC_MS1A:      equ    %00010000
mTPMC1SC_MS1B:      equ    %00100000
mTPMC1SC_CH1IE:     equ    %01000000
mTPMC1SC_CH1F:      equ    %10000000


;*** TPMC1V - TPM Timer Channel 1 Value Register; 0x00000049 ***
TPMC1V:             equ    $00000049                                ;*** TPMC1V - TPM Timer Channel 1 Value Register; 0x00000049 ***


;*** TPMC1VH - TPM Timer Channel 1 Value Register High; 0x00000049 ***
TPMC1VH:            equ    $00000049                                ;*** TPMC1VH - TPM Timer Channel 1 Value Register High; 0x00000049 ***


;*** TPMC1VL - TPM Timer Channel 1 Value Register Low; 0x0000004A ***
TPMC1VL:            equ    $0000004A                                ;*** TPMC1VL - TPM Timer Channel 1 Value Register Low; 0x0000004A ***


;*** SRS - System Reset Status Register; 0x00001800 ***
SRS:                equ    $00001800                                ;*** SRS - System Reset Status Register; 0x00001800 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRS_LVD:            equ    1                                         ; Low Voltage Detect
SRS_ILAD:           equ    3                                         ; Illegal Address
SRS_ILOP:           equ    4                                         ; Illegal Opcode
SRS_COP:            equ    5                                         ; Computer Operating Properly (COP) Watchdog
SRS_PIN:            equ    6                                         ; External Reset Pin
SRS_POR:            equ    7                                         ; Power-On Reset
; bit position masks
mSRS_LVD:           equ    %00000010
mSRS_ILAD:          equ    %00001000
mSRS_ILOP:          equ    %00010000
mSRS_COP:           equ    %00100000
mSRS_PIN:           equ    %01000000
mSRS_POR:           equ    %10000000


;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
SBDFR:              equ    $00001801                                ;*** SBDFR - System Background Debug Force Reset Register; 0x00001801 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SBDFR_BDFR:         equ    0                                         ; Background Debug Force Reset
; bit position masks
mSBDFR_BDFR:        equ    %00000001


;*** SOPT1 - System Options Register 1; 0x00001802 ***
SOPT1:              equ    $00001802                                ;*** SOPT1 - System Options Register 1; 0x00001802 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT1_RSTPE:        equ    0                                         ; RESET Pin Enable
SOPT1_BKGDPE:       equ    1                                         ; Background Debug Mode Pin Enable
SOPT1_STOPE:        equ    5                                         ; Stop Mode Enable
SOPT1_COPT:         equ    6                                         ; COP Watchdog Timeout
SOPT1_COPE:         equ    7                                         ; COP Watchdog Enable
; bit position masks
mSOPT1_RSTPE:       equ    %00000001
mSOPT1_BKGDPE:      equ    %00000010
mSOPT1_STOPE:       equ    %00100000
mSOPT1_COPT:        equ    %01000000
mSOPT1_COPE:        equ    %10000000


;*** SOPT2 - System Options Register 2; 0x00001803 ***
SOPT2:              equ    $00001803                                ;*** SOPT2 - System Options Register 2; 0x00001803 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SOPT2_ACIC:         equ    0                                         ; Analog Comparator to Input Capture Enable
SOPT2_IICPS:        equ    1                                         ; IIC Pin Select
SOPT2_COPCLKS:      equ    7                                         ; COP Watchdog Clock Select
; bit position masks
mSOPT2_ACIC:        equ    %00000001
mSOPT2_IICPS:       equ    %00000010
mSOPT2_COPCLKS:     equ    %10000000


;*** SDID - System Device Identification Register; 0x00001806 ***
SDID:               equ    $00001806                                ;*** SDID - System Device Identification Register; 0x00001806 ***


;*** SDIDH - System Device Identification Register High; 0x00001806 ***
SDIDH:              equ    $00001806                                ;*** SDIDH - System Device Identification Register High; 0x00001806 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDH_ID8:          equ    0                                         ; Part Identification Number 8
SDIDH_ID9:          equ    1                                         ; Part Identification Number 9
SDIDH_ID10:         equ    2                                         ; Part Identification Number 10
SDIDH_ID11:         equ    3                                         ; Part Identification Number 11
SDIDH_REV0:         equ    4                                         ; Revision Number 0
SDIDH_REV1:         equ    5                                         ; Revision Number 1
SDIDH_REV2:         equ    6                                         ; Revision Number 2
SDIDH_REV3:         equ    7                                         ; Revision Number 3
; bit position masks
mSDIDH_ID8:         equ    %00000001
mSDIDH_ID9:         equ    %00000010
mSDIDH_ID10:        equ    %00000100
mSDIDH_ID11:        equ    %00001000
mSDIDH_REV0:        equ    %00010000
mSDIDH_REV1:        equ    %00100000
mSDIDH_REV2:        equ    %01000000
mSDIDH_REV3:        equ    %10000000


;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
SDIDL:              equ    $00001807                                ;*** SDIDL - System Device Identification Register Low; 0x00001807 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SDIDL_ID0:          equ    0                                         ; Part Identification Number 0
SDIDL_ID1:          equ    1                                         ; Part Identification Number 1
SDIDL_ID2:          equ    2                                         ; Part Identification Number 2
SDIDL_ID3:          equ    3                                         ; Part Identification Number 3
SDIDL_ID4:          equ    4                                         ; Part Identification Number 4
SDIDL_ID5:          equ    5                                         ; Part Identification Number 5
SDIDL_ID6:          equ    6                                         ; Part Identification Number 6
SDIDL_ID7:          equ    7                                         ; Part Identification Number 7
; bit position masks
mSDIDL_ID0:         equ    %00000001
mSDIDL_ID1:         equ    %00000010
mSDIDL_ID2:         equ    %00000100
mSDIDL_ID3:         equ    %00001000
mSDIDL_ID4:         equ    %00010000
mSDIDL_ID5:         equ    %00100000
mSDIDL_ID6:         equ    %01000000
mSDIDL_ID7:         equ    %10000000


;*** SRTISC - System RTI Status and Control Register; 0x00001808 ***
SRTISC:             equ    $00001808                                ;*** SRTISC - System RTI Status and Control Register; 0x00001808 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SRTISC_RTIS0:       equ    0                                         ; Real-Time Interrupt Delay Select Bit 0
SRTISC_RTIS1:       equ    1                                         ; Real-Time Interrupt Delay Select Bit 1
SRTISC_RTIS2:       equ    2                                         ; Real-Time Interrupt Delay Select Bit 2
SRTISC_RTIE:        equ    4                                         ; Real-Time Interrupt Enable
SRTISC_RTICLKS:     equ    5                                         ; Real-Time Interrupt Clock Select
SRTISC_RTIACK:      equ    6                                         ; Real-Time Interrupt Acknowledge
SRTISC_RTIF:        equ    7                                         ; Real-Time Interrupt Flag
; bit position masks
mSRTISC_RTIS0:      equ    %00000001
mSRTISC_RTIS1:      equ    %00000010
mSRTISC_RTIS2:      equ    %00000100
mSRTISC_RTIE:       equ    %00010000
mSRTISC_RTICLKS:    equ    %00100000
mSRTISC_RTIACK:     equ    %01000000
mSRTISC_RTIF:       equ    %10000000


;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001809 ***
SPMSC1:             equ    $00001809                                ;*** SPMSC1 - System Power Management Status and Control 1 Register; 0x00001809 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC1_BGBE:        equ    0                                         ; Bandgap Buffer Enable
SPMSC1_LVDE:        equ    2                                         ; Low-Voltage Detect Enable
SPMSC1_LVDSE:       equ    3                                         ; Low-Voltage Detect Stop Enable
SPMSC1_LVDRE:       equ    4                                         ; Low-Voltage Detect Reset Enable
SPMSC1_LVDIE:       equ    5                                         ; Low-Voltage Detect Interrrupt Enable
SPMSC1_LVDACK:      equ    6                                         ; Low-Voltage Detect Acknowledge
SPMSC1_LVDF:        equ    7                                         ; Low-Voltage Detect Flag
; bit position masks
mSPMSC1_BGBE:       equ    %00000001
mSPMSC1_LVDE:       equ    %00000100
mSPMSC1_LVDSE:      equ    %00001000
mSPMSC1_LVDRE:      equ    %00010000
mSPMSC1_LVDIE:      equ    %00100000
mSPMSC1_LVDACK:     equ    %01000000
mSPMSC1_LVDF:       equ    %10000000


;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x0000180A ***
SPMSC2:             equ    $0000180A                                ;*** SPMSC2 - System Power Management Status and Control 2 Register; 0x0000180A ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC2_PPDC:        equ    0                                         ; Partial Power Down Control
SPMSC2_PDC:         equ    1                                         ; Power Down Control
SPMSC2_PPDACK:      equ    2                                         ; Partial Power Down Acknowlege
SPMSC2_PPDF:        equ    3                                         ; Partial Power Down Flag
SPMSC2_PDF:         equ    4                                         ; Power Down Flag
; bit position masks
mSPMSC2_PPDC:       equ    %00000001
mSPMSC2_PDC:        equ    %00000010
mSPMSC2_PPDACK:     equ    %00000100
mSPMSC2_PPDF:       equ    %00001000
mSPMSC2_PDF:        equ    %00010000


;*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000180C ***
SPMSC3:             equ    $0000180C                                ;*** SPMSC3 - System Power Management Status and Control 3 Register; 0x0000180C ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
SPMSC3_LVWV:        equ    4                                         ; Low-Voltage Warning Voltage Select
SPMSC3_LVDV:        equ    5                                         ; Low-Voltage Detect Voltage Select
SPMSC3_LVWACK:      equ    6                                         ; Low-Voltage Warning Acknowledge
SPMSC3_LVWF:        equ    7                                         ; Low-Voltage Warning Flag
; bit position masks
mSPMSC3_LVWV:       equ    %00010000
mSPMSC3_LVDV:       equ    %00100000
mSPMSC3_LVWACK:     equ    %01000000
mSPMSC3_LVWF:       equ    %10000000


;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
DBGCAH:             equ    $00001810                                ;*** DBGCAH - Debug Comparator A High Register; 0x00001810 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAH_Bit8:        equ    0                                         ; Debug Comparator A Bit 8
DBGCAH_Bit9:        equ    1                                         ; Debug Comparator A Bit 9
DBGCAH_Bit10:       equ    2                                         ; Debug Comparator A Bit 10
DBGCAH_Bit11:       equ    3                                         ; Debug Comparator A Bit 11
DBGCAH_Bit12:       equ    4                                         ; Debug Comparator A Bit 12
DBGCAH_Bit13:       equ    5                                         ; Debug Comparator A Bit 13
DBGCAH_Bit14:       equ    6                                         ; Debug Comparator A Bit 14
DBGCAH_Bit15:       equ    7                                         ; Debug Comparator A Bit 15
; bit position masks
mDBGCAH_Bit8:       equ    %00000001
mDBGCAH_Bit9:       equ    %00000010
mDBGCAH_Bit10:      equ    %00000100
mDBGCAH_Bit11:      equ    %00001000
mDBGCAH_Bit12:      equ    %00010000
mDBGCAH_Bit13:      equ    %00100000
mDBGCAH_Bit14:      equ    %01000000
mDBGCAH_Bit15:      equ    %10000000


;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
DBGCAL:             equ    $00001811                                ;*** DBGCAL - Debug Comparator A Low Register; 0x00001811 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCAL_Bit0:        equ    0                                         ; Debug Comparator A Bit 0
DBGCAL_Bit1:        equ    1                                         ; Debug Comparator A Bit 1
DBGCAL_Bit2:        equ    2                                         ; Debug Comparator A Bit 2
DBGCAL_Bit3:        equ    3                                         ; Debug Comparator A Bit 3
DBGCAL_Bit4:        equ    4                                         ; Debug Comparator A Bit 4
DBGCAL_Bit5:        equ    5                                         ; Debug Comparator A Bit 5
DBGCAL_Bit6:        equ    6                                         ; Debug Comparator A Bit 6
DBGCAL_Bit7:        equ    7                                         ; Debug Comparator A Bit 7
; bit position masks
mDBGCAL_Bit0:       equ    %00000001
mDBGCAL_Bit1:       equ    %00000010
mDBGCAL_Bit2:       equ    %00000100
mDBGCAL_Bit3:       equ    %00001000
mDBGCAL_Bit4:       equ    %00010000
mDBGCAL_Bit5:       equ    %00100000
mDBGCAL_Bit6:       equ    %01000000
mDBGCAL_Bit7:       equ    %10000000


;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
DBGCBH:             equ    $00001812                                ;*** DBGCBH - Debug Comparator B High Register; 0x00001812 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBH_Bit8:        equ    0                                         ; Debug Comparator B Bit 8
DBGCBH_Bit9:        equ    1                                         ; Debug Comparator B Bit 9
DBGCBH_Bit10:       equ    2                                         ; Debug Comparator B Bit 10
DBGCBH_Bit11:       equ    3                                         ; Debug Comparator B Bit 11
DBGCBH_Bit12:       equ    4                                         ; Debug Comparator B Bit 12
DBGCBH_Bit13:       equ    5                                         ; Debug Comparator B Bit 13
DBGCBH_Bit14:       equ    6                                         ; Debug Comparator B Bit 14
DBGCBH_Bit15:       equ    7                                         ; Debug Comparator B Bit 15
; bit position masks
mDBGCBH_Bit8:       equ    %00000001
mDBGCBH_Bit9:       equ    %00000010
mDBGCBH_Bit10:      equ    %00000100
mDBGCBH_Bit11:      equ    %00001000
mDBGCBH_Bit12:      equ    %00010000
mDBGCBH_Bit13:      equ    %00100000
mDBGCBH_Bit14:      equ    %01000000
mDBGCBH_Bit15:      equ    %10000000


;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
DBGCBL:             equ    $00001813                                ;*** DBGCBL - Debug Comparator B Low Register; 0x00001813 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGCBL_Bit0:        equ    0                                         ; Debug Comparator B Bit 0
DBGCBL_Bit1:        equ    1                                         ; Debug Comparator B Bit 1
DBGCBL_Bit2:        equ    2                                         ; Debug Comparator B Bit 2
DBGCBL_Bit3:        equ    3                                         ; Debug Comparator B Bit 3
DBGCBL_Bit4:        equ    4                                         ; Debug Comparator B Bit 4
DBGCBL_Bit5:        equ    5                                         ; Debug Comparator B Bit 5
DBGCBL_Bit6:        equ    6                                         ; Debug Comparator B Bit 6
DBGCBL_Bit7:        equ    7                                         ; Debug Comparator B Bit 7
; bit position masks
mDBGCBL_Bit0:       equ    %00000001
mDBGCBL_Bit1:       equ    %00000010
mDBGCBL_Bit2:       equ    %00000100
mDBGCBL_Bit3:       equ    %00001000
mDBGCBL_Bit4:       equ    %00010000
mDBGCBL_Bit5:       equ    %00100000
mDBGCBL_Bit6:       equ    %01000000
mDBGCBL_Bit7:       equ    %10000000


;*** DBGF - Debug FIFO Register; 0x00001814 ***
DBGF:               equ    $00001814                                ;*** DBGF - Debug FIFO Register; 0x00001814 ***


;*** DBGFH - Debug FIFO High Register; 0x00001814 ***
DBGFH:              equ    $00001814                                ;*** DBGFH - Debug FIFO High Register; 0x00001814 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFH_Bit8:         equ    0                                         ; Debug FIFO Bit 8
DBGFH_Bit9:         equ    1                                         ; Debug FIFO Bit 9
DBGFH_Bit10:        equ    2                                         ; Debug FIFO Bit 10
DBGFH_Bit11:        equ    3                                         ; Debug FIFO Bit 11
DBGFH_Bit12:        equ    4                                         ; Debug FIFO Bit 12
DBGFH_Bit13:        equ    5                                         ; Debug FIFO Bit 13
DBGFH_Bit14:        equ    6                                         ; Debug FIFO Bit 14
DBGFH_Bit15:        equ    7                                         ; Debug FIFO Bit 15
; bit position masks
mDBGFH_Bit8:        equ    %00000001
mDBGFH_Bit9:        equ    %00000010
mDBGFH_Bit10:       equ    %00000100
mDBGFH_Bit11:       equ    %00001000
mDBGFH_Bit12:       equ    %00010000
mDBGFH_Bit13:       equ    %00100000
mDBGFH_Bit14:       equ    %01000000
mDBGFH_Bit15:       equ    %10000000


;*** DBGFL - Debug FIFO Low Register; 0x00001815 ***
DBGFL:              equ    $00001815                                ;*** DBGFL - Debug FIFO Low Register; 0x00001815 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGFL_Bit0:         equ    0                                         ; Debug FIFO Bit 0
DBGFL_Bit1:         equ    1                                         ; Debug FIFO Bit 1
DBGFL_Bit2:         equ    2                                         ; Debug FIFO Bit 2
DBGFL_Bit3:         equ    3                                         ; Debug FIFO Bit 3
DBGFL_Bit4:         equ    4                                         ; Debug FIFO Bit 4
DBGFL_Bit5:         equ    5                                         ; Debug FIFO Bit 5
DBGFL_Bit6:         equ    6                                         ; Debug FIFO Bit 6
DBGFL_Bit7:         equ    7                                         ; Debug FIFO Bit 7
; bit position masks
mDBGFL_Bit0:        equ    %00000001
mDBGFL_Bit1:        equ    %00000010
mDBGFL_Bit2:        equ    %00000100
mDBGFL_Bit3:        equ    %00001000
mDBGFL_Bit4:        equ    %00010000
mDBGFL_Bit5:        equ    %00100000
mDBGFL_Bit6:        equ    %01000000
mDBGFL_Bit7:        equ    %10000000


;*** DBGC - Debug Control Register; 0x00001816 ***
DBGC:               equ    $00001816                                ;*** DBGC - Debug Control Register; 0x00001816 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGC_RWBEN:         equ    0                                         ; Enable R/W for Comparator B
DBGC_RWB:           equ    1                                         ; R/W Comparison Value for Comparator B
DBGC_RWAEN:         equ    2                                         ; Enable R/W for Comparator A
DBGC_RWA:           equ    3                                         ; R/W Comparison Value for Comparator A
DBGC_BRKEN:         equ    4                                         ; Break Enable
DBGC_TAG:           equ    5                                         ; Tag/Force Select
DBGC_ARM:           equ    6                                         ; Arm Control
DBGC_DBGEN:         equ    7                                         ; Debug Module Enable
; bit position masks
mDBGC_RWBEN:        equ    %00000001
mDBGC_RWB:          equ    %00000010
mDBGC_RWAEN:        equ    %00000100
mDBGC_RWA:          equ    %00001000
mDBGC_BRKEN:        equ    %00010000
mDBGC_TAG:          equ    %00100000
mDBGC_ARM:          equ    %01000000
mDBGC_DBGEN:        equ    %10000000


;*** DBGT - Debug Trigger Register; 0x00001817 ***
DBGT:               equ    $00001817                                ;*** DBGT - Debug Trigger Register; 0x00001817 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGT_TRG0:          equ    0                                         ; Select Trigger Mode Bit 0
DBGT_TRG1:          equ    1                                         ; Select Trigger Mode Bit 1
DBGT_TRG2:          equ    2                                         ; Select Trigger Mode Bit 2
DBGT_TRG3:          equ    3                                         ; Select Trigger Mode Bit 3
DBGT_BEGIN:         equ    6                                         ; Begin/End Trigger Select
DBGT_TRGSEL:        equ    7                                         ; Trigger Type
; bit position masks
mDBGT_TRG0:         equ    %00000001
mDBGT_TRG1:         equ    %00000010
mDBGT_TRG2:         equ    %00000100
mDBGT_TRG3:         equ    %00001000
mDBGT_BEGIN:        equ    %01000000
mDBGT_TRGSEL:       equ    %10000000


;*** DBGS - Debug Status Register; 0x00001818 ***
DBGS:               equ    $00001818                                ;*** DBGS - Debug Status Register; 0x00001818 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
DBGS_CNT0:          equ    0                                         ; FIFO Valid Count Bit 0
DBGS_CNT1:          equ    1                                         ; FIFO Valid Count Bit 1
DBGS_CNT2:          equ    2                                         ; FIFO Valid Count Bit 2
DBGS_CNT3:          equ    3                                         ; FIFO Valid Count Bit 3
DBGS_ARMF:          equ    5                                         ; Arm Flag
DBGS_BF:            equ    6                                         ; Trigger Match B Flag
DBGS_AF:            equ    7                                         ; Trigger Match A Flag
; bit position masks
mDBGS_CNT0:         equ    %00000001
mDBGS_CNT1:         equ    %00000010
mDBGS_CNT2:         equ    %00000100
mDBGS_CNT3:         equ    %00001000
mDBGS_ARMF:         equ    %00100000
mDBGS_BF:           equ    %01000000
mDBGS_AF:           equ    %10000000


;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
FCDIV:              equ    $00001820                                ;*** FCDIV - FLASH Clock Divider Register; 0x00001820 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCDIV_DIV0:         equ    0                                         ; Divisor for FLASH Clock Divider Bit 0
FCDIV_DIV1:         equ    1                                         ; Divisor for FLASH Clock Divider Bit 1
FCDIV_DIV2:         equ    2                                         ; Divisor for FLASH Clock Divider Bit 2
FCDIV_DIV3:         equ    3                                         ; Divisor for FLASH Clock Divider Bit 3
FCDIV_DIV4:         equ    4                                         ; Divisor for FLASH Clock Divider Bit 4
FCDIV_DIV5:         equ    5                                         ; Divisor for FLASH Clock Divider Bit 5
FCDIV_PRDIV8:       equ    6                                         ; Prescale (Divide) FLASH Clock by 8
FCDIV_DIVLD:        equ    7                                         ; Divisor Loaded Status Flag
; bit position masks
mFCDIV_DIV0:        equ    %00000001
mFCDIV_DIV1:        equ    %00000010
mFCDIV_DIV2:        equ    %00000100
mFCDIV_DIV3:        equ    %00001000
mFCDIV_DIV4:        equ    %00010000
mFCDIV_DIV5:        equ    %00100000
mFCDIV_PRDIV8:      equ    %01000000
mFCDIV_DIVLD:       equ    %10000000


;*** FOPT - FLASH Options Register; 0x00001821 ***
FOPT:               equ    $00001821                                ;*** FOPT - FLASH Options Register; 0x00001821 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FOPT_SEC00:         equ    0                                         ; Security State Code Bit 0
FOPT_SEC01:         equ    1                                         ; Security State Code Bit 1
FOPT_FNORED:        equ    6                                         ; Vector Redirection Disable
FOPT_KEYEN:         equ    7                                         ; Backdoor Key Mechanism Enable
; bit position masks
mFOPT_SEC00:        equ    %00000001
mFOPT_SEC01:        equ    %00000010
mFOPT_FNORED:       equ    %01000000
mFOPT_KEYEN:        equ    %10000000


;*** FCNFG - FLASH Configuration Register; 0x00001823 ***
FCNFG:              equ    $00001823                                ;*** FCNFG - FLASH Configuration Register; 0x00001823 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCNFG_KEYACC:       equ    5                                         ; Enable Writing of Access Key
; bit position masks
mFCNFG_KEYACC:      equ    %00100000


;*** FPROT - FLASH Protection Register; 0x00001824 ***
FPROT:              equ    $00001824                                ;*** FPROT - FLASH Protection Register; 0x00001824 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FPROT_FPDIS:        equ    0                                         ; FLASH Protection Disable
FPROT_FPS0:         equ    1                                         ; FLASH Protect Select Bits, bit 0
FPROT_FPS1:         equ    2                                         ; FLASH Protect Select Bits, bit 1
FPROT_FPS2:         equ    3                                         ; FLASH Protect Select Bits, bit 2
FPROT_FPS3:         equ    4                                         ; FLASH Protect Select Bits, bit 3
FPROT_FPS4:         equ    5                                         ; FLASH Protect Select Bits, bit 4
FPROT_FPS5:         equ    6                                         ; FLASH Protect Select Bits, bit 5
FPROT_FPS6:         equ    7                                         ; FLASH Protect Select Bits, bit 6
; bit position masks
mFPROT_FPDIS:       equ    %00000001
mFPROT_FPS0:        equ    %00000010
mFPROT_FPS1:        equ    %00000100
mFPROT_FPS2:        equ    %00001000
mFPROT_FPS3:        equ    %00010000
mFPROT_FPS4:        equ    %00100000
mFPROT_FPS5:        equ    %01000000
mFPROT_FPS6:        equ    %10000000


;*** FSTAT - FLASH Status Register; 0x00001825 ***
FSTAT:              equ    $00001825                                ;*** FSTAT - FLASH Status Register; 0x00001825 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FSTAT_FBLANK:       equ    2                                         ; FLASH Verified as All Blank (erased) Flag
FSTAT_FACCERR:      equ    4                                         ; Access Error Flag
FSTAT_FPVIOL:       equ    5                                         ; Protection Violation Flag
FSTAT_FCCF:         equ    6                                         ; FLASH Command Complete Flag
FSTAT_FCBEF:        equ    7                                         ; FLASH Command Buffer Empty Flag
; bit position masks
mFSTAT_FBLANK:      equ    %00000100
mFSTAT_FACCERR:     equ    %00010000
mFSTAT_FPVIOL:      equ    %00100000
mFSTAT_FCCF:        equ    %01000000
mFSTAT_FCBEF:       equ    %10000000


;*** FCMD - FLASH Command Register; 0x00001826 ***
FCMD:               equ    $00001826                                ;*** FCMD - FLASH Command Register; 0x00001826 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
FCMD_FCMD0:         equ    0                                         ; FLASH Command Bit 0
FCMD_FCMD1:         equ    1                                         ; FLASH Command Bit 1
FCMD_FCMD2:         equ    2                                         ; FLASH Command Bit 2
FCMD_FCMD3:         equ    3                                         ; FLASH Command Bit 3
FCMD_FCMD4:         equ    4                                         ; FLASH Command Bit 4
FCMD_FCMD5:         equ    5                                         ; FLASH Command Bit 5
FCMD_FCMD6:         equ    6                                         ; FLASH Command Bit 6
FCMD_FCMD7:         equ    7                                         ; FLASH Command Bit 7
; bit position masks
mFCMD_FCMD0:        equ    %00000001
mFCMD_FCMD1:        equ    %00000010
mFCMD_FCMD2:        equ    %00000100
mFCMD_FCMD3:        equ    %00001000
mFCMD_FCMD4:        equ    %00010000
mFCMD_FCMD5:        equ    %00100000
mFCMD_FCMD6:        equ    %01000000
mFCMD_FCMD7:        equ    %10000000


;*** PTAPE - Port A Internal Pullup Enable; 0x00001840 ***
PTAPE:              equ    $00001840                                ;*** PTAPE - Port A Internal Pullup Enable; 0x00001840 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTAPE_PTAPE0:       equ    0                                         ; Internal Pullup Enable for Port A Bit 0
PTAPE_PTAPE1:       equ    1                                         ; Internal Pullup Enable for Port A Bit 1
PTAPE_PTAPE2:       equ    2                                         ; Internal Pullup Enable for Port A Bit 2
PTAPE_PTAPE3:       equ    3                                         ; Internal Pullup Enable for Port A Bit 3
PTAPE_PTAPE4:       equ    4                                         ; Internal Pullup Enable for Port A Bit 4
PTAPE_PTAPE5:       equ    5                                         ; Internal Pullup Enable for Port A Bit 5
; bit position masks
mPTAPE_PTAPE0:      equ    %00000001
mPTAPE_PTAPE1:      equ    %00000010
mPTAPE_PTAPE2:      equ    %00000100
mPTAPE_PTAPE3:      equ    %00001000
mPTAPE_PTAPE4:      equ    %00010000
mPTAPE_PTAPE5:      equ    %00100000


;*** PTASE - Port A Slew Rate Enable; 0x00001841 ***
PTASE:              equ    $00001841                                ;*** PTASE - Port A Slew Rate Enable; 0x00001841 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTASE_PTASE0:       equ    0                                         ; Output Slew Rate Enable for Port A Bit 0
PTASE_PTASE1:       equ    1                                         ; Output Slew Rate Enable for Port A Bit 1
PTASE_PTASE2:       equ    2                                         ; Output Slew Rate Enable for Port A Bit 2
PTASE_PTASE3:       equ    3                                         ; Output Slew Rate Enable for Port A Bit 3
PTASE_PTASE4:       equ    4                                         ; Output Slew Rate Enable for Port A Bit 4
PTASE_PTASE5:       equ    5                                         ; Output Slew Rate Enable for Port A Bit 5
; bit position masks
mPTASE_PTASE0:      equ    %00000001
mPTASE_PTASE1:      equ    %00000010
mPTASE_PTASE2:      equ    %00000100
mPTASE_PTASE3:      equ    %00001000
mPTASE_PTASE4:      equ    %00010000
mPTASE_PTASE5:      equ    %00100000


;*** PTADS - Port A Drive Strength Select; 0x00001842 ***
PTADS:              equ    $00001842                                ;*** PTADS - Port A Drive Strength Select; 0x00001842 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTADS_PTADS0:       equ    0                                         ; Output Drive Strength Selection for Port A Bit 0
PTADS_PTADS1:       equ    1                                         ; Output Drive Strength Selection for Port A Bit 1
PTADS_PTADS2:       equ    2                                         ; Output Drive Strength Selection for Port A Bit 2
PTADS_PTADS3:       equ    3                                         ; Output Drive Strength Selection for Port A Bit 3
PTADS_PTADS4:       equ    4                                         ; Output Drive Strength Selection for Port A Bit 4
PTADS_PTADS5:       equ    5                                         ; Output Drive Strength Selection for Port A Bit 5
; bit position masks
mPTADS_PTADS0:      equ    %00000001
mPTADS_PTADS1:      equ    %00000010
mPTADS_PTADS2:      equ    %00000100
mPTADS_PTADS3:      equ    %00001000
mPTADS_PTADS4:      equ    %00010000
mPTADS_PTADS5:      equ    %00100000


;*** PTBPE - Port B Internal Pullup Enable; 0x00001844 ***
PTBPE:              equ    $00001844                                ;*** PTBPE - Port B Internal Pullup Enable; 0x00001844 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBPE_PTBPE0:       equ    0                                         ; Internal Pullup Enable for Port B Bit 0
PTBPE_PTBPE1:       equ    1                                         ; Internal Pullup Enable for Port B Bit 1
PTBPE_PTBPE2:       equ    2                                         ; Internal Pullup Enable for Port B Bit 2
PTBPE_PTBPE3:       equ    3                                         ; Internal Pullup Enable for Port B Bit 3
PTBPE_PTBPE4:       equ    4                                         ; Internal Pullup Enable for Port B Bit 4
PTBPE_PTBPE5:       equ    5                                         ; Internal Pullup Enable for Port B Bit 5
PTBPE_PTBPE6:       equ    6                                         ; Internal Pullup Enable for Port B Bit 6
PTBPE_PTBPE7:       equ    7                                         ; Internal Pullup Enable for Port B Bit 7
; bit position masks
mPTBPE_PTBPE0:      equ    %00000001
mPTBPE_PTBPE1:      equ    %00000010
mPTBPE_PTBPE2:      equ    %00000100
mPTBPE_PTBPE3:      equ    %00001000
mPTBPE_PTBPE4:      equ    %00010000
mPTBPE_PTBPE5:      equ    %00100000
mPTBPE_PTBPE6:      equ    %01000000
mPTBPE_PTBPE7:      equ    %10000000


;*** PTBSE - Port B Slew Rate Enable; 0x00001845 ***
PTBSE:              equ    $00001845                                ;*** PTBSE - Port B Slew Rate Enable; 0x00001845 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBSE_PTBSE0:       equ    0                                         ; Output Slew Rate Enable for Port B Bit 0
PTBSE_PTBSE1:       equ    1                                         ; Output Slew Rate Enable for Port B Bit 1
PTBSE_PTBSE2:       equ    2                                         ; Output Slew Rate Enable for Port B Bit 2
PTBSE_PTBSE3:       equ    3                                         ; Output Slew Rate Enable for Port B Bit 3
PTBSE_PTBSE4:       equ    4                                         ; Output Slew Rate Enable for Port B Bit 4
PTBSE_PTBSE5:       equ    5                                         ; Output Slew Rate Enable for Port B Bit 5
PTBSE_PTBSE6:       equ    6                                         ; Output Slew Rate Enable for Port B Bit 6
PTBSE_PTBSE7:       equ    7                                         ; Output Slew Rate Enable for Port B Bit 7
; bit position masks
mPTBSE_PTBSE0:      equ    %00000001
mPTBSE_PTBSE1:      equ    %00000010
mPTBSE_PTBSE2:      equ    %00000100
mPTBSE_PTBSE3:      equ    %00001000
mPTBSE_PTBSE4:      equ    %00010000
mPTBSE_PTBSE5:      equ    %00100000
mPTBSE_PTBSE6:      equ    %01000000
mPTBSE_PTBSE7:      equ    %10000000


;*** PTBDS - Port B Drive Strength Select; 0x00001846 ***
PTBDS:              equ    $00001846                                ;*** PTBDS - Port B Drive Strength Select; 0x00001846 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
PTBDS_PTBDS0:       equ    0                                         ; Output Drive Strength Selection for Port B Bit 0
PTBDS_PTBDS1:       equ    1                                         ; Output Drive Strength Selection for Port B Bit 1
PTBDS_PTBDS2:       equ    2                                         ; Output Drive Strength Selection for Port B Bit 2
PTBDS_PTBDS3:       equ    3                                         ; Output Drive Strength Selection for Port B Bit 3
PTBDS_PTBDS4:       equ    4                                         ; Output Drive Strength Selection for Port B Bit 4
PTBDS_PTBDS5:       equ    5                                         ; Output Drive Strength Selection for Port B Bit 5
PTBDS_PTBDS6:       equ    6                                         ; Output Drive Strength Selection for Port B Bit 6
PTBDS_PTBDS7:       equ    7                                         ; Output Drive Strength Selection for Port B Bit 7
; bit position masks
mPTBDS_PTBDS0:      equ    %00000001
mPTBDS_PTBDS1:      equ    %00000010
mPTBDS_PTBDS2:      equ    %00000100
mPTBDS_PTBDS3:      equ    %00001000
mPTBDS_PTBDS4:      equ    %00010000
mPTBDS_PTBDS5:      equ    %00100000
mPTBDS_PTBDS6:      equ    %01000000
mPTBDS_PTBDS7:      equ    %10000000


;*** NV_FTRIM - Nonvolatile ICS Fine Trim Register; 0x0000FFAE ***
NV_FTRIM:           equ    $0000FFAE                                ;*** NV_FTRIM - Nonvolatile ICS Fine Trim Register; 0x0000FFAE ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NV_FTRIM_FTRIM:     equ    0                                         ; ICS Fine Trim
; bit position masks
mNV_FTRIM_FTRIM:    equ    %00000001


;*** NV_ICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***
NV_ICSTRM:          equ    $0000FFAF                                ;*** NV_ICSTRM - Nonvolatile ICS Trim Register; 0x0000FFAF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NV_ICSTRM_TRIM0:    equ    0                                         ; ICS Trim Setting, bit 0
NV_ICSTRM_TRIM1:    equ    1                                         ; ICS Trim Setting, bit 1
NV_ICSTRM_TRIM2:    equ    2                                         ; ICS Trim Setting, bit 2
NV_ICSTRM_TRIM3:    equ    3                                         ; ICS Trim Setting, bit 3
NV_ICSTRM_TRIM4:    equ    4                                         ; ICS Trim Setting, bit 4
NV_ICSTRM_TRIM5:    equ    5                                         ; ICS Trim Setting, bit 5
NV_ICSTRM_TRIM6:    equ    6                                         ; ICS Trim Setting, bit 6
NV_ICSTRM_TRIM7:    equ    7                                         ; ICS Trim Setting, bit 7
; bit position masks
mNV_ICSTRM_TRIM0:   equ    %00000001
mNV_ICSTRM_TRIM1:   equ    %00000010
mNV_ICSTRM_TRIM2:   equ    %00000100
mNV_ICSTRM_TRIM3:   equ    %00001000
mNV_ICSTRM_TRIM4:   equ    %00010000
mNV_ICSTRM_TRIM5:   equ    %00100000
mNV_ICSTRM_TRIM6:   equ    %01000000
mNV_ICSTRM_TRIM7:   equ    %10000000


;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
NVBACKKEY0:         equ    $0000FFB0                                ;*** NVBACKKEY0 - Backdoor Comparison Key 0; 0x0000FFB0 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY0_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY0_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY0_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY0_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY0_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY0_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY0_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY0_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY0_KEY0:   equ    %00000001
mNVBACKKEY0_KEY1:   equ    %00000010
mNVBACKKEY0_KEY2:   equ    %00000100
mNVBACKKEY0_KEY3:   equ    %00001000
mNVBACKKEY0_KEY4:   equ    %00010000
mNVBACKKEY0_KEY5:   equ    %00100000
mNVBACKKEY0_KEY6:   equ    %01000000
mNVBACKKEY0_KEY7:   equ    %10000000


;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
NVBACKKEY1:         equ    $0000FFB1                                ;*** NVBACKKEY1 - Backdoor Comparison Key 1; 0x0000FFB1 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY1_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY1_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY1_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY1_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY1_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY1_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY1_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY1_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY1_KEY0:   equ    %00000001
mNVBACKKEY1_KEY1:   equ    %00000010
mNVBACKKEY1_KEY2:   equ    %00000100
mNVBACKKEY1_KEY3:   equ    %00001000
mNVBACKKEY1_KEY4:   equ    %00010000
mNVBACKKEY1_KEY5:   equ    %00100000
mNVBACKKEY1_KEY6:   equ    %01000000
mNVBACKKEY1_KEY7:   equ    %10000000


;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
NVBACKKEY2:         equ    $0000FFB2                                ;*** NVBACKKEY2 - Backdoor Comparison Key 2; 0x0000FFB2 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY2_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY2_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY2_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY2_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY2_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY2_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY2_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY2_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY2_KEY0:   equ    %00000001
mNVBACKKEY2_KEY1:   equ    %00000010
mNVBACKKEY2_KEY2:   equ    %00000100
mNVBACKKEY2_KEY3:   equ    %00001000
mNVBACKKEY2_KEY4:   equ    %00010000
mNVBACKKEY2_KEY5:   equ    %00100000
mNVBACKKEY2_KEY6:   equ    %01000000
mNVBACKKEY2_KEY7:   equ    %10000000


;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
NVBACKKEY3:         equ    $0000FFB3                                ;*** NVBACKKEY3 - Backdoor Comparison Key 3; 0x0000FFB3 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY3_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY3_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY3_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY3_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY3_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY3_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY3_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY3_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY3_KEY0:   equ    %00000001
mNVBACKKEY3_KEY1:   equ    %00000010
mNVBACKKEY3_KEY2:   equ    %00000100
mNVBACKKEY3_KEY3:   equ    %00001000
mNVBACKKEY3_KEY4:   equ    %00010000
mNVBACKKEY3_KEY5:   equ    %00100000
mNVBACKKEY3_KEY6:   equ    %01000000
mNVBACKKEY3_KEY7:   equ    %10000000


;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
NVBACKKEY4:         equ    $0000FFB4                                ;*** NVBACKKEY4 - Backdoor Comparison Key 4; 0x0000FFB4 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY4_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY4_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY4_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY4_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY4_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY4_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY4_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY4_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY4_KEY0:   equ    %00000001
mNVBACKKEY4_KEY1:   equ    %00000010
mNVBACKKEY4_KEY2:   equ    %00000100
mNVBACKKEY4_KEY3:   equ    %00001000
mNVBACKKEY4_KEY4:   equ    %00010000
mNVBACKKEY4_KEY5:   equ    %00100000
mNVBACKKEY4_KEY6:   equ    %01000000
mNVBACKKEY4_KEY7:   equ    %10000000


;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
NVBACKKEY5:         equ    $0000FFB5                                ;*** NVBACKKEY5 - Backdoor Comparison Key 5; 0x0000FFB5 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY5_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY5_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY5_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY5_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY5_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY5_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY5_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY5_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY5_KEY0:   equ    %00000001
mNVBACKKEY5_KEY1:   equ    %00000010
mNVBACKKEY5_KEY2:   equ    %00000100
mNVBACKKEY5_KEY3:   equ    %00001000
mNVBACKKEY5_KEY4:   equ    %00010000
mNVBACKKEY5_KEY5:   equ    %00100000
mNVBACKKEY5_KEY6:   equ    %01000000
mNVBACKKEY5_KEY7:   equ    %10000000


;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
NVBACKKEY6:         equ    $0000FFB6                                ;*** NVBACKKEY6 - Backdoor Comparison Key 6; 0x0000FFB6 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY6_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY6_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY6_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY6_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY6_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY6_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY6_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY6_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY6_KEY0:   equ    %00000001
mNVBACKKEY6_KEY1:   equ    %00000010
mNVBACKKEY6_KEY2:   equ    %00000100
mNVBACKKEY6_KEY3:   equ    %00001000
mNVBACKKEY6_KEY4:   equ    %00010000
mNVBACKKEY6_KEY5:   equ    %00100000
mNVBACKKEY6_KEY6:   equ    %01000000
mNVBACKKEY6_KEY7:   equ    %10000000


;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
NVBACKKEY7:         equ    $0000FFB7                                ;*** NVBACKKEY7 - Backdoor Comparison Key 7; 0x0000FFB7 ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVBACKKEY7_KEY0:    equ    0                                         ; Backdoor Comparison Key bits, bit 0
NVBACKKEY7_KEY1:    equ    1                                         ; Backdoor Comparison Key bits, bit 1
NVBACKKEY7_KEY2:    equ    2                                         ; Backdoor Comparison Key bits, bit 2
NVBACKKEY7_KEY3:    equ    3                                         ; Backdoor Comparison Key bits, bit 3
NVBACKKEY7_KEY4:    equ    4                                         ; Backdoor Comparison Key bits, bit 4
NVBACKKEY7_KEY5:    equ    5                                         ; Backdoor Comparison Key bits, bit 5
NVBACKKEY7_KEY6:    equ    6                                         ; Backdoor Comparison Key bits, bit 6
NVBACKKEY7_KEY7:    equ    7                                         ; Backdoor Comparison Key bits, bit 7
; bit position masks
mNVBACKKEY7_KEY0:   equ    %00000001
mNVBACKKEY7_KEY1:   equ    %00000010
mNVBACKKEY7_KEY2:   equ    %00000100
mNVBACKKEY7_KEY3:   equ    %00001000
mNVBACKKEY7_KEY4:   equ    %00010000
mNVBACKKEY7_KEY5:   equ    %00100000
mNVBACKKEY7_KEY6:   equ    %01000000
mNVBACKKEY7_KEY7:   equ    %10000000


;*** NVPROT - Nonvolatile FLASH Protection Register; 0x0000FFBD ***
NVPROT:             equ    $0000FFBD                                ;*** NVPROT - Nonvolatile FLASH Protection Register; 0x0000FFBD ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVPROT_FPDIS:       equ    0                                         ; FLASH Protection Disable
NVPROT_FPS0:        equ    1                                         ; FLASH Protect Select Bits, bit 0
NVPROT_FPS1:        equ    2                                         ; FLASH Protect Select Bits, bit 1
NVPROT_FPS2:        equ    3                                         ; FLASH Protect Select Bits, bit 2
NVPROT_FPS3:        equ    4                                         ; FLASH Protect Select Bits, bit 3
NVPROT_FPS4:        equ    5                                         ; FLASH Protect Select Bits, bit 4
NVPROT_FPS5:        equ    6                                         ; FLASH Protect Select Bits, bit 5
NVPROT_FPS6:        equ    7                                         ; FLASH Protect Select Bits, bit 6
; bit position masks
mNVPROT_FPDIS:      equ    %00000001
mNVPROT_FPS0:       equ    %00000010
mNVPROT_FPS1:       equ    %00000100
mNVPROT_FPS2:       equ    %00001000
mNVPROT_FPS3:       equ    %00010000
mNVPROT_FPS4:       equ    %00100000
mNVPROT_FPS5:       equ    %01000000
mNVPROT_FPS6:       equ    %10000000


;*** NVOPT - Nonvolatile FLASH Options Register; 0x0000FFBF ***
NVOPT:              equ    $0000FFBF                                ;*** NVOPT - Nonvolatile FLASH Options Register; 0x0000FFBF ***
; bit numbers for usage in BCLR, BSET, BRCLR and BRSET
NVOPT_SEC00:        equ    0                                         ; Security State Code Bit 0
NVOPT_SEC01:        equ    1                                         ; Security State Code Bit 1
NVOPT_FNORED:       equ    6                                         ; Vector Redirection Disable
NVOPT_KEYEN:        equ    7                                         ; Backdoor Key Mechanism Enable
; bit position masks
mNVOPT_SEC00:       equ    %00000001
mNVOPT_SEC01:       equ    %00000010
mNVOPT_FNORED:      equ    %01000000
mNVOPT_KEYEN:       equ    %10000000


; EOF
