/******************************************************************************
*                                             COPYRIGHT (c) MOTOROLA 2003   
* FILE NAME: swdecoder.c     REVISION 1.0                                        
*                                                                           
* PURPOSE: Switch Decoder Source File
*                                                                           
*******************************************************************************
*                                                                           
*                                                                           
* DESCRIPTION: Switch Decoder Source File             
*                                                                           
* NOTE: 
*                                                                           
* AUTHOR: Eduardo Montanez    LOCATION: OHT     LAST EDIT DATE: 11/19/03  
*                                                                           
* UPDATE HISTORY                                                            
* REV      	AUTHOR      DATE       	DESCRIPTION OF CHANGE                    
* ---      	------      ---------   ---------------------                    
* 1.0      	r9aabe    	11/19/03	- Original coding 
*                                                                           
******************************************************************************/

#include "swdecoder.h"

/* Local function prototypes */

void switch_decoder (void);

/* Global variables */

char sw1;							// sw1 - switch1 flag
char sw2;							// sw2 - switch2 flag
char password;				// password - instantaneous keystroke
char motor;						// motor - motor status (0 - OFF (default), 1 - ON)									 

//***********************************************************************************
//
// Switch Decoder routine
//
//***********************************************************************************

void switch_decoder (void)
{									
	password = (TFLG1 & 0x0E) >> 1;	//Read TFLG1[7:0], mask TFLG1[3:1], shift right 1
	
	switch(password)
	{
		case 0x01:					    // Switch1 pressed
			sw1 = 1;
			sw2 = 0;				
			break;
			
		case 0x02:					    // Switch2 pressed
		
			if (sw1 == 1)
			{
				sw2 = 1;		      	// Turn on sw2 flag if sw1 occured prior
				
			}
			else
			{
				sw1 = 0; sw2 = 0;		// If sw1 did not occur prior to sw2, clear flags 
			}
			break;
		
		case 0x04:					    // Switch3 pressed
		
			if (sw1 == 1 && sw2 == 1)
			{
				motor = ~motor;		  // Change motor status, if sw1 and sw2 occured prior to sw3
				PWME_PWME0 = motor;
									          // Enable or Disable PWM Ch.0 output 
									          // upon combination
				PTAD_PTAD1 = motor; // Output motor status signal 
				sw1 = sw2 = 0;		  // Combination complete, clear all flags
				
			}
			else
			{
				sw1 = 0; sw2 = 0;		// If sw1 and sw2 did not occur prior to sw3, clear flags
			}
			break;
		
		default:break;
	}
	
	TFLG1 &= password << 1;   // Clear keywakeup flags
	password = 0; 
}