#include <hidef.h>         /* common defines and macros */
#include <mc9s12c32.h>     /* derivative information */

#include "atd.h"			     /* atd initialization routines */
#include "io.h"						 /* io initialization routines */
#include "pwm.h"					 /* pwm initialization routines */
#include "tim.h"					 /* timer initialization routines */

/*If using the HCS12 Serial Monitor to debug this demo, be aware that the default
  bus clock speed is bumped up to 24MHz, affecting the initialized module clocks */


#pragma LINK_INFO DERIVATIVE "mc9s12c32"

void main(void)
{
  sw1 = 0;							    // sw1 - switch1 flag
	sw2 = 0;							    // sw2 - switch2 flag
	password = 0;						  // password - instantaneous keystroke
	motor = 0;							  // motor - motor status (0 - OFF (default), 1 - ON)	
	
	DisableInterrupts;				// Disable interrupts	
	
	(void) io_init  ();				// Initialize general purpose I/O
	(void) pwm_init ();				// Initialize the PWM module
	(void) atd_init ();				// Initialize the ATD module
	(void) tim_init ();				// Initialize the switch detect using TIM module input capture
	
  EnableInterrupts;					// Enable interrupts
   
  for(;;) {} /* wait forever */
}
