/*********************************************************************/
/* Project Name: SPI_Slave.mcp                                       */
/* Source fle name: SPI_Slave.c                                      */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: SPI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The data received by SPI is displayed in Port E      */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

typedef unsigned char UINT8;

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {                                                       
  
  SOPT1 = 0x23;          /* Watchdog disable */  
  SCGC1 = 0x00;          /* Disable Bus clock to unused peripherals */
  SCGC2 = 0x02;          /* Bus Clock to the SPI2 module is enabled */
}

void GPIO_Init(void) { 
  
 PTEDD = 0xFF;          /* Configure PTE port as output */
 PTED = 0x00;           /* Put 0's in PTE port */
}

void SPI_configuration (void) {
 
  SPI2BR = 0x75;        /* Select the highest baud rate prescaler divisor and the highest baud rate divisor */
  SPI2C1 = 0xC2;        /* SPI Interrupt enable, system enable and slave mode selected */ 
  SPI2C2 = 0x10;        /* Different pins for data input and data output */
} 

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */         
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  SPI_configuration();  /* Function that initializes the SPI module */

  EnableInterrupts; /* enable interrupts */
  
  for(;;) { 
  
  _Wait;            /* Wait for an interrupt */

  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    

void interrupt VectorNumber_Vspi2 SPI_ISR(void) {

  UINT8 temp, buffer;

  while (PTDD_PTDD0);
  temp = SPI2S;         /* Clear register flag */
  buffer = SPI2D;				/* Read data register to clear receive flag */
  PTED = buffer;        /* Display the received data in LEDs */
}
