/*********************************************************************/
/* Project Name: SCI.mcp                                             */
/* Source fle name: SCI.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: SCI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The SCI module is configured to work at 9600bps,     */
/* in 8-bit mode and normal operation. When an interrupt is          */
/* generated the received data is display on PTE port and one byte   */
/* is send by SCI                                                    */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x01;          /* Bus Clock to the SCI1 module is enable */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
 PTEDD = 0xFF;          /* Configure PTE port as output */
 PTED = 0x00;           /* Put 0's in PTE port */
}

void SCI_configuration (void) {
  
  SCI1C1 = 0x00;        /* 8-bit mode. Normal operation */
  SCI1C2 = 0x2C;        /* Receiver interrupt enable. Transmitter and receiver enable */
  SCI1C3 = 0x00;        /* Disable all errors interrupts */
  SCI1BDL = 0x1A;       /* This register and the SCI1BDH are used to configure the SCI baud rate */
  SCI1BDH = 0x00;       /*                    BUSCLK               4MHz                */
                        /* Baud rate = -------------------- = ------------ = 9600bps   */
}                       /*               [SBR12:SBR0] x 16        26 x 16              */

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */      
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  SCI_configuration();  /* Function that initializes the SCI module */

  EnableInterrupts; /* enable interrupts */
      
  for(;;) {
  
  } /* loop forever */
  /* please make sure that you never leave this function */
}

void interrupt VectorNumber_Vsci1rx SCI_RX_ISR(void) {

 SCI1S1_RDRF = 0;       /* Receive interrupt disable */
 PTED = SCI1D;          /* Display on PTE the received data from SCI */
 while (SCI1S1_TDRE == 0);  /* Wait for the transmitter to be empty */
 SCI1D = '1';               /* Send a character by SCI */
}